import React from 'react';
import PropTypes from 'prop-types';

const UilPrintSlash = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M7,10a1,1,0,1,0,1,1A1,1,0,0,0,7,10ZM3.71,2.29A1,1,0,0,0,2.29,3.71L4.62,6A3,3,0,0,0,2,9v6a3,3,0,0,0,3,3H6v3a1,1,0,0,0,1,1H17a1,1,0,0,0,1-1V19.41l2.29,2.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM6,15v1H5a1,1,0,0,1-1-1V9A1,1,0,0,1,5,8H6.59l6,6H7A1,1,0,0,0,6,15Zm10,5H8V16h6.59L16,17.41ZM19,6H18V3a1,1,0,0,0-1-1H8.66a1,1,0,0,0,0,2H16V6H12.66a1,1,0,0,0,0,2H19a1,1,0,0,1,1,1v6a.37.37,0,0,1,0,.11,1,1,0,0,0,.78,1.18l.2,0a1,1,0,0,0,1-.8A2.84,2.84,0,0,0,22,15V9A3,3,0,0,0,19,6Z'
  }));
};

UilPrintSlash.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilPrintSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilPrintSlash;