import React from 'react';
import PropTypes from 'prop-types';

const UilPresentationEdit = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M9.41,13h2.42a1,1,0,0,0,.71-.29l3.58-3.58a1,1,0,0,0,0-1.41L13.7,5.32a1,1,0,0,0-1.41,0L8.71,8.9a1,1,0,0,0-.3.7V12A1,1,0,0,0,9.41,13Zm1-3L13,7.44l1,1L11.42,11h-1ZM21,14H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18Z'
  }));
};

UilPresentationEdit.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilPresentationEdit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilPresentationEdit;