import React from 'react';
import PropTypes from 'prop-types';

const UilAmazon = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M1.04,17.52q.1-.16.32-.02a21.3078,21.3078,0,0,0,10.88,2.9,21.52431,21.52431,0,0,0,7.74-1.46q.1-.04.29-.12t.27-.12a.35611.35611,0,0,1,.47.12q.17.24-.11.44-.36.26-.92.6a14.99023,14.99023,0,0,1-3.84,1.58A16.1749,16.1749,0,0,1,12,22a16.01714,16.01714,0,0,1-5.9-1.09,16.24638,16.24638,0,0,1-4.98-3.07.273.273,0,0,1-.12-.2A.215.215,0,0,1,1.04,17.52Zm6.02-5.7a4.03628,4.03628,0,0,1,.68-2.36A4.19676,4.19676,0,0,1,9.6,7.98a10.06288,10.06288,0,0,1,2.66-.66q.54-.06,1.76-.16V6.82a3.56151,3.56151,0,0,0-.28-1.72,1.49917,1.49917,0,0,0-1.32-.6h-.16a2.18852,2.18852,0,0,0-1.14.42,1.63936,1.63936,0,0,0-.62,1,.50779.50779,0,0,1-.4.46L7.8,6.1q-.34-.08-.34-.36a.58734.58734,0,0,1,.02-.14A3.83352,3.83352,0,0,1,9.15,2.96,6.26811,6.26811,0,0,1,12.26,2h.5a5.05441,5.05441,0,0,1,3.56,1.18,3.81,3.81,0,0,1,.37.43,3.8746,3.8746,0,0,1,.27.41,2.09844,2.09844,0,0,1,.18.52q.08.34.12.47a2.85611,2.85611,0,0,1,.06.56q.02.43.02.51v4.84a2.86841,2.86841,0,0,0,.15.95,2.47465,2.47465,0,0,0,.29.62q.14.19.46.61a.59856.59856,0,0,1,.12.32.346.346,0,0,1-.16.28q-1.66,1.44-1.8,1.56a.557.557,0,0,1-.58.04q-.28-.24-.49-.46t-.3-.32a4.46629,4.46629,0,0,1-.29-.39q-.2-.29-.28-.39a4.91083,4.91083,0,0,1-2.2,1.52,6.03757,6.03757,0,0,1-1.68.2,3.50454,3.50454,0,0,1-2.53-.95A3.553,3.553,0,0,1,7.06,11.82Zm3.44-.4a1.89505,1.89505,0,0,0,.39,1.25,1.29375,1.29375,0,0,0,1.05.47,1.022,1.022,0,0,0,.17-.02,1.02168,1.02168,0,0,1,.15-.02,2.03262,2.03262,0,0,0,1.3-1.08,3.13045,3.13045,0,0,0,.33-.83,3.80062,3.80062,0,0,0,.12-.73q.01-.28.01-.92v-.5a7.28689,7.28689,0,0,0-1.76.16A2.1441,2.1441,0,0,0,10.5,11.42Zm8.4,6.44a.62647.62647,0,0,1,.12-.16,3.13921,3.13921,0,0,1,.96-.46,6.52032,6.52032,0,0,1,1.48-.22,1.19457,1.19457,0,0,1,.38.02q.9.08,1.08.3a.65471.65471,0,0,1,.08.36v.14a4.55955,4.55955,0,0,1-.38,1.65,3.84046,3.84046,0,0,1-1.06,1.53.302.302,0,0,1-.18.08.17736.17736,0,0,1-.08-.02q-.12-.06-.06-.22a7.63215,7.63215,0,0,0,.74-2.42.51274.51274,0,0,0-.08-.32q-.2-.24-1.12-.24-.34,0-.8.04-.5.06-.92.12A.23166.23166,0,0,1,18.9,18a.06531.06531,0,0,1-.02-.08A.15332.15332,0,0,1,18.9,17.86Z'
  }));
};

UilAmazon.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilAmazon.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilAmazon;