import { BuildInfo, DataSourceInstanceSettings, FeatureToggles, GrafanaConfig, GrafanaTheme, LicenseInfo, PanelPluginMeta, SystemDateFormatSettings } from '@grafana/data';
export declare class GrafanaBootConfig implements GrafanaConfig {
    datasources: {
        [str: string]: DataSourceInstanceSettings;
    };
    panels: {
        [key: string]: PanelPluginMeta;
    };
    minRefreshInterval: string;
    appUrl: string;
    appSubUrl: string;
    windowTitlePrefix: string;
    buildInfo: BuildInfo;
    newPanelTitle: string;
    bootData: any;
    externalUserMngLinkUrl: string;
    externalUserMngLinkName: string;
    externalUserMngInfo: string;
    allowOrgCreate: boolean;
    disableLoginForm: boolean;
    defaultDatasource: string;
    alertingEnabled: boolean;
    alertingErrorOrTimeout: string;
    alertingNoDataOrNullValues: string;
    alertingMinInterval: number;
    authProxyEnabled: boolean;
    exploreEnabled: boolean;
    ldapEnabled: boolean;
    sigV4AuthEnabled: boolean;
    samlEnabled: boolean;
    autoAssignOrg: boolean;
    verifyEmailEnabled: boolean;
    oauth: any;
    disableUserSignUp: boolean;
    loginHint: any;
    passwordHint: any;
    loginError: any;
    navTree: any;
    viewersCanEdit: boolean;
    editorsCanAdmin: boolean;
    disableSanitizeHtml: boolean;
    theme: GrafanaTheme;
    pluginsToPreload: string[];
    featureToggles: FeatureToggles;
    licenseInfo: LicenseInfo;
    rendererAvailable: boolean;
    http2Enabled: boolean;
    dateFormats?: SystemDateFormatSettings;
    sentry: {
        enabled: boolean;
        dsn: string;
        customEndpoint: string;
        sampleRate: number;
    };
    marketplaceUrl?: string;
    expressionsEnabled: boolean;
    customTheme?: any;
    awsAllowedAuthProviders: string[];
    awsAssumeRoleEnabled: boolean;
    constructor(options: GrafanaBootConfig);
}
/**
 * Use this to access the {@link GrafanaBootConfig} for the current running Grafana instance.
 *
 * @public
 */
export declare const config: GrafanaBootConfig;
