"use strict";

exports.__esModule = true;
exports.default = void 0;

async function toDisplayDialog(page, block) {
  return new Promise(async resolve => {
    const handleDialog = dialog => {
      page.removeListener('dialog', handleDialog);
      resolve(dialog);
    };

    page.on('dialog', handleDialog);
    await block();
  });
}

var _default = toDisplayDialog;
exports.default = _default;