import React from 'react';
import PropTypes from 'prop-types';

const UilClockTen = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M12,6a.99974.99974,0,0,0-1,1v3.26758L9.90234,9.63379a1.00016,1.00016,0,0,0-1,1.73242l2.59766,1.5A1,1,0,0,0,13,12V7A.99974.99974,0,0,0,12,6Zm0-4A10,10,0,1,0,22,12,10.01146,10.01146,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Z'
  }));
};

UilClockTen.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilClockTen.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilClockTen;