import React, { HTMLProps } from 'react';
import { SelectableValue } from '@grafana/data';
import { SegmentProps } from './';
export interface SegmentSyncProps<T> extends SegmentProps<T>, Omit<HTMLProps<HTMLDivElement>, 'value' | 'onChange'> {
    value?: T | SelectableValue<T>;
    onChange: (item: SelectableValue<T>) => void;
    options: Array<SelectableValue<T>>;
}
export declare function Segment<T>({ options, value, onChange, Component, className, allowCustomValue, placeholder, disabled, ...rest }: React.PropsWithChildren<SegmentSyncProps<T>>): JSX.Element;
