'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var Components = {
    DataSource: {
        TestData: {
            QueryTab: {
                scenarioSelectContainer: 'Test Data Query scenario select container',
                scenarioSelect: 'Test Data Query scenario select',
                max: 'TestData max',
                min: 'TestData min',
                noise: 'TestData noise',
                seriesCount: 'TestData series count',
                spread: 'TestData spread',
                startValue: 'TestData start value',
            },
        },
    },
    Panels: {
        Panel: {
            title: function (title) { return "Panel header title item " + title; },
            headerItems: function (item) { return "Panel header item " + item; },
            containerByTitle: function (title) { return "Panel container title " + title; },
            headerCornerInfo: function (mode) { return "Panel header " + mode; },
        },
        Visualization: {
            Graph: {
                VisualizationTab: {
                    legendSection: 'Legend section',
                },
                Legend: {
                    legendItemAlias: function (name) { return "gpl alias " + name; },
                    showLegendSwitch: 'gpl show legend',
                },
                xAxis: {
                    labels: function () { return 'div.flot-x-axis > div.flot-tick-label'; },
                },
            },
            BarGauge: {
                value: 'Bar gauge value',
            },
            Text: {
                container: function () { return '.markdown-html'; },
            },
        },
    },
    Drawer: {
        General: {
            title: function (title) { return "Drawer title " + title; },
            expand: 'Drawer expand',
            contract: 'Drawer contract',
            close: 'Drawer close',
            rcContentWrapper: function () { return '.drawer-content-wrapper'; },
        },
    },
    PanelEditor: {
        General: {
            content: 'Panel editor content',
        },
        OptionsPane: {
            content: 'Panel editor option pane content',
            close: 'Page toolbar button Close options pane',
            open: 'Page toolbar button Open options pane',
            select: 'Panel editor option pane select',
            tab: function (title) { return "Panel editor option pane tab " + title; },
        },
        // not sure about the naming *DataPane*
        DataPane: {
            content: 'Panel editor data pane content',
        },
        FieldOptions: {
            propertyEditor: function (type) { return type + " field property editor"; },
        },
    },
    PanelInspector: {
        Data: {
            content: 'Panel inspector Data content',
        },
        Stats: {
            content: 'Panel inspector Stats content',
        },
        Json: {
            content: 'Panel inspector Json content',
        },
        Query: {
            content: 'Panel inspector Query content',
            refreshButton: 'Panel inspector Query refresh button',
            jsonObjectKeys: function () { return '.json-formatter-key'; },
        },
    },
    Tab: {
        title: function (title) { return "Tab " + title; },
        active: function () { return '[class*="-activeTabStyle"]'; },
    },
    RefreshPicker: {
        runButton: 'RefreshPicker run button',
    },
    QueryTab: {
        content: 'Query editor tab content',
        queryInspectorButton: 'Query inspector button',
        addQuery: 'Query editor add query button',
    },
    QueryEditorRows: {
        rows: 'Query editor row',
    },
    QueryEditorRow: {
        actionButton: function (title) { return title + " query operation action"; },
        title: function (refId) { return "Query editor row title " + refId; },
    },
    AlertTab: {
        content: 'Alert editor tab content',
    },
    Alert: {
        alert: function (severity) { return "Alert " + severity; },
    },
    TransformTab: {
        content: 'Transform editor tab content',
        newTransform: function (name) { return "New transform " + name; },
        transformationEditor: function (name) { return "Transformation editor " + name; },
        transformationEditorDebugger: function (name) { return "Transformation editor debugger " + name; },
    },
    Transforms: {
        card: function (name) { return "New transform " + name; },
        Reduce: {
            modeLabel: 'Transform mode label',
            calculationsLabel: 'Transform calculations label',
        },
        searchInput: 'search transformations',
    },
    PageToolbar: {
        container: function () { return '.page-toolbar'; },
        item: function (tooltip) { return "Page toolbar button " + tooltip; },
    },
    QueryEditorToolbarItem: {
        button: function (title) { return "QueryEditor toolbar item button " + title; },
    },
    BackButton: {
        backArrow: 'Go Back button',
    },
    OptionsGroup: {
        toggle: function (title) { return (title ? "Options group " + title : 'Options group'); },
    },
    PluginVisualization: {
        item: function (title) { return "Plugin visualization item " + title; },
        current: function () { return '[class*="-currentVisualizationItem"]'; },
    },
    Select: {
        option: 'Select option',
        input: function () { return 'input[id*="react-select-"]'; },
        singleValue: function () { return 'div[class*="-singleValue"]'; },
    },
    FieldConfigEditor: {
        content: 'Field config editor content',
    },
    OverridesConfigEditor: {
        content: 'Field overrides editor content',
    },
    FolderPicker: {
        container: 'Folder picker select container',
    },
    DataSourcePicker: {
        container: 'Data source picker select container',
    },
    TimeZonePicker: {
        container: 'Time zone picker select container',
    },
    TraceViewer: {
        spanBar: function () { return '[data-test-id="SpanBar--wrapper"]'; },
    },
    QueryField: { container: 'Query field' },
    ValuePicker: {
        button: 'Value picker add button',
        select: function (name) { return "Value picker select " + name; },
    },
    Search: {
        section: 'Search section',
        items: 'Search items',
    },
    DashboardLinks: {
        container: 'Dashboard link container',
        dropDown: 'Dashboard link dropdown',
        link: 'Dashboard link',
    },
    CallToActionCard: {
        button: function (name) { return "Call to action button " + name; },
    },
    DataLinksContextMenu: {
        singleLink: 'Data link',
    },
};

var Pages = {
    Login: {
        url: '/login',
        username: 'Username input field',
        password: 'Password input field',
        submit: 'Login button',
        skip: 'Skip change password button',
    },
    Home: {
        url: '/',
    },
    DataSource: {
        name: 'Data source settings page name input field',
        delete: 'Data source settings page Delete button',
        saveAndTest: 'Data source settings page Save and Test button',
        alert: 'Data source settings page Alert',
    },
    DataSources: {
        url: '/datasources',
        dataSources: function (dataSourceName) { return "Data source list item " + dataSourceName; },
    },
    AddDataSource: {
        url: '/datasources/new',
        dataSourcePlugins: function (pluginName) { return "Data source plugin item " + pluginName; },
    },
    ConfirmModal: {
        delete: 'Confirm Modal Danger Button',
    },
    AddDashboard: {
        url: '/dashboard/new',
        addNewPanel: 'Add new panel',
    },
    Dashboard: {
        url: function (uid) { return "/d/" + uid; },
        SubMenu: {
            submenuItem: 'Dashboard template variables submenu item',
            submenuItemLabels: function (item) { return "Dashboard template variables submenu Label " + item; },
            submenuItemValueDropDownValueLinkTexts: function (item) {
                return "Dashboard template variables Variable Value DropDown value link text " + item;
            },
            submenuItemValueDropDownDropDown: 'Dashboard template variables Variable Value DropDown DropDown',
            submenuItemValueDropDownOptionTexts: function (item) {
                return "Dashboard template variables Variable Value DropDown option text " + item;
            },
        },
        Settings: {
            General: {
                deleteDashBoard: 'Dashboard settings page delete dashboard button',
                sectionItems: function (item) { return "Dashboard settings section item " + item; },
                saveDashBoard: 'Dashboard settings aside actions Save button',
                saveAsDashBoard: 'Dashboard settings aside actions Save As button',
                timezone: 'Time zone picker select container',
                title: 'Dashboard settings page title',
            },
            Annotations: {
                List: {
                    addAnnotationCTA: Components.CallToActionCard.button('Add Annotation Query'),
                },
            },
            Variables: {
                List: {
                    addVariableCTA: Components.CallToActionCard.button('Add variable'),
                    newButton: 'Variable editor New variable button',
                    table: 'Variable editor Table',
                    tableRowNameFields: function (variableName) { return "Variable editor Table Name field " + variableName; },
                    tableRowDefinitionFields: function (variableName) { return "Variable editor Table Definition field " + variableName; },
                    tableRowArrowUpButtons: function (variableName) { return "Variable editor Table ArrowUp button " + variableName; },
                    tableRowArrowDownButtons: function (variableName) { return "Variable editor Table ArrowDown button " + variableName; },
                    tableRowDuplicateButtons: function (variableName) { return "Variable editor Table Duplicate button " + variableName; },
                    tableRowRemoveButtons: function (variableName) { return "Variable editor Table Remove button " + variableName; },
                },
                Edit: {
                    General: {
                        headerLink: 'Variable editor Header link',
                        modeLabelNew: 'Variable editor Header mode New',
                        modeLabelEdit: 'Variable editor Header mode Edit',
                        generalNameInput: 'Variable editor Form Name field',
                        generalTypeSelect: 'Variable editor Form Type select',
                        generalLabelInput: 'Variable editor Form Label field',
                        generalHideSelect: 'Variable editor Form Hide select',
                        selectionOptionsMultiSwitch: 'Variable editor Form Multi switch',
                        selectionOptionsIncludeAllSwitch: 'Variable editor Form IncludeAll switch',
                        selectionOptionsCustomAllInput: 'Variable editor Form IncludeAll field',
                        previewOfValuesOption: 'Variable editor Preview of Values option',
                        submitButton: 'Variable editor Submit button',
                    },
                    QueryVariable: {
                        queryOptionsDataSourceSelect: Components.DataSourcePicker.container,
                        queryOptionsRefreshSelect: 'Variable editor Form Query Refresh select',
                        queryOptionsRegExInput: 'Variable editor Form Query RegEx field',
                        queryOptionsSortSelect: 'Variable editor Form Query Sort select',
                        queryOptionsQueryInput: 'Variable editor Form Default Variable Query Editor textarea',
                        valueGroupsTagsEnabledSwitch: 'Variable editor Form Query UseTags switch',
                        valueGroupsTagsTagsQueryInput: 'Variable editor Form Query TagsQuery field',
                        valueGroupsTagsTagsValuesQueryInput: 'Variable editor Form Query TagsValuesQuery field',
                    },
                    ConstantVariable: {
                        constantOptionsQueryInput: 'Variable editor Form Constant Query field',
                    },
                    TextBoxVariable: {
                        textBoxOptionsQueryInput: 'Variable editor Form TextBox Query field',
                    },
                },
            },
        },
    },
    Dashboards: {
        url: '/dashboards',
        dashboards: function (title) { return "Dashboard search item " + title; },
    },
    SaveDashboardAsModal: {
        newName: 'Save dashboard title field',
        save: 'Save dashboard button',
    },
    SaveDashboardModal: {
        save: 'Dashboard settings Save Dashboard Modal Save button',
        saveVariables: 'Dashboard settings Save Dashboard Modal Save variables checkbox',
        saveTimerange: 'Dashboard settings Save Dashboard Modal Save timerange checkbox',
    },
    SharePanelModal: {
        linkToRenderedImage: 'Link to rendered image',
    },
    Explore: {
        url: '/explore',
        General: {
            container: 'Explore',
            graph: 'Explore Graph',
            table: 'Explore Table',
            scrollBar: function () { return '.scrollbar-view'; },
        },
        Toolbar: {
            navBar: function () { return '.explore-toolbar'; },
        },
    },
    SoloPanel: {
        url: function (page) { return "/d-solo/" + page; },
    },
    PluginsList: {
        page: 'Plugins list page',
        list: 'Plugins list',
        listItem: 'Plugins list item',
        signatureErrorNotice: 'Unsigned plugins notice',
    },
    PluginPage: {
        page: 'Plugin page',
        signatureInfo: 'Plugin signature info',
    },
};

var selectors = {
    pages: Pages,
    components: Components,
};

exports.selectors = selectors;
//# sourceMappingURL=index.development.js.map
