; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"


declare void @use(ptr)
declare void @use.i1(i1)
declare void @llvm.assume(i1)
declare i1 @cond()

define void @test_monotonic_ptr_iv_inc_1_eq_to_uge(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_eq_to_uge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_eq_to_uge_incoming_values_reordered(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_eq_to_uge_incoming_values_reordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ [[START]], [[LOOP_PH]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %loop.ph ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_eq_to_uge_no_preheader(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_eq_to_uge_no_preheader(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[ENTRY:%.*]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %entry ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_different_element_types(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_different_element_types(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i8, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i8, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_different_element_types_2(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_different_element_types_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i8, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i8, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_gep_step_size_i8_unknown_end_ptr(ptr %start, ptr %end) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_gep_step_size_i8_unknown_end_ptr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_ULT_END:%.*]] = icmp uge ptr [[START:%.*]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[START_ULT_END]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[END]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[END]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i8, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %start.ult.end = icmp uge ptr %start, %end
  br i1 %start.ult.end, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %end
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %end
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i8, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_gep_step_size_i32_unknown_end_ptr(ptr %start, ptr %end) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_gep_step_size_i32_unknown_end_ptr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_ULT_END:%.*]] = icmp uge ptr [[START:%.*]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[START_ULT_END]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[END]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[END]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %start.ult.end = icmp uge ptr %start, %end
  br i1 %start.ult.end, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %end
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %end
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_ptr_iv_upper_may_be_less_than_start(ptr %start, i16 %len) {
; CHECK-LABEL: @test_ptr_iv_upper_may_be_less_than_start(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[ENTRY:%.*]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_1]], [[C_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %entry ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = icmp uge ptr %ptr.iv, %start
  %c.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %c.1, %c.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_no_ptr_iv_step_inst_doesnt_use_phi(ptr %start, ptr %p, i16 %len) {
; CHECK-LABEL: @test_no_ptr_iv_step_inst_doesnt_use_phi(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[P:%.*]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %p, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_no_ptr_iv_step_inst_doesnt_use_phi_2(ptr %start, ptr %end, i16 %len) {
; CHECK-LABEL: @test_no_ptr_iv_step_inst_doesnt_use_phi_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds float, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[PTR_IV_2:%.*]] = phi ptr [ [[END:%.*]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT]], [[LOOP_LATCH]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[LOOP_NEXT:%.*]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds float, ptr [[PTR_IV_2]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds float, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %ptr.iv.2 = phi ptr [ %end, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %loop.next

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds float, ptr %ptr.iv.2, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_no_ptr_iv_different_start(ptr %start, ptr %p, i16 %len) {
; CHECK-LABEL: @test_no_ptr_iv_different_start(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[P:%.*]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_1]], [[C_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %p, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = icmp uge ptr %ptr.iv, %start
  %c.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %c.1, %c.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_ptr_iv_not_inbounds(ptr %start, i16 %len) {
; CHECK-LABEL: @test_ptr_iv_not_inbounds(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_1]], [[C_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = icmp uge ptr %ptr.iv, %start
  %c.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %c.1, %c.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_var_step_not_monotonic(ptr %start, i16 %len, i16 %step) {
; CHECK-LABEL: @test_var_step_not_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_1]], [[C_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 [[STEP:%.*]]
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = icmp uge ptr %ptr.iv, %start
  %c.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %c.1, %c.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 %step
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_step_neg_1(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_step_neg_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_1]], [[C_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 -1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = icmp uge ptr %ptr.iv, %start
  %c.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %c.1, %c.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 -1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_step_sign_unknown(ptr %start, i16 %len, i16 %step) {
; CHECK-LABEL: @test_monotonic_ptr_iv_step_sign_unknown(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_1]], [[C_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 [[STEP:%.*]]
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = icmp uge ptr %ptr.iv, %start
  %c.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %c.1, %c.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 %step
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_step_sign_positive_through_assume(ptr %start, i16 %len, i16 %step) {
; CHECK-LABEL: @test_monotonic_ptr_iv_step_sign_positive_through_assume(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[STEP_POS:%.*]] = icmp sge i16 [[STEP:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[STEP_POS]])
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 [[STEP]]
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %step.pos = icmp sge i16 %step, 0
  call void @llvm.assume(i1 %step.pos)
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 %step
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_step_sign_negative_through_assume(ptr %start, i16 %len, i16 %step) {
; CHECK-LABEL: @test_monotonic_ptr_iv_step_sign_negative_through_assume(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[STEP_POS:%.*]] = icmp sle i16 [[STEP:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[STEP_POS]])
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_1]], [[C_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 [[STEP]]
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %step.pos = icmp sle i16 %step, 0
  call void @llvm.assume(i1 %step.pos)
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = icmp uge ptr %ptr.iv, %start
  %c.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %c.1, %c.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 %step
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_2(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 2
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_step_2_cond_controls_single_exit(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_step_2_cond_controls_single_exit(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C_1:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C_1]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    call void @use.i1(i1 [[AND]])
; CHECK-NEXT:    br label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c.1 = icmp eq ptr %ptr.iv, %upper
  br i1 %c.1, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  call void @use.i1(i1 %and)
  br label %loop.latch

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 2
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_loop_exits_on_ne(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_loop_exits_on_ne(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp sge i16 [[LEN]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[LEN_NEG]])
; CHECK-NEXT:    br label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp ne ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT:%.*]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    br label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    [[C_2:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[C_3:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[C_2]], [[C_3]]
; CHECK-NEXT:    call void @use.i1(i1 [[AND]])
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp sge i16 %len, 0
  call void @llvm.assume(i1 %len.neg)
  br label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp ne ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  br label %loop.latch

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  %c.2 = icmp uge ptr %ptr.iv, %start
  %c.3 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %c.2, %c.3
  call void @use.i1(i1 %and)
  ret void
}
