"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
const toHaveSelectorCount = async function (page, selector, expectedValue, options = {}) {
    try {
        await page.waitForSelector(selector, { state: "attached", ...options });
        /* istanbul ignore next */
        const actualCount = await page.$$eval(selector, (el) => el.length);
        return {
            pass: actualCount === expectedValue,
            message: () => utils_1.getMessage(this, "toHaveSelectorCount", expectedValue, actualCount),
        };
    }
    catch (err) {
        return {
            pass: false,
            message: () => `${utils_1.quote(selector)} could not be found on the page.`,
        };
    }
};
exports.default = toHaveSelectorCount;
