// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX11 %s

v_bfrev_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_bfrev_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_bfrev_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_bfrev_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_ceil_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ceil_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ceil_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_ceil_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_ceil_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xdc,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_ceil_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ceil_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ceil_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_ceil_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_ceil_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa2,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cls_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cls_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cls_i32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cls_i32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cls_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_clz_i32_u32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_clz_i32_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_cos_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cos_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cos_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cos_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cos_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xe1,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cos_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cos_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cos_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cos_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cos_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xb6,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ctz_i32_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ctz_i32_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_cvt_f16_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x8a,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cvt_f16_i16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_i16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_i16_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0xd1,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f16_u16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_u16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_u16_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0xd0,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x8b,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cvt_f32_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_i32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_i32_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x85,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_u32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_u32_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x86,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte0_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte0_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte0_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x91,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte1_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte1_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte1_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x92,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte2_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte2_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte2_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x93,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte3_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte3_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte3_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x94,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_floor_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0x8d,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_flr_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_flr_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0x8d,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_i16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i16_f16_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd3,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i32_f32_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x88,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_i32_i16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i32_i16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i32_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_nearest_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0x8c,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_norm_i16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_norm_i16_f16_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0xe3,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_norm_u16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_norm_u16_f16_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0xe4,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_off_f32_i4_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_off_f32_i4_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_off_f32_i4_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x8e,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_rpi_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0x8c,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_u16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u16_f16_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd2,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_u32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u32_f32_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x87,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_u32_u16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u32_u16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u32_u16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_exp_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_exp_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_exp_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_exp_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_exp_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd8,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_exp_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_exp_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_exp_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_exp_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_exp_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_ffbh_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ffbh_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ffbh_i32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ffbh_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_ffbh_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ffbh_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ffbh_u32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ffbh_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_ffbl_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ffbl_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ffbl_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ffbl_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_floor_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_floor_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_floor_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_floor_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_floor_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xdb,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_floor_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_floor_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_floor_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_floor_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_floor_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa4,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_fract_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_fract_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_fract_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_fract_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_fract_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xdf,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_fract_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_fract_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_fract_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_fract_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_fract_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_frexp_exp_i16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_frexp_exp_i16_f16_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0xda,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_frexp_exp_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_frexp_exp_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0xbf,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_frexp_mant_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_frexp_mant_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_frexp_mant_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd9,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_frexp_mant_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_frexp_mant_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_frexp_mant_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xc0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_log_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_log_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_log_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_log_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_log_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_log_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd7,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_log_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_log_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_log_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_log_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_log_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_log_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa7,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_mov_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_mov_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_mov_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_mov_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_mov_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_movreld_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_movreld_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_movreld_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_movreld_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_movreld_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_movreld_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_movreld_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_movreld_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_movreld_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_movreld_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_movreld_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_movreld_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_movreld_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_movreld_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xc2,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_movrels_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_movrels_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_movrels_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_movrels_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_movrels_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_movrelsd_2_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_movrelsd_2_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_movrelsd_2_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_movrelsd_2_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xc8,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_movrelsd_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_movrelsd_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_movrelsd_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_movrelsd_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_movrelsd_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xc4,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_not_b16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_not_b16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_not_b16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_not_b16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_not_b16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_not_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_not_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_not_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_not_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_not_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_rcp_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rcp_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd4,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rcp_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rcp_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xaa,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rcp_iflag_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_iflag_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_iflag_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xab,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rndne_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rndne_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rndne_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rndne_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rndne_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xde,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rndne_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rndne_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rndne_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rndne_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rndne_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa3,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rsq_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rsq_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rsq_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rsq_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rsq_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd6,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rsq_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rsq_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rsq_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rsq_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rsq_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xae,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sat_pk_u8_i16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_sat_pk_u8_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_sin_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sin_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sin_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sin_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sin_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xe0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sin_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sin_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sin_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sin_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sin_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xb5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sqrt_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sqrt_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sqrt_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sqrt_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sqrt_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sqrt_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sqrt_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sqrt_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xb3,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_trunc_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_trunc_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_trunc_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_trunc_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_trunc_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xdd,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_trunc_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_trunc_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_trunc_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_trunc_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_trunc_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa1,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]
