; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s

declare <32 x half> @llvm.experimental.constrained.fadd.v32f16(<32 x half>, <32 x half>, metadata, metadata)
declare <32 x half> @llvm.experimental.constrained.fsub.v32f16(<32 x half>, <32 x half>, metadata, metadata)
declare <32 x half> @llvm.experimental.constrained.fmul.v32f16(<32 x half>, <32 x half>, metadata, metadata)
declare <32 x half> @llvm.experimental.constrained.fdiv.v32f16(<32 x half>, <32 x half>, metadata, metadata)
declare <32 x half> @llvm.experimental.constrained.sqrt.v32f16(<32 x half>, metadata, metadata)
declare <8 x double> @llvm.experimental.constrained.fpext.v8f64.v8f16(<8 x half>, metadata)
declare <16 x float> @llvm.experimental.constrained.fpext.v16f32.v16f16(<16 x half>, metadata)
declare <8 x half> @llvm.experimental.constrained.fptrunc.v8f16.v8f64(<8 x double>, metadata, metadata)
declare <16 x half> @llvm.experimental.constrained.fptrunc.v16f16.v16f32(<16 x float>, metadata, metadata)
declare <32 x half> @llvm.experimental.constrained.fma.v32f16(<32 x half>, <32 x half>, <32 x half>, metadata, metadata)
declare <32 x half> @llvm.experimental.constrained.ceil.v32f16(<32 x half>, metadata)
declare <32 x half> @llvm.experimental.constrained.floor.v32f16(<32 x half>, metadata)
declare <32 x half> @llvm.experimental.constrained.trunc.v32f16(<32 x half>, metadata)
declare <32 x half> @llvm.experimental.constrained.rint.v32f16(<32 x half>, metadata, metadata)
declare <32 x half> @llvm.experimental.constrained.nearbyint.v32f16(<32 x half>, metadata, metadata)

define <32 x half> @f2(<32 x half> %a, <32 x half> %b) #0 {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaddph %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x half> @llvm.experimental.constrained.fadd.v32f16(<32 x half> %a, <32 x half> %b,
                                                                     metadata !"round.dynamic",
                                                                     metadata !"fpexcept.strict") #0
  ret <32 x half> %ret
}

define <32 x half> @f4(<32 x half> %a, <32 x half> %b) #0 {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsubph %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x half> @llvm.experimental.constrained.fsub.v32f16(<32 x half> %a, <32 x half> %b,
                                                                     metadata !"round.dynamic",
                                                                     metadata !"fpexcept.strict") #0
  ret <32 x half> %ret
}

define <32 x half> @f6(<32 x half> %a, <32 x half> %b) #0 {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmulph %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x half> @llvm.experimental.constrained.fmul.v32f16(<32 x half> %a, <32 x half> %b,
                                                                     metadata !"round.dynamic",
                                                                     metadata !"fpexcept.strict") #0
  ret <32 x half> %ret
}

define <32 x half> @f8(<32 x half> %a, <32 x half> %b) #0 {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdivph %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x half> @llvm.experimental.constrained.fdiv.v32f16(<32 x half> %a, <32 x half> %b,
                                                                     metadata !"round.dynamic",
                                                                     metadata !"fpexcept.strict") #0
  ret <32 x half> %ret
}

define <32 x half> @f10(<32 x half> %a) #0 {
; CHECK-LABEL: f10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsqrtph %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <32 x half> @llvm.experimental.constrained.sqrt.v32f16(
                              <32 x half> %a,
                              metadata !"round.dynamic",
                              metadata !"fpexcept.strict") #0
  ret <32 x half > %ret
}

define <8 x double> @f11(<8 x half> %a) #0 {
; CHECK-LABEL: f11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2pd %xmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x double> @llvm.experimental.constrained.fpext.v8f64.v8f16(
                                <8 x half> %a,
                                metadata !"fpexcept.strict") #0
  ret <8 x double> %ret
}

define <8 x half> @f12(<8 x double> %a) #0 {
; CHECK-LABEL: f12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtpd2ph %zmm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x half> @llvm.experimental.constrained.fptrunc.v8f16.v8f64(
                                <8 x double> %a,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #0
  ret <8 x half> %ret
}

define <32 x half> @f13(<32 x half> %a, <32 x half> %b, <32 x half> %c) #0 {
; CHECK-LABEL: f13:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ph %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = call <32 x half> @llvm.experimental.constrained.fma.v32f16(<32 x half> %a, <32 x half> %b, <32 x half> %c,
                                                                    metadata !"round.dynamic",
                                                                    metadata !"fpexcept.strict") #0
  ret <32 x half> %res
}

define <16 x float> @f14(<16 x half> %a) #0 {
; CHECK-LABEL: f14:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2psx %ymm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x float> @llvm.experimental.constrained.fpext.v16f32.v16f16(
                                <16 x half> %a,
                                metadata !"fpexcept.strict") #0
  ret <16 x float> %ret
}

define <16 x half> @f15(<16 x float> %a) #0 {
; CHECK-LABEL: f15:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2phx %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x half> @llvm.experimental.constrained.fptrunc.v16f16.v16f32(
                                <16 x float> %a,
                                metadata !"round.dynamic",
                                metadata !"fpexcept.strict") #0
  ret <16 x half> %ret
}

define <32 x half> @strict_vector_fceil_v32f16(<32 x half> %f) #0 {
; CHECK-LABEL: strict_vector_fceil_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrndscaleph $10, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = call <32 x half> @llvm.experimental.constrained.ceil.v32f16(<32 x half> %f, metadata !"fpexcept.strict") #0
  ret <32 x half> %res
}

define <32 x half> @strict_vector_ffloor_v32f16(<32 x half> %f) #0 {
; CHECK-LABEL: strict_vector_ffloor_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrndscaleph $9, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = call <32 x half> @llvm.experimental.constrained.floor.v32f16(<32 x half> %f, metadata !"fpexcept.strict") #0
  ret <32 x half> %res
}

define <32 x half> @strict_vector_ftrunc_v32f16(<32 x half> %f) #0 {
; CHECK-LABEL: strict_vector_ftrunc_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrndscaleph $11, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = call <32 x half> @llvm.experimental.constrained.trunc.v32f16(<32 x half> %f, metadata !"fpexcept.strict") #0
  ret <32 x half> %res
}

define <32 x half> @strict_vector_frint_v32f16(<32 x half> %f) #0 {
; CHECK-LABEL: strict_vector_frint_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrndscaleph $4, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = call <32 x half> @llvm.experimental.constrained.rint.v32f16(<32 x half> %f,
                             metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret <32 x half> %res
}

define <32 x half> @strict_vector_fnearbyint_v32f16(<32 x half> %f) #0 {
; CHECK-LABEL: strict_vector_fnearbyint_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrndscaleph $12, %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %res = call <32 x half> @llvm.experimental.constrained.nearbyint.v32f16(<32 x half> %f,
                             metadata !"round.dynamic", metadata !"fpexcept.strict") #0
  ret <32 x half> %res
}

attributes #0 = { strictfp }
