; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=mips -mattr=+msa,+fp64,+mips32r2 -relocation-model=pic < %s \
; RUN:      | FileCheck %s -check-prefixes=MSA,MSA32
; RUN: llc -march=mips64 -mattr=+msa,+fp64 -relocation-model=pic -target-abi n32 < %s \
; RUN:      | FileCheck %s -check-prefix=MSA64N32
; RUN: llc -march=mips64 -mattr=+msa,+fp64 -relocation-model=pic -target-abi n64 < %s \
; RUN:      | FileCheck %s -check-prefixes=MSA,MSA64N64

; Test that the immediate intrinsics don't crash LLVM.

; Some of the intrinsics lower to equivalent forms.

define void @addvi_b(ptr %ptr) {
; MSA-LABEL: addvi_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    addvi.b $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: addvi_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    addvi.b $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.addvi.b(<16 x i8> %a, i32 25)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @andi_b(ptr %ptr) {
; MSA-LABEL: andi_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    andi.b $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: andi_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    andi.b $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.andi.b(<16 x i8> %a, i32 25)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @bclri_b(ptr %ptr) {
; MSA-LABEL: bclri_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    andi.b $w0, $w0, 247
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: bclri_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    andi.b $w0, $w0, 247
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.bclri.b(<16 x i8> %a, i32 3)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @binsli_b(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: binsli_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($5)
; MSA-NEXT:    ld.b $w1, 0($4)
; MSA-NEXT:    binsli.b $w1, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w1, 0($4)
;
; MSA64N32-LABEL: binsli_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    ld.b $w0, 0($2)
; MSA64N32-NEXT:    ld.b $w1, 0($1)
; MSA64N32-NEXT:    binsli.b $w1, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w1, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %b = load <16 x i8>, ptr %ptr2, align 16
  %r = call <16 x i8> @llvm.mips.binsli.b(<16 x i8> %a, <16 x i8> %b, i32 3)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @binsri_b(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: binsri_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($5)
; MSA-NEXT:    ld.b $w1, 0($4)
; MSA-NEXT:    binsri.b $w1, $w0, 5
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w1, 0($4)
;
; MSA64N32-LABEL: binsri_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    ld.b $w0, 0($2)
; MSA64N32-NEXT:    ld.b $w1, 0($1)
; MSA64N32-NEXT:    binsri.b $w1, $w0, 5
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w1, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %b = load <16 x i8>, ptr %ptr2, align 16
  %r = call <16 x i8> @llvm.mips.binsri.b(<16 x i8> %a, <16 x i8> %b, i32 5)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @bmnzi_b(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: bmnzi_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($5)
; MSA-NEXT:    ld.b $w1, 0($4)
; MSA-NEXT:    bmnzi.b $w1, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w1, 0($4)
;
; MSA64N32-LABEL: bmnzi_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    ld.b $w0, 0($2)
; MSA64N32-NEXT:    ld.b $w1, 0($1)
; MSA64N32-NEXT:    bmnzi.b $w1, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w1, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %b = load <16 x i8>, ptr %ptr2, align 16
  %r = call <16 x i8> @llvm.mips.bmnzi.b(<16 x i8> %a, <16 x i8> %b, i32 25)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @bmzi_b(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: bmzi_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    ld.b $w1, 0($5)
; MSA-NEXT:    bmnzi.b $w1, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w1, 0($4)
;
; MSA64N32-LABEL: bmzi_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $5, 0
; MSA64N32-NEXT:    sll $2, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($2)
; MSA64N32-NEXT:    ld.b $w1, 0($1)
; MSA64N32-NEXT:    bmnzi.b $w1, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w1, 0($2)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %b = load <16 x i8>, ptr %ptr2, align 16
  %r = call <16 x i8> @llvm.mips.bmzi.b(<16 x i8> %a, <16 x i8> %b, i32 25)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @bnegi_b(ptr %ptr) {
; MSA-LABEL: bnegi_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    bnegi.b $w0, $w0, 6
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: bnegi_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    bnegi.b $w0, $w0, 6
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.bnegi.b(<16 x i8> %a, i32 6)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @bseli_b(ptr %ptr) {
; MSA-LABEL: bseli_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    bseli.b $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: bseli_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    bseli.b $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.bseli.b(<16 x i8> %a, <16 x i8> %a, i32 25)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @bseti_b(ptr %ptr) {
; MSA-LABEL: bseti_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    bseti.b $w0, $w0, 5
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: bseti_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    bseti.b $w0, $w0, 5
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.bseti.b(<16 x i8> %a, i32 5)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @clei_s_b(ptr %ptr) {
; MSA-LABEL: clei_s_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    clei_s.b $w0, $w0, 12
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: clei_s_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    clei_s.b $w0, $w0, 12
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.clei.s.b(<16 x i8> %a, i32 12)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @clei_u_b(ptr %ptr) {
; MSA-LABEL: clei_u_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    clei_u.b $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: clei_u_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    clei_u.b $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.clei.u.b(<16 x i8> %a, i32 25)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @clti_s_b(ptr %ptr) {
; MSA-LABEL: clti_s_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    clti_s.b $w0, $w0, 15
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: clti_s_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    clti_s.b $w0, $w0, 15
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.clti.s.b(<16 x i8> %a, i32 15)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @clti_u_b(ptr %ptr) {
; MSA-LABEL: clti_u_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    clti_u.b $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: clti_u_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    clti_u.b $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.clti.u.b(<16 x i8> %a, i32 25)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @ldi_b(ptr %ptr) {
; MSA-LABEL: ldi_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ldi.b $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: ldi_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ldi.b $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %r = call <16 x i8> @llvm.mips.ldi.b(i32 3)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @maxi_s_b(ptr %ptr) {
; MSA-LABEL: maxi_s_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    maxi_s.b $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: maxi_s_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    maxi_s.b $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.maxi.s.b(<16 x i8> %a, i32 2)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @maxi_u_b(ptr %ptr) {
; MSA-LABEL: maxi_u_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    maxi_u.b $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: maxi_u_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    maxi_u.b $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.maxi.u.b(<16 x i8> %a, i32 2)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @mini_s_b(ptr %ptr) {
; MSA-LABEL: mini_s_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    mini_s.b $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: mini_s_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    mini_s.b $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.mini.s.b(<16 x i8> %a, i32 2)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @mini_u_b(ptr %ptr) {
; MSA-LABEL: mini_u_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    mini_u.b $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: mini_u_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    mini_u.b $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.mini.u.b(<16 x i8> %a, i32 2)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @nori_b(ptr %ptr) {
; MSA-LABEL: nori_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    nori.b $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: nori_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    nori.b $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.nori.b(<16 x i8> %a, i32 25)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @ori_b(ptr %ptr) {
; MSA-LABEL: ori_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    ori.b $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: ori_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    ori.b $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.ori.b(<16 x i8> %a, i32 25)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @sldi_b(ptr %ptr) {
; MSA-LABEL: sldi_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    sldi.b $w0, $w0[7]
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: sldi_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    sldi.b $w0, $w0[7]
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.sldi.b(<16 x i8> %a, <16 x i8> %a, i32 7)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @slli_b(ptr %ptr) {
; MSA-LABEL: slli_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    slli.b $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: slli_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    slli.b $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.slli.b(<16 x i8> %a, i32 3)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @splati_b(ptr %ptr) {
; MSA-LABEL: splati_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    splati.b $w0, $w0[3]
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: splati_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    splati.b $w0, $w0[3]
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.splati.b(<16 x i8> %a, i32 3)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @srai_b(ptr %ptr) {
; MSA-LABEL: srai_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    srai.b $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: srai_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    srai.b $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.srai.b(<16 x i8> %a, i32 3)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @srari_b(ptr %ptr) {
; MSA-LABEL: srari_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    srari.b $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: srari_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    srari.b $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.srari.b(<16 x i8> %a, i32 3)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @srli_b(ptr %ptr) {
; MSA-LABEL: srli_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    srli.b $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: srli_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    srli.b $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.srli.b(<16 x i8> %a, i32 3)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @srlri_b(ptr %ptr) {
; MSA-LABEL: srlri_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    srlri.b $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.b $w0, 0($4)
;
; MSA64N32-LABEL: srlri_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    srlri.b $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.b $w0, 0($1)
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call <16 x i8> @llvm.mips.srlri.b(<16 x i8> %a, i32 3)
  store <16 x i8> %r, ptr %ptr, align 16
  ret void
}

define void @addvi_w(ptr %ptr) {
; MSA-LABEL: addvi_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    addvi.w $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: addvi_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    addvi.w $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.addvi.w(<4 x i32> %a, i32 25)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @bclri_w(ptr %ptr) {
; MSA-LABEL: bclri_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    bclri.w $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: bclri_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    bclri.w $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.bclri.w(<4 x i32> %a, i32 25)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @binsli_w(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: binsli_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($5)
; MSA-NEXT:    ld.w $w1, 0($4)
; MSA-NEXT:    binsli.w $w1, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w1, 0($4)
;
; MSA64N32-LABEL: binsli_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    ld.w $w0, 0($2)
; MSA64N32-NEXT:    ld.w $w1, 0($1)
; MSA64N32-NEXT:    binsli.w $w1, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w1, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %b = load <4 x i32>, ptr %ptr2, align 16
  %r = call <4 x i32> @llvm.mips.binsli.w(<4 x i32> %a, <4 x i32> %b, i32 25)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @binsri_w(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: binsri_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($5)
; MSA-NEXT:    ld.w $w1, 0($4)
; MSA-NEXT:    binsri.w $w1, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w1, 0($4)
;
; MSA64N32-LABEL: binsri_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    ld.w $w0, 0($2)
; MSA64N32-NEXT:    ld.w $w1, 0($1)
; MSA64N32-NEXT:    binsri.w $w1, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w1, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %b = load <4 x i32>, ptr %ptr2, align 16
  %r = call <4 x i32> @llvm.mips.binsri.w(<4 x i32> %a, <4 x i32> %b, i32 25)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @bnegi_w(ptr %ptr) {
; MSA-LABEL: bnegi_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    bnegi.w $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: bnegi_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    bnegi.w $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.bnegi.w(<4 x i32> %a, i32 25)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @bseti_w(ptr %ptr) {
; MSA-LABEL: bseti_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    bseti.w $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: bseti_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    bseti.w $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.bseti.w(<4 x i32> %a, i32 25)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @clei_s_w(ptr %ptr) {
; MSA-LABEL: clei_s_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    clei_s.w $w0, $w0, 14
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: clei_s_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    clei_s.w $w0, $w0, 14
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.clei.s.w(<4 x i32> %a, i32 14)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @clei_u_w(ptr %ptr) {
; MSA-LABEL: clei_u_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    clei_u.w $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: clei_u_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    clei_u.w $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.clei.u.w(<4 x i32> %a, i32 25)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @clti_s_w(ptr %ptr) {
; MSA-LABEL: clti_s_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    clti_s.w $w0, $w0, 15
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: clti_s_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    clti_s.w $w0, $w0, 15
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.clti.s.w(<4 x i32> %a, i32 15)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @clti_u_w(ptr %ptr) {
; MSA-LABEL: clti_u_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    clti_u.w $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: clti_u_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    clti_u.w $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.clti.u.w(<4 x i32> %a, i32 25)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @maxi_s_w(ptr %ptr) {
; MSA-LABEL: maxi_s_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    maxi_s.w $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: maxi_s_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    maxi_s.w $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.maxi.s.w(<4 x i32> %a, i32 2)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @maxi_u_w(ptr %ptr) {
; MSA-LABEL: maxi_u_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    maxi_u.w $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: maxi_u_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    maxi_u.w $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.maxi.u.w(<4 x i32> %a, i32 2)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @mini_s_w(ptr %ptr) {
; MSA-LABEL: mini_s_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    mini_s.w $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: mini_s_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    mini_s.w $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.mini.s.w(<4 x i32> %a, i32 2)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @mini_u_w(ptr %ptr) {
; MSA-LABEL: mini_u_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    mini_u.w $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: mini_u_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    mini_u.w $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.mini.u.w(<4 x i32> %a, i32 2)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @ldi_w(ptr %ptr) {
; MSA-LABEL: ldi_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ldi.w $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: ldi_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ldi.w $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %r = call <4 x i32> @llvm.mips.ldi.w(i32 3)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @sldi_w(ptr %ptr) {
; MSA-LABEL: sldi_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    sldi.w $w0, $w0[2]
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: sldi_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    sldi.w $w0, $w0[2]
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.sldi.w(<4 x i32> %a, <4 x i32> %a, i32 2)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @slli_w(ptr %ptr) {
; MSA-LABEL: slli_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    slli.w $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: slli_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    slli.w $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.slli.w(<4 x i32> %a, i32 3)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @splati_w(ptr %ptr) {
; MSA-LABEL: splati_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    splati.w $w0, $w0[3]
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: splati_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    splati.w $w0, $w0[3]
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.splati.w(<4 x i32> %a, i32 3)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @srai_w(ptr %ptr) {
; MSA-LABEL: srai_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    srai.w $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: srai_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    srai.w $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.srai.w(<4 x i32> %a, i32 3)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @srari_w(ptr %ptr) {
; MSA-LABEL: srari_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    srari.w $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: srari_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    srari.w $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.srari.w(<4 x i32> %a, i32 3)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @srli_w(ptr %ptr) {
; MSA-LABEL: srli_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    srli.w $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: srli_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    srli.w $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.srli.w(<4 x i32> %a, i32 3)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @srlri_w(ptr %ptr) {
; MSA-LABEL: srlri_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    srlri.w $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: srlri_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    srlri.w $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.w $w0, 0($1)
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call <4 x i32> @llvm.mips.srlri.w(<4 x i32> %a, i32 3)
  store <4 x i32> %r, ptr %ptr, align 16
  ret void
}

define void @addvi_h(ptr %ptr) {
; MSA-LABEL: addvi_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    addvi.h $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: addvi_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    addvi.h $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.addvi.h(<8 x i16> %a, i32 25)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @bclri_h(ptr %ptr) {
; MSA-LABEL: bclri_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    bclri.h $w0, $w0, 8
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: bclri_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    bclri.h $w0, $w0, 8
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.bclri.h(<8 x i16> %a, i32 8)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @binsli_h(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: binsli_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($5)
; MSA-NEXT:    ld.h $w1, 0($4)
; MSA-NEXT:    binsli.h $w1, $w0, 8
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w1, 0($4)
;
; MSA64N32-LABEL: binsli_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    ld.h $w0, 0($2)
; MSA64N32-NEXT:    ld.h $w1, 0($1)
; MSA64N32-NEXT:    binsli.h $w1, $w0, 8
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w1, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %b = load <8 x i16>, ptr %ptr2, align 16
  %r = call <8 x i16> @llvm.mips.binsli.h(<8 x i16> %a, <8 x i16> %b, i32 8)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @binsri_h(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: binsri_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($5)
; MSA-NEXT:    ld.h $w1, 0($4)
; MSA-NEXT:    binsri.h $w1, $w0, 14
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w1, 0($4)
;
; MSA64N32-LABEL: binsri_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    ld.h $w0, 0($2)
; MSA64N32-NEXT:    ld.h $w1, 0($1)
; MSA64N32-NEXT:    binsri.h $w1, $w0, 14
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w1, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %b = load <8 x i16>, ptr %ptr2, align 16
  %r = call <8 x i16> @llvm.mips.binsri.h(<8 x i16> %a, <8 x i16> %b, i32 14)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @bnegi_h(ptr %ptr) {
; MSA-LABEL: bnegi_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    bnegi.h $w0, $w0, 14
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: bnegi_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    bnegi.h $w0, $w0, 14
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.bnegi.h(<8 x i16> %a, i32 14)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @bseti_h(ptr %ptr) {
; MSA-LABEL: bseti_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    bseti.h $w0, $w0, 15
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: bseti_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    bseti.h $w0, $w0, 15
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.bseti.h(<8 x i16> %a, i32 15)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @clei_s_h(ptr %ptr) {
; MSA-LABEL: clei_s_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    clei_s.h $w0, $w0, 13
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: clei_s_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    clei_s.h $w0, $w0, 13
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.clei.s.h(<8 x i16> %a, i32 13)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @clei_u_h(ptr %ptr) {
; MSA-LABEL: clei_u_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    clei_u.h $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: clei_u_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    clei_u.h $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.clei.u.h(<8 x i16> %a, i32 25)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @clti_s_h(ptr %ptr) {
; MSA-LABEL: clti_s_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    clti_s.h $w0, $w0, 15
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: clti_s_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    clti_s.h $w0, $w0, 15
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.clti.s.h(<8 x i16> %a, i32 15)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @clti_u_h(ptr %ptr) {
; MSA-LABEL: clti_u_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    clti_u.h $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: clti_u_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    clti_u.h $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.clti.u.h(<8 x i16> %a, i32 25)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @maxi_s_h(ptr %ptr) {
; MSA-LABEL: maxi_s_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    maxi_s.h $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: maxi_s_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    maxi_s.h $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.maxi.s.h(<8 x i16> %a, i32 2)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @maxi_u_h(ptr %ptr) {
; MSA-LABEL: maxi_u_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    maxi_u.h $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: maxi_u_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    maxi_u.h $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.maxi.u.h(<8 x i16> %a, i32 2)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @mini_s_h(ptr %ptr) {
; MSA-LABEL: mini_s_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    mini_s.h $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: mini_s_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    mini_s.h $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.mini.s.h(<8 x i16> %a, i32 2)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @mini_u_h(ptr %ptr) {
; MSA-LABEL: mini_u_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    mini_u.h $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: mini_u_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    mini_u.h $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.mini.u.h(<8 x i16> %a, i32 2)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @ldi_h(ptr %ptr) {
; MSA-LABEL: ldi_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ldi.h $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: ldi_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ldi.h $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %r = call <8 x i16> @llvm.mips.ldi.h(i32 3)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @sldi_h(ptr %ptr) {
; MSA-LABEL: sldi_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    sldi.h $w0, $w0[3]
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: sldi_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    sldi.h $w0, $w0[3]
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.sldi.h(<8 x i16> %a, <8 x i16> %a, i32 3)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @slli_h(ptr %ptr) {
; MSA-LABEL: slli_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    slli.h $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: slli_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    slli.h $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.slli.h(<8 x i16> %a, i32 3)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @splati_h(ptr %ptr) {
; MSA-LABEL: splati_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    splati.h $w0, $w0[3]
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: splati_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    splati.h $w0, $w0[3]
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.splati.h(<8 x i16> %a, i32 3)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @srai_h(ptr %ptr) {
; MSA-LABEL: srai_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    srai.h $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: srai_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    srai.h $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.srai.h(<8 x i16> %a, i32 3)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @srari_h(ptr %ptr) {
; MSA-LABEL: srari_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    srari.h $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: srari_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    srari.h $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.srari.h(<8 x i16> %a, i32 3)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @srli_h(ptr %ptr) {
; MSA-LABEL: srli_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    srli.h $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: srli_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    srli.h $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.srli.h(<8 x i16> %a, i32 3)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define void @srlri_h(ptr %ptr) {
; MSA-LABEL: srlri_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    srlri.h $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.h $w0, 0($4)
;
; MSA64N32-LABEL: srlri_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    srlri.h $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.h $w0, 0($1)
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call <8 x i16> @llvm.mips.srlri.h(<8 x i16> %a, i32 3)
  store <8 x i16> %r, ptr %ptr, align 16
  ret void
}

define i32 @copy_s_b(ptr %ptr) {
; MSA-LABEL: copy_s_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    jr $ra
; MSA-NEXT:    copy_s.b $2, $w0[1]
;
; MSA64N32-LABEL: copy_s_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    copy_s.b $2, $w0[1]
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call i32 @llvm.mips.copy.s.b(<16 x i8> %a, i32 1)
  ret i32 %r
}
define i32 @copy_s_h(ptr %ptr) {
; MSA-LABEL: copy_s_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    jr $ra
; MSA-NEXT:    copy_s.h $2, $w0[1]
;
; MSA64N32-LABEL: copy_s_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    copy_s.h $2, $w0[1]
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call i32 @llvm.mips.copy.s.h(<8 x i16> %a, i32 1)
  ret i32 %r
}
define i32 @copy_s_w(ptr %ptr) {
; MSA-LABEL: copy_s_w:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.w $w0, 0($4)
; MSA-NEXT:    jr $ra
; MSA-NEXT:    copy_s.w $2, $w0[1]
;
; MSA64N32-LABEL: copy_s_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    copy_s.w $2, $w0[1]
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call i32 @llvm.mips.copy.s.w(<4 x i32> %a, i32 1)
  ret i32 %r
}
define i32 @copy_u_b(ptr %ptr) {
; MSA-LABEL: copy_u_b:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.b $w0, 0($4)
; MSA-NEXT:    jr $ra
; MSA-NEXT:    copy_u.b $2, $w0[1]
;
; MSA64N32-LABEL: copy_u_b:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.b $w0, 0($1)
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    copy_u.b $2, $w0[1]
entry:
  %a = load <16 x i8>, ptr %ptr, align 16
  %r = call i32 @llvm.mips.copy.u.b(<16 x i8> %a, i32 1)
  ret i32 %r
}
define i32 @copy_u_h(ptr %ptr) {
; MSA-LABEL: copy_u_h:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.h $w0, 0($4)
; MSA-NEXT:    jr $ra
; MSA-NEXT:    copy_u.h $2, $w0[1]
;
; MSA64N32-LABEL: copy_u_h:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.h $w0, 0($1)
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    copy_u.h $2, $w0[1]
entry:
  %a = load <8 x i16>, ptr %ptr, align 16
  %r = call i32 @llvm.mips.copy.u.h(<8 x i16> %a, i32 1)
  ret i32 %r
}
define i32 @copy_u_w(ptr %ptr) {
; MSA32-LABEL: copy_u_w:
; MSA32:       # %bb.0: # %entry
; MSA32-NEXT:    ld.w $w0, 0($4)
; MSA32-NEXT:    jr $ra
; MSA32-NEXT:    copy_s.w $2, $w0[1]
;
; MSA64N32-LABEL: copy_u_w:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.w $w0, 0($1)
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    copy_u.w $2, $w0[1]
;
; MSA64N64-LABEL: copy_u_w:
; MSA64N64:       # %bb.0: # %entry
; MSA64N64-NEXT:    ld.w $w0, 0($4)
; MSA64N64-NEXT:    jr $ra
; MSA64N64-NEXT:    copy_u.w $2, $w0[1]
entry:
  %a = load <4 x i32>, ptr %ptr, align 16
  %r = call i32 @llvm.mips.copy.u.w(<4 x i32> %a, i32 1)
  ret i32 %r
}

define i64 @copy_s_d(ptr %ptr) {
; MSA32-LABEL: copy_s_d:
; MSA32:       # %bb.0: # %entry
; MSA32-NEXT:    ld.w $w0, 0($4)
; MSA32-NEXT:    copy_s.w $2, $w0[2]
; MSA32-NEXT:    jr $ra
; MSA32-NEXT:    copy_s.w $3, $w0[3]
;
; MSA64N32-LABEL: copy_s_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    copy_s.d $2, $w0[1]
;
; MSA64N64-LABEL: copy_s_d:
; MSA64N64:       # %bb.0: # %entry
; MSA64N64-NEXT:    ld.d $w0, 0($4)
; MSA64N64-NEXT:    jr $ra
; MSA64N64-NEXT:    copy_s.d $2, $w0[1]
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call i64 @llvm.mips.copy.s.d(<2 x i64> %a, i32 1)
  ret i64 %r
}

define i64 @copy_u_d(ptr %ptr) {
; MSA32-LABEL: copy_u_d:
; MSA32:       # %bb.0: # %entry
; MSA32-NEXT:    ld.w $w0, 0($4)
; MSA32-NEXT:    copy_s.w $2, $w0[2]
; MSA32-NEXT:    jr $ra
; MSA32-NEXT:    copy_s.w $3, $w0[3]
;
; MSA64N32-LABEL: copy_u_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    copy_s.d $2, $w0[1]
;
; MSA64N64-LABEL: copy_u_d:
; MSA64N64:       # %bb.0: # %entry
; MSA64N64-NEXT:    ld.d $w0, 0($4)
; MSA64N64-NEXT:    jr $ra
; MSA64N64-NEXT:    copy_s.d $2, $w0[1]
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call i64 @llvm.mips.copy.u.d(<2 x i64> %a, i32 1)
  ret i64 %r
}

define void @addvi_d(ptr %ptr) {
; MSA-LABEL: addvi_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    addvi.d $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: addvi_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    addvi.d $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.addvi.d(<2 x i64> %a, i32 25)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @bclri_d(ptr %ptr) {
; MSA-LABEL: bclri_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    bclri.d $w0, $w0, 16
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: bclri_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    bclri.d $w0, $w0, 16
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.bclri.d(<2 x i64> %a, i32 16)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @binsli_d(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: binsli_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($5)
; MSA-NEXT:    ld.d $w1, 0($4)
; MSA-NEXT:    binsli.d $w1, $w0, 4
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w1, 0($4)
;
; MSA64N32-LABEL: binsli_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    ld.d $w0, 0($2)
; MSA64N32-NEXT:    ld.d $w1, 0($1)
; MSA64N32-NEXT:    binsli.d $w1, $w0, 4
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w1, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %b = load <2 x i64>, ptr %ptr2, align 16
  %r = call <2 x i64> @llvm.mips.binsli.d(<2 x i64> %a, <2 x i64> %b, i32 4)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @binsri_d(ptr %ptr, ptr %ptr2) {
; MSA-LABEL: binsri_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($5)
; MSA-NEXT:    ld.d $w1, 0($4)
; MSA-NEXT:    binsri.d $w1, $w0, 5
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w1, 0($4)
;
; MSA64N32-LABEL: binsri_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    ld.d $w0, 0($2)
; MSA64N32-NEXT:    ld.d $w1, 0($1)
; MSA64N32-NEXT:    binsri.d $w1, $w0, 5
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w1, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %b = load <2 x i64>, ptr %ptr2, align 16
  %r = call <2 x i64> @llvm.mips.binsri.d(<2 x i64> %a, <2 x i64> %b, i32 5)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @bnegi_d(ptr %ptr) {
; MSA-LABEL: bnegi_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    bnegi.d $w0, $w0, 9
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: bnegi_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    bnegi.d $w0, $w0, 9
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.bnegi.d(<2 x i64> %a, i32 9)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @bseti_d(ptr %ptr) {
; MSA-LABEL: bseti_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    bseti.d $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: bseti_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    bseti.d $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.bseti.d(<2 x i64> %a, i32 25)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @clei_s_d(ptr %ptr) {
; MSA-LABEL: clei_s_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    clei_s.d $w0, $w0, 15
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: clei_s_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    clei_s.d $w0, $w0, 15
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.clei.s.d(<2 x i64> %a, i32 15)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @clei_u_d(ptr %ptr) {
; MSA-LABEL: clei_u_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    clei_u.d $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: clei_u_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    clei_u.d $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.clei.u.d(<2 x i64> %a, i32 25)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @clti_s_d(ptr %ptr) {
; MSA-LABEL: clti_s_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    clti_s.d $w0, $w0, 15
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: clti_s_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    clti_s.d $w0, $w0, 15
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.clti.s.d(<2 x i64> %a, i32 15)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @clti_u_d(ptr %ptr) {
; MSA-LABEL: clti_u_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    clti_u.d $w0, $w0, 25
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: clti_u_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    clti_u.d $w0, $w0, 25
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.clti.u.d(<2 x i64> %a, i32 25)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @ldi_d(ptr %ptr) {
; MSA32-LABEL: ldi_d:
; MSA32:       # %bb.0: # %entry
; MSA32-NEXT:    ldi.d $w0, 3
; MSA32-NEXT:    jr $ra
; MSA32-NEXT:    st.w $w0, 0($4)
;
; MSA64N32-LABEL: ldi_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ldi.d $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
;
; MSA64N64-LABEL: ldi_d:
; MSA64N64:       # %bb.0: # %entry
; MSA64N64-NEXT:    ldi.d $w0, 3
; MSA64N64-NEXT:    jr $ra
; MSA64N64-NEXT:    st.d $w0, 0($4)
entry:
  %r = call <2 x i64> @llvm.mips.ldi.d(i32 3)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @maxi_s_d(ptr %ptr) {
; MSA-LABEL: maxi_s_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    maxi_s.d $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: maxi_s_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    maxi_s.d $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.maxi.s.d(<2 x i64> %a, i32 2)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @maxi_u_d(ptr %ptr) {
; MSA-LABEL: maxi_u_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    maxi_u.d $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: maxi_u_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    maxi_u.d $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.maxi.u.d(<2 x i64> %a, i32 2)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @mini_s_d(ptr %ptr) {
; MSA-LABEL: mini_s_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    mini_s.d $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: mini_s_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    mini_s.d $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.mini.s.d(<2 x i64> %a, i32 2)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @mini_u_d(ptr %ptr) {
; MSA-LABEL: mini_u_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    mini_u.d $w0, $w0, 2
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: mini_u_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    mini_u.d $w0, $w0, 2
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.mini.u.d(<2 x i64> %a, i32 2)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @sldi_d(ptr %ptr) {
; MSA-LABEL: sldi_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    sldi.d $w0, $w0[1]
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: sldi_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    sldi.d $w0, $w0[1]
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.sldi.d(<2 x i64> %a, <2 x i64> %a, i32 1)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @slli_d(ptr %ptr) {
; MSA-LABEL: slli_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    slli.d $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: slli_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    slli.d $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.slli.d(<2 x i64> %a, i32 3)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @srai_d(ptr %ptr) {
; MSA-LABEL: srai_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    srai.d $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: srai_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    srai.d $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.srai.d(<2 x i64> %a, i32 3)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @srari_d(ptr %ptr) {
; MSA-LABEL: srari_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    srari.d $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: srari_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    srari.d $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.srari.d(<2 x i64> %a, i32 3)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @srli_d(ptr %ptr) {
; MSA-LABEL: srli_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    srli.d $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: srli_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    srli.d $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.srli.d(<2 x i64> %a, i32 3)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @srlri_d(ptr %ptr) {
; MSA-LABEL: srlri_d:
; MSA:       # %bb.0: # %entry
; MSA-NEXT:    ld.d $w0, 0($4)
; MSA-NEXT:    srlri.d $w0, $w0, 3
; MSA-NEXT:    jr $ra
; MSA-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: srlri_d:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    ld.d $w0, 0($1)
; MSA64N32-NEXT:    srlri.d $w0, $w0, 3
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
entry:
  %a = load <2 x i64>, ptr %ptr, align 16
  %r = call <2 x i64> @llvm.mips.srlri.d(<2 x i64> %a, i32 3)
  store <2 x i64> %r, ptr %ptr, align 16
  ret void
}

define void @ld_d2(ptr %ptr, ptr %ldptr) {
; MSA32-LABEL: ld_d2:
; MSA32:       # %bb.0: # %entry
; MSA32-NEXT:    addiu $1, $5, 4096
; MSA32-NEXT:    ld.d $w0, 0($1)
; MSA32-NEXT:    jr $ra
; MSA32-NEXT:    st.d $w0, 0($4)
;
; MSA64N32-LABEL: ld_d2:
; MSA64N32:       # %bb.0: # %entry
; MSA64N32-NEXT:    sll $1, $4, 0
; MSA64N32-NEXT:    sll $2, $5, 0
; MSA64N32-NEXT:    addiu $2, $2, 4096
; MSA64N32-NEXT:    ld.d $w0, 0($2)
; MSA64N32-NEXT:    jr $ra
; MSA64N32-NEXT:    st.d $w0, 0($1)
;
; MSA64N64-LABEL: ld_d2:
; MSA64N64:       # %bb.0: # %entry
; MSA64N64-NEXT:    daddiu $1, $5, 4096
; MSA64N64-NEXT:    ld.d $w0, 0($1)
; MSA64N64-NEXT:    jr $ra
; MSA64N64-NEXT:    st.d $w0, 0($4)
entry:
  %a = call <2 x i64> @llvm.mips.ld.d(ptr %ldptr, i32 4096)
  store <2 x i64> %a, ptr %ptr, align 16
  ret void
}

declare <8 x i16> @llvm.mips.ldi.h(i32)
declare <8 x i16> @llvm.mips.addvi.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.bclri.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.binsli.h(<8 x i16>, <8 x i16>, i32)
declare <8 x i16> @llvm.mips.binsri.h(<8 x i16>, <8 x i16>, i32)
declare <8 x i16> @llvm.mips.bnegi.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.bseti.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.clei.s.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.clei.u.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.clti.s.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.clti.u.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.maxi.s.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.maxi.u.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.mini.s.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.mini.u.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.sldi.h(<8 x i16>, <8 x i16>, i32)
declare <8 x i16> @llvm.mips.slli.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.splati.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.srai.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.srari.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.srli.h(<8 x i16>, i32)
declare <8 x i16> @llvm.mips.srlri.h(<8 x i16>, i32)
declare <4 x i32> @llvm.mips.addvi.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.bclri.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.binsli.w(<4 x i32>, <4 x i32>, i32)
declare <4 x i32> @llvm.mips.binsri.w(<4 x i32>, <4 x i32>, i32)
declare <4 x i32> @llvm.mips.bnegi.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.bseti.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.ldi.w(i32)
declare <4 x i32> @llvm.mips.clei.s.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.clei.u.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.clti.s.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.clti.u.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.maxi.s.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.maxi.u.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.mini.s.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.mini.u.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.sldi.w(<4 x i32>, <4 x i32>, i32)
declare <4 x i32> @llvm.mips.slli.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.splati.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.srai.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.srari.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.srli.w(<4 x i32>, i32)
declare <4 x i32> @llvm.mips.srlri.w(<4 x i32>, i32)
declare <2 x i64> @llvm.mips.ldi.d(i32)
declare <2 x i64> @llvm.mips.addvi.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.bclri.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.binsli.d(<2 x i64>, <2 x i64>, i32)
declare <2 x i64> @llvm.mips.binsri.d(<2 x i64>, <2 x i64>, i32)
declare <2 x i64> @llvm.mips.bnegi.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.bseti.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.clei.s.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.clei.u.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.clti.s.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.clti.u.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.maxi.s.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.maxi.u.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.mini.s.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.mini.u.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.sldi.d(<2 x i64>, <2 x i64>, i32)
declare <2 x i64> @llvm.mips.slli.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.splati.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.srai.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.srari.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.srli.d(<2 x i64>, i32)
declare <2 x i64> @llvm.mips.srlri.d(<2 x i64>, i32)
declare <16 x i8> @llvm.mips.ldi.b(i32)
declare <16 x i8> @llvm.mips.addvi.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.andi.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.bclri.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.binsli.b(<16 x i8>, <16 x i8>, i32)
declare <16 x i8> @llvm.mips.binsri.b(<16 x i8>, <16 x i8>, i32)
declare <16 x i8> @llvm.mips.bmnzi.b(<16 x i8>, <16 x i8>, i32)
declare <16 x i8> @llvm.mips.bnegi.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.bseli.b(<16 x i8>, <16 x i8>, i32)
declare <16 x i8> @llvm.mips.bseti.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.clei.s.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.clei.u.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.clti.s.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.clti.u.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.maxi.s.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.maxi.u.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.mini.s.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.mini.u.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.nori.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.ori.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.sldi.b(<16 x i8>, <16 x i8>, i32)
declare <16 x i8> @llvm.mips.slli.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.splati.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.srai.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.srari.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.srli.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.srlri.b(<16 x i8>, i32)
declare i32 @llvm.mips.copy.s.h(<8 x i16>, i32)
declare i32 @llvm.mips.copy.u.h(<8 x i16>, i32)
declare i32 @llvm.mips.copy.s.w(<4 x i32>, i32)
declare i32 @llvm.mips.copy.u.w(<4 x i32>, i32)
declare i64 @llvm.mips.copy.s.d(<2 x i64>, i32)
declare i64 @llvm.mips.copy.u.d(<2 x i64>, i32)
declare i32 @llvm.mips.copy.s.b(<16 x i8>, i32)
declare i32 @llvm.mips.copy.u.b(<16 x i8>, i32)
declare <16 x i8> @llvm.mips.bmzi.b(<16 x i8>, <16 x i8>, i32)
declare <16 x i8> @llvm.mips.ld.b(ptr, i32)
declare <8 x i16> @llvm.mips.ld.h(ptr, i32)
declare <4 x i32> @llvm.mips.ld.w(ptr, i32)
declare <2 x i64> @llvm.mips.ld.d(ptr, i32)
declare void @llvm.mips.st.b(<16 x i8>, ptr, i32)
declare void @llvm.mips.st.h(<8 x i16>, ptr, i32)
declare void @llvm.mips.st.w(<4 x i32>, ptr, i32)
declare void @llvm.mips.st.d(<2 x i64>, ptr, i32)
