; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx1100 -mattr="+wavefrontsize64" -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX11 %s
; RUN: llc -march=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,VI %s
; RUN: llc -march=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX9 %s

; RUN: llc -global-isel -march=amdgcn -mcpu=gfx1100 -mattr="+wavefrontsize64" -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX11,GISEL-GFX11 %s
; RUN: llc -global-isel -march=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,VI,GISEL-VI %s
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX9,GISEL-GFX9 %s

declare i64 @llvm.amdgcn.fcmp.f32(float, float, i32) #0
declare i64 @llvm.amdgcn.fcmp.f64(double, double, i32) #0
declare float @llvm.fabs.f32(float) #0

declare i64 @llvm.amdgcn.fcmp.f16(half, half, i32) #0
declare half @llvm.fabs.f16(half) #0

define amdgpu_kernel void @v_fcmp_f32_oeq_with_fabs(ptr addrspace(1) %out, float %src, float %a) {
; GFX11-LABEL: v_fcmp_f32_oeq_with_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f32_e64 s[2:3], s2, |s3|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_oeq_with_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_cmp_eq_f32_e64 s[2:3], s2, |v0|
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_oeq_with_fabs:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s3
; GISEL-VI-NEXT:    v_cmp_eq_f32_e64 s[2:3], s2, |v0|
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_oeq_with_fabs:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s3
; SDAG-VI-NEXT:    v_cmp_eq_f32_e64 s[2:3], s2, |v0|
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %temp = call float @llvm.fabs.f32(float %a)
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float %temp, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_oeq_both_operands_with_fabs(ptr addrspace(1) %out, float %src, float %a) {
; GFX11-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f32_e64 s[2:3], |s2|, |s3|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_cmp_eq_f32_e64 s[2:3], |s2|, |v0|
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s3
; GISEL-VI-NEXT:    v_cmp_eq_f32_e64 s[2:3], |s2|, |v0|
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_oeq_both_operands_with_fabs:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s3
; SDAG-VI-NEXT:    v_cmp_eq_f32_e64 s[2:3], |s2|, |v0|
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %temp = call float @llvm.fabs.f32(float %a)
  %src_input = call float @llvm.fabs.f32(float %src)
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src_input, float %temp, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32(ptr addrspace(1) %out, float %src) {
; SDAG-GFX-LABEL: v_fcmp_f32:
; SDAG-GFX:       ; %bb.0:
; SDAG-GFX-NEXT:    s_endpgm
;
; SDAG-GFX11-LABEL: v_fcmp_f32:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_fcmp_f32:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_endpgm
;
; SDAG-GFX9-LABEL: v_fcmp_f32:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f32:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f32:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; GISEL-GFX-LABEL: v_fcmp_f32:
; GISEL-GFX:       ; %bb.0:
; GISEL-GFX-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-GFX-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GISEL-GFX-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 -1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_oeq(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_oeq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_oeq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_oeq:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_eq_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_oeq:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_eq_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_one(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_one:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_one:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_one:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_neq_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_one:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_neq_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 6)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ogt(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ogt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ogt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_ogt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_gt_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_ogt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_gt_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 2)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_oge(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_oge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_oge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_oge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ge_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_oge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ge_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 3)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_olt(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_olt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_olt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_olt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_lt_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_olt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_lt_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 4)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ole(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ole:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ole:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_ole:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_le_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_ole:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_le_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 5)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f32_ueq(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ueq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlg_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ueq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlg_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_ueq:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nlg_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_ueq:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nlg_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 9)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_une(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_une:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_une:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_une:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_neq_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_une:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_neq_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 14)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ugt(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ugt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nge_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ugt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nle_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_ugt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nle_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_ugt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nle_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 10)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_uge(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_uge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ngt_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_uge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_uge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nlt_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_uge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nlt_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 11)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ult(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ult:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nle_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ult:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nge_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_ult:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nge_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_ult:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nge_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 12)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f32_ule(ptr addrspace(1) %out, float %src) {
; GFX11-LABEL: v_fcmp_f32_ule:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlt_f32_e64 s[2:3], 0x42c80000, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f32_ule:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f32_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f32_ule:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ngt_f32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f32_ule:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x42c80000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ngt_f32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f32(float %src, float 100.00, i32 13)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_oeq(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_oeq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_oeq:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_eq_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_oeq:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_eq_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_oeq:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_eq_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_oeq:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_eq_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_one(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_one:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_one:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_one:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_one:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_one:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 6)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ogt(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ogt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_ogt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_gt_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_ogt:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_gt_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_ogt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_gt_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_ogt:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_gt_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 2)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_oge(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_oge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_oge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ge_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_oge:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_ge_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_oge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ge_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_oge:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_ge_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 3)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_olt(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_olt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_olt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_lt_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_olt:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_lt_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_olt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_lt_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_olt:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_lt_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 4)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ole(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ole:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_ole:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_le_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_ole:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_le_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_ole:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_le_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_ole:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_le_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 5)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ueq(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ueq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlg_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_ueq:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nlg_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_ueq:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_nlg_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_ueq:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nlg_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_ueq:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_nlg_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 9)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_une(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_une:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_une:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_une:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_une:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_une:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_neq_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 14)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ugt(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ugt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nle_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_ugt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nle_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_ugt:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_nle_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_ugt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nle_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_ugt:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_nle_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 10)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_uge(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_uge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlt_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_uge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nlt_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_uge:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_nlt_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_uge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nlt_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_uge:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_nlt_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 11)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ult(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ult:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nge_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_ult:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nge_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_ult:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_nge_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_ult:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nge_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_ult:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_nge_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 12)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f64_ule(ptr addrspace(1) %out, double %src) {
; GFX11-LABEL: v_fcmp_f64_ule:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_mov_b32 s5, 0x40590000
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ngt_f64_e64 s[2:3], s[2:3], s[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f64_ule:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-VI-NEXT:    s_mov_b32 s4, 0
; GISEL-VI-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ngt_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f64_ule:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GISEL-GFX9-NEXT:    s_mov_b32 s4, 0
; GISEL-GFX9-NEXT:    s_mov_b32 s5, 0x40590000
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    v_cmp_ngt_f64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f64_ule:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ngt_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
; SDAG-GFX9-LABEL: v_fcmp_f64_ule:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, 0x40590000
; SDAG-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-GFX9-NEXT:    v_cmp_ngt_f64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v1, s2
; SDAG-GFX9-NEXT:    v_mov_b32_e32 v2, s3
; SDAG-GFX9-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; SDAG-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f64(double %src, double 100.00, i32 13)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oeq_with_fabs(ptr addrspace(1) %out, half %src, half %a) {
; GFX11-LABEL: v_fcmp_f16_oeq_with_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s3, s2, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_f16_e64 s[2:3], s2, |s3|
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_oeq_with_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s0, s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_cmp_eq_f16_e64 s[0:1], s4, |v0|
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_oeq_with_fabs:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    s_lshr_b32 s3, s2, 16
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s3
; GISEL-VI-NEXT:    v_cmp_eq_f16_e64 s[2:3], s2, |v0|
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_oeq_with_fabs:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    s_lshr_b32 s3, s2, 16
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s3
; SDAG-VI-NEXT:    v_cmp_eq_f16_e64 s[2:3], s2, |v0|
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %temp = call half @llvm.fabs.f16(half %a)
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half %temp, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oeq_both_operands_with_fabs(ptr addrspace(1) %out, half %src, half %a) {
; GFX11-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s3, s2, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_f16_e64 s[2:3], |s2|, |s3|
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s0, s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_cmp_eq_f16_e64 s[0:1], |s4|, |v0|
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    s_lshr_b32 s3, s2, 16
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s3
; GISEL-VI-NEXT:    v_cmp_eq_f16_e64 s[2:3], |s2|, |v0|
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_oeq_both_operands_with_fabs:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    s_lshr_b32 s3, s2, 16
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s3
; SDAG-VI-NEXT:    v_cmp_eq_f16_e64 s[2:3], |s2|, |v0|
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %temp = call half @llvm.fabs.f16(half %a)
  %src_input = call half @llvm.fabs.f16(half %src)
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src_input, half %temp, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fcmp_f16(ptr addrspace(1) %out, half %src) {
; SDAG-GFX-LABEL: v_fcmp_f16:
; SDAG-GFX:       ; %bb.0:
; SDAG-GFX-NEXT:    s_endpgm
;
; SDAG-GFX11-LABEL: v_fcmp_f16:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_fcmp_f16:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_endpgm
;
; SDAG-GFX9-LABEL: v_fcmp_f16:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_fcmp_f16:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GISEL-GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_fcmp_f16:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
; GISEL-GFX-LABEL: v_fcmp_f16:
; GISEL-GFX:       ; %bb.0:
; GISEL-GFX-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-GFX-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GISEL-GFX-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 -1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oeq(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_oeq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_oeq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_oeq:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_eq_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_oeq:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_eq_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 1)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_one(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_one:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_one:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_one:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_neq_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_one:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_neq_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 6)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ogt(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ogt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ogt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_ogt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_gt_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_ogt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_gt_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 2)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_oge(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_oge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_oge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_oge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ge_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_oge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ge_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 3)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_olt(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_olt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_olt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_olt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_lt_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_olt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_lt_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 4)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ole(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ole:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ole:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_ole:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_le_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_ole:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_le_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 5)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ueq(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ueq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlg_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ueq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlg_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_ueq:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nlg_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_ueq:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nlg_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 9)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_une(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_une:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_neq_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_une:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_neq_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_une:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_neq_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_une:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_neq_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 14)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ugt(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ugt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nge_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ugt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nle_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_ugt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nle_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_ugt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nle_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 10)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_uge(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_uge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ngt_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_uge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nlt_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_uge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nlt_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_uge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nlt_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 11)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ult(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ult:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nle_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ult:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_nge_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_ult:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_nge_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_ult:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_nge_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 12)
  store i64 %result, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @v_fcmp_f16_ule(ptr addrspace(1) %out, half %src) {
; GFX11-LABEL: v_fcmp_f16_ule:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[0:1], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[0:1], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlt_f16_e64 s[2:3], 0x5640, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fcmp_f16_ule:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x5640
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ngt_f16_e64 s[0:1], s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_fcmp_f16_ule:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ngt_f16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
; SDAG-VI-LABEL: v_fcmp_f16_ule:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[0:1], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x5640
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ngt_f16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.fcmp.f16(half %src, half 100.00, i32 13)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind readnone convergent }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
; VI: {{.*}}
