; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=hawaii < %s | FileCheck --check-prefix=GFX7 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=fiji < %s | FileCheck --check-prefix=GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck --check-prefix=GFX10_W32 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 -mattr=+wavefrontsize64 < %s | FileCheck --check-prefix=GFX10_W64 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 < %s | FileCheck --check-prefix=GFX11_W32 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 -mattr=+wavefrontsize64 < %s | FileCheck --check-prefix=GFX11_W64 %s

define float @v_div_fmas_f32(float %a, float %b, float %c, i1 %d) {
; GFX7-LABEL: v_div_fmas_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX7-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX7-NEXT:    s_nop 3
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_div_fmas_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10_W32-LABEL: v_div_fmas_f32:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10_W32-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10_W32-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX10_W32-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX10_W32-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10_W64-LABEL: v_div_fmas_f32:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10_W64-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10_W64-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX10_W64-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX10_W64-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11_W32-LABEL: v_div_fmas_f32:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11_W32-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11_W32-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX11_W32-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v3
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX11_W32-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11_W64-LABEL: v_div_fmas_f32:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11_W64-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11_W64-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX11_W64-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v3
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX11_W64-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float %b, float %c, i1 %d)
  ret float %result
}

define double @v_div_fmas_f64(double %a, double %b, double %c, i1 %d) {
; GFX7-LABEL: v_div_fmas_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX7-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX7-NEXT:    s_nop 3
; GFX7-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_div_fmas_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10_W32-LABEL: v_div_fmas_f64:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10_W32-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10_W32-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX10_W32-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v6
; GFX10_W32-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX10_W32-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10_W64-LABEL: v_div_fmas_f64:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10_W64-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10_W64-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX10_W64-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX10_W64-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX10_W64-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11_W32-LABEL: v_div_fmas_f64:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11_W32-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11_W32-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX11_W32-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v6
; GFX11_W32-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX11_W32-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11_W64-LABEL: v_div_fmas_f64:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11_W64-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11_W64-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX11_W64-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX11_W64-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX11_W64-NEXT:    s_setpc_b64 s[30:31]
  %result = call double @llvm.amdgcn.div.fmas.f64(double %a, double %b, double %c, i1 %d)
  ret double %result
}

define amdgpu_ps float @s_div_fmas_f32(float inreg %a, float inreg %b, float inreg %c, i32 inreg %d) {
; GFX7-LABEL: s_div_fmas_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_cmp_eq_u32 s3, 0
; GFX7-NEXT:    s_cselect_b32 s3, 1, 0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    s_and_b32 s0, 1, s3
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX7-NEXT:    s_nop 3
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX7-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_div_fmas_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_cmp_eq_u32 s3, 0
; GFX8-NEXT:    s_cselect_b32 s3, 1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    s_and_b32 s0, 1, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX10_W32-LABEL: s_div_fmas_f32:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_cmp_eq_u32 s3, 0
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s1
; GFX10_W32-NEXT:    s_cselect_b32 s3, 1, 0
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, s2
; GFX10_W32-NEXT:    s_and_b32 s3, 1, s3
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s3
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, s0, v0, v1
; GFX10_W32-NEXT:    ; return to shader part epilog
;
; GFX10_W64-LABEL: s_div_fmas_f32:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_cmp_eq_u32 s3, 0
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s1
; GFX10_W64-NEXT:    s_cselect_b32 s3, 1, 0
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, s2
; GFX10_W64-NEXT:    s_and_b32 s3, 1, s3
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s3
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, s0, v0, v1
; GFX10_W64-NEXT:    ; return to shader part epilog
;
; GFX11_W32-LABEL: s_div_fmas_f32:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_cmp_eq_u32 s3, 0
; GFX11_W32-NEXT:    v_dual_mov_b32 v0, s1 :: v_dual_mov_b32 v1, s2
; GFX11_W32-NEXT:    s_cselect_b32 s3, 1, 0
; GFX11_W32-NEXT:    s_and_b32 s3, 1, s3
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s3
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, s0, v0, v1
; GFX11_W32-NEXT:    ; return to shader part epilog
;
; GFX11_W64-LABEL: s_div_fmas_f32:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_cmp_eq_u32 s3, 0
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s1
; GFX11_W64-NEXT:    s_cselect_b32 s3, 1, 0
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, s2
; GFX11_W64-NEXT:    s_and_b32 s3, 1, s3
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s3
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, s0, v0, v1
; GFX11_W64-NEXT:    ; return to shader part epilog
  %vcc = icmp eq i32 %d, 0
  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float %b, float %c, i1 %vcc)
  ret float %result
}

define amdgpu_ps double @s_div_fmas_f64(double inreg %a, double inreg %b, double inreg %c, i32 inreg %d) {
; GFX7-LABEL: s_div_fmas_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_cmp_eq_u32 s6, 0
; GFX7-NEXT:    s_cselect_b32 s6, 1, 0
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s2
; GFX7-NEXT:    v_mov_b32_e32 v4, s4
; GFX7-NEXT:    s_and_b32 s0, 1, s6
; GFX7-NEXT:    v_mov_b32_e32 v3, s3
; GFX7-NEXT:    v_mov_b32_e32 v5, s5
; GFX7-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX7-NEXT:    s_nop 3
; GFX7-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX7-NEXT:    v_readfirstlane_b32 s0, v0
; GFX7-NEXT:    v_readfirstlane_b32 s1, v1
; GFX7-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_div_fmas_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_cmp_eq_u32 s6, 0
; GFX8-NEXT:    s_cselect_b32 s6, 1, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    v_mov_b32_e32 v4, s4
; GFX8-NEXT:    s_and_b32 s0, 1, s6
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_mov_b32_e32 v5, s5
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX10_W32-LABEL: s_div_fmas_f64:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_cmp_eq_u32 s6, 0
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s2
; GFX10_W32-NEXT:    s_cselect_b32 s6, 1, 0
; GFX10_W32-NEXT:    v_mov_b32_e32 v2, s4
; GFX10_W32-NEXT:    s_and_b32 s6, 1, s6
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, s3
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s6
; GFX10_W32-NEXT:    v_mov_b32_e32 v3, s5
; GFX10_W32-NEXT:    v_div_fmas_f64 v[0:1], s[0:1], v[0:1], v[2:3]
; GFX10_W32-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10_W32-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10_W32-NEXT:    ; return to shader part epilog
;
; GFX10_W64-LABEL: s_div_fmas_f64:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_cmp_eq_u32 s6, 0
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s2
; GFX10_W64-NEXT:    s_cselect_b32 s6, 1, 0
; GFX10_W64-NEXT:    v_mov_b32_e32 v2, s4
; GFX10_W64-NEXT:    s_and_b32 s6, 1, s6
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, s3
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s6
; GFX10_W64-NEXT:    v_mov_b32_e32 v3, s5
; GFX10_W64-NEXT:    v_div_fmas_f64 v[0:1], s[0:1], v[0:1], v[2:3]
; GFX10_W64-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10_W64-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10_W64-NEXT:    ; return to shader part epilog
;
; GFX11_W32-LABEL: s_div_fmas_f64:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_cmp_eq_u32 s6, 0
; GFX11_W32-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11_W32-NEXT:    s_cselect_b32 s6, 1, 0
; GFX11_W32-NEXT:    v_dual_mov_b32 v2, s4 :: v_dual_mov_b32 v3, s5
; GFX11_W32-NEXT:    s_and_b32 s6, 1, s6
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s6
; GFX11_W32-NEXT:    v_div_fmas_f64 v[0:1], s[0:1], v[0:1], v[2:3]
; GFX11_W32-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11_W32-NEXT:    v_readfirstlane_b32 s1, v1
; GFX11_W32-NEXT:    ; return to shader part epilog
;
; GFX11_W64-LABEL: s_div_fmas_f64:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_cmp_eq_u32 s6, 0
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s2
; GFX11_W64-NEXT:    s_cselect_b32 s6, 1, 0
; GFX11_W64-NEXT:    v_mov_b32_e32 v2, s4
; GFX11_W64-NEXT:    s_and_b32 s6, 1, s6
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, s3
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s6
; GFX11_W64-NEXT:    v_mov_b32_e32 v3, s5
; GFX11_W64-NEXT:    v_div_fmas_f64 v[0:1], s[0:1], v[0:1], v[2:3]
; GFX11_W64-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11_W64-NEXT:    v_readfirstlane_b32 s1, v1
; GFX11_W64-NEXT:    ; return to shader part epilog
  %vcc = icmp eq i32 %d, 0
  %result = call double @llvm.amdgcn.div.fmas.f64(double %a, double %b, double %c, i1 %vcc)
  ret double %result
}

define amdgpu_kernel void @test_div_fmas_f32(ptr addrspace(1) %out, [8 x i32], float %a, [8 x i32], float %b, [8 x i32], float %c, [8 x i32], i1 %d) {
; GFX7-LABEL: test_div_fmas_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s2, s[0:1], 0xa
; GFX7-NEXT:    s_load_dword s3, s[0:1], 0x13
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x1c
; GFX7-NEXT:    s_load_dword s5, s[0:1], 0x25
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    s_and_b32 s2, 1, s5
; GFX7-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_nop 1
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x28
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x4c
; GFX8-NEXT:    s_load_dword s4, s[0:1], 0x70
; GFX8-NEXT:    s_load_dword s5, s[0:1], 0x94
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_and_b32 s2, 1, s5
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f32 v2, v0, v1, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f32:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_clause 0x4
; GFX10_W32-NEXT:    s_load_dword s4, s[0:1], 0x94
; GFX10_W32-NEXT:    s_load_dword s5, s[0:1], 0x4c
; GFX10_W32-NEXT:    s_load_dword s6, s[0:1], 0x70
; GFX10_W32-NEXT:    s_load_dword s7, s[0:1], 0x28
; GFX10_W32-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    s_and_b32 s0, 1, s4
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, s6
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, s7, v0, v1
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W32-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f32:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_clause 0x4
; GFX10_W64-NEXT:    s_load_dword s4, s[0:1], 0x94
; GFX10_W64-NEXT:    s_load_dword s5, s[0:1], 0x4c
; GFX10_W64-NEXT:    s_load_dword s6, s[0:1], 0x70
; GFX10_W64-NEXT:    s_load_dword s7, s[0:1], 0x28
; GFX10_W64-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    s_and_b32 s0, 1, s4
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, s6
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, s7, v0, v1
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W64-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f32:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_clause 0x4
; GFX11_W32-NEXT:    s_load_b32 s2, s[0:1], 0x94
; GFX11_W32-NEXT:    s_load_b32 s3, s[0:1], 0x4c
; GFX11_W32-NEXT:    s_load_b32 s4, s[0:1], 0x70
; GFX11_W32-NEXT:    s_load_b32 s5, s[0:1], 0x28
; GFX11_W32-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W32-NEXT:    v_dual_mov_b32 v0, s3 :: v_dual_mov_b32 v1, s4
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s2
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, s5, v0, v1
; GFX11_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W32-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f32:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_clause 0x4
; GFX11_W64-NEXT:    s_load_b32 s2, s[0:1], 0x94
; GFX11_W64-NEXT:    s_load_b32 s3, s[0:1], 0x4c
; GFX11_W64-NEXT:    s_load_b32 s4, s[0:1], 0x70
; GFX11_W64-NEXT:    s_load_b32 s5, s[0:1], 0x28
; GFX11_W64-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s3
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, s4
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, s5, v0, v1
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W64-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float %b, float %c, i1 %d)
  store float %result, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_div_fmas_f32_inline_imm_0(ptr addrspace(1) %out, [8 x i32], float %a, [8 x i32], float %b, [8 x i32], float %c, [8 x i32], i1 %d) {
; GFX7-LABEL: test_div_fmas_f32_inline_imm_0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s2, s[0:1], 0x13
; GFX7-NEXT:    s_load_dword s3, s[0:1], 0x1c
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x25
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_and_b32 s2, 1, s4
; GFX7-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_nop 1
; GFX7-NEXT:    v_div_fmas_f32 v0, 1.0, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f32_inline_imm_0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x4c
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x70
; GFX8-NEXT:    s_load_dword s4, s[0:1], 0x94
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_and_b32 s2, 1, s4
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f32 v2, 1.0, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f32_inline_imm_0:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_clause 0x3
; GFX10_W32-NEXT:    s_load_dword s4, s[0:1], 0x94
; GFX10_W32-NEXT:    s_load_dword s5, s[0:1], 0x70
; GFX10_W32-NEXT:    s_load_dword s6, s[0:1], 0x4c
; GFX10_W32-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    s_and_b32 s0, 1, s4
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, 1.0, s6, v0
; GFX10_W32-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f32_inline_imm_0:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_clause 0x3
; GFX10_W64-NEXT:    s_load_dword s4, s[0:1], 0x94
; GFX10_W64-NEXT:    s_load_dword s5, s[0:1], 0x70
; GFX10_W64-NEXT:    s_load_dword s6, s[0:1], 0x4c
; GFX10_W64-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    s_and_b32 s0, 1, s4
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, 1.0, s6, v0
; GFX10_W64-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f32_inline_imm_0:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_clause 0x3
; GFX11_W32-NEXT:    s_load_b32 s2, s[0:1], 0x94
; GFX11_W32-NEXT:    s_load_b32 s3, s[0:1], 0x70
; GFX11_W32-NEXT:    s_load_b32 s4, s[0:1], 0x4c
; GFX11_W32-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W32-NEXT:    v_mov_b32_e32 v0, s3
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s2
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, 1.0, s4, v0
; GFX11_W32-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f32_inline_imm_0:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_clause 0x3
; GFX11_W64-NEXT:    s_load_b32 s2, s[0:1], 0x94
; GFX11_W64-NEXT:    s_load_b32 s3, s[0:1], 0x70
; GFX11_W64-NEXT:    s_load_b32 s4, s[0:1], 0x4c
; GFX11_W64-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s3
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, 1.0, s4, v0
; GFX11_W64-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
  %result = call float @llvm.amdgcn.div.fmas.f32(float 1.0, float %b, float %c, i1 %d)
  store float %result, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_div_fmas_f32_inline_imm_1(ptr addrspace(1) %out, float %a, float %b, float %c, [8 x i32], i1 %d) {
; GFX7-LABEL: test_div_fmas_f32_inline_imm_1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s2, s[0:1], 0x2
; GFX7-NEXT:    s_load_dword s3, s[0:1], 0x4
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0xd
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_and_b32 s2, 1, s4
; GFX7-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_nop 1
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, 1.0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f32_inline_imm_1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x8
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x10
; GFX8-NEXT:    s_load_dword s4, s[0:1], 0x34
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_and_b32 s2, 1, s4
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f32 v2, v0, 1.0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f32_inline_imm_1:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_clause 0x3
; GFX10_W32-NEXT:    s_load_dword s4, s[0:1], 0x34
; GFX10_W32-NEXT:    s_load_dword s5, s[0:1], 0x10
; GFX10_W32-NEXT:    s_load_dword s6, s[0:1], 0x8
; GFX10_W32-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    s_and_b32 s0, 1, s4
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, s6, 1.0, v0
; GFX10_W32-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f32_inline_imm_1:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_clause 0x3
; GFX10_W64-NEXT:    s_load_dword s4, s[0:1], 0x34
; GFX10_W64-NEXT:    s_load_dword s5, s[0:1], 0x10
; GFX10_W64-NEXT:    s_load_dword s6, s[0:1], 0x8
; GFX10_W64-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    s_and_b32 s0, 1, s4
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, s6, 1.0, v0
; GFX10_W64-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f32_inline_imm_1:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_clause 0x3
; GFX11_W32-NEXT:    s_load_b32 s2, s[0:1], 0x34
; GFX11_W32-NEXT:    s_load_b32 s3, s[0:1], 0x10
; GFX11_W32-NEXT:    s_load_b32 s4, s[0:1], 0x8
; GFX11_W32-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W32-NEXT:    v_mov_b32_e32 v0, s3
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s2
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, s4, 1.0, v0
; GFX11_W32-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f32_inline_imm_1:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_clause 0x3
; GFX11_W64-NEXT:    s_load_b32 s2, s[0:1], 0x34
; GFX11_W64-NEXT:    s_load_b32 s3, s[0:1], 0x10
; GFX11_W64-NEXT:    s_load_b32 s4, s[0:1], 0x8
; GFX11_W64-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s3
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, s4, 1.0, v0
; GFX11_W64-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float 1.0, float %c, i1 %d)
  store float %result, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_div_fmas_f32_inline_imm_2(ptr addrspace(1) %out, [8 x i32], float %a, [8 x i32], float %b, [8 x i32], float %c, [8 x i32], i1 %d) {
; GFX7-LABEL: test_div_fmas_f32_inline_imm_2:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s2, s[0:1], 0xa
; GFX7-NEXT:    s_load_dword s3, s[0:1], 0x13
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x25
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    s_and_b32 s2, 1, s4
; GFX7-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_nop 1
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v1, 1.0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f32_inline_imm_2:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x28
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x4c
; GFX8-NEXT:    s_load_dword s4, s[0:1], 0x94
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_and_b32 s2, 1, s4
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f32 v2, v0, v1, 1.0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f32_inline_imm_2:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_clause 0x3
; GFX10_W32-NEXT:    s_load_dword s4, s[0:1], 0x94
; GFX10_W32-NEXT:    s_load_dword s5, s[0:1], 0x4c
; GFX10_W32-NEXT:    s_load_dword s6, s[0:1], 0x28
; GFX10_W32-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    s_and_b32 s0, 1, s4
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, s6, v0, 1.0
; GFX10_W32-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f32_inline_imm_2:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_clause 0x3
; GFX10_W64-NEXT:    s_load_dword s4, s[0:1], 0x94
; GFX10_W64-NEXT:    s_load_dword s5, s[0:1], 0x4c
; GFX10_W64-NEXT:    s_load_dword s6, s[0:1], 0x28
; GFX10_W64-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    s_and_b32 s0, 1, s4
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, s6, v0, 1.0
; GFX10_W64-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f32_inline_imm_2:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_clause 0x3
; GFX11_W32-NEXT:    s_load_b32 s2, s[0:1], 0x94
; GFX11_W32-NEXT:    s_load_b32 s3, s[0:1], 0x4c
; GFX11_W32-NEXT:    s_load_b32 s4, s[0:1], 0x28
; GFX11_W32-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W32-NEXT:    v_mov_b32_e32 v0, s3
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s2
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, s4, v0, 1.0
; GFX11_W32-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f32_inline_imm_2:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_clause 0x3
; GFX11_W64-NEXT:    s_load_b32 s2, s[0:1], 0x94
; GFX11_W64-NEXT:    s_load_b32 s3, s[0:1], 0x4c
; GFX11_W64-NEXT:    s_load_b32 s4, s[0:1], 0x28
; GFX11_W64-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s3
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, s4, v0, 1.0
; GFX11_W64-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float %b, float 1.0, i1 %d)
  store float %result, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_div_fmas_f64(ptr addrspace(1) %out, double %a, double %b, double %c, i1 %d) {
; GFX7-LABEL: test_div_fmas_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x0
; GFX7-NEXT:    s_load_dword s0, s[0:1], 0x8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v2, s8
; GFX7-NEXT:    v_mov_b32_e32 v4, s10
; GFX7-NEXT:    s_and_b32 s0, 1, s0
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v3, s9
; GFX7-NEXT:    v_mov_b32_e32 v5, s11
; GFX7-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX7-NEXT:    s_nop 3
; GFX7-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x0
; GFX8-NEXT:    s_load_dword s0, s[0:1], 0x20
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_mov_b32_e32 v2, s8
; GFX8-NEXT:    v_mov_b32_e32 v4, s10
; GFX8-NEXT:    s_and_b32 s0, 1, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v3, s9
; GFX8-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f64:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_clause 0x1
; GFX10_W32-NEXT:    s_load_dword s2, s[0:1], 0x20
; GFX10_W32-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    s_and_b32 s0, 1, s2
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s8
; GFX10_W32-NEXT:    v_mov_b32_e32 v2, s10
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, s9
; GFX10_W32-NEXT:    v_mov_b32_e32 v3, s11
; GFX10_W32-NEXT:    v_div_fmas_f64 v[0:1], s[6:7], v[0:1], v[2:3]
; GFX10_W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX10_W32-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f64:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_clause 0x1
; GFX10_W64-NEXT:    s_load_dword s2, s[0:1], 0x20
; GFX10_W64-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    s_and_b32 s0, 1, s2
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s8
; GFX10_W64-NEXT:    v_mov_b32_e32 v2, s10
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, s9
; GFX10_W64-NEXT:    v_mov_b32_e32 v3, s11
; GFX10_W64-NEXT:    v_div_fmas_f64 v[0:1], s[6:7], v[0:1], v[2:3]
; GFX10_W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX10_W64-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f64:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_clause 0x1
; GFX11_W32-NEXT:    s_load_b32 s8, s[0:1], 0x20
; GFX11_W32-NEXT:    s_load_b256 s[0:7], s[0:1], 0x0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    s_and_b32 s8, 1, s8
; GFX11_W32-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s8
; GFX11_W32-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s7
; GFX11_W32-NEXT:    v_div_fmas_f64 v[0:1], s[2:3], v[0:1], v[2:3]
; GFX11_W32-NEXT:    v_mov_b32_e32 v2, 0
; GFX11_W32-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f64:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_clause 0x1
; GFX11_W64-NEXT:    s_load_b32 s8, s[0:1], 0x20
; GFX11_W64-NEXT:    s_load_b256 s[0:7], s[0:1], 0x0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    s_and_b32 s8, 1, s8
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s4
; GFX11_W64-NEXT:    v_mov_b32_e32 v2, s6
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s8
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, s5
; GFX11_W64-NEXT:    v_mov_b32_e32 v3, s7
; GFX11_W64-NEXT:    v_div_fmas_f64 v[0:1], s[2:3], v[0:1], v[2:3]
; GFX11_W64-NEXT:    v_mov_b32_e32 v2, 0
; GFX11_W64-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
  %result = call double @llvm.amdgcn.div.fmas.f64(double %a, double %b, double %c, i1 %d)
  store double %result, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @test_div_fmas_f32_cond_to_vcc(ptr addrspace(1) %out, float %a, float %b, float %c, i32 %i) {
; GFX7-LABEL: test_div_fmas_f32_cond_to_vcc:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x2
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cmp_eq_u32 s7, 0
; GFX7-NEXT:    s_cselect_b32 s2, 1, 0
; GFX7-NEXT:    s_and_b32 s2, 1, s2
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    v_mov_b32_e32 v2, s6
; GFX7-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_nop 2
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f32_cond_to_vcc:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x8
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cmp_eq_u32 s7, 0
; GFX8-NEXT:    s_cselect_b32 s2, 1, 0
; GFX8-NEXT:    s_and_b32 s2, 1, s2
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_mov_b32_e32 v2, s6
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX8-NEXT:    s_nop 3
; GFX8-NEXT:    v_div_fmas_f32 v2, v0, v1, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f32_cond_to_vcc:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_clause 0x1
; GFX10_W32-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x8
; GFX10_W32-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    s_cmp_eq_u32 s7, 0
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W32-NEXT:    s_cselect_b32 s0, 1, 0
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, s6
; GFX10_W32-NEXT:    s_and_b32 s0, 1, s0
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, s4, v0, v1
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W32-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f32_cond_to_vcc:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_clause 0x1
; GFX10_W64-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x8
; GFX10_W64-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    s_cmp_eq_u32 s7, 0
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s5
; GFX10_W64-NEXT:    s_cselect_b32 s0, 1, 0
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, s6
; GFX10_W64-NEXT:    s_and_b32 s0, 1, s0
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, s4, v0, v1
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W64-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f32_cond_to_vcc:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_clause 0x1
; GFX11_W32-NEXT:    s_load_b128 s[4:7], s[0:1], 0x8
; GFX11_W32-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    s_cmp_eq_u32 s7, 0
; GFX11_W32-NEXT:    v_dual_mov_b32 v0, s5 :: v_dual_mov_b32 v1, s6
; GFX11_W32-NEXT:    s_cselect_b32 s2, 1, 0
; GFX11_W32-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s2
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, s4, v0, v1
; GFX11_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W32-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f32_cond_to_vcc:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_clause 0x1
; GFX11_W64-NEXT:    s_load_b128 s[4:7], s[0:1], 0x8
; GFX11_W64-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    s_cmp_eq_u32 s7, 0
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s5
; GFX11_W64-NEXT:    s_cselect_b32 s2, 1, 0
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, s6
; GFX11_W64-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, s4, v0, v1
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W64-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
  %cmp = icmp eq i32 %i, 0
  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float %b, float %c, i1 %cmp)
  store float %result, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_div_fmas_f32_imm_false_cond_to_vcc(ptr addrspace(1) %out, [8 x i32], float %a, [8 x i32], float %b, [8 x i32], float %c) {
; GFX7-LABEL: test_div_fmas_f32_imm_false_cond_to_vcc:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s2, s[0:1], 0xa
; GFX7-NEXT:    s_load_dword s3, s[0:1], 0x13
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x1c
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX7-NEXT:    s_mov_b64 vcc, 0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f32_imm_false_cond_to_vcc:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x28
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x4c
; GFX8-NEXT:    s_load_dword s4, s[0:1], 0x70
; GFX8-NEXT:    s_mov_b64 vcc, 0
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_div_fmas_f32 v2, v0, v1, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f32_imm_false_cond_to_vcc:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_clause 0x3
; GFX10_W32-NEXT:    s_load_dword s4, s[0:1], 0x4c
; GFX10_W32-NEXT:    s_load_dword s5, s[0:1], 0x70
; GFX10_W32-NEXT:    s_load_dword s6, s[0:1], 0x28
; GFX10_W32-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W32-NEXT:    s_mov_b32 vcc_lo, 0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s4
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, s5
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, s6, v0, v1
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W32-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f32_imm_false_cond_to_vcc:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_clause 0x3
; GFX10_W64-NEXT:    s_load_dword s4, s[0:1], 0x4c
; GFX10_W64-NEXT:    s_load_dword s5, s[0:1], 0x70
; GFX10_W64-NEXT:    s_load_dword s6, s[0:1], 0x28
; GFX10_W64-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W64-NEXT:    s_mov_b64 vcc, 0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s4
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, s5
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, s6, v0, v1
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W64-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f32_imm_false_cond_to_vcc:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_clause 0x3
; GFX11_W32-NEXT:    s_load_b32 s2, s[0:1], 0x4c
; GFX11_W32-NEXT:    s_load_b32 s3, s[0:1], 0x70
; GFX11_W32-NEXT:    s_load_b32 s4, s[0:1], 0x28
; GFX11_W32-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W32-NEXT:    s_mov_b32 vcc_lo, 0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, s4, v0, v1
; GFX11_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W32-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f32_imm_false_cond_to_vcc:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_clause 0x3
; GFX11_W64-NEXT:    s_load_b32 s2, s[0:1], 0x4c
; GFX11_W64-NEXT:    s_load_b32 s3, s[0:1], 0x70
; GFX11_W64-NEXT:    s_load_b32 s4, s[0:1], 0x28
; GFX11_W64-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W64-NEXT:    s_mov_b64 vcc, 0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s2
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, s3
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, s4, v0, v1
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W64-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float %b, float %c, i1 false)
  store float %result, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_div_fmas_f32_imm_true_cond_to_vcc(ptr addrspace(1) %out, [8 x i32], float %a, [8 x i32], float %b, [8 x i32], float %c) {
; GFX7-LABEL: test_div_fmas_f32_imm_true_cond_to_vcc:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s2, s[0:1], 0xa
; GFX7-NEXT:    s_load_dword s3, s[0:1], 0x13
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x1c
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX7-NEXT:    s_mov_b64 vcc, -1
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s3
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    v_div_fmas_f32 v0, v0, v1, v2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f32_imm_true_cond_to_vcc:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x28
; GFX8-NEXT:    s_load_dword s3, s[0:1], 0x4c
; GFX8-NEXT:    s_load_dword s4, s[0:1], 0x70
; GFX8-NEXT:    s_mov_b64 vcc, -1
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_div_fmas_f32 v2, v0, v1, v2
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f32_imm_true_cond_to_vcc:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_clause 0x3
; GFX10_W32-NEXT:    s_load_dword s4, s[0:1], 0x4c
; GFX10_W32-NEXT:    s_load_dword s5, s[0:1], 0x70
; GFX10_W32-NEXT:    s_load_dword s6, s[0:1], 0x28
; GFX10_W32-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W32-NEXT:    s_mov_b32 vcc_lo, -1
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    v_mov_b32_e32 v0, s4
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, s5
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, s6, v0, v1
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W32-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f32_imm_true_cond_to_vcc:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_clause 0x3
; GFX10_W64-NEXT:    s_load_dword s4, s[0:1], 0x4c
; GFX10_W64-NEXT:    s_load_dword s5, s[0:1], 0x70
; GFX10_W64-NEXT:    s_load_dword s6, s[0:1], 0x28
; GFX10_W64-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX10_W64-NEXT:    s_mov_b64 vcc, -1
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    v_mov_b32_e32 v0, s4
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, s5
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, s6, v0, v1
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W64-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f32_imm_true_cond_to_vcc:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_clause 0x3
; GFX11_W32-NEXT:    s_load_b32 s2, s[0:1], 0x4c
; GFX11_W32-NEXT:    s_load_b32 s3, s[0:1], 0x70
; GFX11_W32-NEXT:    s_load_b32 s4, s[0:1], 0x28
; GFX11_W32-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W32-NEXT:    s_mov_b32 vcc_lo, -1
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    v_dual_mov_b32 v0, s2 :: v_dual_mov_b32 v1, s3
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, s4, v0, v1
; GFX11_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W32-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f32_imm_true_cond_to_vcc:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_clause 0x3
; GFX11_W64-NEXT:    s_load_b32 s2, s[0:1], 0x4c
; GFX11_W64-NEXT:    s_load_b32 s3, s[0:1], 0x70
; GFX11_W64-NEXT:    s_load_b32 s4, s[0:1], 0x28
; GFX11_W64-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W64-NEXT:    s_mov_b64 vcc, -1
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    v_mov_b32_e32 v0, s2
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, s3
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, s4, v0, v1
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W64-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float %b, float %c, i1 true)
  store float %result, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_div_fmas_f32_logical_cond_to_vcc(ptr addrspace(1) %out, ptr addrspace(1) %in, [8 x i32], i32 %d) {
; GFX7-LABEL: test_div_fmas_f32_logical_cond_to_vcc:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x0
; GFX7-NEXT:    s_load_dword s8, s[0:1], 0xc
; GFX7-NEXT:    s_mov_b32 s2, 0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[0:1], s[6:7]
; GFX7-NEXT:    buffer_load_dword v3, v[1:2], s[0:3], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_load_dword v4, v[1:2], s[0:3], 0 addr64 offset:4 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_load_dword v1, v[1:2], s[0:3], 0 addr64 offset:8 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_cmp_lg_u32 s8, 0
; GFX7-NEXT:    s_cselect_b32 s0, 1, 0
; GFX7-NEXT:    s_and_b32 s0, 1, s0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, s0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_and_b64 vcc, vcc, s[0:1]
; GFX7-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX7-NEXT:    v_div_fmas_f32 v0, v3, v4, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0 offset:8
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f32_logical_cond_to_vcc:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x0
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x30
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s6
; GFX8-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 4, v1
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v2, vcc
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 8, v1
; GFX8-NEXT:    v_addc_u32_e32 v6, vcc, 0, v2, vcc
; GFX8-NEXT:    flat_load_dword v1, v[1:2] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_load_dword v2, v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s4, 8
; GFX8-NEXT:    s_addc_u32 s1, s5, 0
; GFX8-NEXT:    s_cmp_lg_u32 s2, 0
; GFX8-NEXT:    s_cselect_b32 s2, 1, 0
; GFX8-NEXT:    s_and_b32 s2, 1, s2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    v_cmp_ne_u32_e64 s[2:3], 0, s2
; GFX8-NEXT:    s_and_b64 vcc, vcc, s[2:3]
; GFX8-NEXT:    s_nop 1
; GFX8-NEXT:    v_div_fmas_f32 v2, v1, v2, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f32_logical_cond_to_vcc:
; GFX10_W32:       ; %bb.0:
; GFX10_W32-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x0
; GFX10_W32-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX10_W32-NEXT:    s_load_dword s0, s[0:1], 0x30
; GFX10_W32-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    global_load_dword v2, v1, s[6:7] glc dlc
; GFX10_W32-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-NEXT:    global_load_dword v3, v1, s[6:7] offset:4 glc dlc
; GFX10_W32-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-NEXT:    global_load_dword v4, v1, s[6:7] offset:8 glc dlc
; GFX10_W32-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W32-NEXT:    s_cmp_lg_u32 s0, 0
; GFX10_W32-NEXT:    s_cselect_b32 s0, 1, 0
; GFX10_W32-NEXT:    s_and_b32 s0, 1, s0
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 s0, 0, s0
; GFX10_W32-NEXT:    s_and_b32 vcc_lo, vcc_lo, s0
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, v2, v3, v4
; GFX10_W32-NEXT:    global_store_dword v1, v0, s[4:5] offset:8
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f32_logical_cond_to_vcc:
; GFX10_W64:       ; %bb.0:
; GFX10_W64-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x0
; GFX10_W64-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX10_W64-NEXT:    s_load_dword s0, s[0:1], 0x30
; GFX10_W64-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    global_load_dword v2, v1, s[6:7] glc dlc
; GFX10_W64-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-NEXT:    global_load_dword v3, v1, s[6:7] offset:4 glc dlc
; GFX10_W64-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-NEXT:    global_load_dword v4, v1, s[6:7] offset:8 glc dlc
; GFX10_W64-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W64-NEXT:    s_cmp_lg_u32 s0, 0
; GFX10_W64-NEXT:    s_cselect_b32 s0, 1, 0
; GFX10_W64-NEXT:    s_and_b32 s0, 1, s0
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, s0
; GFX10_W64-NEXT:    s_and_b64 vcc, vcc, s[0:1]
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, v2, v3, v4
; GFX10_W64-NEXT:    global_store_dword v1, v0, s[4:5] offset:8
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f32_logical_cond_to_vcc:
; GFX11_W32:       ; %bb.0:
; GFX11_W32-NEXT:    s_load_b128 s[4:7], s[0:1], 0x0
; GFX11_W32-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX11_W32-NEXT:    s_load_b32 s0, s[0:1], 0x30
; GFX11_W32-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    global_load_b32 v2, v1, s[6:7] glc dlc
; GFX11_W32-NEXT:    s_waitcnt vmcnt(0)
; GFX11_W32-NEXT:    global_load_b32 v3, v1, s[6:7] offset:4 glc dlc
; GFX11_W32-NEXT:    s_waitcnt vmcnt(0)
; GFX11_W32-NEXT:    global_load_b32 v1, v1, s[6:7] offset:8 glc dlc
; GFX11_W32-NEXT:    s_waitcnt vmcnt(0)
; GFX11_W32-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11_W32-NEXT:    s_cselect_b32 s0, 1, 0
; GFX11_W32-NEXT:    s_and_b32 s0, 1, s0
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 s0, 0, s0
; GFX11_W32-NEXT:    s_and_b32 vcc_lo, vcc_lo, s0
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, v2, v3, v1
; GFX11_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W32-NEXT:    global_store_b32 v1, v0, s[4:5] offset:8
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f32_logical_cond_to_vcc:
; GFX11_W64:       ; %bb.0:
; GFX11_W64-NEXT:    s_load_b128 s[4:7], s[0:1], 0x0
; GFX11_W64-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX11_W64-NEXT:    s_load_b32 s0, s[0:1], 0x30
; GFX11_W64-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    global_load_b32 v2, v1, s[6:7] glc dlc
; GFX11_W64-NEXT:    s_waitcnt vmcnt(0)
; GFX11_W64-NEXT:    global_load_b32 v3, v1, s[6:7] offset:4 glc dlc
; GFX11_W64-NEXT:    s_waitcnt vmcnt(0)
; GFX11_W64-NEXT:    global_load_b32 v1, v1, s[6:7] offset:8 glc dlc
; GFX11_W64-NEXT:    s_waitcnt vmcnt(0)
; GFX11_W64-NEXT:    s_cmp_lg_u32 s0, 0
; GFX11_W64-NEXT:    s_cselect_b32 s0, 1, 0
; GFX11_W64-NEXT:    s_and_b32 s0, 1, s0
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 s[0:1], 0, s0
; GFX11_W64-NEXT:    s_and_b64 vcc, vcc, s[0:1]
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, v2, v3, v1
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W64-NEXT:    global_store_b32 v1, v0, s[4:5] offset:8
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.a = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.b = getelementptr float, ptr addrspace(1) %gep.a, i32 1
  %gep.c = getelementptr float, ptr addrspace(1) %gep.a, i32 2
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 2

  %a = load volatile float, ptr addrspace(1) %gep.a
  %b = load volatile float, ptr addrspace(1) %gep.b
  %c = load volatile float, ptr addrspace(1) %gep.c

  %cmp0 = icmp eq i32 %tid, 0
  %cmp1 = icmp ne i32 %d, 0
  %and = and i1 %cmp0, %cmp1

  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float %b, float %c, i1 %and)
  store float %result, ptr addrspace(1) %gep.out, align 4
  ret void
}

define amdgpu_kernel void @test_div_fmas_f32_i1_phi_vcc(ptr addrspace(1) %out, [8 x i32], ptr addrspace(1) %in, [8 x i32], ptr addrspace(1) %dummy) {
; GFX7-LABEL: test_div_fmas_f32_i1_phi_vcc:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0xa
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_load_dwordx3 v[1:3], v[1:2], s[4:7], 0 addr64
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX7-NEXT:    s_cbranch_execz .LBB13_2
; GFX7-NEXT:  ; %bb.1: ; %bb
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x14
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_cmp_lg_u32 s4, 0
; GFX7-NEXT:    s_cselect_b32 s6, 1, 0
; GFX7-NEXT:  .LBB13_2: ; %exit
; GFX7-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX7-NEXT:    s_and_b32 s0, 1, s6
; GFX7-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX7-NEXT:    s_mov_b32 s6, -1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_nop 1
; GFX7-NEXT:    v_div_fmas_f32 v0, v1, v2, v3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    buffer_store_dword v0, off, s[4:7], 0 offset:8
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: test_div_fmas_f32_i1_phi_vcc:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x28
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 2, v0
; GFX8-NEXT:    s_mov_b32 s4, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX8-NEXT:    flat_load_dwordx3 v[1:3], v[1:2]
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB13_2
; GFX8-NEXT:  ; %bb.1: ; %bb
; GFX8-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x50
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cmp_lg_u32 s4, 0
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:  .LBB13_2: ; %exit
; GFX8-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_add_u32 s0, s0, 8
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    s_and_b32 s2, 1, s4
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_nop 2
; GFX8-NEXT:    v_div_fmas_f32 v2, v1, v2, v3
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10_W32-LABEL: test_div_fmas_f32_i1_phi_vcc:
; GFX10_W32:       ; %bb.0: ; %entry
; GFX10_W32-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x28
; GFX10_W32-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX10_W32-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    global_load_dwordx3 v[1:3], v1, s[2:3]
; GFX10_W32-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10_W32-NEXT:    s_mov_b32 s2, 0
; GFX10_W32-NEXT:    s_and_saveexec_b32 s3, vcc_lo
; GFX10_W32-NEXT:    s_cbranch_execz .LBB13_2
; GFX10_W32-NEXT:  ; %bb.1: ; %bb
; GFX10_W32-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x50
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    s_cmp_lg_u32 s2, 0
; GFX10_W32-NEXT:    s_cselect_b32 s2, 1, 0
; GFX10_W32-NEXT:  .LBB13_2: ; %exit
; GFX10_W32-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX10_W32-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX10_W32-NEXT:    s_and_b32 s2, 1, s2
; GFX10_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s2
; GFX10_W32-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W32-NEXT:    v_div_fmas_f32 v0, v1, v2, v3
; GFX10_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W32-NEXT:    global_store_dword v1, v0, s[0:1] offset:8
; GFX10_W32-NEXT:    s_endpgm
;
; GFX10_W64-LABEL: test_div_fmas_f32_i1_phi_vcc:
; GFX10_W64:       ; %bb.0: ; %entry
; GFX10_W64-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x28
; GFX10_W64-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX10_W64-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX10_W64-NEXT:    s_mov_b32 s4, 0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    global_load_dwordx3 v[1:3], v1, s[2:3]
; GFX10_W64-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10_W64-NEXT:    s_and_saveexec_b64 s[2:3], vcc
; GFX10_W64-NEXT:    s_cbranch_execz .LBB13_2
; GFX10_W64-NEXT:  ; %bb.1: ; %bb
; GFX10_W64-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x50
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    s_cmp_lg_u32 s4, 0
; GFX10_W64-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10_W64-NEXT:  .LBB13_2: ; %exit
; GFX10_W64-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX10_W64-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX10_W64-NEXT:    s_and_b32 s2, 1, s4
; GFX10_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX10_W64-NEXT:    s_waitcnt vmcnt(0)
; GFX10_W64-NEXT:    v_div_fmas_f32 v0, v1, v2, v3
; GFX10_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX10_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10_W64-NEXT:    global_store_dword v1, v0, s[0:1] offset:8
; GFX10_W64-NEXT:    s_endpgm
;
; GFX11_W32-LABEL: test_div_fmas_f32_i1_phi_vcc:
; GFX11_W32:       ; %bb.0: ; %entry
; GFX11_W32-NEXT:    s_load_b64 s[2:3], s[0:1], 0x28
; GFX11_W32-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    global_load_b96 v[1:3], v1, s[2:3]
; GFX11_W32-NEXT:    s_mov_b32 s2, 0
; GFX11_W32-NEXT:    s_mov_b32 s3, exec_lo
; GFX11_W32-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX11_W32-NEXT:    s_cbranch_execz .LBB13_2
; GFX11_W32-NEXT:  ; %bb.1: ; %bb
; GFX11_W32-NEXT:    s_load_b64 s[4:5], s[0:1], 0x50
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    s_load_b32 s2, s[4:5], 0x0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    s_cmp_lg_u32 s2, 0
; GFX11_W32-NEXT:    s_cselect_b32 s2, 1, 0
; GFX11_W32-NEXT:  .LBB13_2: ; %exit
; GFX11_W32-NEXT:    s_or_b32 exec_lo, exec_lo, s3
; GFX11_W32-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W32-NEXT:    s_and_b32 s2, 1, s2
; GFX11_W32-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s2
; GFX11_W32-NEXT:    s_waitcnt vmcnt(0)
; GFX11_W32-NEXT:    v_div_fmas_f32 v0, v1, v2, v3
; GFX11_W32-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W32-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W32-NEXT:    global_store_b32 v1, v0, s[0:1] offset:8
; GFX11_W32-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W32-NEXT:    s_endpgm
;
; GFX11_W64-LABEL: test_div_fmas_f32_i1_phi_vcc:
; GFX11_W64:       ; %bb.0: ; %entry
; GFX11_W64-NEXT:    s_load_b64 s[2:3], s[0:1], 0x28
; GFX11_W64-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX11_W64-NEXT:    s_mov_b32 s4, 0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    global_load_b96 v[1:3], v1, s[2:3]
; GFX11_W64-NEXT:    s_mov_b64 s[2:3], exec
; GFX11_W64-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX11_W64-NEXT:    s_cbranch_execz .LBB13_2
; GFX11_W64-NEXT:  ; %bb.1: ; %bb
; GFX11_W64-NEXT:    s_load_b64 s[4:5], s[0:1], 0x50
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    s_load_b32 s4, s[4:5], 0x0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    s_cmp_lg_u32 s4, 0
; GFX11_W64-NEXT:    s_cselect_b32 s4, 1, 0
; GFX11_W64-NEXT:  .LBB13_2: ; %exit
; GFX11_W64-NEXT:    s_or_b64 exec, exec, s[2:3]
; GFX11_W64-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GFX11_W64-NEXT:    s_and_b32 s2, 1, s4
; GFX11_W64-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s2
; GFX11_W64-NEXT:    s_waitcnt vmcnt(0)
; GFX11_W64-NEXT:    v_div_fmas_f32 v0, v1, v2, v3
; GFX11_W64-NEXT:    v_mov_b32_e32 v1, 0
; GFX11_W64-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11_W64-NEXT:    global_store_b32 v1, v0, s[0:1] offset:8
; GFX11_W64-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11_W64-NEXT:    s_endpgm
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.a = getelementptr float, ptr addrspace(1) %in, i32 %tid
  %gep.b = getelementptr float, ptr addrspace(1) %gep.a, i32 1
  %gep.c = getelementptr float, ptr addrspace(1) %gep.a, i32 2

  %a = load float, ptr addrspace(1) %gep.a
  %b = load float, ptr addrspace(1) %gep.b
  %c = load float, ptr addrspace(1) %gep.c

  %cmp0 = icmp eq i32 %tid, 0
  br i1 %cmp0, label %bb, label %exit

bb:
  %val = load i32, ptr addrspace(1) %dummy
  %cmp1 = icmp ne i32 %val, 0
  br label %exit

exit:
  %cond = phi i1 [false, %entry], [%cmp1, %bb]
  %gep.out = getelementptr float, ptr addrspace(1) %out, i32 2
  %result = call float @llvm.amdgcn.div.fmas.f32(float %a, float %b, float %c, i1 %cond)
  store float %result, ptr addrspace(1) %gep.out, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #0
declare float @llvm.amdgcn.div.fmas.f32(float, float, float, i1) #0
declare double @llvm.amdgcn.div.fmas.f64(double, double, double, i1) #0

attributes #0 = { nounwind readnone speculatable }
