; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=hawaii -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX7 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10 %s

define amdgpu_ps i8 @extractelement_sgpr_v4i8_sgpr_idx(<4 x i8> addrspace(4)* inreg %ptr, i32 inreg %idx) {
; GCN-LABEL: extractelement_sgpr_v4i8_sgpr_idx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s0, s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GCN-NEXT:    s_lshr_b32 s1, s0, 24
; GCN-NEXT:    s_and_b32 s2, s0, 0xff
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_lshl_b32 s1, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    s_and_b32 s1, s4, 3
; GCN-NEXT:    s_lshl_b32 s1, s1, 3
; GCN-NEXT:    s_lshr_b32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v4i8_sgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX10-NEXT:    s_lshr_b32 s1, s0, 24
; GFX10-NEXT:    s_and_b32 s2, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s3, s3, 8
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_or_b32 s2, s2, s3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s2, s0
; GFX10-NEXT:    s_and_b32 s2, s4, 3
; GFX10-NEXT:    s_or_b32 s0, s0, s1
; GFX10-NEXT:    s_lshl_b32 s1, s2, 3
; GFX10-NEXT:    s_lshr_b32 s0, s0, s1
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %element = extractelement <4 x i8> %vector, i32 %idx
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_vgpr_v4i8_sgpr_idx(<4 x i8> addrspace(1)* %ptr, i32 inreg %idx) {
; GFX9-LABEL: extractelement_vgpr_v4i8_sgpr_idx:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    s_and_b32 s0, s2, 3
; GFX9-NEXT:    s_lshl_b32 s0, s0, 3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: extractelement_vgpr_v4i8_sgpr_idx:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    s_and_b32 s0, s2, 3
; GFX8-NEXT:    s_lshl_b32 s0, s0, 3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX7-LABEL: extractelement_vgpr_v4i8_sgpr_idx:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_and_b32 s0, s2, 3
; GFX7-NEXT:    s_lshl_b32 s0, s0, 3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_readfirstlane_b32 s0, v0
; GFX7-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_vgpr_v4i8_sgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    s_and_b32 s0, s2, 3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 3
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %element = extractelement <4 x i8> %vector, i32 %idx
  ret i8 %element
}

define i8 @extractelement_vgpr_v4i8_vgpr_idx(<4 x i8> addrspace(1)* %ptr, i32 %idx) {
; GFX9-LABEL: extractelement_vgpr_v4i8_vgpr_idx:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v3, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v4, 16
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v5
; GFX9-NEXT:    v_or3_b32 v0, v0, v4, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v4i8_vgpr_idx:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v3, 16
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v4i8_vgpr_idx:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v1, 3, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v4, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v3, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v4i8_vgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_mov_b32_e32 v3, 16
; GFX10-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX10-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %element = extractelement <4 x i8> %vector, i32 %idx
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v4i8_vgpr_idx(<4 x i8> addrspace(4)* inreg %ptr, i32 %idx) {
; GFX9-LABEL: extractelement_sgpr_v4i8_vgpr_idx:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX9-NEXT:    s_lshr_b32 s1, s0, 24
; GFX9-NEXT:    s_and_b32 s2, s0, 0xff
; GFX9-NEXT:    s_lshl_b32 s3, s3, 8
; GFX9-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX9-NEXT:    s_or_b32 s2, s2, s3
; GFX9-NEXT:    s_lshl_b32 s0, s0, 16
; GFX9-NEXT:    s_or_b32 s0, s2, s0
; GFX9-NEXT:    s_lshl_b32 s1, s1, 24
; GFX9-NEXT:    s_or_b32 s0, s0, s1
; GFX9-NEXT:    v_lshrrev_b32_e64 v0, v0, s0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: extractelement_sgpr_v4i8_vgpr_idx:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX8-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX8-NEXT:    s_lshr_b32 s1, s0, 24
; GFX8-NEXT:    s_and_b32 s2, s0, 0xff
; GFX8-NEXT:    s_lshl_b32 s3, s3, 8
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX8-NEXT:    s_or_b32 s2, s2, s3
; GFX8-NEXT:    s_lshl_b32 s0, s0, 16
; GFX8-NEXT:    s_or_b32 s0, s2, s0
; GFX8-NEXT:    s_lshl_b32 s1, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    v_lshrrev_b32_e64 v0, v0, s0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX7-LABEL: extractelement_sgpr_v4i8_vgpr_idx:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX7-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GFX7-NEXT:    s_lshr_b32 s1, s0, 24
; GFX7-NEXT:    s_and_b32 s2, s0, 0xff
; GFX7-NEXT:    s_lshl_b32 s3, s3, 8
; GFX7-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GFX7-NEXT:    s_or_b32 s2, s2, s3
; GFX7-NEXT:    s_lshl_b32 s0, s0, 16
; GFX7-NEXT:    s_or_b32 s0, s2, s0
; GFX7-NEXT:    s_lshl_b32 s1, s1, 24
; GFX7-NEXT:    s_or_b32 s0, s0, s1
; GFX7-NEXT:    v_lshr_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_readfirstlane_b32 s0, v0
; GFX7-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v4i8_vgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s2
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    v_lshrrev_b32_e64 v0, v0, s0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %element = extractelement <4 x i8> %vector, i32 %idx
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v4i8_idx0(<4 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v4i8_idx0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s0, s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GCN-NEXT:    s_lshr_b32 s1, s0, 24
; GCN-NEXT:    s_and_b32 s2, s0, 0xff
; GCN-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_lshl_b32 s1, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v4i8_idx0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s2
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %element = extractelement <4 x i8> %vector, i32 0
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v4i8_idx1(<4 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v4i8_idx1:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s0, s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GCN-NEXT:    s_lshr_b32 s1, s0, 24
; GCN-NEXT:    s_and_b32 s2, s0, 0xff
; GCN-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_lshl_b32 s1, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    s_lshr_b32 s0, s0, 8
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v4i8_idx1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s2
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    s_lshr_b32 s0, s0, 8
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %element = extractelement <4 x i8> %vector, i32 1
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v4i8_idx2(<4 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v4i8_idx2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s0, s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GCN-NEXT:    s_lshr_b32 s1, s0, 24
; GCN-NEXT:    s_and_b32 s2, s0, 0xff
; GCN-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_lshl_b32 s1, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    s_lshr_b32 s0, s0, 16
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v4i8_idx2:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s2
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    s_lshr_b32 s0, s0, 16
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %element = extractelement <4 x i8> %vector, i32 2
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v4i8_idx3(<4 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v4i8_idx3:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s0, s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GCN-NEXT:    s_lshr_b32 s1, s0, 24
; GCN-NEXT:    s_and_b32 s2, s0, 0xff
; GCN-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_lshl_b32 s1, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    s_lshr_b32 s0, s0, 24
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v4i8_idx3:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s2
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <4 x i8>, <4 x i8> addrspace(4)* %ptr
  %element = extractelement <4 x i8> %vector, i32 3
  ret i8 %element
}

define i8 @extractelement_vgpr_v4i8_idx0(<4 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v4i8_idx0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v4i8_idx0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v4i8_idx0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v4i8_idx0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %element = extractelement <4 x i8> %vector, i32 0
  ret i8 %element
}

define i8 @extractelement_vgpr_v4i8_idx1(<4 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v4i8_idx1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v2, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v4i8_idx1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v4i8_idx1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v4i8_idx1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %element = extractelement <4 x i8> %vector, i32 1
  ret i8 %element
}

define i8 @extractelement_vgpr_v4i8_idx2(<4 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v4i8_idx2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_mov_b32 s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v4, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v4i8_idx2:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v4i8_idx2:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v4i8_idx2:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    s_mov_b32 s4, 16
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX10-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %element = extractelement <4 x i8> %vector, i32 2
  ret i8 %element
}

define i8 @extractelement_vgpr_v4i8_idx3(<4 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v4i8_idx3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v4i8_idx3:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v4i8_idx3:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v4i8_idx3:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dword v0, v[0:1], off
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <4 x i8>, <4 x i8> addrspace(1)* %ptr
  %element = extractelement <4 x i8> %vector, i32 3
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_sgpr_idx(<8 x i8> addrspace(4)* inreg %ptr, i32 inreg %idx) {
; GCN-LABEL: extractelement_sgpr_v8i8_sgpr_idx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_mov_b32 s7, 0x80008
; GCN-NEXT:    s_movk_i32 s2, 0xff
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s8, s0, s7
; GCN-NEXT:    s_and_b32 s6, s0, s2
; GCN-NEXT:    s_lshl_b32 s8, s8, 8
; GCN-NEXT:    s_or_b32 s6, s6, s8
; GCN-NEXT:    s_mov_b32 s8, 0x80010
; GCN-NEXT:    s_lshr_b32 s3, s0, 24
; GCN-NEXT:    s_bfe_u32 s0, s0, s8
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s6, s0
; GCN-NEXT:    s_lshl_b32 s3, s3, 24
; GCN-NEXT:    s_or_b32 s0, s0, s3
; GCN-NEXT:    s_bfe_u32 s3, s1, s7
; GCN-NEXT:    s_lshr_b32 s5, s1, 24
; GCN-NEXT:    s_and_b32 s2, s1, s2
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_bfe_u32 s1, s1, s8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s1, s1, 16
; GCN-NEXT:    s_or_b32 s1, s2, s1
; GCN-NEXT:    s_lshl_b32 s2, s5, 24
; GCN-NEXT:    s_or_b32 s1, s1, s2
; GCN-NEXT:    s_lshr_b32 s2, s4, 2
; GCN-NEXT:    s_cmp_eq_u32 s2, 1
; GCN-NEXT:    s_cselect_b32 s0, s1, s0
; GCN-NEXT:    s_and_b32 s1, s4, 3
; GCN-NEXT:    s_lshl_b32 s1, s1, 3
; GCN-NEXT:    s_lshr_b32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_sgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_mov_b32 s3, 0x80008
; GFX10-NEXT:    s_movk_i32 s2, 0xff
; GFX10-NEXT:    s_mov_b32 s5, 0x80010
; GFX10-NEXT:    s_lshr_b32 s6, s4, 2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s10, s0, s3
; GFX10-NEXT:    s_bfe_u32 s3, s1, s3
; GFX10-NEXT:    s_lshr_b32 s7, s0, 24
; GFX10-NEXT:    s_lshr_b32 s8, s1, 24
; GFX10-NEXT:    s_and_b32 s9, s0, s2
; GFX10-NEXT:    s_bfe_u32 s0, s0, s5
; GFX10-NEXT:    s_and_b32 s2, s1, s2
; GFX10-NEXT:    s_bfe_u32 s1, s1, s5
; GFX10-NEXT:    s_lshl_b32 s5, s10, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 8
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s5, s9, s5
; GFX10-NEXT:    s_or_b32 s2, s2, s3
; GFX10-NEXT:    s_lshl_b32 s7, s7, 24
; GFX10-NEXT:    s_lshl_b32 s8, s8, 24
; GFX10-NEXT:    s_or_b32 s0, s5, s0
; GFX10-NEXT:    s_or_b32 s1, s2, s1
; GFX10-NEXT:    s_or_b32 s0, s0, s7
; GFX10-NEXT:    s_or_b32 s1, s1, s8
; GFX10-NEXT:    s_cmp_eq_u32 s6, 1
; GFX10-NEXT:    s_cselect_b32 s0, s1, s0
; GFX10-NEXT:    s_and_b32 s1, s4, 3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 3
; GFX10-NEXT:    s_lshr_b32 s0, s0, s1
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 %idx
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_vgpr_v8i8_sgpr_idx(<8 x i8> addrspace(1)* %ptr, i32 inreg %idx) {
; GFX9-LABEL: extractelement_vgpr_v8i8_sgpr_idx:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    s_lshr_b32 s4, s2, 2
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_and_or_b32 v1, v1, s3, v6
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v5, v2
; GFX9-NEXT:    v_or3_b32 v1, v1, v7, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    s_lshl_b32 s0, s2, 3
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: extractelement_vgpr_v8i8_sgpr_idx:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    v_mov_b32_e32 v3, 16
; GFX8-NEXT:    s_lshr_b32 s0, s2, 2
; GFX8-NEXT:    s_and_b32 s1, s2, 3
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX8-NEXT:    s_lshl_b32 s0, s1, 3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 24, v5
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v7
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX7-LABEL: extractelement_vgpr_v8i8_sgpr_idx:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s0, 0xff
; GFX7-NEXT:    s_lshr_b32 s1, s2, 2
; GFX7-NEXT:    s_and_b32 s2, s2, 3
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v5, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v7, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v4, s0, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v6, s0, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 8, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 8, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_or_b32_e32 v5, v6, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v5, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    s_lshl_b32 s0, s2, 3
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_readfirstlane_b32 s0, v0
; GFX7-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_vgpr_v8i8_sgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    s_movk_i32 s3, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, s3, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_and_or_b32 v1, v1, s3, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v4
; GFX10-NEXT:    s_lshr_b32 s0, s2, 2
; GFX10-NEXT:    v_or3_b32 v0, v0, v6, v2
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 1
; GFX10-NEXT:    v_or3_b32 v1, v1, v7, v3
; GFX10-NEXT:    s_and_b32 s0, s2, 3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 %idx
  ret i8 %element
}

define i8 @extractelement_vgpr_v8i8_vgpr_idx(<8 x i8> addrspace(1)* %ptr, i32 %idx) {
; GFX9-LABEL: extractelement_vgpr_v8i8_vgpr_idx:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    s_mov_b32 s5, 16
; GFX9-NEXT:    s_movk_i32 s6, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 2, v2
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v8, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, s5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v9, s5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, s6, v6
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX9-NEXT:    v_and_or_b32 v1, v1, s6, v8
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX9-NEXT:    v_or3_b32 v0, v0, v7, v4
; GFX9-NEXT:    v_or3_b32 v1, v1, v9, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v8i8_vgpr_idx:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    v_mov_b32_e32 v4, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 2, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v5
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v9, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 24, v7
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v9
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v8i8_vgpr_idx:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s4, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 2, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v7, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v9, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v6, s4, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v8, s4, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 8, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v8, v9
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 24, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_or_b32_e32 v0, v6, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v7, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v8i8_vgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    s_mov_b32 s5, 16
; GFX10-NEXT:    s_movk_i32 s6, 0xff
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v4, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v6, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, s5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v8, s5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v0, s6, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 24, v3
; GFX10-NEXT:    v_and_or_b32 v1, v1, s6, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 24, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 2, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX10-NEXT:    v_or3_b32 v0, v0, v7, v3
; GFX10-NEXT:    v_or3_b32 v1, v1, v8, v4
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 %idx
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_vgpr_idx(<8 x i8> addrspace(4)* inreg %ptr, i32 %idx) {
; GCN-LABEL: extractelement_sgpr_v8i8_vgpr_idx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_mov_b32 s6, 0x80008
; GCN-NEXT:    s_movk_i32 s2, 0xff
; GCN-NEXT:    v_lshrrev_b32_e32 v1, 2, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s7, s0, s6
; GCN-NEXT:    s_and_b32 s5, s0, s2
; GCN-NEXT:    s_lshl_b32 s7, s7, 8
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_mov_b32 s7, 0x80010
; GCN-NEXT:    s_lshr_b32 s3, s0, 24
; GCN-NEXT:    s_bfe_u32 s0, s0, s7
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s5, s0
; GCN-NEXT:    s_lshl_b32 s3, s3, 24
; GCN-NEXT:    s_or_b32 s0, s0, s3
; GCN-NEXT:    s_bfe_u32 s3, s1, s6
; GCN-NEXT:    s_lshr_b32 s4, s1, 24
; GCN-NEXT:    s_and_b32 s2, s1, s2
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_bfe_u32 s1, s1, s7
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s1, s1, 16
; GCN-NEXT:    s_or_b32 s1, s2, s1
; GCN-NEXT:    s_lshl_b32 s2, s4, 24
; GCN-NEXT:    s_or_b32 s1, s1, s2
; GCN-NEXT:    v_mov_b32_e32 v2, s0
; GCN-NEXT:    v_mov_b32_e32 v3, s1
; GCN-NEXT:    v_and_b32_e32 v0, 3, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_lshrrev_b32_e32 v0, v0, v1
; GCN-NEXT:    v_readfirstlane_b32 s0, v0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_vgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_mov_b32 s3, 0x80008
; GFX10-NEXT:    s_movk_i32 s2, 0xff
; GFX10-NEXT:    s_mov_b32 s4, 0x80010
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 2, v0
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s8, s0, s3
; GFX10-NEXT:    s_bfe_u32 s3, s1, s3
; GFX10-NEXT:    s_lshr_b32 s6, s1, 24
; GFX10-NEXT:    s_and_b32 s7, s0, s2
; GFX10-NEXT:    s_and_b32 s2, s1, s2
; GFX10-NEXT:    s_bfe_u32 s1, s1, s4
; GFX10-NEXT:    s_lshl_b32 s3, s3, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s2, s2, s3
; GFX10-NEXT:    s_lshl_b32 s3, s6, 24
; GFX10-NEXT:    s_or_b32 s1, s2, s1
; GFX10-NEXT:    s_lshr_b32 s5, s0, 24
; GFX10-NEXT:    s_bfe_u32 s0, s0, s4
; GFX10-NEXT:    s_lshl_b32 s4, s8, 8
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_or_b32 s3, s7, s4
; GFX10-NEXT:    v_mov_b32_e32 v2, s1
; GFX10-NEXT:    s_lshl_b32 s2, s5, 24
; GFX10-NEXT:    s_or_b32 s0, s3, s0
; GFX10-NEXT:    s_or_b32 s0, s0, s2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, s0, v2, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v0, v1
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 %idx
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_idx0(<8 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v8i8_idx0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GCN-NEXT:    s_lshr_b32 s1, s0, 24
; GCN-NEXT:    s_and_b32 s2, s0, 0xff
; GCN-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_lshl_b32 s1, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_idx0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s2
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 0
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_idx1(<8 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v8i8_idx1:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GCN-NEXT:    s_lshr_b32 s1, s0, 24
; GCN-NEXT:    s_and_b32 s2, s0, 0xff
; GCN-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_lshl_b32 s1, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    s_lshr_b32 s0, s0, 8
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_idx1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s2
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    s_lshr_b32 s0, s0, 8
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 1
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_idx2(<8 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v8i8_idx2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GCN-NEXT:    s_lshr_b32 s1, s0, 24
; GCN-NEXT:    s_and_b32 s2, s0, 0xff
; GCN-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_lshl_b32 s1, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    s_lshr_b32 s0, s0, 16
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_idx2:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s2
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    s_lshr_b32 s0, s0, 16
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 2
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_idx3(<8 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v8i8_idx3:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s0, 0x80008
; GCN-NEXT:    s_lshr_b32 s1, s0, 24
; GCN-NEXT:    s_and_b32 s2, s0, 0xff
; GCN-NEXT:    s_bfe_u32 s0, s0, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    s_lshl_b32 s1, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    s_lshr_b32 s0, s0, 24
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_idx3:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s0, 0x80008
; GFX10-NEXT:    s_and_b32 s1, s0, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s0, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s1, s1, s2
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s1, s1, s3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 24
; GFX10-NEXT:    s_or_b32 s0, s1, s0
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 3
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_idx4(<8 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v8i8_idx4:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s1, 0x80008
; GCN-NEXT:    s_lshr_b32 s0, s1, 24
; GCN-NEXT:    s_and_b32 s2, s1, 0xff
; GCN-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s1, s1, 16
; GCN-NEXT:    s_or_b32 s1, s2, s1
; GCN-NEXT:    s_lshl_b32 s0, s0, 24
; GCN-NEXT:    s_or_b32 s0, s1, s0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_idx4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s1, 0x80008
; GFX10-NEXT:    s_and_b32 s0, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s0, s0, s2
; GFX10-NEXT:    s_lshr_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s0, s3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s0, s1
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 4
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_idx5(<8 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v8i8_idx5:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s1, 0x80008
; GCN-NEXT:    s_lshr_b32 s0, s1, 24
; GCN-NEXT:    s_and_b32 s2, s1, 0xff
; GCN-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s1, s1, 16
; GCN-NEXT:    s_or_b32 s1, s2, s1
; GCN-NEXT:    s_lshl_b32 s0, s0, 24
; GCN-NEXT:    s_or_b32 s0, s1, s0
; GCN-NEXT:    s_lshr_b32 s0, s0, 8
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_idx5:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s1, 0x80008
; GFX10-NEXT:    s_and_b32 s0, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s0, s0, s2
; GFX10-NEXT:    s_lshr_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s0, s3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s0, s1
; GFX10-NEXT:    s_lshr_b32 s0, s0, 8
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 5
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_idx6(<8 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v8i8_idx6:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s1, 0x80008
; GCN-NEXT:    s_lshr_b32 s0, s1, 24
; GCN-NEXT:    s_and_b32 s2, s1, 0xff
; GCN-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s1, s1, 16
; GCN-NEXT:    s_or_b32 s1, s2, s1
; GCN-NEXT:    s_lshl_b32 s0, s0, 24
; GCN-NEXT:    s_or_b32 s0, s1, s0
; GCN-NEXT:    s_lshr_b32 s0, s0, 16
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_idx6:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s1, 0x80008
; GFX10-NEXT:    s_and_b32 s0, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s0, s0, s2
; GFX10-NEXT:    s_lshr_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s0, s3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s0, s1
; GFX10-NEXT:    s_lshr_b32 s0, s0, 16
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 6
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v8i8_idx7(<8 x i8> addrspace(4)* inreg %ptr) {
; GCN-LABEL: extractelement_sgpr_v8i8_idx7:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s3, s1, 0x80008
; GCN-NEXT:    s_lshr_b32 s0, s1, 24
; GCN-NEXT:    s_and_b32 s2, s1, 0xff
; GCN-NEXT:    s_bfe_u32 s1, s1, 0x80010
; GCN-NEXT:    s_lshl_b32 s3, s3, 8
; GCN-NEXT:    s_or_b32 s2, s2, s3
; GCN-NEXT:    s_lshl_b32 s1, s1, 16
; GCN-NEXT:    s_or_b32 s1, s2, s1
; GCN-NEXT:    s_lshl_b32 s0, s0, 24
; GCN-NEXT:    s_or_b32 s0, s1, s0
; GCN-NEXT:    s_lshr_b32 s0, s0, 24
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v8i8_idx7:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s2, s1, 0x80008
; GFX10-NEXT:    s_and_b32 s0, s1, 0xff
; GFX10-NEXT:    s_bfe_u32 s3, s1, 0x80010
; GFX10-NEXT:    s_lshl_b32 s2, s2, 8
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_or_b32 s0, s0, s2
; GFX10-NEXT:    s_lshr_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s0, s3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 24
; GFX10-NEXT:    s_or_b32 s0, s0, s1
; GFX10-NEXT:    s_lshr_b32 s0, s0, 24
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <8 x i8>, <8 x i8> addrspace(4)* %ptr
  %element = extractelement <8 x i8> %vector, i32 7
  ret i8 %element
}

define i8 @extractelement_vgpr_v8i8_idx0(<8 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v8i8_idx0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v8i8_idx0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v8i8_idx0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v8i8_idx0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 0
  ret i8 %element
}

define i8 @extractelement_vgpr_v8i8_idx1(<8 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v8i8_idx1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v2, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v8i8_idx1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v8i8_idx1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v8i8_idx1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 1
  ret i8 %element
}

define i8 @extractelement_vgpr_v8i8_idx2(<8 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v8i8_idx2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_mov_b32 s4, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v4, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v8i8_idx2:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v8i8_idx2:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v8i8_idx2:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    s_mov_b32 s4, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX10-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 2
  ret i8 %element
}

define i8 @extractelement_vgpr_v8i8_idx3(<8 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v8i8_idx3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v8i8_idx3:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v8i8_idx3:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v8i8_idx3:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 3
  ret i8 %element
}

define i8 @extractelement_vgpr_v8i8_idx4(<8 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v8i8_idx4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v1, v0, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v8i8_idx4:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v8i8_idx4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v8i8_idx4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v1, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 4
  ret i8 %element
}

define i8 @extractelement_vgpr_v8i8_idx5(<8 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v8i8_idx5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v2, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v1, v0, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v8i8_idx5:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v8i8_idx5:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v8i8_idx5:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v1, 0xff, v1, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v1, v0, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 5
  ret i8 %element
}

define i8 @extractelement_vgpr_v8i8_idx6(<8 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v8i8_idx6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_mov_b32 s4, 16
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v1, v0, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v4, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v8i8_idx6:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v8i8_idx6:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v8i8_idx6:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    s_mov_b32 s4, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v1, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX10-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 6
  ret i8 %element
}

define i8 @extractelement_vgpr_v8i8_idx7(<8 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v8i8_idx7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v1, v0, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v8i8_idx7:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v8i8_idx7:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v8i8_idx7:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx2 v[0:1], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v1, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <8 x i8>, <8 x i8> addrspace(1)* %ptr
  %element = extractelement <8 x i8> %vector, i32 7
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v16i8_sgpr_idx(<16 x i8> addrspace(4)* inreg %ptr, i32 inreg %idx) {
; GCN-LABEL: extractelement_sgpr_v16i8_sgpr_idx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GCN-NEXT:    s_mov_b32 s11, 0x80008
; GCN-NEXT:    s_movk_i32 s9, 0xff
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s12, s0, s11
; GCN-NEXT:    s_and_b32 s10, s0, s9
; GCN-NEXT:    s_lshl_b32 s12, s12, 8
; GCN-NEXT:    s_or_b32 s10, s10, s12
; GCN-NEXT:    s_mov_b32 s12, 0x80010
; GCN-NEXT:    s_lshr_b32 s5, s0, 24
; GCN-NEXT:    s_bfe_u32 s0, s0, s12
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s10, s0
; GCN-NEXT:    s_lshl_b32 s5, s5, 24
; GCN-NEXT:    s_bfe_u32 s10, s1, s11
; GCN-NEXT:    s_lshr_b32 s6, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s5
; GCN-NEXT:    s_and_b32 s5, s1, s9
; GCN-NEXT:    s_lshl_b32 s10, s10, 8
; GCN-NEXT:    s_bfe_u32 s1, s1, s12
; GCN-NEXT:    s_or_b32 s5, s5, s10
; GCN-NEXT:    s_lshl_b32 s1, s1, 16
; GCN-NEXT:    s_or_b32 s1, s5, s1
; GCN-NEXT:    s_lshl_b32 s5, s6, 24
; GCN-NEXT:    s_bfe_u32 s6, s2, s11
; GCN-NEXT:    s_lshr_b32 s7, s2, 24
; GCN-NEXT:    s_or_b32 s1, s1, s5
; GCN-NEXT:    s_and_b32 s5, s2, s9
; GCN-NEXT:    s_lshl_b32 s6, s6, 8
; GCN-NEXT:    s_bfe_u32 s2, s2, s12
; GCN-NEXT:    s_or_b32 s5, s5, s6
; GCN-NEXT:    s_lshl_b32 s2, s2, 16
; GCN-NEXT:    s_or_b32 s2, s5, s2
; GCN-NEXT:    s_lshl_b32 s5, s7, 24
; GCN-NEXT:    s_bfe_u32 s6, s3, s11
; GCN-NEXT:    s_lshr_b32 s8, s3, 24
; GCN-NEXT:    s_or_b32 s2, s2, s5
; GCN-NEXT:    s_and_b32 s5, s3, s9
; GCN-NEXT:    s_lshl_b32 s6, s6, 8
; GCN-NEXT:    s_bfe_u32 s3, s3, s12
; GCN-NEXT:    s_or_b32 s5, s5, s6
; GCN-NEXT:    s_lshl_b32 s3, s3, 16
; GCN-NEXT:    s_or_b32 s3, s5, s3
; GCN-NEXT:    s_lshl_b32 s5, s8, 24
; GCN-NEXT:    s_or_b32 s3, s3, s5
; GCN-NEXT:    s_lshr_b32 s5, s4, 2
; GCN-NEXT:    s_cmp_eq_u32 s5, 1
; GCN-NEXT:    s_cselect_b32 s0, s1, s0
; GCN-NEXT:    s_cmp_eq_u32 s5, 2
; GCN-NEXT:    s_cselect_b32 s0, s2, s0
; GCN-NEXT:    s_cmp_eq_u32 s5, 3
; GCN-NEXT:    s_cselect_b32 s0, s3, s0
; GCN-NEXT:    s_and_b32 s1, s4, 3
; GCN-NEXT:    s_lshl_b32 s1, s1, 3
; GCN-NEXT:    s_lshr_b32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v16i8_sgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    s_mov_b32 s6, 0x80008
; GFX10-NEXT:    s_movk_i32 s5, 0xff
; GFX10-NEXT:    s_mov_b32 s7, 0x80010
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s13, s0, s6
; GFX10-NEXT:    s_lshr_b32 s8, s0, 24
; GFX10-NEXT:    s_and_b32 s12, s0, s5
; GFX10-NEXT:    s_bfe_u32 s0, s0, s7
; GFX10-NEXT:    s_lshl_b32 s13, s13, 8
; GFX10-NEXT:    s_bfe_u32 s15, s1, s6
; GFX10-NEXT:    s_bfe_u32 s17, s2, s6
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_or_b32 s12, s12, s13
; GFX10-NEXT:    s_bfe_u32 s6, s3, s6
; GFX10-NEXT:    s_lshr_b32 s9, s1, 24
; GFX10-NEXT:    s_lshr_b32 s10, s2, 24
; GFX10-NEXT:    s_lshr_b32 s11, s3, 24
; GFX10-NEXT:    s_and_b32 s14, s1, s5
; GFX10-NEXT:    s_bfe_u32 s1, s1, s7
; GFX10-NEXT:    s_and_b32 s16, s2, s5
; GFX10-NEXT:    s_lshl_b32 s8, s8, 24
; GFX10-NEXT:    s_lshl_b32 s15, s15, 8
; GFX10-NEXT:    s_lshl_b32 s17, s17, 8
; GFX10-NEXT:    s_or_b32 s0, s12, s0
; GFX10-NEXT:    s_bfe_u32 s2, s2, s7
; GFX10-NEXT:    s_and_b32 s5, s3, s5
; GFX10-NEXT:    s_lshl_b32 s6, s6, 8
; GFX10-NEXT:    s_bfe_u32 s3, s3, s7
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s13, s14, s15
; GFX10-NEXT:    s_or_b32 s0, s0, s8
; GFX10-NEXT:    s_or_b32 s8, s16, s17
; GFX10-NEXT:    s_lshl_b32 s2, s2, 16
; GFX10-NEXT:    s_or_b32 s5, s5, s6
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    s_lshl_b32 s9, s9, 24
; GFX10-NEXT:    s_or_b32 s1, s13, s1
; GFX10-NEXT:    s_or_b32 s2, s8, s2
; GFX10-NEXT:    s_lshl_b32 s8, s10, 24
; GFX10-NEXT:    s_or_b32 s3, s5, s3
; GFX10-NEXT:    s_lshl_b32 s5, s11, 24
; GFX10-NEXT:    s_lshr_b32 s6, s4, 2
; GFX10-NEXT:    s_or_b32 s1, s1, s9
; GFX10-NEXT:    s_or_b32 s2, s2, s8
; GFX10-NEXT:    s_or_b32 s3, s3, s5
; GFX10-NEXT:    s_cmp_eq_u32 s6, 1
; GFX10-NEXT:    s_cselect_b32 s0, s1, s0
; GFX10-NEXT:    s_cmp_eq_u32 s6, 2
; GFX10-NEXT:    s_cselect_b32 s0, s2, s0
; GFX10-NEXT:    s_cmp_eq_u32 s6, 3
; GFX10-NEXT:    s_cselect_b32 s0, s3, s0
; GFX10-NEXT:    s_and_b32 s1, s4, 3
; GFX10-NEXT:    s_lshl_b32 s1, s1, 3
; GFX10-NEXT:    s_lshr_b32 s0, s0, s1
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %element = extractelement <16 x i8> %vector, i32 %idx
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_vgpr_v16i8_sgpr_idx(<16 x i8> addrspace(1)* %ptr, i32 inreg %idx) {
; GFX9-LABEL: extractelement_vgpr_v16i8_sgpr_idx:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s0, 8
; GFX9-NEXT:    s_mov_b32 s1, 16
; GFX9-NEXT:    s_movk_i32 s3, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v5, 8
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v6, 16
; GFX9-NEXT:    s_lshr_b32 s4, s2, 2
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 1
; GFX9-NEXT:    s_and_b32 s2, s2, 3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v11, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v12, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v0, v0, s3, v11
; GFX9-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX9-NEXT:    v_and_or_b32 v1, v1, s3, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, v6, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v5, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v2, v2, v4, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_or3_b32 v0, v0, v12, v7
; GFX9-NEXT:    v_or3_b32 v1, v1, v14, v8
; GFX9-NEXT:    v_lshlrev_b32_sdwa v6, v6, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v3, v3, v4, v5
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 24, v10
; GFX9-NEXT:    v_or3_b32 v2, v2, v16, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 2
; GFX9-NEXT:    v_or3_b32 v3, v3, v6, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 vcc, s4, 3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX9-NEXT:    s_lshl_b32 s0, s2, 3
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: extractelement_vgpr_v16i8_sgpr_idx:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v4, 8
; GFX8-NEXT:    v_mov_b32_e32 v5, 16
; GFX8-NEXT:    v_mov_b32_e32 v6, 8
; GFX8-NEXT:    v_mov_b32_e32 v7, 16
; GFX8-NEXT:    s_lshr_b32 s0, s2, 2
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 1
; GFX8-NEXT:    s_and_b32 s1, s2, 3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v12, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v4, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 24, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v13, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v6, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v7, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v6, v6, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v9
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v13
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 24, v10
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v15
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v8
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 24, v11
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v7
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 2
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e64 vcc, s0, 3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX8-NEXT:    s_lshl_b32 s0, s1, 3
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX7-LABEL: extractelement_vgpr_v16i8_sgpr_idx:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s0, 0xff
; GFX7-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX7-NEXT:    s_lshr_b32 s1, s2, 2
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 1
; GFX7-NEXT:    s_and_b32 s2, s2, 3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v10, v0, 8, 8
; GFX7-NEXT:    v_bfe_u32 v12, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v6, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v9, s0, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v11, s0, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_bfe_u32 v14, v2, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v10, 8, v10
; GFX7-NEXT:    v_lshlrev_b32_e32 v12, 8, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v13, v2, v4
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v15, v3, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v14, 8, v14
; GFX7-NEXT:    v_or_b32_e32 v9, v9, v10
; GFX7-NEXT:    v_or_b32_e32 v10, v11, v12
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v4, v3, v4
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 24, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 24, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v15, 8, v15
; GFX7-NEXT:    v_or_b32_e32 v11, v13, v14
; GFX7-NEXT:    v_or_b32_e32 v0, v9, v0
; GFX7-NEXT:    v_or_b32_e32 v1, v10, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v15
; GFX7-NEXT:    v_or_b32_e32 v2, v11, v2
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v5
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 2
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v8
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e64 vcc, s1, 3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX7-NEXT:    s_lshl_b32 s0, s2, 3
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX7-NEXT:    v_readfirstlane_b32 s0, v0
; GFX7-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_vgpr_v16i8_sgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s0, 8
; GFX10-NEXT:    v_mov_b32_e32 v5, 8
; GFX10-NEXT:    s_mov_b32 s1, 16
; GFX10-NEXT:    s_movk_i32 s3, 0xff
; GFX10-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX10-NEXT:    v_mov_b32_e32 v6, 16
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v10, s0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v12, s0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v11, s1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, s1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v0, v0, s3, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX10-NEXT:    v_and_or_b32 v1, v1, s3, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX10-NEXT:    s_lshr_b32 s0, s2, 2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, v6, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v2, v2, v4, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v11, v7
; GFX10-NEXT:    v_or3_b32 v1, v1, v13, v8
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 1
; GFX10-NEXT:    v_or3_b32 v2, v2, v15, v9
; GFX10-NEXT:    v_and_or_b32 v4, v3, v4, v5
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v6, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 24, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 2
; GFX10-NEXT:    v_or3_b32 v1, v4, v3, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e64 vcc_lo, s0, 3
; GFX10-NEXT:    s_and_b32 s0, s2, 3
; GFX10-NEXT:    s_lshl_b32 s0, s0, 3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 %idx
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_vgpr_idx(<16 x i8> addrspace(1)* %ptr, i32 %idx) {
; GFX9-LABEL: extractelement_vgpr_v16i8_vgpr_idx:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    s_mov_b32 s5, 16
; GFX9-NEXT:    s_movk_i32 s6, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v7, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 2, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX9-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 24, v4
; GFX9-NEXT:    v_lshlrev_b32_sdwa v13, s4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v15, s4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 24, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 24, v6
; GFX9-NEXT:    v_lshlrev_b32_sdwa v14, s5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v16, s5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v17, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_and_or_b32 v3, v3, s6, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX9-NEXT:    v_and_or_b32 v4, v4, s6, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX9-NEXT:    v_lshlrev_b32_sdwa v18, v7, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v7, v7, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v5, v5, v0, v17
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX9-NEXT:    v_and_or_b32 v0, v6, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v12
; GFX9-NEXT:    v_or3_b32 v3, v3, v14, v9
; GFX9-NEXT:    v_or3_b32 v4, v4, v16, v10
; GFX9-NEXT:    v_or3_b32 v5, v5, v18, v11
; GFX9-NEXT:    v_or3_b32 v0, v0, v7, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 2, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_vgpr_idx:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[3:6], v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_mov_b32_e32 v7, 8
; GFX8-NEXT:    v_mov_b32_e32 v8, 16
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 2, v2
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v9
; GFX8-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_sdwa v14, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 24, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v15, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v16, v7, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 24, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v17, v8, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v7, v7, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 24, v11
; GFX8-NEXT:    v_or_b32_sdwa v5, v5, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v15
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 24, v6
; GFX8-NEXT:    v_lshlrev_b32_sdwa v8, v8, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 24, v12
; GFX8-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v5, v17
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v10
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 24, v13
; GFX8-NEXT:    v_or_b32_e32 v5, v6, v8
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 2, v9
; GFX8-NEXT:    v_or_b32_e32 v4, v5, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_vgpr_idx:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[3:6], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_movk_i32 s4, 0xff
; GFX7-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX7-NEXT:    v_lshrrev_b32_e32 v17, 2, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v17
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v11, v3, 8, 8
; GFX7-NEXT:    v_bfe_u32 v13, v4, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; GFX7-NEXT:    v_and_b32_e32 v10, s4, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v12, s4, v4
; GFX7-NEXT:    v_bfe_u32 v4, v4, 16, 8
; GFX7-NEXT:    v_bfe_u32 v15, v5, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX7-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX7-NEXT:    v_lshrrev_b32_e32 v8, 24, v5
; GFX7-NEXT:    v_and_b32_e32 v14, v5, v0
; GFX7-NEXT:    v_bfe_u32 v5, v5, 16, 8
; GFX7-NEXT:    v_bfe_u32 v16, v6, 8, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v15, 8, v15
; GFX7-NEXT:    v_or_b32_e32 v10, v10, v11
; GFX7-NEXT:    v_or_b32_e32 v11, v12, v13
; GFX7-NEXT:    v_lshrrev_b32_e32 v9, 24, v6
; GFX7-NEXT:    v_and_b32_e32 v0, v6, v0
; GFX7-NEXT:    v_bfe_u32 v6, v6, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v7, 24, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v16, 8, v16
; GFX7-NEXT:    v_or_b32_e32 v12, v14, v15
; GFX7-NEXT:    v_or_b32_e32 v3, v10, v3
; GFX7-NEXT:    v_or_b32_e32 v4, v11, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v8, 24, v8
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v16
; GFX7-NEXT:    v_or_b32_e32 v5, v12, v5
; GFX7-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_or_b32_e32 v3, v4, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v6
; GFX7-NEXT:    v_or_b32_e32 v4, v5, v8
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 2, v17
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v9
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v17
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_vgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[3:6], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    s_mov_b32 s5, 16
; GFX10-NEXT:    s_movk_i32 s6, 0xff
; GFX10-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX10-NEXT:    v_mov_b32_e32 v7, 16
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 2, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 3, v2
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v8
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 24, v4
; GFX10-NEXT:    v_lshlrev_b32_sdwa v13, s4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v15, s4, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 24, v5
; GFX10-NEXT:    v_lshlrev_b32_sdwa v14, s5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v16, s5, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v17, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v3, v3, s6, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 24, v9
; GFX10-NEXT:    v_and_or_b32 v4, v4, s6, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 24, v10
; GFX10-NEXT:    v_lshrrev_b32_e32 v12, 24, v6
; GFX10-NEXT:    v_lshlrev_b32_sdwa v18, v7, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_and_or_b32 v5, v5, v0, v17
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 24, v11
; GFX10-NEXT:    v_or3_b32 v3, v3, v14, v9
; GFX10-NEXT:    v_or3_b32 v4, v4, v16, v10
; GFX10-NEXT:    v_lshlrev_b32_sdwa v7, v7, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, v6, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v12
; GFX10-NEXT:    v_or3_b32 v5, v5, v18, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 2, v8
; GFX10-NEXT:    v_or3_b32 v0, v0, v7, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v5, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 3, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 3, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 %idx
  ret i8 %element
}

define amdgpu_ps i8 @extractelement_sgpr_v16i8_vgpr_idx(<16 x i8> addrspace(4)* inreg %ptr, i32 %idx) {
; GCN-LABEL: extractelement_sgpr_v16i8_vgpr_idx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GCN-NEXT:    s_mov_b32 s10, 0x80008
; GCN-NEXT:    s_movk_i32 s8, 0xff
; GCN-NEXT:    v_lshrrev_b32_e32 v1, 2, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s11, s0, s10
; GCN-NEXT:    s_and_b32 s9, s0, s8
; GCN-NEXT:    s_lshl_b32 s11, s11, 8
; GCN-NEXT:    s_or_b32 s9, s9, s11
; GCN-NEXT:    s_mov_b32 s11, 0x80010
; GCN-NEXT:    s_lshr_b32 s4, s0, 24
; GCN-NEXT:    s_bfe_u32 s0, s0, s11
; GCN-NEXT:    s_lshl_b32 s0, s0, 16
; GCN-NEXT:    s_or_b32 s0, s9, s0
; GCN-NEXT:    s_lshl_b32 s4, s4, 24
; GCN-NEXT:    s_bfe_u32 s9, s1, s10
; GCN-NEXT:    s_lshr_b32 s5, s1, 24
; GCN-NEXT:    s_or_b32 s0, s0, s4
; GCN-NEXT:    s_and_b32 s4, s1, s8
; GCN-NEXT:    s_lshl_b32 s9, s9, 8
; GCN-NEXT:    s_bfe_u32 s1, s1, s11
; GCN-NEXT:    s_or_b32 s4, s4, s9
; GCN-NEXT:    s_lshl_b32 s1, s1, 16
; GCN-NEXT:    s_or_b32 s1, s4, s1
; GCN-NEXT:    s_lshl_b32 s4, s5, 24
; GCN-NEXT:    s_bfe_u32 s5, s2, s10
; GCN-NEXT:    s_lshr_b32 s6, s2, 24
; GCN-NEXT:    s_or_b32 s1, s1, s4
; GCN-NEXT:    s_and_b32 s4, s2, s8
; GCN-NEXT:    s_lshl_b32 s5, s5, 8
; GCN-NEXT:    s_bfe_u32 s2, s2, s11
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_lshl_b32 s2, s2, 16
; GCN-NEXT:    s_or_b32 s2, s4, s2
; GCN-NEXT:    s_lshl_b32 s4, s6, 24
; GCN-NEXT:    s_bfe_u32 s5, s3, s10
; GCN-NEXT:    s_lshr_b32 s7, s3, 24
; GCN-NEXT:    s_or_b32 s2, s2, s4
; GCN-NEXT:    s_and_b32 s4, s3, s8
; GCN-NEXT:    s_lshl_b32 s5, s5, 8
; GCN-NEXT:    s_bfe_u32 s3, s3, s11
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_lshl_b32 s3, s3, 16
; GCN-NEXT:    s_or_b32 s3, s4, s3
; GCN-NEXT:    s_lshl_b32 s4, s7, 24
; GCN-NEXT:    v_mov_b32_e32 v2, s0
; GCN-NEXT:    v_mov_b32_e32 v3, s1
; GCN-NEXT:    s_or_b32 s3, s3, s4
; GCN-NEXT:    v_mov_b32_e32 v4, s2
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 2, v1
; GCN-NEXT:    v_mov_b32_e32 v5, s3
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v1
; GCN-NEXT:    v_and_b32_e32 v0, 3, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v5, vcc
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GCN-NEXT:    v_lshrrev_b32_e32 v0, v0, v1
; GCN-NEXT:    v_readfirstlane_b32 s0, v0
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: extractelement_sgpr_v16i8_vgpr_idx:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; GFX10-NEXT:    s_mov_b32 s5, 0x80008
; GFX10-NEXT:    s_movk_i32 s4, 0xff
; GFX10-NEXT:    s_mov_b32 s6, 0x80010
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 2, v0
; GFX10-NEXT:    v_and_b32_e32 v0, 3, v0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_bfe_u32 s12, s0, s5
; GFX10-NEXT:    s_bfe_u32 s14, s1, s5
; GFX10-NEXT:    s_lshr_b32 s8, s1, 24
; GFX10-NEXT:    s_and_b32 s11, s0, s4
; GFX10-NEXT:    s_and_b32 s13, s1, s4
; GFX10-NEXT:    s_bfe_u32 s1, s1, s6
; GFX10-NEXT:    s_lshl_b32 s12, s12, 8
; GFX10-NEXT:    s_lshl_b32 s14, s14, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    s_or_b32 s11, s11, s12
; GFX10-NEXT:    s_or_b32 s12, s13, s14
; GFX10-NEXT:    s_lshl_b32 s8, s8, 24
; GFX10-NEXT:    s_or_b32 s1, s12, s1
; GFX10-NEXT:    s_lshr_b32 s7, s0, 24
; GFX10-NEXT:    s_bfe_u32 s0, s0, s6
; GFX10-NEXT:    s_or_b32 s1, s1, s8
; GFX10-NEXT:    s_lshl_b32 s0, s0, 16
; GFX10-NEXT:    s_bfe_u32 s16, s2, s5
; GFX10-NEXT:    v_mov_b32_e32 v2, s1
; GFX10-NEXT:    s_lshl_b32 s7, s7, 24
; GFX10-NEXT:    s_or_b32 s0, s11, s0
; GFX10-NEXT:    s_lshr_b32 s9, s2, 24
; GFX10-NEXT:    s_and_b32 s15, s2, s4
; GFX10-NEXT:    s_lshl_b32 s16, s16, 8
; GFX10-NEXT:    s_bfe_u32 s2, s2, s6
; GFX10-NEXT:    s_or_b32 s0, s0, s7
; GFX10-NEXT:    s_or_b32 s7, s15, s16
; GFX10-NEXT:    s_lshl_b32 s2, s2, 16
; GFX10-NEXT:    s_bfe_u32 s5, s3, s5
; GFX10-NEXT:    v_cndmask_b32_e32 v2, s0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 2, v1
; GFX10-NEXT:    s_or_b32 s2, s7, s2
; GFX10-NEXT:    s_lshl_b32 s7, s9, 24
; GFX10-NEXT:    s_and_b32 s4, s3, s4
; GFX10-NEXT:    s_lshl_b32 s5, s5, 8
; GFX10-NEXT:    s_bfe_u32 s1, s3, s6
; GFX10-NEXT:    s_or_b32 s2, s2, s7
; GFX10-NEXT:    s_lshr_b32 s10, s3, 24
; GFX10-NEXT:    s_or_b32 s3, s4, s5
; GFX10-NEXT:    s_lshl_b32 s1, s1, 16
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 3, v1
; GFX10-NEXT:    s_or_b32 s0, s3, s1
; GFX10-NEXT:    s_lshl_b32 s1, s10, 24
; GFX10-NEXT:    s_or_b32 s3, s0, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v2, s3, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v0, v1
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %vector = load <16 x i8>, <16 x i8> addrspace(4)* %ptr
  %element = extractelement <16 x i8> %vector, i32 %idx
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx0(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx0:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx0:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 0
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx1(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v2, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx1:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx1:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 1
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx2(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_mov_b32 s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v4, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx2:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx2:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx2:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    s_mov_b32 s4, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX10-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 2
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx3(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx3:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx3:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v0, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v0
; GFX7-NEXT:    v_bfe_u32 v0, v0, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx3:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v0
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 3
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx4(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v1, v0, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx4:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v1, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 4
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx5(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v2, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v1, v0, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx5:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx5:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx5:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v1, 0xff, v1, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v1, v0, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 5
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx6(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    s_mov_b32 s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v1, v0, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v4, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx6:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx6:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx6:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    s_mov_b32 s4, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v1, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX10-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 6
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx7(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v1, v0, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx7:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v2, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx7:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v1, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xff, v1
; GFX7-NEXT:    v_bfe_u32 v1, v1, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v2, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx7:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v1
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v1, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 7
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx8(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v2, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx8:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v2, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 8
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx9(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx9:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v1, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v2, v0, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx9:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx9:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx9:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v1, 0xff, v2, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v1, v0, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 9
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx10(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx10:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    s_mov_b32 s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v2, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX9-NEXT:    v_or3_b32 v0, v0, v4, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx10:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx10:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx10:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    s_mov_b32 s4, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 24, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, s4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v2, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX10-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 10
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx11(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx11:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v3, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v2
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v3, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v2, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v3, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx11:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v3
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx11:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v2
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v2
; GFX7-NEXT:    v_bfe_u32 v2, v2, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 8, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx11:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 24, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v2, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 11
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx12(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx12:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v2, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v3, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx12:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx12:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx12:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 12
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx13(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx13:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v1, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v3, v0, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX9-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx13:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx13:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx13:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, s4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v1, 0xff, v3, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_or3_b32 v0, v1, v0, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 13
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx14(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx14:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    s_mov_b32 s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v4, s4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v3, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX9-NEXT:    v_or3_b32 v0, v0, v4, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx14:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx14:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx14:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    s_mov_b32 s4, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v1, 24, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, s4, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 14
  ret i8 %element
}

define i8 @extractelement_vgpr_v16i8_idx15(<16 x i8> addrspace(1)* %ptr) {
; GFX9-LABEL: extractelement_vgpr_v16i8_idx15:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, 0xff
; GFX9-NEXT:    v_mov_b32_e32 v2, 16
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v3
; GFX9-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX9-NEXT:    v_lshlrev_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX9-NEXT:    v_and_or_b32 v0, v3, v0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 24, v4
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: extractelement_vgpr_v16i8_idx15:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, 16
; GFX8-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX8-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX8-NEXT:    v_or_b32_sdwa v0, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: extractelement_vgpr_v16i8_idx15:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    buffer_load_dwordx4 v[0:3], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_u32 v2, v3, 8, 8
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xff, v3
; GFX7-NEXT:    v_bfe_u32 v3, v3, 16, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX7-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: extractelement_vgpr_v16i8_idx15:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_load_dwordx4 v[0:3], v[0:1], off
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 8
; GFX10-NEXT:    v_mov_b32_e32 v1, 16
; GFX10-NEXT:    v_lshlrev_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 24, v3
; GFX10-NEXT:    v_lshlrev_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
; GFX10-NEXT:    v_and_or_b32 v0, 0xff, v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 24, v2
; GFX10-NEXT:    v_or3_b32 v0, v0, v1, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %vector = load <16 x i8>, <16 x i8> addrspace(1)* %ptr
  %element = extractelement <16 x i8> %vector, i32 15
  ret i8 %element
}
