---
id: Button
section: components
cssPrefix: pf-c-button
propComponents: ['Button']
ouia: true
---

import TimesIcon from '@patternfly/react-icons/dist/esm/icons/times-icon';
import PlusCircleIcon from '@patternfly/react-icons/dist/esm/icons/plus-circle-icon';
import ExternalLinkSquareAltIcon from '@patternfly/react-icons/dist/esm/icons/external-link-square-alt-icon';
import CopyIcon from '@patternfly/react-icons/dist/esm/icons/copy-icon';
import ArrowRightIcon from '@patternfly/react-icons/dist/esm/icons/arrow-right-icon';
import UploadIcon from '@patternfly/react-icons/dist/esm/icons/upload-icon';
import { Link } from '@reach/router';

## Examples

### Variations

```ts file="./ButtonVariations.tsx"
```

### Disabled

```ts file="./ButtonDisabled.tsx"
```

### Aria disabled

```ts file="./ButtonAriaDisabled.tsx"
```

### Aria disabled button with tooltip

```ts file="./ButtonAriaDisabledTooltip.tsx"
```

### Aria disabled link as button with tooltip

```ts file="./ButtonAriaDisabledLinkTooltip.tsx"
```

### Links as buttons

```ts file="./ButtonLinks.tsx"
```

### Inline link as span

```ts file="./ButtonInlineSpanLink.tsx"
```

### Block level

```ts file="./ButtonBlock.tsx"
```

### Types

```ts file="./ButtonTypes.tsx"
```

### Small

```ts file="./ButtonSmall.tsx"
```

### Call to action

```ts file="./ButtonCallToAction.tsx"
```

### Progress

```ts file="./ButtonProgress.tsx"
```

### Router link

```ts file="./ButtonRouterLink.tsx"
```

