; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse4.1 | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=CHECK,AVX

define i16 @mulhs(i16 %a0, i16 %a1) {
; CHECK-LABEL: mulhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movswl %si, %ecx
; CHECK-NEXT:    movswl %di, %eax
; CHECK-NEXT:    imull %ecx, %eax
; CHECK-NEXT:    shrl $16, %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
    %x0 = sext i16 %a0 to i32
    %x1 = sext i16 %a1 to i32
    %v0 = insertelement <1 x i32> <i32 undef>, i32 %x0, i32 0
    %v1 = insertelement <1 x i32> <i32 undef>, i32 %x1, i32 0
    %mul = mul nsw <1 x i32> %v0, %v1
    %lshr = lshr <1 x i32> %mul, <i32 16>
    %trunc = trunc <1 x i32> %lshr to <1 x i16>
    %res = extractelement <1 x i16> %trunc, i32 0
    ret i16 %res
}

define i16 @mulhu(i16 %a0, i16 %a1) {
; SSE-LABEL: mulhu:
; SSE:       # %bb.0:
; SSE-NEXT:    movzwl %si, %ecx
; SSE-NEXT:    movzwl %di, %eax
; SSE-NEXT:    imull %ecx, %eax
; SSE-NEXT:    shrl $16, %eax
; SSE-NEXT:    # kill: def $ax killed $ax killed $eax
; SSE-NEXT:    retq
;
; AVX-LABEL: mulhu:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovd %edi, %xmm0
; AVX-NEXT:    vmovd %esi, %xmm1
; AVX-NEXT:    vpmulhuw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovd %xmm0, %eax
; AVX-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX-NEXT:    retq
    %x0 = zext i16 %a0 to i32
    %x1 = zext i16 %a1 to i32
    %v0 = insertelement <1 x i32> <i32 undef>, i32 %x0, i32 0
    %v1 = insertelement <1 x i32> <i32 undef>, i32 %x1, i32 0
    %mul = mul nsw <1 x i32> %v0, %v1
    %lshr = lshr <1 x i32> %mul, <i32 16>
    %trunc = trunc <1 x i32> %lshr to <1 x i16>
    %res = extractelement <1 x i16> %trunc, i32 0
    ret i16 %res
}
