; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve  < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; insertelement
;

; i8
define <4 x i8> @insertelement_v4i8(<4 x i8> %op1) {
; CHECK-LABEL: insertelement_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z2.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    cmpeq p0.h, p0/z, z2.h, z1.h
; CHECK-NEXT:    mov z0.h, p0/m, w9
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <4 x i8> %op1, i8 5, i64 3
    ret <4 x i8> %r
}

define <8 x i8> @insertelement_v8i8(<8 x i8> %op1) {
; CHECK-LABEL: insertelement_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z2.b, #0, #1
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov z1.b, w8
; CHECK-NEXT:    cmpeq p0.b, p0/z, z2.b, z1.b
; CHECK-NEXT:    mov z0.b, p0/m, w9
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <8 x i8> %op1, i8 5, i64 7
    ret <8 x i8> %r
}

define <16 x i8> @insertelement_v16i8(<16 x i8> %op1) {
; CHECK-LABEL: insertelement_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #15 // =0xf
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z2.b, #0, #1
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z1.b, w8
; CHECK-NEXT:    cmpeq p0.b, p0/z, z2.b, z1.b
; CHECK-NEXT:    mov z0.b, p0/m, w9
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <16 x i8> %op1, i8 5, i64 15
    ret <16 x i8> %r
}

define <32 x i8> @insertelement_v32i8(<32 x i8> %op1) {
; CHECK-LABEL: insertelement_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #15 // =0xf
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z3.b, #0, #1
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    mov z2.b, w8
; CHECK-NEXT:    cmpeq p0.b, p0/z, z3.b, z2.b
; CHECK-NEXT:    mov z1.b, p0/m, w9
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
    %r = insertelement <32 x i8> %op1, i8 5, i64 31
    ret <32 x i8> %r
}

; i16
define <2 x i16> @insertelement_v2i16(<2 x i16> %op1) {
; CHECK-LABEL: insertelement_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z2.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    cmpeq p0.s, p0/z, z2.s, z1.s
; CHECK-NEXT:    mov z0.s, p0/m, w9
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <2 x i16> %op1, i16 5, i64 1
    ret <2 x i16> %r
}

define <4 x i16> @insertelement_v4i16(<4 x i16> %op1) {
; CHECK-LABEL: insertelement_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z2.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    cmpeq p0.h, p0/z, z2.h, z1.h
; CHECK-NEXT:    mov z0.h, p0/m, w9
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <4 x i16> %op1, i16 5, i64 3
    ret <4 x i16> %r
}

define <8 x i16> @insertelement_v8i16(<8 x i16> %op1) {
; CHECK-LABEL: insertelement_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z2.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z1.h, w8
; CHECK-NEXT:    cmpeq p0.h, p0/z, z2.h, z1.h
; CHECK-NEXT:    mov z0.h, p0/m, w9
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <8 x i16> %op1, i16 5, i64 7
    ret <8 x i16> %r
}

define <16 x i16> @insertelement_v16i16(<16 x i16> %op1) {
; CHECK-LABEL: insertelement_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z3.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    cmpeq p0.h, p0/z, z3.h, z2.h
; CHECK-NEXT:    mov z1.h, p0/m, w9
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
    %r = insertelement <16 x i16> %op1, i16 5, i64 15
    ret <16 x i16> %r
}

;i32
define <2 x i32> @insertelement_v2i32(<2 x i32> %op1) {
; CHECK-LABEL: insertelement_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z2.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    cmpeq p0.s, p0/z, z2.s, z1.s
; CHECK-NEXT:    mov z0.s, p0/m, w9
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <2 x i32> %op1, i32 5, i64 1
    ret <2 x i32> %r
}

define <4 x i32> @insertelement_v4i32(<4 x i32> %op1) {
; CHECK-LABEL: insertelement_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z2.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z1.s, w8
; CHECK-NEXT:    cmpeq p0.s, p0/z, z2.s, z1.s
; CHECK-NEXT:    mov z0.s, p0/m, w9
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <4 x i32> %op1, i32 5, i64 3
    ret <4 x i32> %r
}

define <8 x i32> @insertelement_v8i32(ptr %a) {
; CHECK-LABEL: insertelement_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    index z3.s, #0, #1
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.s, p0/z, z3.s, z2.s
; CHECK-NEXT:    mov z1.s, p0/m, w8
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
    %op1 = load <8 x i32>, ptr %a
    %r = insertelement <8 x i32> %op1, i32 5, i64 7
    ret <8 x i32> %r
}

;i64
define <1 x i64> @insertelement_v1i64(<1 x i64> %op1) {
; CHECK-LABEL: insertelement_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z0.d, #5 // =0x5
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <1 x i64> %op1, i64 5, i64 0
    ret <1 x i64> %r
}

define <2 x i64> @insertelement_v2i64(<2 x i64> %op1) {
; CHECK-LABEL: insertelement_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    mov w9, #5 // =0x5
; CHECK-NEXT:    index z2.d, #0, #1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z1.d, x8
; CHECK-NEXT:    cmpeq p0.d, p0/z, z2.d, z1.d
; CHECK-NEXT:    mov z0.d, p0/m, x9
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <2 x i64> %op1, i64 5, i64 1
    ret <2 x i64> %r
}

define <4 x i64> @insertelement_v4i64(ptr %a) {
; CHECK-LABEL: insertelement_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    index z3.d, #0, #1
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    mov w8, #5 // =0x5
; CHECK-NEXT:    cmpeq p0.d, p0/z, z3.d, z2.d
; CHECK-NEXT:    mov z1.d, p0/m, x8
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
    %op1 = load <4 x i64>, ptr %a
    %r = insertelement <4 x i64> %op1, i64 5, i64 3
    ret <4 x i64> %r
}

;f16
define <2 x half> @insertelement_v2f16(<2 x half> %op1) {
; CHECK-LABEL: insertelement_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    fmov h1, #5.00000000
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    str h0, [sp, #8]
; CHECK-NEXT:    str h1, [sp, #10]
; CHECK-NEXT:    ldr d0, [sp, #8]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
    %r = insertelement <2 x half> %op1, half 5.0, i64 1
    ret <2 x half> %r
}

define <4 x half> @insertelement_v4f16(<4 x half> %op1) {
; CHECK-LABEL: insertelement_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    fmov h1, #5.00000000
; CHECK-NEXT:    index z3.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    cmpeq p0.h, p0/z, z3.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, h1
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <4 x half> %op1, half 5.0, i64 3
    ret <4 x half> %r
}

define <8 x half> @insertelement_v8f16(<8 x half> %op1) {
; CHECK-LABEL: insertelement_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    fmov h1, #5.00000000
; CHECK-NEXT:    index z3.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    cmpeq p0.h, p0/z, z3.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, h1
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <8 x half> %op1, half 5.0, i64 7
    ret <8 x half> %r
}

define <16 x half> @insertelement_v16f16(ptr %a) {
; CHECK-LABEL: insertelement_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    fmov h3, #5.00000000
; CHECK-NEXT:    index z4.h, #0, #1
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, w8
; CHECK-NEXT:    cmpeq p0.h, p0/z, z4.h, z2.h
; CHECK-NEXT:    mov z1.h, p0/m, h3
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
    %op1 = load <16 x half>, ptr %a
    %r = insertelement <16 x half> %op1, half 5.0, i64 15
    ret <16 x half> %r
}

;f32
define <2 x float> @insertelement_v2f32(<2 x float> %op1) {
; CHECK-LABEL: insertelement_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    fmov s1, #5.00000000
; CHECK-NEXT:    index z3.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    cmpeq p0.s, p0/z, z3.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, s1
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <2 x float> %op1, float 5.0, i64 1
    ret <2 x float> %r
}

define <4 x float> @insertelement_v4f32(<4 x float> %op1) {
; CHECK-LABEL: insertelement_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    fmov s1, #5.00000000
; CHECK-NEXT:    index z3.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z2.s, w8
; CHECK-NEXT:    cmpeq p0.s, p0/z, z3.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, s1
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <4 x float> %op1, float 5.0, i64 3
    ret <4 x float> %r
}

define <8 x float> @insertelement_v8f32(ptr %a) {
; CHECK-LABEL: insertelement_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov w8, #3 // =0x3
; CHECK-NEXT:    fmov s4, #5.00000000
; CHECK-NEXT:    index z2.s, #0, #1
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z3.s, w8
; CHECK-NEXT:    cmpeq p0.s, p0/z, z2.s, z3.s
; CHECK-NEXT:    mov z1.s, p0/m, s4
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
    %op1 = load <8 x float>, ptr %a
    %r = insertelement <8 x float> %op1, float 5.0, i64 7
    ret <8 x float> %r
}

;f64
define <1 x double> @insertelement_v1f64(<1 x double> %op1) {
; CHECK-LABEL: insertelement_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov d0, #5.00000000
; CHECK-NEXT:    ret
    %r = insertelement <1 x double> %op1, double 5.0, i64 0
    ret <1 x double> %r
}

define <2 x double> @insertelement_v2f64(<2 x double> %op1) {
; CHECK-LABEL: insertelement_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    fmov d1, #5.00000000
; CHECK-NEXT:    index z3.d, #0, #1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z2.d, x8
; CHECK-NEXT:    cmpeq p0.d, p0/z, z3.d, z2.d
; CHECK-NEXT:    mov z0.d, p0/m, d1
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
    %r = insertelement <2 x double> %op1, double 5.0, i64 1
    ret <2 x double> %r
}

define <4 x double> @insertelement_v4f64(ptr %a) {
; CHECK-LABEL: insertelement_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    fmov d4, #5.00000000
; CHECK-NEXT:    index z2.d, #0, #1
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    mov z3.d, x8
; CHECK-NEXT:    cmpeq p0.d, p0/z, z2.d, z3.d
; CHECK-NEXT:    mov z1.d, p0/m, d4
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
    %op1 = load <4 x double>, ptr %a
    %r = insertelement <4 x double> %op1, double 5.0, i64 3
    ret <4 x double> %r
}
