; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve < %s | FileCheck %s
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sme < %s | FileCheck %s

;
; ST1B
;

define void @st1b_i8(<vscale x 16 x i8> %data, <vscale x 16 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1b_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1b { z0.b }, p0, [x0, x1]
; CHECK-NEXT:    ret
  %base = getelementptr i8, ptr %a, i64 %index
  call void @llvm.aarch64.sve.st1.nxv16i8(<vscale x 16 x i8> %data,
                                          <vscale x 16 x i1> %pred,
                                          ptr %base)
  ret void
}



define void @st1b_h(<vscale x 8 x i16> %data, <vscale x 8 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1b_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1b { z0.h }, p0, [x0, x1]
; CHECK-NEXT:    ret
  %base = getelementptr i8, ptr %a, i64 %index
  %trunc = trunc <vscale x 8 x i16> %data to <vscale x 8 x i8>
  call void @llvm.aarch64.sve.st1.nxv8i8(<vscale x 8 x i8> %trunc,
                                         <vscale x 8 x i1> %pred,
                                         ptr %base)
  ret void
}

define void @st1b_s(<vscale x 4 x i32> %data, <vscale x 4 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1b_s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1b { z0.s }, p0, [x0, x1]
; CHECK-NEXT:    ret
  %base = getelementptr i8, ptr %a, i64 %index
  %trunc = trunc <vscale x 4 x i32> %data to <vscale x 4 x i8>
  call void @llvm.aarch64.sve.st1.nxv4i8(<vscale x 4 x i8> %trunc,
                                         <vscale x 4 x i1> %pred,
                                         ptr %base)
  ret void
}

define void @st1b_d(<vscale x 2 x i64> %data, <vscale x 2 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1b_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1b { z0.d }, p0, [x0, x1]
; CHECK-NEXT:    ret
  %base = getelementptr i8, ptr %a, i64 %index
  %trunc = trunc <vscale x 2 x i64> %data to <vscale x 2 x i8>
  call void @llvm.aarch64.sve.st1.nxv2i8(<vscale x 2 x i8> %trunc,
                                         <vscale x 2 x i1> %pred,
                                         ptr %base)
  ret void
}

;
; ST1H
;

define void @st1h_i16(<vscale x 8 x i16> %data, <vscale x 8 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1h_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1h { z0.h }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %base = getelementptr i16, ptr %a, i64 %index
  call void @llvm.aarch64.sve.st1.nxv8i16(<vscale x 8 x i16> %data,
                                          <vscale x 8 x i1> %pred,
                                          ptr %base)
  ret void
}

define void @st1h_f16(<vscale x 8 x half> %data, <vscale x 8 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1h_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1h { z0.h }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %base = getelementptr half, ptr %a, i64 %index
  call void @llvm.aarch64.sve.st1.nxv8f16(<vscale x 8 x half> %data,
                                          <vscale x 8 x i1> %pred,
                                          ptr %base)
  ret void
}

define void @st1h_bf16(<vscale x 8 x bfloat> %data, <vscale x 8 x i1> %pred, ptr %a, i64 %index) #0 {
; CHECK-LABEL: st1h_bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1h { z0.h }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %base = getelementptr bfloat, ptr %a, i64 %index
  call void @llvm.aarch64.sve.st1.nxv8bf16(<vscale x 8 x bfloat> %data,
                                           <vscale x 8 x i1> %pred,
                                           ptr %base)
  ret void
}

define void @st1h_s(<vscale x 4 x i32> %data, <vscale x 4 x i1> %pred, ptr %addr) {
; CHECK-LABEL: st1h_s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1h { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %trunc = trunc <vscale x 4 x i32> %data to <vscale x 4 x i16>
  call void @llvm.aarch64.sve.st1.nxv4i16(<vscale x 4 x i16> %trunc,
                                         <vscale x 4 x i1> %pred,
                                         ptr %addr)
  ret void
}

define void @st1h_d(<vscale x 2 x i64> %data, <vscale x 2 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1h_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1h { z0.d }, p0, [x0, x1, lsl #1]
; CHECK-NEXT:    ret
  %base = getelementptr i16, ptr %a, i64 %index
  %trunc = trunc <vscale x 2 x i64> %data to <vscale x 2 x i16>
  call void @llvm.aarch64.sve.st1.nxv2i16(<vscale x 2 x i16> %trunc,
                                         <vscale x 2 x i1> %pred,
                                         ptr %base)
  ret void
}

;
; ST1W
;

define void @st1w_i32(<vscale x 4 x i32> %data, <vscale x 4 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1w_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1w { z0.s }, p0, [x0, x1, lsl #2]
; CHECK-NEXT:    ret
  %base = getelementptr i32, ptr %a, i64 %index
  call void @llvm.aarch64.sve.st1.nxv4i32(<vscale x 4 x i32> %data,
                                          <vscale x 4 x i1> %pred,
                                          ptr %base)
  ret void
}

define void @st1w_f32(<vscale x 4 x float> %data, <vscale x 4 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1w_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1w { z0.s }, p0, [x0, x1, lsl #2]
; CHECK-NEXT:    ret
  %base = getelementptr float, ptr %a, i64 %index
  call void @llvm.aarch64.sve.st1.nxv4f32(<vscale x 4 x float> %data,
                                          <vscale x 4 x i1> %pred,
                                          ptr %base)
  ret void
}

define void @st1w_d(<vscale x 2 x i64> %data, <vscale x 2 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1w_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1w { z0.d }, p0, [x0, x1, lsl #2]
; CHECK-NEXT:    ret
  %base = getelementptr i32, ptr %a, i64 %index
  %trunc = trunc <vscale x 2 x i64> %data to <vscale x 2 x i32>
  call void @llvm.aarch64.sve.st1.nxv2i32(<vscale x 2 x i32> %trunc,
                                          <vscale x 2 x i1> %pred,
                                          ptr %base)
  ret void
}

;
; ST1D
;

define void @st1d_i64(<vscale x 2 x i64> %data, <vscale x 2 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1d_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1d { z0.d }, p0, [x0, x1, lsl #3]
; CHECK-NEXT:    ret
  %base = getelementptr i64, ptr %a, i64 %index
  call void @llvm.aarch64.sve.st1.nxv2i64(<vscale x 2 x i64> %data,
                                          <vscale x 2 x i1> %pred,
                                          ptr %base)
  ret void
}

define void @st1d_f64(<vscale x 2 x double> %data, <vscale x 2 x i1> %pred, ptr %a, i64 %index) {
; CHECK-LABEL: st1d_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1d { z0.d }, p0, [x0, x1, lsl #3]
; CHECK-NEXT:    ret
  %base = getelementptr double, ptr %a, i64 %index
  call void @llvm.aarch64.sve.st1.nxv2f64(<vscale x 2 x double> %data,
                                          <vscale x 2 x i1> %pred,
                                          ptr %base)
  ret void
}

declare void @llvm.aarch64.sve.st1.nxv16i8(<vscale x 16 x i8>, <vscale x 16 x i1>, ptr)

declare void @llvm.aarch64.sve.st1.nxv8i8(<vscale x 8 x i8>, <vscale x 8 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv8i16(<vscale x 8 x i16>, <vscale x 8 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv8f16(<vscale x 8 x half>, <vscale x 8 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv8bf16(<vscale x 8 x bfloat>, <vscale x 8 x i1>, ptr)

declare void @llvm.aarch64.sve.st1.nxv4i8(<vscale x 4 x i8>, <vscale x 4 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv4i16(<vscale x 4 x i16>, <vscale x 4 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv4i32(<vscale x 4 x i32>, <vscale x 4 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv4f32(<vscale x 4 x float>, <vscale x 4 x i1>, ptr)

declare void @llvm.aarch64.sve.st1.nxv2i8(<vscale x 2 x i8>, <vscale x 2 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv2i16(<vscale x 2 x i16>, <vscale x 2 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv2i32(<vscale x 2 x i32>, <vscale x 2 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv2i64(<vscale x 2 x i64>, <vscale x 2 x i1>, ptr)
declare void @llvm.aarch64.sve.st1.nxv2f64(<vscale x 2 x double>, <vscale x 2 x i1>, ptr)

; +bf16 is required for the bfloat version.
attributes #0 = { "target-features"="+bf16" }
