/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.archive;

import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.TimestampsPolicy;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.archive.ArchiveItem;
import com.android.tools.build.jetifier.processor.archive.ArchiveItemVisitor;
import com.android.tools.build.jetifier.processor.archive.FileSearchResult;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 82\u00020\u0001:\u000278B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0001J\u0006\u0010$\u001a\u00020%J$\u0010&\u001a\u00020\u001f2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00140(2\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0001J\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020%2\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u0002042\u0006\u00100\u001a\u000201H\u0016J\u0018\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020\u00032\b\b\u0002\u00100\u001a\u000201R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016\u00a8\u00069"}, d2={"Lcom/android/tools/build/jetifier/processor/archive/Archive;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItem;", "relativePath", "Ljava/nio/file/Path;", "files", "", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "(Ljava/nio/file/Path;Ljava/util/List;Ljava/nio/file/attribute/FileTime;)V", "_files", "", "fileName", "", "getFileName", "()Ljava/lang/String;", "getFiles", "()Ljava/util/List;", "getLastModifiedTime", "()Ljava/nio/file/attribute/FileTime;", "markedForRemoval", "", "getMarkedForRemoval", "()Z", "setMarkedForRemoval", "(Z)V", "getRelativePath", "()Ljava/nio/file/Path;", "targetPath", "wasChanged", "getWasChanged", "accept", "", "visitor", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItemVisitor;", "addItem", "item", "copySelfFromOriginToTarget", "Ljava/io/File;", "findAllFiles", "selector", "Lkotlin/Function1;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "result", "Lcom/android/tools/build/jetifier/processor/archive/FileSearchResult;", "removeItem", "setTargetPath", "path", "writeSelf", "timestampsPolicy", "Lcom/android/tools/build/jetifier/processor/TimestampsPolicy;", "writeSelfTo", "outputStream", "Ljava/io/OutputStream;", "writeSelfToFile", "outputPath", "Builder", "Companion", "jetifier-processor"})
public final class Archive
implements ArchiveItem {
    private final List<ArchiveItem> _files;
    @NotNull
    private final List<ArchiveItem> files;
    @NotNull
    private final String fileName;
    private boolean markedForRemoval;
    private Path targetPath;
    @NotNull
    private final Path relativePath;
    @Nullable
    private final FileTime lastModifiedTime;
    @NotNull
    private static final List<String> ARCHIVE_EXTENSIONS;
    @NotNull
    public static final String TAG = "Archive";
    public static final Companion Companion;

    @NotNull
    public final List<ArchiveItem> getFiles() {
        return this.files;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean getMarkedForRemoval() {
        return this.markedForRemoval;
    }

    @Override
    public void setMarkedForRemoval(boolean bl) {
        this.markedForRemoval = bl;
    }

    @Override
    public boolean getWasChanged() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ArchiveItem it = (ArchiveItem)element$iv;
                    boolean bl2 = false;
                    if (!it.getWasChanged()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void setTargetPath(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.targetPath = path;
    }

    @Override
    public void findAllFiles(@NotNull Function1<? super ArchiveFile, Boolean> selector, @NotNull FileSearchResult result) {
        Intrinsics.checkParameterIsNotNull(selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Iterable $this$forEach$iv = this.files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArchiveItem it = (ArchiveItem)element$iv;
            boolean bl = false;
            it.findAllFiles(selector, result);
        }
    }

    @Override
    public void accept(@NotNull ArchiveItemVisitor visitor) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        visitor.visit(this);
    }

    @NotNull
    public final File writeSelf(@NotNull TimestampsPolicy timestampsPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)timestampsPolicy, (String)"timestampsPolicy");
        return this.writeSelfToFile(this.targetPath, timestampsPolicy);
    }

    @NotNull
    public final File copySelfFromOriginToTarget() {
        Files.copy(this.getRelativePath(), this.targetPath, StandardCopyOption.REPLACE_EXISTING);
        File file = this.targetPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"targetPath.toFile()");
        return file;
    }

    public final void removeItem(@NotNull ArchiveItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        this._files.remove(item);
    }

    public final void addItem(@NotNull ArchiveItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        this._files.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File writeSelfToFile(@NotNull Path outputPath, @NotNull TimestampsPolicy timestampsPolicy) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)outputPath, (String)"outputPath");
        Intrinsics.checkParameterIsNotNull((Object)timestampsPolicy, (String)"timestampsPolicy");
        if (Files.exists(outputPath, new LinkOption[0])) {
            Log.INSTANCE.i(TAG, "Deleting old output file", new Object[0]);
            Files.delete(outputPath);
        }
        if (outputPath.getParent() != null && !Files.exists(outputPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        }
        Log.INSTANCE.i(TAG, "Writing archive: %s", new Object[]{outputPath.toUri()});
        File file = outputPath.toFile();
        Files.createFile(outputPath, new FileAttribute[0]);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        Closeable closeable = stream;
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedOutputStream it = (BufferedOutputStream)closeable;
            boolean bl2 = false;
            this.writeSelfTo(it, timestampsPolicy);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File file2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
        return file2;
    }

    public static /* synthetic */ File writeSelfToFile$default(Archive archive, Path path, TimestampsPolicy timestampsPolicy, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            timestampsPolicy = TimestampsPolicy.Companion.getKEEP_PREVIOUS();
        }
        return archive.writeSelfToFile(path, timestampsPolicy);
    }

    @Override
    public void writeSelfTo(@NotNull OutputStream outputStream, @NotNull TimestampsPolicy timestampsPolicy) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        Intrinsics.checkParameterIsNotNull((Object)timestampsPolicy, (String)"timestampsPolicy");
        ZipOutputStream out = new ZipOutputStream(outputStream);
        for (ArchiveItem file : this.files) {
            if (file.getMarkedForRemoval()) continue;
            Log.INSTANCE.v(TAG, "Writing file: %s", new Object[]{file.getRelativePath()});
            String path = StringsKt.replace$default((String)((Object)file.getRelativePath()).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
            ZipEntry entry = new ZipEntry(path);
            if (timestampsPolicy.getModifiedTime(file.getLastModifiedTime()) != null) {
                FileTime fileTime;
                boolean bl = false;
                boolean bl2 = false;
                FileTime newModifiedTime = fileTime;
                boolean bl3 = false;
                entry.setLastModifiedTime(newModifiedTime);
            }
            out.putNextEntry(entry);
            file.writeSelfTo(out, timestampsPolicy);
            out.closeEntry();
        }
        out.finish();
    }

    @Override
    @NotNull
    public Path getRelativePath() {
        return this.relativePath;
    }

    @Override
    @Nullable
    public FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Archive(@NotNull Path relativePath, @NotNull List<? extends ArchiveItem> files, @Nullable FileTime lastModifiedTime) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        this.relativePath = relativePath;
        this.lastModifiedTime = lastModifiedTime;
        this._files = CollectionsKt.toMutableList((Collection)files);
        this.files = this._files;
        this.fileName = ((Object)this.getRelativePath().getFileName()).toString();
        this.targetPath = this.getRelativePath();
    }

    public /* synthetic */ Archive(Path path, List list, FileTime fileTime, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fileTime = null;
        }
        this(path, list, fileTime);
    }

    static {
        Companion = new Companion(null);
        ARCHIVE_EXTENSIONS = CollectionsKt.listOf((Object[])new String[]{".jar", ".zip", ".aar"});
    }

    @Override
    public boolean isPomFile() {
        return ArchiveItem.DefaultImpls.isPomFile(this);
    }

    @Override
    public boolean isClassFile() {
        return ArchiveItem.DefaultImpls.isClassFile(this);
    }

    @Override
    public boolean isXmlFile() {
        return ArchiveItem.DefaultImpls.isXmlFile(this);
    }

    @Override
    public boolean isProGuardFile() {
        return ArchiveItem.DefaultImpls.isProGuardFile(this);
    }

    @Override
    public boolean isJavaFile() {
        return ArchiveItem.DefaultImpls.isJavaFile(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ*\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/build/jetifier/processor/archive/Archive$Builder;", "", "()V", "extract", "Lcom/android/tools/build/jetifier/processor/archive/Archive;", "archiveFile", "Ljava/io/File;", "recursive", "", "extractArchive", "inputStream", "Ljava/io/InputStream;", "relativePath", "Ljava/nio/file/Path;", "originalModifiedTime", "Ljava/nio/file/attribute/FileTime;", "extractFile", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "zipIn", "Ljava/util/zip/ZipInputStream;", "isArchive", "zipEntry", "Ljava/util/zip/ZipEntry;", "jetifier-processor"})
    public static final class Builder {
        public static final Builder INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Archive extract(@NotNull File archiveFile, boolean recursive) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
            Log.INSTANCE.i(Archive.TAG, "Extracting: %s", new Object[]{archiveFile.getAbsolutePath()});
            FileInputStream inputStream = new FileInputStream(archiveFile);
            Closeable closeable = inputStream;
            boolean bl = false;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl2 = false;
                InputStream inputStream2 = it;
                Path path = archiveFile.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"archiveFile.toPath()");
                Archive archive = INSTANCE.extractArchive(inputStream2, path, recursive, null);
                return archive;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public static /* synthetic */ Archive extract$default(Builder builder, File file, boolean bl, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                bl = true;
            }
            return builder.extract(file, bl);
        }

        private final Archive extractArchive(InputStream inputStream, Path relativePath, boolean recursive, FileTime originalModifiedTime) throws IOException {
            ZipInputStream zipIn = new ZipInputStream(inputStream);
            boolean bl = false;
            List files = new ArrayList();
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                FileTime modifiedTime = entry.getLastModifiedTime();
                if (!entry.isDirectory()) {
                    Path entryPath = Paths.get(entry.getName(), new String[0]);
                    if (this.isArchive(entry) && recursive) {
                        Log.INSTANCE.i(Archive.TAG, "Extracting nested: %s", new Object[]{entryPath});
                        InputStream inputStream2 = zipIn;
                        Path path = entryPath;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"entryPath");
                        files.add(this.extractArchive(inputStream2, path, recursive, modifiedTime));
                    } else {
                        Path path = entryPath;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"entryPath");
                        files.add(this.extractFile(zipIn, path, modifiedTime));
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
            return new Archive(relativePath, CollectionsKt.toList((Iterable)files), originalModifiedTime);
        }

        private final ArchiveFile extractFile(ZipInputStream zipIn, Path relativePath, FileTime originalModifiedTime) throws IOException {
            Log.INSTANCE.v(Archive.TAG, "Extracting archive: %s", new Object[]{relativePath});
            byte[] data = ByteStreamsKt.readBytes((InputStream)zipIn);
            return new ArchiveFile(relativePath, data, originalModifiedTime);
        }

        private final boolean isArchive(ZipEntry zipEntry) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = Companion.getARCHIVE_EXTENSIONS();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string = zipEntry.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"zipEntry.name");
                        if (!StringsKt.endsWith((String)string, (String)it, (boolean)true)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private Builder() {
        }

        static {
            Builder builder;
            INSTANCE = builder = new Builder();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/build/jetifier/processor/archive/Archive$Companion;", "", "()V", "ARCHIVE_EXTENSIONS", "", "", "getARCHIVE_EXTENSIONS", "()Ljava/util/List;", "TAG", "jetifier-processor"})
    public static final class Companion {
        @NotNull
        public final List<String> getARCHIVE_EXTENSIONS() {
            return ARCHIVE_EXTENSIONS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

