; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

declare void @use(i1)

define i1 @logic_and_logic_or_1(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_and_logic_or_1(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 true, i1 [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 %a, i1 false
  %bc = select i1 %c, i1 %b, i1 false
  %or = select i1 %ac, i1 true, i1 %bc
  ret i1 %or
}

define i1 @logic_and_logic_or_2(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_and_logic_or_2(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 true, i1 [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %a, i1 %c, i1 false
  %bc = select i1 %c, i1 %b, i1 false
  %or = select i1 %ac, i1 true, i1 %bc
  ret i1 %or
}

define i1 @logic_and_logic_or_3(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_and_logic_or_3(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 true, i1 [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[TMP1]], i1 [[C:%.*]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %a, i1 %c, i1 false
  %bc = select i1 %b, i1 %c, i1 false
  %or = select i1 %ac, i1 true, i1 %bc
  ret i1 %or
}

define i1 @logic_and_logic_or_4(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_and_logic_or_4(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 true, i1 [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 %a, i1 false
  %bc = select i1 %b, i1 %c, i1 false
  %or = select i1 %ac, i1 true, i1 %bc
  ret i1 %or
}

define i1 @logic_and_logic_or_5(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_and_logic_or_5(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 %a, i1 false
  %bc = select i1 %c, i1 %b, i1 false
  %or = select i1 %bc, i1 true, i1 %ac
  ret i1 %or
}

define i1 @logic_and_logic_or_6(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_and_logic_or_6(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %a, i1 %c, i1 false
  %bc = select i1 %c, i1 %b, i1 false
  %or = select i1 %bc, i1 true, i1 %ac
  ret i1 %or
}

define i1 @logic_and_logic_or_7(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_and_logic_or_7(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[TMP1]], i1 [[C:%.*]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %a, i1 %c, i1 false
  %bc = select i1 %b, i1 %c, i1 false
  %or = select i1 %bc, i1 true, i1 %ac
  ret i1 %or
}

define i1 @logic_and_logic_or_8(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_and_logic_or_8(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 %a, i1 false
  %bc = select i1 %b, i1 %c, i1 false
  %or = select i1 %bc, i1 true, i1 %ac
  ret i1 %or
}

define <3 x i1> @logic_and_logic_or_vector(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @logic_and_logic_or_vector(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[TMP1]], <3 x i1> zeroinitializer
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = select <3 x i1> %c, <3 x i1> %a, <3 x i1> <i1 false, i1 false, i1 false>
  %bc = select <3 x i1> %c, <3 x i1> %b, <3 x i1> <i1 false, i1 false, i1 false>
  %or = select <3 x i1> %ac, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %bc
  ret <3 x i1> %or
}

define <3 x i1> @logic_and_logic_or_vector_poison1(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @logic_and_logic_or_vector_poison1(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[TMP1]], <3 x i1> zeroinitializer
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = select <3 x i1> %c, <3 x i1> %a, <3 x i1> <i1 false, i1 false, i1 false>
  %bc = select <3 x i1> %c, <3 x i1> %b, <3 x i1> <i1 false, i1 false, i1 false>
  %or = select <3 x i1> %ac, <3 x i1> <i1 true, i1 true, i1 poison>, <3 x i1> %bc
  ret <3 x i1> %or
}

define <3 x i1> @logic_and_logic_or_vector_poison2(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @logic_and_logic_or_vector_poison2(
; CHECK-NEXT:    [[AC:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[A:%.*]], <3 x i1> <i1 false, i1 poison, i1 false>
; CHECK-NEXT:    [[BC:%.*]] = select <3 x i1> [[C]], <3 x i1> [[B:%.*]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[AC]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[BC]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = select <3 x i1> %c, <3 x i1> %a, <3 x i1> <i1 false, i1 poison, i1 false>
  %bc = select <3 x i1> %c, <3 x i1> %b, <3 x i1> <i1 false, i1 false, i1 false>
  %or = select <3 x i1> %ac, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %bc
  ret <3 x i1> %or
}

define <3 x i1> @logic_and_logic_or_vector_poison3(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @logic_and_logic_or_vector_poison3(
; CHECK-NEXT:    [[BC:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[BC]], <3 x i1> <i1 poison, i1 false, i1 false>
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = select <3 x i1> %c, <3 x i1> %a, <3 x i1> <i1 false, i1 false, i1 false>
  %bc = select <3 x i1> %c, <3 x i1> %b, <3 x i1> <i1 poison, i1 false, i1 false>
  %or = select <3 x i1> %ac, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %bc
  ret <3 x i1> %or
}

; negative test: not one use for both op

define i1 @logic_and_logic_or_not_one_use(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_and_logic_or_not_one_use(
; CHECK-NEXT:    [[AC:%.*]] = select i1 [[C:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[BC:%.*]] = select i1 [[C]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[AC]], i1 true, i1 [[BC]]
; CHECK-NEXT:    call void @use(i1 [[AC]])
; CHECK-NEXT:    call void @use(i1 [[BC]])
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 %a, i1 false
  %bc = select i1 %c, i1 %b, i1 false
  %or = select i1 %ac, i1 true, i1 %bc
  call void @use(i1 %ac)
  call void @use(i1 %bc)
  ret i1 %or
}

define i1 @and_logic_and_logic_or_1(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_logic_and_logic_or_1(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 true, i1 [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %c, %a
  %bc = select i1 %c, i1 %b, i1 false
  %or = select i1 %ac, i1 true, i1 %bc
  ret i1 %or
}

define i1 @and_logic_and_logic_or_2(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_logic_and_logic_or_2(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 true, i1 [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %c, %a
  %bc = select i1 %b, i1 %c, i1 false
  %or = select i1 %ac, i1 true, i1 %bc
  ret i1 %or
}

define i1 @and_logic_and_logic_or_3(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_logic_and_logic_or_3(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 true, i1 [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %a, %c
  %bc = select i1 %c, i1 %b, i1 false
  %or = select i1 %ac, i1 true, i1 %bc
  ret i1 %or
}

define i1 @and_logic_and_logic_or_4(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_logic_and_logic_or_4(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 true, i1 [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %a, %c
  %bc = select i1 %b, i1 %c, i1 false
  %or = select i1 %ac, i1 true, i1 %bc
  ret i1 %or
}

define i1 @and_logic_and_logic_or_5(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_logic_and_logic_or_5(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %c, %a
  %bc = select i1 %c, i1 %b, i1 false
  %or = select i1 %bc, i1 true, i1 %ac
  ret i1 %or
}

define i1 @and_logic_and_logic_or_6(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_logic_and_logic_or_6(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = and i1 [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %c, %a
  %bc = select i1 %b, i1 %c, i1 false
  %or = select i1 %bc, i1 true, i1 %ac
  ret i1 %or
}

define i1 @and_logic_and_logic_or_7(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_logic_and_logic_or_7(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 [[TMP1]], i1 false
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %a, %c
  %bc = select i1 %c, i1 %b, i1 false
  %or = select i1 %bc, i1 true, i1 %ac
  ret i1 %or
}

define i1 @and_logic_and_logic_or_8(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_logic_and_logic_or_8(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = and i1 [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %a, %c
  %bc = select i1 %b, i1 %c, i1 false
  %or = select i1 %bc, i1 true, i1 %ac
  ret i1 %or
}

define <3 x i1> @and_logic_and_logic_or_vector(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @and_logic_and_logic_or_vector(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[TMP1]], <3 x i1> zeroinitializer
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = and <3 x i1> %c, %a
  %bc = select <3 x i1> %c, <3 x i1> %b, <3 x i1> <i1 false, i1 false, i1 false>
  %or = select <3 x i1> %ac, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %bc
  ret <3 x i1> %or
}

define <3 x i1> @and_logic_and_logic_or_vector_poison1(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @and_logic_and_logic_or_vector_poison1(
; CHECK-NEXT:    [[BC:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[BC]], <3 x i1> <i1 false, i1 poison, i1 false>
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = and <3 x i1> %c, %a
  %bc = select <3 x i1> %c, <3 x i1> %b, <3 x i1> <i1 false, i1 poison, i1 false>
  %or = select <3 x i1> %ac, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %bc
  ret <3 x i1> %or
}

define <3 x i1> @and_logic_and_logic_or_vector_poison2(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @and_logic_and_logic_or_vector_poison2(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> [[TMP1]], <3 x i1> zeroinitializer
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = and <3 x i1> %c, %a
  %bc = select <3 x i1> %c, <3 x i1> %b, <3 x i1> <i1 false, i1 false, i1 false>
  %or = select <3 x i1> %ac, <3 x i1> <i1 poison, i1 true, i1 true>, <3 x i1> %bc
  ret <3 x i1> %or
}

define i1 @and_logic_and_logic_or_not_one_use(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_logic_and_logic_or_not_one_use(
; CHECK-NEXT:    [[AC:%.*]] = and i1 [[A:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[BC:%.*]] = select i1 [[B:%.*]], i1 [[C]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[BC]], i1 true, i1 [[AC]]
; CHECK-NEXT:    call void @use(i1 [[AC]])
; CHECK-NEXT:    call void @use(i1 [[BC]])
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %a, %c
  %bc = select i1 %b, i1 %c, i1 false
  %or = select i1 %bc, i1 true, i1 %ac
  call void @use(i1 %ac)
  call void @use(i1 %bc)
  ret i1 %or
}

define i1 @and_and_logic_or_1(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_and_logic_or_1(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 true, i1 [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = and i1 [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %c, %a
  %bc = and i1 %c, %b
  %or = select i1 %ac, i1 true, i1 %bc
  ret i1 %or
}

define i1 @and_and_logic_or_2(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_and_logic_or_2(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = and i1 [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %a, %c
  %bc = and i1 %c, %b
  %or = select i1 %bc, i1 true, i1 %ac
  ret i1 %or
}

define <3 x i1>  @and_and_logic_or_vector(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @and_and_logic_or_vector(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = and <3 x i1> [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = and <3 x i1> %c, %a
  %bc = and <3 x i1> %c, %b
  %or = select <3 x i1> %ac, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1>  %bc
  ret <3 x i1> %or
}

define <3 x i1>  @and_and_logic_or_vector_poison(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @and_and_logic_or_vector_poison(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = and <3 x i1> [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = and <3 x i1> %c, %a
  %bc = and <3 x i1> %c, %b
  %or = select <3 x i1> %ac, <3 x i1> <i1 true, i1 poison, i1 true>, <3 x i1> %bc
  ret <3 x i1> %or
}

define i1 @and_and_logic_or_not_one_use(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @and_and_logic_or_not_one_use(
; CHECK-NEXT:    [[AC:%.*]] = and i1 [[A:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[BC:%.*]] = and i1 [[C]], [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[BC]], i1 true, i1 [[AC]]
; CHECK-NEXT:    call void @use(i1 [[AC]])
; CHECK-NEXT:    call void @use(i1 [[BC]])
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = and i1 %a, %c
  %bc = and i1 %c, %b
  %or = select i1 %bc, i1 true, i1 %ac
  call void @use(i1 %ac)
  call void @use(i1 %bc)
  ret i1 %or
}

define i1 @logic_or_logic_and_1(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_or_logic_and_1(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 true, i1 %a
  %bc = select i1 %c, i1 true, i1 %b
  %or = select i1 %ac, i1 %bc, i1 false
  ret i1 %or
}

define i1 @logic_or_logic_and_2(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_or_logic_and_2(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %a, i1 true, i1 %c
  %bc = select i1 %c, i1 true, i1 %b
  %or = select i1 %ac, i1 %bc, i1 false
  ret i1 %or
}

define i1 @logic_or_logic_and_3(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_or_logic_and_3(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[TMP1]], i1 true, i1 [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %a, i1 true, i1 %c
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %ac, i1 %bc, i1 false
  ret i1 %or
}

define i1 @logic_or_logic_and_4(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_or_logic_and_4(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 true, i1 %a
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %ac, i1 %bc, i1 false
  ret i1 %or
}

define i1 @logic_or_logic_and_5(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_or_logic_and_5(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 true, i1 %a
  %bc = select i1 %c, i1 true, i1 %b
  %or = select i1 %bc, i1 %ac, i1 false
  ret i1 %or
}

define i1 @logic_or_logic_and_6(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_or_logic_and_6(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %a, i1 true, i1 %c
  %bc = select i1 %c, i1 true, i1 %b
  %or = select i1 %bc, i1 %ac, i1 false
  ret i1 %or
}

define i1 @logic_or_logic_and_7(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_or_logic_and_7(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[TMP1]], i1 true, i1 [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %a, i1 true, i1 %c
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %bc, i1 %ac, i1 false
  ret i1 %or
}

define i1 @logic_or_logic_and_8(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_or_logic_and_8(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 true, i1 %a
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %bc, i1 %ac, i1 false
  ret i1 %or
}

define <3 x i1> @logic_or_logic_and_vector(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @logic_or_logic_and_vector(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> [[B:%.*]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[TMP1]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %a
  %bc = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %b
  %or = select <3 x i1> %ac, <3 x i1> %bc, <3 x i1> <i1 false, i1 false, i1 false>
  ret <3 x i1> %or
}

define <3 x i1> @logic_or_logic_and_vector_poison1(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @logic_or_logic_and_vector_poison1(
; CHECK-NEXT:    [[AC:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> <i1 poison, i1 true, i1 true>, <3 x i1> [[A:%.*]]
; CHECK-NEXT:    [[BC:%.*]] = select <3 x i1> [[C]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[B:%.*]]
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[AC]], <3 x i1> [[BC]], <3 x i1> zeroinitializer
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = select <3 x i1> %c, <3 x i1> <i1 poison, i1 true, i1 true>, <3 x i1> %a
  %bc = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %b
  %or = select <3 x i1> %ac, <3 x i1> %bc, <3 x i1> <i1 false, i1 false, i1 false>
  ret <3 x i1> %or
}

define <3 x i1> @logic_or_logic_and_vector_poison2(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @logic_or_logic_and_vector_poison2(
; CHECK-NEXT:    [[BC:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> [[B:%.*]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> <i1 true, i1 poison, i1 true>, <3 x i1> [[BC]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %a
  %bc = select <3 x i1> %c, <3 x i1> <i1 true, i1 poison, i1 true>, <3 x i1> %b
  %or = select <3 x i1> %ac, <3 x i1> %bc, <3 x i1> <i1 false, i1 false, i1 false>
  ret <3 x i1> %or
}

define <3 x i1> @logic_or_logic_and_vector_poison3(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @logic_or_logic_and_vector_poison3(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> [[B:%.*]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[TMP1]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %a
  %bc = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %b
  %or = select <3 x i1> %ac, <3 x i1> %bc, <3 x i1> <i1 false, i1 false, i1 poison>
  ret <3 x i1> %or
}

; negative test: not one use for both op

define i1 @logic_or_logic_and_not_one_use(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @logic_or_logic_and_not_one_use(
; CHECK-NEXT:    [[AC:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[A:%.*]]
; CHECK-NEXT:    [[BC:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[C]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[BC]], i1 [[AC]], i1 false
; CHECK-NEXT:    call void @use(i1 [[AC]])
; CHECK-NEXT:    call void @use(i1 [[BC]])
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = select i1 %c, i1 true, i1 %a
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %bc, i1 %ac, i1 false
  call void @use(i1 %ac)
  call void @use(i1 %bc)
  ret i1 %or
}

define i1 @or_logic_or_logic_and_1(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_logic_or_logic_and_1(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %c, %a
  %bc = select i1 %c, i1 true, i1 %b
  %or = select i1 %ac, i1 %bc, i1 false
  ret i1 %or
}

define i1 @or_logic_or_logic_and_2(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_logic_or_logic_and_2(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %c, %a
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %ac, i1 %bc, i1 false
  ret i1 %or
}

define i1 @or_logic_or_logic_and_3(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_logic_or_logic_and_3(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %c, %a
  %bc = select i1 %c, i1 true, i1 %b
  %or = select i1 %bc, i1 %ac, i1 false
  ret i1 %or
}

define i1 @or_logic_or_logic_and_4(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_logic_or_logic_and_4(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = or i1 [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %c, %a
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %bc, i1 %ac, i1 false
  ret i1 %or
}

define i1 @or_logic_or_logic_and_5(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_logic_or_logic_and_5(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %a, %c
  %bc = select i1 %c, i1 true, i1 %b
  %or = select i1 %ac, i1 %bc, i1 false
  ret i1 %or
}

define i1 @or_logic_or_logic_and_6(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_logic_or_logic_and_6(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %a, %c
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %ac, i1 %bc, i1 false
  ret i1 %or
}

define i1 @or_logic_or_logic_and_7(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_logic_or_logic_and_7(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[C:%.*]], i1 true, i1 [[TMP1]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %a, %c
  %bc = select i1 %c, i1 true, i1 %b
  %or = select i1 %bc, i1 %ac, i1 false
  ret i1 %or
}

define i1 @or_logic_or_logic_and_8(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_logic_or_logic_and_8(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = or i1 [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %a, %c
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %bc, i1 %ac, i1 false
  ret i1 %or
}

define <3 x i1> @or_logic_or_logic_and_vector(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @or_logic_or_logic_and_vector(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> [[B:%.*]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[TMP1]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = or <3 x i1> %c, %a
  %bc = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %b
  %or = select <3 x i1> %ac, <3 x i1> %bc, <3 x i1> <i1 false, i1 false, i1 false>
  ret <3 x i1> %or
}

define <3 x i1> @or_logic_or_logic_and_vector_poison1(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @or_logic_or_logic_and_vector_poison1(
; CHECK-NEXT:    [[BC:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> [[B:%.*]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> <i1 true, i1 poison, i1 true>, <3 x i1> [[BC]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = or <3 x i1> %c, %a
  %bc = select <3 x i1> %c, <3 x i1> <i1 true, i1 poison, i1 true>, <3 x i1> %b
  %or = select <3 x i1> %ac, <3 x i1> %bc, <3 x i1> <i1 false, i1 false, i1 false>
  ret <3 x i1> %or
}

define <3 x i1> @or_logic_or_logic_and_vector_poison2(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @or_logic_or_logic_and_vector_poison2(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> [[B:%.*]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = select <3 x i1> [[C:%.*]], <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> [[TMP1]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = or <3 x i1> %c, %a
  %bc = select <3 x i1> %c, <3 x i1> <i1 true, i1 true, i1 true>, <3 x i1> %b
  %or = select <3 x i1> %ac, <3 x i1> %bc, <3 x i1> <i1 false, i1 false, i1 poison>
  ret <3 x i1> %or
}

define i1 @or_logic_or_logic_and_not_one_use(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_logic_or_logic_and_not_one_use(
; CHECK-NEXT:    [[AC:%.*]] = or i1 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[BC:%.*]] = select i1 [[B:%.*]], i1 true, i1 [[C]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[BC]], i1 [[AC]], i1 false
; CHECK-NEXT:    call void @use(i1 [[AC]])
; CHECK-NEXT:    call void @use(i1 [[BC]])
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %c, %a
  %bc = select i1 %b, i1 true, i1 %c
  %or = select i1 %bc, i1 %ac, i1 false
  call void @use(i1 %ac)
  call void @use(i1 %bc)
  ret i1 %or
}

define i1 @or_or_logic_and_1(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_or_logic_and_1(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[A:%.*]], i1 [[B:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = or i1 [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %c, %a
  %bc = or i1 %b, %c
  %or = select i1 %ac, i1 %bc, i1 false
  ret i1 %or
}

define i1 @or_or_logic_and_2(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_or_logic_and_2(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[B:%.*]], i1 [[A:%.*]], i1 false
; CHECK-NEXT:    [[OR:%.*]] = or i1 [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %c, %a
  %bc = or i1 %b, %c
  %or = select i1 %bc, i1 %ac, i1 false
  ret i1 %or
}

define <3 x i1> @or_or_logic_and_vector(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @or_or_logic_and_vector(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> [[B:%.*]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = or <3 x i1> [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = or <3 x i1> %c, %a
  %bc = or <3 x i1> %b, %c
  %or = select <3 x i1> %ac, <3 x i1> %bc, <3 x i1> <i1 false, i1 false, i1 false>
  ret <3 x i1> %or
}

define <3 x i1> @or_or_logic_and_vector_poison(<3 x i1> %c, <3 x i1> %a, <3 x i1> %b) {
; CHECK-LABEL: @or_or_logic_and_vector_poison(
; CHECK-NEXT:    [[TMP1:%.*]] = select <3 x i1> [[A:%.*]], <3 x i1> [[B:%.*]], <3 x i1> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = or <3 x i1> [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %ac = or <3 x i1> %c, %a
  %bc = or <3 x i1> %b, %c
  %or = select <3 x i1> %ac, <3 x i1> %bc, <3 x i1> <i1 poison, i1 false, i1 false>
  ret <3 x i1> %or
}

define i1 @or_or_logic_and_not_one_use(i1 %c, i1 %a, i1 %b) {
; CHECK-LABEL: @or_or_logic_and_not_one_use(
; CHECK-NEXT:    [[AC:%.*]] = or i1 [[C:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[BC:%.*]] = or i1 [[B:%.*]], [[C]]
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[BC]], i1 [[AC]], i1 false
; CHECK-NEXT:    call void @use(i1 [[AC]])
; CHECK-NEXT:    call void @use(i1 [[BC]])
; CHECK-NEXT:    ret i1 [[OR]]
;
  %ac = or i1 %c, %a
  %bc = or i1 %b, %c
  %or = select i1 %bc, i1 %ac, i1 false
  call void @use(i1 %ac)
  call void @use(i1 %bc)
  ret i1 %or
}
