; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=thumbv7-unknown-linux < %s | FileCheck -check-prefixes=CHECK %s

define { half, i32 } @test_frexp_f16_i32(half %a) {
; CHECK-LABEL: test_frexp_f16_i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    ldr r1, [sp, #4]
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  ret { half, i32 } %result
}

define half @test_frexp_f16_i32_only_use_fract(half %a) {
; CHECK-LABEL: test_frexp_f16_i32_only_use_fract:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  %result.0 = extractvalue { half, i32 } %result, 0
  ret half %result.0
}

define i32 @test_frexp_f16_i32_only_use_exp(half %a) {
; CHECK-LABEL: test_frexp_f16_i32_only_use_exp:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  %result.0 = extractvalue { half, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x half>, <2 x i32> } @test_frexp_v2f16_v2i32(<2 x half> %a) {
; CHECK-LABEL: test_frexp_v2f16_v2i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    vpush {d8}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    mov r4, r1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    mov r5, r0
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    add r4, sp, #4
; CHECK-NEXT:    mov r1, r4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    mov r7, sp
; CHECK-NEXT:    mov r6, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    mov r1, r7
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    vld1.32 {d8[0]}, [r7:32]
; CHECK-NEXT:    vld1.32 {d8[1]}, [r4:32]
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    mov r0, r6
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    mov r1, r0
; CHECK-NEXT:    vmov r2, r3, d8
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    vpop {d8}
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    pop {r4, r5, r6, r7, pc}
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  ret { <2 x half>, <2 x i32> } %result
}

define <2 x half> @test_frexp_v2f16_v2i32_only_use_fract(<2 x half> %a) {
; CHECK-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    mov r4, r1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    mov r1, sp
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    mov r5, r0
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    bl __gnu_f2h_ieee
; CHECK-NEXT:    mov r1, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r4, r5, r7, pc}
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  %result.0 = extractvalue { <2 x half>, <2 x i32> } %result, 0
  ret <2 x half> %result.0
}

define <2 x i32> @test_frexp_v2f16_v2i32_only_use_exp(<2 x half> %a) {
; CHECK-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    mov r4, r1
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    mov r5, sp
; CHECK-NEXT:    mov r1, r5
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    bl __gnu_h2f_ieee
; CHECK-NEXT:    add r4, sp, #4
; CHECK-NEXT:    mov r1, r4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    vld1.32 {d16[0]}, [r5:32]
; CHECK-NEXT:    vld1.32 {d16[1]}, [r4:32]
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r4, r5, r7, pc}
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  %result.1 = extractvalue { <2 x half>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

define { float, i32 } @test_frexp_f32_i32(float %a) {
; CHECK-LABEL: test_frexp_f32_i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr r1, [sp, #4]
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define { float, i32 } @test_frexp_f32_i32_tailcall(float %a) {
; CHECK-LABEL: test_frexp_f32_i32_tailcall:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr r1, [sp, #4]
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = tail call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define float @test_frexp_f32_i32_only_use_fract(float %a) {
; CHECK-LABEL: test_frexp_f32_i32_only_use_fract:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 0
  ret float %result.0
}

define i32 @test_frexp_f32_i32_only_use_exp(float %a) {
; CHECK-LABEL: test_frexp_f32_i32_only_use_exp:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x float>, <2 x i32> } @test_frexp_v2f32_v2i32(<2 x float> %a) {
; CHECK-LABEL: test_frexp_v2f32_v2i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    vpush {d8}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    vmov d8, r0, r1
; CHECK-NEXT:    add r4, sp, #4
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    mov r1, r4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    mov r5, r0
; CHECK-NEXT:    vmov r0, s17
; CHECK-NEXT:    vld1.32 {d8[0]}, [r4:32]
; CHECK-NEXT:    mov r4, sp
; CHECK-NEXT:    mov r1, r4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    vld1.32 {d8[1]}, [r4:32]
; CHECK-NEXT:    mov r1, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    vmov r2, r3, d8
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    vpop {d8}
; CHECK-NEXT:    pop {r4, r5, r7, pc}
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  ret { <2 x float>, <2 x i32> } %result
}

define <2 x float> @test_frexp_v2f32_v2i32_only_use_fract(<2 x float> %a) {
; CHECK-LABEL: test_frexp_v2f32_v2i32_only_use_fract:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    vpush {d8}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    vmov d8, r0, r1
; CHECK-NEXT:    mov r1, sp
; CHECK-NEXT:    vmov r0, s17
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    mov r1, r4
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    vpop {d8}
; CHECK-NEXT:    pop {r4, pc}
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  %result.0 = extractvalue { <2 x float>, <2 x i32> } %result, 0
  ret <2 x float> %result.0
}

define <2 x i32> @test_frexp_v2f32_v2i32_only_use_exp(<2 x float> %a) {
; CHECK-LABEL: test_frexp_v2f32_v2i32_only_use_exp:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    vpush {d8}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    vmov d8, r0, r1
; CHECK-NEXT:    add r4, sp, #4
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    mov r1, r4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    vmov r0, s17
; CHECK-NEXT:    mov r5, sp
; CHECK-NEXT:    mov r1, r5
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    vld1.32 {d16[0]}, [r4:32]
; CHECK-NEXT:    vld1.32 {d16[1]}, [r5:32]
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    vpop {d8}
; CHECK-NEXT:    pop {r4, r5, r7, pc}
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  %result.1 = extractvalue { <2 x float>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

define { <4 x float>, <4 x i32> } @test_frexp_v4f32_v4i32(<4 x float> %a) {
; CHECK-LABEL: test_frexp_v4f32_v4i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, r9, lr}
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    add.w r8, sp, #12
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    mov r0, r2
; CHECK-NEXT:    mov r5, r3
; CHECK-NEXT:    mov r1, r8
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    add r6, sp, #8
; CHECK-NEXT:    mov r9, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    mov r1, r6
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    vldr d16, [sp, #80]
; CHECK-NEXT:    mov r5, r0
; CHECK-NEXT:    vld1.32 {d8[0]}, [r8:32]
; CHECK-NEXT:    add.w r8, sp, #4
; CHECK-NEXT:    vmov r0, r7, d16
; CHECK-NEXT:    mov r1, r8
; CHECK-NEXT:    vld1.32 {d8[1]}, [r6:32]
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    vld1.32 {d9[0]}, [r8:32]
; CHECK-NEXT:    vmov s21, r5
; CHECK-NEXT:    mov r5, sp
; CHECK-NEXT:    mov r6, r0
; CHECK-NEXT:    mov r0, r7
; CHECK-NEXT:    mov r1, r5
; CHECK-NEXT:    vmov s20, r9
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    vmov s23, r0
; CHECK-NEXT:    vld1.32 {d9[1]}, [r5:32]
; CHECK-NEXT:    vmov s22, r6
; CHECK-NEXT:    vst1.32 {d10, d11}, [r4]!
; CHECK-NEXT:    vst1.64 {d8, d9}, [r4]
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, pc}
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  ret { <4 x float>, <4 x i32> } %result
}

define <4 x float> @test_frexp_v4f32_v4i32_only_use_fract(<4 x float> %a) {
; CHECK-LABEL: test_frexp_v4f32_v4i32_only_use_fract:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    mov r5, r1
; CHECK-NEXT:    mov r6, r0
; CHECK-NEXT:    mov r1, sp
; CHECK-NEXT:    mov r0, r3
; CHECK-NEXT:    mov r4, r2
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    vmov s19, r0
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    add r1, sp, #8
; CHECK-NEXT:    vmov s18, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    add r1, sp, #12
; CHECK-NEXT:    vmov s17, r0
; CHECK-NEXT:    mov r0, r6
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    vmov s16, r0
; CHECK-NEXT:    vmov r2, r3, d9
; CHECK-NEXT:    vmov r0, r1, d8
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r6, pc}
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  %result.0 = extractvalue { <4 x float>, <4 x i32> } %result, 0
  ret <4 x float> %result.0
}

define <4 x i32> @test_frexp_v4f32_v4i32_only_use_exp(<4 x float> %a) {
; CHECK-LABEL: test_frexp_v4f32_v4i32_only_use_exp:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    mov r6, r1
; CHECK-NEXT:    add r1, sp, #12
; CHECK-NEXT:    mov r4, r3
; CHECK-NEXT:    mov r5, r2
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    add r1, sp, #8
; CHECK-NEXT:    mov r0, r6
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    add r1, sp, #4
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    mov r1, sp
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldrd r1, r0, [sp, #8]
; CHECK-NEXT:    ldrd r3, r2, [sp], #16
; CHECK-NEXT:    pop {r4, r5, r6, pc}
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  %result.1 = extractvalue { <4 x float>, <4 x i32> } %result, 1
  ret <4 x i32> %result.1
}

define { double, i32 } @test_frexp_f64_i32(double %a) {
; CHECK-LABEL: test_frexp_f64_i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    add r2, sp, #4
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    ldr r2, [sp, #4]
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  ret { double, i32 } %result
}

define double @test_frexp_f64_i32_only_use_fract(double %a) {
; CHECK-LABEL: test_frexp_f64_i32_only_use_fract:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    add r2, sp, #4
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 0
  ret double %result.0
}

define i32 @test_frexp_f64_i32_only_use_exp(double %a) {
; CHECK-LABEL: test_frexp_f64_i32_only_use_exp:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    add r2, sp, #4
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop {r7, pc}
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x double>, <2 x i32> } @test_frexp_v2f64_v2i32(<2 x double> %a) {
; CHECK-LABEL: test_frexp_v2f64_v2i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, lr}
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    add.w r8, sp, #4
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    mov r0, r2
; CHECK-NEXT:    mov r1, r3
; CHECK-NEXT:    mov r2, r8
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    mov r6, r0
; CHECK-NEXT:    mov r7, r1
; CHECK-NEXT:    ldrd r0, r1, [sp, #32]
; CHECK-NEXT:    mov r5, sp
; CHECK-NEXT:    mov r2, r5
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    vld1.32 {d16[0]}, [r8:32]
; CHECK-NEXT:    vmov d18, r6, r7
; CHECK-NEXT:    vmov d19, r0, r1
; CHECK-NEXT:    vld1.32 {d16[1]}, [r5:32]
; CHECK-NEXT:    vst1.64 {d18, d19}, [r4]!
; CHECK-NEXT:    vstr d16, [r4]
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    pop.w {r4, r5, r6, r7, r8, pc}
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  ret { <2 x double>, <2 x i32> } %result
}

define <2 x double> @test_frexp_v2f64_v2i32_only_use_fract(<2 x double> %a) {
; CHECK-LABEL: test_frexp_v2f64_v2i32_only_use_fract:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    sub sp, #12
; CHECK-NEXT:    mov r5, r2
; CHECK-NEXT:    add r2, sp, #4
; CHECK-NEXT:    mov r4, r3
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    add r2, sp, #8
; CHECK-NEXT:    mov r6, r0
; CHECK-NEXT:    mov r7, r1
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    mov r1, r4
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    mov r2, r0
; CHECK-NEXT:    mov r3, r1
; CHECK-NEXT:    mov r0, r6
; CHECK-NEXT:    mov r1, r7
; CHECK-NEXT:    add sp, #12
; CHECK-NEXT:    pop {r4, r5, r6, r7, pc}
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  %result.0 = extractvalue { <2 x double>, <2 x i32> } %result, 0
  ret <2 x double> %result.0
}

define <2 x i32> @test_frexp_v2f64_v2i32_only_use_exp(<2 x double> %a) {
; CHECK-LABEL: test_frexp_v2f64_v2i32_only_use_exp:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    sub sp, #12
; CHECK-NEXT:    add r6, sp, #4
; CHECK-NEXT:    mov r5, r2
; CHECK-NEXT:    mov r4, r3
; CHECK-NEXT:    mov r2, r6
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    add r7, sp, #8
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    mov r1, r4
; CHECK-NEXT:    mov r2, r7
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    vld1.32 {d16[0]}, [r6:32]
; CHECK-NEXT:    vld1.32 {d16[1]}, [r7:32]
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    add sp, #12
; CHECK-NEXT:    pop {r4, r5, r6, r7, pc}
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  %result.1 = extractvalue { <2 x double>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

declare { float, i32 } @llvm.frexp.f32.i32(float) #0
declare { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float>) #0
declare { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float>) #0

declare { half, i32 } @llvm.frexp.f16.i32(half) #0
declare { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half>) #0

declare { double, i32 } @llvm.frexp.f64.i32(double) #0
declare { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double>) #0

declare { half, i16 } @llvm.frexp.f16.i16(half) #0
declare { <2 x half>, <2 x i16> } @llvm.frexp.v2f16.v2i16(<2 x half>) #0

attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
