; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v -target-abi=ilp32d -riscv-v-vector-bits-min=128\
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v -target-abi=lp64d  -riscv-v-vector-bits-min=128\
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half>, <1 x half>, metadata, metadata)
define <1 x i1> @fcmp_oeq_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oeq_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oeq_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ogt_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ogt_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ogt_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oge_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oge_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oge_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_olt_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_olt_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_olt_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ole_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ole_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ole_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_one_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_one_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_one_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ord_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ord_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ord_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ueq_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ueq_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ueq_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ugt_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ugt_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ugt_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uge_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uge_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uge_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ult_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ult_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ult_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ule_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ule_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ule_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_une_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_une_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_une_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uno_vv_v1f16(<1 x half> %va, <1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uno_vf_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %va, <1 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uno_fv_v1f16(<1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <1 x half> poison, half %b, i32 0
  %splat = shufflevector <1 x half> %head, <1 x half> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f16(<1 x half> %splat, <1 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

declare <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half>, <2 x half>, metadata, metadata)
define <2 x i1> @fcmp_oeq_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oeq_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oeq_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ogt_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ogt_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ogt_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oge_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oge_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oge_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_olt_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_olt_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_olt_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ole_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ole_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ole_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_one_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_one_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_one_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ord_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ord_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ord_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ueq_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ueq_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ueq_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ugt_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ugt_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ugt_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uge_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uge_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uge_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ult_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ult_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ult_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ule_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ule_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ule_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_une_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_une_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_une_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uno_vv_v2f16(<2 x half> %va, <2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uno_vf_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uno_fv_v2f16(<2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f16(<2 x half> %splat, <2 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

declare <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half>, <4 x half>, metadata, metadata)
define <4 x i1> @fcmp_oeq_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oeq_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oeq_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ogt_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ogt_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ogt_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oge_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oge_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oge_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_olt_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_olt_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_olt_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ole_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ole_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ole_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_one_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_one_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_one_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ord_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ord_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ord_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ueq_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ueq_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ueq_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ugt_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ugt_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ugt_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uge_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uge_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uge_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ult_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ult_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ult_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ule_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ule_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ule_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_une_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_une_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_une_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uno_vv_v4f16(<4 x half> %va, <4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uno_vf_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uno_fv_v4f16(<4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f16(<4 x half> %splat, <4 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

declare <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half>, <8 x half>, metadata, metadata)
define <8 x i1> @fcmp_oeq_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oeq_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oeq_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ogt_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ogt_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ogt_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oge_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oge_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oge_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_olt_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_olt_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_olt_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ole_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ole_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ole_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_one_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_one_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_one_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ord_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ord_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ord_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ueq_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ueq_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ueq_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ugt_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ugt_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ugt_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uge_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uge_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uge_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ult_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ult_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ult_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ule_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ule_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ule_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_une_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_une_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_une_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uno_vv_v8f16(<8 x half> %va, <8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uno_vf_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uno_fv_v8f16(<8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f16(<8 x half> %splat, <8 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

declare <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half>, <16 x half>, metadata, metadata)
define <16 x i1> @fcmp_oeq_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oeq_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oeq_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ogt_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ogt_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ogt_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oge_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oge_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oge_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_olt_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_olt_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_olt_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ole_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ole_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ole_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_one_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmfeq.vv v14, v8, v8
; CHECK-NEXT:    vmand.mm v12, v14, v13
; CHECK-NEXT:    vmand.mm v13, v13, v14
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vv v13, v10, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_one_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v11, v12
; CHECK-NEXT:    vmand.mm v11, v12, v11
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_one_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ord_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ord_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ord_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ueq_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmfeq.vv v14, v8, v8
; CHECK-NEXT:    vmand.mm v12, v14, v13
; CHECK-NEXT:    vmand.mm v13, v13, v14
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vv v13, v10, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ueq_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v11, v12
; CHECK-NEXT:    vmand.mm v11, v12, v11
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ueq_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ugt_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ugt_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ugt_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uge_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uge_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uge_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ult_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ult_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ult_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ule_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ule_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ule_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_une_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_une_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_une_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uno_vv_v16f16(<16 x half> %va, <16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v12, v10, v10
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vmor.mm v0, v10, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uno_vf_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfne.vf v12, v10, fa0
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vmor.mm v0, v10, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uno_fv_v16f16(<16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfne.vf v12, v10, fa0
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half> %splat, <16 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

declare <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half>, <32 x half>, metadata, metadata)
define <32 x i1> @fcmp_oeq_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_oeq_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_oeq_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ogt_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ogt_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ogt_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_oge_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_oge_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_oge_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_olt_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_olt_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_olt_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ole_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ole_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ole_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_one_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmfeq.vv v18, v8, v8
; CHECK-NEXT:    vmand.mm v16, v18, v17
; CHECK-NEXT:    vmand.mm v17, v17, v18
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v17
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_one_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v16
; CHECK-NEXT:    vmand.mm v13, v16, v13
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_one_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v13
; CHECK-NEXT:    vmand.mm v13, v13, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ord_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ord_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ord_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ueq_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmfeq.vv v18, v8, v8
; CHECK-NEXT:    vmand.mm v16, v18, v17
; CHECK-NEXT:    vmand.mm v17, v17, v18
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v17
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ueq_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v16
; CHECK-NEXT:    vmand.mm v13, v16, v13
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ueq_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v13
; CHECK-NEXT:    vmand.mm v13, v13, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ugt_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ugt_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ugt_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_uge_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_uge_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_uge_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ult_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ult_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ult_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ule_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ule_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_ule_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_une_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_une_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_une_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_uno_vv_v32f16(<32 x half> %va, <32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v12, v12
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_uno_vf_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfne.vf v16, v12, fa0
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

define <32 x i1> @fcmp_uno_fv_v32f16(<32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfne.vf v16, v12, fa0
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %1 = call <32 x i1> @llvm.experimental.constrained.fcmp.v32f16(<32 x half> %splat, <32 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <32 x i1> %1
}

declare <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float>, <1 x float>, metadata, metadata)
define <1 x i1> @fcmp_oeq_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oeq_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oeq_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ogt_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ogt_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ogt_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oge_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oge_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oge_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_olt_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_olt_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_olt_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ole_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ole_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ole_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_one_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_one_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_one_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ord_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ord_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ord_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ueq_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ueq_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ueq_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ugt_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ugt_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ugt_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uge_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uge_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uge_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ult_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ult_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ult_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ule_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ule_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ule_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_une_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_une_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_une_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uno_vv_v1f32(<1 x float> %va, <1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uno_vf_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %va, <1 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uno_fv_v1f32(<1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <1 x float> poison, float %b, i32 0
  %splat = shufflevector <1 x float> %head, <1 x float> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f32(<1 x float> %splat, <1 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

declare <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float>, <2 x float>, metadata, metadata)
define <2 x i1> @fcmp_oeq_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oeq_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oeq_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ogt_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ogt_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ogt_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oge_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oge_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oge_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_olt_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_olt_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_olt_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ole_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ole_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ole_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_one_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_one_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_one_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ord_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ord_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ord_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ueq_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ueq_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ueq_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ugt_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ugt_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ugt_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uge_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uge_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uge_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ult_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ult_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ult_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ule_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ule_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ule_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_une_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_une_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_une_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uno_vv_v2f32(<2 x float> %va, <2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uno_vf_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uno_fv_v2f32(<2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f32(<2 x float> %splat, <2 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

declare <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float>, <4 x float>, metadata, metadata)
define <4 x i1> @fcmp_oeq_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oeq_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oeq_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ogt_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ogt_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ogt_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oge_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oge_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oge_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_olt_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_olt_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_olt_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ole_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ole_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ole_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_one_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_one_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_one_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ord_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ord_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ord_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ueq_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ueq_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ueq_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ugt_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ugt_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ugt_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uge_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uge_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uge_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ult_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ult_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ult_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ule_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ule_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ule_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_une_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_une_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_une_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uno_vv_v4f32(<4 x float> %va, <4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uno_vf_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uno_fv_v4f32(<4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f32(<4 x float> %splat, <4 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

declare <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float>, <8 x float>, metadata, metadata)
define <8 x i1> @fcmp_oeq_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oeq_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oeq_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ogt_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ogt_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ogt_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oge_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oge_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oge_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_olt_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_olt_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_olt_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ole_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ole_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ole_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_one_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmfeq.vv v14, v8, v8
; CHECK-NEXT:    vmand.mm v12, v14, v13
; CHECK-NEXT:    vmand.mm v13, v13, v14
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vv v13, v10, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_one_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v11, v12
; CHECK-NEXT:    vmand.mm v11, v12, v11
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_one_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ord_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ord_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ord_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ueq_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmfeq.vv v14, v8, v8
; CHECK-NEXT:    vmand.mm v12, v14, v13
; CHECK-NEXT:    vmand.mm v13, v13, v14
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vv v13, v10, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ueq_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v11, v12
; CHECK-NEXT:    vmand.mm v11, v12, v11
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ueq_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ugt_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ugt_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ugt_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uge_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uge_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uge_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ult_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ult_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ult_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ule_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ule_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ule_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_une_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_une_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_une_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uno_vv_v8f32(<8 x float> %va, <8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v12, v10, v10
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vmor.mm v0, v10, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uno_vf_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfne.vf v12, v10, fa0
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vmor.mm v0, v10, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uno_fv_v8f32(<8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfne.vf v12, v10, fa0
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f32(<8 x float> %splat, <8 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

declare <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float>, <16 x float>, metadata, metadata)
define <16 x i1> @fcmp_oeq_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oeq_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oeq_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ogt_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ogt_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ogt_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oge_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oge_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_oge_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_olt_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_olt_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_olt_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ole_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ole_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ole_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_one_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmfeq.vv v18, v8, v8
; CHECK-NEXT:    vmand.mm v16, v18, v17
; CHECK-NEXT:    vmand.mm v17, v17, v18
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v17
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_one_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v16
; CHECK-NEXT:    vmand.mm v13, v16, v13
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_one_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v13
; CHECK-NEXT:    vmand.mm v13, v13, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ord_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ord_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ord_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ueq_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmfeq.vv v18, v8, v8
; CHECK-NEXT:    vmand.mm v16, v18, v17
; CHECK-NEXT:    vmand.mm v17, v17, v18
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v17
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ueq_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v16
; CHECK-NEXT:    vmand.mm v13, v16, v13
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ueq_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v13
; CHECK-NEXT:    vmand.mm v13, v13, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ugt_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ugt_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ugt_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uge_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uge_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uge_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ult_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ult_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ult_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ule_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ule_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_ule_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_une_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_une_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_une_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uno_vv_v16f32(<16 x float> %va, <16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v12, v12
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uno_vf_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfne.vf v16, v12, fa0
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

define <16 x i1> @fcmp_uno_fv_v16f32(<16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfne.vf v16, v12, fa0
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %1 = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f32(<16 x float> %splat, <16 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <16 x i1> %1
}

declare <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double>, <1 x double>, metadata, metadata)
define <1 x i1> @fcmp_oeq_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oeq_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oeq_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ogt_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ogt_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ogt_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oge_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oge_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_oge_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_olt_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_olt_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_olt_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ole_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ole_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ole_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_one_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_one_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_one_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ord_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ord_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ord_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ueq_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ueq_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ueq_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ugt_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ugt_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ugt_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uge_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uge_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uge_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ult_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ult_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ult_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ule_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ule_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_ule_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_une_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_une_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_une_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uno_vv_v1f64(<1 x double> %va, <1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uno_vf_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %va, <1 x double> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

define <1 x i1> @fcmp_uno_fv_v1f64(<1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <1 x double> poison, double %b, i32 0
  %splat = shufflevector <1 x double> %head, <1 x double> poison, <1 x i32> zeroinitializer
  %1 = call <1 x i1> @llvm.experimental.constrained.fcmp.v1f64(<1 x double> %splat, <1 x double> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <1 x i1> %1
}

declare <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double>, <2 x double>, metadata, metadata)
define <2 x i1> @fcmp_oeq_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oeq_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oeq_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ogt_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ogt_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ogt_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oge_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oge_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_oge_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_olt_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_olt_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_olt_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ole_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ole_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ole_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_one_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_one_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_one_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ord_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ord_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ord_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ueq_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vv v10, v8, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    vmflt.vv v11, v9, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ueq_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v11, v10
; CHECK-NEXT:    vmand.mm v10, v10, v11
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ueq_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v10, v9, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v9, v10, v11
; CHECK-NEXT:    vmand.mm v10, v11, v10
; CHECK-NEXT:    vmv.v.v v0, v9
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v10, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ugt_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ugt_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ugt_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uge_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v9, v9
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v8, v9, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uge_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uge_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ult_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmfle.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ult_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ult_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ule_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmfeq.vv v11, v9, v9
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    vmflt.vv v0, v9, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ule_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v10
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_ule_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v9
; CHECK-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_une_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_une_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_une_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uno_vv_v2f64(<2 x double> %va, <2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uno_vf_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

define <2 x i1> @fcmp_uno_fv_v2f64(<2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %1 = call <2 x i1> @llvm.experimental.constrained.fcmp.v2f64(<2 x double> %splat, <2 x double> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <2 x i1> %1
}

declare <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double>, <4 x double>, metadata, metadata)
define <4 x i1> @fcmp_oeq_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oeq_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oeq_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ogt_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ogt_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ogt_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oge_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oge_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_oge_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_olt_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_olt_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_olt_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ole_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ole_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ole_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_one_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmfeq.vv v14, v8, v8
; CHECK-NEXT:    vmand.mm v12, v14, v13
; CHECK-NEXT:    vmand.mm v13, v13, v14
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vv v13, v10, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_one_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v11, v12
; CHECK-NEXT:    vmand.mm v11, v12, v11
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_one_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ord_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ord_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ord_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ueq_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmfeq.vv v14, v8, v8
; CHECK-NEXT:    vmand.mm v12, v14, v13
; CHECK-NEXT:    vmand.mm v13, v13, v14
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vv v13, v10, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ueq_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v11, v12
; CHECK-NEXT:    vmand.mm v11, v12, v11
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ueq_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v11, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v11
; CHECK-NEXT:    vmand.mm v11, v11, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    vmflt.vf v11, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ugt_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ugt_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ugt_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uge_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v10, v10
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v8, v10, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uge_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uge_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ult_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ult_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfge.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ult_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfle.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ule_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmfeq.vv v13, v10, v10
; CHECK-NEXT:    vmand.mm v12, v13, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vv v12, v10, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ule_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v12, v10
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_ule_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfeq.vf v12, v10, fa0
; CHECK-NEXT:    vmfeq.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v10, v10, v12
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmflt.vf v10, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_une_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_une_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_une_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uno_vv_v4f64(<4 x double> %va, <4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmfne.vv v12, v10, v10
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vmor.mm v0, v10, v12
; CHECK-NEXT:    ret
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uno_vf_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfne.vf v12, v10, fa0
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vmor.mm v0, v10, v12
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

define <4 x i1> @fcmp_uno_fv_v4f64(<4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfne.vf v12, v10, fa0
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %1 = call <4 x i1> @llvm.experimental.constrained.fcmp.v4f64(<4 x double> %splat, <4 x double> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <4 x i1> %1
}

declare <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double>, <8 x double>, metadata, metadata)
define <8 x i1> @fcmp_oeq_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oeq_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oeq_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ogt_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ogt_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ogt_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oge_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oge_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_oge_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_olt_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_olt_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_olt_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ole_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ole_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ole_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_one_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmfeq.vv v18, v8, v8
; CHECK-NEXT:    vmand.mm v16, v18, v17
; CHECK-NEXT:    vmand.mm v17, v17, v18
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v17
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_one_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v16
; CHECK-NEXT:    vmand.mm v13, v16, v13
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_one_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v13
; CHECK-NEXT:    vmand.mm v13, v13, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ord_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ord_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ord_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ueq_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmfeq.vv v18, v8, v8
; CHECK-NEXT:    vmand.mm v16, v18, v17
; CHECK-NEXT:    vmand.mm v17, v17, v18
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v17
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ueq_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v13, v16
; CHECK-NEXT:    vmand.mm v13, v16, v13
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ueq_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v13, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v13
; CHECK-NEXT:    vmand.mm v13, v13, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ugt_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ugt_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ugt_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uge_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v12, v12
; CHECK-NEXT:    vmfeq.vv v17, v8, v8
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uge_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uge_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ult_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ult_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ult_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ule_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vmfeq.vv v16, v8, v8
; CHECK-NEXT:    vmfeq.vv v17, v12, v12
; CHECK-NEXT:    vmand.mm v16, v17, v16
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ule_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v16, v12
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_ule_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0
; CHECK-NEXT:    vmfeq.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v12, v12, v16
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_une_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_une_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_une_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uno_vv_v8f64(<8 x double> %va, <8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v12, v12
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uno_vf_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfne.vf v16, v12, fa0
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}

define <8 x i1> @fcmp_uno_fv_v8f64(<8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfne.vf v16, v12, fa0
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vmor.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %1 = call <8 x i1> @llvm.experimental.constrained.fcmp.v8f64(<8 x double> %splat, <8 x double> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <8 x i1> %1
}
