.\"
.\" cupsfilter man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cupsfilter 8 "CUPS" "11 June 2014" "Apple Inc."
.SH NAME
cupsfilter \- convert a file to another format using cups filters
.SH SYNOPSIS
.B cupsfilter
[
.B \-\-list\-filters
] [
.B \-D
] [
.B \-U
.I user
] [
.B \-c
.I config-file
] [
.B \-d
.I printer
] [
.B \-e
] [
.B \-i
.I mime/type
] [
.B \-j
.I job-id[,N]
] [
.B \-m
.I mime/type
] [
.B \-n
.I copies
] [
.B \-o
.I name=value
] [
.B \-p
.I filename.ppd
] [
.B \-t
.I title
] [
.B \-u
]
.I filename
.SH DESCRIPTION
.B cupsfilter
is a front-end to the CUPS filter subsystem which allows you to convert a file to a specific format, just as if you had printed the file through CUPS. By default,
.B cupsfilter
generates a PDF file. The converted file is sent to the standard output.
.SH OPTIONS
.TP 5
.B \-\-list\-filters
Do not actually run the filters, just print the filters used to stdout.
.TP 5
.B \-D
Delete the input file after conversion.
.TP 5
\fB\-U \fIuser\fR
Specifies the username passed to the filters. The default is the name of the current user.
.TP 5
\fB\-c \fIconfig-file\fR
Uses the named cups-files.conf configuration file.
.TP 5
\fB\-d \fIprinter\fR
Uses information from the named printer.
.TP 5
.B \-e
Use every filter from the PPD file.
.TP 5
\fB\-i \fImime/type\fR
Specifies the source file type. The default file type is guessed using the filename and contents of the file.
.TP 5
\fB\-j \fIjob-id[,N]\fR
Converts document N from the specified job. If N is omitted, document 1 is converted.
.TP 5
\fB\-m \fImime/type\fR
Specifies the destination file type. The default file type is application/pdf. Use printer/foo to convert to the printer format defined by the filters in the PPD file.
.TP 5
\fB\-n \fIcopies\fR
Specifies the number of copies to generate.
.TP 5
\fB\-o \fIname=value\fR
Specifies options to pass to the CUPS filters.
.TP 5
\fB\-p \fIfilename.ppd\fR
Specifies the PPD file to use.
.TP 5
\fB\-t \fItitle\fR
Specifies the document title.
.TP 5
.B \-u
Delete the PPD file after conversion.
.SH EXIT STATUS
.B cupsfilter
returns a non-zero exit status on any error.
.SH ENVIRONMENT
All of the standard
.BR cups (1)
environment variables affect the operation of
.BR cupsfilter .
.SH FILES
.nf
/etc/cups/cups-files.conf
/etc/cups/*.convs
/etc/cups/*.types
/usr/share/cups/mime/*.convs
/usr/share/cups/mime/*.types
.SH NOTES
Unlike when printing, filters run using the
.B cupsfilter
command use the current user and security session. This may result in different output or unexpected behavior.
.SH EXAMPLE
The following command will generate a PDF preview of job 42 for a printer named "myprinter" and save it to a file named "preview.pdf":
.nf

    cupsfilter -m application/pdf -d myprinter -j 42 >preview.pdf
.fi
.SH SEE ALSO
.BR cups (1),
.BR cupsd.conf (5),
.BR filter(7),
.BR mime.convs (7),
.BR mime.types (7),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2017 by Apple Inc.
