; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mtriple=amdgcn-- -verify-machineinstrs -o - %s | FileCheck -check-prefix=SI %s
; RUN: llc -march=amdgcn -mtriple=amdgcn-- -mcpu=gfx900 -verify-machineinstrs -o - %s | FileCheck -check-prefix=GFX9 %s

define <4 x i16> @extract_4xi16(<8 x i16> addrspace(1) * %p0, <8 x i16> addrspace(1) * %p1) {
; SI-LABEL: extract_4xi16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cbranch_scc0 .LBB0_2
; SI-NEXT:  ; %bb.1: ; %F
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_ushort v4, v[2:3], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v5, v[2:3], s[4:7], 0 addr64 offset:2 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v6, v[2:3], s[4:7], 0 addr64 offset:4 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v7, v[2:3], s[4:7], 0 addr64 offset:6 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v8, v[2:3], s[4:7], 0 addr64 offset:8 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v8, v[2:3], s[4:7], 0 addr64 offset:10 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v8, v[2:3], s[4:7], 0 addr64 offset:12 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, v[2:3], s[4:7], 0 addr64 offset:14 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; SI-NEXT:    v_or_b32_e32 v2, v6, v2
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; SI-NEXT:    s_mov_b64 vcc, exec
; SI-NEXT:    s_cbranch_execz .LBB0_3
; SI-NEXT:    s_branch .LBB0_4
; SI-NEXT:  .LBB0_2:
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    s_mov_b64 vcc, 0
; SI-NEXT:  .LBB0_3: ; %T
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_ushort v3, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64 offset:2 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v4, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v5, v[0:1], s[4:7], 0 addr64 offset:6 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v6, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v6, v[0:1], s[4:7], 0 addr64 offset:10 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v6, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64 offset:14 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v4, v0
; SI-NEXT:    v_or_b32_e32 v3, v3, v1
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; SI-NEXT:  .LBB0_4: ; %exit
; SI-NEXT:    v_bfe_i32 v0, v3, 0, 16
; SI-NEXT:    v_bfe_i32 v1, v4, 0, 16
; SI-NEXT:    v_bfe_i32 v2, v2, 0, 16
; SI-NEXT:    s_mov_b32 s4, 0xffff
; SI-NEXT:    v_mov_b32_e32 v3, 0x8000
; SI-NEXT:    v_mov_b32_e32 v4, 0xffff0000
; SI-NEXT:    v_bfrev_b32_e32 v5, 1
; SI-NEXT:    v_mov_b32_e32 v6, 0xffff8000
; SI-NEXT:    v_mov_b32_e32 v7, s4
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, -1, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, v7, v3, vcc
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, -1, v1
; SI-NEXT:    v_cndmask_b32_e32 v1, v4, v5, vcc
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, -1, v2
; SI-NEXT:    v_cndmask_b32_e32 v2, -1, v6, vcc
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_and_b32_e32 v2, s4, v2
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: extract_4xi16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cbranch_scc0 .LBB0_2
; GFX9-NEXT:  ; %bb.1: ; %F
; GFX9-NEXT:    global_load_dwordx4 v[2:5], v[2:3], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_cbranch_execz .LBB0_3
; GFX9-NEXT:    s_branch .LBB0_4
; GFX9-NEXT:  .LBB0_2:
; GFX9-NEXT:    s_mov_b32 s8, 0
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s8
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:  .LBB0_3: ; %T
; GFX9-NEXT:    global_load_dwordx4 v[2:5], v[0:1], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:  .LBB0_4: ; %exit
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, 15, v3 op_sel_hi:[0,0]
; GFX9-NEXT:    s_movk_i32 s4, 0x8000
; GFX9-NEXT:    v_or_b32_sdwa v1, v0, s4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, s4, v0
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, 15, v2 op_sel_hi:[0,1]
; GFX9-NEXT:    v_or_b32_sdwa v2, v0, s4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xffff
; GFX9-NEXT:    v_and_b32_e32 v0, v4, v0
; GFX9-NEXT:    v_lshl_or_b32 v0, v2, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v2, v4, v3
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  br i1 undef, label %T, label %F

T:
  %t = load volatile <8 x i16>, <8 x i16> addrspace(1) * %p0
  br label %exit

F:
  %f = load volatile <8 x i16>, <8 x i16> addrspace(1) * %p1
  br label %exit

exit:
  %m = phi <8 x i16> [ %t, %T ], [ %f, %F ]
  %v2 = shufflevector <8 x i16> %m, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 2>
  %b2 = icmp sgt <4 x i16> %v2, <i16 -1, i16 -1, i16 -1, i16 -1>
  %r2 = select <4 x i1> %b2, <4 x i16> <i16 -32768, i16 -32768, i16 -32768, i16 -32768>, <4 x i16> <i16 -1, i16 -1, i16 -1, i16 -1>
  ret <4 x i16> %r2
}

define <4 x i16> @extract_4xi16_2(<8 x i16> addrspace(1) * %p0, <8 x i16> addrspace(1) * %p1) {
; SI-LABEL: extract_4xi16_2:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cbranch_scc0 .LBB1_2
; SI-NEXT:  ; %bb.1: ; %F
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_ushort v4, v[2:3], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v4, v[2:3], s[4:7], 0 addr64 offset:2 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v4, v[2:3], s[4:7], 0 addr64 offset:4 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v4, v[2:3], s[4:7], 0 addr64 offset:6 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v4, v[2:3], s[4:7], 0 addr64 offset:8 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v5, v[2:3], s[4:7], 0 addr64 offset:10 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v6, v[2:3], s[4:7], 0 addr64 offset:12 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, v[2:3], s[4:7], 0 addr64 offset:14 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; SI-NEXT:    v_or_b32_e32 v2, v6, v2
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; SI-NEXT:    s_mov_b64 vcc, exec
; SI-NEXT:    s_cbranch_execz .LBB1_3
; SI-NEXT:    s_branch .LBB1_4
; SI-NEXT:  .LBB1_2:
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    s_mov_b64 vcc, 0
; SI-NEXT:  .LBB1_3: ; %T
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64 offset:2 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64 offset:6 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v3, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64 offset:10 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v4, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64 offset:14 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v4, v0
; SI-NEXT:    v_or_b32_e32 v3, v3, v1
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; SI-NEXT:  .LBB1_4: ; %exit
; SI-NEXT:    v_bfe_i32 v0, v3, 0, 16
; SI-NEXT:    v_bfe_i32 v1, v5, 0, 16
; SI-NEXT:    v_bfe_i32 v2, v2, 0, 16
; SI-NEXT:    v_bfe_i32 v3, v4, 0, 16
; SI-NEXT:    v_mov_b32_e32 v4, 0xffff
; SI-NEXT:    v_mov_b32_e32 v5, 0x8000
; SI-NEXT:    v_mov_b32_e32 v6, 0xffff0000
; SI-NEXT:    v_bfrev_b32_e32 v7, 1
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, -1, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, -1, v1
; SI-NEXT:    v_cndmask_b32_e32 v1, v6, v7, vcc
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, -1, v2
; SI-NEXT:    v_cndmask_b32_e32 v2, v4, v5, vcc
; SI-NEXT:    v_cmp_lt_i32_e32 vcc, -1, v3
; SI-NEXT:    v_cndmask_b32_e32 v3, v6, v7, vcc
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: extract_4xi16_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_2
; GFX9-NEXT:  ; %bb.1: ; %F
; GFX9-NEXT:    global_load_dwordx4 v[2:5], v[2:3], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_cbranch_execz .LBB1_3
; GFX9-NEXT:    s_branch .LBB1_4
; GFX9-NEXT:  .LBB1_2:
; GFX9-NEXT:    s_mov_b32 s8, 0
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s8
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:  .LBB1_3: ; %T
; GFX9-NEXT:    global_load_dwordx4 v[2:5], v[0:1], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:  .LBB1_4: ; %exit
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, 15, v5 op_sel_hi:[0,1]
; GFX9-NEXT:    s_movk_i32 s4, 0x8000
; GFX9-NEXT:    v_or_b32_sdwa v1, v0, s4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, s4, v0
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, 15, v4 op_sel_hi:[0,1]
; GFX9-NEXT:    v_or_b32_sdwa v3, v0, s4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xffff
; GFX9-NEXT:    v_and_b32_e32 v0, v4, v0
; GFX9-NEXT:    v_and_b32_e32 v2, v4, v2
; GFX9-NEXT:    v_lshl_or_b32 v0, v3, 16, v0
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  br i1 undef, label %T, label %F

T:
  %t = load volatile <8 x i16>, <8 x i16> addrspace(1) * %p0
  br label %exit

F:
  %f = load volatile <8 x i16>, <8 x i16> addrspace(1) * %p1
  br label %exit

exit:
  %m = phi <8 x i16> [ %t, %T ], [ %f, %F ]
  %v2 = shufflevector <8 x i16> %m, <8 x i16> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %b2 = icmp sgt <4 x i16> %v2, <i16 -1, i16 -1, i16 -1, i16 -1>
  %r2 = select <4 x i1> %b2, <4 x i16> <i16 -32768, i16 -32768, i16 -32768, i16 -32768>, <4 x i16> <i16 -1, i16 -1, i16 -1, i16 -1>
  ret <4 x i16> %r2
}

define <4 x half> @extract_4xf16(<8 x half> addrspace(1) * %p0, <8 x half> addrspace(1) * %p1) {
; SI-LABEL: extract_4xf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cbranch_scc0 .LBB2_2
; SI-NEXT:  ; %bb.1: ; %F
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_ushort v4, v[2:3], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v5, v[2:3], s[4:7], 0 addr64 offset:2 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v6, v[2:3], s[4:7], 0 addr64 offset:4 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v7, v[2:3], s[4:7], 0 addr64 offset:6 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v8, v[2:3], s[4:7], 0 addr64 offset:8 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v8, v[2:3], s[4:7], 0 addr64 offset:10 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v8, v[2:3], s[4:7], 0 addr64 offset:12 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v2, v[2:3], s[4:7], 0 addr64 offset:14 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; SI-NEXT:    v_or_b32_e32 v2, v6, v2
; SI-NEXT:    v_or_b32_e32 v4, v4, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v4
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    s_mov_b64 vcc, exec
; SI-NEXT:    s_cbranch_execz .LBB2_3
; SI-NEXT:    s_branch .LBB2_4
; SI-NEXT:  .LBB2_2:
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    s_mov_b64 vcc, 0
; SI-NEXT:  .LBB2_3: ; %T
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s4, s6
; SI-NEXT:    s_mov_b32 s5, s6
; SI-NEXT:    buffer_load_ushort v2, v[0:1], s[4:7], 0 addr64 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v3, v[0:1], s[4:7], 0 addr64 offset:2 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v4, v[0:1], s[4:7], 0 addr64 offset:4 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v5, v[0:1], s[4:7], 0 addr64 offset:6 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v6, v[0:1], s[4:7], 0 addr64 offset:8 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v6, v[0:1], s[4:7], 0 addr64 offset:10 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v6, v[0:1], s[4:7], 0 addr64 offset:12 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ushort v0, v[0:1], s[4:7], 0 addr64 offset:14 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; SI-NEXT:    v_or_b32_e32 v0, v4, v0
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v1
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v0
; SI-NEXT:  .LBB2_4: ; %exit
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_mov_b32_e32 v3, 0x3fa00000
; SI-NEXT:    v_mov_b32_e32 v4, 0x3f200000
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cmp_nge_f32_e32 vcc, 0.5, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; SI-NEXT:    v_cmp_nge_f32_e32 vcc, 0.5, v1
; SI-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; SI-NEXT:    v_cmp_nge_f32_e32 vcc, 0.5, v2
; SI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v3, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: extract_4xf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cbranch_scc0 .LBB2_2
; GFX9-NEXT:  ; %bb.1: ; %F
; GFX9-NEXT:    global_load_dwordx4 v[2:5], v[2:3], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_cbranch_execz .LBB2_3
; GFX9-NEXT:    s_branch .LBB2_4
; GFX9-NEXT:  .LBB2_2:
; GFX9-NEXT:    s_mov_b32 s8, 0
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s8
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:  .LBB2_3: ; %T
; GFX9-NEXT:    global_load_dwordx4 v[2:5], v[0:1], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:  .LBB2_4: ; %exit
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v3
; GFX9-NEXT:    v_lshl_or_b32 v0, v3, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x3800
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x3900
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x3d00
; GFX9-NEXT:    v_cmp_ge_f16_e32 vcc, 0.5, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v3, v4, vcc
; GFX9-NEXT:    v_cmp_nle_f16_sdwa vcc, v0, v1 src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v4, v3, vcc
; GFX9-NEXT:    v_cmp_ge_f16_e32 vcc, 0.5, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GFX9-NEXT:    v_cmp_le_f16_sdwa vcc, v2, v1 src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v4, vcc
; GFX9-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-NEXT:    v_pack_b32_f16 v1, v5, v6
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  br i1 undef, label %T, label %F

T:
  %t = load volatile <8 x half>, <8 x half> addrspace(1) * %p0
  br label %exit

F:
  %f = load volatile <8 x half>, <8 x half> addrspace(1) * %p1
  br label %exit

exit:
  %m = phi <8 x half> [ %t, %T ], [ %f, %F ]
  %v2 = shufflevector <8 x half> %m, <8 x half> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 2>
  %b2 = fcmp ugt <4 x half> %v2, <half 0xH3800, half 0xH3800, half 0xH3800, half 0xH3800>
  %r2 = select <4 x i1> %b2, <4 x half> <half 0xH3900, half 0xH3900, half 0xH3900, half 0xH3900>, <4 x half> <half 0xH3D00, half 0xH3D00, half 0xH3D00, half 0xH3D00>
  ret <4 x half> %r2
}
