"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.installDeps = void 0;
const child_process_1 = __importDefault(require("child_process"));
const os_1 = __importDefault(require("os"));
const path_1 = __importDefault(require("path"));
const ubuntuVersion_1 = require("../utils/ubuntuVersion");
const utils = __importStar(require("../utils/utils"));
const { deps } = require('../nativeDeps');
const SCRIPTS_DIRECTORY = path_1.default.join(__dirname, '..', '..', 'bin');
async function installDeps(browserTypes) {
    if (!browserTypes.length)
        browserTypes = ['chromium', 'firefox', 'webkit'];
    if (os_1.default.platform() === 'win32') {
        if (browserTypes.includes('chromium')) {
            const { code } = await utils.spawnAsync('powershell.exe', [path_1.default.join(SCRIPTS_DIRECTORY, 'install_media_pack.ps1')], { cwd: SCRIPTS_DIRECTORY, stdio: 'inherit' });
            if (code !== 0)
                throw new Error('Failed to install windows dependencies!');
        }
        return;
    }
    if (os_1.default.platform() !== 'linux')
        return;
    browserTypes.push('tools');
    const ubuntuVersion = await ubuntuVersion_1.getUbuntuVersion();
    if (ubuntuVersion !== '18.04' && ubuntuVersion !== '20.04' && ubuntuVersion !== '21.04') {
        console.warn('Cannot install dependencies for this linux distribution!'); // eslint-disable-line no-console
        return;
    }
    const libraries = [];
    for (const browserType of browserTypes) {
        if (ubuntuVersion === '18.04')
            libraries.push(...deps['bionic'][browserType]);
        else if (ubuntuVersion === '20.04')
            libraries.push(...deps['focal'][browserType]);
        else if (ubuntuVersion === '21.04')
            libraries.push(...deps['hirsute'][browserType]);
    }
    const uniqueLibraries = Array.from(new Set(libraries));
    console.log('Installing Ubuntu dependencies...'); // eslint-disable-line no-console
    const commands = [];
    commands.push('apt-get update');
    commands.push(['apt-get', 'install', '-y', '--no-install-recommends',
        ...uniqueLibraries,
    ].join(' '));
    const isRoot = (process.getuid() === 0);
    const child = isRoot ?
        child_process_1.default.spawn('sh', ['-c', `${commands.join('; ')}`], { stdio: 'inherit' }) :
        child_process_1.default.spawn('sudo', ['--', 'sh', '-c', `${commands.join('; ')}`], { stdio: 'inherit' });
    await new Promise(f => child.on('exit', f));
}
exports.installDeps = installDeps;
//# sourceMappingURL=installDeps.js.map