/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.core;

import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.type.JavaType;
import com.android.tools.build.jetifier.core.utils.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/build/jetifier/core/TypeRewriter;", "", "config", "Lcom/android/tools/build/jetifier/core/config/Config;", "useFallback", "", "(Lcom/android/tools/build/jetifier/core/config/Config;Z)V", "rewriteType", "Lcom/android/tools/build/jetifier/core/type/JavaType;", "type", "Companion", "jetifier-core"})
public final class TypeRewriter {
    private final Config config;
    private final boolean useFallback;
    private static final String TAG = "TypeRewriter";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final JavaType rewriteType(@NotNull JavaType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        JavaType result = this.config.getTypesMap().mapType(type);
        if (result != null) {
            Log.INSTANCE.i(TAG, "Map: %s -> %s", type, result);
            return result;
        }
        if (!this.config.isEligibleForRewrite(type)) {
            return type;
        }
        if (!this.useFallback) {
            Log.INSTANCE.e(TAG, "No mapping for: " + type, new Object[0]);
            return null;
        }
        JavaType rulesResult = this.config.getRulesMap().rewriteType(type);
        if (rulesResult != null) {
            Log.INSTANCE.i(TAG, "Using fallback: %s -> %s", type, rulesResult);
            return rulesResult;
        }
        return null;
    }

    public TypeRewriter(@NotNull Config config, boolean useFallback) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.useFallback = useFallback;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/build/jetifier/core/TypeRewriter$Companion;", "", "()V", "TAG", "", "jetifier-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

