; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test that the strpbrk library call simplifier works correctly.
;
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128"

@hello = constant [12 x i8] c"hello world\00"
@w = constant [2 x i8] c"w\00"
@null = constant [1 x i8] zeroinitializer

declare ptr @strpbrk(ptr, ptr)

; Check strpbrk(s, "") -> NULL.

define ptr @test_simplify1(ptr %str) {
; CHECK-LABEL: @test_simplify1(
; CHECK-NEXT:    ret ptr null
;

  %ret = call ptr @strpbrk(ptr %str, ptr @null)
  ret ptr %ret
}

; Check strpbrk("", s) -> NULL.

define ptr @test_simplify2(ptr %pat) {
; CHECK-LABEL: @test_simplify2(
; CHECK-NEXT:    ret ptr null
;

  %ret = call ptr @strpbrk(ptr @null, ptr %pat)
  ret ptr %ret
}

; Check strpbrk(s1, s2), where s1 and s2 are constants.

define ptr @test_simplify3() {
; CHECK-LABEL: @test_simplify3(
; CHECK-NEXT:    ret ptr getelementptr inbounds ([12 x i8], ptr @hello, i32 0, i32 6)
;

  %ret = call ptr @strpbrk(ptr @hello, ptr @w)
  ret ptr %ret
}

; Check strpbrk(s, "a") -> strchr(s, 'a').

define ptr @test_simplify4(ptr %str) {
; CHECK-LABEL: @test_simplify4(
; CHECK-NEXT:    [[STRCHR:%.*]] = call ptr @strchr(ptr noundef nonnull dereferenceable(1) [[STR:%.*]], i32 119)
; CHECK-NEXT:    ret ptr [[STRCHR]]
;

  %ret = call ptr @strpbrk(ptr %str, ptr @w)
  ret ptr %ret
}

; Check cases that shouldn't be simplified.

define ptr @test_no_simplify1(ptr %str, ptr %pat) {
; CHECK-LABEL: @test_no_simplify1(
; CHECK-NEXT:    [[RET:%.*]] = call ptr @strpbrk(ptr [[STR:%.*]], ptr [[PAT:%.*]])
; CHECK-NEXT:    ret ptr [[RET]]
;

  %ret = call ptr @strpbrk(ptr %str, ptr %pat)
  ret ptr %ret
}
