; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare <vscale x 1 x half> @llvm.experimental.constrained.fdiv.nxv1f16(<vscale x 1 x half>, <vscale x 1 x half>, metadata, metadata)
define <vscale x 1 x half> @vfdiv_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv1f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 1 x half> @llvm.experimental.constrained.fdiv.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 1 x half> %vc
}

define <vscale x 1 x half> @vfdiv_vf_nxv1f16(<vscale x 1 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %vc = call <vscale x 1 x half> @llvm.experimental.constrained.fdiv.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 1 x half> %vc
}

declare <vscale x 2 x half> @llvm.experimental.constrained.fdiv.nxv2f16(<vscale x 2 x half>, <vscale x 2 x half>, metadata, metadata)
define <vscale x 2 x half> @vfdiv_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 2 x half> @llvm.experimental.constrained.fdiv.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 2 x half> %vc
}

define <vscale x 2 x half> @vfdiv_vf_nxv2f16(<vscale x 2 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %vc = call <vscale x 2 x half> @llvm.experimental.constrained.fdiv.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 2 x half> %vc
}

declare <vscale x 4 x half> @llvm.experimental.constrained.fdiv.nxv4f16(<vscale x 4 x half>, <vscale x 4 x half>, metadata, metadata)
define <vscale x 4 x half> @vfdiv_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 4 x half> @llvm.experimental.constrained.fdiv.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 4 x half> %vc
}

define <vscale x 4 x half> @vfdiv_vf_nxv4f16(<vscale x 4 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %vc = call <vscale x 4 x half> @llvm.experimental.constrained.fdiv.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 4 x half> %vc
}

declare <vscale x 8 x half> @llvm.experimental.constrained.fdiv.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>, metadata, metadata)
define <vscale x 8 x half> @vfdiv_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 8 x half> @llvm.experimental.constrained.fdiv.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 8 x half> %vc
}

define <vscale x 8 x half> @vfdiv_vf_nxv8f16(<vscale x 8 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = call <vscale x 8 x half> @llvm.experimental.constrained.fdiv.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 8 x half> %vc
}

define <vscale x 8 x half> @vfdiv_fv_nxv8f16(<vscale x 8 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfdiv_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfrdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vc = call <vscale x 8 x half> @llvm.experimental.constrained.fdiv.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 8 x half> %vc
}

declare <vscale x 16 x half> @llvm.experimental.constrained.fdiv.nxv16f16(<vscale x 16 x half>, <vscale x 16 x half>, metadata, metadata)
define <vscale x 16 x half> @vfdiv_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 16 x half> @llvm.experimental.constrained.fdiv.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 16 x half> %vc
}

define <vscale x 16 x half> @vfdiv_vf_nxv16f16(<vscale x 16 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %vc = call <vscale x 16 x half> @llvm.experimental.constrained.fdiv.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 16 x half> %vc
}

declare <vscale x 32 x half> @llvm.experimental.constrained.fdiv.nxv32f16(<vscale x 32 x half>, <vscale x 32 x half>, metadata, metadata)
define <vscale x 32 x half> @vfdiv_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv32f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 32 x half> @llvm.experimental.constrained.fdiv.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 32 x half> %vc
}

define <vscale x 32 x half> @vfdiv_vf_nxv32f16(<vscale x 32 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %vc = call <vscale x 32 x half> @llvm.experimental.constrained.fdiv.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 32 x half> %vc
}

declare <vscale x 1 x float> @llvm.experimental.constrained.fdiv.nxv1f32(<vscale x 1 x float>, <vscale x 1 x float>, metadata, metadata)
define <vscale x 1 x float> @vfdiv_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv1f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 1 x float> @llvm.experimental.constrained.fdiv.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 1 x float> %vc
}

define <vscale x 1 x float> @vfdiv_vf_nxv1f32(<vscale x 1 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %vc = call <vscale x 1 x float> @llvm.experimental.constrained.fdiv.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 1 x float> %vc
}

declare <vscale x 2 x float> @llvm.experimental.constrained.fdiv.nxv2f32(<vscale x 2 x float>, <vscale x 2 x float>, metadata, metadata)
define <vscale x 2 x float> @vfdiv_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 2 x float> @llvm.experimental.constrained.fdiv.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 2 x float> %vc
}

define <vscale x 2 x float> @vfdiv_vf_nxv2f32(<vscale x 2 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %vc = call <vscale x 2 x float> @llvm.experimental.constrained.fdiv.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 2 x float> %vc
}

declare <vscale x 4 x float> @llvm.experimental.constrained.fdiv.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>, metadata, metadata)
define <vscale x 4 x float> @vfdiv_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 4 x float> @llvm.experimental.constrained.fdiv.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 4 x float> %vc
}

define <vscale x 4 x float> @vfdiv_vf_nxv4f32(<vscale x 4 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %vc = call <vscale x 4 x float> @llvm.experimental.constrained.fdiv.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 4 x float> %vc
}

declare <vscale x 8 x float> @llvm.experimental.constrained.fdiv.nxv8f32(<vscale x 8 x float>, <vscale x 8 x float>, metadata, metadata)
define <vscale x 8 x float> @vfdiv_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 8 x float> @llvm.experimental.constrained.fdiv.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 8 x float> %vc
}

define <vscale x 8 x float> @vfdiv_vf_nxv8f32(<vscale x 8 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = call <vscale x 8 x float> @llvm.experimental.constrained.fdiv.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 8 x float> %vc
}

define <vscale x 8 x float> @vfdiv_fv_nxv8f32(<vscale x 8 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfdiv_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfrdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vc = call <vscale x 8 x float> @llvm.experimental.constrained.fdiv.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 8 x float> %vc
}

declare <vscale x 16 x float> @llvm.experimental.constrained.fdiv.nxv16f32(<vscale x 16 x float>, <vscale x 16 x float>, metadata, metadata)
define <vscale x 16 x float> @vfdiv_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv16f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 16 x float> @llvm.experimental.constrained.fdiv.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 16 x float> %vc
}

define <vscale x 16 x float> @vfdiv_vf_nxv16f32(<vscale x 16 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %vc = call <vscale x 16 x float> @llvm.experimental.constrained.fdiv.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 16 x float> %vc
}

declare <vscale x 1 x double> @llvm.experimental.constrained.fdiv.nxv1f64(<vscale x 1 x double>, <vscale x 1 x double>, metadata, metadata)
define <vscale x 1 x double> @vfdiv_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv1f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 1 x double> @llvm.experimental.constrained.fdiv.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 1 x double> %vc
}

define <vscale x 1 x double> @vfdiv_vf_nxv1f64(<vscale x 1 x double> %va, double %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %vc = call <vscale x 1 x double> @llvm.experimental.constrained.fdiv.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 1 x double> %vc
}

declare <vscale x 2 x double> @llvm.experimental.constrained.fdiv.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>, metadata, metadata)
define <vscale x 2 x double> @vfdiv_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 2 x double> @llvm.experimental.constrained.fdiv.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 2 x double> %vc
}

define <vscale x 2 x double> @vfdiv_vf_nxv2f64(<vscale x 2 x double> %va, double %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %vc = call <vscale x 2 x double> @llvm.experimental.constrained.fdiv.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 2 x double> %vc
}

declare <vscale x 4 x double> @llvm.experimental.constrained.fdiv.nxv4f64(<vscale x 4 x double>, <vscale x 4 x double>, metadata, metadata)
define <vscale x 4 x double> @vfdiv_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 4 x double> @llvm.experimental.constrained.fdiv.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 4 x double> %vc
}

define <vscale x 4 x double> @vfdiv_vf_nxv4f64(<vscale x 4 x double> %va, double %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %vc = call <vscale x 4 x double> @llvm.experimental.constrained.fdiv.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 4 x double> %vc
}

declare <vscale x 8 x double> @llvm.experimental.constrained.fdiv.nxv8f64(<vscale x 8 x double>, <vscale x 8 x double>, metadata, metadata)
define <vscale x 8 x double> @vfdiv_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) strictfp {
; CHECK-LABEL: vfdiv_vv_nxv8f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfdiv.vv v8, v8, v16
; CHECK-NEXT:    ret
entry:
  %vc = call <vscale x 8 x double> @llvm.experimental.constrained.fdiv.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 8 x double> %vc
}

define <vscale x 8 x double> @vfdiv_vf_nxv8f64(<vscale x 8 x double> %va, double %b) strictfp {
; CHECK-LABEL: vfdiv_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = call <vscale x 8 x double> @llvm.experimental.constrained.fdiv.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 8 x double> %vc
}

define <vscale x 8 x double> @vfdiv_fv_nxv8f64(<vscale x 8 x double> %va, double %b) strictfp {
; CHECK-LABEL: vfdiv_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfrdiv.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %vc = call <vscale x 8 x double> @llvm.experimental.constrained.fdiv.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <vscale x 8 x double> %vc
}
