; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+f --verify-machineinstrs < %s | FileCheck %s
; RUN: llc --mtriple=loongarch64 --mattr=+f --verify-machineinstrs < %s | FileCheck %s

declare void @llvm.loongarch.dbar(i32)
declare void @llvm.loongarch.ibar(i32)
declare void @llvm.loongarch.break(i32)
declare void @llvm.loongarch.movgr2fcsr(i32, i32)
declare i32 @llvm.loongarch.movfcsr2gr(i32)
declare void @llvm.loongarch.syscall(i32)
declare i32 @llvm.loongarch.csrrd.w(i32 immarg)
declare i32 @llvm.loongarch.csrwr.w(i32, i32 immarg)
declare i32 @llvm.loongarch.csrxchg.w(i32, i32, i32 immarg)
declare i32 @llvm.loongarch.iocsrrd.b(i32)
declare i32 @llvm.loongarch.iocsrrd.h(i32)
declare i32 @llvm.loongarch.iocsrrd.w(i32)
declare void @llvm.loongarch.iocsrwr.b(i32, i32)
declare void @llvm.loongarch.iocsrwr.h(i32, i32)
declare void @llvm.loongarch.iocsrwr.w(i32, i32)
declare i32 @llvm.loongarch.cpucfg(i32)

define void @foo() nounwind {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    dbar 0
; CHECK-NEXT:    ret
entry:
  call void @llvm.loongarch.dbar(i32 0)
  ret void
}

define void @ibar() nounwind {
; CHECK-LABEL: ibar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ibar 0
; CHECK-NEXT:    ret
entry:
  call void @llvm.loongarch.ibar(i32 0)
  ret void
}

define void @break() nounwind {
; CHECK-LABEL: break:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    break 1
; CHECK-NEXT:    ret
entry:
  call void @llvm.loongarch.break(i32 1)
  ret void
}

define void @movgr2fcsr(i32 %a) nounwind {
; CHECK-LABEL: movgr2fcsr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movgr2fcsr $fcsr1, $a0
; CHECK-NEXT:    ret
entry:
  call void @llvm.loongarch.movgr2fcsr(i32 1, i32 %a)
  ret void
}

define i32 @movfcsr2gr() nounwind {
; CHECK-LABEL: movfcsr2gr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movfcsr2gr $a0, $fcsr1
; CHECK-NEXT:    ret
entry:
  %res = call i32 @llvm.loongarch.movfcsr2gr(i32 1)
  ret i32 %res
}

;; TODO: Optimize out `movfcsr2gr` without data-dependency.
define void @movfcsr2gr_noret() nounwind {
; CHECK-LABEL: movfcsr2gr_noret:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movfcsr2gr $a0, $fcsr1
; CHECK-NEXT:    ret
entry:
  %res = call i32 @llvm.loongarch.movfcsr2gr(i32 1)
  ret void
}

define void @syscall() nounwind {
; CHECK-LABEL: syscall:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    syscall 1
; CHECK-NEXT:    ret
entry:
  call void @llvm.loongarch.syscall(i32 1)
  ret void
}

define i32 @csrrd_w() {
; CHECK-LABEL: csrrd_w:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    csrrd $a0, 1
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.csrrd.w(i32 1)
  ret i32 %0
}

define void @csrrd_w_noret() {
; CHECK-LABEL: csrrd_w_noret:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    csrrd $a0, 1
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.csrrd.w(i32 1)
  ret void
}

define i32 @csrwr_w(i32 signext %a) {
; CHECK-LABEL: csrwr_w:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    csrwr $a0, 1
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.csrwr.w(i32 %a, i32 1)
  ret i32 %0
}

;; Check that csrwr is emitted even if the return value of the intrinsic is not used.
define void @csrwr_w_noret(i32 signext %a) {
; CHECK-LABEL: csrwr_w_noret:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    csrwr $a0, 1
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.csrwr.w(i32 %a, i32 1)
  ret void
}

define i32 @csrxchg_w(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: csrxchg_w:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    csrxchg $a0, $a1, 1
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.csrxchg.w(i32 %a, i32 %b, i32 1)
  ret i32 %0
}

;; Check that csrxchg is emitted even if the return value of the intrinsic is not used.
define void @csrxchg_w_noret(i32 signext %a, i32 signext %b) {
; CHECK-LABEL: csrxchg_w_noret:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    csrxchg $a0, $a1, 1
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.csrxchg.w(i32 %a, i32 %b, i32 1)
  ret void
}

define i32 @iocsrrd_b(i32 %a) {
; CHECK-LABEL: iocsrrd_b:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    iocsrrd.b $a0, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.iocsrrd.b(i32 %a)
  ret i32 %0
}

define i32 @iocsrrd_h(i32 %a) {
; CHECK-LABEL: iocsrrd_h:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    iocsrrd.h $a0, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.iocsrrd.h(i32 %a)
  ret i32 %0
}

define i32 @iocsrrd_w(i32 %a) {
; CHECK-LABEL: iocsrrd_w:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    iocsrrd.w $a0, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.iocsrrd.w(i32 %a)
  ret i32 %0
}

define void @iocsrrd_b_noret(i32 %a) {
; CHECK-LABEL: iocsrrd_b_noret:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    iocsrrd.b $a0, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.iocsrrd.b(i32 %a)
  ret void
}

define void @iocsrrd_h_noret(i32 %a) {
; CHECK-LABEL: iocsrrd_h_noret:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    iocsrrd.h $a0, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.iocsrrd.h(i32 %a)
  ret void
}

define void @iocsrrd_w_noret(i32 %a) {
; CHECK-LABEL: iocsrrd_w_noret:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    iocsrrd.w $a0, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.iocsrrd.w(i32 %a)
  ret void
}

define void @iocsrwr_b(i32 %a, i32 %b) {
; CHECK-LABEL: iocsrwr_b:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    iocsrwr.b $a0, $a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.loongarch.iocsrwr.b(i32 %a, i32 %b)
  ret void
}

define void @iocsrwr_h(i32 %a, i32 %b) {
; CHECK-LABEL: iocsrwr_h:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    iocsrwr.h $a0, $a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.loongarch.iocsrwr.h(i32 %a, i32 %b)
  ret void
}

define void @iocsrwr_w(i32 %a, i32 %b) {
; CHECK-LABEL: iocsrwr_w:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    iocsrwr.w $a0, $a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.loongarch.iocsrwr.w(i32 %a, i32 %b)
  ret void
}

define i32 @cpucfg(i32 %a) {
; CHECK-LABEL: cpucfg:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cpucfg $a0, $a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.cpucfg(i32 %a)
  ret i32 %0
}

define void @cpucfg_noret(i32 %a) {
; CHECK-LABEL: cpucfg_noret:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ret
entry:
  %0 = tail call i32 @llvm.loongarch.cpucfg(i32 %a)
  ret void
}
