; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mcpu=yonah | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:64:64-v128:128:128-a0:0:64-f80:128:128"
target triple = "i686-apple-darwin8"

; This should store directly into P from the FP stack.  It should not
; go through a stack slot to get there.

define void @bar(ptr %P) {
; CHECK-LABEL: bar:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    pushl %esi
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    subl $8, %esp
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset %esi, -8
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-NEXT:    calll _foo
; CHECK-NEXT:    fstpl (%esi)
; CHECK-NEXT:    addl $8, %esp
; CHECK-NEXT:    popl %esi
; CHECK-NEXT:    retl
entry:
	%tmp = tail call double (...) @foo( )		; <double> [#uses=1]
	store double %tmp, ptr %P, align 8
	ret void
}

declare double @foo(...)

define void @bar2(ptr %P) {
; CHECK-LABEL: bar2:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    pushl %esi
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    subl $8, %esp
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset %esi, -8
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-NEXT:    calll _foo2
; CHECK-NEXT:    fstps (%esi)
; CHECK-NEXT:    addl $8, %esp
; CHECK-NEXT:    popl %esi
; CHECK-NEXT:    retl
entry:
	%tmp = tail call double (...) @foo2( )		; <double> [#uses=1]
	%tmp1 = fptrunc double %tmp to float		; <float> [#uses=1]
	store float %tmp1, ptr %P, align 4
	ret void
}

declare double @foo2(...)

