; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals
; RUN: opt < %s -passes=simplifycfg -simplifycfg-require-and-preserve-domtree=1 -hoist-common-insts=true -S | FileCheck %s

define void @hoist_range(i1 %c, ptr %p) {
; CHECK-LABEL: @hoist_range(
; CHECK-NEXT:  if:
; CHECK-NEXT:    [[T:%.*]] = load i8, ptr [[P:%.*]], align 1, !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    ret void
;
if:
  br i1 %c, label %then, label %else
then:
  %t = load i8, ptr %p, !range !0
  br label %out
else:
  %e = load i8, ptr %p, !range !1
  br label %out
out:
  ret void
}

define void @hoist_both_noundef(i1 %c, ptr %p) {
; CHECK-LABEL: @hoist_both_noundef(
; CHECK-NEXT:  if:
; CHECK-NEXT:    [[T:%.*]] = load i8, ptr [[P:%.*]], align 1, !noundef !1
; CHECK-NEXT:    ret void
;
if:
  br i1 %c, label %then, label %else

then:
  %t = load i8, ptr %p, !noundef !2
  br label %out

else:
  %e = load i8, ptr %p, !noundef !2
  br label %out

out:
  ret void
}

define void @hoist_one_noundef(i1 %c, ptr %p) {
; CHECK-LABEL: @hoist_one_noundef(
; CHECK-NEXT:  if:
; CHECK-NEXT:    [[T:%.*]] = load i8, ptr [[P:%.*]], align 1
; CHECK-NEXT:    ret void
;
if:
  br i1 %c, label %then, label %else

then:
  %t = load i8, ptr %p, !noundef !2
  br label %out

else:
  %e = load i8, ptr %p
  br label %out

out:
  ret void
}

define void @hoist_dereferenceable(i1 %c, ptr %p) {
; CHECK-LABEL: @hoist_dereferenceable(
; CHECK-NEXT:  if:
; CHECK-NEXT:    [[T:%.*]] = load ptr, ptr [[P:%.*]], align 8, !dereferenceable !2
; CHECK-NEXT:    ret void
;
if:
  br i1 %c, label %then, label %else
then:
  %t = load ptr, ptr %p, !dereferenceable !{i64 10}
  br label %out
else:
  %e = load ptr, ptr %p, !dereferenceable !{i64 20}
  br label %out
out:
  ret void
}

define void @hoist_dereferenceable_or_null(i1 %c, ptr %p) {
; CHECK-LABEL: @hoist_dereferenceable_or_null(
; CHECK-NEXT:  if:
; CHECK-NEXT:    [[T:%.*]] = load ptr, ptr [[P:%.*]], align 8, !dereferenceable_or_null !2
; CHECK-NEXT:    ret void
;
if:
  br i1 %c, label %then, label %else
then:
  %t = load ptr, ptr %p, !dereferenceable_or_null !{i64 20}
  br label %out
else:
  %e = load ptr, ptr %p, !dereferenceable_or_null !{i64 10}
  br label %out
out:
  ret void
}

; !range violation only returns poison, and is thus safe to speculate.
define i32 @speculate_range(i1 %c, ptr dereferenceable(8) align 8 %p) {
; CHECK-LABEL: @speculate_range(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[V:%.*]] = load i32, ptr [[P:%.*]], align 4, !range [[RNG3:![0-9]+]]
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[C:%.*]], i32 [[V]], i32 0
; CHECK-NEXT:    ret i32 [[SPEC_SELECT]]
;
entry:
  br i1 %c, label %if, label %join

if:
  %v = load i32, ptr %p, !range !{i32 0, i32 10}
  br label %join

join:
  %phi = phi i32 [ %v, %if ], [ 0, %entry ]
  ret i32 %phi
}

; !nonnull is safe to speculate, but !noundef is not, as the latter causes
; immediate undefined behavior.
define ptr @speculate_nonnull(i1 %c, ptr dereferenceable(8) align 8 %p) {
; CHECK-LABEL: @speculate_nonnull(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[V:%.*]] = load ptr, ptr [[P:%.*]], align 8, !nonnull !1
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[C:%.*]], ptr [[V]], ptr null
; CHECK-NEXT:    ret ptr [[SPEC_SELECT]]
;
entry:
  br i1 %c, label %if, label %join

if:
  %v = load ptr, ptr %p, !nonnull !{}, !noundef !{}
  br label %join

join:
  %phi = phi ptr [ %v, %if ], [ null, %entry ]
  ret ptr %phi
}

; !align is safe to speculate, but !dereferenceable is not, as the latter causes
; immediate undefined behavior.
define ptr @speculate_align(i1 %c, ptr dereferenceable(8) align 8 %p) {
; CHECK-LABEL: @speculate_align(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[V:%.*]] = load ptr, ptr [[P:%.*]], align 8, !align !4
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[C:%.*]], ptr [[V]], ptr null
; CHECK-NEXT:    ret ptr [[SPEC_SELECT]]
;
entry:
  br i1 %c, label %if, label %join

if:
  %v = load ptr, ptr %p, !align !{i64 4}, !dereferenceable !{i64 4}
  br label %join

join:
  %phi = phi ptr [ %v, %if ], [ null, %entry ]
  ret ptr %phi
}

define void @hoist_fpmath(i1 %c, double %x) {
; CHECK-LABEL: @hoist_fpmath(
; CHECK-NEXT:  if:
; CHECK-NEXT:    [[T:%.*]] = fadd double [[X:%.*]], 1.000000e+00, !fpmath !5
; CHECK-NEXT:    ret void
;
if:
  br i1 %c, label %then, label %else
then:
  %t = fadd double %x, 1.0, !fpmath !{ float 2.5 }
  br label %out
else:
  %e = fadd double %x, 1.0, !fpmath !{ float 5.0 }
  br label %out
out:
  ret void
}

!0 = !{ i8 0, i8 1 }
!1 = !{ i8 3, i8 5 }
!2 = !{}
;.
; CHECK: [[RNG0]] = !{i8 0, i8 1, i8 3, i8 5}
; CHECK: [[META1:![0-9]+]] = !{}
; CHECK: [[META2:![0-9]+]] = !{i64 10}
; CHECK: [[RNG3]] = !{i32 0, i32 10}
; CHECK: [[META4:![0-9]+]] = !{i64 4}
; CHECK: [[META5:![0-9]+]] = !{float 2.500000e+00}
;.
