; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=x86_64-unknown-unknown < %s | FileCheck -check-prefixes=X64 %s
; RUN: llc -mtriple=i386-pc-win32 < %s | FileCheck -check-prefix=WIN32 %s

; FIXME
; define { half, i32 } @test_frexp_f16_i32(half %a) {
;   %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
;   ret { half, i32 } %result
; }

; define half @test_frexp_f16_i32_only_use_fract(half %a) {
;   %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
;   %result.0 = extractvalue { half, i32 } %result, 0
;   ret half %result.0
; }

; define i32 @test_frexp_f16_i32_only_use_exp(half %a) {
;   %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
;   %result.0 = extractvalue { half, i32 } %result, 1
;   ret i32 %result.0
; }

; define { <2 x half>, <2 x i32> } @test_frexp_v2f16_v2i32(<2 x half> %a) {
;   %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
;   ret { <2 x half>, <2 x i32> } %result
; }

; define <2 x half> @test_frexp_v2f16_v2i32_only_use_fract(<2 x half> %a) {
;   %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
;   %result.0 = extractvalue { <2 x half>, <2 x i32> } %result, 0
;   ret <2 x half> %result.0
; }

; define <2 x i32> @test_frexp_v2f16_v2i32_only_use_exp(<2 x half> %a) {
;   %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
;   %result.1 = extractvalue { <2 x half>, <2 x i32> } %result, 1
;   ret <2 x i32> %result.1
; }

define { float, i32 } @test_frexp_f32_i32(float %a) {
; X64-LABEL: test_frexp_f32_i32:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    .cfi_def_cfa_offset 16
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movl {{[0-9]+}}(%rsp), %eax
; X64-NEXT:    popq %rcx
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
;
; WIN32-LABEL: test_frexp_f32_i32:
; WIN32:       # %bb.0:
; WIN32-NEXT:    subl $12, %esp
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fld %st(0)
; WIN32-NEXT:    fmuls __real@4c000000
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fsts (%esp)
; WIN32-NEXT:    movl (%esp), %eax
; WIN32-NEXT:    movl %eax, %ecx
; WIN32-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %ecx # imm = 0x800000
; WIN32-NEXT:    jb LBB0_1
; WIN32-NEXT:  # %bb.2:
; WIN32-NEXT:    movl %ecx, %edx
; WIN32-NEXT:    jmp LBB0_3
; WIN32-NEXT:  LBB0_1:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    movl %eax, %edx
; WIN32-NEXT:    andl $2139095040, %edx # imm = 0x7F800000
; WIN32-NEXT:  LBB0_3:
; WIN32-NEXT:    shrl $23, %edx
; WIN32-NEXT:    cmpl $8388608, %ecx # imm = 0x800000
; WIN32-NEXT:    jae LBB0_5
; WIN32-NEXT:  # %bb.4:
; WIN32-NEXT:    addl $-25, %edx
; WIN32-NEXT:  LBB0_5:
; WIN32-NEXT:    andl $-2139095041, %eax # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %eax # imm = 0x3F000000
; WIN32-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN32-NEXT:    addl $-126, %edx
; WIN32-NEXT:    addl $-2139095040, %ecx # imm = 0x80800000
; WIN32-NEXT:    xorl %eax, %eax
; WIN32-NEXT:    cmpl $-2139095040, %ecx # imm = 0x80800000
; WIN32-NEXT:    jbe LBB0_7
; WIN32-NEXT:  # %bb.6:
; WIN32-NEXT:    movl %edx, %eax
; WIN32-NEXT:  LBB0_7:
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    jbe LBB0_9
; WIN32-NEXT:  # %bb.8:
; WIN32-NEXT:    fstp %st(1)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB0_9:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    addl $12, %esp
; WIN32-NEXT:    retl
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define float @test_frexp_f32_i32_only_use_fract(float %a) {
; X64-LABEL: test_frexp_f32_i32_only_use_fract:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    .cfi_def_cfa_offset 16
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    popq %rax
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
;
; WIN32-LABEL: test_frexp_f32_i32_only_use_fract:
; WIN32:       # %bb.0:
; WIN32-NEXT:    subl $12, %esp
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fsts (%esp)
; WIN32-NEXT:    fld %st(0)
; WIN32-NEXT:    fmuls __real@4c000000
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    movl (%esp), %ecx
; WIN32-NEXT:    movl %ecx, %eax
; WIN32-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %eax # imm = 0x800000
; WIN32-NEXT:    jae LBB1_2
; WIN32-NEXT:  # %bb.1:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN32-NEXT:  LBB1_2:
; WIN32-NEXT:    andl $-2139095041, %ecx # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %ecx # imm = 0x3F000000
; WIN32-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN32-NEXT:    addl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    cmpl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    jbe LBB1_4
; WIN32-NEXT:  # %bb.3:
; WIN32-NEXT:    fstp %st(1)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB1_4:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    addl $12, %esp
; WIN32-NEXT:    retl
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 0
  ret float %result.0
}

define i32 @test_frexp_f32_i32_only_use_exp(float %a) {
; X64-LABEL: test_frexp_f32_i32_only_use_exp:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    .cfi_def_cfa_offset 16
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movl {{[0-9]+}}(%rsp), %eax
; X64-NEXT:    popq %rcx
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
;
; WIN32-LABEL: test_frexp_f32_i32_only_use_exp:
; WIN32:       # %bb.0:
; WIN32-NEXT:    subl $8, %esp
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fld %st(0)
; WIN32-NEXT:    fmuls __real@4c000000
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fstps (%esp)
; WIN32-NEXT:    movl $2147483647, %ecx # imm = 0x7FFFFFFF
; WIN32-NEXT:    andl (%esp), %ecx
; WIN32-NEXT:    cmpl $8388608, %ecx # imm = 0x800000
; WIN32-NEXT:    jb LBB2_1
; WIN32-NEXT:  # %bb.2:
; WIN32-NEXT:    movl %ecx, %edx
; WIN32-NEXT:    jmp LBB2_3
; WIN32-NEXT:  LBB2_1:
; WIN32-NEXT:    movl $2139095040, %edx # imm = 0x7F800000
; WIN32-NEXT:    andl {{[0-9]+}}(%esp), %edx
; WIN32-NEXT:  LBB2_3:
; WIN32-NEXT:    shrl $23, %edx
; WIN32-NEXT:    cmpl $8388608, %ecx # imm = 0x800000
; WIN32-NEXT:    jae LBB2_5
; WIN32-NEXT:  # %bb.4:
; WIN32-NEXT:    addl $-25, %edx
; WIN32-NEXT:  LBB2_5:
; WIN32-NEXT:    addl $-2139095040, %ecx # imm = 0x80800000
; WIN32-NEXT:    xorl %eax, %eax
; WIN32-NEXT:    cmpl $-2139095040, %ecx # imm = 0x80800000
; WIN32-NEXT:    jbe LBB2_7
; WIN32-NEXT:  # %bb.6:
; WIN32-NEXT:    addl $-126, %edx
; WIN32-NEXT:    movl %edx, %eax
; WIN32-NEXT:  LBB2_7:
; WIN32-NEXT:    addl $8, %esp
; WIN32-NEXT:    retl
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 1
  ret i32 %result.0
}

; FIXME: Widen vector result
; define { <2 x float>, <2 x i32> } @test_frexp_v2f32_v2i32(<2 x float> %a) {
;   %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
;   ret { <2 x float>, <2 x i32> } %result
; }

; define <2 x float> @test_frexp_v2f32_v2i32_only_use_fract(<2 x float> %a) {
;   %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
;   %result.0 = extractvalue { <2 x float>, <2 x i32> } %result, 0
;   ret <2 x float> %result.0
; }

; define <2 x i32> @test_frexp_v2f32_v2i32_only_use_exp(<2 x float> %a) {
;   %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
;   %result.1 = extractvalue { <2 x float>, <2 x i32> } %result, 1
;   ret <2 x i32> %result.1
; }

define { <4 x float>, <4 x i32> } @test_frexp_v4f32_v4i32(<4 x float> %a) {
; X64-LABEL: test_frexp_v4f32_v4i32:
; X64:       # %bb.0:
; X64-NEXT:    subq $72, %rsp
; X64-NEXT:    .cfi_def_cfa_offset 80
; X64-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; X64-NEXT:    movq %rsp, %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; X64-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    unpcklps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; X64-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; X64-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; X64-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64-NEXT:    unpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; X64-NEXT:    # xmm1 = xmm1[0],mem[0]
; X64-NEXT:    movaps %xmm1, %xmm0
; X64-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X64-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X64-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; X64-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X64-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; X64-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; X64-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; X64-NEXT:    addq $72, %rsp
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
;
; WIN32-LABEL: test_frexp_v4f32_v4i32:
; WIN32:       # %bb.0:
; WIN32-NEXT:    pushl %ebp
; WIN32-NEXT:    pushl %ebx
; WIN32-NEXT:    pushl %edi
; WIN32-NEXT:    pushl %esi
; WIN32-NEXT:    subl $68, %esp
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    flds __real@4c000000
; WIN32-NEXT:    fld %st(1)
; WIN32-NEXT:    fmul %st(1), %st
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fxch %st(1)
; WIN32-NEXT:    fsts {{[0-9]+}}(%esp)
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; WIN32-NEXT:    movl %ebx, %eax
; WIN32-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %eax # imm = 0x800000
; WIN32-NEXT:    jb LBB3_1
; WIN32-NEXT:  # %bb.2:
; WIN32-NEXT:    movl %eax, %ecx
; WIN32-NEXT:    jmp LBB3_3
; WIN32-NEXT:  LBB3_1:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; WIN32-NEXT:    movl %ebx, %ecx
; WIN32-NEXT:    andl $2139095040, %ecx # imm = 0x7F800000
; WIN32-NEXT:  LBB3_3:
; WIN32-NEXT:    shrl $23, %ecx
; WIN32-NEXT:    cmpl $8388608, %eax # imm = 0x800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fld %st(0)
; WIN32-NEXT:    fmul %st(3), %st
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fsts {{[0-9]+}}(%esp)
; WIN32-NEXT:    jae LBB3_5
; WIN32-NEXT:  # %bb.4:
; WIN32-NEXT:    addl $-25, %ecx
; WIN32-NEXT:  LBB3_5:
; WIN32-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN32-NEXT:    movl %ecx, %edx
; WIN32-NEXT:    andl $2147483647, %edx # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %edx # imm = 0x800000
; WIN32-NEXT:    jb LBB3_6
; WIN32-NEXT:  # %bb.7:
; WIN32-NEXT:    movl %edx, %esi
; WIN32-NEXT:    jmp LBB3_8
; WIN32-NEXT:  LBB3_6:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN32-NEXT:    movl %ecx, %esi
; WIN32-NEXT:    andl $2139095040, %esi # imm = 0x7F800000
; WIN32-NEXT:  LBB3_8:
; WIN32-NEXT:    shrl $23, %esi
; WIN32-NEXT:    cmpl $8388608, %edx # imm = 0x800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fld %st(0)
; WIN32-NEXT:    fmul %st(4), %st
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fsts {{[0-9]+}}(%esp)
; WIN32-NEXT:    jae LBB3_10
; WIN32-NEXT:  # %bb.9:
; WIN32-NEXT:    addl $-25, %esi
; WIN32-NEXT:  LBB3_10:
; WIN32-NEXT:    movl %esi, (%esp) # 4-byte Spill
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN32-NEXT:    movl %edi, %ebp
; WIN32-NEXT:    andl $2147483647, %ebp # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %ebp # imm = 0x800000
; WIN32-NEXT:    jb LBB3_11
; WIN32-NEXT:  # %bb.12:
; WIN32-NEXT:    movl %ebp, %esi
; WIN32-NEXT:    jmp LBB3_13
; WIN32-NEXT:  LBB3_11:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN32-NEXT:    movl %edi, %esi
; WIN32-NEXT:    andl $2139095040, %esi # imm = 0x7F800000
; WIN32-NEXT:  LBB3_13:
; WIN32-NEXT:    shrl $23, %esi
; WIN32-NEXT:    cmpl $8388608, %ebp # imm = 0x800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fmul %st, %st(4)
; WIN32-NEXT:    fxch %st(4)
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fxch %st(3)
; WIN32-NEXT:    fsts {{[0-9]+}}(%esp)
; WIN32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; WIN32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; WIN32-NEXT:    jae LBB3_15
; WIN32-NEXT:  # %bb.14:
; WIN32-NEXT:    addl $-25, %esi
; WIN32-NEXT:  LBB3_15:
; WIN32-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    movl %eax, %edx
; WIN32-NEXT:    andl $2147483647, %edx # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %edx # imm = 0x800000
; WIN32-NEXT:    jb LBB3_16
; WIN32-NEXT:  # %bb.17:
; WIN32-NEXT:    movl %edx, %esi
; WIN32-NEXT:    jmp LBB3_18
; WIN32-NEXT:  LBB3_16:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    movl %eax, %esi
; WIN32-NEXT:    andl $2139095040, %esi # imm = 0x7F800000
; WIN32-NEXT:  LBB3_18:
; WIN32-NEXT:    shrl $23, %esi
; WIN32-NEXT:    cmpl $8388608, %edx # imm = 0x800000
; WIN32-NEXT:    jae LBB3_20
; WIN32-NEXT:  # %bb.19:
; WIN32-NEXT:    addl $-25, %esi
; WIN32-NEXT:  LBB3_20:
; WIN32-NEXT:    andl $-2139095041, %eax # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %eax # imm = 0x3F000000
; WIN32-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN32-NEXT:    andl $-2139095041, %ebx # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %ebx # imm = 0x3F000000
; WIN32-NEXT:    movl %ebx, {{[0-9]+}}(%esp)
; WIN32-NEXT:    andl $-2139095041, %ecx # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %ecx # imm = 0x3F000000
; WIN32-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN32-NEXT:    andl $-2139095041, %edi # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %edi # imm = 0x3F000000
; WIN32-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN32-NEXT:    addl $-126, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Spill
; WIN32-NEXT:    addl $-126, (%esp) # 4-byte Folded Spill
; WIN32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; WIN32-NEXT:    addl $-126, %ecx
; WIN32-NEXT:    addl $-126, %esi
; WIN32-NEXT:    addl $-2139095040, %edx # imm = 0x80800000
; WIN32-NEXT:    xorl %edi, %edi
; WIN32-NEXT:    cmpl $-2139095040, %edx # imm = 0x80800000
; WIN32-NEXT:    movl $0, %ebx
; WIN32-NEXT:    jbe LBB3_22
; WIN32-NEXT:  # %bb.21:
; WIN32-NEXT:    movl %esi, %ebx
; WIN32-NEXT:  LBB3_22:
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; WIN32-NEXT:    jbe LBB3_24
; WIN32-NEXT:  # %bb.23:
; WIN32-NEXT:    fstp %st(1)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB3_24:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    addl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    cmpl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    movl $0, %edx
; WIN32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %esi # 4-byte Reload
; WIN32-NEXT:    jbe LBB3_26
; WIN32-NEXT:  # %bb.25:
; WIN32-NEXT:    movl %ecx, %edx
; WIN32-NEXT:  LBB3_26:
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    jbe LBB3_28
; WIN32-NEXT:  # %bb.27:
; WIN32-NEXT:    fstp %st(3)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB3_28:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; WIN32-NEXT:    addl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    cmpl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    movl $0, %ecx
; WIN32-NEXT:    jbe LBB3_30
; WIN32-NEXT:  # %bb.29:
; WIN32-NEXT:    movl (%esp), %ecx # 4-byte Reload
; WIN32-NEXT:  LBB3_30:
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    jbe LBB3_32
; WIN32-NEXT:  # %bb.31:
; WIN32-NEXT:    fstp %st(2)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB3_32:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    addl $-2139095040, %ebp # imm = 0x80800000
; WIN32-NEXT:    cmpl $-2139095040, %ebp # imm = 0x80800000
; WIN32-NEXT:    jbe LBB3_34
; WIN32-NEXT:  # %bb.33:
; WIN32-NEXT:    movl %esi, %edi
; WIN32-NEXT:  LBB3_34:
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    jbe LBB3_36
; WIN32-NEXT:  # %bb.35:
; WIN32-NEXT:    fstp %st(4)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB3_36:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    movl %edi, 28(%eax)
; WIN32-NEXT:    movl %ecx, 24(%eax)
; WIN32-NEXT:    movl %edx, 20(%eax)
; WIN32-NEXT:    movl %ebx, 16(%eax)
; WIN32-NEXT:    fxch %st(3)
; WIN32-NEXT:    fstps 12(%eax)
; WIN32-NEXT:    fstps 8(%eax)
; WIN32-NEXT:    fstps 4(%eax)
; WIN32-NEXT:    fstps (%eax)
; WIN32-NEXT:    addl $68, %esp
; WIN32-NEXT:    popl %esi
; WIN32-NEXT:    popl %edi
; WIN32-NEXT:    popl %ebx
; WIN32-NEXT:    popl %ebp
; WIN32-NEXT:    retl
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  ret { <4 x float>, <4 x i32> } %result
}

define <4 x float> @test_frexp_v4f32_v4i32_only_use_fract(<4 x float> %a) {
; X64-LABEL: test_frexp_v4f32_v4i32_only_use_fract:
; X64:       # %bb.0:
; X64-NEXT:    subq $72, %rsp
; X64-NEXT:    .cfi_def_cfa_offset 80
; X64-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; X64-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    unpcklps (%rsp), %xmm0 # 16-byte Folded Reload
; X64-NEXT:    # xmm0 = xmm0[0],mem[0],xmm0[1],mem[1]
; X64-NEXT:    movaps %xmm0, (%rsp) # 16-byte Spill
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; X64-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64-NEXT:    unpcklpd (%rsp), %xmm1 # 16-byte Folded Reload
; X64-NEXT:    # xmm1 = xmm1[0],mem[0]
; X64-NEXT:    movaps %xmm1, %xmm0
; X64-NEXT:    addq $72, %rsp
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
;
; WIN32-LABEL: test_frexp_v4f32_v4i32_only_use_fract:
; WIN32:       # %bb.0:
; WIN32-NEXT:    pushl %edi
; WIN32-NEXT:    pushl %esi
; WIN32-NEXT:    subl $48, %esp
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fsts {{[0-9]+}}(%esp)
; WIN32-NEXT:    flds __real@4c000000
; WIN32-NEXT:    fld %st(1)
; WIN32-NEXT:    fmul %st(1), %st
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fxch %st(2)
; WIN32-NEXT:    fsts {{[0-9]+}}(%esp)
; WIN32-NEXT:    fld %st(0)
; WIN32-NEXT:    fmul %st(3), %st
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fxch %st(3)
; WIN32-NEXT:    fsts {{[0-9]+}}(%esp)
; WIN32-NEXT:    fld %st(0)
; WIN32-NEXT:    fmul %st(3), %st
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fxch %st(4)
; WIN32-NEXT:    fsts (%esp)
; WIN32-NEXT:    fmul %st, %st(2)
; WIN32-NEXT:    fxch %st(2)
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN32-NEXT:    movl %ecx, %eax
; WIN32-NEXT:    andl $2147483647, %eax # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %eax # imm = 0x800000
; WIN32-NEXT:    jae LBB4_2
; WIN32-NEXT:  # %bb.1:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; WIN32-NEXT:  LBB4_2:
; WIN32-NEXT:    andl $-2139095041, %ecx # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %ecx # imm = 0x3F000000
; WIN32-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN32-NEXT:    movl %edx, %ecx
; WIN32-NEXT:    andl $2147483647, %ecx # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %ecx # imm = 0x800000
; WIN32-NEXT:    jae LBB4_4
; WIN32-NEXT:  # %bb.3:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; WIN32-NEXT:  LBB4_4:
; WIN32-NEXT:    andl $-2139095041, %edx # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %edx # imm = 0x3F000000
; WIN32-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN32-NEXT:    movl %esi, %edx
; WIN32-NEXT:    andl $2147483647, %edx # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %edx # imm = 0x800000
; WIN32-NEXT:    jae LBB4_6
; WIN32-NEXT:  # %bb.5:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN32-NEXT:  LBB4_6:
; WIN32-NEXT:    andl $-2139095041, %esi # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %esi # imm = 0x3F000000
; WIN32-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; WIN32-NEXT:    movl (%esp), %edi
; WIN32-NEXT:    movl %edi, %esi
; WIN32-NEXT:    andl $2147483647, %esi # imm = 0x7FFFFFFF
; WIN32-NEXT:    cmpl $8388608, %esi # imm = 0x800000
; WIN32-NEXT:    jae LBB4_8
; WIN32-NEXT:  # %bb.7:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN32-NEXT:  LBB4_8:
; WIN32-NEXT:    andl $-2139095041, %edi # imm = 0x807FFFFF
; WIN32-NEXT:    orl $1056964608, %edi # imm = 0x3F000000
; WIN32-NEXT:    movl %edi, {{[0-9]+}}(%esp)
; WIN32-NEXT:    addl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    cmpl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    jbe LBB4_10
; WIN32-NEXT:  # %bb.9:
; WIN32-NEXT:    fstp %st(1)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB4_10:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    addl $-2139095040, %ecx # imm = 0x80800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    cmpl $-2139095040, %ecx # imm = 0x80800000
; WIN32-NEXT:    jbe LBB4_12
; WIN32-NEXT:  # %bb.11:
; WIN32-NEXT:    fstp %st(3)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB4_12:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    addl $-2139095040, %edx # imm = 0x80800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    cmpl $-2139095040, %edx # imm = 0x80800000
; WIN32-NEXT:    jbe LBB4_14
; WIN32-NEXT:  # %bb.13:
; WIN32-NEXT:    fstp %st(4)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB4_14:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    addl $-2139095040, %esi # imm = 0x80800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    cmpl $-2139095040, %esi # imm = 0x80800000
; WIN32-NEXT:    jbe LBB4_16
; WIN32-NEXT:  # %bb.15:
; WIN32-NEXT:    fstp %st(2)
; WIN32-NEXT:    fldz
; WIN32-NEXT:  LBB4_16:
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    fxch %st(1)
; WIN32-NEXT:    fstps 12(%eax)
; WIN32-NEXT:    fxch %st(2)
; WIN32-NEXT:    fstps 8(%eax)
; WIN32-NEXT:    fstps 4(%eax)
; WIN32-NEXT:    fstps (%eax)
; WIN32-NEXT:    addl $48, %esp
; WIN32-NEXT:    popl %esi
; WIN32-NEXT:    popl %edi
; WIN32-NEXT:    retl
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  %result.0 = extractvalue { <4 x float>, <4 x i32> } %result, 0
  ret <4 x float> %result.0
}

define <4 x i32> @test_frexp_v4f32_v4i32_only_use_exp(<4 x float> %a) {
; X64-LABEL: test_frexp_v4f32_v4i32_only_use_exp:
; X64:       # %bb.0:
; X64-NEXT:    subq $40, %rsp
; X64-NEXT:    .cfi_def_cfa_offset 48
; X64-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3,3,3]
; X64-NEXT:    movq %rsp, %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; X64-NEXT:    movhlps {{.*#+}} xmm0 = xmm0[1,1]
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; X64-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,1,1]
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexpf@PLT
; X64-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X64-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; X64-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; X64-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X64-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; X64-NEXT:    addq $40, %rsp
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
;
; WIN32-LABEL: test_frexp_v4f32_v4i32_only_use_exp:
; WIN32:       # %bb.0:
; WIN32-NEXT:    pushl %ebp
; WIN32-NEXT:    pushl %ebx
; WIN32-NEXT:    pushl %edi
; WIN32-NEXT:    pushl %esi
; WIN32-NEXT:    subl $36, %esp
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    flds __real@4c000000
; WIN32-NEXT:    fld %st(1)
; WIN32-NEXT:    fmul %st(1), %st
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fxch %st(1)
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    movl $2139095040, %ecx # imm = 0x7F800000
; WIN32-NEXT:    movl $2147483647, %edx # imm = 0x7FFFFFFF
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    andl %edx, %eax
; WIN32-NEXT:    cmpl $8388608, %eax # imm = 0x800000
; WIN32-NEXT:    jb LBB5_1
; WIN32-NEXT:  # %bb.2:
; WIN32-NEXT:    movl %eax, %esi
; WIN32-NEXT:    jmp LBB5_3
; WIN32-NEXT:  LBB5_1:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN32-NEXT:    andl %ecx, %esi
; WIN32-NEXT:  LBB5_3:
; WIN32-NEXT:    shrl $23, %esi
; WIN32-NEXT:    cmpl $8388608, %eax # imm = 0x800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fld %st(0)
; WIN32-NEXT:    fmul %st(2), %st
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    jae LBB5_5
; WIN32-NEXT:  # %bb.4:
; WIN32-NEXT:    addl $-25, %esi
; WIN32-NEXT:  LBB5_5:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; WIN32-NEXT:    andl %edx, %edi
; WIN32-NEXT:    cmpl $8388608, %edi # imm = 0x800000
; WIN32-NEXT:    jb LBB5_6
; WIN32-NEXT:  # %bb.7:
; WIN32-NEXT:    movl %edi, %ebx
; WIN32-NEXT:    jmp LBB5_8
; WIN32-NEXT:  LBB5_6:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; WIN32-NEXT:    andl %ecx, %ebx
; WIN32-NEXT:  LBB5_8:
; WIN32-NEXT:    shrl $23, %ebx
; WIN32-NEXT:    cmpl $8388608, %edi # imm = 0x800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fld %st(0)
; WIN32-NEXT:    fmul %st(2), %st
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    jae LBB5_10
; WIN32-NEXT:  # %bb.9:
; WIN32-NEXT:    addl $-25, %ebx
; WIN32-NEXT:  LBB5_10:
; WIN32-NEXT:    movl %esi, (%esp) # 4-byte Spill
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; WIN32-NEXT:    andl %edx, %ebp
; WIN32-NEXT:    cmpl $8388608, %ebp # imm = 0x800000
; WIN32-NEXT:    jb LBB5_11
; WIN32-NEXT:  # %bb.12:
; WIN32-NEXT:    movl %ebp, %esi
; WIN32-NEXT:    jmp LBB5_13
; WIN32-NEXT:  LBB5_11:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; WIN32-NEXT:    andl %ecx, %esi
; WIN32-NEXT:  LBB5_13:
; WIN32-NEXT:    shrl $23, %esi
; WIN32-NEXT:    cmpl $8388608, %ebp # imm = 0x800000
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fmul %st, %st(1)
; WIN32-NEXT:    fxch %st(1)
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    jae LBB5_15
; WIN32-NEXT:  # %bb.14:
; WIN32-NEXT:    addl $-25, %esi
; WIN32-NEXT:  LBB5_15:
; WIN32-NEXT:    andl {{[0-9]+}}(%esp), %edx
; WIN32-NEXT:    cmpl $8388608, %edx # imm = 0x800000
; WIN32-NEXT:    jb LBB5_16
; WIN32-NEXT:  # %bb.17:
; WIN32-NEXT:    movl %edx, %ecx
; WIN32-NEXT:    jmp LBB5_18
; WIN32-NEXT:  LBB5_16:
; WIN32-NEXT:    andl {{[0-9]+}}(%esp), %ecx
; WIN32-NEXT:  LBB5_18:
; WIN32-NEXT:    shrl $23, %ecx
; WIN32-NEXT:    cmpl $8388608, %edx # imm = 0x800000
; WIN32-NEXT:    jae LBB5_20
; WIN32-NEXT:  # %bb.19:
; WIN32-NEXT:    addl $-25, %ecx
; WIN32-NEXT:  LBB5_20:
; WIN32-NEXT:    addl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    cmpl $-2139095040, %eax # imm = 0x80800000
; WIN32-NEXT:    movl $0, %eax
; WIN32-NEXT:    jbe LBB5_22
; WIN32-NEXT:  # %bb.21:
; WIN32-NEXT:    movl (%esp), %eax # 4-byte Reload
; WIN32-NEXT:    addl $-126, %eax
; WIN32-NEXT:  LBB5_22:
; WIN32-NEXT:    movl %eax, (%esp) # 4-byte Spill
; WIN32-NEXT:    addl $-2139095040, %edi # imm = 0x80800000
; WIN32-NEXT:    cmpl $-2139095040, %edi # imm = 0x80800000
; WIN32-NEXT:    movl $0, %edi
; WIN32-NEXT:    jbe LBB5_24
; WIN32-NEXT:  # %bb.23:
; WIN32-NEXT:    addl $-126, %ebx
; WIN32-NEXT:    movl %ebx, %edi
; WIN32-NEXT:  LBB5_24:
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    addl $-2139095040, %ebp # imm = 0x80800000
; WIN32-NEXT:    cmpl $-2139095040, %ebp # imm = 0x80800000
; WIN32-NEXT:    movl $0, %ebx
; WIN32-NEXT:    jbe LBB5_26
; WIN32-NEXT:  # %bb.25:
; WIN32-NEXT:    addl $-126, %esi
; WIN32-NEXT:    movl %esi, %ebx
; WIN32-NEXT:  LBB5_26:
; WIN32-NEXT:    addl $-2139095040, %edx # imm = 0x80800000
; WIN32-NEXT:    cmpl $-2139095040, %edx # imm = 0x80800000
; WIN32-NEXT:    movl $0, %edx
; WIN32-NEXT:    jbe LBB5_28
; WIN32-NEXT:  # %bb.27:
; WIN32-NEXT:    addl $-126, %ecx
; WIN32-NEXT:    movl %ecx, %edx
; WIN32-NEXT:  LBB5_28:
; WIN32-NEXT:    movl %edx, 12(%eax)
; WIN32-NEXT:    movl %ebx, 8(%eax)
; WIN32-NEXT:    movl %edi, 4(%eax)
; WIN32-NEXT:    movl (%esp), %ecx # 4-byte Reload
; WIN32-NEXT:    movl %ecx, (%eax)
; WIN32-NEXT:    addl $36, %esp
; WIN32-NEXT:    popl %esi
; WIN32-NEXT:    popl %edi
; WIN32-NEXT:    popl %ebx
; WIN32-NEXT:    popl %ebp
; WIN32-NEXT:    retl
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  %result.1 = extractvalue { <4 x float>, <4 x i32> } %result, 1
  ret <4 x i32> %result.1
}

define { double, i32 } @test_frexp_f64_i32(double %a) {
; X64-LABEL: test_frexp_f64_i32:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    .cfi_def_cfa_offset 16
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexp@PLT
; X64-NEXT:    movl {{[0-9]+}}(%rsp), %eax
; X64-NEXT:    popq %rcx
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
;
; WIN32-LABEL: test_frexp_f64_i32:
; WIN32:       # %bb.0:
; WIN32-NEXT:    subl $16, %esp
; WIN32-NEXT:    fldl {{[0-9]+}}(%esp)
; WIN32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN32-NEXT:    fstpl (%esp)
; WIN32-NEXT:    calll _frexp
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    addl $16, %esp
; WIN32-NEXT:    retl
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  ret { double, i32 } %result
}

define double @test_frexp_f64_i32_only_use_fract(double %a) {
; X64-LABEL: test_frexp_f64_i32_only_use_fract:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    .cfi_def_cfa_offset 16
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexp@PLT
; X64-NEXT:    popq %rax
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
;
; WIN32-LABEL: test_frexp_f64_i32_only_use_fract:
; WIN32:       # %bb.0:
; WIN32-NEXT:    subl $16, %esp
; WIN32-NEXT:    fldl {{[0-9]+}}(%esp)
; WIN32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN32-NEXT:    fstpl (%esp)
; WIN32-NEXT:    calll _frexp
; WIN32-NEXT:    addl $16, %esp
; WIN32-NEXT:    retl
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 0
  ret double %result.0
}

define i32 @test_frexp_f64_i32_only_use_exp(double %a) {
; X64-LABEL: test_frexp_f64_i32_only_use_exp:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    .cfi_def_cfa_offset 16
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq frexp@PLT
; X64-NEXT:    movl {{[0-9]+}}(%rsp), %eax
; X64-NEXT:    popq %rcx
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
;
; WIN32-LABEL: test_frexp_f64_i32_only_use_exp:
; WIN32:       # %bb.0:
; WIN32-NEXT:    subl $16, %esp
; WIN32-NEXT:    fldl {{[0-9]+}}(%esp)
; WIN32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN32-NEXT:    fstpl (%esp)
; WIN32-NEXT:    calll _frexp
; WIN32-NEXT:    fstp %st(0)
; WIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    addl $16, %esp
; WIN32-NEXT:    retl
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 1
  ret i32 %result.0
}

; FIXME: Widen vector result
; define { <2 x double>, <2 x i32> } @test_frexp_v2f64_v2i32(<2 x double> %a) {
;   %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
;   ret { <2 x double>, <2 x i32> } %result
; }

; define <2 x double> @test_frexp_v2f64_v2i32_only_use_fract(<2 x double> %a) {
;   %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
;   %result.0 = extractvalue { <2 x double>, <2 x i32> } %result, 0
;   ret <2 x double> %result.0
; }

; define <2 x i32> @test_frexp_v2f64_v2i32_only_use_exp(<2 x double> %a) {
;   %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
;   %result.1 = extractvalue { <2 x double>, <2 x i32> } %result, 1
;   ret <2 x i32> %result.1
; }

declare { float, i32 } @llvm.frexp.f32.i32(float) #0
declare { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float>) #0
declare { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float>) #0

declare { half, i32 } @llvm.frexp.f16.i32(half) #0
declare { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half>) #0

declare { double, i32 } @llvm.frexp.f64.i32(double) #0
declare { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double>) #0

declare { half, i16 } @llvm.frexp.f16.i16(half) #0
declare { <2 x half>, <2 x i16> } @llvm.frexp.v2f16.v2i16(<2 x half>) #0

attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
