; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i1(<1 x i1>, metadata, metadata)
define <1 x half> @vsitofp_v1i1_v1f16(<1 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i1_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i1(<1 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i1(<1 x i1>, metadata, metadata)
define <1 x half> @vuitofp_v1i1_v1f16(<1 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i1_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i1(<1 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i1(<1 x i1>, metadata, metadata)
define <1 x float> @vsitofp_v1i1_v1f32(<1 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i1_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i1(<1 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i1(<1 x i1>, metadata, metadata)
define <1 x float> @vuitofp_v1i1_v1f32(<1 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i1_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i1(<1 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i1(<1 x i1>, metadata, metadata)
define <1 x double> @vsitofp_v1i1_v1f64(<1 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i1_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i1(<1 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}

declare <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i1(<1 x i1>, metadata, metadata)
define <1 x double> @vuitofp_v1i1_v1f64(<1 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i1_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i1(<1 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}

declare <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i1(<2 x i1>, metadata, metadata)
define <2 x half> @vsitofp_v2i1_v2f16(<2 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i1_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i1(<2 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i1(<2 x i1>, metadata, metadata)
define <2 x half> @vuitofp_v2i1_v2f16(<2 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i1_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i1(<2 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i1(<2 x i1>, metadata, metadata)
define <2 x float> @vsitofp_v2i1_v2f32(<2 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i1_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i1(<2 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i1(<2 x i1>, metadata, metadata)
define <2 x float> @vuitofp_v2i1_v2f32(<2 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i1_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i1(<2 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i1(<2 x i1>, metadata, metadata)
define <2 x double> @vsitofp_v2i1_v2f64(<2 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i1_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i1(<2 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i1(<2 x i1>, metadata, metadata)
define <2 x double> @vuitofp_v2i1_v2f64(<2 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i1_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i1(<2 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i1(<4 x i1>, metadata, metadata)
define <4 x half> @vsitofp_v4i1_v4f16(<4 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i1_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i1(<4 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i1(<4 x i1>, metadata, metadata)
define <4 x half> @vuitofp_v4i1_v4f16(<4 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i1_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i1(<4 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i1(<4 x i1>, metadata, metadata)
define <4 x float> @vsitofp_v4i1_v4f32(<4 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i1_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i1(<4 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i1(<4 x i1>, metadata, metadata)
define <4 x float> @vuitofp_v4i1_v4f32(<4 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i1_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i1(<4 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i1(<4 x i1>, metadata, metadata)
define <4 x double> @vsitofp_v4i1_v4f64(<4 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i1_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i1(<4 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i1(<4 x i1>, metadata, metadata)
define <4 x double> @vuitofp_v4i1_v4f64(<4 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i1_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i1(<4 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i1(<8 x i1>, metadata, metadata)
define <8 x half> @vsitofp_v8i1_v8f16(<8 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i1_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i1(<8 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i1(<8 x i1>, metadata, metadata)
define <8 x half> @vuitofp_v8i1_v8f16(<8 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i1_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v9, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i1(<8 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i1(<8 x i1>, metadata, metadata)
define <8 x float> @vsitofp_v8i1_v8f32(<8 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i1_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i1(<8 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i1(<8 x i1>, metadata, metadata)
define <8 x float> @vuitofp_v8i1_v8f32(<8 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i1_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i1(<8 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i1(<8 x i1>, metadata, metadata)
define <8 x double> @vsitofp_v8i1_v8f64(<8 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i1_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i1(<8 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i1(<8 x i1>, metadata, metadata)
define <8 x double> @vuitofp_v8i1_v8f64(<8 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i1_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i1(<8 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <16 x half> @llvm.experimental.constrained.sitofp.v16f16.v16i1(<16 x i1>, metadata, metadata)
define <16 x half> @vsitofp_v16i1_v16f16(<16 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v16i1_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <16 x half> @llvm.experimental.constrained.sitofp.v16f16.v16i1(<16 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x half> %evec
}

declare <16 x half> @llvm.experimental.constrained.uitofp.v16f16.v16i1(<16 x i1>, metadata, metadata)
define <16 x half> @vuitofp_v16i1_v16f16(<16 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v16i1_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v10, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <16 x half> @llvm.experimental.constrained.uitofp.v16f16.v16i1(<16 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x half> %evec
}

declare <16 x float> @llvm.experimental.constrained.sitofp.v16f32.v16i1(<16 x i1>, metadata, metadata)
define <16 x float> @vsitofp_v16i1_v16f32(<16 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v16i1_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x float> @llvm.experimental.constrained.sitofp.v16f32.v16i1(<16 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x float> %evec
}

declare <16 x float> @llvm.experimental.constrained.uitofp.v16f32.v16i1(<16 x i1>, metadata, metadata)
define <16 x float> @vuitofp_v16i1_v16f32(<16 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v16i1_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x float> @llvm.experimental.constrained.uitofp.v16f32.v16i1(<16 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x float> %evec
}

declare <32 x half> @llvm.experimental.constrained.sitofp.v32f16.v32i1(<32 x i1>, metadata, metadata)
define <32 x half> @vsitofp_v32i1_v32f16(<32 x i1> %va) strictfp {
; CHECK-LABEL: vsitofp_v32i1_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, -1, v0
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <32 x half> @llvm.experimental.constrained.sitofp.v32f16.v32i1(<32 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <32 x half> %evec
}

declare <32 x half> @llvm.experimental.constrained.uitofp.v32f16.v32i1(<32 x i1>, metadata, metadata)
define <32 x half> @vuitofp_v32i1_v32f16(<32 x i1> %va) strictfp {
; CHECK-LABEL: vuitofp_v32i1_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v12, v8, 1, v0
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <32 x half> @llvm.experimental.constrained.uitofp.v32f16.v32i1(<32 x i1> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <32 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i8(<1 x i8>, metadata, metadata)
define <1 x half> @vsitofp_v1i8_v1f16(<1 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i8_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i8(<1 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i7(<1 x i7>, metadata, metadata)
define <1 x half> @vsitofp_v1i7_v1f16(<1 x i7> %va) strictfp {
  %evec = call <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i7(<1 x i7> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i7(<1 x i7>, metadata, metadata)
define <1 x half> @vuitofp_v1i7_v1f16(<1 x i7> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i7_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    andi a0, a0, 127
; CHECK-NEXT:    fcvt.h.wu fa5, a0
; CHECK-NEXT:    fsh fa5, 14(sp)
; CHECK-NEXT:    addi a0, sp, 14
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i7(<1 x i7> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i8(<1 x i8>, metadata, metadata)
define <1 x half> @vuitofp_v1i8_v1f16(<1 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i8_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e8, mf8, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i8(<1 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i8(<1 x i8>, metadata, metadata)
define <1 x float> @vsitofp_v1i8_v1f32(<1 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i8_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i8(<1 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i8(<1 x i8>, metadata, metadata)
define <1 x float> @vuitofp_v1i8_v1f32(<1 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i8_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i8(<1 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i8(<1 x i8>, metadata, metadata)
define <1 x double> @vsitofp_v1i8_v1f64(<1 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i8_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf4 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i8(<1 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}

declare <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i8(<1 x i8>, metadata, metadata)
define <1 x double> @vuitofp_v1i8_v1f64(<1 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i8_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf4 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i8(<1 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}

declare <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i8(<2 x i8>, metadata, metadata)
define <2 x half> @vsitofp_v2i8_v2f16(<2 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i8_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i8(<2 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i8(<2 x i8>, metadata, metadata)
define <2 x half> @vuitofp_v2i8_v2f16(<2 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i8_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i8(<2 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i8(<2 x i8>, metadata, metadata)
define <2 x float> @vsitofp_v2i8_v2f32(<2 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i8_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i8(<2 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i8(<2 x i8>, metadata, metadata)
define <2 x float> @vuitofp_v2i8_v2f32(<2 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i8_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i8(<2 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i8(<2 x i8>, metadata, metadata)
define <2 x double> @vsitofp_v2i8_v2f64(<2 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i8_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf4 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i8(<2 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i8(<2 x i8>, metadata, metadata)
define <2 x double> @vuitofp_v2i8_v2f64(<2 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i8_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf4 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i8(<2 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i8(<4 x i8>, metadata, metadata)
define <4 x half> @vsitofp_v4i8_v4f16(<4 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i8_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i8(<4 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i8(<4 x i8>, metadata, metadata)
define <4 x half> @vuitofp_v4i8_v4f16(<4 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i8_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i8(<4 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i8(<4 x i8>, metadata, metadata)
define <4 x float> @vsitofp_v4i8_v4f32(<4 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i8_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i8(<4 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i8(<4 x i8>, metadata, metadata)
define <4 x float> @vuitofp_v4i8_v4f32(<4 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i8_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i8(<4 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i8(<4 x i8>, metadata, metadata)
define <4 x double> @vsitofp_v4i8_v4f64(<4 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i8_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf4 v10, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i8(<4 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i8(<4 x i8>, metadata, metadata)
define <4 x double> @vuitofp_v4i8_v4f64(<4 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i8_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf4 v10, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i8(<4 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i8(<8 x i8>, metadata, metadata)
define <8 x half> @vsitofp_v8i8_v8f16(<8 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i8_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i8(<8 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i8(<8 x i8>, metadata, metadata)
define <8 x half> @vuitofp_v8i8_v8f16(<8 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i8_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i8(<8 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i8(<8 x i8>, metadata, metadata)
define <8 x float> @vsitofp_v8i8_v8f32(<8 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i8_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i8(<8 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i8(<8 x i8>, metadata, metadata)
define <8 x float> @vuitofp_v8i8_v8f32(<8 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i8_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i8(<8 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i8(<8 x i8>, metadata, metadata)
define <8 x double> @vsitofp_v8i8_v8f64(<8 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i8_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf4 v12, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i8(<8 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i8(<8 x i8>, metadata, metadata)
define <8 x double> @vuitofp_v8i8_v8f64(<8 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i8_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf4 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i8(<8 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <16 x half> @llvm.experimental.constrained.sitofp.v16f16.v16i8(<16 x i8>, metadata, metadata)
define <16 x half> @vsitofp_v16i8_v16f16(<16 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v16i8_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <16 x half> @llvm.experimental.constrained.sitofp.v16f16.v16i8(<16 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x half> %evec
}

declare <16 x half> @llvm.experimental.constrained.uitofp.v16f16.v16i8(<16 x i8>, metadata, metadata)
define <16 x half> @vuitofp_v16i8_v16f16(<16 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v16i8_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <16 x half> @llvm.experimental.constrained.uitofp.v16f16.v16i8(<16 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x half> %evec
}

declare <16 x float> @llvm.experimental.constrained.sitofp.v16f32.v16i8(<16 x i8>, metadata, metadata)
define <16 x float> @vsitofp_v16i8_v16f32(<16 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v16i8_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x float> @llvm.experimental.constrained.sitofp.v16f32.v16i8(<16 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x float> %evec
}

declare <16 x float> @llvm.experimental.constrained.uitofp.v16f32.v16i8(<16 x i8>, metadata, metadata)
define <16 x float> @vuitofp_v16i8_v16f32(<16 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v16i8_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x float> @llvm.experimental.constrained.uitofp.v16f32.v16i8(<16 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x float> %evec
}

declare <32 x half> @llvm.experimental.constrained.sitofp.v32f16.v32i8(<32 x i8>, metadata, metadata)
define <32 x half> @vsitofp_v32i8_v32f16(<32 x i8> %va) strictfp {
; CHECK-LABEL: vsitofp_v32i8_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <32 x half> @llvm.experimental.constrained.sitofp.v32f16.v32i8(<32 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <32 x half> %evec
}

declare <32 x half> @llvm.experimental.constrained.uitofp.v32f16.v32i8(<32 x i8>, metadata, metadata)
define <32 x half> @vuitofp_v32i8_v32f16(<32 x i8> %va) strictfp {
; CHECK-LABEL: vuitofp_v32i8_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <32 x half> @llvm.experimental.constrained.uitofp.v32f16.v32i8(<32 x i8> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <32 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i16(<1 x i16>, metadata, metadata)
define <1 x half> @vsitofp_v1i16_v1f16(<1 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i16_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i16(<1 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i16(<1 x i16>, metadata, metadata)
define <1 x half> @vuitofp_v1i16_v1f16(<1 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i16_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i16(<1 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i16(<1 x i16>, metadata, metadata)
define <1 x float> @vsitofp_v1i16_v1f32(<1 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i16_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i16(<1 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i16(<1 x i16>, metadata, metadata)
define <1 x float> @vuitofp_v1i16_v1f32(<1 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i16_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i16(<1 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i16(<1 x i16>, metadata, metadata)
define <1 x double> @vsitofp_v1i16_v1f64(<1 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i16_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i16(<1 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}

declare <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i16(<1 x i16>, metadata, metadata)
define <1 x double> @vuitofp_v1i16_v1f64(<1 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i16_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i16(<1 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}

declare <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i16(<2 x i16>, metadata, metadata)
define <2 x half> @vsitofp_v2i16_v2f16(<2 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i16_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i16(<2 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i16(<2 x i16>, metadata, metadata)
define <2 x half> @vuitofp_v2i16_v2f16(<2 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i16_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i16(<2 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i16(<2 x i16>, metadata, metadata)
define <2 x float> @vsitofp_v2i16_v2f32(<2 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i16_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i16(<2 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i16(<2 x i16>, metadata, metadata)
define <2 x float> @vuitofp_v2i16_v2f32(<2 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i16_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i16(<2 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i16(<2 x i16>, metadata, metadata)
define <2 x double> @vsitofp_v2i16_v2f64(<2 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i16_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vsext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i16(<2 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i16(<2 x i16>, metadata, metadata)
define <2 x double> @vuitofp_v2i16_v2f64(<2 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i16_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v9, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i16(<2 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i16(<4 x i16>, metadata, metadata)
define <4 x half> @vsitofp_v4i16_v4f16(<4 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i16_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i16(<4 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i16(<4 x i16>, metadata, metadata)
define <4 x half> @vuitofp_v4i16_v4f16(<4 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i16_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i16(<4 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i16(<4 x i16>, metadata, metadata)
define <4 x float> @vsitofp_v4i16_v4f32(<4 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i16_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i16(<4 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i16(<4 x i16>, metadata, metadata)
define <4 x float> @vuitofp_v4i16_v4f32(<4 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i16_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i16(<4 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i16(<4 x i16>, metadata, metadata)
define <4 x double> @vsitofp_v4i16_v4f64(<4 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i16_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i16(<4 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i16(<4 x i16>, metadata, metadata)
define <4 x double> @vuitofp_v4i16_v4f64(<4 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i16_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i16(<4 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i16(<8 x i16>, metadata, metadata)
define <8 x half> @vsitofp_v8i16_v8f16(<8 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i16_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i16(<8 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i16(<8 x i16>, metadata, metadata)
define <8 x half> @vuitofp_v8i16_v8f16(<8 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i16_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i16(<8 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i16(<8 x i16>, metadata, metadata)
define <8 x float> @vsitofp_v8i16_v8f32(<8 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i16_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i16(<8 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i16(<8 x i16>, metadata, metadata)
define <8 x float> @vuitofp_v8i16_v8f32(<8 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i16_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i16(<8 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i16(<8 x i16>, metadata, metadata)
define <8 x double> @vsitofp_v8i16_v8f64(<8 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i16_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.x.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i16(<8 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i16(<8 x i16>, metadata, metadata)
define <8 x double> @vuitofp_v8i16_v8f64(<8 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i16_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v12, v8
; CHECK-NEXT:    vfwcvt.f.xu.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i16(<8 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <16 x half> @llvm.experimental.constrained.sitofp.v16f16.v16i16(<16 x i16>, metadata, metadata)
define <16 x half> @vsitofp_v16i16_v16f16(<16 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v16i16_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <16 x half> @llvm.experimental.constrained.sitofp.v16f16.v16i16(<16 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x half> %evec
}

declare <16 x half> @llvm.experimental.constrained.uitofp.v16f16.v16i16(<16 x i16>, metadata, metadata)
define <16 x half> @vuitofp_v16i16_v16f16(<16 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v16i16_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <16 x half> @llvm.experimental.constrained.uitofp.v16f16.v16i16(<16 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x half> %evec
}

declare <16 x float> @llvm.experimental.constrained.sitofp.v16f32.v16i16(<16 x i16>, metadata, metadata)
define <16 x float> @vsitofp_v16i16_v16f32(<16 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v16i16_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x float> @llvm.experimental.constrained.sitofp.v16f32.v16i16(<16 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x float> %evec
}

declare <16 x float> @llvm.experimental.constrained.uitofp.v16f32.v16i16(<16 x i16>, metadata, metadata)
define <16 x float> @vuitofp_v16i16_v16f32(<16 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v16i16_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x float> @llvm.experimental.constrained.uitofp.v16f32.v16i16(<16 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x float> %evec
}

declare <32 x half> @llvm.experimental.constrained.sitofp.v32f16.v32i16(<32 x i16>, metadata, metadata)
define <32 x half> @vsitofp_v32i16_v32f16(<32 x i16> %va) strictfp {
; CHECK-LABEL: vsitofp_v32i16_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <32 x half> @llvm.experimental.constrained.sitofp.v32f16.v32i16(<32 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <32 x half> %evec
}

declare <32 x half> @llvm.experimental.constrained.uitofp.v32f16.v32i16(<32 x i16>, metadata, metadata)
define <32 x half> @vuitofp_v32i16_v32f16(<32 x i16> %va) strictfp {
; CHECK-LABEL: vuitofp_v32i16_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <32 x half> @llvm.experimental.constrained.uitofp.v32f16.v32i16(<32 x i16> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <32 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i32(<1 x i32>, metadata, metadata)
define <1 x half> @vsitofp_v1i32_v1f16(<1 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i32_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i32(<1 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i32(<1 x i32>, metadata, metadata)
define <1 x half> @vuitofp_v1i32_v1f16(<1 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i32_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i32(<1 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i32(<1 x i32>, metadata, metadata)
define <1 x float> @vsitofp_v1i32_v1f32(<1 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i32_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i32(<1 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i32(<1 x i32>, metadata, metadata)
define <1 x float> @vuitofp_v1i32_v1f32(<1 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i32_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i32(<1 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i32(<1 x i32>, metadata, metadata)
define <1 x double> @vsitofp_v1i32_v1f64(<1 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i32_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i32(<1 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}

declare <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i32(<1 x i32>, metadata, metadata)
define <1 x double> @vuitofp_v1i32_v1f64(<1 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i32_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i32(<1 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}

declare <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i32(<2 x i32>, metadata, metadata)
define <2 x half> @vsitofp_v2i32_v2f16(<2 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i32_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i32(<2 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i32(<2 x i32>, metadata, metadata)
define <2 x half> @vuitofp_v2i32_v2f16(<2 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i32_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i32(<2 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i32(<2 x i32>, metadata, metadata)
define <2 x float> @vsitofp_v2i32_v2f32(<2 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i32_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i32(<2 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i32(<2 x i32>, metadata, metadata)
define <2 x float> @vuitofp_v2i32_v2f32(<2 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i32_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i32(<2 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i32(<2 x i32>, metadata, metadata)
define <2 x double> @vsitofp_v2i32_v2f64(<2 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i32_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i32(<2 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i32(<2 x i32>, metadata, metadata)
define <2 x double> @vuitofp_v2i32_v2f64(<2 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i32_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i32(<2 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i32(<4 x i32>, metadata, metadata)
define <4 x half> @vsitofp_v4i32_v4f16(<4 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i32_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i32(<4 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i32(<4 x i32>, metadata, metadata)
define <4 x half> @vuitofp_v4i32_v4f16(<4 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i32_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i32(<4 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i32(<4 x i32>, metadata, metadata)
define <4 x float> @vsitofp_v4i32_v4f32(<4 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i32_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i32(<4 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i32(<4 x i32>, metadata, metadata)
define <4 x float> @vuitofp_v4i32_v4f32(<4 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i32_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i32(<4 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i32(<4 x i32>, metadata, metadata)
define <4 x double> @vsitofp_v4i32_v4f64(<4 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i32_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i32(<4 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i32(<4 x i32>, metadata, metadata)
define <4 x double> @vuitofp_v4i32_v4f64(<4 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i32_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-NEXT:    vmv2r.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i32(<4 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i32(<8 x i32>, metadata, metadata)
define <8 x half> @vsitofp_v8i32_v8f16(<8 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i32_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i32(<8 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i32(<8 x i32>, metadata, metadata)
define <8 x half> @vuitofp_v8i32_v8f16(<8 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i32_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i32(<8 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i32(<8 x i32>, metadata, metadata)
define <8 x float> @vsitofp_v8i32_v8f32(<8 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i32_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i32(<8 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i32(<8 x i32>, metadata, metadata)
define <8 x float> @vuitofp_v8i32_v8f32(<8 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i32_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i32(<8 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i32(<8 x i32>, metadata, metadata)
define <8 x double> @vsitofp_v8i32_v8f64(<8 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i32_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.x.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i32(<8 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i32(<8 x i32>, metadata, metadata)
define <8 x double> @vuitofp_v8i32_v8f64(<8 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i32_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-NEXT:    vmv4r.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i32(<8 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <16 x half> @llvm.experimental.constrained.sitofp.v16f16.v16i32(<16 x i32>, metadata, metadata)
define <16 x half> @vsitofp_v16i32_v16f16(<16 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v16i32_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x half> @llvm.experimental.constrained.sitofp.v16f16.v16i32(<16 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x half> %evec
}

declare <16 x half> @llvm.experimental.constrained.uitofp.v16f16.v16i32(<16 x i32>, metadata, metadata)
define <16 x half> @vuitofp_v16i32_v16f16(<16 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v16i32_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <16 x half> @llvm.experimental.constrained.uitofp.v16f16.v16i32(<16 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x half> %evec
}

declare <16 x float> @llvm.experimental.constrained.sitofp.v16f32.v16i32(<16 x i32>, metadata, metadata)
define <16 x float> @vsitofp_v16i32_v16f32(<16 x i32> %va) strictfp {
; CHECK-LABEL: vsitofp_v16i32_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <16 x float> @llvm.experimental.constrained.sitofp.v16f32.v16i32(<16 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x float> %evec
}

declare <16 x float> @llvm.experimental.constrained.uitofp.v16f32.v16i32(<16 x i32>, metadata, metadata)
define <16 x float> @vuitofp_v16i32_v16f32(<16 x i32> %va) strictfp {
; CHECK-LABEL: vuitofp_v16i32_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <16 x float> @llvm.experimental.constrained.uitofp.v16f32.v16i32(<16 x i32> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <16 x float> %evec
}

declare <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i64(<1 x i64>, metadata, metadata)
define <1 x half> @vsitofp_v1i64_v1f16(<1 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.sitofp.v1f16.v1i64(<1 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i64(<1 x i64>, metadata, metadata)
define <1 x half> @vuitofp_v1i64_v1f16(<1 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i64_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x half> @llvm.experimental.constrained.uitofp.v1f16.v1i64(<1 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x half> %evec
}

declare <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i64(<1 x i64>, metadata, metadata)
define <1 x float> @vsitofp_v1i64_v1f32(<1 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i64_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.sitofp.v1f32.v1i64(<1 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i64(<1 x i64>, metadata, metadata)
define <1 x float> @vuitofp_v1i64_v1f32(<1 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i64_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <1 x float> @llvm.experimental.constrained.uitofp.v1f32.v1i64(<1 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x float> %evec
}

declare <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i64(<1 x i64>, metadata, metadata)
define <1 x double> @vsitofp_v1i64_v1f64(<1 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v1i64_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.sitofp.v1f64.v1i64(<1 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}

declare <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i64(<1 x i64>, metadata, metadata)
define <1 x double> @vuitofp_v1i64_v1f64(<1 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v1i64_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <1 x double> @llvm.experimental.constrained.uitofp.v1f64.v1i64(<1 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <1 x double> %evec
}


declare <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i64(<2 x i64>, metadata, metadata)
define <2 x half> @vsitofp_v2i64_v2f16(<2 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.sitofp.v2f16.v2i64(<2 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i64(<2 x i64>, metadata, metadata)
define <2 x half> @vuitofp_v2i64_v2f16(<2 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x half> @llvm.experimental.constrained.uitofp.v2f16.v2i64(<2 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x half> %evec
}

declare <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i64(<2 x i64>, metadata, metadata)
define <2 x float> @vsitofp_v2i64_v2f32(<2 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i64_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.sitofp.v2f32.v2i64(<2 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i64(<2 x i64>, metadata, metadata)
define <2 x float> @vuitofp_v2i64_v2f32(<2 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i64_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = call <2 x float> @llvm.experimental.constrained.uitofp.v2f32.v2i64(<2 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x float> %evec
}

declare <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i64(<2 x i64>, metadata, metadata)
define <2 x double> @vsitofp_v2i64_v2f64(<2 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v2i64_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.sitofp.v2f64.v2i64(<2 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i64(<2 x i64>, metadata, metadata)
define <2 x double> @vuitofp_v2i64_v2f64(<2 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v2i64_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <2 x double> @llvm.experimental.constrained.uitofp.v2f64.v2i64(<2 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <2 x double> %evec
}

declare <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i64(<4 x i64>, metadata, metadata)
define <4 x half> @vsitofp_v4i64_v4f16(<4 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.sitofp.v4f16.v4i64(<4 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i64(<4 x i64>, metadata, metadata)
define <4 x half> @vuitofp_v4i64_v4f16(<4 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i64_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x half> @llvm.experimental.constrained.uitofp.v4f16.v4i64(<4 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x half> %evec
}

declare <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i64(<4 x i64>, metadata, metadata)
define <4 x float> @vsitofp_v4i64_v4f32(<4 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i64_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.sitofp.v4f32.v4i64(<4 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i64(<4 x i64>, metadata, metadata)
define <4 x float> @vuitofp_v4i64_v4f32(<4 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i64_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = call <4 x float> @llvm.experimental.constrained.uitofp.v4f32.v4i64(<4 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x float> %evec
}

declare <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i64(<4 x i64>, metadata, metadata)
define <4 x double> @vsitofp_v4i64_v4f64(<4 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v4i64_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.sitofp.v4f64.v4i64(<4 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i64(<4 x i64>, metadata, metadata)
define <4 x double> @vuitofp_v4i64_v4f64(<4 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v4i64_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <4 x double> @llvm.experimental.constrained.uitofp.v4f64.v4i64(<4 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <4 x double> %evec
}

declare <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i64(<8 x i64>, metadata, metadata)
define <8 x half> @vsitofp_v8i64_v8f16(<8 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.sitofp.v8f16.v8i64(<8 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i64(<8 x i64>, metadata, metadata)
define <8 x half> @vuitofp_v8i64_v8f16(<8 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x half> @llvm.experimental.constrained.uitofp.v8f16.v8i64(<8 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x half> %evec
}

declare <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i64(<8 x i64>, metadata, metadata)
define <8 x float> @vsitofp_v8i64_v8f32(<8 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i64_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.x.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.sitofp.v8f32.v8i64(<8 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i64(<8 x i64>, metadata, metadata)
define <8 x float> @vuitofp_v8i64_v8f32(<8 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i64_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = call <8 x float> @llvm.experimental.constrained.uitofp.v8f32.v8i64(<8 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x float> %evec
}

declare <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i64(<8 x i64>, metadata, metadata)
define <8 x double> @vsitofp_v8i64_v8f64(<8 x i64> %va) strictfp {
; CHECK-LABEL: vsitofp_v8i64_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.x.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.sitofp.v8f64.v8i64(<8 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}

declare <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i64(<8 x i64>, metadata, metadata)
define <8 x double> @vuitofp_v8i64_v8f64(<8 x i64> %va) strictfp {
; CHECK-LABEL: vuitofp_v8i64_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-NEXT:    ret
  %evec = call <8 x double> @llvm.experimental.constrained.uitofp.v8f64.v8i64(<8 x i64> %va, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret <8 x double> %evec
}
