; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32,RV32I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV64,RV64I
; RUN: llc -mtriple=riscv32 -mattr=+zbs -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,ZBS,RV32,RV32ZBS
; RUN: llc -mtriple=riscv64 -mattr=+zbs -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,ZBS,RV64,RV64ZBS
; RUN: llc -mtriple=riscv32 -mattr=+xtheadbs -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,XTHEADBS,RV32,RV32XTHEADBS
; RUN: llc -mtriple=riscv64 -mattr=+xtheadbs -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,XTHEADBS,RV64,RV64XTHEADBS

define signext i32 @bittest_7_i32(i32 signext %a) nounwind {
; CHECK-LABEL: bittest_7_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 128
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %shr = lshr i32 %a, 7
  %not = xor i32 %shr, -1
  %and = and i32 %not, 1
  ret i32 %and
}

define signext i32 @bittest_10_i32(i32 signext %a) nounwind {
; CHECK-LABEL: bittest_10_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1024
; CHECK-NEXT:    seqz a0, a0
; CHECK-NEXT:    ret
  %shr = lshr i32 %a, 10
  %not = xor i32 %shr, -1
  %and = and i32 %not, 1
  ret i32 %and
}

define signext i32 @bittest_11_i32(i32 signext %a) nounwind {
; RV32I-LABEL: bittest_11_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    slli a0, a0, 20
; RV32I-NEXT:    srli a0, a0, 31
; RV32I-NEXT:    ret
;
; RV64I-LABEL: bittest_11_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    slli a0, a0, 52
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
;
; ZBS-LABEL: bittest_11_i32:
; ZBS:       # %bb.0:
; ZBS-NEXT:    not a0, a0
; ZBS-NEXT:    bexti a0, a0, 11
; ZBS-NEXT:    ret
;
; XTHEADBS-LABEL: bittest_11_i32:
; XTHEADBS:       # %bb.0:
; XTHEADBS-NEXT:    not a0, a0
; XTHEADBS-NEXT:    th.tst a0, a0, 11
; XTHEADBS-NEXT:    ret
  %shr = lshr i32 %a, 11
  %not = xor i32 %shr, -1
  %and = and i32 %not, 1
  ret i32 %and
}

define signext i32 @bittest_31_i32(i32 signext %a) nounwind {
; RV32-LABEL: bittest_31_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    not a0, a0
; RV32-NEXT:    srli a0, a0, 31
; RV32-NEXT:    ret
;
; RV64-LABEL: bittest_31_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    not a0, a0
; RV64-NEXT:    srliw a0, a0, 31
; RV64-NEXT:    ret
  %shr = lshr i32 %a, 31
  %not = xor i32 %shr, -1
  %and = and i32 %not, 1
  ret i32 %and
}

define i64 @bittest_7_i64(i64 %a) nounwind {
; RV32-LABEL: bittest_7_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a0, a0, 128
; RV32-NEXT:    seqz a0, a0
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: bittest_7_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a0, a0, 128
; RV64-NEXT:    seqz a0, a0
; RV64-NEXT:    ret
  %shr = lshr i64 %a, 7
  %not = xor i64 %shr, -1
  %and = and i64 %not, 1
  ret i64 %and
}

define i64 @bittest_10_i64(i64 %a) nounwind {
; RV32-LABEL: bittest_10_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a0, a0, 1024
; RV32-NEXT:    seqz a0, a0
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: bittest_10_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a0, a0, 1024
; RV64-NEXT:    seqz a0, a0
; RV64-NEXT:    ret
  %shr = lshr i64 %a, 10
  %not = xor i64 %shr, -1
  %and = and i64 %not, 1
  ret i64 %and
}

define i64 @bittest_11_i64(i64 %a) nounwind {
; RV32I-LABEL: bittest_11_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    slli a0, a0, 20
; RV32I-NEXT:    srli a0, a0, 31
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: bittest_11_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    slli a0, a0, 52
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
;
; RV32ZBS-LABEL: bittest_11_i64:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    not a0, a0
; RV32ZBS-NEXT:    bexti a0, a0, 11
; RV32ZBS-NEXT:    li a1, 0
; RV32ZBS-NEXT:    ret
;
; RV64ZBS-LABEL: bittest_11_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    not a0, a0
; RV64ZBS-NEXT:    bexti a0, a0, 11
; RV64ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bittest_11_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    not a0, a0
; RV32XTHEADBS-NEXT:    th.tst a0, a0, 11
; RV32XTHEADBS-NEXT:    li a1, 0
; RV32XTHEADBS-NEXT:    ret
;
; RV64XTHEADBS-LABEL: bittest_11_i64:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    not a0, a0
; RV64XTHEADBS-NEXT:    th.tst a0, a0, 11
; RV64XTHEADBS-NEXT:    ret
  %shr = lshr i64 %a, 11
  %not = xor i64 %shr, -1
  %and = and i64 %not, 1
  ret i64 %and
}

define i64 @bittest_31_i64(i64 %a) nounwind {
; RV32-LABEL: bittest_31_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    not a0, a0
; RV32-NEXT:    srli a0, a0, 31
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    ret
;
; RV64I-LABEL: bittest_31_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srliw a0, a0, 31
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bittest_31_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    not a0, a0
; RV64ZBS-NEXT:    bexti a0, a0, 31
; RV64ZBS-NEXT:    ret
;
; RV64XTHEADBS-LABEL: bittest_31_i64:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    not a0, a0
; RV64XTHEADBS-NEXT:    th.tst a0, a0, 31
; RV64XTHEADBS-NEXT:    ret
  %shr = lshr i64 %a, 31
  %not = xor i64 %shr, -1
  %and = and i64 %not, 1
  ret i64 %and
}

define i64 @bittest_32_i64(i64 %a) nounwind {
; RV32-LABEL: bittest_32_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    not a0, a1
; RV32-NEXT:    andi a0, a0, 1
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    ret
;
; RV64I-LABEL: bittest_32_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    slli a0, a0, 31
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bittest_32_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    not a0, a0
; RV64ZBS-NEXT:    bexti a0, a0, 32
; RV64ZBS-NEXT:    ret
;
; RV64XTHEADBS-LABEL: bittest_32_i64:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    not a0, a0
; RV64XTHEADBS-NEXT:    th.tst a0, a0, 32
; RV64XTHEADBS-NEXT:    ret
  %shr = lshr i64 %a, 32
  %not = xor i64 %shr, -1
  %and = and i64 %not, 1
  ret i64 %and
}

define i64 @bittest_63_i64(i64 %a) nounwind {
; RV32-LABEL: bittest_63_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    not a0, a1
; RV32-NEXT:    srli a0, a0, 31
; RV32-NEXT:    li a1, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: bittest_63_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    not a0, a0
; RV64-NEXT:    srli a0, a0, 63
; RV64-NEXT:    ret
  %shr = lshr i64 %a, 63
  %not = xor i64 %shr, -1
  %and = and i64 %not, 1
  ret i64 %and
}

; Make sure we use (andi (srl X, Y), 1) or bext.
define i1 @bittest_constant_by_var_shr_i32(i32 signext %b) nounwind {
; RV32I-LABEL: bittest_constant_by_var_shr_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 301408
; RV32I-NEXT:    addi a1, a1, 722
; RV32I-NEXT:    srl a0, a1, a0
; RV32I-NEXT:    andi a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: bittest_constant_by_var_shr_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 301408
; RV64I-NEXT:    addiw a1, a1, 722
; RV64I-NEXT:    srlw a0, a1, a0
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBS-LABEL: bittest_constant_by_var_shr_i32:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    lui a1, 301408
; RV32ZBS-NEXT:    addi a1, a1, 722
; RV32ZBS-NEXT:    bext a0, a1, a0
; RV32ZBS-NEXT:    ret
;
; RV64ZBS-LABEL: bittest_constant_by_var_shr_i32:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    lui a1, 301408
; RV64ZBS-NEXT:    addiw a1, a1, 722
; RV64ZBS-NEXT:    bext a0, a1, a0
; RV64ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bittest_constant_by_var_shr_i32:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    lui a1, 301408
; RV32XTHEADBS-NEXT:    addi a1, a1, 722
; RV32XTHEADBS-NEXT:    srl a0, a1, a0
; RV32XTHEADBS-NEXT:    andi a0, a0, 1
; RV32XTHEADBS-NEXT:    ret
;
; RV64XTHEADBS-LABEL: bittest_constant_by_var_shr_i32:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    lui a1, 301408
; RV64XTHEADBS-NEXT:    addiw a1, a1, 722
; RV64XTHEADBS-NEXT:    srlw a0, a1, a0
; RV64XTHEADBS-NEXT:    andi a0, a0, 1
; RV64XTHEADBS-NEXT:    ret
  %shl = lshr i32 1234567890, %b
  %and = and i32 %shl, 1
  %cmp = icmp ne i32 %and, 0
  ret i1 %cmp
}

; Make sure we use (andi (srl X, Y), 1) or bext.
define i1 @bittest_constant_by_var_shl_i32(i32 signext %b) nounwind {
; RV32I-LABEL: bittest_constant_by_var_shl_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 301408
; RV32I-NEXT:    addi a1, a1, 722
; RV32I-NEXT:    srl a0, a1, a0
; RV32I-NEXT:    andi a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: bittest_constant_by_var_shl_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 301408
; RV64I-NEXT:    addiw a1, a1, 722
; RV64I-NEXT:    srlw a0, a1, a0
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBS-LABEL: bittest_constant_by_var_shl_i32:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    lui a1, 301408
; RV32ZBS-NEXT:    addi a1, a1, 722
; RV32ZBS-NEXT:    bext a0, a1, a0
; RV32ZBS-NEXT:    ret
;
; RV64ZBS-LABEL: bittest_constant_by_var_shl_i32:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    lui a1, 301408
; RV64ZBS-NEXT:    addiw a1, a1, 722
; RV64ZBS-NEXT:    bext a0, a1, a0
; RV64ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bittest_constant_by_var_shl_i32:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    lui a1, 301408
; RV32XTHEADBS-NEXT:    addi a1, a1, 722
; RV32XTHEADBS-NEXT:    srl a0, a1, a0
; RV32XTHEADBS-NEXT:    andi a0, a0, 1
; RV32XTHEADBS-NEXT:    ret
;
; RV64XTHEADBS-LABEL: bittest_constant_by_var_shl_i32:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    lui a1, 301408
; RV64XTHEADBS-NEXT:    addiw a1, a1, 722
; RV64XTHEADBS-NEXT:    srlw a0, a1, a0
; RV64XTHEADBS-NEXT:    andi a0, a0, 1
; RV64XTHEADBS-NEXT:    ret
  %shl = shl i32 1, %b
  %and = and i32 %shl, 1234567890
  %cmp = icmp ne i32 %and, 0
  ret i1 %cmp
}

; Make sure we use (andi (srl X, Y), 1) or bext.
define i1 @bittest_constant_by_var_shr_i64(i64 %b) nounwind {
; RV32-LABEL: bittest_constant_by_var_shr_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a1, 301408
; RV32-NEXT:    addi a1, a1, 722
; RV32-NEXT:    srl a1, a1, a0
; RV32-NEXT:    addi a0, a0, -32
; RV32-NEXT:    srli a0, a0, 31
; RV32-NEXT:    and a0, a0, a1
; RV32-NEXT:    ret
;
; RV64I-LABEL: bittest_constant_by_var_shr_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 301408
; RV64I-NEXT:    addiw a1, a1, 722
; RV64I-NEXT:    srl a0, a1, a0
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bittest_constant_by_var_shr_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    lui a1, 301408
; RV64ZBS-NEXT:    addiw a1, a1, 722
; RV64ZBS-NEXT:    bext a0, a1, a0
; RV64ZBS-NEXT:    ret
;
; RV64XTHEADBS-LABEL: bittest_constant_by_var_shr_i64:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    lui a1, 301408
; RV64XTHEADBS-NEXT:    addiw a1, a1, 722
; RV64XTHEADBS-NEXT:    srl a0, a1, a0
; RV64XTHEADBS-NEXT:    andi a0, a0, 1
; RV64XTHEADBS-NEXT:    ret
  %shl = lshr i64 1234567890, %b
  %and = and i64 %shl, 1
  %cmp = icmp ne i64 %and, 0
  ret i1 %cmp
}

; Make sure we use (andi (srl X, Y), 1) or bext.
define i1 @bittest_constant_by_var_shl_i64(i64 %b) nounwind {
; RV32-LABEL: bittest_constant_by_var_shl_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a1, 301408
; RV32-NEXT:    addi a1, a1, 722
; RV32-NEXT:    srl a1, a1, a0
; RV32-NEXT:    addi a0, a0, -32
; RV32-NEXT:    srli a0, a0, 31
; RV32-NEXT:    and a0, a0, a1
; RV32-NEXT:    ret
;
; RV64I-LABEL: bittest_constant_by_var_shl_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 301408
; RV64I-NEXT:    addiw a1, a1, 722
; RV64I-NEXT:    srl a0, a1, a0
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBS-LABEL: bittest_constant_by_var_shl_i64:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    lui a1, 301408
; RV64ZBS-NEXT:    addiw a1, a1, 722
; RV64ZBS-NEXT:    bext a0, a1, a0
; RV64ZBS-NEXT:    ret
;
; RV64XTHEADBS-LABEL: bittest_constant_by_var_shl_i64:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    lui a1, 301408
; RV64XTHEADBS-NEXT:    addiw a1, a1, 722
; RV64XTHEADBS-NEXT:    srl a0, a1, a0
; RV64XTHEADBS-NEXT:    andi a0, a0, 1
; RV64XTHEADBS-NEXT:    ret
  %shl = shl i64 1, %b
  %and = and i64 %shl, 1234567890
  %cmp = icmp ne i64 %and, 0
  ret i1 %cmp
}

; We want to use (andi (srl X, Y), 1) or bext before the beqz.
define void @bittest_switch(i32 signext %0) {
; RV32I-LABEL: bittest_switch:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 31
; RV32I-NEXT:    bltu a1, a0, .LBB14_3
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    lui a1, 524291
; RV32I-NEXT:    addi a1, a1, 768
; RV32I-NEXT:    srl a0, a1, a0
; RV32I-NEXT:    andi a0, a0, 1
; RV32I-NEXT:    beqz a0, .LBB14_3
; RV32I-NEXT:  # %bb.2:
; RV32I-NEXT:    tail bar@plt
; RV32I-NEXT:  .LBB14_3:
; RV32I-NEXT:    ret
;
; RV64I-LABEL: bittest_switch:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 31
; RV64I-NEXT:    bltu a1, a0, .LBB14_3
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    lui a1, 2048
; RV64I-NEXT:    addiw a1, a1, 51
; RV64I-NEXT:    slli a1, a1, 8
; RV64I-NEXT:    srl a0, a1, a0
; RV64I-NEXT:    andi a0, a0, 1
; RV64I-NEXT:    beqz a0, .LBB14_3
; RV64I-NEXT:  # %bb.2:
; RV64I-NEXT:    tail bar@plt
; RV64I-NEXT:  .LBB14_3:
; RV64I-NEXT:    ret
;
; RV32ZBS-LABEL: bittest_switch:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    li a1, 31
; RV32ZBS-NEXT:    bltu a1, a0, .LBB14_3
; RV32ZBS-NEXT:  # %bb.1:
; RV32ZBS-NEXT:    lui a1, 524291
; RV32ZBS-NEXT:    addi a1, a1, 768
; RV32ZBS-NEXT:    bext a0, a1, a0
; RV32ZBS-NEXT:    beqz a0, .LBB14_3
; RV32ZBS-NEXT:  # %bb.2:
; RV32ZBS-NEXT:    tail bar@plt
; RV32ZBS-NEXT:  .LBB14_3:
; RV32ZBS-NEXT:    ret
;
; RV64ZBS-LABEL: bittest_switch:
; RV64ZBS:       # %bb.0:
; RV64ZBS-NEXT:    li a1, 31
; RV64ZBS-NEXT:    bltu a1, a0, .LBB14_3
; RV64ZBS-NEXT:  # %bb.1:
; RV64ZBS-NEXT:    lui a1, 2048
; RV64ZBS-NEXT:    addiw a1, a1, 51
; RV64ZBS-NEXT:    slli a1, a1, 8
; RV64ZBS-NEXT:    bext a0, a1, a0
; RV64ZBS-NEXT:    beqz a0, .LBB14_3
; RV64ZBS-NEXT:  # %bb.2:
; RV64ZBS-NEXT:    tail bar@plt
; RV64ZBS-NEXT:  .LBB14_3:
; RV64ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bittest_switch:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    li a1, 31
; RV32XTHEADBS-NEXT:    bltu a1, a0, .LBB14_3
; RV32XTHEADBS-NEXT:  # %bb.1:
; RV32XTHEADBS-NEXT:    lui a1, 524291
; RV32XTHEADBS-NEXT:    addi a1, a1, 768
; RV32XTHEADBS-NEXT:    srl a0, a1, a0
; RV32XTHEADBS-NEXT:    andi a0, a0, 1
; RV32XTHEADBS-NEXT:    beqz a0, .LBB14_3
; RV32XTHEADBS-NEXT:  # %bb.2:
; RV32XTHEADBS-NEXT:    tail bar@plt
; RV32XTHEADBS-NEXT:  .LBB14_3:
; RV32XTHEADBS-NEXT:    ret
;
; RV64XTHEADBS-LABEL: bittest_switch:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    li a1, 31
; RV64XTHEADBS-NEXT:    bltu a1, a0, .LBB14_3
; RV64XTHEADBS-NEXT:  # %bb.1:
; RV64XTHEADBS-NEXT:    lui a1, 2048
; RV64XTHEADBS-NEXT:    addiw a1, a1, 51
; RV64XTHEADBS-NEXT:    slli a1, a1, 8
; RV64XTHEADBS-NEXT:    srl a0, a1, a0
; RV64XTHEADBS-NEXT:    andi a0, a0, 1
; RV64XTHEADBS-NEXT:    beqz a0, .LBB14_3
; RV64XTHEADBS-NEXT:  # %bb.2:
; RV64XTHEADBS-NEXT:    tail bar@plt
; RV64XTHEADBS-NEXT:  .LBB14_3:
; RV64XTHEADBS-NEXT:    ret
  switch i32 %0, label %3 [
    i32 8, label %2
    i32 9, label %2
    i32 12, label %2
    i32 13, label %2
    i32 31, label %2
  ]

2:
  tail call void @bar()
  br label %3

3:
  ret void
}

declare void @bar()

define signext i32 @bit_10_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; CHECK-LABEL: bit_10_z_select_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a3, a0, 1024
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    beqz a3, .LBB15_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB15_2:
; CHECK-NEXT:    ret
  %1 = and i32 %a, 1024
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_10_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_10_nz_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 21
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bltz a3, .LBB16_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB16_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_10_nz_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 53
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bltz a3, .LBB16_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB16_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 1024
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_11_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_11_z_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 20
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bgez a3, .LBB17_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB17_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_11_z_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 52
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bgez a3, .LBB17_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB17_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 2048
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_11_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_11_nz_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 20
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bltz a3, .LBB18_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB18_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_11_nz_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 52
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bltz a3, .LBB18_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB18_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 2048
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_20_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_20_z_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 11
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bgez a3, .LBB19_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB19_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_20_z_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 43
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bgez a3, .LBB19_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB19_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 1048576
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_20_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_20_nz_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 11
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bltz a3, .LBB20_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB20_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_20_nz_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 43
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bltz a3, .LBB20_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB20_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 1048576
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_31_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_31_z_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    bgez a0, .LBB21_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a1, a2
; RV32-NEXT:  .LBB21_2:
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_z_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a3, 524288
; RV64-NEXT:    and a3, a0, a3
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB21_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB21_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 2147483648
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_31_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_31_nz_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    srli a3, a0, 31
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bnez a3, .LBB22_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB22_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_nz_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a3, 524288
; RV64-NEXT:    and a3, a0, a3
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB22_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB22_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 2147483648
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define i64 @bit_10_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_10_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a6, a0, 1024
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    beqz a6, .LBB23_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB23_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_10_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a3, a0, 1024
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB23_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB23_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 1024
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_10_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32I-LABEL: bit_10_nz_select_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 21
; RV32I-NEXT:    srli a6, a0, 31
; RV32I-NEXT:    mv a1, a3
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    bnez a6, .LBB24_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:  .LBB24_2:
; RV32I-NEXT:    ret
;
; RV64-LABEL: bit_10_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 53
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bltz a3, .LBB24_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB24_2:
; RV64-NEXT:    ret
;
; RV32ZBS-LABEL: bit_10_nz_select_i64:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    bexti a6, a0, 10
; RV32ZBS-NEXT:    mv a1, a3
; RV32ZBS-NEXT:    mv a0, a2
; RV32ZBS-NEXT:    bnez a6, .LBB24_2
; RV32ZBS-NEXT:  # %bb.1:
; RV32ZBS-NEXT:    mv a0, a4
; RV32ZBS-NEXT:    mv a1, a5
; RV32ZBS-NEXT:  .LBB24_2:
; RV32ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bit_10_nz_select_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    th.tst a6, a0, 10
; RV32XTHEADBS-NEXT:    mv a1, a3
; RV32XTHEADBS-NEXT:    mv a0, a2
; RV32XTHEADBS-NEXT:    bnez a6, .LBB24_2
; RV32XTHEADBS-NEXT:  # %bb.1:
; RV32XTHEADBS-NEXT:    mv a0, a4
; RV32XTHEADBS-NEXT:    mv a1, a5
; RV32XTHEADBS-NEXT:  .LBB24_2:
; RV32XTHEADBS-NEXT:    ret
  %1 = and i64 %a, 1024
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_11_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_11_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a6, a0, 20
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bgez a6, .LBB25_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB25_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_11_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 52
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bgez a3, .LBB25_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB25_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 2048
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_11_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32I-LABEL: bit_11_nz_select_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 20
; RV32I-NEXT:    srli a6, a0, 31
; RV32I-NEXT:    mv a1, a3
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    bnez a6, .LBB26_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:  .LBB26_2:
; RV32I-NEXT:    ret
;
; RV64-LABEL: bit_11_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 52
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bltz a3, .LBB26_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB26_2:
; RV64-NEXT:    ret
;
; RV32ZBS-LABEL: bit_11_nz_select_i64:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    bexti a6, a0, 11
; RV32ZBS-NEXT:    mv a1, a3
; RV32ZBS-NEXT:    mv a0, a2
; RV32ZBS-NEXT:    bnez a6, .LBB26_2
; RV32ZBS-NEXT:  # %bb.1:
; RV32ZBS-NEXT:    mv a0, a4
; RV32ZBS-NEXT:    mv a1, a5
; RV32ZBS-NEXT:  .LBB26_2:
; RV32ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bit_11_nz_select_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    th.tst a6, a0, 11
; RV32XTHEADBS-NEXT:    mv a1, a3
; RV32XTHEADBS-NEXT:    mv a0, a2
; RV32XTHEADBS-NEXT:    bnez a6, .LBB26_2
; RV32XTHEADBS-NEXT:  # %bb.1:
; RV32XTHEADBS-NEXT:    mv a0, a4
; RV32XTHEADBS-NEXT:    mv a1, a5
; RV32XTHEADBS-NEXT:  .LBB26_2:
; RV32XTHEADBS-NEXT:    ret
  %1 = and i64 %a, 2048
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_20_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_20_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a6, a0, 11
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bgez a6, .LBB27_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB27_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_20_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 43
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bgez a3, .LBB27_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB27_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 1048576
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_20_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32I-LABEL: bit_20_nz_select_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 11
; RV32I-NEXT:    srli a6, a0, 31
; RV32I-NEXT:    mv a1, a3
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    bnez a6, .LBB28_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:  .LBB28_2:
; RV32I-NEXT:    ret
;
; RV64-LABEL: bit_20_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 43
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bltz a3, .LBB28_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB28_2:
; RV64-NEXT:    ret
;
; RV32ZBS-LABEL: bit_20_nz_select_i64:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    bexti a6, a0, 20
; RV32ZBS-NEXT:    mv a1, a3
; RV32ZBS-NEXT:    mv a0, a2
; RV32ZBS-NEXT:    bnez a6, .LBB28_2
; RV32ZBS-NEXT:  # %bb.1:
; RV32ZBS-NEXT:    mv a0, a4
; RV32ZBS-NEXT:    mv a1, a5
; RV32ZBS-NEXT:  .LBB28_2:
; RV32ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bit_20_nz_select_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    th.tst a6, a0, 20
; RV32XTHEADBS-NEXT:    mv a1, a3
; RV32XTHEADBS-NEXT:    mv a0, a2
; RV32XTHEADBS-NEXT:    bnez a6, .LBB28_2
; RV32XTHEADBS-NEXT:  # %bb.1:
; RV32XTHEADBS-NEXT:    mv a0, a4
; RV32XTHEADBS-NEXT:    mv a1, a5
; RV32XTHEADBS-NEXT:  .LBB28_2:
; RV32XTHEADBS-NEXT:    ret
  %1 = and i64 %a, 1048576
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_31_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_31_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    bgez a0, .LBB29_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB29_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 32
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bgez a3, .LBB29_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB29_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 2147483648
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_31_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_31_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    srli a6, a0, 31
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a6, .LBB30_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB30_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 32
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bltz a3, .LBB30_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB30_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 2147483648
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_32_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_32_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a6, a1, 1
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    beqz a6, .LBB31_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB31_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_32_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 31
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bgez a3, .LBB31_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB31_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 4294967296
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_32_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_32_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a6, a1, 1
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a6, .LBB32_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB32_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_32_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 31
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bltz a3, .LBB32_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB32_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 4294967296
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_55_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_55_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a6, a1, 8
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bgez a6, .LBB33_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB33_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_55_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 8
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bgez a3, .LBB33_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB33_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 36028797018963968
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_55_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32I-LABEL: bit_55_nz_select_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    srli a6, a1, 31
; RV32I-NEXT:    mv a1, a3
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    bnez a6, .LBB34_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:  .LBB34_2:
; RV32I-NEXT:    ret
;
; RV64-LABEL: bit_55_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 8
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bltz a3, .LBB34_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB34_2:
; RV64-NEXT:    ret
;
; RV32ZBS-LABEL: bit_55_nz_select_i64:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    bexti a6, a1, 23
; RV32ZBS-NEXT:    mv a1, a3
; RV32ZBS-NEXT:    mv a0, a2
; RV32ZBS-NEXT:    bnez a6, .LBB34_2
; RV32ZBS-NEXT:  # %bb.1:
; RV32ZBS-NEXT:    mv a0, a4
; RV32ZBS-NEXT:    mv a1, a5
; RV32ZBS-NEXT:  .LBB34_2:
; RV32ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bit_55_nz_select_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    th.tst a6, a1, 23
; RV32XTHEADBS-NEXT:    mv a1, a3
; RV32XTHEADBS-NEXT:    mv a0, a2
; RV32XTHEADBS-NEXT:    bnez a6, .LBB34_2
; RV32XTHEADBS-NEXT:  # %bb.1:
; RV32XTHEADBS-NEXT:    mv a0, a4
; RV32XTHEADBS-NEXT:    mv a1, a5
; RV32XTHEADBS-NEXT:  .LBB34_2:
; RV32XTHEADBS-NEXT:    ret
  %1 = and i64 %a, 36028797018963968
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_63_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_63_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bgez a1, .LBB35_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a3, a5
; RV32-NEXT:  .LBB35_2:
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_63_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    bgez a0, .LBB35_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:  .LBB35_2:
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    ret
  %1 = and i64 %a, 9223372036854775808
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_63_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_63_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    srli a6, a1, 31
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a6, .LBB36_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB36_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_63_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    srli a3, a0, 63
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB36_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB36_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 9223372036854775808
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define void @bit_10_z_branch_i32(i32 signext %0) {
; CHECK-LABEL: bit_10_z_branch_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1024
; CHECK-NEXT:    bnez a0, .LBB37_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    tail bar@plt
; CHECK-NEXT:  .LBB37_2:
; CHECK-NEXT:    ret
  %2 = and i32 %0, 1024
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_10_nz_branch_i32(i32 signext %0) {
; CHECK-LABEL: bit_10_nz_branch_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1024
; CHECK-NEXT:    beqz a0, .LBB38_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    tail bar@plt
; CHECK-NEXT:  .LBB38_2:
; CHECK-NEXT:    ret
  %2 = and i32 %0, 1024
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_11_z_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_11_z_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 20
; RV32-NEXT:    bltz a0, .LBB39_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB39_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_11_z_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 52
; RV64-NEXT:    bltz a0, .LBB39_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB39_2:
; RV64-NEXT:    ret
  %2 = and i32 %0, 2048
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_11_nz_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_11_nz_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 20
; RV32-NEXT:    bgez a0, .LBB40_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB40_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_11_nz_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 52
; RV64-NEXT:    bgez a0, .LBB40_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB40_2:
; RV64-NEXT:    ret
  %2 = and i32 %0, 2048
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_24_z_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_24_z_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 7
; RV32-NEXT:    bltz a0, .LBB41_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB41_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_24_z_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 39
; RV64-NEXT:    bltz a0, .LBB41_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB41_2:
; RV64-NEXT:    ret
  %2 = and i32 %0, 16777216
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_24_nz_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_24_nz_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 7
; RV32-NEXT:    bgez a0, .LBB42_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB42_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_24_nz_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 39
; RV64-NEXT:    bgez a0, .LBB42_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB42_2:
; RV64-NEXT:    ret
  %2 = and i32 %0, 16777216
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_31_z_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_31_z_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    bltz a0, .LBB43_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB43_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_z_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 524288
; RV64-NEXT:    and a0, a0, a1
; RV64-NEXT:    bnez a0, .LBB43_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB43_2:
; RV64-NEXT:    ret
  %2 = and i32 %0, 2147483648
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_31_nz_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_31_nz_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    bgez a0, .LBB44_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB44_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_nz_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 524288
; RV64-NEXT:    and a0, a0, a1
; RV64-NEXT:    beqz a0, .LBB44_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB44_2:
; RV64-NEXT:    ret
  %2 = and i32 %0, 2147483648
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_10_z_branch_i64(i64 %0) {
; CHECK-LABEL: bit_10_z_branch_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1024
; CHECK-NEXT:    bnez a0, .LBB45_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    tail bar@plt
; CHECK-NEXT:  .LBB45_2:
; CHECK-NEXT:    ret
  %2 = and i64 %0, 1024
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_10_nz_branch_i64(i64 %0) {
; CHECK-LABEL: bit_10_nz_branch_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1024
; CHECK-NEXT:    beqz a0, .LBB46_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    tail bar@plt
; CHECK-NEXT:  .LBB46_2:
; CHECK-NEXT:    ret
  %2 = and i64 %0, 1024
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_11_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_11_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 20
; RV32-NEXT:    bltz a0, .LBB47_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB47_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_11_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 52
; RV64-NEXT:    bltz a0, .LBB47_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB47_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 2048
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_11_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_11_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 20
; RV32-NEXT:    bgez a0, .LBB48_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB48_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_11_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 52
; RV64-NEXT:    bgez a0, .LBB48_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB48_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 2048
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_24_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_24_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 7
; RV32-NEXT:    bltz a0, .LBB49_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB49_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_24_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 39
; RV64-NEXT:    bltz a0, .LBB49_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB49_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 16777216
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_24_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_24_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 7
; RV32-NEXT:    bgez a0, .LBB50_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB50_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_24_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 39
; RV64-NEXT:    bgez a0, .LBB50_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB50_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 16777216
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_31_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_31_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    bltz a0, .LBB51_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB51_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    bltz a0, .LBB51_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB51_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 2147483648
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_31_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_31_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    bgez a0, .LBB52_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB52_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    bgez a0, .LBB52_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB52_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 2147483648
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_32_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_32_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a1, a1, 1
; RV32-NEXT:    bnez a1, .LBB53_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB53_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_32_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 31
; RV64-NEXT:    bltz a0, .LBB53_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB53_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 4294967296
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_32_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_32_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a1, a1, 1
; RV32-NEXT:    beqz a1, .LBB54_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB54_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_32_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 31
; RV64-NEXT:    bgez a0, .LBB54_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB54_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 4294967296
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_62_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_62_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a1, a1, 1
; RV32-NEXT:    bltz a1, .LBB55_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB55_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_62_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 1
; RV64-NEXT:    bltz a0, .LBB55_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB55_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 4611686018427387904
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_62_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_62_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a1, a1, 1
; RV32-NEXT:    bgez a1, .LBB56_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB56_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_62_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 1
; RV64-NEXT:    bgez a0, .LBB56_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB56_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 4611686018427387904
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_63_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_63_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    bltz a1, .LBB57_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB57_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_63_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    bltz a0, .LBB57_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB57_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 9223372036854775808
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_63_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_63_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    bgez a1, .LBB58_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB58_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_63_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    bgez a0, .LBB58_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB58_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 9223372036854775808
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define signext i32 @bit_10_1_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; CHECK-LABEL: bit_10_1_z_select_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a3, a0, 1023
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    beqz a3, .LBB59_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB59_2:
; CHECK-NEXT:    ret
  %1 = and i32 %a, 1023
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_10_1_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; CHECK-LABEL: bit_10_1_nz_select_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a3, a0, 1023
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    bnez a3, .LBB60_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB60_2:
; CHECK-NEXT:    ret
  %1 = and i32 %a, 1023
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_11_1_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; CHECK-LABEL: bit_11_1_z_select_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a3, a0, 2047
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    beqz a3, .LBB61_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB61_2:
; CHECK-NEXT:    ret
  %1 = and i32 %a, 2047
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_11_1_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; CHECK-LABEL: bit_11_1_nz_select_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a3, a0, 2047
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    bnez a3, .LBB62_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB62_2:
; CHECK-NEXT:    ret
  %1 = and i32 %a, 2047
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_16_1_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_16_1_z_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 16
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    beqz a3, .LBB63_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB63_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_16_1_z_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 48
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB63_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB63_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 65535
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_16_1_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_16_1_nz_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 16
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bnez a3, .LBB64_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB64_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_16_1_nz_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 48
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB64_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB64_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 65535
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_20_1_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_20_1_z_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 12
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    beqz a3, .LBB65_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB65_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_20_1_z_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 44
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB65_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB65_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 1048575
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_20_1_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_20_1_nz_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 12
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bnez a3, .LBB66_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB66_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_20_1_nz_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 44
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB66_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB66_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 1048575
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_31_1_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_31_1_z_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 1
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    beqz a3, .LBB67_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB67_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_1_z_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 33
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB67_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB67_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 2147483647
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_31_1_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; RV32-LABEL: bit_31_1_nz_select_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a3, a0, 1
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bnez a3, .LBB68_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB68_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_1_nz_select_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 33
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB68_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB68_2:
; RV64-NEXT:    ret
  %1 = and i32 %a, 2147483647
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_32_1_z_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; CHECK-LABEL: bit_32_1_z_select_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    beqz a0, .LBB69_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:  .LBB69_2:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    ret
  %1 = and i32 %a, 4294967295
  %2 = icmp eq i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define signext i32 @bit_32_1_nz_select_i32(i32 signext %a, i32 signext %b, i32 signext %c) {
; CHECK-LABEL: bit_32_1_nz_select_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    bnez a0, .LBB70_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a1, a2
; CHECK-NEXT:  .LBB70_2:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    ret
  %1 = and i32 %a, 4294967295
  %2 = icmp ne i32 %1, 0
  %3 = select i1 %2, i32 %b, i32 %c
  ret i32 %3
}

define i64 @bit_10_1_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_10_1_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a6, a0, 1023
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    beqz a6, .LBB71_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB71_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_10_1_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a3, a0, 1023
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB71_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB71_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 1023
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_10_1_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_10_1_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a6, a0, 1023
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a6, .LBB72_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB72_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_10_1_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a3, a0, 1023
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB72_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB72_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 1023
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_11_1_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_11_1_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a6, a0, 2047
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    beqz a6, .LBB73_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB73_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_11_1_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a3, a0, 2047
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB73_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB73_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 2047
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_11_1_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_11_1_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a6, a0, 2047
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a6, .LBB74_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB74_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_11_1_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a3, a0, 2047
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB74_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB74_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 2047
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_16_1_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_16_1_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a6, a0, 16
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    beqz a6, .LBB75_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB75_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_16_1_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 48
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB75_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB75_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 65535
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_16_1_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_16_1_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    bnez a0, .LBB76_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB76_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_16_1_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    sext.w a3, a0
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB76_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB76_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 4294967295
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}


define i64 @bit_20_1_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_20_1_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a6, a0, 12
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    beqz a6, .LBB77_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB77_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_20_1_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 44
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB77_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB77_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 1048575
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_20_1_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_20_1_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a6, a0, 12
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a6, .LBB78_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB78_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_20_1_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 44
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB78_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB78_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 1048575
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_31_1_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_31_1_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a6, a0, 1
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    beqz a6, .LBB79_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB79_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_1_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 33
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB79_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB79_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 2147483647
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_31_1_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_31_1_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a6, a0, 1
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a6, .LBB80_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB80_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_1_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 33
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB80_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB80_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 2147483647
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_32_1_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_32_1_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    beqz a0, .LBB81_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB81_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_32_1_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    sext.w a3, a0
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB81_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB81_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 4294967295
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_32_1_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_32_1_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    bnez a0, .LBB82_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB82_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_32_1_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    sext.w a3, a0
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB82_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB82_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 4294967295
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_55_1_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_55_1_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a1, a1, 9
; RV32-NEXT:    srli a1, a1, 9
; RV32-NEXT:    or a6, a0, a1
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    beqz a6, .LBB83_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB83_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_55_1_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 9
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB83_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB83_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 36028797018963967
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_55_1_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_55_1_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a1, a1, 9
; RV32-NEXT:    srli a1, a1, 9
; RV32-NEXT:    or a6, a0, a1
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a6, .LBB84_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB84_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_55_1_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 9
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB84_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB84_2:
; RV64-NEXT:    ret
  %1 = and i64 %a, 36028797018963967
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_63_1_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32I-LABEL: bit_63_1_z_select_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    or a6, a0, a1
; RV32I-NEXT:    mv a1, a3
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    beqz a6, .LBB85_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:  .LBB85_2:
; RV32I-NEXT:    ret
;
; RV64-LABEL: bit_63_1_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 1
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    beqz a3, .LBB85_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB85_2:
; RV64-NEXT:    ret
;
; RV32ZBS-LABEL: bit_63_1_z_select_i64:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    bclri a1, a1, 31
; RV32ZBS-NEXT:    or a6, a0, a1
; RV32ZBS-NEXT:    mv a1, a3
; RV32ZBS-NEXT:    mv a0, a2
; RV32ZBS-NEXT:    beqz a6, .LBB85_2
; RV32ZBS-NEXT:  # %bb.1:
; RV32ZBS-NEXT:    mv a0, a4
; RV32ZBS-NEXT:    mv a1, a5
; RV32ZBS-NEXT:  .LBB85_2:
; RV32ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bit_63_1_z_select_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    slli a1, a1, 1
; RV32XTHEADBS-NEXT:    srli a1, a1, 1
; RV32XTHEADBS-NEXT:    or a6, a0, a1
; RV32XTHEADBS-NEXT:    mv a1, a3
; RV32XTHEADBS-NEXT:    mv a0, a2
; RV32XTHEADBS-NEXT:    beqz a6, .LBB85_2
; RV32XTHEADBS-NEXT:  # %bb.1:
; RV32XTHEADBS-NEXT:    mv a0, a4
; RV32XTHEADBS-NEXT:    mv a1, a5
; RV32XTHEADBS-NEXT:  .LBB85_2:
; RV32XTHEADBS-NEXT:    ret
  %1 = and i64 %a, 9223372036854775807
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_63_1_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32I-LABEL: bit_63_1_nz_select_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    or a6, a0, a1
; RV32I-NEXT:    mv a1, a3
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    bnez a6, .LBB86_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a4
; RV32I-NEXT:    mv a1, a5
; RV32I-NEXT:  .LBB86_2:
; RV32I-NEXT:    ret
;
; RV64-LABEL: bit_63_1_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a3, a0, 1
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB86_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB86_2:
; RV64-NEXT:    ret
;
; RV32ZBS-LABEL: bit_63_1_nz_select_i64:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    bclri a1, a1, 31
; RV32ZBS-NEXT:    or a6, a0, a1
; RV32ZBS-NEXT:    mv a1, a3
; RV32ZBS-NEXT:    mv a0, a2
; RV32ZBS-NEXT:    bnez a6, .LBB86_2
; RV32ZBS-NEXT:  # %bb.1:
; RV32ZBS-NEXT:    mv a0, a4
; RV32ZBS-NEXT:    mv a1, a5
; RV32ZBS-NEXT:  .LBB86_2:
; RV32ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bit_63_1_nz_select_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    slli a1, a1, 1
; RV32XTHEADBS-NEXT:    srli a1, a1, 1
; RV32XTHEADBS-NEXT:    or a6, a0, a1
; RV32XTHEADBS-NEXT:    mv a1, a3
; RV32XTHEADBS-NEXT:    mv a0, a2
; RV32XTHEADBS-NEXT:    bnez a6, .LBB86_2
; RV32XTHEADBS-NEXT:  # %bb.1:
; RV32XTHEADBS-NEXT:    mv a0, a4
; RV32XTHEADBS-NEXT:    mv a1, a5
; RV32XTHEADBS-NEXT:  .LBB86_2:
; RV32XTHEADBS-NEXT:    ret
  %1 = and i64 %a, 9223372036854775807
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_64_1_z_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_64_1_z_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    or a6, a0, a1
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    beqz a6, .LBB87_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB87_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_64_1_z_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    beqz a0, .LBB87_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:  .LBB87_2:
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    ret
  %1 = and i64 %a, 18446744073709551615
  %2 = icmp eq i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define i64 @bit_64_1_nz_select_i64(i64 %a, i64 %b, i64 %c) {
; RV32-LABEL: bit_64_1_nz_select_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    or a6, a0, a1
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a6, .LBB88_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB88_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_64_1_nz_select_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    bnez a0, .LBB88_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:  .LBB88_2:
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    ret
  %1 = and i64 %a, 18446744073709551615
  %2 = icmp ne i64 %1, 0
  %3 = select i1 %2, i64 %b, i64 %c
  ret i64 %3
}

define void @bit_10_1_z_branch_i32(i32 signext %0) {
; CHECK-LABEL: bit_10_1_z_branch_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1023
; CHECK-NEXT:    beqz a0, .LBB89_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB89_2:
; CHECK-NEXT:    tail bar@plt
  %2 = and i32 %0, 1023
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_10_1_nz_branch_i32(i32 signext %0) {
; CHECK-LABEL: bit_10_1_nz_branch_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1023
; CHECK-NEXT:    beqz a0, .LBB90_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    tail bar@plt
; CHECK-NEXT:  .LBB90_2:
; CHECK-NEXT:    ret
  %2 = and i32 %0, 1023
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_11_1_z_branch_i32(i32 signext %0) {
; CHECK-LABEL: bit_11_1_z_branch_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 2047
; CHECK-NEXT:    beqz a0, .LBB91_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB91_2:
; CHECK-NEXT:    tail bar@plt
  %2 = and i32 %0, 2047
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_11_1_nz_branch_i32(i32 signext %0) {
; CHECK-LABEL: bit_11_1_nz_branch_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 2047
; CHECK-NEXT:    beqz a0, .LBB92_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    tail bar@plt
; CHECK-NEXT:  .LBB92_2:
; CHECK-NEXT:    ret
  %2 = and i32 %0, 2047
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_16_1_z_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_16_1_z_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 16
; RV32-NEXT:    beqz a0, .LBB93_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB93_2:
; RV32-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_16_1_z_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 48
; RV64-NEXT:    beqz a0, .LBB93_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB93_2:
; RV64-NEXT:    tail bar@plt
  %2 = and i32 %0, 65535
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_16_1_nz_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_16_1_nz_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 16
; RV32-NEXT:    beqz a0, .LBB94_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB94_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_16_1_nz_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 48
; RV64-NEXT:    beqz a0, .LBB94_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB94_2:
; RV64-NEXT:    ret
  %2 = and i32 %0, 65535
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_24_1_z_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_24_1_z_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 8
; RV32-NEXT:    beqz a0, .LBB95_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB95_2:
; RV32-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_24_1_z_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    beqz a0, .LBB95_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB95_2:
; RV64-NEXT:    tail bar@plt
  %2 = and i32 %0, 16777215
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_24_1_nz_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_24_1_nz_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 8
; RV32-NEXT:    beqz a0, .LBB96_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB96_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_24_1_nz_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    beqz a0, .LBB96_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB96_2:
; RV64-NEXT:    ret
  %2 = and i32 %0, 16777215
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_31_1_z_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_31_1_z_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    beqz a0, .LBB97_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB97_2:
; RV32-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_31_1_z_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 33
; RV64-NEXT:    beqz a0, .LBB97_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB97_2:
; RV64-NEXT:    tail bar@plt
  %2 = and i32 %0, 2147483647
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_31_1_nz_branch_i32(i32 signext %0) {
; RV32-LABEL: bit_31_1_nz_branch_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    beqz a0, .LBB98_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB98_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_1_nz_branch_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 33
; RV64-NEXT:    beqz a0, .LBB98_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB98_2:
; RV64-NEXT:    ret
  %2 = and i32 %0, 2147483647
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_32_1_z_branch_i32(i32 signext %0) {
; CHECK-LABEL: bit_32_1_z_branch_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    beqz a0, .LBB99_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB99_2:
; CHECK-NEXT:    tail bar@plt
  %2 = and i32 %0, 4294967295
  %3 = icmp eq i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_32_1_nz_branch_i32(i32 signext %0) {
; CHECK-LABEL: bit_32_1_nz_branch_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    beqz a0, .LBB100_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    tail bar@plt
; CHECK-NEXT:  .LBB100_2:
; CHECK-NEXT:    ret
  %2 = and i32 %0, 4294967295
  %3 = icmp ne i32 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}


define void @bit_10_1_z_branch_i64(i64 %0) {
; CHECK-LABEL: bit_10_1_z_branch_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1023
; CHECK-NEXT:    beqz a0, .LBB101_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB101_2:
; CHECK-NEXT:    tail bar@plt
  %2 = and i64 %0, 1023
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_10_1_nz_branch_i64(i64 %0) {
; CHECK-LABEL: bit_10_1_nz_branch_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1023
; CHECK-NEXT:    beqz a0, .LBB102_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    tail bar@plt
; CHECK-NEXT:  .LBB102_2:
; CHECK-NEXT:    ret
  %2 = and i64 %0, 1023
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_11_1_z_branch_i64(i64 %0) {
; CHECK-LABEL: bit_11_1_z_branch_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 2047
; CHECK-NEXT:    beqz a0, .LBB103_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB103_2:
; CHECK-NEXT:    tail bar@plt
  %2 = and i64 %0, 2047
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_11_1_nz_branch_i64(i64 %0) {
; CHECK-LABEL: bit_11_1_nz_branch_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 2047
; CHECK-NEXT:    beqz a0, .LBB104_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    tail bar@plt
; CHECK-NEXT:  .LBB104_2:
; CHECK-NEXT:    ret
  %2 = and i64 %0, 2047
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_16_1_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_16_1_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 16
; RV32-NEXT:    beqz a0, .LBB105_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB105_2:
; RV32-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_16_1_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 48
; RV64-NEXT:    beqz a0, .LBB105_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB105_2:
; RV64-NEXT:    tail bar@plt
  %2 = and i64 %0, 65535
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_16_1_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_16_1_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 16
; RV32-NEXT:    beqz a0, .LBB106_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB106_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_16_1_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 48
; RV64-NEXT:    beqz a0, .LBB106_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB106_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 65535
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_24_1_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_24_1_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 8
; RV32-NEXT:    beqz a0, .LBB107_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB107_2:
; RV32-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_24_1_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    beqz a0, .LBB107_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB107_2:
; RV64-NEXT:    tail bar@plt
  %2 = and i64 %0, 16777215
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_24_1_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_24_1_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 8
; RV32-NEXT:    beqz a0, .LBB108_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB108_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_24_1_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    beqz a0, .LBB108_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB108_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 16777215
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_31_1_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_31_1_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    beqz a0, .LBB109_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB109_2:
; RV32-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_31_1_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 33
; RV64-NEXT:    beqz a0, .LBB109_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB109_2:
; RV64-NEXT:    tail bar@plt
  %2 = and i64 %0, 2147483647
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_31_1_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_31_1_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    beqz a0, .LBB110_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB110_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_31_1_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 33
; RV64-NEXT:    beqz a0, .LBB110_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB110_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 2147483647
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_32_1_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_32_1_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    beqz a0, .LBB111_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB111_2:
; RV32-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_32_1_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    sext.w a0, a0
; RV64-NEXT:    beqz a0, .LBB111_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB111_2:
; RV64-NEXT:    tail bar@plt
  %2 = and i64 %0, 4294967295
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_32_1_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_32_1_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    beqz a0, .LBB112_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB112_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_32_1_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    sext.w a0, a0
; RV64-NEXT:    beqz a0, .LBB112_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB112_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 4294967295
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_62_1_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_62_1_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a1, a1, 2
; RV32-NEXT:    srli a1, a1, 2
; RV32-NEXT:    or a0, a0, a1
; RV32-NEXT:    beqz a0, .LBB113_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB113_2:
; RV32-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_62_1_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 2
; RV64-NEXT:    beqz a0, .LBB113_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB113_2:
; RV64-NEXT:    tail bar@plt
  %2 = and i64 %0, 4611686018427387903
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_62_1_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_62_1_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a1, a1, 2
; RV32-NEXT:    srli a1, a1, 2
; RV32-NEXT:    or a0, a0, a1
; RV32-NEXT:    beqz a0, .LBB114_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB114_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_62_1_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 2
; RV64-NEXT:    beqz a0, .LBB114_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB114_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 4611686018427387903
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_63_1_z_branch_i64(i64 %0) {
; RV32I-LABEL: bit_63_1_z_branch_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    beqz a0, .LBB115_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB115_2:
; RV32I-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_63_1_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 1
; RV64-NEXT:    beqz a0, .LBB115_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB115_2:
; RV64-NEXT:    tail bar@plt
;
; RV32ZBS-LABEL: bit_63_1_z_branch_i64:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    bclri a1, a1, 31
; RV32ZBS-NEXT:    or a0, a0, a1
; RV32ZBS-NEXT:    beqz a0, .LBB115_2
; RV32ZBS-NEXT:  # %bb.1:
; RV32ZBS-NEXT:    ret
; RV32ZBS-NEXT:  .LBB115_2:
; RV32ZBS-NEXT:    tail bar@plt
;
; RV32XTHEADBS-LABEL: bit_63_1_z_branch_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    slli a1, a1, 1
; RV32XTHEADBS-NEXT:    srli a1, a1, 1
; RV32XTHEADBS-NEXT:    or a0, a0, a1
; RV32XTHEADBS-NEXT:    beqz a0, .LBB115_2
; RV32XTHEADBS-NEXT:  # %bb.1:
; RV32XTHEADBS-NEXT:    ret
; RV32XTHEADBS-NEXT:  .LBB115_2:
; RV32XTHEADBS-NEXT:    tail bar@plt
  %2 = and i64 %0, 9223372036854775807
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_63_1_nz_branch_i64(i64 %0) {
; RV32I-LABEL: bit_63_1_nz_branch_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    beqz a0, .LBB116_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    tail bar@plt
; RV32I-NEXT:  .LBB116_2:
; RV32I-NEXT:    ret
;
; RV64-LABEL: bit_63_1_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 1
; RV64-NEXT:    beqz a0, .LBB116_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB116_2:
; RV64-NEXT:    ret
;
; RV32ZBS-LABEL: bit_63_1_nz_branch_i64:
; RV32ZBS:       # %bb.0:
; RV32ZBS-NEXT:    bclri a1, a1, 31
; RV32ZBS-NEXT:    or a0, a0, a1
; RV32ZBS-NEXT:    beqz a0, .LBB116_2
; RV32ZBS-NEXT:  # %bb.1:
; RV32ZBS-NEXT:    tail bar@plt
; RV32ZBS-NEXT:  .LBB116_2:
; RV32ZBS-NEXT:    ret
;
; RV32XTHEADBS-LABEL: bit_63_1_nz_branch_i64:
; RV32XTHEADBS:       # %bb.0:
; RV32XTHEADBS-NEXT:    slli a1, a1, 1
; RV32XTHEADBS-NEXT:    srli a1, a1, 1
; RV32XTHEADBS-NEXT:    or a0, a0, a1
; RV32XTHEADBS-NEXT:    beqz a0, .LBB116_2
; RV32XTHEADBS-NEXT:  # %bb.1:
; RV32XTHEADBS-NEXT:    tail bar@plt
; RV32XTHEADBS-NEXT:  .LBB116_2:
; RV32XTHEADBS-NEXT:    ret
  %2 = and i64 %0, 9223372036854775807
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_64_1_z_branch_i64(i64 %0) {
; RV32-LABEL: bit_64_1_z_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    or a0, a0, a1
; RV32-NEXT:    beqz a0, .LBB117_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB117_2:
; RV32-NEXT:    tail bar@plt
;
; RV64-LABEL: bit_64_1_z_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    beqz a0, .LBB117_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB117_2:
; RV64-NEXT:    tail bar@plt
  %2 = and i64 %0, 18446744073709551615
  %3 = icmp eq i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

define void @bit_64_1_nz_branch_i64(i64 %0) {
; RV32-LABEL: bit_64_1_nz_branch_i64:
; RV32:       # %bb.0:
; RV32-NEXT:    or a0, a0, a1
; RV32-NEXT:    beqz a0, .LBB118_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    tail bar@plt
; RV32-NEXT:  .LBB118_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bit_64_1_nz_branch_i64:
; RV64:       # %bb.0:
; RV64-NEXT:    beqz a0, .LBB118_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    tail bar@plt
; RV64-NEXT:  .LBB118_2:
; RV64-NEXT:    ret
  %2 = and i64 %0, 18446744073709551615
  %3 = icmp ne i64 %2, 0
  br i1 %3, label %4, label %5

4:
  tail call void @bar()
  br label %5

5:
  ret void
}

