; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -select-optimize -mtriple=aarch64-linux-gnu -mcpu=generic -S < %s | FileCheck %s --check-prefix=CHECK-GENERIC
; RUN: opt -select-optimize -mtriple=aarch64-linux-gnu -mcpu=neoverse-n1 -S < %s | FileCheck %s
; RUN: opt -select-optimize -mtriple=aarch64-linux-gnu -mcpu=neoverse-v2 -S < %s | FileCheck %s
; RUN: opt -select-optimize -mtriple=aarch64-linux-gnu -mcpu=cortex-a72 -S < %s | FileCheck %s

; Test has not predictable select, which should not be transformed to a branch
define i32 @test1(i32 %a) {
; CHECK-GENERIC-LABEL: @test1(
; CHECK-GENERIC-NEXT:  entry:
; CHECK-GENERIC-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A:%.*]], 1
; CHECK-GENERIC-NEXT:    [[DEC:%.*]] = sub i32 [[A]], 1
; CHECK-GENERIC-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i32 0, i32 [[DEC]], !prof [[PROF0:![0-9]+]]
; CHECK-GENERIC-NEXT:    ret i32 [[RES]]
;
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A:%.*]], 1
; CHECK-NEXT:    [[DEC:%.*]] = sub i32 [[A]], 1
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i32 0, i32 [[DEC]], !prof [[PROF0:![0-9]+]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %cmp = icmp slt i32 %a, 1
  %dec = sub i32 %a, 1
  %res = select i1 %cmp, i32 0, i32 %dec, !prof !0
  ret i32 %res
}

; Test has highly predictable select according to profile data,
; which should be transformed to a branch on cores with enabled FeaturePredictableSelectIsExpensive
define i32 @test2(i32 %a) {
; CHECK-GENERIC-LABEL: @test2(
; CHECK-GENERIC-NEXT:  entry:
; CHECK-GENERIC-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A:%.*]], 1
; CHECK-GENERIC-NEXT:    [[DEC:%.*]] = sub i32 [[A]], 1
; CHECK-GENERIC-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i32 0, i32 [[DEC]], !prof [[PROF1:![0-9]+]]
; CHECK-GENERIC-NEXT:    ret i32 [[RES]]
;
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[A:%.*]], 1
; CHECK-NEXT:    [[RES_FROZEN:%.*]] = freeze i1 [[CMP]]
; CHECK-NEXT:    br i1 [[RES_FROZEN]], label [[SELECT_END:%.*]], label [[SELECT_FALSE_SINK:%.*]], !prof [[PROF1:![0-9]+]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[DEC:%.*]] = sub i32 [[A]], 1
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[DEC]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %cmp = icmp slt i32 %a, 1
  %dec = sub i32 %a, 1
  %res = select i1 %cmp, i32 0, i32 %dec, !prof !1
  ret i32 %res
}

!0 = !{!"branch_weights", i32 1, i32 1}
!1 = !{!"branch_weights", i32 1, i32 1000}
