/* Generated by re2c 0.13.5 */
/*
  +----------------------------------------------------------------------+
  | phar php single-file executable PHP extension                        |
  +----------------------------------------------------------------------+
  | Copyright (c) The PHP Group                                          |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt.                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Marcus Boerger <helly@php.net>                              |
  +----------------------------------------------------------------------+
*/

#include "phar_internal.h"

phar_path_check_result phar_path_check(char **s, size_t *len, const char **error)
{
	const unsigned char *p = (const unsigned char*)*s;
	const unsigned char *m;

	if (*len == 1 && *p == '.') {
		*error = "current directory reference";
		return pcr_err_curr_dir;
	} else if (*len == 2 && p[0] == '.' && p[1] == '.') {
		*error = "upper directory reference";
		return pcr_err_up_dir;
	}

#define YYCTYPE         unsigned char
#define YYCURSOR        p
#define YYLIMIT         p+*len
#define YYMARKER        m
#define YYFILL(n)

loop:

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;

	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= '[') {
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy20;
				goto yy22;
			} else {
				if (yych <= '\r') goto yy23;
				if (yych <= 0x19) goto yy22;
				goto yy10;
			}
		} else {
			if (yych <= '/') {
				if (yych <= '*') goto yy6;
				if (yych <= '.') goto yy10;
			} else {
				if (yych == '?') goto yy8;
				goto yy10;
			}
		}
	} else {
		if (yych <= 0xEC) {
			if (yych <= 0xC1) {
				if (yych <= '\\') goto yy4;
				if (yych <= 0x7F) goto yy10;
				goto yy22;
			} else {
				if (yych <= 0xDF) goto yy11;
				if (yych <= 0xE0) goto yy13;
				goto yy14;
			}
		} else {
			if (yych <= 0xF0) {
				if (yych <= 0xED) goto yy15;
				if (yych <= 0xEF) goto yy16;
				goto yy17;
			} else {
				if (yych <= 0xF3) goto yy18;
				if (yych <= 0xF4) goto yy19;
				goto yy22;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') goto yy3;
	if (yych <= '.') goto yy36;
	if (yych <= '/') goto yy37;
yy3:
	{
			goto loop;
		}
yy4:
	++YYCURSOR;
	{
			*error = "back-slash";
			return pcr_err_back_slash;
		}
yy6:
	++YYCURSOR;
	{
			*error = "star";
			return pcr_err_star;
		}
yy8:
	++YYCURSOR;
	{
			if (**s == '/') {
				(*s)++;
			}
			*len = (p - (const unsigned char*)*s) -1;
			*error = NULL;
			return pcr_use_query;
		}
yy10:
	yych = *++YYCURSOR;
	goto yy3;
yy11:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 0x7F) goto yy12;
	if (yych <= 0xBF) goto yy27;
yy12:
	{
			*error ="illegal character";
			return pcr_err_illegal_char;
		}
yy13:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x9F) goto yy12;
	if (yych <= 0xBF) goto yy35;
	goto yy12;
yy14:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x7F) goto yy12;
	if (yych <= 0xBF) goto yy34;
	goto yy12;
yy15:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x7F) goto yy12;
	if (yych <= 0x9F) goto yy33;
	goto yy12;
yy16:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x7F) goto yy12;
	if (yych <= 0xBF) goto yy32;
	goto yy12;
yy17:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x8F) goto yy12;
	if (yych <= 0xBF) goto yy30;
	goto yy12;
yy18:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x7F) goto yy12;
	if (yych <= 0xBF) goto yy28;
	goto yy12;
yy19:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x7F) goto yy12;
	if (yych <= 0x8F) goto yy24;
	goto yy12;
yy20:
	++YYCURSOR;
	{
			if (**s == '/') {
				(*s)++;
				(*len)--;
			}
			if ((p - (const unsigned char*)*s) - 1 != *len)
			{
				*error ="illegal character";
				return pcr_err_illegal_char;
			}
			*error = NULL;
			return pcr_is_ok;
		}
yy22:
	yych = *++YYCURSOR;
	goto yy12;
yy23:
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy22;
	goto yy12;
yy24:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych <= 0xBF) goto yy26;
yy25:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 0) {
		goto yy3;
	} else {
		goto yy12;
	}
yy26:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych >= 0xC0) goto yy25;
yy27:
	yych = *++YYCURSOR;
	goto yy3;
yy28:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych >= 0xC0) goto yy25;
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych <= 0xBF) goto yy27;
	goto yy25;
yy30:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych >= 0xC0) goto yy25;
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych <= 0xBF) goto yy27;
	goto yy25;
yy32:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych <= 0xBF) goto yy27;
	goto yy25;
yy33:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych <= 0xBF) goto yy27;
	goto yy25;
yy34:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych <= 0xBF) goto yy27;
	goto yy25;
yy35:
	yych = *++YYCURSOR;
	if (yych <= 0x7F) goto yy25;
	if (yych <= 0xBF) goto yy27;
	goto yy25;
yy36:
	yych = *++YYCURSOR;
	if (yych <= 0x00) goto yy40;
	if (yych <= '-') goto yy25;
	if (yych <= '.') goto yy39;
	if (yych <= '/') goto yy40;
	goto yy25;
yy37:
	++YYCURSOR;
	{
			*error = "double slash";
			return pcr_err_double_slash;
		}
yy39:
	yych = *++YYCURSOR;
	if (yych <= 0x00) goto yy42;
	if (yych == '/') goto yy42;
	goto yy25;
yy40:
	++YYCURSOR;
	{
			*error = "current directory reference";
			return pcr_err_curr_dir;
		}
yy42:
	++YYCURSOR;
	{
			*error = "upper directory reference";
			return pcr_err_up_dir;
		}
}

}
