"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getReaderM = exports.fromNaturalTransformation = exports.fromReader = exports.chain = exports.ap = exports.map = exports.of = void 0;
var function_1 = require("./function");
function of(F) {
    return function (a) { return function () { return F.of(a); }; };
}
exports.of = of;
function map(F) {
    return function (f) { return function (fa) { return function (r) { return F.map(fa(r), f); }; }; };
}
exports.map = map;
function ap(F) {
    return function (fa) { return function (fab) { return function (r) { return F.ap(fab(r), fa(r)); }; }; };
}
exports.ap = ap;
function chain(M) {
    return function (f) { return function (ma) { return function (r) { return M.chain(ma(r), function (a) { return f(a)(r); }); }; }; };
}
exports.chain = chain;
function fromReader(F) {
    return function (ma) { return function_1.flow(ma, F.of); };
}
exports.fromReader = fromReader;
function fromNaturalTransformation(nt) {
    return function (f) { return function_1.flow(f, nt); };
}
exports.fromNaturalTransformation = fromNaturalTransformation;
/** @deprecated */
/* istanbul ignore next */
function getReaderM(M) {
    var _ap = ap(M);
    var _map = map(M);
    var _chain = chain(M);
    return {
        map: function (fa, f) { return function_1.pipe(fa, _map(f)); },
        ap: function (fab, fa) { return function_1.pipe(fab, _ap(fa)); },
        of: of(M),
        chain: function (ma, f) { return function_1.pipe(ma, _chain(f)); },
        ask: function () { return M.of; },
        asks: function (f) { return function_1.flow(f, M.of); },
        local: function (ma, f) { return function (q) { return ma(f(q)); }; },
        fromReader: fromReader(M),
        fromM: function (ma) { return function () { return ma; }; }
    };
}
exports.getReaderM = getReaderM;
