'use strict'
const onExit = require('signal-exit')
const path = require('path')
const fs = require('fs')
const process = require('process')
const binName = path.basename(require.main.filename, '.js')
const mainPath = path.resolve(require.main.paths[0], '..')

module.exports = function (entry) {
  let started = false
  let exited = false
  onExit((code, signal) => {
    if (started && !exited) {
      // tested, but exit mechanism can't collect coverage
      /* istanbul ignore next */
      if (signal) {
        /* istanbul ignore next */
        console.error('Abnormal exit:', signal)
      } else {
        console.error('Abnormal exit: Promises not resolved')
      }
      process.exit(code || 1)
    }
  })
  fs.readFile(mainPath + '/package.json', (err, data) => {
    try {
      const pkg = JSON.parse(data)
      const nameMatch = new RegExp(binName, 'i')
      let isInPackage = typeof pkg.bin === 'string'
        ? nameMatch.test(pkg.bin)
        : pkg.bin && Object.keys(pkg.bin).some(b => nameMatch.test(b) || nameMatch.test(pkg.bin[b]))
      if (isInPackage) {
        /* istanbul ignore next */
        if (global['NO_NOTIFIER']) throw new Error('NO NOTIFIER')
        const updateNotifier = require('update-notifier');
        updateNotifier({pkg: pkg}).notify()
      }
    } catch (ex) { /* don't care */ }
  })

  let haveYargs
  let yargs
  let opts
  let argv = process.argv.slice(2)
  if (process.platform === 'win32') {
    const glob = require('glob').sync
    const cwd = process.cwd()
    const statCache = {}
    const nonull = true
    const expandedArgs = []
    argv.forEach(_ => expandedArgs.push.apply(expandedArgs, glob(_, {cwd, statCache, nonull})))
    argv = expandedArgs
  }
  try {
    /* istanbul ignore next */
    if (global['NO_YARGS']) throw new Error('NO YARGS')
    yargs = require('yargs')(argv)
    haveYargs = true
  } catch (_) {
    opts = {_: argv}
    const noYargs = () => {
      throw new Error('Argument parsing is not available (could not find yargs), to install run: npm i yargs')
    }
    // only missing on v4, which has incomplete coverage anyway
    /* istanbul ignore next */
    yargs = global.Proxy && new global.Proxy({}, {
      getPrototypeOf: noYargs,
      setPrototypeOf: noYargs,
      isExtensible: noYargs,
      preventExtensions: noYargs,
      getOwnPropertyDescriptor: noYargs,
      defineProperty: noYargs,
      has: noYargs,
      get: noYargs,
      set: noYargs,
      deleteProperty: noYargs,
      ownKeys: noYargs,
      apply: noYargs,
      construct: noYargs
    })
  }
  setImmediate(() => {
    if (haveYargs) {
      opts = yargs.argv
      argv = opts._
    }
    started = true
    try {
      const appPromise = entry.apply(null, [opts].concat(argv))
      if (!appPromise || !appPromise.then) {
        return onError(new Error('Application entry point' + (entry.name ? ` (${entry.name})` : '') + ' did not return a promise.'))
      }
      appPromise.then(() => exited = true, onError)
    } catch (ex) {
      onError (ex)
    }
    function onError (err) {
      exited = true
      if (typeof err === 'number') {
        process.exit(err)
      } else if (err) {
        console.error((err && err.stack) ? err.stack : err)
      }
      process.exit(1)
    }
  })
  return yargs
}
