// Generated by CoffeeScript 2.5.1
var SpecialString, i, len, prop, ref;

module.exports = SpecialString = (function() {
  var self;

  class SpecialString {
    constructor(str) {
      if (!(this instanceof self)) {
        return new self(str);
      }
      this._str = String(str);
      this._len = 0;
    }

    _getStr() {
      return this._str;
    }

    set(str) {
      this._str = String(str);
      return this;
    }

    clone() {
      return new SpecialString(this._str);
    }

    isEmpty() {
      return this._str === '';
    }

    isOnlySpecialChars() {
      return !this.isEmpty() && this.length === 0;
    }

    _reset() {
      return this._len = 0;
    }

    splitIn(limit, trimLeftEachLine = false) {
      var buffer, bufferLength, justSkippedSkipChar, lines;
      buffer = '';
      bufferLength = 0;
      lines = [];
      justSkippedSkipChar = false;
      self._countChars(this._str, function(char, charLength) {
        if (bufferLength > limit || bufferLength + charLength > limit) {
          lines.push(buffer);
          buffer = '';
          bufferLength = 0;
        }
        if (bufferLength === 0 && char === ' ' && !justSkippedSkipChar && trimLeftEachLine) {
          return justSkippedSkipChar = true;
        } else {
          buffer += char;
          bufferLength += charLength;
          return justSkippedSkipChar = false;
        }
      });
      if (buffer.length > 0) {
        lines.push(buffer);
      }
      return lines;
    }

    trim() {
      return new SpecialString(this.str.trim());
    }

    trimLeft() {
      return new SpecialString(this.str.replace(/^\s+/, ''));
    }

    trimRight() {
      return new SpecialString(this.str.replace(/\s+$/, ''));
    }

    _getLength() {
      var sum;
      sum = 0;
      self._countChars(this._str, function(char, charLength) {
        sum += charLength;
      });
      return sum;
    }

    cut(from, to, trimLeft = false) {
      var after, before, cur, cut;
      if (to == null) {
        to = this.length;
      }
      from = parseInt(from);
      if (from >= to) {
        throw Error("`from` shouldn't be larger than `to`");
      }
      before = '';
      after = '';
      cut = '';
      cur = 0;
      self._countChars(this._str, (char, charLength) => {
        if (this.str === 'ab<tag>') {
          console.log(charLength, char);
        }
        if (cur === from && char.match(/^\s+$/) && trimLeft) {
          return;
        }
        if (cur < from) {
          before += char;
        // let's be greedy
        } else if (cur < to || cur + charLength <= to) {
          cut += char;
        } else {
          after += char;
        }
        cur += charLength;
      });
      this._str = before + after;
      this._reset();
      return new SpecialString(cut);
    }

    static _countChars(text, cb) {
      var char, charLength, m;
      while (text.length !== 0) {
        if (m = text.match(self._tagRx)) {
          char = m[0];
          charLength = 0;
          text = text.substr(char.length, text.length);
        } else if (m = text.match(self._quotedHtmlRx)) {
          char = m[0];
          charLength = 1;
          text = text.substr(char.length, text.length);
        } else if (text.match(self._tabRx)) {
          char = "\t";
          charLength = 8;
          text = text.substr(1, text.length);
        } else {
          char = text[0];
          charLength = 1;
          text = text.substr(1, text.length);
        }
        cb.call(null, char, charLength);
      }
    }

  };

  self = SpecialString;

  SpecialString._tabRx = /^\t/;

  SpecialString._tagRx = /^<[^>]+>/;

  SpecialString._quotedHtmlRx = /^&(gt|lt|quot|amp|apos|sp);/;

  return SpecialString;

}).call(this);

ref = ['str', 'length'];
for (i = 0, len = ref.length; i < len; i++) {
  prop = ref[i];
  (function() {
    var methodName;
    methodName = '_get' + prop[0].toUpperCase() + prop.substr(1, prop.length);
    return SpecialString.prototype.__defineGetter__(prop, function() {
      return this[methodName]();
    });
  })();
}
