/**
 * Remove all children of an element.
 * @param {HTMLElement} element A valid HTML element.
 * @param {number} [skip] Number of elements to skip removing.
 * @returns {void}
 */
function removeAllChildren(element, skip) {
  /** @type {Node[]} */
  const childList = Array.prototype.slice.call(
    element.childNodes,
    typeof skip !== 'undefined' ? skip : 0
  );

  for (let i = 0; i < childList.length; i += 1) {
    element.removeChild(childList[i]);
  }
}

module.exports = removeAllChildren;
