; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=riscv32 -mattr=+v -passes="print<cost-model>" -cost-kind=throughput 2>&1 -disable-output | FileCheck %s
; RUN: opt < %s -mtriple=riscv64 -mattr=+v -passes="print<cost-model>" -cost-kind=throughput 2>&1 -disable-output | FileCheck %s
; RUN: opt < %s -mtriple=riscv32 -mattr=+v -passes="print<cost-model>" -cost-kind=code-size 2>&1 -disable-output | FileCheck %s --check-prefix=SIZE
; RUN: opt < %s -mtriple=riscv64 -mattr=+v -passes="print<cost-model>" -cost-kind=code-size 2>&1 -disable-output | FileCheck %s --check-prefix=SIZE

declare i8 @llvm.vector.reduce.add.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_add_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vreduce_add_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i8 @llvm.vector.reduce.add.nxv1i8(<vscale x 1 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_add_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.add.nxv1i8(<vscale x 1 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.add.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_umax_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i8 @llvm.vector.reduce.umax.nxv1i8(<vscale x 1 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.umax.nxv1i8(<vscale x 1 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.umax.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_smax_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i8 @llvm.vector.reduce.smax.nxv1i8(<vscale x 1 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.smax.nxv1i8(<vscale x 1 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.smax.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_umin_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i8 @llvm.vector.reduce.umin.nxv1i8(<vscale x 1 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.umin.nxv1i8(<vscale x 1 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.umin.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_smin_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i8 @llvm.vector.reduce.smin.nxv1i8(<vscale x 1 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.smin.nxv1i8(<vscale x 1 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.smin.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_and_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vreduce_and_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i8 @llvm.vector.reduce.and.nxv1i8(<vscale x 1 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_and_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.and.nxv1i8(<vscale x 1 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.and.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_or_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vreduce_or_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i8 @llvm.vector.reduce.or.nxv1i8(<vscale x 1 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_or_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.or.nxv1i8(<vscale x 1 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.or.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.nxv1i8(<vscale x 1 x i8>)

define signext i8 @vreduce_xor_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i8 @llvm.vector.reduce.xor.nxv1i8(<vscale x 1 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.xor.nxv1i8(<vscale x 1 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.xor.nxv1i8(<vscale x 1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_add_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vreduce_add_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i8 @llvm.vector.reduce.add.nxv2i8(<vscale x 2 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_add_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.add.nxv2i8(<vscale x 2 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.add.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_umax_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i8 @llvm.vector.reduce.umax.nxv2i8(<vscale x 2 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.umax.nxv2i8(<vscale x 2 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.umax.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_smax_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i8 @llvm.vector.reduce.smax.nxv2i8(<vscale x 2 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.smax.nxv2i8(<vscale x 2 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.smax.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_umin_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i8 @llvm.vector.reduce.umin.nxv2i8(<vscale x 2 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.umin.nxv2i8(<vscale x 2 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.umin.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_smin_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i8 @llvm.vector.reduce.smin.nxv2i8(<vscale x 2 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.smin.nxv2i8(<vscale x 2 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.smin.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_and_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vreduce_and_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i8 @llvm.vector.reduce.and.nxv2i8(<vscale x 2 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_and_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.and.nxv2i8(<vscale x 2 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.and.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_or_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vreduce_or_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i8 @llvm.vector.reduce.or.nxv2i8(<vscale x 2 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_or_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.or.nxv2i8(<vscale x 2 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.or.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.nxv2i8(<vscale x 2 x i8>)

define signext i8 @vreduce_xor_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i8 @llvm.vector.reduce.xor.nxv2i8(<vscale x 2 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.xor.nxv2i8(<vscale x 2 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.xor.nxv2i8(<vscale x 2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_add_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vreduce_add_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i8 @llvm.vector.reduce.add.nxv4i8(<vscale x 4 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_add_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.add.nxv4i8(<vscale x 4 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.add.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_umax_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i8 @llvm.vector.reduce.umax.nxv4i8(<vscale x 4 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.umax.nxv4i8(<vscale x 4 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.umax.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_smax_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i8 @llvm.vector.reduce.smax.nxv4i8(<vscale x 4 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.smax.nxv4i8(<vscale x 4 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.smax.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_umin_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i8 @llvm.vector.reduce.umin.nxv4i8(<vscale x 4 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.umin.nxv4i8(<vscale x 4 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.umin.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_smin_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i8 @llvm.vector.reduce.smin.nxv4i8(<vscale x 4 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.smin.nxv4i8(<vscale x 4 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.smin.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_and_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vreduce_and_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i8 @llvm.vector.reduce.and.nxv4i8(<vscale x 4 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_and_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.and.nxv4i8(<vscale x 4 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.and.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_or_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vreduce_or_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i8 @llvm.vector.reduce.or.nxv4i8(<vscale x 4 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_or_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.or.nxv4i8(<vscale x 4 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.or.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.nxv4i8(<vscale x 4 x i8>)

define signext i8 @vreduce_xor_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i8 @llvm.vector.reduce.xor.nxv4i8(<vscale x 4 x i8> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i8 @llvm.vector.reduce.xor.nxv4i8(<vscale x 4 x i8> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %red
;
  %red = call i8 @llvm.vector.reduce.xor.nxv4i8(<vscale x 4 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_add_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vreduce_add_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_add_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

define signext i16 @vwreduce_add_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vwreduce_add_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 1 x i8> %v to <vscale x 1 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vwreduce_add_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 1 x i8> %v to <vscale x 1 x i16>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %e = sext <vscale x 1 x i8> %v to <vscale x 1 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %e)
  ret i16 %red
}

define signext i16 @vwreduce_uadd_nxv1i8(<vscale x 1 x i8> %v) {
; CHECK-LABEL: 'vwreduce_uadd_nxv1i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 1 x i8> %v to <vscale x 1 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vwreduce_uadd_nxv1i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 1 x i8> %v to <vscale x 1 x i16>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %e = sext <vscale x 1 x i8> %v to <vscale x 1 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv1i16(<vscale x 1 x i16> %e)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_umax_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.umax.nxv1i16(<vscale x 1 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.umax.nxv1i16(<vscale x 1 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.umax.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_smax_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.smax.nxv1i16(<vscale x 1 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.smax.nxv1i16(<vscale x 1 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.smax.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_umin_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.umin.nxv1i16(<vscale x 1 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.umin.nxv1i16(<vscale x 1 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.umin.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_smin_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.smin.nxv1i16(<vscale x 1 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.smin.nxv1i16(<vscale x 1 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.smin.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_and_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vreduce_and_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.and.nxv1i16(<vscale x 1 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_and_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.and.nxv1i16(<vscale x 1 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.and.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_or_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vreduce_or_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.or.nxv1i16(<vscale x 1 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_or_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.or.nxv1i16(<vscale x 1 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.or.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.nxv1i16(<vscale x 1 x i16>)

define signext i16 @vreduce_xor_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i16 @llvm.vector.reduce.xor.nxv1i16(<vscale x 1 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.xor.nxv1i16(<vscale x 1 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.xor.nxv1i16(<vscale x 1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_add_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vreduce_add_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_add_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

define signext i16 @vwreduce_add_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vwreduce_add_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 2 x i8> %v to <vscale x 2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vwreduce_add_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 2 x i8> %v to <vscale x 2 x i16>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %e = sext <vscale x 2 x i8> %v to <vscale x 2 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %e)
  ret i16 %red
}

define signext i16 @vwreduce_uadd_nxv2i8(<vscale x 2 x i8> %v) {
; CHECK-LABEL: 'vwreduce_uadd_nxv2i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 2 x i8> %v to <vscale x 2 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vwreduce_uadd_nxv2i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 2 x i8> %v to <vscale x 2 x i16>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %e = sext <vscale x 2 x i8> %v to <vscale x 2 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv2i16(<vscale x 2 x i16> %e)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_umax_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.umax.nxv2i16(<vscale x 2 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.umax.nxv2i16(<vscale x 2 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.umax.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_smax_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.smax.nxv2i16(<vscale x 2 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.smax.nxv2i16(<vscale x 2 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.smax.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_umin_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.umin.nxv2i16(<vscale x 2 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.umin.nxv2i16(<vscale x 2 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.umin.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_smin_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.smin.nxv2i16(<vscale x 2 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.smin.nxv2i16(<vscale x 2 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.smin.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_and_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vreduce_and_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.and.nxv2i16(<vscale x 2 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_and_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.and.nxv2i16(<vscale x 2 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.and.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_or_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vreduce_or_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.or.nxv2i16(<vscale x 2 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_or_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.or.nxv2i16(<vscale x 2 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.or.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.nxv2i16(<vscale x 2 x i16>)

define signext i16 @vreduce_xor_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i16 @llvm.vector.reduce.xor.nxv2i16(<vscale x 2 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.xor.nxv2i16(<vscale x 2 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.xor.nxv2i16(<vscale x 2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_add_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vreduce_add_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_add_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

define signext i16 @vwreduce_add_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vwreduce_add_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 4 x i8> %v to <vscale x 4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vwreduce_add_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 4 x i8> %v to <vscale x 4 x i16>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %e = sext <vscale x 4 x i8> %v to <vscale x 4 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %e)
  ret i16 %red
}

define signext i16 @vwreduce_uadd_nxv4i8(<vscale x 4 x i8> %v) {
; CHECK-LABEL: 'vwreduce_uadd_nxv4i8'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 4 x i8> %v to <vscale x 4 x i16>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vwreduce_uadd_nxv4i8'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 4 x i8> %v to <vscale x 4 x i16>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %e = sext <vscale x 4 x i8> %v to <vscale x 4 x i16>
  %red = call i16 @llvm.vector.reduce.add.nxv4i16(<vscale x 4 x i16> %e)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_umax_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.umax.nxv4i16(<vscale x 4 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.umax.nxv4i16(<vscale x 4 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.umax.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_smax_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.smax.nxv4i16(<vscale x 4 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.smax.nxv4i16(<vscale x 4 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.smax.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_umin_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.umin.nxv4i16(<vscale x 4 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.umin.nxv4i16(<vscale x 4 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.umin.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_smin_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.smin.nxv4i16(<vscale x 4 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.smin.nxv4i16(<vscale x 4 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.smin.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_and_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vreduce_and_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.and.nxv4i16(<vscale x 4 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_and_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.and.nxv4i16(<vscale x 4 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.and.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_or_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vreduce_or_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.or.nxv4i16(<vscale x 4 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_or_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.or.nxv4i16(<vscale x 4 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.or.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.nxv4i16(<vscale x 4 x i16>)

define signext i16 @vreduce_xor_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i16 @llvm.vector.reduce.xor.nxv4i16(<vscale x 4 x i16> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i16 @llvm.vector.reduce.xor.nxv4i16(<vscale x 4 x i16> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %red
;
  %red = call i16 @llvm.vector.reduce.xor.nxv4i16(<vscale x 4 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_add_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vreduce_add_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_add_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

define signext i32 @vwreduce_add_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vwreduce_add_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 1 x i16> %v to <vscale x 1 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vwreduce_add_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 1 x i16> %v to <vscale x 1 x i32>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %e = sext <vscale x 1 x i16> %v to <vscale x 1 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %e)
  ret i32 %red
}

define signext i32 @vwreduce_uadd_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: 'vwreduce_uadd_nxv1i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 1 x i16> %v to <vscale x 1 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vwreduce_uadd_nxv1i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 1 x i16> %v to <vscale x 1 x i32>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %e = zext <vscale x 1 x i16> %v to <vscale x 1 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv1i32(<vscale x 1 x i32> %e)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_umax_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.umax.nxv1i32(<vscale x 1 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.umax.nxv1i32(<vscale x 1 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.umax.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_smax_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.smax.nxv1i32(<vscale x 1 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.smax.nxv1i32(<vscale x 1 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.smax.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_umin_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.umin.nxv1i32(<vscale x 1 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.umin.nxv1i32(<vscale x 1 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.umin.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_smin_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.smin.nxv1i32(<vscale x 1 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.smin.nxv1i32(<vscale x 1 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.smin.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_and_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vreduce_and_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.and.nxv1i32(<vscale x 1 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_and_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.and.nxv1i32(<vscale x 1 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.and.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_or_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vreduce_or_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.or.nxv1i32(<vscale x 1 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_or_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.or.nxv1i32(<vscale x 1 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.or.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.nxv1i32(<vscale x 1 x i32>)

define signext i32 @vreduce_xor_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i32 @llvm.vector.reduce.xor.nxv1i32(<vscale x 1 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.xor.nxv1i32(<vscale x 1 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.xor.nxv1i32(<vscale x 1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_add_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vreduce_add_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_add_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

define signext i32 @vwreduce_add_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vwreduce_add_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 2 x i16> %v to <vscale x 2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vwreduce_add_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 2 x i16> %v to <vscale x 2 x i32>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %e = sext <vscale x 2 x i16> %v to <vscale x 2 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %e)
  ret i32 %red
}

define signext i32 @vwreduce_uadd_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: 'vwreduce_uadd_nxv2i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 2 x i16> %v to <vscale x 2 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vwreduce_uadd_nxv2i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 2 x i16> %v to <vscale x 2 x i32>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %e = zext <vscale x 2 x i16> %v to <vscale x 2 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv2i32(<vscale x 2 x i32> %e)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_umax_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.umax.nxv2i32(<vscale x 2 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.umax.nxv2i32(<vscale x 2 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.umax.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_smax_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.smax.nxv2i32(<vscale x 2 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.smax.nxv2i32(<vscale x 2 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.smax.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_umin_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.umin.nxv2i32(<vscale x 2 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.umin.nxv2i32(<vscale x 2 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.umin.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_smin_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.smin.nxv2i32(<vscale x 2 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.smin.nxv2i32(<vscale x 2 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.smin.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_and_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vreduce_and_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.and.nxv2i32(<vscale x 2 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_and_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.and.nxv2i32(<vscale x 2 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.and.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_or_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vreduce_or_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.or.nxv2i32(<vscale x 2 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_or_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.or.nxv2i32(<vscale x 2 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.or.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.nxv2i32(<vscale x 2 x i32>)

define signext i32 @vreduce_xor_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i32 @llvm.vector.reduce.xor.nxv2i32(<vscale x 2 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.xor.nxv2i32(<vscale x 2 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.xor.nxv2i32(<vscale x 2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_add_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vreduce_add_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_add_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

define signext i32 @vwreduce_add_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vwreduce_add_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 4 x i16> %v to <vscale x 4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vwreduce_add_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 4 x i16> %v to <vscale x 4 x i32>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %e = sext <vscale x 4 x i16> %v to <vscale x 4 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %e)
  ret i32 %red
}

define signext i32 @vwreduce_uadd_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: 'vwreduce_uadd_nxv4i16'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 4 x i16> %v to <vscale x 4 x i32>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vwreduce_uadd_nxv4i16'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 4 x i16> %v to <vscale x 4 x i32>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %e = zext <vscale x 4 x i16> %v to <vscale x 4 x i32>
  %red = call i32 @llvm.vector.reduce.add.nxv4i32(<vscale x 4 x i32> %e)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_umax_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.umax.nxv4i32(<vscale x 4 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.umax.nxv4i32(<vscale x 4 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.umax.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_smax_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.smax.nxv4i32(<vscale x 4 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.smax.nxv4i32(<vscale x 4 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.smax.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_umin_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.umin.nxv4i32(<vscale x 4 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.umin.nxv4i32(<vscale x 4 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.umin.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_smin_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.smin.nxv4i32(<vscale x 4 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.smin.nxv4i32(<vscale x 4 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.smin.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_and_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vreduce_and_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.and.nxv4i32(<vscale x 4 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_and_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.and.nxv4i32(<vscale x 4 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.and.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_or_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vreduce_or_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.or.nxv4i32(<vscale x 4 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_or_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.or.nxv4i32(<vscale x 4 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.or.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.nxv4i32(<vscale x 4 x i32>)

define signext i32 @vreduce_xor_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i32 @llvm.vector.reduce.xor.nxv4i32(<vscale x 4 x i32> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i32 @llvm.vector.reduce.xor.nxv4i32(<vscale x 4 x i32> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %red
;
  %red = call i32 @llvm.vector.reduce.xor.nxv4i32(<vscale x 4 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_add_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: 'vreduce_add_nxv1i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_add_nxv1i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

define i64 @vwreduce_add_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vwreduce_add_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 1 x i32> %v to <vscale x 1 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vwreduce_add_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 1 x i32> %v to <vscale x 1 x i64>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %e = sext <vscale x 1 x i32> %v to <vscale x 1 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %e)
  ret i64 %red
}

define i64 @vwreduce_uadd_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: 'vwreduce_uadd_nxv1i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 1 x i32> %v to <vscale x 1 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vwreduce_uadd_nxv1i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 1 x i32> %v to <vscale x 1 x i64>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %e = zext <vscale x 1 x i32> %v to <vscale x 1 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv1i64(<vscale x 1 x i64> %e)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_umax_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv1i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.umax.nxv1i64(<vscale x 1 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv1i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.umax.nxv1i64(<vscale x 1 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.umax.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_smax_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv1i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.smax.nxv1i64(<vscale x 1 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv1i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.smax.nxv1i64(<vscale x 1 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.smax.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_umin_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv1i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.umin.nxv1i64(<vscale x 1 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv1i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.umin.nxv1i64(<vscale x 1 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.umin.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_smin_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv1i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.smin.nxv1i64(<vscale x 1 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv1i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.smin.nxv1i64(<vscale x 1 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.smin.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_and_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: 'vreduce_and_nxv1i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.and.nxv1i64(<vscale x 1 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_and_nxv1i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.and.nxv1i64(<vscale x 1 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.and.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_or_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: 'vreduce_or_nxv1i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.or.nxv1i64(<vscale x 1 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_or_nxv1i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.or.nxv1i64(<vscale x 1 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.or.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.nxv1i64(<vscale x 1 x i64>)

define i64 @vreduce_xor_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv1i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %red = call i64 @llvm.vector.reduce.xor.nxv1i64(<vscale x 1 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv1i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.xor.nxv1i64(<vscale x 1 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.xor.nxv1i64(<vscale x 1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_add_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: 'vreduce_add_nxv2i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_add_nxv2i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

define i64 @vwreduce_add_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vwreduce_add_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 2 x i32> %v to <vscale x 2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vwreduce_add_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 2 x i32> %v to <vscale x 2 x i64>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %e = sext <vscale x 2 x i32> %v to <vscale x 2 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %e)
  ret i64 %red
}

define i64 @vwreduce_uadd_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: 'vwreduce_uadd_nxv2i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 2 x i32> %v to <vscale x 2 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vwreduce_uadd_nxv2i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 2 x i32> %v to <vscale x 2 x i64>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %e = zext <vscale x 2 x i32> %v to <vscale x 2 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv2i64(<vscale x 2 x i64> %e)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_umax_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv2i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.umax.nxv2i64(<vscale x 2 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv2i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.umax.nxv2i64(<vscale x 2 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.umax.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_smax_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv2i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.smax.nxv2i64(<vscale x 2 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv2i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.smax.nxv2i64(<vscale x 2 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.smax.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_umin_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv2i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.umin.nxv2i64(<vscale x 2 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv2i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.umin.nxv2i64(<vscale x 2 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.umin.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_smin_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv2i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.smin.nxv2i64(<vscale x 2 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv2i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.smin.nxv2i64(<vscale x 2 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.smin.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_and_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: 'vreduce_and_nxv2i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.and.nxv2i64(<vscale x 2 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_and_nxv2i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.and.nxv2i64(<vscale x 2 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.and.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_or_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: 'vreduce_or_nxv2i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.or.nxv2i64(<vscale x 2 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_or_nxv2i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.or.nxv2i64(<vscale x 2 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.or.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.nxv2i64(<vscale x 2 x i64>)

define i64 @vreduce_xor_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv2i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %red = call i64 @llvm.vector.reduce.xor.nxv2i64(<vscale x 2 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv2i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.xor.nxv2i64(<vscale x 2 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.xor.nxv2i64(<vscale x 2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_add_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: 'vreduce_add_nxv4i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_add_nxv4i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

define i64 @vwreduce_add_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vwreduce_add_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 4 x i32> %v to <vscale x 4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vwreduce_add_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = sext <vscale x 4 x i32> %v to <vscale x 4 x i64>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %e = sext <vscale x 4 x i32> %v to <vscale x 4 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %e)
  ret i64 %red
}

define i64 @vwreduce_uadd_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: 'vwreduce_uadd_nxv4i32'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 4 x i32> %v to <vscale x 4 x i64>
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %e)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vwreduce_uadd_nxv4i32'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %e = zext <vscale x 4 x i32> %v to <vscale x 4 x i64>
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %e)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %e = zext <vscale x 4 x i32> %v to <vscale x 4 x i64>
  %red = call i64 @llvm.vector.reduce.add.nxv4i64(<vscale x 4 x i64> %e)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_umax_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: 'vreduce_umax_nxv4i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.umax.nxv4i64(<vscale x 4 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_umax_nxv4i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.umax.nxv4i64(<vscale x 4 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.umax.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_smax_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: 'vreduce_smax_nxv4i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.smax.nxv4i64(<vscale x 4 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_smax_nxv4i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.smax.nxv4i64(<vscale x 4 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.smax.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_umin_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: 'vreduce_umin_nxv4i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.umin.nxv4i64(<vscale x 4 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_umin_nxv4i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.umin.nxv4i64(<vscale x 4 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.umin.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_smin_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: 'vreduce_smin_nxv4i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.smin.nxv4i64(<vscale x 4 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_smin_nxv4i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.smin.nxv4i64(<vscale x 4 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.smin.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_and_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: 'vreduce_and_nxv4i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.and.nxv4i64(<vscale x 4 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_and_nxv4i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.and.nxv4i64(<vscale x 4 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.and.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_or_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: 'vreduce_or_nxv4i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.or.nxv4i64(<vscale x 4 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_or_nxv4i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.or.nxv4i64(<vscale x 4 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.or.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.nxv4i64(<vscale x 4 x i64>)

define i64 @vreduce_xor_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: 'vreduce_xor_nxv4i64'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %red = call i64 @llvm.vector.reduce.xor.nxv4i64(<vscale x 4 x i64> %v)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
; SIZE-LABEL: 'vreduce_xor_nxv4i64'
; SIZE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %red = call i64 @llvm.vector.reduce.xor.nxv4i64(<vscale x 4 x i64> %v)
; SIZE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %red
;
  %red = call i64 @llvm.vector.reduce.xor.nxv4i64(<vscale x 4 x i64> %v)
  ret i64 %red
}
