declare type ObjectLike<T = any> = Record<string, T>;
/**
 * Check if the variable contains an object stricly rejecting arrays
 * @param obj an object
 * @returns `true` if obj is an object
 */
export declare function isObjectNotArray<T extends object>(obj: T | any[]): obj is T;
/**
 * Pure function - doesn't mutate either parameter!
 * Merges two objects together deeply, overwriting the properties in first with the properties in second
 * @param first The first object
 * @param second The second object
 * @returns a new object
 */
export declare function deepMerge(first?: ObjectLike, second?: ObjectLike): Record<string, any>;
export {};
//# sourceMappingURL=deepMerge.d.ts.map