; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -mattr=+simd128,+sign-ext | FileCheck %s --check-prefix=SIMD128
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers | FileCheck %s --check-prefix=NO-SIMD128

; Test that basic SIMD128 vector manipulation operations assemble as expected.

target triple = "wasm32-unknown-unknown"

; ==============================================================================
; 16 x i8
; ==============================================================================
define <16 x i8> @const_v16i8() {
; SIMD128-LABEL: const_v16i8:
; SIMD128:         .functype const_v16i8 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_v16i8:
; NO-SIMD128:         .functype const_v16i8 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 1084818905618843912
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 506097522914230528
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <16 x i8> <i8 00, i8 01, i8 02, i8 03, i8 04, i8 05, i8 06, i8 07,
                 i8 08, i8 09, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15>
}

define <16 x i8> @splat_v16i8(i8 %x) {
; SIMD128-LABEL: splat_v16i8:
; SIMD128:         .functype splat_v16i8 (i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.splat $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: splat_v16i8:
; NO-SIMD128:         .functype splat_v16i8 (i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store8 8($0), $1
; NO-SIMD128-NEXT:    i32.store8 4($0), $1
; NO-SIMD128-NEXT:    i32.store8 2($0), $1
; NO-SIMD128-NEXT:    i32.store8 1($0), $1
; NO-SIMD128-NEXT:    i32.store8 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store8 0($pop1), $1
; NO-SIMD128-NEXT:    i32.const $push2=, 14
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store8 0($pop3), $1
; NO-SIMD128-NEXT:    i32.const $push4=, 13
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store8 0($pop5), $1
; NO-SIMD128-NEXT:    i32.const $push6=, 12
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $1
; NO-SIMD128-NEXT:    i32.const $push8=, 11
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.store8 0($pop9), $1
; NO-SIMD128-NEXT:    i32.const $push10=, 10
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $1
; NO-SIMD128-NEXT:    i32.const $push12=, 9
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $1
; NO-SIMD128-NEXT:    i32.const $push14=, 7
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.store8 0($pop15), $1
; NO-SIMD128-NEXT:    i32.const $push16=, 6
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $1
; NO-SIMD128-NEXT:    i32.const $push18=, 5
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $1
; NO-SIMD128-NEXT:    i32.const $push20=, 3
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.store8 0($pop21), $1
; NO-SIMD128-NEXT:    return
  %v = insertelement <16 x i8> undef, i8 %x, i32 0
  %res = shufflevector <16 x i8> %v, <16 x i8> undef,
    <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0,
                i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <16 x i8> %res
}

define <16 x i8> @const_splat_v16i8() {
; SIMD128-LABEL: const_splat_v16i8:
; SIMD128:         .functype const_splat_v16i8 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_splat_v16i8:
; NO-SIMD128:         .functype const_splat_v16i8 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 3038287259199220266
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 3038287259199220266
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <16 x i8> <i8 42, i8 42, i8 42, i8 42, i8 42, i8 42, i8 42, i8 42,
                 i8 42, i8 42, i8 42, i8 42, i8 42, i8 42, i8 42, i8 42>
}

define i32 @extract_v16i8_s(<16 x i8> %v) {
; SIMD128-LABEL: extract_v16i8_s:
; SIMD128:         .functype extract_v16i8_s (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_s $push0=, $0, 13
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v16i8_s:
; NO-SIMD128:         .functype extract_v16i8_s (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $13
; NO-SIMD128-NEXT:    return $pop0
  %elem = extractelement <16 x i8> %v, i8 13
  %a = sext i8 %elem to i32
  ret i32 %a
}

define i32 @extract_var_v16i8_s(<16 x i8> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v16i8_s:
; SIMD128:         .functype extract_var_v16i8_s (v128, i32) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push4=, __stack_pointer
; SIMD128-NEXT:    i32.const $push5=, 16
; SIMD128-NEXT:    i32.sub $push7=, $pop4, $pop5
; SIMD128-NEXT:    local.tee $push6=, $2=, $pop7
; SIMD128-NEXT:    v128.store 0($pop6), $0
; SIMD128-NEXT:    i32.const $push0=, 15
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.or $push2=, $2, $pop1
; SIMD128-NEXT:    i32.load8_s $push3=, 0($pop2)
; SIMD128-NEXT:    return $pop3
;
; NO-SIMD128-LABEL: extract_var_v16i8_s:
; NO-SIMD128:         .functype extract_var_v16i8_s (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push4=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push5=, 16
; NO-SIMD128-NEXT:    i32.sub $push7=, $pop4, $pop5
; NO-SIMD128-NEXT:    local.tee $push6=, $17=, $pop7
; NO-SIMD128-NEXT:    i32.store8 15($pop6), $15
; NO-SIMD128-NEXT:    i32.store8 14($17), $14
; NO-SIMD128-NEXT:    i32.store8 13($17), $13
; NO-SIMD128-NEXT:    i32.store8 12($17), $12
; NO-SIMD128-NEXT:    i32.store8 11($17), $11
; NO-SIMD128-NEXT:    i32.store8 10($17), $10
; NO-SIMD128-NEXT:    i32.store8 9($17), $9
; NO-SIMD128-NEXT:    i32.store8 8($17), $8
; NO-SIMD128-NEXT:    i32.store8 7($17), $7
; NO-SIMD128-NEXT:    i32.store8 6($17), $6
; NO-SIMD128-NEXT:    i32.store8 5($17), $5
; NO-SIMD128-NEXT:    i32.store8 4($17), $4
; NO-SIMD128-NEXT:    i32.store8 3($17), $3
; NO-SIMD128-NEXT:    i32.store8 2($17), $2
; NO-SIMD128-NEXT:    i32.store8 1($17), $1
; NO-SIMD128-NEXT:    i32.store8 0($17), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.or $push2=, $17, $pop1
; NO-SIMD128-NEXT:    i32.load8_s $push3=, 0($pop2)
; NO-SIMD128-NEXT:    return $pop3
  %elem = extractelement <16 x i8> %v, i32 %i
  %a = sext i8 %elem to i32
  ret i32 %a
}

define i32 @extract_undef_v16i8_s(<16 x i8> %v) {
; SIMD128-LABEL: extract_undef_v16i8_s:
; SIMD128:         .functype extract_undef_v16i8_s (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_s $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_undef_v16i8_s:
; NO-SIMD128:         .functype extract_undef_v16i8_s (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $0
; NO-SIMD128-NEXT:    return $pop0
  %elem = extractelement <16 x i8> %v, i8 undef
  %a = sext i8 %elem to i32
  ret i32 %a
}

define i32 @extract_v16i8_u(<16 x i8> %v) {
; SIMD128-LABEL: extract_v16i8_u:
; SIMD128:         .functype extract_v16i8_u (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $0, 13
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v16i8_u:
; NO-SIMD128:         .functype extract_v16i8_u (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $13, $pop0
; NO-SIMD128-NEXT:    return $pop1
  %elem = extractelement <16 x i8> %v, i8 13
  %a = zext i8 %elem to i32
  ret i32 %a
}

define i32 @extract_var_v16i8_u(<16 x i8> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v16i8_u:
; SIMD128:         .functype extract_var_v16i8_u (v128, i32) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push4=, __stack_pointer
; SIMD128-NEXT:    i32.const $push5=, 16
; SIMD128-NEXT:    i32.sub $push7=, $pop4, $pop5
; SIMD128-NEXT:    local.tee $push6=, $2=, $pop7
; SIMD128-NEXT:    v128.store 0($pop6), $0
; SIMD128-NEXT:    i32.const $push0=, 15
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.or $push2=, $2, $pop1
; SIMD128-NEXT:    i32.load8_u $push3=, 0($pop2)
; SIMD128-NEXT:    return $pop3
;
; NO-SIMD128-LABEL: extract_var_v16i8_u:
; NO-SIMD128:         .functype extract_var_v16i8_u (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push4=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push5=, 16
; NO-SIMD128-NEXT:    i32.sub $push7=, $pop4, $pop5
; NO-SIMD128-NEXT:    local.tee $push6=, $17=, $pop7
; NO-SIMD128-NEXT:    i32.store8 15($pop6), $15
; NO-SIMD128-NEXT:    i32.store8 14($17), $14
; NO-SIMD128-NEXT:    i32.store8 13($17), $13
; NO-SIMD128-NEXT:    i32.store8 12($17), $12
; NO-SIMD128-NEXT:    i32.store8 11($17), $11
; NO-SIMD128-NEXT:    i32.store8 10($17), $10
; NO-SIMD128-NEXT:    i32.store8 9($17), $9
; NO-SIMD128-NEXT:    i32.store8 8($17), $8
; NO-SIMD128-NEXT:    i32.store8 7($17), $7
; NO-SIMD128-NEXT:    i32.store8 6($17), $6
; NO-SIMD128-NEXT:    i32.store8 5($17), $5
; NO-SIMD128-NEXT:    i32.store8 4($17), $4
; NO-SIMD128-NEXT:    i32.store8 3($17), $3
; NO-SIMD128-NEXT:    i32.store8 2($17), $2
; NO-SIMD128-NEXT:    i32.store8 1($17), $1
; NO-SIMD128-NEXT:    i32.store8 0($17), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.or $push2=, $17, $pop1
; NO-SIMD128-NEXT:    i32.load8_u $push3=, 0($pop2)
; NO-SIMD128-NEXT:    return $pop3
  %elem = extractelement <16 x i8> %v, i32 %i
  %a = zext i8 %elem to i32
  ret i32 %a
}

define i32 @extract_undef_v16i8_u(<16 x i8> %v) {
; SIMD128-LABEL: extract_undef_v16i8_u:
; SIMD128:         .functype extract_undef_v16i8_u (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_undef_v16i8_u:
; NO-SIMD128:         .functype extract_undef_v16i8_u (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $0, $pop0
; NO-SIMD128-NEXT:    return $pop1
  %elem = extractelement <16 x i8> %v, i8 undef
  %a = zext i8 %elem to i32
  ret i32 %a
}

define i8 @extract_v16i8(<16 x i8> %v) {
; SIMD128-LABEL: extract_v16i8:
; SIMD128:         .functype extract_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $0, 13
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v16i8:
; NO-SIMD128:         .functype extract_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $13
  %elem = extractelement <16 x i8> %v, i8 13
  ret i8 %elem
}

define i8 @extract_var_v16i8(<16 x i8> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v16i8:
; SIMD128:         .functype extract_var_v16i8 (v128, i32) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push4=, __stack_pointer
; SIMD128-NEXT:    i32.const $push5=, 16
; SIMD128-NEXT:    i32.sub $push7=, $pop4, $pop5
; SIMD128-NEXT:    local.tee $push6=, $2=, $pop7
; SIMD128-NEXT:    v128.store 0($pop6), $0
; SIMD128-NEXT:    i32.const $push0=, 15
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.or $push2=, $2, $pop1
; SIMD128-NEXT:    i32.load8_u $push3=, 0($pop2)
; SIMD128-NEXT:    return $pop3
;
; NO-SIMD128-LABEL: extract_var_v16i8:
; NO-SIMD128:         .functype extract_var_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push4=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push5=, 16
; NO-SIMD128-NEXT:    i32.sub $push7=, $pop4, $pop5
; NO-SIMD128-NEXT:    local.tee $push6=, $17=, $pop7
; NO-SIMD128-NEXT:    i32.store8 15($pop6), $15
; NO-SIMD128-NEXT:    i32.store8 14($17), $14
; NO-SIMD128-NEXT:    i32.store8 13($17), $13
; NO-SIMD128-NEXT:    i32.store8 12($17), $12
; NO-SIMD128-NEXT:    i32.store8 11($17), $11
; NO-SIMD128-NEXT:    i32.store8 10($17), $10
; NO-SIMD128-NEXT:    i32.store8 9($17), $9
; NO-SIMD128-NEXT:    i32.store8 8($17), $8
; NO-SIMD128-NEXT:    i32.store8 7($17), $7
; NO-SIMD128-NEXT:    i32.store8 6($17), $6
; NO-SIMD128-NEXT:    i32.store8 5($17), $5
; NO-SIMD128-NEXT:    i32.store8 4($17), $4
; NO-SIMD128-NEXT:    i32.store8 3($17), $3
; NO-SIMD128-NEXT:    i32.store8 2($17), $2
; NO-SIMD128-NEXT:    i32.store8 1($17), $1
; NO-SIMD128-NEXT:    i32.store8 0($17), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.or $push2=, $17, $pop1
; NO-SIMD128-NEXT:    i32.load8_u $push3=, 0($pop2)
; NO-SIMD128-NEXT:    return $pop3
  %elem = extractelement <16 x i8> %v, i32 %i
  ret i8 %elem
}

define i8 @extract_undef_v16i8(<16 x i8> %v) {
; SIMD128-LABEL: extract_undef_v16i8:
; SIMD128:         .functype extract_undef_v16i8 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_undef_v16i8:
; NO-SIMD128:         .functype extract_undef_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $0
  %elem = extractelement <16 x i8> %v, i8 undef
  ret i8 %elem
}

define <16 x i8> @replace_v16i8(<16 x i8> %v, i8 %x) {
; SIMD128-LABEL: replace_v16i8:
; SIMD128:         .functype replace_v16i8 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.replace_lane $push0=, $0, 11, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_v16i8:
; NO-SIMD128:         .functype replace_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store8 8($0), $9
; NO-SIMD128-NEXT:    i32.store8 4($0), $5
; NO-SIMD128-NEXT:    i32.store8 2($0), $3
; NO-SIMD128-NEXT:    i32.store8 1($0), $2
; NO-SIMD128-NEXT:    i32.store8 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store8 0($pop1), $16
; NO-SIMD128-NEXT:    i32.const $push2=, 14
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store8 0($pop3), $15
; NO-SIMD128-NEXT:    i32.const $push4=, 13
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store8 0($pop5), $14
; NO-SIMD128-NEXT:    i32.const $push6=, 12
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $13
; NO-SIMD128-NEXT:    i32.const $push8=, 11
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.store8 0($pop9), $17
; NO-SIMD128-NEXT:    i32.const $push10=, 10
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $11
; NO-SIMD128-NEXT:    i32.const $push12=, 9
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $10
; NO-SIMD128-NEXT:    i32.const $push14=, 7
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.store8 0($pop15), $8
; NO-SIMD128-NEXT:    i32.const $push16=, 6
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $7
; NO-SIMD128-NEXT:    i32.const $push18=, 5
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $6
; NO-SIMD128-NEXT:    i32.const $push20=, 3
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.store8 0($pop21), $4
; NO-SIMD128-NEXT:    return
  %res = insertelement <16 x i8> %v, i8 %x, i32 11
  ret <16 x i8> %res
}

define <16 x i8> @replace_var_v16i8(<16 x i8> %v, i32 %i, i8 %x) {
; SIMD128-LABEL: replace_var_v16i8:
; SIMD128:         .functype replace_var_v16i8 (v128, i32, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push4=, __stack_pointer
; SIMD128-NEXT:    i32.const $push5=, 16
; SIMD128-NEXT:    i32.sub $push7=, $pop4, $pop5
; SIMD128-NEXT:    local.tee $push6=, $3=, $pop7
; SIMD128-NEXT:    v128.store 0($pop6), $0
; SIMD128-NEXT:    i32.const $push0=, 15
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.or $push2=, $3, $pop1
; SIMD128-NEXT:    i32.store8 0($pop2), $2
; SIMD128-NEXT:    v128.load $push3=, 0($3)
; SIMD128-NEXT:    return $pop3
;
; NO-SIMD128-LABEL: replace_var_v16i8:
; NO-SIMD128:         .functype replace_var_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push5=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push6=, 16
; NO-SIMD128-NEXT:    i32.sub $push8=, $pop5, $pop6
; NO-SIMD128-NEXT:    local.tee $push7=, $19=, $pop8
; NO-SIMD128-NEXT:    i32.store8 15($pop7), $16
; NO-SIMD128-NEXT:    i32.store8 14($19), $15
; NO-SIMD128-NEXT:    i32.store8 13($19), $14
; NO-SIMD128-NEXT:    i32.store8 12($19), $13
; NO-SIMD128-NEXT:    i32.store8 11($19), $12
; NO-SIMD128-NEXT:    i32.store8 10($19), $11
; NO-SIMD128-NEXT:    i32.store8 9($19), $10
; NO-SIMD128-NEXT:    i32.store8 8($19), $9
; NO-SIMD128-NEXT:    i32.store8 7($19), $8
; NO-SIMD128-NEXT:    i32.store8 6($19), $7
; NO-SIMD128-NEXT:    i32.store8 5($19), $6
; NO-SIMD128-NEXT:    i32.store8 4($19), $5
; NO-SIMD128-NEXT:    i32.store8 3($19), $4
; NO-SIMD128-NEXT:    i32.store8 2($19), $3
; NO-SIMD128-NEXT:    i32.store8 1($19), $2
; NO-SIMD128-NEXT:    i32.store8 0($19), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.and $push1=, $17, $pop0
; NO-SIMD128-NEXT:    i32.or $push2=, $19, $pop1
; NO-SIMD128-NEXT:    i32.store8 0($pop2), $18
; NO-SIMD128-NEXT:    i64.load $push3=, 8($19)
; NO-SIMD128-NEXT:    i64.store 8($0), $pop3
; NO-SIMD128-NEXT:    i64.load $push4=, 0($19)
; NO-SIMD128-NEXT:    i64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
  %res = insertelement <16 x i8> %v, i8 %x, i32 %i
  ret <16 x i8> %res
}

define <16 x i8> @replace_zero_v16i8(<16 x i8> %v, i8 %x) {
; SIMD128-LABEL: replace_zero_v16i8:
; SIMD128:         .functype replace_zero_v16i8 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.replace_lane $push0=, $0, 0, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_zero_v16i8:
; NO-SIMD128:         .functype replace_zero_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store8 8($0), $9
; NO-SIMD128-NEXT:    i32.store8 4($0), $5
; NO-SIMD128-NEXT:    i32.store8 2($0), $3
; NO-SIMD128-NEXT:    i32.store8 1($0), $2
; NO-SIMD128-NEXT:    i32.store8 0($0), $17
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store8 0($pop1), $16
; NO-SIMD128-NEXT:    i32.const $push2=, 14
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store8 0($pop3), $15
; NO-SIMD128-NEXT:    i32.const $push4=, 13
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store8 0($pop5), $14
; NO-SIMD128-NEXT:    i32.const $push6=, 12
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $13
; NO-SIMD128-NEXT:    i32.const $push8=, 11
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.store8 0($pop9), $12
; NO-SIMD128-NEXT:    i32.const $push10=, 10
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $11
; NO-SIMD128-NEXT:    i32.const $push12=, 9
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $10
; NO-SIMD128-NEXT:    i32.const $push14=, 7
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.store8 0($pop15), $8
; NO-SIMD128-NEXT:    i32.const $push16=, 6
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $7
; NO-SIMD128-NEXT:    i32.const $push18=, 5
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $6
; NO-SIMD128-NEXT:    i32.const $push20=, 3
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.store8 0($pop21), $4
; NO-SIMD128-NEXT:    return
  %res = insertelement <16 x i8> %v, i8 %x, i32 0
  ret <16 x i8> %res
}

define <16 x i8> @shuffle_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: shuffle_v16i8:
; SIMD128:         .functype shuffle_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $1, 0, 17, 2, 19, 4, 21, 6, 23, 8, 25, 10, 27, 12, 29, 14, 31
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_v16i8:
; NO-SIMD128:         .functype shuffle_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store8 8($0), $9
; NO-SIMD128-NEXT:    i32.store8 4($0), $5
; NO-SIMD128-NEXT:    i32.store8 2($0), $3
; NO-SIMD128-NEXT:    i32.store8 1($0), $18
; NO-SIMD128-NEXT:    i32.store8 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store8 0($pop1), $32
; NO-SIMD128-NEXT:    i32.const $push2=, 14
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store8 0($pop3), $15
; NO-SIMD128-NEXT:    i32.const $push4=, 13
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store8 0($pop5), $30
; NO-SIMD128-NEXT:    i32.const $push6=, 12
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $13
; NO-SIMD128-NEXT:    i32.const $push8=, 11
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.store8 0($pop9), $28
; NO-SIMD128-NEXT:    i32.const $push10=, 10
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $11
; NO-SIMD128-NEXT:    i32.const $push12=, 9
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $26
; NO-SIMD128-NEXT:    i32.const $push14=, 7
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.store8 0($pop15), $24
; NO-SIMD128-NEXT:    i32.const $push16=, 6
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $7
; NO-SIMD128-NEXT:    i32.const $push18=, 5
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $22
; NO-SIMD128-NEXT:    i32.const $push20=, 3
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.store8 0($pop21), $20
; NO-SIMD128-NEXT:    return
  %res = shufflevector <16 x i8> %x, <16 x i8> %y,
    <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23,
                i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  ret <16 x i8> %res
}

define <16 x i8> @shuffle_undef_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: shuffle_undef_v16i8:
; SIMD128:         .functype shuffle_undef_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_undef_v16i8:
; NO-SIMD128:         .functype shuffle_undef_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store8 8($0), $2
; NO-SIMD128-NEXT:    i32.store8 4($0), $2
; NO-SIMD128-NEXT:    i32.store8 2($0), $2
; NO-SIMD128-NEXT:    i32.store8 1($0), $2
; NO-SIMD128-NEXT:    i32.store8 0($0), $2
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store8 0($pop1), $2
; NO-SIMD128-NEXT:    i32.const $push2=, 14
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store8 0($pop3), $2
; NO-SIMD128-NEXT:    i32.const $push4=, 13
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store8 0($pop5), $2
; NO-SIMD128-NEXT:    i32.const $push6=, 12
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $2
; NO-SIMD128-NEXT:    i32.const $push8=, 11
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.store8 0($pop9), $2
; NO-SIMD128-NEXT:    i32.const $push10=, 10
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $2
; NO-SIMD128-NEXT:    i32.const $push12=, 9
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $2
; NO-SIMD128-NEXT:    i32.const $push14=, 7
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.store8 0($pop15), $2
; NO-SIMD128-NEXT:    i32.const $push16=, 6
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $2
; NO-SIMD128-NEXT:    i32.const $push18=, 5
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $2
; NO-SIMD128-NEXT:    i32.const $push20=, 3
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.store8 0($pop21), $2
; NO-SIMD128-NEXT:    return
  %res = shufflevector <16 x i8> %x, <16 x i8> %y,
    <16 x i32> <i32 1, i32 undef, i32 undef, i32 undef,
                i32 undef, i32 undef, i32 undef, i32 undef,
                i32 undef, i32 undef, i32 undef, i32 undef,
                i32 undef, i32 undef, i32 undef, i32 undef>
  ret <16 x i8> %res
}

define <16 x i8> @build_v16i8(i8 %x0, i8 %x1, i8 %x2, i8 %x3,
; SIMD128-LABEL: build_v16i8:
; SIMD128:         .functype build_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.splat $push0=, $0
; SIMD128-NEXT:    i8x16.replace_lane $push1=, $pop0, 1, $1
; SIMD128-NEXT:    i8x16.replace_lane $push2=, $pop1, 2, $2
; SIMD128-NEXT:    i8x16.replace_lane $push3=, $pop2, 3, $3
; SIMD128-NEXT:    i8x16.replace_lane $push4=, $pop3, 4, $4
; SIMD128-NEXT:    i8x16.replace_lane $push5=, $pop4, 5, $5
; SIMD128-NEXT:    i8x16.replace_lane $push6=, $pop5, 6, $6
; SIMD128-NEXT:    i8x16.replace_lane $push7=, $pop6, 7, $7
; SIMD128-NEXT:    i8x16.replace_lane $push8=, $pop7, 8, $8
; SIMD128-NEXT:    i8x16.replace_lane $push9=, $pop8, 9, $9
; SIMD128-NEXT:    i8x16.replace_lane $push10=, $pop9, 10, $10
; SIMD128-NEXT:    i8x16.replace_lane $push11=, $pop10, 11, $11
; SIMD128-NEXT:    i8x16.replace_lane $push12=, $pop11, 12, $12
; SIMD128-NEXT:    i8x16.replace_lane $push13=, $pop12, 13, $13
; SIMD128-NEXT:    i8x16.replace_lane $push14=, $pop13, 14, $14
; SIMD128-NEXT:    i8x16.replace_lane $push15=, $pop14, 15, $15
; SIMD128-NEXT:    return $pop15
;
; NO-SIMD128-LABEL: build_v16i8:
; NO-SIMD128:         .functype build_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store8 8($0), $9
; NO-SIMD128-NEXT:    i32.store8 4($0), $5
; NO-SIMD128-NEXT:    i32.store8 2($0), $3
; NO-SIMD128-NEXT:    i32.store8 1($0), $2
; NO-SIMD128-NEXT:    i32.store8 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store8 0($pop1), $16
; NO-SIMD128-NEXT:    i32.const $push2=, 14
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store8 0($pop3), $15
; NO-SIMD128-NEXT:    i32.const $push4=, 13
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store8 0($pop5), $14
; NO-SIMD128-NEXT:    i32.const $push6=, 12
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $13
; NO-SIMD128-NEXT:    i32.const $push8=, 11
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.store8 0($pop9), $12
; NO-SIMD128-NEXT:    i32.const $push10=, 10
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $11
; NO-SIMD128-NEXT:    i32.const $push12=, 9
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $10
; NO-SIMD128-NEXT:    i32.const $push14=, 7
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.store8 0($pop15), $8
; NO-SIMD128-NEXT:    i32.const $push16=, 6
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $7
; NO-SIMD128-NEXT:    i32.const $push18=, 5
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $6
; NO-SIMD128-NEXT:    i32.const $push20=, 3
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.store8 0($pop21), $4
; NO-SIMD128-NEXT:    return
                              i8 %x4, i8 %x5, i8 %x6, i8 %x7,
                              i8 %x8, i8 %x9, i8 %x10, i8 %x11,
                              i8 %x12, i8 %x13, i8 %x14, i8 %x15) {
  %t0 = insertelement <16 x i8> undef, i8 %x0, i32 0
  %t1 = insertelement <16 x i8> %t0, i8 %x1, i32 1
  %t2 = insertelement <16 x i8> %t1, i8 %x2, i32 2
  %t3 = insertelement <16 x i8> %t2, i8 %x3, i32 3
  %t4 = insertelement <16 x i8> %t3, i8 %x4, i32 4
  %t5 = insertelement <16 x i8> %t4, i8 %x5, i32 5
  %t6 = insertelement <16 x i8> %t5, i8 %x6, i32 6
  %t7 = insertelement <16 x i8> %t6, i8 %x7, i32 7
  %t8 = insertelement <16 x i8> %t7, i8 %x8, i32 8
  %t9 = insertelement <16 x i8> %t8, i8 %x9, i32 9
  %t10 = insertelement <16 x i8> %t9, i8 %x10, i32 10
  %t11 = insertelement <16 x i8> %t10, i8 %x11, i32 11
  %t12 = insertelement <16 x i8> %t11, i8 %x12, i32 12
  %t13 = insertelement <16 x i8> %t12, i8 %x13, i32 13
  %t14 = insertelement <16 x i8> %t13, i8 %x14, i32 14
  %res = insertelement <16 x i8> %t14, i8 %x15, i32 15
  ret <16 x i8> %res
}

; ==============================================================================
; 8 x i16
; ==============================================================================
define <8 x i16> @const_v8i16() {
; SIMD128-LABEL: const_v8i16:
; SIMD128:         .functype const_v8i16 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 256, 770, 1284, 1798, 2312, 2826, 3340, 3854
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_v8i16:
; NO-SIMD128:         .functype const_v8i16 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 1084818905618843912
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 506097522914230528
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <8 x i16> <i16 256, i16 770, i16 1284, i16 1798,
                 i16 2312, i16 2826, i16 3340, i16 3854>
}

define <8 x i16> @splat_v8i16(i16 %x) {
; SIMD128-LABEL: splat_v8i16:
; SIMD128:         .functype splat_v8i16 (i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.splat $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: splat_v8i16:
; NO-SIMD128:         .functype splat_v8i16 (i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store16 8($0), $1
; NO-SIMD128-NEXT:    i32.store16 4($0), $1
; NO-SIMD128-NEXT:    i32.store16 2($0), $1
; NO-SIMD128-NEXT:    i32.store16 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 14
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store16 0($pop1), $1
; NO-SIMD128-NEXT:    i32.const $push2=, 12
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store16 0($pop3), $1
; NO-SIMD128-NEXT:    i32.const $push4=, 10
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store16 0($pop5), $1
; NO-SIMD128-NEXT:    i32.const $push6=, 6
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $1
; NO-SIMD128-NEXT:    return
  %v = insertelement <8 x i16> undef, i16 %x, i32 0
  %res = shufflevector <8 x i16> %v, <8 x i16> undef,
    <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  ret <8 x i16> %res
}

define <8 x i16> @const_splat_v8i16() {
; SIMD128-LABEL: const_splat_v8i16:
; SIMD128:         .functype const_splat_v8i16 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 42, 42, 42, 42, 42, 42, 42, 42
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_splat_v8i16:
; NO-SIMD128:         .functype const_splat_v8i16 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 11822129413226538
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 11822129413226538
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <8 x i16> <i16 42, i16 42, i16 42, i16 42, i16 42, i16 42, i16 42, i16 42>
}

define i32 @extract_v8i16_s(<8 x i16> %v) {
; SIMD128-LABEL: extract_v8i16_s:
; SIMD128:         .functype extract_v8i16_s (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_s $push0=, $0, 5
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v8i16_s:
; NO-SIMD128:         .functype extract_v8i16_s (i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $5
; NO-SIMD128-NEXT:    return $pop0
  %elem = extractelement <8 x i16> %v, i16 5
  %a = sext i16 %elem to i32
  ret i32 %a
}

define i32 @extract_var_v8i16_s(<8 x i16> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v8i16_s:
; SIMD128:         .functype extract_var_v8i16_s (v128, i32) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $2=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 7
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 1
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $2, $pop3
; SIMD128-NEXT:    i32.load16_s $push5=, 0($pop4)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: extract_var_v8i16_s:
; NO-SIMD128:         .functype extract_var_v8i16_s (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push6=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push7=, 16
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; NO-SIMD128-NEXT:    local.tee $push8=, $9=, $pop9
; NO-SIMD128-NEXT:    i32.store16 14($pop8), $7
; NO-SIMD128-NEXT:    i32.store16 12($9), $6
; NO-SIMD128-NEXT:    i32.store16 10($9), $5
; NO-SIMD128-NEXT:    i32.store16 8($9), $4
; NO-SIMD128-NEXT:    i32.store16 6($9), $3
; NO-SIMD128-NEXT:    i32.store16 4($9), $2
; NO-SIMD128-NEXT:    i32.store16 2($9), $1
; NO-SIMD128-NEXT:    i32.store16 0($9), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 7
; NO-SIMD128-NEXT:    i32.and $push1=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 1
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $9, $pop3
; NO-SIMD128-NEXT:    i32.load16_s $push5=, 0($pop4)
; NO-SIMD128-NEXT:    return $pop5
  %elem = extractelement <8 x i16> %v, i32 %i
  %a = sext i16 %elem to i32
  ret i32 %a
}

define i32 @extract_undef_v8i16_s(<8 x i16> %v) {
; SIMD128-LABEL: extract_undef_v8i16_s:
; SIMD128:         .functype extract_undef_v8i16_s (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_s $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_undef_v8i16_s:
; NO-SIMD128:         .functype extract_undef_v8i16_s (i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $0
; NO-SIMD128-NEXT:    return $pop0
  %elem = extractelement <8 x i16> %v, i16 undef
  %a = sext i16 %elem to i32
  ret i32 %a
}

define i32 @extract_v8i16_u(<8 x i16> %v) {
; SIMD128-LABEL: extract_v8i16_u:
; SIMD128:         .functype extract_v8i16_u (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $0, 5
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v8i16_u:
; NO-SIMD128:         .functype extract_v8i16_u (i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $5, $pop0
; NO-SIMD128-NEXT:    return $pop1
  %elem = extractelement <8 x i16> %v, i16 5
  %a = zext i16 %elem to i32
  ret i32 %a
}

define i32 @extract_var_v8i16_u(<8 x i16> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v8i16_u:
; SIMD128:         .functype extract_var_v8i16_u (v128, i32) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $2=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 7
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 1
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $2, $pop3
; SIMD128-NEXT:    i32.load16_u $push5=, 0($pop4)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: extract_var_v8i16_u:
; NO-SIMD128:         .functype extract_var_v8i16_u (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push6=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push7=, 16
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; NO-SIMD128-NEXT:    local.tee $push8=, $9=, $pop9
; NO-SIMD128-NEXT:    i32.store16 14($pop8), $7
; NO-SIMD128-NEXT:    i32.store16 12($9), $6
; NO-SIMD128-NEXT:    i32.store16 10($9), $5
; NO-SIMD128-NEXT:    i32.store16 8($9), $4
; NO-SIMD128-NEXT:    i32.store16 6($9), $3
; NO-SIMD128-NEXT:    i32.store16 4($9), $2
; NO-SIMD128-NEXT:    i32.store16 2($9), $1
; NO-SIMD128-NEXT:    i32.store16 0($9), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 7
; NO-SIMD128-NEXT:    i32.and $push1=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 1
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $9, $pop3
; NO-SIMD128-NEXT:    i32.load16_u $push5=, 0($pop4)
; NO-SIMD128-NEXT:    return $pop5
  %elem = extractelement <8 x i16> %v, i32 %i
  %a = zext i16 %elem to i32
  ret i32 %a
}

define i32 @extract_undef_v8i16_u(<8 x i16> %v) {
; SIMD128-LABEL: extract_undef_v8i16_u:
; SIMD128:         .functype extract_undef_v8i16_u (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_undef_v8i16_u:
; NO-SIMD128:         .functype extract_undef_v8i16_u (i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $0, $pop0
; NO-SIMD128-NEXT:    return $pop1
  %elem = extractelement <8 x i16> %v, i16 undef
  %a = zext i16 %elem to i32
  ret i32 %a
}

define i16 @extract_v8i16(<8 x i16> %v) {
; SIMD128-LABEL: extract_v8i16:
; SIMD128:         .functype extract_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $0, 5
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v8i16:
; NO-SIMD128:         .functype extract_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $5
  %elem = extractelement <8 x i16> %v, i16 5
  ret i16 %elem
}

define i16 @extract_var_v8i16(<8 x i16> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v8i16:
; SIMD128:         .functype extract_var_v8i16 (v128, i32) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $2=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 7
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 1
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $2, $pop3
; SIMD128-NEXT:    i32.load16_u $push5=, 0($pop4)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: extract_var_v8i16:
; NO-SIMD128:         .functype extract_var_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push6=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push7=, 16
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; NO-SIMD128-NEXT:    local.tee $push8=, $9=, $pop9
; NO-SIMD128-NEXT:    i32.store16 14($pop8), $7
; NO-SIMD128-NEXT:    i32.store16 12($9), $6
; NO-SIMD128-NEXT:    i32.store16 10($9), $5
; NO-SIMD128-NEXT:    i32.store16 8($9), $4
; NO-SIMD128-NEXT:    i32.store16 6($9), $3
; NO-SIMD128-NEXT:    i32.store16 4($9), $2
; NO-SIMD128-NEXT:    i32.store16 2($9), $1
; NO-SIMD128-NEXT:    i32.store16 0($9), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 7
; NO-SIMD128-NEXT:    i32.and $push1=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 1
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $9, $pop3
; NO-SIMD128-NEXT:    i32.load16_u $push5=, 0($pop4)
; NO-SIMD128-NEXT:    return $pop5
  %elem = extractelement <8 x i16> %v, i32 %i
  ret i16 %elem
}

define i16 @extract_undef_v8i16(<8 x i16> %v) {
; SIMD128-LABEL: extract_undef_v8i16:
; SIMD128:         .functype extract_undef_v8i16 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_undef_v8i16:
; NO-SIMD128:         .functype extract_undef_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $0
  %elem = extractelement <8 x i16> %v, i16 undef
  ret i16 %elem
}

define <8 x i16> @replace_v8i16(<8 x i16> %v, i16 %x) {
; SIMD128-LABEL: replace_v8i16:
; SIMD128:         .functype replace_v8i16 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.replace_lane $push0=, $0, 7, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_v8i16:
; NO-SIMD128:         .functype replace_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store16 8($0), $5
; NO-SIMD128-NEXT:    i32.store16 4($0), $3
; NO-SIMD128-NEXT:    i32.store16 2($0), $2
; NO-SIMD128-NEXT:    i32.store16 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 14
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store16 0($pop1), $9
; NO-SIMD128-NEXT:    i32.const $push2=, 12
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store16 0($pop3), $7
; NO-SIMD128-NEXT:    i32.const $push4=, 10
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store16 0($pop5), $6
; NO-SIMD128-NEXT:    i32.const $push6=, 6
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $4
; NO-SIMD128-NEXT:    return
  %res = insertelement <8 x i16> %v, i16 %x, i32 7
  ret <8 x i16> %res
}

define <8 x i16> @replace_var_v8i16(<8 x i16> %v, i32 %i, i16 %x) {
; SIMD128-LABEL: replace_var_v8i16:
; SIMD128:         .functype replace_var_v8i16 (v128, i32, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $3=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 7
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 1
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $3, $pop3
; SIMD128-NEXT:    i32.store16 0($pop4), $2
; SIMD128-NEXT:    v128.load $push5=, 0($3)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: replace_var_v8i16:
; NO-SIMD128:         .functype replace_var_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push7=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push8=, 16
; NO-SIMD128-NEXT:    i32.sub $push10=, $pop7, $pop8
; NO-SIMD128-NEXT:    local.tee $push9=, $11=, $pop10
; NO-SIMD128-NEXT:    i32.store16 14($pop9), $8
; NO-SIMD128-NEXT:    i32.store16 12($11), $7
; NO-SIMD128-NEXT:    i32.store16 10($11), $6
; NO-SIMD128-NEXT:    i32.store16 8($11), $5
; NO-SIMD128-NEXT:    i32.store16 6($11), $4
; NO-SIMD128-NEXT:    i32.store16 4($11), $3
; NO-SIMD128-NEXT:    i32.store16 2($11), $2
; NO-SIMD128-NEXT:    i32.store16 0($11), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 7
; NO-SIMD128-NEXT:    i32.and $push1=, $9, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 1
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $11, $pop3
; NO-SIMD128-NEXT:    i32.store16 0($pop4), $10
; NO-SIMD128-NEXT:    i64.load $push5=, 8($11)
; NO-SIMD128-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-NEXT:    i64.load $push6=, 0($11)
; NO-SIMD128-NEXT:    i64.store 0($0), $pop6
; NO-SIMD128-NEXT:    return
  %res = insertelement <8 x i16> %v, i16 %x, i32 %i
  ret <8 x i16> %res
}

define <8 x i16> @replace_zero_v8i16(<8 x i16> %v, i16 %x) {
; SIMD128-LABEL: replace_zero_v8i16:
; SIMD128:         .functype replace_zero_v8i16 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.replace_lane $push0=, $0, 0, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_zero_v8i16:
; NO-SIMD128:         .functype replace_zero_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store16 8($0), $5
; NO-SIMD128-NEXT:    i32.store16 4($0), $3
; NO-SIMD128-NEXT:    i32.store16 2($0), $2
; NO-SIMD128-NEXT:    i32.store16 0($0), $9
; NO-SIMD128-NEXT:    i32.const $push0=, 14
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store16 0($pop1), $8
; NO-SIMD128-NEXT:    i32.const $push2=, 12
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store16 0($pop3), $7
; NO-SIMD128-NEXT:    i32.const $push4=, 10
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store16 0($pop5), $6
; NO-SIMD128-NEXT:    i32.const $push6=, 6
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $4
; NO-SIMD128-NEXT:    return
  %res = insertelement <8 x i16> %v, i16 %x, i32 0
  ret <8 x i16> %res
}

define <8 x i16> @shuffle_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: shuffle_v8i16:
; SIMD128:         .functype shuffle_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $1, 0, 1, 18, 19, 4, 5, 22, 23, 8, 9, 26, 27, 12, 13, 30, 31
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_v8i16:
; NO-SIMD128:         .functype shuffle_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store16 8($0), $5
; NO-SIMD128-NEXT:    i32.store16 4($0), $3
; NO-SIMD128-NEXT:    i32.store16 2($0), $10
; NO-SIMD128-NEXT:    i32.store16 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 14
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store16 0($pop1), $16
; NO-SIMD128-NEXT:    i32.const $push2=, 12
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store16 0($pop3), $7
; NO-SIMD128-NEXT:    i32.const $push4=, 10
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store16 0($pop5), $14
; NO-SIMD128-NEXT:    i32.const $push6=, 6
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $12
; NO-SIMD128-NEXT:    return
  %res = shufflevector <8 x i16> %x, <8 x i16> %y,
    <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  ret <8 x i16> %res
}

define <8 x i16> @shuffle_undef_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: shuffle_undef_v8i16:
; SIMD128:         .functype shuffle_undef_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_undef_v8i16:
; NO-SIMD128:         .functype shuffle_undef_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store16 8($0), $2
; NO-SIMD128-NEXT:    i32.store16 4($0), $2
; NO-SIMD128-NEXT:    i32.store16 2($0), $2
; NO-SIMD128-NEXT:    i32.store16 0($0), $2
; NO-SIMD128-NEXT:    i32.const $push0=, 14
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store16 0($pop1), $2
; NO-SIMD128-NEXT:    i32.const $push2=, 12
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store16 0($pop3), $2
; NO-SIMD128-NEXT:    i32.const $push4=, 10
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store16 0($pop5), $2
; NO-SIMD128-NEXT:    i32.const $push6=, 6
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $2
; NO-SIMD128-NEXT:    return
  %res = shufflevector <8 x i16> %x, <8 x i16> %y,
    <8 x i32> <i32 1, i32 undef, i32 undef, i32 undef,
               i32 undef, i32 undef, i32 undef, i32 undef>
  ret <8 x i16> %res
}

define <8 x i16> @build_v8i16(i16 %x0, i16 %x1, i16 %x2, i16 %x3,
; SIMD128-LABEL: build_v8i16:
; SIMD128:         .functype build_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.splat $push0=, $0
; SIMD128-NEXT:    i16x8.replace_lane $push1=, $pop0, 1, $1
; SIMD128-NEXT:    i16x8.replace_lane $push2=, $pop1, 2, $2
; SIMD128-NEXT:    i16x8.replace_lane $push3=, $pop2, 3, $3
; SIMD128-NEXT:    i16x8.replace_lane $push4=, $pop3, 4, $4
; SIMD128-NEXT:    i16x8.replace_lane $push5=, $pop4, 5, $5
; SIMD128-NEXT:    i16x8.replace_lane $push6=, $pop5, 6, $6
; SIMD128-NEXT:    i16x8.replace_lane $push7=, $pop6, 7, $7
; SIMD128-NEXT:    return $pop7
;
; NO-SIMD128-LABEL: build_v8i16:
; NO-SIMD128:         .functype build_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store16 8($0), $5
; NO-SIMD128-NEXT:    i32.store16 4($0), $3
; NO-SIMD128-NEXT:    i32.store16 2($0), $2
; NO-SIMD128-NEXT:    i32.store16 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 14
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store16 0($pop1), $8
; NO-SIMD128-NEXT:    i32.const $push2=, 12
; NO-SIMD128-NEXT:    i32.add $push3=, $0, $pop2
; NO-SIMD128-NEXT:    i32.store16 0($pop3), $7
; NO-SIMD128-NEXT:    i32.const $push4=, 10
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.store16 0($pop5), $6
; NO-SIMD128-NEXT:    i32.const $push6=, 6
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $4
; NO-SIMD128-NEXT:    return
                              i16 %x4, i16 %x5, i16 %x6, i16 %x7) {
  %t0 = insertelement <8 x i16> undef, i16 %x0, i32 0
  %t1 = insertelement <8 x i16> %t0, i16 %x1, i32 1
  %t2 = insertelement <8 x i16> %t1, i16 %x2, i32 2
  %t3 = insertelement <8 x i16> %t2, i16 %x3, i32 3
  %t4 = insertelement <8 x i16> %t3, i16 %x4, i32 4
  %t5 = insertelement <8 x i16> %t4, i16 %x5, i32 5
  %t6 = insertelement <8 x i16> %t5, i16 %x6, i32 6
  %res = insertelement <8 x i16> %t6, i16 %x7, i32 7
  ret <8 x i16> %res
}

; ==============================================================================
; 4 x i32
; ==============================================================================
define <4 x i32> @const_v4i32() {
; SIMD128-LABEL: const_v4i32:
; SIMD128:         .functype const_v4i32 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 50462976, 117835012, 185207048, 252579084
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_v4i32:
; NO-SIMD128:         .functype const_v4i32 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 1084818905618843912
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 506097522914230528
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <4 x i32> <i32 50462976, i32 117835012, i32 185207048, i32 252579084>
}

define <4 x i32> @splat_v4i32(i32 %x) {
; SIMD128-LABEL: splat_v4i32:
; SIMD128:         .functype splat_v4i32 (i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.splat $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: splat_v4i32:
; NO-SIMD128:         .functype splat_v4i32 (i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store 8($0), $1
; NO-SIMD128-NEXT:    i32.store 4($0), $1
; NO-SIMD128-NEXT:    i32.store 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store 0($pop1), $1
; NO-SIMD128-NEXT:    return
  %v = insertelement <4 x i32> undef, i32 %x, i32 0
  %res = shufflevector <4 x i32> %v, <4 x i32> undef,
    <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  ret <4 x i32> %res
}

define <4 x i32> @const_splat_v4i32() {
; SIMD128-LABEL: const_splat_v4i32:
; SIMD128:         .functype const_splat_v4i32 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 42, 42, 42, 42
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_splat_v4i32:
; NO-SIMD128:         .functype const_splat_v4i32 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 180388626474
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 180388626474
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <4 x i32> <i32 42, i32 42, i32 42, i32 42>
}

define i32 @extract_v4i32(<4 x i32> %v) {
; SIMD128-LABEL: extract_v4i32:
; SIMD128:         .functype extract_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extract_lane $push0=, $0, 3
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v4i32:
; NO-SIMD128:         .functype extract_v4i32 (i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $3
  %elem = extractelement <4 x i32> %v, i32 3
  ret i32 %elem
}

define i32 @extract_var_v4i32(<4 x i32> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v4i32:
; SIMD128:         .functype extract_var_v4i32 (v128, i32) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $2=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 3
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 2
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $2, $pop3
; SIMD128-NEXT:    i32.load $push5=, 0($pop4)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: extract_var_v4i32:
; NO-SIMD128:         .functype extract_var_v4i32 (i32, i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push6=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push7=, 16
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; NO-SIMD128-NEXT:    local.tee $push8=, $5=, $pop9
; NO-SIMD128-NEXT:    i32.store 12($pop8), $3
; NO-SIMD128-NEXT:    i32.store 8($5), $2
; NO-SIMD128-NEXT:    i32.store 4($5), $1
; NO-SIMD128-NEXT:    i32.store 0($5), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 3
; NO-SIMD128-NEXT:    i32.and $push1=, $4, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 2
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $5, $pop3
; NO-SIMD128-NEXT:    i32.load $push5=, 0($pop4)
; NO-SIMD128-NEXT:    return $pop5
  %elem = extractelement <4 x i32> %v, i32 %i
  ret i32 %elem
}

define i32 @extract_zero_v4i32(<4 x i32> %v) {
; SIMD128-LABEL: extract_zero_v4i32:
; SIMD128:         .functype extract_zero_v4i32 (v128) -> (i32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extract_lane $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_zero_v4i32:
; NO-SIMD128:         .functype extract_zero_v4i32 (i32, i32, i32, i32) -> (i32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $0
  %elem = extractelement <4 x i32> %v, i32 0
  ret i32 %elem
}

define <4 x i32> @replace_v4i32(<4 x i32> %v, i32 %x) {
; SIMD128-LABEL: replace_v4i32:
; SIMD128:         .functype replace_v4i32 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.replace_lane $push0=, $0, 2, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_v4i32:
; NO-SIMD128:         .functype replace_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store 8($0), $5
; NO-SIMD128-NEXT:    i32.store 4($0), $2
; NO-SIMD128-NEXT:    i32.store 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store 0($pop1), $4
; NO-SIMD128-NEXT:    return
  %res = insertelement <4 x i32> %v, i32 %x, i32 2
  ret <4 x i32> %res
}

define <4 x i32> @replace_var_v4i32(<4 x i32> %v, i32 %i, i32 %x) {
; SIMD128-LABEL: replace_var_v4i32:
; SIMD128:         .functype replace_var_v4i32 (v128, i32, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $3=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 3
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 2
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $3, $pop3
; SIMD128-NEXT:    i32.store 0($pop4), $2
; SIMD128-NEXT:    v128.load $push5=, 0($3)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: replace_var_v4i32:
; NO-SIMD128:         .functype replace_var_v4i32 (i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push7=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push8=, 16
; NO-SIMD128-NEXT:    i32.sub $push10=, $pop7, $pop8
; NO-SIMD128-NEXT:    local.tee $push9=, $7=, $pop10
; NO-SIMD128-NEXT:    i32.store 12($pop9), $4
; NO-SIMD128-NEXT:    i32.store 8($7), $3
; NO-SIMD128-NEXT:    i32.store 4($7), $2
; NO-SIMD128-NEXT:    i32.store 0($7), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 3
; NO-SIMD128-NEXT:    i32.and $push1=, $5, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 2
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $7, $pop3
; NO-SIMD128-NEXT:    i32.store 0($pop4), $6
; NO-SIMD128-NEXT:    i64.load $push5=, 8($7)
; NO-SIMD128-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-NEXT:    i64.load $push6=, 0($7)
; NO-SIMD128-NEXT:    i64.store 0($0), $pop6
; NO-SIMD128-NEXT:    return
  %res = insertelement <4 x i32> %v, i32 %x, i32 %i
  ret <4 x i32> %res
}

define <4 x i32> @replace_zero_v4i32(<4 x i32> %v, i32 %x) {
; SIMD128-LABEL: replace_zero_v4i32:
; SIMD128:         .functype replace_zero_v4i32 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.replace_lane $push0=, $0, 0, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_zero_v4i32:
; NO-SIMD128:         .functype replace_zero_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store 8($0), $3
; NO-SIMD128-NEXT:    i32.store 4($0), $2
; NO-SIMD128-NEXT:    i32.store 0($0), $5
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store 0($pop1), $4
; NO-SIMD128-NEXT:    return
  %res = insertelement <4 x i32> %v, i32 %x, i32 0
  ret <4 x i32> %res
}

define <4 x i32> @shuffle_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: shuffle_v4i32:
; SIMD128:         .functype shuffle_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $1, 0, 1, 2, 3, 20, 21, 22, 23, 8, 9, 10, 11, 28, 29, 30, 31
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_v4i32:
; NO-SIMD128:         .functype shuffle_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store 8($0), $3
; NO-SIMD128-NEXT:    i32.store 4($0), $6
; NO-SIMD128-NEXT:    i32.store 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store 0($pop1), $8
; NO-SIMD128-NEXT:    return
  %res = shufflevector <4 x i32> %x, <4 x i32> %y,
    <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x i32> %res
}

define <4 x i32> @shuffle_undef_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: shuffle_undef_v4i32:
; SIMD128:         .functype shuffle_undef_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_undef_v4i32:
; NO-SIMD128:         .functype shuffle_undef_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store 8($0), $2
; NO-SIMD128-NEXT:    i32.store 4($0), $2
; NO-SIMD128-NEXT:    i32.store 0($0), $2
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store 0($pop1), $2
; NO-SIMD128-NEXT:    return
  %res = shufflevector <4 x i32> %x, <4 x i32> %y,
    <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  ret <4 x i32> %res
}

define <4 x i32> @build_v4i32(i32 %x0, i32 %x1, i32 %x2, i32 %x3) {
; SIMD128-LABEL: build_v4i32:
; SIMD128:         .functype build_v4i32 (i32, i32, i32, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.splat $push0=, $0
; SIMD128-NEXT:    i32x4.replace_lane $push1=, $pop0, 1, $1
; SIMD128-NEXT:    i32x4.replace_lane $push2=, $pop1, 2, $2
; SIMD128-NEXT:    i32x4.replace_lane $push3=, $pop2, 3, $3
; SIMD128-NEXT:    return $pop3
;
; NO-SIMD128-LABEL: build_v4i32:
; NO-SIMD128:         .functype build_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.store 8($0), $3
; NO-SIMD128-NEXT:    i32.store 4($0), $2
; NO-SIMD128-NEXT:    i32.store 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.store 0($pop1), $4
; NO-SIMD128-NEXT:    return
  %t0 = insertelement <4 x i32> undef, i32 %x0, i32 0
  %t1 = insertelement <4 x i32> %t0, i32 %x1, i32 1
  %t2 = insertelement <4 x i32> %t1, i32 %x2, i32 2
  %res = insertelement <4 x i32> %t2, i32 %x3, i32 3
  ret <4 x i32> %res
}

; ==============================================================================
; 2 x i64
; ==============================================================================
define <2 x i64> @const_v2i64() {
; SIMD128-LABEL: const_v2i64:
; SIMD128:         .functype const_v2i64 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 506097522914230528, 1084818905618843912
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_v2i64:
; NO-SIMD128:         .functype const_v2i64 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 1084818905618843912
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 506097522914230528
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <2 x i64> <i64 506097522914230528, i64 1084818905618843912>
}

define <2 x i64> @splat_v2i64(i64 %x) {
; SIMD128-LABEL: splat_v2i64:
; SIMD128:         .functype splat_v2i64 (i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.splat $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: splat_v2i64:
; NO-SIMD128:         .functype splat_v2i64 (i32, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.store 8($0), $1
; NO-SIMD128-NEXT:    i64.store 0($0), $1
; NO-SIMD128-NEXT:    return
  %t1 = insertelement <2 x i64> zeroinitializer, i64 %x, i32 0
  %res = insertelement <2 x i64> %t1, i64 %x, i32 1
  ret <2 x i64> %res
}

define <2 x i64> @const_splat_v2i64() {
; SIMD128-LABEL: const_splat_v2i64:
; SIMD128:         .functype const_splat_v2i64 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 42, 42
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_splat_v2i64:
; NO-SIMD128:         .functype const_splat_v2i64 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 42
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 42
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <2 x i64> <i64 42, i64 42>
}

define i64 @extract_v2i64(<2 x i64> %v) {
; SIMD128-LABEL: extract_v2i64:
; SIMD128:         .functype extract_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v2i64:
; NO-SIMD128:         .functype extract_v2i64 (i64, i64) -> (i64)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $1
  %elem = extractelement <2 x i64> %v, i64 1
  ret i64 %elem
}

define i64 @extract_var_v2i64(<2 x i64> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v2i64:
; SIMD128:         .functype extract_var_v2i64 (v128, i32) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $2=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 1
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 3
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $2, $pop3
; SIMD128-NEXT:    i64.load $push5=, 0($pop4)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: extract_var_v2i64:
; NO-SIMD128:         .functype extract_var_v2i64 (i64, i64, i32) -> (i64)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push6=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push7=, 16
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; NO-SIMD128-NEXT:    local.tee $push8=, $3=, $pop9
; NO-SIMD128-NEXT:    i64.store 8($pop8), $1
; NO-SIMD128-NEXT:    i64.store 0($3), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 1
; NO-SIMD128-NEXT:    i32.and $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 3
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $3, $pop3
; NO-SIMD128-NEXT:    i64.load $push5=, 0($pop4)
; NO-SIMD128-NEXT:    return $pop5
  %elem = extractelement <2 x i64> %v, i32 %i
  ret i64 %elem
}

define i64 @extract_zero_v2i64(<2 x i64> %v) {
; SIMD128-LABEL: extract_zero_v2i64:
; SIMD128:         .functype extract_zero_v2i64 (v128) -> (i64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_zero_v2i64:
; NO-SIMD128:         .functype extract_zero_v2i64 (i64, i64) -> (i64)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $0
  %elem = extractelement <2 x i64> %v, i64 0
  ret i64 %elem
}

define <2 x i64> @replace_v2i64(<2 x i64> %v, i64 %x) {
; SIMD128-LABEL: replace_v2i64:
; SIMD128:         .functype replace_v2i64 (v128, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.replace_lane $push0=, $0, 0, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_v2i64:
; NO-SIMD128:         .functype replace_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.store 8($0), $2
; NO-SIMD128-NEXT:    i64.store 0($0), $3
; NO-SIMD128-NEXT:    return
  %res = insertelement <2 x i64> %v, i64 %x, i32 0
  ret <2 x i64> %res
}

define <2 x i64> @replace_var_v2i64(<2 x i64> %v, i32 %i, i64 %x) {
; SIMD128-LABEL: replace_var_v2i64:
; SIMD128:         .functype replace_var_v2i64 (v128, i32, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $3=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 1
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 3
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $3, $pop3
; SIMD128-NEXT:    i64.store 0($pop4), $2
; SIMD128-NEXT:    v128.load $push5=, 0($3)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: replace_var_v2i64:
; NO-SIMD128:         .functype replace_var_v2i64 (i32, i64, i64, i32, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push7=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push8=, 16
; NO-SIMD128-NEXT:    i32.sub $push10=, $pop7, $pop8
; NO-SIMD128-NEXT:    local.tee $push9=, $5=, $pop10
; NO-SIMD128-NEXT:    i64.store 8($pop9), $2
; NO-SIMD128-NEXT:    i64.store 0($5), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 1
; NO-SIMD128-NEXT:    i32.and $push1=, $3, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 3
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $5, $pop3
; NO-SIMD128-NEXT:    i64.store 0($pop4), $4
; NO-SIMD128-NEXT:    i64.load $push5=, 8($5)
; NO-SIMD128-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-NEXT:    i64.load $push6=, 0($5)
; NO-SIMD128-NEXT:    i64.store 0($0), $pop6
; NO-SIMD128-NEXT:    return
  %res = insertelement <2 x i64> %v, i64 %x, i32 %i
  ret <2 x i64> %res
}

define <2 x i64> @replace_zero_v2i64(<2 x i64> %v, i64 %x) {
; SIMD128-LABEL: replace_zero_v2i64:
; SIMD128:         .functype replace_zero_v2i64 (v128, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.replace_lane $push0=, $0, 0, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_zero_v2i64:
; NO-SIMD128:         .functype replace_zero_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.store 8($0), $2
; NO-SIMD128-NEXT:    i64.store 0($0), $3
; NO-SIMD128-NEXT:    return
  %res = insertelement <2 x i64> %v, i64 %x, i32 0
  ret <2 x i64> %res
}

define <2 x i64> @shuffle_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: shuffle_v2i64:
; SIMD128:         .functype shuffle_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $1, 0, 1, 2, 3, 4, 5, 6, 7, 24, 25, 26, 27, 28, 29, 30, 31
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_v2i64:
; NO-SIMD128:         .functype shuffle_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.store 8($0), $4
; NO-SIMD128-NEXT:    i64.store 0($0), $1
; NO-SIMD128-NEXT:    return
  %res = shufflevector <2 x i64> %x, <2 x i64> %y, <2 x i32> <i32 0, i32 3>
  ret <2 x i64> %res
}

define <2 x i64> @shuffle_undef_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: shuffle_undef_v2i64:
; SIMD128:         .functype shuffle_undef_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_undef_v2i64:
; NO-SIMD128:         .functype shuffle_undef_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.store 8($0), $2
; NO-SIMD128-NEXT:    i64.store 0($0), $2
; NO-SIMD128-NEXT:    return
  %res = shufflevector <2 x i64> %x, <2 x i64> %y,
    <2 x i32> <i32 1, i32 undef>
  ret <2 x i64> %res
}

define <2 x i64> @build_v2i64(i64 %x0, i64 %x1) {
; SIMD128-LABEL: build_v2i64:
; SIMD128:         .functype build_v2i64 (i64, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.splat $push0=, $0
; SIMD128-NEXT:    i64x2.replace_lane $push1=, $pop0, 1, $1
; SIMD128-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: build_v2i64:
; NO-SIMD128:         .functype build_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.store 8($0), $2
; NO-SIMD128-NEXT:    i64.store 0($0), $1
; NO-SIMD128-NEXT:    return
  %t0 = insertelement <2 x i64> undef, i64 %x0, i32 0
  %res = insertelement <2 x i64> %t0, i64 %x1, i32 1
  ret <2 x i64> %res
}

; ==============================================================================
; 4 x f32
; ==============================================================================
define <4 x float> @const_v4f32() {
; SIMD128-LABEL: const_v4f32:
; SIMD128:         .functype const_v4f32 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.0402p-121, 0x1.0c0a08p-113, 0x1.14121p-105, 0x1.1c1a18p-97
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_v4f32:
; NO-SIMD128:         .functype const_v4f32 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 1084818905618843912
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 506097522914230528
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <4 x float> <float 0x3860402000000000, float 0x38e0c0a080000000,
                   float 0x3961412100000000, float 0x39e1c1a180000000>
}

define <4 x float> @splat_v4f32(float %x) {
; SIMD128-LABEL: splat_v4f32:
; SIMD128:         .functype splat_v4f32 (f32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.splat $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: splat_v4f32:
; NO-SIMD128:         .functype splat_v4f32 (i32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.store 8($0), $1
; NO-SIMD128-NEXT:    f32.store 4($0), $1
; NO-SIMD128-NEXT:    f32.store 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    f32.store 0($pop1), $1
; NO-SIMD128-NEXT:    return
  %v = insertelement <4 x float> undef, float %x, i32 0
  %res = shufflevector <4 x float> %v, <4 x float> undef,
    <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  ret <4 x float> %res
}

define <4 x float> @const_splat_v4f32() {
; SIMD128-LABEL: const_splat_v4f32:
; SIMD128:         .functype const_splat_v4f32 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5, 0x1.5p5, 0x1.5p5
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_splat_v4f32:
; NO-SIMD128:         .functype const_splat_v4f32 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4767060206681587712
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4767060206681587712
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <4 x float> <float 42., float 42., float 42., float 42.>
}

define float @extract_v4f32(<4 x float> %v) {
; SIMD128-LABEL: extract_v4f32:
; SIMD128:         .functype extract_v4f32 (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 3
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v4f32:
; NO-SIMD128:         .functype extract_v4f32 (f32, f32, f32, f32) -> (f32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $3
  %elem = extractelement <4 x float> %v, i32 3
  ret float %elem
}

define float @extract_var_v4f32(<4 x float> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v4f32:
; SIMD128:         .functype extract_var_v4f32 (v128, i32) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $2=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 3
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 2
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $2, $pop3
; SIMD128-NEXT:    f32.load $push5=, 0($pop4)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: extract_var_v4f32:
; NO-SIMD128:         .functype extract_var_v4f32 (f32, f32, f32, f32, i32) -> (f32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push6=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push7=, 16
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; NO-SIMD128-NEXT:    local.tee $push8=, $5=, $pop9
; NO-SIMD128-NEXT:    f32.store 12($pop8), $3
; NO-SIMD128-NEXT:    f32.store 8($5), $2
; NO-SIMD128-NEXT:    f32.store 4($5), $1
; NO-SIMD128-NEXT:    f32.store 0($5), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 3
; NO-SIMD128-NEXT:    i32.and $push1=, $4, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 2
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $5, $pop3
; NO-SIMD128-NEXT:    f32.load $push5=, 0($pop4)
; NO-SIMD128-NEXT:    return $pop5
  %elem = extractelement <4 x float> %v, i32 %i
  ret float %elem
}

define float @extract_zero_v4f32(<4 x float> %v) {
; SIMD128-LABEL: extract_zero_v4f32:
; SIMD128:         .functype extract_zero_v4f32 (v128) -> (f32)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_zero_v4f32:
; NO-SIMD128:         .functype extract_zero_v4f32 (f32, f32, f32, f32) -> (f32)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $0
  %elem = extractelement <4 x float> %v, i32 0
  ret float %elem
}

define <4 x float> @replace_v4f32(<4 x float> %v, float %x) {
; SIMD128-LABEL: replace_v4f32:
; SIMD128:         .functype replace_v4f32 (v128, f32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.replace_lane $push0=, $0, 2, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_v4f32:
; NO-SIMD128:         .functype replace_v4f32 (i32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.store 8($0), $5
; NO-SIMD128-NEXT:    f32.store 4($0), $2
; NO-SIMD128-NEXT:    f32.store 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    f32.store 0($pop1), $4
; NO-SIMD128-NEXT:    return
  %res = insertelement <4 x float> %v, float %x, i32 2
  ret <4 x float> %res
}

define <4 x float> @replace_var_v4f32(<4 x float> %v, i32 %i, float %x) {
; SIMD128-LABEL: replace_var_v4f32:
; SIMD128:         .functype replace_var_v4f32 (v128, i32, f32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $3=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 3
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 2
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $3, $pop3
; SIMD128-NEXT:    f32.store 0($pop4), $2
; SIMD128-NEXT:    v128.load $push5=, 0($3)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: replace_var_v4f32:
; NO-SIMD128:         .functype replace_var_v4f32 (i32, f32, f32, f32, f32, i32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push7=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push8=, 16
; NO-SIMD128-NEXT:    i32.sub $push10=, $pop7, $pop8
; NO-SIMD128-NEXT:    local.tee $push9=, $7=, $pop10
; NO-SIMD128-NEXT:    f32.store 12($pop9), $4
; NO-SIMD128-NEXT:    f32.store 8($7), $3
; NO-SIMD128-NEXT:    f32.store 4($7), $2
; NO-SIMD128-NEXT:    f32.store 0($7), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 3
; NO-SIMD128-NEXT:    i32.and $push1=, $5, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 2
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $7, $pop3
; NO-SIMD128-NEXT:    f32.store 0($pop4), $6
; NO-SIMD128-NEXT:    i64.load $push5=, 8($7)
; NO-SIMD128-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-NEXT:    i64.load $push6=, 0($7)
; NO-SIMD128-NEXT:    i64.store 0($0), $pop6
; NO-SIMD128-NEXT:    return
  %res = insertelement <4 x float> %v, float %x, i32 %i
  ret <4 x float> %res
}

define <4 x float> @replace_zero_v4f32(<4 x float> %v, float %x) {
; SIMD128-LABEL: replace_zero_v4f32:
; SIMD128:         .functype replace_zero_v4f32 (v128, f32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.replace_lane $push0=, $0, 0, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_zero_v4f32:
; NO-SIMD128:         .functype replace_zero_v4f32 (i32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.store 8($0), $3
; NO-SIMD128-NEXT:    f32.store 4($0), $2
; NO-SIMD128-NEXT:    f32.store 0($0), $5
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    f32.store 0($pop1), $4
; NO-SIMD128-NEXT:    return
  %res = insertelement <4 x float> %v, float %x, i32 0
  ret <4 x float> %res
}

define <4 x float> @shuffle_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: shuffle_v4f32:
; SIMD128:         .functype shuffle_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $1, 0, 1, 2, 3, 20, 21, 22, 23, 8, 9, 10, 11, 28, 29, 30, 31
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_v4f32:
; NO-SIMD128:         .functype shuffle_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.store 8($0), $3
; NO-SIMD128-NEXT:    f32.store 4($0), $6
; NO-SIMD128-NEXT:    f32.store 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    f32.store 0($pop1), $8
; NO-SIMD128-NEXT:    return
  %res = shufflevector <4 x float> %x, <4 x float> %y,
    <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x float> %res
}

define <4 x float> @shuffle_undef_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: shuffle_undef_v4f32:
; SIMD128:         .functype shuffle_undef_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 4, 5, 6, 7, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_undef_v4f32:
; NO-SIMD128:         .functype shuffle_undef_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.store 8($0), $2
; NO-SIMD128-NEXT:    f32.store 4($0), $2
; NO-SIMD128-NEXT:    f32.store 0($0), $2
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    f32.store 0($pop1), $2
; NO-SIMD128-NEXT:    return
  %res = shufflevector <4 x float> %x, <4 x float> %y,
    <4 x i32> <i32 1, i32 undef, i32 undef, i32 undef>
  ret <4 x float> %res
}

define <4 x float> @build_v4f32(float %x0, float %x1, float %x2, float %x3) {
; SIMD128-LABEL: build_v4f32:
; SIMD128:         .functype build_v4f32 (f32, f32, f32, f32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.splat $push0=, $0
; SIMD128-NEXT:    f32x4.replace_lane $push1=, $pop0, 1, $1
; SIMD128-NEXT:    f32x4.replace_lane $push2=, $pop1, 2, $2
; SIMD128-NEXT:    f32x4.replace_lane $push3=, $pop2, 3, $3
; SIMD128-NEXT:    return $pop3
;
; NO-SIMD128-LABEL: build_v4f32:
; NO-SIMD128:         .functype build_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.store 8($0), $3
; NO-SIMD128-NEXT:    f32.store 4($0), $2
; NO-SIMD128-NEXT:    f32.store 0($0), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 12
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    f32.store 0($pop1), $4
; NO-SIMD128-NEXT:    return
  %t0 = insertelement <4 x float> undef, float %x0, i32 0
  %t1 = insertelement <4 x float> %t0, float %x1, i32 1
  %t2 = insertelement <4 x float> %t1, float %x2, i32 2
  %res = insertelement <4 x float> %t2, float %x3, i32 3
  ret <4 x float> %res
}

; ==============================================================================
; 2 x f64
; ==============================================================================
define <2 x double> @const_v2f64() {
; SIMD128-LABEL: const_v2f64:
; SIMD128:         .functype const_v2f64 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.60504030201p-911, 0x1.e0d0c0b0a0908p-783
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_v2f64:
; NO-SIMD128:         .functype const_v2f64 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 1084818905618843912
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 506097522914230528
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <2 x double> <double 0x0706050403020100, double 0x0F0E0D0C0B0A0908>
}

define <2 x double> @splat_v2f64(double %x) {
; SIMD128-LABEL: splat_v2f64:
; SIMD128:         .functype splat_v2f64 (f64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.splat $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: splat_v2f64:
; NO-SIMD128:         .functype splat_v2f64 (i32, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.store 8($0), $1
; NO-SIMD128-NEXT:    f64.store 0($0), $1
; NO-SIMD128-NEXT:    return
  %t1 = insertelement <2 x double> zeroinitializer, double %x, i3 0
  %res = insertelement <2 x double> %t1, double %x, i32 1
  ret <2 x double> %res
}

define <2 x double> @const_splat_v2f64() {
; SIMD128-LABEL: const_splat_v2f64:
; SIMD128:         .functype const_splat_v2f64 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: const_splat_v2f64:
; NO-SIMD128:         .functype const_splat_v2f64 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4631107791820423168
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4631107791820423168
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
  ret <2 x double> <double 42., double 42.>
}

define double @extract_v2f64(<2 x double> %v) {
; SIMD128-LABEL: extract_v2f64:
; SIMD128:         .functype extract_v2f64 (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_v2f64:
; NO-SIMD128:         .functype extract_v2f64 (f64, f64) -> (f64)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $1
  %elem = extractelement <2 x double> %v, i32 1
  ret double %elem
}

define double @extract_var_v2f64(<2 x double> %v, i32 %i) {
; SIMD128-LABEL: extract_var_v2f64:
; SIMD128:         .functype extract_var_v2f64 (v128, i32) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $2=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 1
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 3
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $2, $pop3
; SIMD128-NEXT:    f64.load $push5=, 0($pop4)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: extract_var_v2f64:
; NO-SIMD128:         .functype extract_var_v2f64 (f64, f64, i32) -> (f64)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push6=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push7=, 16
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; NO-SIMD128-NEXT:    local.tee $push8=, $3=, $pop9
; NO-SIMD128-NEXT:    f64.store 8($pop8), $1
; NO-SIMD128-NEXT:    f64.store 0($3), $0
; NO-SIMD128-NEXT:    i32.const $push0=, 1
; NO-SIMD128-NEXT:    i32.and $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 3
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $3, $pop3
; NO-SIMD128-NEXT:    f64.load $push5=, 0($pop4)
; NO-SIMD128-NEXT:    return $pop5
  %elem = extractelement <2 x double> %v, i32 %i
  ret double %elem
}

define double @extract_zero_v2f64(<2 x double> %v) {
; SIMD128-LABEL: extract_zero_v2f64:
; SIMD128:         .functype extract_zero_v2f64 (v128) -> (f64)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.extract_lane $push0=, $0, 0
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: extract_zero_v2f64:
; NO-SIMD128:         .functype extract_zero_v2f64 (f64, f64) -> (f64)
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    return $0
  %elem = extractelement <2 x double> %v, i32 0
  ret double %elem
}

define <2 x double> @replace_v2f64(<2 x double> %v, double %x) {
; SIMD128-LABEL: replace_v2f64:
; SIMD128:         .functype replace_v2f64 (v128, f64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.replace_lane $push0=, $0, 0, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_v2f64:
; NO-SIMD128:         .functype replace_v2f64 (i32, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.store 8($0), $2
; NO-SIMD128-NEXT:    f64.store 0($0), $3
; NO-SIMD128-NEXT:    return
  %res = insertelement <2 x double> %v, double %x, i32 0
  ret <2 x double> %res
}

define <2 x double> @replace_var_v2f64(<2 x double> %v, i32 %i, double %x) {
; SIMD128-LABEL: replace_var_v2f64:
; SIMD128:         .functype replace_var_v2f64 (v128, i32, f64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    global.get $push6=, __stack_pointer
; SIMD128-NEXT:    i32.const $push7=, 16
; SIMD128-NEXT:    i32.sub $push9=, $pop6, $pop7
; SIMD128-NEXT:    local.tee $push8=, $3=, $pop9
; SIMD128-NEXT:    v128.store 0($pop8), $0
; SIMD128-NEXT:    i32.const $push0=, 1
; SIMD128-NEXT:    i32.and $push1=, $1, $pop0
; SIMD128-NEXT:    i32.const $push2=, 3
; SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; SIMD128-NEXT:    i32.or $push4=, $3, $pop3
; SIMD128-NEXT:    f64.store 0($pop4), $2
; SIMD128-NEXT:    v128.load $push5=, 0($3)
; SIMD128-NEXT:    return $pop5
;
; NO-SIMD128-LABEL: replace_var_v2f64:
; NO-SIMD128:         .functype replace_var_v2f64 (i32, f64, f64, i32, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    global.get $push7=, __stack_pointer
; NO-SIMD128-NEXT:    i32.const $push8=, 16
; NO-SIMD128-NEXT:    i32.sub $push10=, $pop7, $pop8
; NO-SIMD128-NEXT:    local.tee $push9=, $5=, $pop10
; NO-SIMD128-NEXT:    f64.store 8($pop9), $2
; NO-SIMD128-NEXT:    f64.store 0($5), $1
; NO-SIMD128-NEXT:    i32.const $push0=, 1
; NO-SIMD128-NEXT:    i32.and $push1=, $3, $pop0
; NO-SIMD128-NEXT:    i32.const $push2=, 3
; NO-SIMD128-NEXT:    i32.shl $push3=, $pop1, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $5, $pop3
; NO-SIMD128-NEXT:    f64.store 0($pop4), $4
; NO-SIMD128-NEXT:    f64.load $push5=, 8($5)
; NO-SIMD128-NEXT:    f64.store 8($0), $pop5
; NO-SIMD128-NEXT:    f64.load $push6=, 0($5)
; NO-SIMD128-NEXT:    f64.store 0($0), $pop6
; NO-SIMD128-NEXT:    return
  %res = insertelement <2 x double> %v, double %x, i32 %i
  ret <2 x double> %res
}

define <2 x double> @replace_zero_v2f64(<2 x double> %v, double %x) {
; SIMD128-LABEL: replace_zero_v2f64:
; SIMD128:         .functype replace_zero_v2f64 (v128, f64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.replace_lane $push0=, $0, 0, $1
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: replace_zero_v2f64:
; NO-SIMD128:         .functype replace_zero_v2f64 (i32, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.store 8($0), $2
; NO-SIMD128-NEXT:    f64.store 0($0), $3
; NO-SIMD128-NEXT:    return
  %res = insertelement <2 x double> %v, double %x, i32 0
  ret <2 x double> %res
}

define <2 x double> @shuffle_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: shuffle_v2f64:
; SIMD128:         .functype shuffle_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $1, 0, 1, 2, 3, 4, 5, 6, 7, 24, 25, 26, 27, 28, 29, 30, 31
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_v2f64:
; NO-SIMD128:         .functype shuffle_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.store 8($0), $4
; NO-SIMD128-NEXT:    f64.store 0($0), $1
; NO-SIMD128-NEXT:    return
  %res = shufflevector <2 x double> %x, <2 x double> %y,
    <2 x i32> <i32 0, i32 3>
  ret <2 x double> %res
}

define <2 x double> @shuffle_undef_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: shuffle_undef_v2f64:
; SIMD128:         .functype shuffle_undef_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shuffle $push0=, $0, $0, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7
; SIMD128-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shuffle_undef_v2f64:
; NO-SIMD128:         .functype shuffle_undef_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.store 8($0), $2
; NO-SIMD128-NEXT:    f64.store 0($0), $2
; NO-SIMD128-NEXT:    return
  %res = shufflevector <2 x double> %x, <2 x double> %y,
    <2 x i32> <i32 1, i32 undef>
  ret <2 x double> %res
}

define <2 x double> @build_v2f64(double %x0, double %x1) {
; SIMD128-LABEL: build_v2f64:
; SIMD128:         .functype build_v2f64 (f64, f64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.splat $push0=, $0
; SIMD128-NEXT:    f64x2.replace_lane $push1=, $pop0, 1, $1
; SIMD128-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: build_v2f64:
; NO-SIMD128:         .functype build_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.store 8($0), $2
; NO-SIMD128-NEXT:    f64.store 0($0), $1
; NO-SIMD128-NEXT:    return
  %t0 = insertelement <2 x double> undef, double %x0, i32 0
  %res = insertelement <2 x double> %t0, double %x1, i32 1
  ret <2 x double> %res
}
