; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -amdgpu-scalarize-global-loads=false -march=amdgcn -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX6 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -march=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -march=amdgcn -mcpu=gfx1100 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -march=r600 -mcpu=cypress -verify-machineinstrs < %s | FileCheck -check-prefixes=CYPRESS %s

declare i16 @llvm.convert.to.fp16.f32(float) nounwind readnone

define amdgpu_kernel void @test_convert_fp32_to_fp16(ptr addrspace(1) noalias %out, ptr addrspace(1) noalias %in) nounwind {
; GFX6-LABEL: test_convert_fp32_to_fp16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_mov_b32 s10, s6
; GFX6-NEXT:    s_mov_b32 s11, s7
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s8, s2
; GFX6-NEXT:    s_mov_b32 s9, s3
; GFX6-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: test_convert_fp32_to_fp16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; GFX8-NEXT:    s_mov_b32 s7, 0xf000
; GFX8-NEXT:    s_mov_b32 s6, -1
; GFX8-NEXT:    s_mov_b32 s10, s6
; GFX8-NEXT:    s_mov_b32 s11, s7
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s8, s2
; GFX8-NEXT:    s_mov_b32 s9, s3
; GFX8-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX8-NEXT:    s_mov_b32 s4, s0
; GFX8-NEXT:    s_mov_b32 s5, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX8-NEXT:    s_endpgm
;
; GFX11-LABEL: test_convert_fp32_to_fp16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    s_mov_b32 s6, -1
; GFX11-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-NEXT:    s_mov_b32 s10, s6
; GFX11-NEXT:    s_mov_b32 s11, s7
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s8, s2
; GFX11-NEXT:    s_mov_b32 s9, s3
; GFX11-NEXT:    s_mov_b32 s4, s0
; GFX11-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-NEXT:    s_mov_b32 s5, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; CYPRESS-LABEL: test_convert_fp32_to_fp16:
; CYPRESS:       ; %bb.0:
; CYPRESS-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; CYPRESS-NEXT:    TEX 0 @6
; CYPRESS-NEXT:    ALU 11, @9, KC0[CB0:0-32], KC1[]
; CYPRESS-NEXT:    MEM_RAT MSKOR T0.XW, T1.X
; CYPRESS-NEXT:    CF_END
; CYPRESS-NEXT:    PAD
; CYPRESS-NEXT:    Fetch clause starting at 6:
; CYPRESS-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; CYPRESS-NEXT:    ALU clause starting at 8:
; CYPRESS-NEXT:     MOV * T0.X, KC0[2].Z,
; CYPRESS-NEXT:    ALU clause starting at 9:
; CYPRESS-NEXT:     AND_INT * T0.W, KC0[2].Y, literal.x,
; CYPRESS-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; CYPRESS-NEXT:     FLT32_TO_FLT16 T1.W, T0.X,
; CYPRESS-NEXT:     LSHL * T0.W, PV.W, literal.x,
; CYPRESS-NEXT:    3(4.203895e-45), 0(0.000000e+00)
; CYPRESS-NEXT:     LSHL T0.X, PV.W, PS,
; CYPRESS-NEXT:     LSHL * T0.W, literal.x, PS,
; CYPRESS-NEXT:    65535(9.183409e-41), 0(0.000000e+00)
; CYPRESS-NEXT:     MOV T0.Y, 0.0,
; CYPRESS-NEXT:     MOV * T0.Z, 0.0,
; CYPRESS-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; CYPRESS-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %val = load float, ptr addrspace(1) %in, align 4
  %cvt = call i16 @llvm.convert.to.fp16.f32(float %val) nounwind readnone
  store i16 %cvt, ptr addrspace(1) %out, align 2
  ret void
}
