; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -disable-output "-passes=print<scalar-evolution>" < %s 2>&1 | FileCheck %s

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.9.0"

; Test that SCEV is capable of figuring out value of 'IV' that actually does not change.
define void @foo() {
; CHECK-LABEL: 'foo'
; CHECK-NEXT:  Classifying expressions for: @foo
; CHECK-NEXT:    %iv.i = phi i64 [ -5, %entry ], [ %iv.next.i, %loop ]
; CHECK-NEXT:    --> -5 U: [-5,-4) S: [-5,-4) Exits: -5 LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:    %iv.next.i = add nsw i64 %iv.i, 0
; CHECK-NEXT:    --> -5 U: [-5,-4) S: [-5,-4) Exits: -5 LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @foo
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv.i = phi i64 [ -5, %entry ], [ %iv.next.i, %loop ]
  %iv.next.i = add nsw i64 %iv.i, 0
  br label %loop
}
