; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -disable-output "-passes=print<scalar-evolution>" < %s 2>&1 | FileCheck %s

define void @x(ptr %cond) {
; CHECK-LABEL: 'x'
; CHECK-NEXT:  Classifying expressions for: @x
; CHECK-NEXT:    %idx = phi i8 [ 0, %entry ], [ %idx.inc, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,-128) S: [0,-128) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.inc = add nsw i8 %idx, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><%loop> U: [1,0) S: [1,0) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %c = load volatile i1, ptr %cond, align 1
; CHECK-NEXT:    --> %c U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @x
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
  entry:
  br label %loop

  loop:
  %idx = phi i8 [ 0, %entry ], [ %idx.inc, %loop ]

  %idx.inc = add nsw i8 %idx, 1

  %c = load volatile i1, ptr %cond
  br i1 %c, label %loop, label %exit

  exit:
  ret void
}

define void @y(ptr %addr) {
; CHECK-LABEL: 'y'
; CHECK-NEXT:  Classifying expressions for: @y
; CHECK-NEXT:    %idx = phi i8 [ -5, %entry ], [ %idx.inc, %loop ]
; CHECK-NEXT:    --> {-5,+,1}<nsw><%loop> U: [-5,6) S: [-5,6) Exits: 5 LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %idx.inc = add i8 %idx, 1
; CHECK-NEXT:    --> {-4,+,1}<nsw><%loop> U: [-4,7) S: [-4,7) Exits: 6 LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @y
; CHECK-NEXT:  Loop %loop: backedge-taken count is 10
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 10
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is 10
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is 10
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 11
;
  entry:
  br label %loop

  loop:
  %idx = phi i8 [-5, %entry ], [ %idx.inc, %loop ]

  %idx.inc = add i8 %idx, 1

  %continue = icmp slt i8 %idx.inc, 6
  br i1 %continue, label %loop, label %exit

  exit:
  ret void
}
