# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## 4.175.4 (2021-11-15)


### Bug Fixes

* **FileUpload:** Downgrade react-dropzone back to 9.0.0 to avoid a breaking type change, fix behavior regressions ([#6610](https://github.com/patternfly/patternfly-react/issues/6610)) ([574bf4f](https://github.com/patternfly/patternfly-react/commit/574bf4ff3ccf7f67ce750bc48067eaf826e99990))





## 4.175.3 (2021-11-15)


### Bug Fixes

* **Menu:** allow maxMenuHeight with Scrollabe ([#6608](https://github.com/patternfly/patternfly-react/issues/6608)) ([8c1f12c](https://github.com/patternfly/patternfly-react/commit/8c1f12c2b0e86bbc5ba1071db3ebf29fee7421a0))





## 4.175.2 (2021-11-15)

**Note:** Version bump only for package @patternfly/react-core





## 4.175.1 (2021-11-15)

**Note:** Version bump only for package @patternfly/react-core





# 4.175.0 (2021-11-12)


### Features

* **card:** added hoverable/selectable/selected-raised variant ([#6565](https://github.com/patternfly/patternfly-react/issues/6565)) ([8c60568](https://github.com/patternfly/patternfly-react/commit/8c60568ba4fa18398fed636710e222ce506de82c))





## 4.174.2 (2021-11-12)

**Note:** Version bump only for package @patternfly/react-core





## 4.174.1 (2021-11-12)

**Note:** Version bump only for package @patternfly/react-core





# 4.174.0 (2021-11-11)


### Features

* **ComposableTable:** add sticky columns and nested headers ([#6538](https://github.com/patternfly/patternfly-react/issues/6538)) ([f11245b](https://github.com/patternfly/patternfly-react/commit/f11245bfccc8c6c02a9d5545a69ed533743cc552))





# 4.173.0 (2021-11-11)


### Features

* **contextselector:** added support for context selector items as links ([#6554](https://github.com/patternfly/patternfly-react/issues/6554)) ([c465388](https://github.com/patternfly/patternfly-react/commit/c4653881eee0cd8ec8e3a7125bbef0bded9f2de0))





# 4.172.0 (2021-11-11)


### Features

* **Navigation:** Added exemple with third level ([#6564](https://github.com/patternfly/patternfly-react/issues/6564)) ([c30da53](https://github.com/patternfly/patternfly-react/commit/c30da532855118f705c8cfc87c545bb1eea11ebb))





# 4.171.0 (2021-11-11)


### Features

* enhance type correctness of CodeEditor ([#6579](https://github.com/patternfly/patternfly-react/issues/6579)) ([e1ad65c](https://github.com/patternfly/patternfly-react/commit/e1ad65c225968d5a9c74019d19e4a3c5e2666926))





## 4.170.4 (2021-11-10)


### Bug Fixes

* **jumplinks:** fixed to always set clicked item as active ([#6542](https://github.com/patternfly/patternfly-react/issues/6542)) ([845c98f](https://github.com/patternfly/patternfly-react/commit/845c98f5f3df8aa9b6acc190707c5f1d7bf3ca38))





## 4.170.3 (2021-11-10)


### Bug Fixes

* **Menu:** stop passing disableHover to DrilldownMenu DOM ([#6571](https://github.com/patternfly/patternfly-react/issues/6571)) ([63dcf25](https://github.com/patternfly/patternfly-react/commit/63dcf256723848ff3789828fc0a5f86d5009fc87))





## 4.170.2 (2021-11-10)

**Note:** Version bump only for package @patternfly/react-core





## 4.170.1 (2021-11-10)

**Note:** Version bump only for package @patternfly/react-core





# 4.170.0 (2021-11-09)


### Features

* **Table:** set default sort direction ([#6544](https://github.com/patternfly/patternfly-react/issues/6544)) ([9ee4942](https://github.com/patternfly/patternfly-react/commit/9ee49428c8e1041721f2a09f8176a5aba3335049))





## 4.169.4 (2021-11-09)

**Note:** Version bump only for package @patternfly/react-core





## 4.169.3 (2021-11-08)

**Note:** Version bump only for package @patternfly/react-core





## 4.169.2 (2021-11-08)

**Note:** Version bump only for package @patternfly/react-core





## 4.169.1 (2021-11-08)


### Bug Fixes

* **acccessconsoles:** use object type Select options values in order to not mix displayed text with option keys ([#6496](https://github.com/patternfly/patternfly-react/issues/6496)) ([975c8e1](https://github.com/patternfly/patternfly-react/commit/975c8e14d7ea8c53eb4048ea6ef73e804b3ad2be))





# 4.169.0 (2021-11-04)


### Features

* **log-viewer:** support ANSI color ([#6519](https://github.com/patternfly/patternfly-react/issues/6519)) ([936a699](https://github.com/patternfly/patternfly-react/commit/936a699b0514a492d3c40be08932fb7bab275cce))





## 4.168.11 (2021-11-01)


### Bug Fixes

* **AboutModal:** allow to disable FocusTrap ([#6509](https://github.com/patternfly/patternfly-react/issues/6509)) ([72536e1](https://github.com/patternfly/patternfly-react/commit/72536e1f73641ff3f19f865f08dbb41ad0ee7b9f))





## 4.168.10 (2021-10-29)


### Bug Fixes

* **Banner:** forward props ([#6511](https://github.com/patternfly/patternfly-react/issues/6511)) ([e36c890](https://github.com/patternfly/patternfly-react/commit/e36c89077afa82340994c0e3c0fc929e601e01bc))





## 4.168.9 (2021-10-28)

**Note:** Version bump only for package @patternfly/react-core





## 4.168.8 (2021-10-27)

**Note:** Version bump only for package @patternfly/react-core





## 4.168.7 (2021-10-27)


### Bug Fixes

* change transformer cjs package to private ([#6515](https://github.com/patternfly/patternfly-react/issues/6515)) ([efcb357](https://github.com/patternfly/patternfly-react/commit/efcb3573b71541328ce2b16caa80ce33b2a62131))





## 4.168.6 (2021-10-26)

**Note:** Version bump only for package @patternfly/react-core





## 4.168.5 (2021-10-26)


### Bug Fixes

* **tokens:** added check for no matching var to avoid infinite loop ([#6502](https://github.com/patternfly/patternfly-react/issues/6502)) ([99605c2](https://github.com/patternfly/patternfly-react/commit/99605c213f12490d0abe75910e05c3e6da26a1f3))





## 4.168.4 (2021-10-26)


### Bug Fixes

* add transformer package ([#6507](https://github.com/patternfly/patternfly-react/issues/6507)) ([daffd28](https://github.com/patternfly/patternfly-react/commit/daffd2864388abe63e625f962a8b38c2b7056209))





## 4.168.3 (2021-10-26)


### Bug Fixes

* **transformer:** publish transformer in patternfly org ([#6506](https://github.com/patternfly/patternfly-react/issues/6506)) ([b739af3](https://github.com/patternfly/patternfly-react/commit/b739af318400b41d4e9a53bdff6232ecc176916e))





## 4.168.2 (2021-10-26)


### Bug Fixes

* **readme:** update react-core readme ([#6505](https://github.com/patternfly/patternfly-react/issues/6505)) ([d4f9a11](https://github.com/patternfly/patternfly-react/commit/d4f9a114584eea7ab67873f199e80b348886e14b))





## 4.168.1 (2021-10-26)


### Bug Fixes

* **DualListSelector:** account for duplicate folders ([#6499](https://github.com/patternfly/patternfly-react/issues/6499)) ([e531e68](https://github.com/patternfly/patternfly-react/commit/e531e68e7adc58459b3630f5c915ed69e3021012))





# 4.168.0 (2021-10-26)


### Features

* **toolbar:** add sticky top modifier to toolbar ([#6447](https://github.com/patternfly/patternfly-react/issues/6447)) ([fe7605a](https://github.com/patternfly/patternfly-react/commit/fe7605a67428b43ec00b3cb2117270296576737c))





## 4.167.1 (2021-10-26)


### Bug Fixes

* **types:** SelectOptionProp made optional ([#6503](https://github.com/patternfly/patternfly-react/issues/6503)) ([716ac80](https://github.com/patternfly/patternfly-react/commit/716ac80e2414507d589ee3002fc0cea0068ae59c))





# 4.167.0 (2021-10-26)


### Features

* **TextInputGroup:** add text input group ([#6482](https://github.com/patternfly/patternfly-react/issues/6482)) ([a02fd4f](https://github.com/patternfly/patternfly-react/commit/a02fd4fe3345245b2252ee5a261f5b1460490642)), closes [patternfly/patternfly-react#6409](https://github.com/patternfly/patternfly-react/issues/6409)





## 4.166.4 (2021-10-26)


### Bug Fixes

* **KebabToggle:** adds event to onToggle definition ([#6490](https://github.com/patternfly/patternfly-react/issues/6490)) ([0441575](https://github.com/patternfly/patternfly-react/commit/04415757917062aa13c06b34bd94ef38c2334088))





## 4.166.3 (2021-10-26)


### Bug Fixes

* **Modal:** test clean up ([#6489](https://github.com/patternfly/patternfly-react/issues/6489)) ([c8eaa7c](https://github.com/patternfly/patternfly-react/commit/c8eaa7c838fbedb98ea0f38e4f535488040a72e2))





## 4.166.2 (2021-10-25)

**Note:** Version bump only for package @patternfly/react-core





## 4.166.1 (2021-10-25)

**Note:** Version bump only for package @patternfly/react-core





# 4.166.0 (2021-10-25)


### Features

* **Tabs:** Added support for tab content body with padding, added tabs open and tab secondary tabs demos ([#6484](https://github.com/patternfly/patternfly-react/issues/6484)) ([0ccbe9d](https://github.com/patternfly/patternfly-react/commit/0ccbe9d1e6e0dac0730466c92a90fe2cd9f6560d))





## 4.165.1 (2021-10-21)

**Note:** Version bump only for package @patternfly/react-core





# 4.165.0 (2021-10-21)


### Features

* **label:** added compact label, updated horizontal grid card demo ([#6448](https://github.com/patternfly/patternfly-react/issues/6448)) ([89e0431](https://github.com/patternfly/patternfly-react/commit/89e04317924282140606d45f2292aa3f658b4b6c))





## 4.164.1 (2021-10-21)


### Bug Fixes

* **DescriptionListGroup:** forward props to DOM ([#6466](https://github.com/patternfly/patternfly-react/issues/6466)) ([b78e2aa](https://github.com/patternfly/patternfly-react/commit/b78e2aa9c0360ce8418f6e7b55274ea1a50de518))





# 4.164.0 (2021-10-20)


### Features

* **Progress:** allow node titles ([#6470](https://github.com/patternfly/patternfly-react/issues/6470)) ([46d5252](https://github.com/patternfly/patternfly-react/commit/46d52523ad5111bb11729c2750abe9aeb35d9326))





# 4.163.0 (2021-10-20)


### Features

* **DualListSelector:** add disabled flag ([#6442](https://github.com/patternfly/patternfly-react/issues/6442)) ([85e1314](https://github.com/patternfly/patternfly-react/commit/85e131435be12c2df79336e9fa56987ed3717417))





## 4.162.8 (2021-10-20)

**Note:** Version bump only for package @patternfly/react-core





## 4.162.7 (2021-10-20)

**Note:** Version bump only for package @patternfly/react-core





## [4.162.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.162.5...@patternfly/react-core@4.162.6) (2021-10-18)

**Note:** Version bump only for package @patternfly/react-core





## [4.162.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.162.4...@patternfly/react-core@4.162.5) (2021-10-14)


### Bug Fixes

* **wizard:** change wizard toggle and wizard toggle item to span tags ([#6428](https://github.com/patternfly/patternfly-react/issues/6428)) ([7b73e61](https://github.com/patternfly/patternfly-react/commit/7b73e61a26d29be8b8ebed5e87a1682600dee1e8))





## [4.162.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.162.3...@patternfly/react-core@4.162.4) (2021-10-14)


### Performance Improvements

* **TreeView:** add memoization + test demo ([#6362](https://github.com/patternfly/patternfly-react/issues/6362)) ([6e35627](https://github.com/patternfly/patternfly-react/commit/6e35627ded8d156da8898ffb6252c868504fbcd9))





## [4.162.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.162.2...@patternfly/react-core@4.162.3) (2021-10-13)

**Note:** Version bump only for package @patternfly/react-core





## [4.162.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.162.1...@patternfly/react-core@4.162.2) (2021-10-11)

**Note:** Version bump only for package @patternfly/react-core





## [4.162.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.162.0...@patternfly/react-core@4.162.1) (2021-10-11)

**Note:** Version bump only for package @patternfly/react-core





# [4.162.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.161.3...@patternfly/react-core@4.162.0) (2021-10-11)


### Features

* **Navigation:** add flyout with menu components ([#6416](https://github.com/patternfly/patternfly-react/issues/6416)) ([1d85989](https://github.com/patternfly/patternfly-react/commit/1d85989935aeaa3daa5c6f42b4f487be6a555be8))





## [4.161.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.161.2...@patternfly/react-core@4.161.3) (2021-10-11)

**Note:** Version bump only for package @patternfly/react-core





## [4.161.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.161.1...@patternfly/react-core@4.161.2) (2021-10-08)

**Note:** Version bump only for package @patternfly/react-core





## [4.161.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.161.0...@patternfly/react-core@4.161.1) (2021-10-07)

**Note:** Version bump only for package @patternfly/react-core





# [4.161.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.160.3...@patternfly/react-core@4.161.0) (2021-10-07)


### Features

* **DualListSelector:** introduce composable example and drag/drop demo ([#6369](https://github.com/patternfly/patternfly-react/issues/6369)) ([7cdda0f](https://github.com/patternfly/patternfly-react/commit/7cdda0fdd7f794e64bb8a8adebb48dfede5ebff9))





## [4.160.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.160.2...@patternfly/react-core@4.160.3) (2021-10-06)

**Note:** Version bump only for package @patternfly/react-core





## [4.160.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.160.1...@patternfly/react-core@4.160.2) (2021-10-06)

**Note:** Version bump only for package @patternfly/react-core





## [4.160.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.160.0...@patternfly/react-core@4.160.1) (2021-10-06)


### Bug Fixes

* **catalog, umd:** remove node-sass to allow building on node16 ([#6398](https://github.com/patternfly/patternfly-react/issues/6398)) ([212611a](https://github.com/patternfly/patternfly-react/commit/212611aae49d30385b500b5299be2975900ec22c))





# [4.160.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.159.1...@patternfly/react-core@4.160.0) (2021-10-05)


### Features

* **ProgressStepper:** add progress stepper ([#6339](https://github.com/patternfly/patternfly-react/issues/6339)) ([ba25ab3](https://github.com/patternfly/patternfly-react/commit/ba25ab399717356981ce8a54ede4ba3be91d9e94))





## [4.159.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.159.0...@patternfly/react-core@4.159.1) (2021-10-05)

**Note:** Version bump only for package @patternfly/react-core





# [4.159.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.158.4...@patternfly/react-core@4.159.0) (2021-10-05)


### Features

* **select:** add support for right aligned menu ([#6395](https://github.com/patternfly/patternfly-react/issues/6395)) ([74a586b](https://github.com/patternfly/patternfly-react/commit/74a586b51f6f7100f28f976d5f822b4874e6b7f4))





## [4.158.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.158.3...@patternfly/react-core@4.158.4) (2021-10-05)

**Note:** Version bump only for package @patternfly/react-core





## [4.158.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.158.2...@patternfly/react-core@4.158.3) (2021-10-01)

**Note:** Version bump only for package @patternfly/react-core





## [4.158.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.158.1...@patternfly/react-core@4.158.2) (2021-10-01)

**Note:** Version bump only for package @patternfly/react-core





## [4.158.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.158.0...@patternfly/react-core@4.158.1) (2021-09-30)

**Note:** Version bump only for package @patternfly/react-core





# [4.158.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.157.8...@patternfly/react-core@4.158.0) (2021-09-29)


### Features

* **JumpLinks:** Added toggle text ([#6347](https://github.com/patternfly/patternfly-react/issues/6347)) ([36042f6](https://github.com/patternfly/patternfly-react/commit/36042f679880f819afd26618797167a42f5fe901))





## [4.157.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.157.7...@patternfly/react-core@4.157.8) (2021-09-27)

**Note:** Version bump only for package @patternfly/react-core





## [4.157.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.157.6...@patternfly/react-core@4.157.7) (2021-09-27)


### Bug Fixes

* **TreeView:** isExpanded should override defaultExpanded ([#6326](https://github.com/patternfly/patternfly-react/issues/6326)) ([8f15ae3](https://github.com/patternfly/patternfly-react/commit/8f15ae30245c8238ff541f2040251a811d378f58))





## [4.157.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.157.5...@patternfly/react-core@4.157.6) (2021-09-24)


### Bug Fixes

* **dragdrop:** remove React.createPortal, add noWrap ([#6328](https://github.com/patternfly/patternfly-react/issues/6328)) ([425f9f2](https://github.com/patternfly/patternfly-react/commit/425f9f2f8b2c0281349f7e689f9f83f547af1c5c))





## [4.157.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.157.4...@patternfly/react-core@4.157.5) (2021-09-22)

**Note:** Version bump only for package @patternfly/react-core





## [4.157.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.157.3...@patternfly/react-core@4.157.4) (2021-09-20)

**Note:** Version bump only for package @patternfly/react-core





## [4.157.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.157.2...@patternfly/react-core@4.157.3) (2021-09-18)


### Bug Fixes

* **Nav:** Hide flyout example and props ([#6329](https://github.com/patternfly/patternfly-react/issues/6329)) ([e83e4e7](https://github.com/patternfly/patternfly-react/commit/e83e4e783023bb876457677c9627e9e25eed95d6))





## [4.157.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.157.1...@patternfly/react-core@4.157.2) (2021-09-16)


### Bug Fixes

* **nav:** flyout onMouseOver logic ([#6325](https://github.com/patternfly/patternfly-react/issues/6325)) ([2157b73](https://github.com/patternfly/patternfly-react/commit/2157b73d6953add7a67772c8fc3f86d822f8a5a3))





## [4.157.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.157.0...@patternfly/react-core@4.157.1) (2021-09-14)


### Bug Fixes

* **calendarmonth:** make useEffect respect validators ([#6315](https://github.com/patternfly/patternfly-react/issues/6315)) ([155eb0c](https://github.com/patternfly/patternfly-react/commit/155eb0cc9e6eaea22f0a3301b1e7be66c5982204))





# [4.157.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.156.4...@patternfly/react-core@4.157.0) (2021-09-14)


### Features

* **SearchInput:** Autocomplete SearchInput demo ([#6305](https://github.com/patternfly/patternfly-react/issues/6305)) ([8456945](https://github.com/patternfly/patternfly-react/commit/84569455a9662f6e0be951a0431b2bacea61ee73))





## [4.156.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.156.3...@patternfly/react-core@4.156.4) (2021-09-14)

**Note:** Version bump only for package @patternfly/react-core





## [4.156.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.156.2...@patternfly/react-core@4.156.3) (2021-09-13)

**Note:** Version bump only for package @patternfly/react-core





## [4.156.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.156.1...@patternfly/react-core@4.156.2) (2021-09-13)


### Bug Fixes

* wrapper nav should have hrefs ([#6297](https://github.com/patternfly/patternfly-react/issues/6297)) ([98af96d](https://github.com/patternfly/patternfly-react/commit/98af96d0bdf4db68ed27b106041588de881855ac))





## [4.156.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.156.0...@patternfly/react-core@4.156.1) (2021-09-13)

**Note:** Version bump only for package @patternfly/react-core





# [4.156.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.155.2...@patternfly/react-core@4.156.0) (2021-09-13)


### Features

* **Flex, Gallery, Grid:** allow setting alternative component ([#6270](https://github.com/patternfly/patternfly-react/issues/6270)) ([1703fdf](https://github.com/patternfly/patternfly-react/commit/1703fdfad6e2e058e0bd7e82269c79f41b8c0809)), closes [#5967](https://github.com/patternfly/patternfly-react/issues/5967)





## [4.155.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.155.1...@patternfly/react-core@4.155.2) (2021-09-13)

**Note:** Version bump only for package @patternfly/react-core





## [4.155.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.155.0...@patternfly/react-core@4.155.1) (2021-09-13)

**Note:** Version bump only for package @patternfly/react-core





# [4.155.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.154.1...@patternfly/react-core@4.155.0) (2021-09-10)


### Bug Fixes

* **dual-list-selector:** added support for list item row, bumped core ([#6294](https://github.com/patternfly/patternfly-react/issues/6294)) ([010efb5](https://github.com/patternfly/patternfly-react/commit/010efb51c46740bd1e28866d6b956c363819b69d))
* **SelectToggle:** use aria-label prop ([#6271](https://github.com/patternfly/patternfly-react/issues/6271)) ([5084a46](https://github.com/patternfly/patternfly-react/commit/5084a46531c8d3054e0c8b53f921d18bfb116973))


### Features

* **Nav:** add flyout ([#6253](https://github.com/patternfly/patternfly-react/issues/6253)) ([fec556d](https://github.com/patternfly/patternfly-react/commit/fec556dab5478aec27f7ec56e35be11ac5774d4a))





## [4.154.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.154.0...@patternfly/react-core@4.154.1) (2021-09-10)

**Note:** Version bump only for package @patternfly/react-core





# [4.154.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.153.0...@patternfly/react-core@4.154.0) (2021-09-09)


### Bug Fixes

* **datepicker:** updated date picker microcopy ([#6263](https://github.com/patternfly/patternfly-react/issues/6263)) ([6975851](https://github.com/patternfly/patternfly-react/commit/6975851f389d3834597c24769f35ad84d0339a08))


### Features

* **DescriptionList:** add compact and fluid modifiers ([#6260](https://github.com/patternfly/patternfly-react/issues/6260)) ([8b7cd70](https://github.com/patternfly/patternfly-react/commit/8b7cd704a4aae20ebf5953d4de4cc4f894052851))





# [4.153.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.152.7...@patternfly/react-core@4.153.0) (2021-09-01)


### Bug Fixes

* **Slider:** fixed customSteps spacing to respect min/max ([#6231](https://github.com/patternfly/patternfly-react/issues/6231)) ([ed777b2](https://github.com/patternfly/patternfly-react/commit/ed777b2288167bd42fe4e5564510b1ef135164fa))


### Features

* **DualListSelector:** add arguments to onOptionsSelect ([#6224](https://github.com/patternfly/patternfly-react/issues/6224)) ([#6225](https://github.com/patternfly/patternfly-react/issues/6225)) ([a59c4af](https://github.com/patternfly/patternfly-react/commit/a59c4afc84a7892035c9c80dd1c7b1d431406619))





## [4.152.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.152.6...@patternfly/react-core@4.152.7) (2021-08-31)

**Note:** Version bump only for package @patternfly/react-core





## [4.152.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.152.5...@patternfly/react-core@4.152.6) (2021-08-31)


### Bug Fixes

* **Slider:** update slider to respect min/max constraints ([#6232](https://github.com/patternfly/patternfly-react/issues/6232)) ([11dd20e](https://github.com/patternfly/patternfly-react/commit/11dd20e34ed7f1dafc3043e061b9f3e6f221daa2))





## [4.152.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.152.4...@patternfly/react-core@4.152.5) (2021-08-30)

**Note:** Version bump only for package @patternfly/react-core





## [4.152.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.152.3...@patternfly/react-core@4.152.4) (2021-08-23)

**Note:** Version bump only for package @patternfly/react-core





## [4.152.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.152.2...@patternfly/react-core@4.152.3) (2021-08-23)

**Note:** Version bump only for package @patternfly/react-core





## [4.152.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.152.1...@patternfly/react-core@4.152.2) (2021-08-23)

**Note:** Version bump only for package @patternfly/react-core





## [4.152.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.152.0...@patternfly/react-core@4.152.1) (2021-08-23)

**Note:** Version bump only for package @patternfly/react-core





# [4.152.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.151.2...@patternfly/react-core@4.152.0) (2021-08-20)


### Features

* **Menu:** add app-launcher mockup ([#6175](https://github.com/patternfly/patternfly-react/issues/6175)) ([9f2fdcc](https://github.com/patternfly/patternfly-react/commit/9f2fdcce55e087f39b7f5b3ce6f1f5939ac1e1c7))





## [4.151.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.151.1...@patternfly/react-core@4.151.2) (2021-08-20)

**Note:** Version bump only for package @patternfly/react-core





## [4.151.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.151.0...@patternfly/react-core@4.151.1) (2021-08-20)

**Note:** Version bump only for package @patternfly/react-core





# [4.151.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.150.4...@patternfly/react-core@4.151.0) (2021-08-19)


### Bug Fixes

* **examples:** updating example microcopy ([#6196](https://github.com/patternfly/patternfly-react/issues/6196)) ([b1d90f2](https://github.com/patternfly/patternfly-react/commit/b1d90f2c3e05eb6f5ee9aaa34b46a5a5d7a203fd))


### Features

* **ContextSelector:** Add plain variant ([#6141](https://github.com/patternfly/patternfly-react/issues/6141)) ([b4ab0e0](https://github.com/patternfly/patternfly-react/commit/b4ab0e0094917739ff7c02797ce305498dc8fc9f))
* **Search input:** Added support for submit button ([#6178](https://github.com/patternfly/patternfly-react/issues/6178)) ([4a2679a](https://github.com/patternfly/patternfly-react/commit/4a2679abab52d612d4f13386b43d89db87053dab))
* **TreeView:** add guides + compact variants ([#6172](https://github.com/patternfly/patternfly-react/issues/6172)) ([7526e23](https://github.com/patternfly/patternfly-react/commit/7526e236c218a54d37e74baebbfd180f7024587e))





## [4.150.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.150.3...@patternfly/react-core@4.150.4) (2021-08-19)


### Bug Fixes

* **NumberInput:** call 'onPlus' and 'onMinus' if set only ([#6197](https://github.com/patternfly/patternfly-react/issues/6197)) ([ac3b03e](https://github.com/patternfly/patternfly-react/commit/ac3b03e466d21cef330ade1010caf915c59a69cd))
* **Select:** correct typeahead children check ([#6176](https://github.com/patternfly/patternfly-react/issues/6176)) ([4899e6e](https://github.com/patternfly/patternfly-react/commit/4899e6e799fb5b1ae7747353c718d7b3a1464abd))





## [4.150.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.150.2...@patternfly/react-core@4.150.3) (2021-08-19)

**Note:** Version bump only for package @patternfly/react-core





## [4.150.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.150.1...@patternfly/react-core@4.150.2) (2021-08-18)


### Bug Fixes

* **DualListSelector:** respect initial chosen opts, select subfolders, reset selected on all ([#6180](https://github.com/patternfly/patternfly-react/issues/6180)) ([a1df392](https://github.com/patternfly/patternfly-react/commit/a1df3925e3e464d0caa27cb94b3162ad7cb7212b))





## [4.150.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.150.0...@patternfly/react-core@4.150.1) (2021-08-18)

**Note:** Version bump only for package @patternfly/react-core





# [4.150.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.149.1...@patternfly/react-core@4.150.0) (2021-08-17)


### Features

* **Navigation:** add horizontal subnav variant ([#6149](https://github.com/patternfly/patternfly-react/issues/6149)) ([1ec8488](https://github.com/patternfly/patternfly-react/commit/1ec8488a3056fc659ec83f04a6e793903ddd2e83))
* **Popover:** support diagonal positions ([#6155](https://github.com/patternfly/patternfly-react/issues/6155)) ([f1b1003](https://github.com/patternfly/patternfly-react/commit/f1b10032eb527ada191cef8f7f21e76dc1d7c56c))





## [4.149.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.149.0...@patternfly/react-core@4.149.1) (2021-08-16)


### Bug Fixes

* **jumplinks:** improve perf ([#6128](https://github.com/patternfly/patternfly-react/issues/6128)) ([94448e4](https://github.com/patternfly/patternfly-react/commit/94448e4ea83113d5cb5de75dbf362b2ef0ecd5ef))
* **Popover:** call setVisible before animation ([#6104](https://github.com/patternfly/patternfly-react/issues/6104)) ([bc7dc1a](https://github.com/patternfly/patternfly-react/commit/bc7dc1aab813cec5c6f63b2051cbbc21eecbe947))





# [4.149.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.148.2...@patternfly/react-core@4.149.0) (2021-08-12)


### Bug Fixes

* **TimePicker:** small fixes ([#6134](https://github.com/patternfly/patternfly-react/issues/6134)) ([b4a9bb5](https://github.com/patternfly/patternfly-react/commit/b4a9bb5fc3c5a60e905055de6c45619e40215e8c))
* **Toolbar:** use categoryName.key as filter counter index ([#6143](https://github.com/patternfly/patternfly-react/issues/6143)) ([28d1aef](https://github.com/patternfly/patternfly-react/commit/28d1aef59772d6a9669338bd7457591efc72f715))


### Features

* **SearchInput:** submit the search when hitting Enter in the main input field ([#6145](https://github.com/patternfly/patternfly-react/issues/6145)) ([6757b8e](https://github.com/patternfly/patternfly-react/commit/6757b8e46f14987f3680a2d6c3614bab938e2065))
* **TreeView:** Update treeview to consume toolbar ([#6133](https://github.com/patternfly/patternfly-react/issues/6133)) ([3b3b328](https://github.com/patternfly/patternfly-react/commit/3b3b3281aef7a328ee9c7265aeb3575365ae8798))





## [4.148.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.148.1...@patternfly/react-core@4.148.2) (2021-08-11)

**Note:** Version bump only for package @patternfly/react-core





## [4.148.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.148.0...@patternfly/react-core@4.148.1) (2021-08-11)


### Bug Fixes

* **ToolbarFilter:** Add props for customizing ChipGroup text ([#6138](https://github.com/patternfly/patternfly-react/issues/6138)) ([28cbfab](https://github.com/patternfly/patternfly-react/commit/28cbfab02f753ba112f7037c5c9d5562db02edbd))





# [4.148.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.147.2...@patternfly/react-core@4.148.0) (2021-08-10)


### Features

* **HelperText:** update default icons for success/error ([#6130](https://github.com/patternfly/patternfly-react/issues/6130)) ([0b7d722](https://github.com/patternfly/patternfly-react/commit/0b7d72248e3f5ed8135d75d87d39350f6bbd7bd7))





## [4.147.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.147.1...@patternfly/react-core@4.147.2) (2021-08-10)


### Bug Fixes

* **SelectMenu:** omit isLastOptionBeforeFooter from props ([#6147](https://github.com/patternfly/patternfly-react/issues/6147)) ([6c6f42c](https://github.com/patternfly/patternfly-react/commit/6c6f42cabf1a7a2e81aefac2bc0fe46b19180c21))





## [4.147.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.147.0...@patternfly/react-core@4.147.1) (2021-08-09)

**Note:** Version bump only for package @patternfly/react-core





# [4.147.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.146.0...@patternfly/react-core@4.147.0) (2021-08-03)


### Features

* **LogViewer:** Add demo with new controls ([#6064](https://github.com/patternfly/patternfly-react/issues/6064)) ([2343396](https://github.com/patternfly/patternfly-react/commit/2343396087f8b14706a88ecdbba90bb282b1875d))





# [4.146.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.145.1...@patternfly/react-core@4.146.0) (2021-08-02)


### Features

* **Dropdown:** Allow for tooltips on aria-disabled items ([#6038](https://github.com/patternfly/patternfly-react/issues/6038)) ([74ec097](https://github.com/patternfly/patternfly-react/commit/74ec09747379ccfaa3b0ebecaadff910c7b590e2))





## [4.145.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.145.0...@patternfly/react-core@4.145.1) (2021-08-02)

**Note:** Version bump only for package @patternfly/react-core





# [4.145.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.144.0...@patternfly/react-core@4.145.0) (2021-08-02)


### Bug Fixes

* **Select:** first new item focused after view more clicked ([#6095](https://github.com/patternfly/patternfly-react/issues/6095)) ([a03497d](https://github.com/patternfly/patternfly-react/commit/a03497d2dd748b8d16c140f8c33352d8c343bded))


### Features

* **Form): add form group label info & docs(Form:** add password strength demo ([#6053](https://github.com/patternfly/patternfly-react/issues/6053)) ([0f11c0a](https://github.com/patternfly/patternfly-react/commit/0f11c0ae719b0eba2bc4507b1e950bf18bd2667f))





# [4.144.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.143.2...@patternfly/react-core@4.144.0) (2021-07-30)


### Bug Fixes

* **Sidebar:** custom className override fix ([#6094](https://github.com/patternfly/patternfly-react/issues/6094)) ([5e4fe50](https://github.com/patternfly/patternfly-react/commit/5e4fe501eeb8a7d9d2c57dd0445a672efef018d3))


### Features

* **Accordion:** Added support for bordered, display large … ([#6085](https://github.com/patternfly/patternfly-react/issues/6085)) ([da59273](https://github.com/patternfly/patternfly-react/commit/da592733aaf8a147ae26ac4f319bda2f4010a65c))
* **ExpandableSection:** Added props to support disclosure variation ([#6078](https://github.com/patternfly/patternfly-react/issues/6078)) ([3e9aa7e](https://github.com/patternfly/patternfly-react/commit/3e9aa7eb985b560c8c899c00f1ced4b0221aded4))
* **Label:** add editable label ([#6065](https://github.com/patternfly/patternfly-react/issues/6065)) ([0ce5149](https://github.com/patternfly/patternfly-react/commit/0ce51496c467bc0eff0a987a7013bca60d4970bd))
* **Tabs:** support page insets ([#6087](https://github.com/patternfly/patternfly-react/issues/6087)) ([dcc4d0e](https://github.com/patternfly/patternfly-react/commit/dcc4d0e5b2493ed79933febc79287462bfebe6f5))





## [4.143.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.143.1...@patternfly/react-core@4.143.2) (2021-07-29)

**Note:** Version bump only for package @patternfly/react-core





## [4.143.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.143.0...@patternfly/react-core@4.143.1) (2021-07-29)

**Note:** Version bump only for package @patternfly/react-core





# [4.143.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.142.3...@patternfly/react-core@4.143.0) (2021-07-28)


### Features

* **Switch:** add isReversed prop/layout ([#6080](https://github.com/patternfly/patternfly-react/issues/6080)) ([f9a7284](https://github.com/patternfly/patternfly-react/commit/f9a7284e1eba98a7c561a54dc0f8b41eb86c0323))





## [4.142.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.142.2...@patternfly/react-core@4.142.3) (2021-07-28)

**Note:** Version bump only for package @patternfly/react-core





## [4.142.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.142.1...@patternfly/react-core@4.142.2) (2021-07-27)


### Bug Fixes

* **datepicker:** clear parse error on type ([#6066](https://github.com/patternfly/patternfly-react/issues/6066)) ([025d13b](https://github.com/patternfly/patternfly-react/commit/025d13b22d1802948439369bb2244e0253527569))





## [4.142.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.142.0...@patternfly/react-core@4.142.1) (2021-07-27)


### Bug Fixes

* **NotifcationDrawr:** show close button ([#6071](https://github.com/patternfly/patternfly-react/issues/6071)) ([905ce78](https://github.com/patternfly/patternfly-react/commit/905ce7805ff3254bd597bec46009e6af12c65799))





# [4.142.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.141.0...@patternfly/react-core@4.142.0) (2021-07-23)


### Features

* **menu:** context menu flyout ([#5789](https://github.com/patternfly/patternfly-react/issues/5789)) ([d9400ea](https://github.com/patternfly/patternfly-react/commit/d9400eab07553c1e219917cade343dcb87770ad3))





# [4.141.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.140.2...@patternfly/react-core@4.141.0) (2021-07-21)


### Features

* **button:** allow router link component ([#6061](https://github.com/patternfly/patternfly-react/issues/6061)) ([762c299](https://github.com/patternfly/patternfly-react/commit/762c299315b30af32096addce88b983319a5b834))





## [4.140.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.140.1...@patternfly/react-core@4.140.2) (2021-07-21)

**Note:** Version bump only for package @patternfly/react-core





## [4.140.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.140.0...@patternfly/react-core@4.140.1) (2021-07-21)


### Bug Fixes

* **TextInput:** fix warning about ouiaSafe property ([#6060](https://github.com/patternfly/patternfly-react/issues/6060)) ([99ce719](https://github.com/patternfly/patternfly-react/commit/99ce719f70f3e3020c8702a87b5c5354146474c7))





# [4.140.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.139.0...@patternfly/react-core@4.140.0) (2021-07-20)


### Bug Fixes

* **Checkbox:** fix warning about ouiaSafe property ([#6055](https://github.com/patternfly/patternfly-react/issues/6055)) ([a06c6c0](https://github.com/patternfly/patternfly-react/commit/a06c6c0f751cbb07ed5a95e233815a927a56833d))
* **Select:** check children have props before comparing them ([#6052](https://github.com/patternfly/patternfly-react/issues/6052)) ([fcc3b8c](https://github.com/patternfly/patternfly-react/commit/fcc3b8c393ccc06233cee772277d48bdeaf814d4))


### Features

* **avatar:** add border prop ([#6040](https://github.com/patternfly/patternfly-react/issues/6040)) ([65d7cdd](https://github.com/patternfly/patternfly-react/commit/65d7cddfb498562dde586e24df50f1030532eb4e))





# [4.139.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.138.0...@patternfly/react-core@4.139.0) (2021-07-20)


### Features

* **SearchInput:** Allow passing custom form elements after the attributes ([#6043](https://github.com/patternfly/patternfly-react/issues/6043)) ([dbc3c4f](https://github.com/patternfly/patternfly-react/commit/dbc3c4f39e262c7d744065eaf799276ab1b2194a))





# [4.138.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.137.0...@patternfly/react-core@4.138.0) (2021-07-19)


### Bug Fixes

* **datepicker:** change default parse format to y-m-d from y(-m)?(-d)? ([#6039](https://github.com/patternfly/patternfly-react/issues/6039)) ([998cd5b](https://github.com/patternfly/patternfly-react/commit/998cd5b4bf95396c0a8a23af75be87a48e546cc9))


### Features

* **Page:** Add tabs PageSection variant ([#6028](https://github.com/patternfly/patternfly-react/issues/6028)) ([0391207](https://github.com/patternfly/patternfly-react/commit/0391207f156cf870c392996a26c9fb34eb337b65))





# [4.137.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.136.1...@patternfly/react-core@4.137.0) (2021-07-16)


### Features

* **AlertGroup:** Make dynamic alerts more accessible ([#5946](https://github.com/patternfly/patternfly-react/issues/5946)) ([d29ae2f](https://github.com/patternfly/patternfly-react/commit/d29ae2f5296d0129e4623f98b9453af6a194248f))





## [4.136.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.136.0...@patternfly/react-core@4.136.1) (2021-07-15)


### Bug Fixes

* **TreeView:** console warning about uncontrolled inputs when checkbox swaps between determinate/indeterminate ([#6041](https://github.com/patternfly/patternfly-react/issues/6041)) ([074c8ce](https://github.com/patternfly/patternfly-react/commit/074c8ced8c37be39d7aac89ed3f283a0ae3f2da4))





# [4.136.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.15...@patternfly/react-core@4.136.0) (2021-07-15)


### Features

* **misc:** Keyboard handling helper ([#5972](https://github.com/patternfly/patternfly-react/issues/5972)) ([55cf40d](https://github.com/patternfly/patternfly-react/commit/55cf40d2f8beafd78ebbfb4fcd353198a18ab928))





## [4.135.15](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.14...@patternfly/react-core@4.135.15) (2021-07-14)

**Note:** Version bump only for package @patternfly/react-core





## [4.135.14](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.13...@patternfly/react-core@4.135.14) (2021-07-13)

**Note:** Version bump only for package @patternfly/react-core





## [4.135.13](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.12...@patternfly/react-core@4.135.13) (2021-07-13)

**Note:** Version bump only for package @patternfly/react-core





## [4.135.12](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.11...@patternfly/react-core@4.135.12) (2021-07-12)

**Note:** Version bump only for package @patternfly/react-core





## [4.135.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.10...@patternfly/react-core@4.135.11) (2021-07-09)

**Note:** Version bump only for package @patternfly/react-core





## [4.135.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.9...@patternfly/react-core@4.135.10) (2021-07-09)

**Note:** Version bump only for package @patternfly/react-core





## [4.135.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.8...@patternfly/react-core@4.135.9) (2021-07-09)


### Bug Fixes

* **Select:** Ignore arrow keys when typeahead options are empty ([#5958](https://github.com/patternfly/patternfly-react/issues/5958)) ([7ead1e8](https://github.com/patternfly/patternfly-react/commit/7ead1e8418d6d02b42dcd625ca3ff4fda3a83770))
* **TimePicker:** onInputChange is always set to valid ([#5982](https://github.com/patternfly/patternfly-react/issues/5982)) ([a5fcf76](https://github.com/patternfly/patternfly-react/commit/a5fcf76785772b11959be7cbb42cf02520d8a623))





## [4.135.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.7...@patternfly/react-core@4.135.8) (2021-07-09)


### Bug Fixes

* **Select:** check the values of the children for possible changes on componentDidUpdate ([#5973](https://github.com/patternfly/patternfly-react/issues/5973)) ([13b758e](https://github.com/patternfly/patternfly-react/commit/13b758e7531cfe00432da4cbc719c20fd074a371))





## [4.135.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.6...@patternfly/react-core@4.135.7) (2021-07-08)

**Note:** Version bump only for package @patternfly/react-core





## [4.135.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.5...@patternfly/react-core@4.135.6) (2021-07-07)


### Bug Fixes

* 🐛 Tooltip: clean up timeouts on unmount to prevent warning ([#5991](https://github.com/patternfly/patternfly-react/issues/5991)) ([e04c653](https://github.com/patternfly/patternfly-react/commit/e04c653cba2fd7cbdc9214ddd4e43ea2f6e8312f))





## [4.135.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.4...@patternfly/react-core@4.135.5) (2021-07-01)


### Bug Fixes

* **TimePicker:** Apply proper styles on Popper container ([#5960](https://github.com/patternfly/patternfly-react/issues/5960)) ([2275ac4](https://github.com/patternfly/patternfly-react/commit/2275ac4e40bbd1518b529837e33721980e6d9b31))





## [4.135.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.3...@patternfly/react-core@4.135.4) (2021-07-01)


### Bug Fixes

* **slider:** respect props in useCallback ([#5969](https://github.com/patternfly/patternfly-react/issues/5969)) ([8c671c4](https://github.com/patternfly/patternfly-react/commit/8c671c470af714f80e852afe8be20e608c80342d))





## [4.135.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.2...@patternfly/react-core@4.135.3) (2021-06-30)

**Note:** Version bump only for package @patternfly/react-core





## [4.135.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.1...@patternfly/react-core@4.135.2) (2021-06-30)


### Bug Fixes

* **ci:** change master branch to main ([4ac4129](https://github.com/patternfly/patternfly-react/commit/4ac4129e8da9a37367ea7612019f8d7af1ed8836))





## [4.135.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.135.0...@patternfly/react-core@4.135.1) (2021-06-28)

**Note:** Version bump only for package @patternfly/react-core





# [4.135.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.134.1...@patternfly/react-core@4.135.0) (2021-06-21)


### Features

* **HelperText:** add helper text component ([#5903](https://github.com/patternfly/patternfly-react/issues/5903)) ([188fa7f](https://github.com/patternfly/patternfly-react/commit/188fa7fe4c1d460357a96a35133944d4c5db93b3))
* **LogViewer:** Make logviewer responsive and change search result styling ([#5927](https://github.com/patternfly/patternfly-react/issues/5927)) ([3f6a493](https://github.com/patternfly/patternfly-react/commit/3f6a4934127d23de1baf2447003296600d9f3c5b))





## [4.134.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.134.0...@patternfly/react-core@4.134.1) (2021-06-18)

**Note:** Version bump only for package @patternfly/react-core





# [4.134.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.133.0...@patternfly/react-core@4.134.0) (2021-06-18)


### Features

* **Menu:** add scrollable support ([#5667](https://github.com/patternfly/patternfly-react/issues/5667)) ([fedaddf](https://github.com/patternfly/patternfly-react/commit/fedaddfc1bb8625f3aa0e881e575b1294312fa79))





# [4.133.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.132.0...@patternfly/react-core@4.133.0) (2021-06-18)


### Features

* **split:** added prop to allow children to wrap ([#5892](https://github.com/patternfly/patternfly-react/issues/5892)) ([a9d5cb4](https://github.com/patternfly/patternfly-react/commit/a9d5cb4089113dc3b1365d3f73e8e259719a8328))





# [4.132.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.131.1...@patternfly/react-core@4.132.0) (2021-06-18)


### Bug Fixes

* **DualListSelector:** add/remove all should respect filtering ([#5884](https://github.com/patternfly/patternfly-react/issues/5884)) ([46be375](https://github.com/patternfly/patternfly-react/commit/46be375d21a5c0ae422bfb89e67d8a2fc07a59b9))


### Features

* **Text:** Added support for visited link styling ([#5917](https://github.com/patternfly/patternfly-react/issues/5917)) ([b2167ed](https://github.com/patternfly/patternfly-react/commit/b2167ed94552c60d7cc4e143a467ca96eddfda21))





## [4.131.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.131.0...@patternfly/react-core@4.131.1) (2021-06-17)


### Bug Fixes

* **breadcrumb:** moved divider outside of header element ([#5870](https://github.com/patternfly/patternfly-react/issues/5870)) ([da0a7d2](https://github.com/patternfly/patternfly-react/commit/da0a7d25e8c926e861fea8a43ed36c76a01402ad))





# [4.131.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.130.0...@patternfly/react-core@4.131.0) (2021-06-17)


### Features

* **DualListSelector:** add tooltips to control buttons ([#5914](https://github.com/patternfly/patternfly-react/issues/5914)) ([1292479](https://github.com/patternfly/patternfly-react/commit/1292479e121f4eeaadb2f6954b24b0e68551dcd3))





# [4.130.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.129.1...@patternfly/react-core@4.130.0) (2021-06-17)


### Features

* **DescriptionList:** add responsive layout breakpoint property ([#5885](https://github.com/patternfly/patternfly-react/issues/5885)) ([0c51572](https://github.com/patternfly/patternfly-react/commit/0c5157247b7e9a19e0328b9c61e957071cfecb37))





## [4.129.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.129.0...@patternfly/react-core@4.129.1) (2021-06-17)

**Note:** Version bump only for package @patternfly/react-core





# [4.129.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.128.7...@patternfly/react-core@4.129.0) (2021-06-17)


### Features

* **Card:** Added support to remove offset from actions ([#5887](https://github.com/patternfly/patternfly-react/issues/5887)) ([6267210](https://github.com/patternfly/patternfly-react/commit/62672106007d93cf5061882b7325d9e73fceaed5))





## [4.128.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.128.6...@patternfly/react-core@4.128.7) (2021-06-16)


### Bug Fixes

* **TimePicker:** fix the returned values of the onChange method. ([#5868](https://github.com/patternfly/patternfly-react/issues/5868)) ([75d0cf9](https://github.com/patternfly/patternfly-react/commit/75d0cf98ca112839270f00e36372f42e76d0374e))





## [4.128.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.128.5...@patternfly/react-core@4.128.6) (2021-06-16)


### Bug Fixes

* **DatePicker, TimePicker:** Pass additional props to input ([#5848](https://github.com/patternfly/patternfly-react/issues/5848)) ([45b44b7](https://github.com/patternfly/patternfly-react/commit/45b44b7e1f9635f1d58ce0c27638564c126bc7b5))





## [4.128.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.128.4...@patternfly/react-core@4.128.5) (2021-06-15)


### Bug Fixes

* **Menu:** update tabIndex when children change ([#5923](https://github.com/patternfly/patternfly-react/issues/5923)) ([dcaa7d7](https://github.com/patternfly/patternfly-react/commit/dcaa7d7b5bf1b4aef7ccd93968a360e92e970a33))





## [4.128.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.128.3...@patternfly/react-core@4.128.4) (2021-06-11)


### Bug Fixes

* **select:** add some safety accessors ([#5902](https://github.com/patternfly/patternfly-react/issues/5902)) ([34b032b](https://github.com/patternfly/patternfly-react/commit/34b032be18987b507853a7a4c71ecca8a1ae6350))





## [4.128.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.128.2...@patternfly/react-core@4.128.3) (2021-06-10)

**Note:** Version bump only for package @patternfly/react-core





## [4.128.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.128.1...@patternfly/react-core@4.128.2) (2021-06-04)

**Note:** Version bump only for package @patternfly/react-core





## [4.128.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.128.0...@patternfly/react-core@4.128.1) (2021-06-02)

**Note:** Version bump only for package @patternfly/react-core





# [4.128.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.127.0...@patternfly/react-core@4.128.0) (2021-06-02)


### Features

* **Wizard:** allow for expandable nav items ([#5842](https://github.com/patternfly/patternfly-react/issues/5842)) ([2556754](https://github.com/patternfly/patternfly-react/commit/2556754770aa4008c8b2aef5a5f764d2382dbf9d))





# [4.127.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.126.2...@patternfly/react-core@4.127.0) (2021-06-02)


### Features

* **Menu:** filter tree demo ([#5824](https://github.com/patternfly/patternfly-react/issues/5824)) ([663f0f5](https://github.com/patternfly/patternfly-react/commit/663f0f5fc11ff1b5054e03c9c897b2ccc63f04b1))





## [4.126.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.126.1...@patternfly/react-core@4.126.2) (2021-06-01)

**Note:** Version bump only for package @patternfly/react-core





## [4.126.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.126.0...@patternfly/react-core@4.126.1) (2021-06-01)

**Note:** Version bump only for package @patternfly/react-core





# [4.126.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.125.0...@patternfly/react-core@4.126.0) (2021-05-27)


### Bug Fixes

* **timepicker:** don't spread validateTime ([#5850](https://github.com/patternfly/patternfly-react/issues/5850)) ([2fc0622](https://github.com/patternfly/patternfly-react/commit/2fc0622358b3a375e9e8875d9de457e27b7d236c))


### Features

* **grid+flex:** add ability to specify order ([#5274](https://github.com/patternfly/patternfly-react/issues/5274)) ([bd3fe3e](https://github.com/patternfly/patternfly-react/commit/bd3fe3e7609fed6d18f26db22984a5e857c631ca))
* **Tabs:** Added support for uncontrolled tabs ([#5831](https://github.com/patternfly/patternfly-react/issues/5831)) ([93a159f](https://github.com/patternfly/patternfly-react/commit/93a159f7116b96e422366ccdd397480b0c024cf2))





# [4.125.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.124.0...@patternfly/react-core@4.125.0) (2021-05-27)


### Features

* **select:** allow filtering in single variant ([#5793](https://github.com/patternfly/patternfly-react/issues/5793)) ([54d2e3f](https://github.com/patternfly/patternfly-react/commit/54d2e3f2858099ad096c520634bfdf260f880e3c))





# [4.124.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.123.2...@patternfly/react-core@4.124.0) (2021-05-27)


### Bug Fixes

* **SearchInput:** stop capturing browser focus on mount ([#5823](https://github.com/patternfly/patternfly-react/issues/5823)) ([043be45](https://github.com/patternfly/patternfly-react/commit/043be450a8e101b6db3d93a13ddef88e937d297d))


### Features

* **DescriptionList:** Added support for helpr text ([#5837](https://github.com/patternfly/patternfly-react/issues/5837)) ([80fc558](https://github.com/patternfly/patternfly-react/commit/80fc5583bc759c4fac0d87cd985d9f3baa3f7222))
* **Menu:** add footer, add view more demo ([#5791](https://github.com/patternfly/patternfly-react/issues/5791)) ([dfb53aa](https://github.com/patternfly/patternfly-react/commit/dfb53aaa0abab6f26ca7b5ff92c9f2c1ef39588c))





## [4.123.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.123.1...@patternfly/react-core@4.123.2) (2021-05-27)


### Bug Fixes

* **tooltip:** change default entry and exit delay ([#5746](https://github.com/patternfly/patternfly-react/issues/5746)) ([9f35132](https://github.com/patternfly/patternfly-react/commit/9f351324257ad29a79dc92a1659801e20766e0f8))





## [4.123.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.123.0...@patternfly/react-core@4.123.1) (2021-05-26)


### Bug Fixes

* **timepicker:** use exact match instead of includes ([#5841](https://github.com/patternfly/patternfly-react/issues/5841)) ([5aa08d4](https://github.com/patternfly/patternfly-react/commit/5aa08d47ce4894630fc4ac1f5491abe36f109dde))





# [4.123.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.122.1...@patternfly/react-core@4.123.0) (2021-05-26)


### Features

* **Button:** add danger modifier to link/secondary buttons ([#5808](https://github.com/patternfly/patternfly-react/issues/5808)) ([0fc56c4](https://github.com/patternfly/patternfly-react/commit/0fc56c4ef30b260a8c4d4268e8c2058826d5b9b8))





## [4.122.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.122.0...@patternfly/react-core@4.122.1) (2021-05-25)

**Note:** Version bump only for package @patternfly/react-core





# [4.122.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.121.4...@patternfly/react-core@4.122.0) (2021-05-25)


### Features

* **list:** added icons, plain, bordered ([#5796](https://github.com/patternfly/patternfly-react/issues/5796)) ([3f2cd16](https://github.com/patternfly/patternfly-react/commit/3f2cd16ffd195d67e3862c9a250a6e61fbfe4ce1))





## [4.121.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.121.3...@patternfly/react-core@4.121.4) (2021-05-24)

**Note:** Version bump only for package @patternfly/react-core





## [4.121.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.121.2...@patternfly/react-core@4.121.3) (2021-05-21)


### Bug Fixes

* **jumplinks:** check for stale DOM node ([#5812](https://github.com/patternfly/patternfly-react/issues/5812)) ([b7125a9](https://github.com/patternfly/patternfly-react/commit/b7125a9710b336213f4144773cf3b6be43536caf))





## [4.121.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.121.1...@patternfly/react-core@4.121.2) (2021-05-19)

**Note:** Version bump only for package @patternfly/react-core





## [4.121.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.121.0...@patternfly/react-core@4.121.1) (2021-05-17)


### Bug Fixes

* **Dropdown, Select:** fix focus on toggle after click off menu ([#5787](https://github.com/patternfly/patternfly-react/issues/5787)) ([65a522a](https://github.com/patternfly/patternfly-react/commit/65a522a6705788f1b15c4c59c89c653724b7757b))





# [4.121.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.120.0...@patternfly/react-core@4.121.0) (2021-05-13)


### Features

* **Select:** Added footer and view more options ([#5736](https://github.com/patternfly/patternfly-react/issues/5736)) ([607c436](https://github.com/patternfly/patternfly-react/commit/607c436cf840fce9f3db923135fede361bcd02c2))





# [4.120.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.119.2...@patternfly/react-core@4.120.0) (2021-05-12)


### Features

* **MenuToggle:** add menu toggle / Add composable menu POCs ([#5722](https://github.com/patternfly/patternfly-react/issues/5722)) ([20ae2dc](https://github.com/patternfly/patternfly-react/commit/20ae2dcacfbf60d4e648fb4ccdd1880cee9744bd))





## [4.119.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.119.1...@patternfly/react-core@4.119.2) (2021-05-11)


### Bug Fixes

* **Dropdown, Select:** fix scrollbar click closing menu ([#5766](https://github.com/patternfly/patternfly-react/issues/5766)) ([e349054](https://github.com/patternfly/patternfly-react/commit/e34905437479aa4914d14a43892e39b9bcdb6ae1))
* **togglegroup:** remove dividers, light variation, add compact ([#5762](https://github.com/patternfly/patternfly-react/issues/5762)) ([d5c8c31](https://github.com/patternfly/patternfly-react/commit/d5c8c31bb24f613687fcf5aa3213ee51a8007580))





## [4.119.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.119.0...@patternfly/react-core@4.119.1) (2021-05-10)


### Bug Fixes

* **DualListSelector:** fix bug with selecting single node in nested folder ([#5763](https://github.com/patternfly/patternfly-react/issues/5763)) ([4f5df48](https://github.com/patternfly/patternfly-react/commit/4f5df48e6d866f3f3bab951c6aae815825d3c3f4))





# [4.119.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.118.0...@patternfly/react-core@4.119.0) (2021-05-10)


### Features

* **Dropdown:** add alignment breakpoints, fix ref console warning ([#5734](https://github.com/patternfly/patternfly-react/issues/5734)) ([7bc72c1](https://github.com/patternfly/patternfly-react/commit/7bc72c1627a5d6156eebcc2c573a555f64219059))
* **Select:** Add flag to accept input values even if not in menu ([#5751](https://github.com/patternfly/patternfly-react/issues/5751)) ([6373bbf](https://github.com/patternfly/patternfly-react/commit/6373bbf3a1824424ebc54a13b154259da2aa6a54))





# [4.118.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.117.2...@patternfly/react-core@4.118.0) (2021-05-07)


### Features

* **Card:** add isToggleRightAligned prop ([#5723](https://github.com/patternfly/patternfly-react/issues/5723)) ([336c447](https://github.com/patternfly/patternfly-react/commit/336c447dd95f9759dd791032f52669ea2e97881f))





## [4.117.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.117.1...@patternfly/react-core@4.117.2) (2021-05-07)

**Note:** Version bump only for package @patternfly/react-core





## [4.117.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.117.0...@patternfly/react-core@4.117.1) (2021-05-07)

**Note:** Version bump only for package @patternfly/react-core





# [4.117.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.116.3...@patternfly/react-core@4.117.0) (2021-05-06)


### Bug Fixes

* **FileUpload:** allow user to override onClick ([#5689](https://github.com/patternfly/patternfly-react/issues/5689)) ([58f60e5](https://github.com/patternfly/patternfly-react/commit/58f60e5b7da3fd1d85d4023735efdca3eb4c058a))


### Features

* **Gallery:** add min/max widths at breakpoints ([#5735](https://github.com/patternfly/patternfly-react/issues/5735)) ([5b4e08d](https://github.com/patternfly/patternfly-react/commit/5b4e08db8deb46711780854c1eafc19b33613328))





## [4.116.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.116.2...@patternfly/react-core@4.116.3) (2021-05-06)

**Note:** Version bump only for package @patternfly/react-core





## [4.116.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.116.1...@patternfly/react-core@4.116.2) (2021-05-06)


### Bug Fixes

* **Accordion:** set button type, update prop extension ([#5688](https://github.com/patternfly/patternfly-react/issues/5688)) ([565c17e](https://github.com/patternfly/patternfly-react/commit/565c17e4936fbbe5c0a1148a45779be50789aa26))





## [4.116.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.116.0...@patternfly/react-core@4.116.1) (2021-05-05)


### Bug Fixes

* **packages:** check canUseDOM before using DOM ([#5733](https://github.com/patternfly/patternfly-react/issues/5733)) ([915f03e](https://github.com/patternfly/patternfly-react/commit/915f03e7b8107a2767cc0df9bc72ba7364524d5e))





# [4.116.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.115.6...@patternfly/react-core@4.116.0) (2021-05-04)


### Features

* **ToolbarItem:** add widths on breakpoints ([#5727](https://github.com/patternfly/patternfly-react/issues/5727)) ([2149190](https://github.com/patternfly/patternfly-react/commit/214919090ae02511f206aa799bae4660a82b21ce))





## [4.115.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.115.5...@patternfly/react-core@4.115.6) (2021-05-03)

**Note:** Version bump only for package @patternfly/react-core





## [4.115.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.115.4...@patternfly/react-core@4.115.5) (2021-05-03)

**Note:** Version bump only for package @patternfly/react-core





## [4.115.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.115.3...@patternfly/react-core@4.115.4) (2021-04-29)

**Note:** Version bump only for package @patternfly/react-core





## [4.115.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.115.2...@patternfly/react-core@4.115.3) (2021-04-26)

**Note:** Version bump only for package @patternfly/react-core





## [4.115.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.115.1...@patternfly/react-core@4.115.2) (2021-04-22)

**Note:** Version bump only for package @patternfly/react-core





## [4.115.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.115.0...@patternfly/react-core@4.115.1) (2021-04-21)

**Note:** Version bump only for package @patternfly/react-core





# [4.115.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.114.1...@patternfly/react-core@4.115.0) (2021-04-20)


### Features

* **Select:** Added invalid state to select ([#5675](https://github.com/patternfly/patternfly-react/issues/5675)) ([d222162](https://github.com/patternfly/patternfly-react/commit/d222162565605b4776b31901773827459bc2d9b5))





## [4.114.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.114.0...@patternfly/react-core@4.114.1) (2021-04-20)


### Bug Fixes

* **Toolbar:** Collapse expandable content when crossing breakpoint ([#5692](https://github.com/patternfly/patternfly-react/issues/5692)) ([73a0f60](https://github.com/patternfly/patternfly-react/commit/73a0f60ebb64235a1d63b7d01d15da324b790f14))





# [4.114.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.113.1...@patternfly/react-core@4.114.0) (2021-04-19)


### Features

* **DatePicker:** Add date and time range demo ([#5666](https://github.com/patternfly/patternfly-react/issues/5666)) ([982a0c3](https://github.com/patternfly/patternfly-react/commit/982a0c3eac7cde751bfe29fde822c6ad9ca9bb40))





## [4.113.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.113.0...@patternfly/react-core@4.113.1) (2021-04-16)

**Note:** Version bump only for package @patternfly/react-core





# [4.113.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.112.0...@patternfly/react-core@4.113.0) (2021-04-16)


### Features

* **Form:** Add stacked variant and section title ([#5621](https://github.com/patternfly/patternfly-react/issues/5621)) ([d69f902](https://github.com/patternfly/patternfly-react/commit/d69f90236fe967b2ac2a0ca38cc3469318705385))





# [4.112.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.111.0...@patternfly/react-core@4.112.0) (2021-04-16)


### Features

* **Table:** Add optional icons to tree table rows, add responsive view ([#5672](https://github.com/patternfly/patternfly-react/issues/5672)) ([7ecba96](https://github.com/patternfly/patternfly-react/commit/7ecba96a191798d01c7f9209a14a04f4a658d7bb))





# [4.111.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.110.1...@patternfly/react-core@4.111.0) (2021-04-16)


### Features

* **CodeBlock:** add component ([#5656](https://github.com/patternfly/patternfly-react/issues/5656)) ([8e85b41](https://github.com/patternfly/patternfly-react/commit/8e85b41dff4b68924796d38dc882902d354011c5))





## [4.110.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.110.0...@patternfly/react-core@4.110.1) (2021-04-16)

**Note:** Version bump only for package @patternfly/react-core





# [4.110.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.109.1...@patternfly/react-core@4.110.0) (2021-04-15)


### Features

* **ExpandableSection:** add detached variant, update tests ([#5643](https://github.com/patternfly/patternfly-react/issues/5643)) ([28bea0a](https://github.com/patternfly/patternfly-react/commit/28bea0afd738e5f0b9b656b0dac3920e2f1c5c9e))





## [4.109.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.109.0...@patternfly/react-core@4.109.1) (2021-04-15)


### Bug Fixes

* **workspace:** remove codecov ([#5683](https://github.com/patternfly/patternfly-react/issues/5683)) ([479d052](https://github.com/patternfly/patternfly-react/commit/479d052962409e75193ac341c04c2c3e3f5a723d))





# [4.109.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.108.0...@patternfly/react-core@4.109.0) (2021-04-15)


### Features

* **Select:** Added optional item count ([#5677](https://github.com/patternfly/patternfly-react/issues/5677)) ([f36235b](https://github.com/patternfly/patternfly-react/commit/f36235b93540845d144ea0cbf2c168c1a538ae73))





# [4.108.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.107.0...@patternfly/react-core@4.108.0) (2021-04-15)


### Features

* **Card:** add full-height and plain variation ([#5632](https://github.com/patternfly/patternfly-react/issues/5632)) ([f9344cd](https://github.com/patternfly/patternfly-react/commit/f9344cdd0349163211c3aeb041b5f862f0b8f29e)), closes [#5584](https://github.com/patternfly/patternfly-react/issues/5584) [#5582](https://github.com/patternfly/patternfly-react/issues/5582)
* **ClipboardCopy:** add inline variant ([#5629](https://github.com/patternfly/patternfly-react/issues/5629)) ([27a7f29](https://github.com/patternfly/patternfly-react/commit/27a7f29acf83371520de1f7f9ba56586ecbb8f10))





# [4.107.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.9...@patternfly/react-core@4.107.0) (2021-04-14)


### Features

* **TableText:** allow passing tooltipProps ([#5654](https://github.com/patternfly/patternfly-react/issues/5654)) ([d20f62f](https://github.com/patternfly/patternfly-react/commit/d20f62f4eb39aa1feb185992d86330592cc557dd))





## [4.106.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.8...@patternfly/react-core@4.106.9) (2021-04-14)

**Note:** Version bump only for package @patternfly/react-core





## [4.106.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.7...@patternfly/react-core@4.106.8) (2021-04-13)

**Note:** Version bump only for package @patternfly/react-core





## [4.106.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.6...@patternfly/react-core@4.106.7) (2021-04-13)

**Note:** Version bump only for package @patternfly/react-core





## [4.106.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.5...@patternfly/react-core@4.106.6) (2021-04-12)


### Bug Fixes

* **card:** add empty state to card demo ([#5605](https://github.com/patternfly/patternfly-react/issues/5605)) ([bdd25cb](https://github.com/patternfly/patternfly-react/commit/bdd25cbe6207b068de8fe023941a096371c3ee35))





## [4.106.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.4...@patternfly/react-core@4.106.5) (2021-04-09)


### Bug Fixes

* **select:** remove panel from select variants ([#5600](https://github.com/patternfly/patternfly-react/issues/5600)) ([edc9116](https://github.com/patternfly/patternfly-react/commit/edc91164829d302c07fb10231141fb1ca3a95462))
* **Wizard:** disable back button on first step for keyboard users ([#5623](https://github.com/patternfly/patternfly-react/issues/5623)) ([a97fc26](https://github.com/patternfly/patternfly-react/commit/a97fc269373832b1dc6ff033d0cf7858fe01337e))





## [4.106.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.3...@patternfly/react-core@4.106.4) (2021-04-08)

**Note:** Version bump only for package @patternfly/react-core





## [4.106.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.2...@patternfly/react-core@4.106.3) (2021-04-05)


### Bug Fixes

* **treeview:** add classname ([#5608](https://github.com/patternfly/patternfly-react/issues/5608)) ([6113739](https://github.com/patternfly/patternfly-react/commit/611373974d23e27819618057a6d1e50c0a070e8a))





## [4.106.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.1...@patternfly/react-core@4.106.2) (2021-04-01)


### Bug Fixes

* **nav:** don't call onExpand twice ([#5611](https://github.com/patternfly/patternfly-react/issues/5611)) ([2f6fcfd](https://github.com/patternfly/patternfly-react/commit/2f6fcfde6c183d3c351516b3b2061d36968d14a5))





## [4.106.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.106.0...@patternfly/react-core@4.106.1) (2021-03-29)


### Bug Fixes

* **Navigation:** Fixed so that the onExpand callback is fired ([#5595](https://github.com/patternfly/patternfly-react/issues/5595)) ([95ed773](https://github.com/patternfly/patternfly-react/commit/95ed7734e69b81ed7548f4125d320087b25d3b0c))





# [4.106.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.105.0...@patternfly/react-core@4.106.0) (2021-03-26)


### Features

* **Menu:** keyboard interaction first pass ([#5570](https://github.com/patternfly/patternfly-react/issues/5570)) ([f35afb4](https://github.com/patternfly/patternfly-react/commit/f35afb4d621c6f7f1c67b024b8dfaac4026ef7be))





# [4.105.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.104.0...@patternfly/react-core@4.105.0) (2021-03-26)


### Features

* **Form:** Added support for field groups ([#5569](https://github.com/patternfly/patternfly-react/issues/5569)) ([4110d58](https://github.com/patternfly/patternfly-react/commit/4110d587d17c3bf3dc51f5bfc447016c6aee2b46))





# [4.104.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.103.0...@patternfly/react-core@4.104.0) (2021-03-26)


### Features

* **Slider:** add isDisabled property ([#5524](https://github.com/patternfly/patternfly-react/issues/5524)) ([54ea9aa](https://github.com/patternfly/patternfly-react/commit/54ea9aa0f75f7c88f57e1d487066eeb29fabe267)), closes [#5496](https://github.com/patternfly/patternfly-react/issues/5496)





# [4.103.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.102.2...@patternfly/react-core@4.103.0) (2021-03-26)


### Features

* **Checkbox, Radio:** Added support for custom body content ([#5559](https://github.com/patternfly/patternfly-react/issues/5559)) ([49e7e1f](https://github.com/patternfly/patternfly-react/commit/49e7e1f5918f22378a5cfbd036fb80dc42b6e1ad))





## [4.102.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.102.1...@patternfly/react-core@4.102.2) (2021-03-25)


### Bug Fixes

* **alert:** do not return false in useEffect ([#5575](https://github.com/patternfly/patternfly-react/issues/5575)) ([e1772fa](https://github.com/patternfly/patternfly-react/commit/e1772fa407bb4b3f36d99eff62f85282b998f46c))





## [4.102.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.102.0...@patternfly/react-core@4.102.1) (2021-03-25)

**Note:** Version bump only for package @patternfly/react-core





# [4.102.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.10...@patternfly/react-core@4.102.0) (2021-03-25)


### Bug Fixes

* **pagination:** add titles.ofWord ([#5563](https://github.com/patternfly/patternfly-react/issues/5563)) ([0b26473](https://github.com/patternfly/patternfly-react/commit/0b26473149a486c5ddd90b52923f816d7fbdc588))


### Features

* **alert:** don't timeout if isMouseOver ([#5566](https://github.com/patternfly/patternfly-react/issues/5566)) ([26ed9f7](https://github.com/patternfly/patternfly-react/commit/26ed9f706ff41d3046d3960b5f8535631975569c))
* **textarea:** add auto resizing ([#5568](https://github.com/patternfly/patternfly-react/issues/5568)) ([4809e89](https://github.com/patternfly/patternfly-react/commit/4809e8988001a7246b25d662b7f8cf3df304389d))





## [4.101.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.9...@patternfly/react-core@4.101.10) (2021-03-24)

**Note:** Version bump only for package @patternfly/react-core





## [4.101.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.8...@patternfly/react-core@4.101.9) (2021-03-22)


### Bug Fixes

* **backgroundimage:** useEffect for id ([#5541](https://github.com/patternfly/patternfly-react/issues/5541)) ([3329544](https://github.com/patternfly/patternfly-react/commit/3329544facaea4c0631c089e33b4dee5c4cc8b73))





## [4.101.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.7...@patternfly/react-core@4.101.8) (2021-03-22)


### Bug Fixes

* **jumplinks:** add className prop ([#5553](https://github.com/patternfly/patternfly-react/issues/5553)) ([83a3973](https://github.com/patternfly/patternfly-react/commit/83a3973ee2b7b3b9918b0d63898665a99573240a))





## [4.101.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.6...@patternfly/react-core@4.101.7) (2021-03-18)


### Bug Fixes

* **Topology:** Fix for context sub menu placement ([#5546](https://github.com/patternfly/patternfly-react/issues/5546)) ([2e22720](https://github.com/patternfly/patternfly-react/commit/2e22720e6888dd5afaa16f39b80ded2d5107628b))





## [4.101.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.5...@patternfly/react-core@4.101.6) (2021-03-17)


### Bug Fixes

* **drawer:** dont initially render DrawerPanelContent ([#5543](https://github.com/patternfly/patternfly-react/issues/5543)) ([d07235d](https://github.com/patternfly/patternfly-react/commit/d07235de20d9c750fa6d8b6383bb14589f9276c7))





## [4.101.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.4...@patternfly/react-core@4.101.5) (2021-03-16)


### Bug Fixes

* **Switch:** fix error message regarding accessibility usage ([#5522](https://github.com/patternfly/patternfly-react/issues/5522)) ([ebf99fb](https://github.com/patternfly/patternfly-react/commit/ebf99fb3d027306133aa06cd422eaee1232780c5)), closes [#5521](https://github.com/patternfly/patternfly-react/issues/5521)





## [4.101.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.3...@patternfly/react-core@4.101.4) (2021-03-16)

**Note:** Version bump only for package @patternfly/react-core





## [4.101.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.2...@patternfly/react-core@4.101.3) (2021-03-09)

**Note:** Version bump only for package @patternfly/react-core





## [4.101.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.1...@patternfly/react-core@4.101.2) (2021-03-05)

**Note:** Version bump only for package @patternfly/react-core





## [4.101.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.101.0...@patternfly/react-core@4.101.1) (2021-03-04)

**Note:** Version bump only for package @patternfly/react-core





# [4.101.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.100.1...@patternfly/react-core@4.101.0) (2021-03-04)


### Features

* **SearchInput:** add isDisabled and clean up focus handling ([#5468](https://github.com/patternfly/patternfly-react/issues/5468)) ([05b1b3a](https://github.com/patternfly/patternfly-react/commit/05b1b3a803c053150966e89a635120474c12c300))





## [4.100.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.100.0...@patternfly/react-core@4.100.1) (2021-03-04)


### Bug Fixes

* **searchinput:** add searchInputMenuBody class ([#5518](https://github.com/patternfly/patternfly-react/issues/5518)) ([99f0512](https://github.com/patternfly/patternfly-react/commit/99f05123d28a7be887efd1921733fc2dc0bddd6d))





# [4.100.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.99.1...@patternfly/react-core@4.100.0) (2021-03-03)


### Bug Fixes

* **CalendarMonth:** fix selecting month in Popover for React 17 ([#5517](https://github.com/patternfly/patternfly-react/issues/5517)) ([508e0eb](https://github.com/patternfly/patternfly-react/commit/508e0ebea256f7e1554ee307b9d7aedcf0749e93))
* **datalist:** fix dragging in firefox ([#5505](https://github.com/patternfly/patternfly-react/issues/5505)) ([bfb6ec7](https://github.com/patternfly/patternfly-react/commit/bfb6ec7088929bbb1a4c3a3aeb21dfd9dc6fa24d))
* **Progress:** make proper usage of accessibility properties      ([#5470](https://github.com/patternfly/patternfly-react/issues/5470)) ([99709b4](https://github.com/patternfly/patternfly-react/commit/99709b418330d7cd32fe0affa70cf3f0e3d1cb27))
* **Radio, Checkbox:** Added standalone modifier when no label is provided ([#5513](https://github.com/patternfly/patternfly-react/issues/5513)) ([4e6273d](https://github.com/patternfly/patternfly-react/commit/4e6273db2cbf5e7a4f2a1fcfca3d706889ded5fe))


### Features

* **Drawer:** add gray and white panel background variants ([#5479](https://github.com/patternfly/patternfly-react/issues/5479)) ([2cddcb9](https://github.com/patternfly/patternfly-react/commit/2cddcb9d861c130d44c73f42eb93610d5dd5cfb2))
* **InputGroup:** add plain input group text variant ([#5478](https://github.com/patternfly/patternfly-react/issues/5478)) ([6f6d772](https://github.com/patternfly/patternfly-react/commit/6f6d7722604445d41b5361e99a14474e578851e9))





## [4.99.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.99.0...@patternfly/react-core@4.99.1) (2021-03-03)


### Bug Fixes

* **timepicker:** use different am/pm suffixes ([#5504](https://github.com/patternfly/patternfly-react/issues/5504)) ([7f0feee](https://github.com/patternfly/patternfly-react/commit/7f0feee330a23e11f950e5e3d521e1c7ea61b58a))





# [4.99.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.98.0...@patternfly/react-core@4.99.0) (2021-03-02)


### Features

* **TreeView:** add flag for expand/collapse all ([#5503](https://github.com/patternfly/patternfly-react/issues/5503)) ([b529adc](https://github.com/patternfly/patternfly-react/commit/b529adca780d185bc740056efe2f5b6826c0285b))





# [4.98.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.97.4...@patternfly/react-core@4.98.0) (2021-03-02)


### Features

* **LoginPage:** enable show or hide password ([#5481](https://github.com/patternfly/patternfly-react/issues/5481)) ([72317be](https://github.com/patternfly/patternfly-react/commit/72317be761ce61fd3cdd4d02536e5d4ea43e3604))





## [4.97.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.97.3...@patternfly/react-core@4.97.4) (2021-02-24)

**Note:** Version bump only for package @patternfly/react-core





## [4.97.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.97.2...@patternfly/react-core@4.97.3) (2021-02-18)

**Note:** Version bump only for package @patternfly/react-core





## [4.97.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.97.1...@patternfly/react-core@4.97.2) (2021-02-17)

**Note:** Version bump only for package @patternfly/react-core





## [4.97.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.97.0...@patternfly/react-core@4.97.1) (2021-02-16)

**Note:** Version bump only for package @patternfly/react-core





# [4.97.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.96.0...@patternfly/react-core@4.97.0) (2021-02-12)


### Features

* **SearchInput:** add advanced search feature ([#5454](https://github.com/patternfly/patternfly-react/issues/5454)) ([7099da1](https://github.com/patternfly/patternfly-react/commit/7099da1cb31fb9f5fb537b082365eabc42c2b95e))
* **Slider:** Added touch support ([#5453](https://github.com/patternfly/patternfly-react/issues/5453)) ([32ce723](https://github.com/patternfly/patternfly-react/commit/32ce7238d8743f6d4a5f7b128b1293e855d012ca))





# [4.96.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.95.1...@patternfly/react-core@4.96.0) (2021-02-12)


### Bug Fixes

* **Select:** fix typeahead variant not using the compareTo property for custom objects ([#5450](https://github.com/patternfly/patternfly-react/issues/5450)) ([5e1d81d](https://github.com/patternfly/patternfly-react/commit/5e1d81dfcb1a55ae93c209b8c1a7de05b7ed2f85)), closes [issue#4361](https://github.com/issue/issues/4361) [issue#5449](https://github.com/issue/issues/5449) [#5449](https://github.com/patternfly/patternfly-react/issues/5449) [#4361](https://github.com/patternfly/patternfly-react/issues/4361)


### Features

* **TreeView:** add keyboard interaction ([#5439](https://github.com/patternfly/patternfly-react/issues/5439)) ([fc094b9](https://github.com/patternfly/patternfly-react/commit/fc094b910517e6a42f2d88175557675572e89ae5))





## [4.95.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.95.0...@patternfly/react-core@4.95.1) (2021-02-11)

**Note:** Version bump only for package @patternfly/react-core





# [4.95.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.94.1...@patternfly/react-core@4.95.0) (2021-02-11)


### Features

* **Navigation:** Added support for spreading props to the NaveExpand… ([#5438](https://github.com/patternfly/patternfly-react/issues/5438)) ([e462fb8](https://github.com/patternfly/patternfly-react/commit/e462fb81dee60652027a985a4098a238a38a613a))





## [4.94.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.94.0...@patternfly/react-core@4.94.1) (2021-02-11)

**Note:** Version bump only for package @patternfly/react-core





# [4.94.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.93.3...@patternfly/react-core@4.94.0) (2021-02-11)


### Features

* **FormSelect:** added support for placeholder styled option ([#5428](https://github.com/patternfly/patternfly-react/issues/5428)) ([22217e9](https://github.com/patternfly/patternfly-react/commit/22217e9982f68dee541c3c9eb1138b4e2f369689))





## [4.93.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.93.2...@patternfly/react-core@4.93.3) (2021-02-11)

**Note:** Version bump only for package @patternfly/react-core





## [4.93.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.93.1...@patternfly/react-core@4.93.2) (2021-02-10)

**Note:** Version bump only for package @patternfly/react-core





## [4.93.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.93.0...@patternfly/react-core@4.93.1) (2021-02-10)

**Note:** Version bump only for package @patternfly/react-core





# [4.93.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.92.3...@patternfly/react-core@4.93.0) (2021-02-10)


### Features

* **Progress:** Add warning when title and aria-label not present ([#5415](https://github.com/patternfly/patternfly-react/issues/5415)) ([c2cb799](https://github.com/patternfly/patternfly-react/commit/c2cb799b19094c383bc103e63c91bcd6e27f1afb))





## [4.92.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.92.2...@patternfly/react-core@4.92.3) (2021-02-10)


### Bug Fixes

* **searchinput:** add bar class ([#5425](https://github.com/patternfly/patternfly-react/issues/5425)) ([1ac88c1](https://github.com/patternfly/patternfly-react/commit/1ac88c154bcf6b04ff9b692f8ebecb68e15d5c37))





## [4.92.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.92.1...@patternfly/react-core@4.92.2) (2021-02-10)


### Bug Fixes

* **selectmenu:** don't use focus trap when no tabbable children ([#5427](https://github.com/patternfly/patternfly-react/issues/5427)) ([ec98e73](https://github.com/patternfly/patternfly-react/commit/ec98e734b37bba933522fb363b0c48aa81ad3d61))





## [4.92.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.92.0...@patternfly/react-core@4.92.1) (2021-02-08)

**Note:** Version bump only for package @patternfly/react-core





# [4.92.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.91.0...@patternfly/react-core@4.92.0) (2021-02-03)


### Bug Fixes

* **datalist:** use drag-over modifier instead of css style ([#5119](https://github.com/patternfly/patternfly-react/issues/5119)) ([f7c5c27](https://github.com/patternfly/patternfly-react/commit/f7c5c2738aefe995bef7b60c77560da825830433))
* **Drawer:** enable touch controls for resizable drawer ([#5357](https://github.com/patternfly/patternfly-react/issues/5357)) ([27c539c](https://github.com/patternfly/patternfly-react/commit/27c539cf90d0c6cd818e0aad6a6df5741df66d90))
* **timepicker:** fix issue when clicking dropdown menu does not trigger onchange function ([#5399](https://github.com/patternfly/patternfly-react/issues/5399)) ([38db41e](https://github.com/patternfly/patternfly-react/commit/38db41e62fbbf8513a446e2d4de3b3d29c1e13dd))


### Features

* **searchInput:** add support to passing a ref ([#5215](https://github.com/patternfly/patternfly-react/issues/5215)) ([41af5d3](https://github.com/patternfly/patternfly-react/commit/41af5d34d5c80afade3c1c9ace9e07877b141149))





# [4.91.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.90.4...@patternfly/react-core@4.91.0) (2021-02-02)


### Bug Fixes

* **datepicker:** don't rely on toISOString ([#5369](https://github.com/patternfly/patternfly-react/issues/5369)) ([e7cf59d](https://github.com/patternfly/patternfly-react/commit/e7cf59dfe990e4b701e446a48b13f560b352607d))
* **wizard:** add cancel button class ([#5391](https://github.com/patternfly/patternfly-react/issues/5391)) ([8e2cc70](https://github.com/patternfly/patternfly-react/commit/8e2cc70f22010dbed3fb4b35e6345dfbb9d60c7e))


### Features

* **card:** add pf-m-display-lg and pf-m-rounded ([#5389](https://github.com/patternfly/patternfly-react/issues/5389)) ([2adb463](https://github.com/patternfly/patternfly-react/commit/2adb4630ef23035f90f3ea8cdb79e0c19c57b2d0))
* **spinner:** add isSVG ([#5390](https://github.com/patternfly/patternfly-react/issues/5390)) ([0114531](https://github.com/patternfly/patternfly-react/commit/01145311c6e50732691e3a43bc5dcc6b47026bc1))





## [4.90.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.90.3...@patternfly/react-core@4.90.4) (2021-02-01)


### Bug Fixes

* **Tooltip:** only add aria when tooltip is visible/in the DOM ([#5382](https://github.com/patternfly/patternfly-react/issues/5382)) ([10263d9](https://github.com/patternfly/patternfly-react/commit/10263d993ea781a1bf681816eeddce9fa7657670))





## [4.90.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.90.2...@patternfly/react-core@4.90.3) (2021-02-01)


### Bug Fixes

* **Select:** adjust Select component so that it also works with children changes while it's mounted ([#5375](https://github.com/patternfly/patternfly-react/issues/5375)) ([227da1d](https://github.com/patternfly/patternfly-react/commit/227da1dca3fdd108d411bb42c5021f0af3540fe9)), closes [#5365](https://github.com/patternfly/patternfly-react/issues/5365) [#5374](https://github.com/patternfly/patternfly-react/issues/5374)





## [4.90.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.90.1...@patternfly/react-core@4.90.2) (2021-01-27)

**Note:** Version bump only for package @patternfly/react-core





## [4.90.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.90.0...@patternfly/react-core@4.90.1) (2021-01-26)


### Bug Fixes

* **nav:** fix navitem tabindex casing ([#5376](https://github.com/patternfly/patternfly-react/issues/5376)) ([515fdb5](https://github.com/patternfly/patternfly-react/commit/515fdb534a0fd5a9d0b4a44f4bb73403b65477f0))





# [4.90.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.89.3...@patternfly/react-core@4.90.0) (2021-01-25)


### Features

* **Slider:** Added new slider component ([#5358](https://github.com/patternfly/patternfly-react/issues/5358)) ([90df385](https://github.com/patternfly/patternfly-react/commit/90df3850a0a602d14538faba98314405b12a786b))





## [4.89.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.89.2...@patternfly/react-core@4.89.3) (2021-01-25)


### Bug Fixes

* **drawer:** fix dragging problem on iframe when resizing drawer ([#5331](https://github.com/patternfly/patternfly-react/issues/5331)) ([746d43c](https://github.com/patternfly/patternfly-react/commit/746d43c3fee0600663489dfec6bcdde9076f9826))





## [4.89.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.89.1...@patternfly/react-core@4.89.2) (2021-01-25)


### Bug Fixes

* **Wizard:** add wizard demos to match core ([#5325](https://github.com/patternfly/patternfly-react/issues/5325)) ([85c354e](https://github.com/patternfly/patternfly-react/commit/85c354ede81155f6d336d0cd6b99de0cde05e59e))





## [4.89.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.89.0...@patternfly/react-core@4.89.1) (2021-01-22)


### Bug Fixes

* **Drawer:** initial width doesn't respect min/max widths ([#5313](https://github.com/patternfly/patternfly-react/issues/5313)) ([4f199c4](https://github.com/patternfly/patternfly-react/commit/4f199c4db5c3cb493d2947d871f687cc5527517c))





# [4.89.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.88.1...@patternfly/react-core@4.89.0) (2021-01-22)


### Features

* **Drawer:** improve cursor responsiveness ([#5328](https://github.com/patternfly/patternfly-react/issues/5328)) ([e1c44c7](https://github.com/patternfly/patternfly-react/commit/e1c44c74cb8d016b62782eb24d80abedb124365a))
* **SimpleList:** Uncontrolled Simple list support ([#5134](https://github.com/patternfly/patternfly-react/issues/5134)) ([690cf90](https://github.com/patternfly/patternfly-react/commit/690cf9090444edc3a5d3bb470edf25633b031f65))





## [4.88.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.88.0...@patternfly/react-core@4.88.1) (2021-01-19)


### Bug Fixes

* **Nav:** Make nav items keyboard and screen reader accessible ([#5312](https://github.com/patternfly/patternfly-react/issues/5312)) ([da90ef8](https://github.com/patternfly/patternfly-react/commit/da90ef8a8d5e653fd657decdddb795772e8b5309))





# [4.88.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.87.6...@patternfly/react-core@4.88.0) (2021-01-15)


### Bug Fixes

* **Wizard:** set a custom width to the wizard modal ([#5256](https://github.com/patternfly/patternfly-react/issues/5256)) ([22dd8f6](https://github.com/patternfly/patternfly-react/commit/22dd8f6518b37e45fec646b64bb9d58f188a7707))


### Features

* **ChipGroup:** Add event handler prop for overflow-chip click  ([#5272](https://github.com/patternfly/patternfly-react/issues/5272)) ([c4af7f1](https://github.com/patternfly/patternfly-react/commit/c4af7f17be30dbf86f4a9caf41acc29001b395db))





## [4.87.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.87.5...@patternfly/react-core@4.87.6) (2021-01-15)


### Bug Fixes

* **SearchInput:** hide clear button when onClear function is not set ([#5230](https://github.com/patternfly/patternfly-react/issues/5230)) ([df2e5e6](https://github.com/patternfly/patternfly-react/commit/df2e5e6011aae2205038027ced4de880c5cab71d))





## [4.87.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.87.4...@patternfly/react-core@4.87.5) (2021-01-12)


### Bug Fixes

* **primary-detail-demo:** enable static drawer open on mobile view ([#5311](https://github.com/patternfly/patternfly-react/issues/5311)) ([538a678](https://github.com/patternfly/patternfly-react/commit/538a6783f98cbc1a40bcf3300f6c0fc2a0057c7d))





## [4.87.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.87.3...@patternfly/react-core@4.87.4) (2021-01-11)

**Note:** Version bump only for package @patternfly/react-core





## [4.87.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.87.2...@patternfly/react-core@4.87.3) (2021-01-07)


### Bug Fixes

* **Toolbar:** add log viewer toolbar example ([#5196](https://github.com/patternfly/patternfly-react/issues/5196)) ([d951adc](https://github.com/patternfly/patternfly-react/commit/d951adce83ea6316a7a271a3e8ccb345b6cf73f5))





## [4.87.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.87.1...@patternfly/react-core@4.87.2) (2021-01-07)


### Bug Fixes

* **radio/checkbox:** show error message if id is missing ([#5292](https://github.com/patternfly/patternfly-react/issues/5292)) ([79ac5ba](https://github.com/patternfly/patternfly-react/commit/79ac5ba55ad714ce0b70368c42004a2d0aee9703))





## [4.87.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.87.0...@patternfly/react-core@4.87.1) (2021-01-07)

**Note:** Version bump only for package @patternfly/react-core





# [4.87.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.86.1...@patternfly/react-core@4.87.0) (2021-01-06)


### Features

* **packages:** use react 17 ([#5111](https://github.com/patternfly/patternfly-react/issues/5111)) ([7fbafcc](https://github.com/patternfly/patternfly-react/commit/7fbafcc947c95d2bda2f4fad8f7737cf7dd3fca6))





## [4.86.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.86.0...@patternfly/react-core@4.86.1) (2021-01-04)


### Bug Fixes

* **jumplinks:** allow hrefs with spaces ([#5223](https://github.com/patternfly/patternfly-react/issues/5223)) ([885185b](https://github.com/patternfly/patternfly-react/commit/885185b06ca56cbdf346ff4afda34a330fcc226e))





# [4.86.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.85.2...@patternfly/react-core@4.86.0) (2021-01-04)


### Features

* **ApplicationLauncher:** use favorites util, move util to helpers ([#5267](https://github.com/patternfly/patternfly-react/issues/5267)) ([5dfbc6b](https://github.com/patternfly/patternfly-react/commit/5dfbc6bd668629f9a17e21f2f47213b9e2e8fa2a))





## [4.85.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.85.1...@patternfly/react-core@4.85.2) (2021-01-04)


### Bug Fixes

* **dualListSelector:** do not pass custom handlers to root div ([#5308](https://github.com/patternfly/patternfly-react/issues/5308)) ([577dc02](https://github.com/patternfly/patternfly-react/commit/577dc02d24b2c9b6fff86407f5b22bf9c9c54923))





## [4.85.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.85.0...@patternfly/react-core@4.85.1) (2020-12-16)


### Bug Fixes

* **DualListSelector:** Add type=button to DualListSelectorListItem buttons ([#5266](https://github.com/patternfly/patternfly-react/issues/5266)) ([c251687](https://github.com/patternfly/patternfly-react/commit/c251687aa472e0138e213b95ce219c4267a38216))
* **Select:** fix crash when opened using Enter with disabled options ([#5258](https://github.com/patternfly/patternfly-react/issues/5258)) ([06f977f](https://github.com/patternfly/patternfly-react/commit/06f977fe363b3bd3c695c39fd96716167b403bc0)), closes [#5257](https://github.com/patternfly/patternfly-react/issues/5257)





# [4.85.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.84.4...@patternfly/react-core@4.85.0) (2020-12-16)


### Features

* **breadcrumb:** add render prop to breadcrumb item ([#5189](https://github.com/patternfly/patternfly-react/issues/5189)) ([492a950](https://github.com/patternfly/patternfly-react/commit/492a950c1fa6448e96a7beaa31dd3084d9a306e3))





## [4.84.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.84.3...@patternfly/react-core@4.84.4) (2020-12-15)

**Note:** Version bump only for package @patternfly/react-core





## [4.84.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.84.2...@patternfly/react-core@4.84.3) (2020-12-11)


### Bug Fixes

* **calendar-month:** rely on base styles from react-core/dist/styles/base.css ([#5251](https://github.com/patternfly/patternfly-react/issues/5251)) ([337a667](https://github.com/patternfly/patternfly-react/commit/337a667cf12e6b9f4c0eb98ac3176c6268db07b3))





## [4.84.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.84.1...@patternfly/react-core@4.84.2) (2020-12-10)

**Note:** Version bump only for package @patternfly/react-core





## [4.84.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.84.0...@patternfly/react-core@4.84.1) (2020-12-10)

**Note:** Version bump only for package @patternfly/react-core





# [4.84.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.83.3...@patternfly/react-core@4.84.0) (2020-12-10)


### Features

* **DualListSelector:** add support for trees and checkboxes ([#5207](https://github.com/patternfly/patternfly-react/issues/5207)) ([1533ad8](https://github.com/patternfly/patternfly-react/commit/1533ad8cbf99b132e8383c01e94a121023a4c9d7))
* **TimePicker:** Add basic time picker ([#5216](https://github.com/patternfly/patternfly-react/issues/5216)) ([e5f11a1](https://github.com/patternfly/patternfly-react/commit/e5f11a19b333703319bc55dd76814ae154bae187))





## [4.83.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.83.2...@patternfly/react-core@4.83.3) (2020-12-09)


### Bug Fixes

* **jumplinks:** add offset prop ([#5233](https://github.com/patternfly/patternfly-react/issues/5233)) ([6dd1d35](https://github.com/patternfly/patternfly-react/commit/6dd1d353bae4173056023c60757550372a2fa672))





## [4.83.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.83.1...@patternfly/react-core@4.83.2) (2020-12-08)

**Note:** Version bump only for package @patternfly/react-core





## [4.83.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.83.0...@patternfly/react-core@4.83.1) (2020-12-08)

**Note:** Version bump only for package @patternfly/react-core





# [4.83.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.82.2...@patternfly/react-core@4.83.0) (2020-12-08)


### Bug Fixes

* **descriptionList:** change autoMinFitModifier to autoFitMinModifier ([#5227](https://github.com/patternfly/patternfly-react/issues/5227)) ([fa85c81](https://github.com/patternfly/patternfly-react/commit/fa85c81030f9486335c6a2b9ae23bcaa1ce3ffa2))


### Features

* **alert:** add support to custom icon ([#5140](https://github.com/patternfly/patternfly-react/issues/5140)) ([3751cb5](https://github.com/patternfly/patternfly-react/commit/3751cb59d9bfd278ca811551ac8e16a2ebb2e243))





## [4.82.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.82.1...@patternfly/react-core@4.82.2) (2020-12-07)

**Note:** Version bump only for package @patternfly/react-core





## [4.82.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.82.0...@patternfly/react-core@4.82.1) (2020-12-07)


### Bug Fixes

* **textinput:** remove Button and React.Fragment from the ref example ([#5176](https://github.com/patternfly/patternfly-react/issues/5176)) ([2197f08](https://github.com/patternfly/patternfly-react/commit/2197f08151b94facec91b7fb23fb3e9245f7b10b))





# [4.82.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.81.1...@patternfly/react-core@4.82.0) (2020-12-07)


### Features

* **descriptionList:** add suport to auto fit ([#5113](https://github.com/patternfly/patternfly-react/issues/5113)) ([1434f9e](https://github.com/patternfly/patternfly-react/commit/1434f9ee930422532bc70c3bb5fb3dfc4d17eb1c))
* **textarea:** support isDisabled ([#5107](https://github.com/patternfly/patternfly-react/issues/5107)) ([9ebcfe9](https://github.com/patternfly/patternfly-react/commit/9ebcfe9b7b8719556c7b4430186010dd788744f1))





## [4.81.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.81.0...@patternfly/react-core@4.81.1) (2020-12-07)

**Note:** Version bump only for package @patternfly/react-core





# [4.81.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.80.2...@patternfly/react-core@4.81.0) (2020-12-04)


### Features

* **Drawer:** add splitter feature ([#5193](https://github.com/patternfly/patternfly-react/issues/5193)) ([7f44e90](https://github.com/patternfly/patternfly-react/commit/7f44e901d225068597c1b0efb6098f7c35a01476))





## [4.80.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.80.1...@patternfly/react-core@4.80.2) (2020-12-03)

**Note:** Version bump only for package @patternfly/react-core





## [4.80.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.80.0...@patternfly/react-core@4.80.1) (2020-12-02)

**Note:** Version bump only for package @patternfly/react-core





# [4.80.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.79.6...@patternfly/react-core@4.80.0) (2020-12-01)


### Features

* **react-core:** move react-datetime to react-core ([#5201](https://github.com/patternfly/patternfly-react/issues/5201)) ([a36d5d0](https://github.com/patternfly/patternfly-react/commit/a36d5d05a0a839cef5b8ab2790ef10ccd8b89d30))





## [4.79.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.79.5...@patternfly/react-core@4.79.6) (2020-11-30)

**Note:** Version bump only for package @patternfly/react-core





## [4.79.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.79.4...@patternfly/react-core@4.79.5) (2020-11-30)

**Note:** Version bump only for package @patternfly/react-core





## [4.79.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.79.3...@patternfly/react-core@4.79.4) (2020-11-23)

**Note:** Version bump only for package @patternfly/react-core





## [4.79.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.79.2...@patternfly/react-core@4.79.3) (2020-11-20)


### Bug Fixes

* **form-demo:** tidy form demo examples ([#5172](https://github.com/patternfly/patternfly-react/issues/5172)) ([4abb31e](https://github.com/patternfly/patternfly-react/commit/4abb31e457b217ab9b0af74efd74ac869678535f))





## [4.79.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.79.1...@patternfly/react-core@4.79.2) (2020-11-17)

**Note:** Version bump only for package @patternfly/react-core





## [4.79.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.79.0...@patternfly/react-core@4.79.1) (2020-11-17)

**Note:** Version bump only for package @patternfly/react-core





# [4.79.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.78.0...@patternfly/react-core@4.79.0) (2020-11-17)


### Bug Fixes

* **navigation:** move Page html demos to Navigation component ([#5109](https://github.com/patternfly/patternfly-react/issues/5109)) ([d37e774](https://github.com/patternfly/patternfly-react/commit/d37e77433a79004ea3d26b34a1dc365c969909f3))


### Features

* **DualListSelector:** add new component ([#5120](https://github.com/patternfly/patternfly-react/issues/5120)) ([0ed1c5a](https://github.com/patternfly/patternfly-react/commit/0ed1c5a0d530cbbba7f026660baec51f6fd03559))





# [4.78.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.77.1...@patternfly/react-core@4.78.0) (2020-11-17)


### Features

* **menu:** introduces new menu component ([#4847](https://github.com/patternfly/patternfly-react/issues/4847)) ([e867f09](https://github.com/patternfly/patternfly-react/commit/e867f093c5eef175b44cbb88e3ad229376de123f))





## [4.77.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.77.0...@patternfly/react-core@4.77.1) (2020-11-16)


### Bug Fixes

* **datepicker:** add calendar component ([#5026](https://github.com/patternfly/patternfly-react/issues/5026)) ([198dd0f](https://github.com/patternfly/patternfly-react/commit/198dd0fc202bdfa55ef9c9cc1a6721778f1dd265))





# [4.77.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.76.0...@patternfly/react-core@4.77.0) (2020-11-16)


### Features

* **Card:** add expandable card, move tests ([#5093](https://github.com/patternfly/patternfly-react/issues/5093)) ([0dd992c](https://github.com/patternfly/patternfly-react/commit/0dd992ca8d3aa998766bc750e6972ab5dab49910))
* **Touchspin:** add touchspin component ([#5115](https://github.com/patternfly/patternfly-react/issues/5115)) ([9dbe59a](https://github.com/patternfly/patternfly-react/commit/9dbe59acf457910ec8efa8280cbc33c952469724))





# [4.76.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.10...@patternfly/react-core@4.76.0) (2020-11-13)


### Features

* **demo:** add sticky bottom pagination to the card demo ([#5000](https://github.com/patternfly/patternfly-react/issues/5000)) ([883fbf6](https://github.com/patternfly/patternfly-react/commit/883fbf6d6304e8651d572ec4b7cd2af5a344fc85))
* **Toolbar:** add flag to match page insets ([#5098](https://github.com/patternfly/patternfly-react/issues/5098)) ([fb40278](https://github.com/patternfly/patternfly-react/commit/fb40278d7c5610cd735ab1a4976f3aea5b0be86a))





## [4.75.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.9...@patternfly/react-core@4.75.10) (2020-11-09)

**Note:** Version bump only for package @patternfly/react-core





## [4.75.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.8...@patternfly/react-core@4.75.9) (2020-11-05)

**Note:** Version bump only for package @patternfly/react-core





## [4.75.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.7...@patternfly/react-core@4.75.8) (2020-11-04)

**Note:** Version bump only for package @patternfly/react-core





## [4.75.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.6...@patternfly/react-core@4.75.7) (2020-10-30)

**Note:** Version bump only for package @patternfly/react-core





## [4.75.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.5...@patternfly/react-core@4.75.6) (2020-10-30)


### Bug Fixes

* **datalist:** respect isDisabled for dragging ([#5052](https://github.com/patternfly/patternfly-react/issues/5052)) ([a8039b0](https://github.com/patternfly/patternfly-react/commit/a8039b00c0a795282319c4a39006c8841c0ad39c))





## [4.75.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.4...@patternfly/react-core@4.75.5) (2020-10-29)


### Bug Fixes

* **docs:** add missing fieldId prop in sample code ([#5059](https://github.com/patternfly/patternfly-react/issues/5059)) ([95b7f0f](https://github.com/patternfly/patternfly-react/commit/95b7f0f12cb6e6c00c7c8fd1b637c06cb44411af))





## [4.75.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.3...@patternfly/react-core@4.75.4) (2020-10-29)

**Note:** Version bump only for package @patternfly/react-core





## [4.75.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.2...@patternfly/react-core@4.75.3) (2020-10-28)

**Note:** Version bump only for package @patternfly/react-core





## [4.75.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.1...@patternfly/react-core@4.75.2) (2020-10-26)

**Note:** Version bump only for package @patternfly/react-core





## [4.75.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.75.0...@patternfly/react-core@4.75.1) (2020-10-26)


### Bug Fixes

* **Alert, NotificationDrawer:** Added tooltips to truncated titles ([#5043](https://github.com/patternfly/patternfly-react/issues/5043)) ([eb77e52](https://github.com/patternfly/patternfly-react/commit/eb77e52337734f462f2ce5f5fd51fbbf3c4aef0e))





# [4.75.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.74.0...@patternfly/react-core@4.75.0) (2020-10-26)


### Features

* **DataList:** expose grid modifiers as properties ([#4969](https://github.com/patternfly/patternfly-react/issues/4969)) ([7e26b4e](https://github.com/patternfly/patternfly-react/commit/7e26b4e534ebe569f9fef0152c886014d2ddfcac)), closes [#4965](https://github.com/patternfly/patternfly-react/issues/4965)





# [4.74.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.73.0...@patternfly/react-core@4.74.0) (2020-10-23)


### Features

* **Form:** add FormAlert, isLimitWidth, and allow helper text above field ([#5036](https://github.com/patternfly/patternfly-react/issues/5036)) ([29eb4f3](https://github.com/patternfly/patternfly-react/commit/29eb4f3421b8452457008e9742b87692bbc32791))





# [4.73.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.72.0...@patternfly/react-core@4.73.0) (2020-10-23)


### Features

* **Pagination:** add sticky modifier flag ([#4977](https://github.com/patternfly/patternfly-react/issues/4977)) ([447772a](https://github.com/patternfly/patternfly-react/commit/447772a2ae1edd3db43fb8088377d72e10c77ade))





# [4.72.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.71.0...@patternfly/react-core@4.72.0) (2020-10-23)


### Features

* **DataList:** add expand/collapse all ([#5034](https://github.com/patternfly/patternfly-react/issues/5034)) ([9539481](https://github.com/patternfly/patternfly-react/commit/95394815cda979fe2317de78915447ed1d470296))





# [4.71.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.70.2...@patternfly/react-core@4.71.0) (2020-10-23)


### Features

* **Splitter:** add Splitter component ([#5051](https://github.com/patternfly/patternfly-react/issues/5051)) ([70073f2](https://github.com/patternfly/patternfly-react/commit/70073f27cf7833ebf4785887636ba6474f53de8b))





## [4.70.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.70.1...@patternfly/react-core@4.70.2) (2020-10-23)


### Bug Fixes

* **DataList:** add documentation for properties of DataList{DragButton, Control} ([#5047](https://github.com/patternfly/patternfly-react/issues/5047)) ([8988b47](https://github.com/patternfly/patternfly-react/commit/8988b4714e55db7e46d5ee1f118a58d71016f7f3)), closes [#5046](https://github.com/patternfly/patternfly-react/issues/5046)





## [4.70.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.70.0...@patternfly/react-core@4.70.1) (2020-10-22)

**Note:** Version bump only for package @patternfly/react-core





# [4.70.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.69.0...@patternfly/react-core@4.70.0) (2020-10-22)


### Features

* **Modal:** add help section to the modal header ([#5002](https://github.com/patternfly/patternfly-react/issues/5002)) ([6a2b79b](https://github.com/patternfly/patternfly-react/commit/6a2b79bf3b79652eeb11f89cb47225deeaa8aaee))





# [4.69.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.68.4...@patternfly/react-core@4.69.0) (2020-10-22)


### Features

* **ContextSelector:** add footer to selector ([#4976](https://github.com/patternfly/patternfly-react/issues/4976)) ([e2738d9](https://github.com/patternfly/patternfly-react/commit/e2738d9aa298787f238cebdaa64ac52f1c09b5fa))





## [4.68.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.68.3...@patternfly/react-core@4.68.4) (2020-10-22)


### Bug Fixes

* **ModalContent:** Remove duplicate pf-c-modal-box__title from ModalContent ([#4980](https://github.com/patternfly/patternfly-react/issues/4980)) ([c21ebcb](https://github.com/patternfly/patternfly-react/commit/c21ebcbd2aeb08df32f54a76e8592d1f6bb864b6)), closes [#4973](https://github.com/patternfly/patternfly-react/issues/4973)





## [4.68.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.68.2...@patternfly/react-core@4.68.3) (2020-10-22)


### Bug Fixes

* **Skeleton:** Add screen reader text to skeleton ([#5032](https://github.com/patternfly/patternfly-react/issues/5032)) ([c165bf3](https://github.com/patternfly/patternfly-react/commit/c165bf38f7ec2ba1bcbbdb52bb14a280597af43c))





## [4.68.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.68.1...@patternfly/react-core@4.68.2) (2020-10-22)

**Note:** Version bump only for package @patternfly/react-core





## [4.68.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.68.0...@patternfly/react-core@4.68.1) (2020-10-21)


### Bug Fixes

* **Dropdown:** test and update dropdown to work better in JAWS ([#4951](https://github.com/patternfly/patternfly-react/issues/4951)) ([22056fa](https://github.com/patternfly/patternfly-react/commit/22056fa435c12c1a0f1dd1d763eec9a093973b04))





# [4.68.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.67.0...@patternfly/react-core@4.68.0) (2020-10-20)


### Features

* **toggleGroup:** add suport to text + icon ([#4999](https://github.com/patternfly/patternfly-react/issues/4999)) ([ca606e4](https://github.com/patternfly/patternfly-react/commit/ca606e443d69c7ef8774185695a398df001abc57))





# [4.67.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.66.1...@patternfly/react-core@4.67.0) (2020-10-20)


### Bug Fixes

* **select:** display label and not value in typeahead ([#4916](https://github.com/patternfly/patternfly-react/issues/4916)) ([ea57b3f](https://github.com/patternfly/patternfly-react/commit/ea57b3f6c74189796362ec4ef17ab7119f4f0348))


### Features

* **alert:** support callback on alert timeout ([#5014](https://github.com/patternfly/patternfly-react/issues/5014)) ([909c3a7](https://github.com/patternfly/patternfly-react/commit/909c3a75d8c798b90be9bc791609aaec66825e80))





## [4.66.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.66.0...@patternfly/react-core@4.66.1) (2020-10-19)

**Note:** Version bump only for package @patternfly/react-core





# [4.66.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.65.0...@patternfly/react-core@4.66.0) (2020-10-19)


### Features

* **Empty state:** Added extra small variation ([#5012](https://github.com/patternfly/patternfly-react/issues/5012)) ([5ea4ab7](https://github.com/patternfly/patternfly-react/commit/5ea4ab758158697572bc9dc0dfd49528a25e5455))





# [4.65.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.64.7...@patternfly/react-core@4.65.0) (2020-10-19)


### Features

* **FormSection:** Add FormSection component ([#4971](https://github.com/patternfly/patternfly-react/issues/4971)) ([5e9106b](https://github.com/patternfly/patternfly-react/commit/5e9106b37f348038f2c7d37571e17427c610676e)), closes [#4960](https://github.com/patternfly/patternfly-react/issues/4960)





## [4.64.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.64.6...@patternfly/react-core@4.64.7) (2020-10-14)


### Bug Fixes

* **Label:** Added tooltip to truncated text ([#5007](https://github.com/patternfly/patternfly-react/issues/5007)) ([5881577](https://github.com/patternfly/patternfly-react/commit/58815776532aa0de61c63925746d06d226e061e6))
* **select:** skip the divider children in getDisplay ([#4998](https://github.com/patternfly/patternfly-react/issues/4998)) ([99fc494](https://github.com/patternfly/patternfly-react/commit/99fc494e636b12f1528e1956f33ff6327379bdb3))





## [4.64.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.64.5...@patternfly/react-core@4.64.6) (2020-10-13)


### Bug Fixes

* **LabelGroup:** should always contain pf-c-label-group__main ([#4970](https://github.com/patternfly/patternfly-react/issues/4970)) ([277c4a3](https://github.com/patternfly/patternfly-react/commit/277c4a339237b1745b340a37e30b3e894e539139)), closes [#4961](https://github.com/patternfly/patternfly-react/issues/4961)





## [4.64.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.64.4...@patternfly/react-core@4.64.5) (2020-10-12)


### Bug Fixes

* **datalist:** cancel moving for invalid drops ([#4996](https://github.com/patternfly/patternfly-react/issues/4996)) ([688f260](https://github.com/patternfly/patternfly-react/commit/688f260a63edb65e4ba5c05a1cdc607085cd77c9))





## [4.64.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.64.3...@patternfly/react-core@4.64.4) (2020-10-12)


### Bug Fixes

* **inputgroup:** allow string children ([#4963](https://github.com/patternfly/patternfly-react/issues/4963)) ([2f90073](https://github.com/patternfly/patternfly-react/commit/2f90073111e01c4c5597d04b2a337707881a33ec))





## [4.64.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.64.2...@patternfly/react-core@4.64.3) (2020-10-12)


### Bug Fixes

* **nav:** Fix ariaLabel not getting applied ([#4944](https://github.com/patternfly/patternfly-react/issues/4944)) ([7e0a7f1](https://github.com/patternfly/patternfly-react/commit/7e0a7f1ae8a2bd0e7c5df247bb05f70f55929243)), closes [#4507](https://github.com/patternfly/patternfly-react/issues/4507)





## [4.64.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.64.1...@patternfly/react-core@4.64.2) (2020-10-09)


### Bug Fixes

* **Tab:** Tab component properties don't show in the docs ([#4851](https://github.com/patternfly/patternfly-react/issues/4851)) ([3a774e9](https://github.com/patternfly/patternfly-react/commit/3a774e969430dc900ced7921d4452bfc9a8d0dc9)), closes [#4647](https://github.com/patternfly/patternfly-react/issues/4647)





## [4.64.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.64.0...@patternfly/react-core@4.64.1) (2020-10-09)

**Note:** Version bump only for package @patternfly/react-core





# [4.64.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.63.3...@patternfly/react-core@4.64.0) (2020-10-07)


### Features

* **TextArea:** support passing a ref ([#4953](https://github.com/patternfly/patternfly-react/issues/4953)) ([f8741dd](https://github.com/patternfly/patternfly-react/commit/f8741ddd49854ec1488cce0473a458619946a94d)), closes [#4894](https://github.com/patternfly/patternfly-react/issues/4894)





## [4.63.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.63.2...@patternfly/react-core@4.63.3) (2020-10-06)


### Bug Fixes

* **empty-state:** remove duplicate example, use title case ([#4954](https://github.com/patternfly/patternfly-react/issues/4954)) ([0e4a0c3](https://github.com/patternfly/patternfly-react/commit/0e4a0c30dcb9c253206d07fd44f769e7177929a5))





## [4.63.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.63.1...@patternfly/react-core@4.63.2) (2020-10-05)

**Note:** Version bump only for package @patternfly/react-core





## [4.63.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.63.0...@patternfly/react-core@4.63.1) (2020-10-05)


### Bug Fixes

* **datalist:** add ref to omit list ([#4948](https://github.com/patternfly/patternfly-react/issues/4948)) ([7f740df](https://github.com/patternfly/patternfly-react/commit/7f740df79c199a21fc8c7a02ccba88f7199b76b9))





# [4.63.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.62.0...@patternfly/react-core@4.63.0) (2020-10-05)


### Features

* **DataList:** add draggable feature for basic list ([#4852](https://github.com/patternfly/patternfly-react/issues/4852)) ([532fc5a](https://github.com/patternfly/patternfly-react/commit/532fc5add962b665a90362f45723252ccbc95e1d))





# [4.62.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.61.0...@patternfly/react-core@4.62.0) (2020-10-02)


### Features

* **Label:** Added support for React router ([#4934](https://github.com/patternfly/patternfly-react/issues/4934)) ([7f3a9ad](https://github.com/patternfly/patternfly-react/commit/7f3a9add2650cef8c8884ffdbaeb6663187775b0))





# [4.61.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.60.3...@patternfly/react-core@4.61.0) (2020-10-02)


### Features

* **DataList:** add support for text modifiers ([#4846](https://github.com/patternfly/patternfly-react/issues/4846)) ([4f4271b](https://github.com/patternfly/patternfly-react/commit/4f4271b2c20a869504339173c28300ed65cd7330)), closes [#4822](https://github.com/patternfly/patternfly-react/issues/4822)





## [4.60.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.60.2...@patternfly/react-core@4.60.3) (2020-10-02)

**Note:** Version bump only for package @patternfly/react-core





## [4.60.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.60.1...@patternfly/react-core@4.60.2) (2020-10-02)


### Bug Fixes

* **Select:** grouped Select generates invalid HTML ([#4919](https://github.com/patternfly/patternfly-react/issues/4919)) ([9986d51](https://github.com/patternfly/patternfly-react/commit/9986d5177c56a5454cb3ba0c26b74a748d352f2b)), closes [#4917](https://github.com/patternfly/patternfly-react/issues/4917)





## [4.60.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.60.0...@patternfly/react-core@4.60.1) (2020-10-02)

**Note:** Version bump only for package @patternfly/react-core





# [4.60.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.59.0...@patternfly/react-core@4.60.0) (2020-10-01)


### Features

* **DatePicker:** Add basic date picker ([#4888](https://github.com/patternfly/patternfly-react/issues/4888)) ([37bf1c2](https://github.com/patternfly/patternfly-react/commit/37bf1c2acc0dfdff57fa388fa9242ea578f0aeaf))
* **Modal:** add top align to modal ([#4871](https://github.com/patternfly/patternfly-react/issues/4871)) ([15da8a0](https://github.com/patternfly/patternfly-react/commit/15da8a08867899b20dc774aafcc6bfe458ac9ae0))





# [4.59.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.58.2...@patternfly/react-core@4.59.0) (2020-10-01)


### Bug Fixes

* **ToolTip/index.ts:** Exports TooltipProps as a type to help babel. ([#4854](https://github.com/patternfly/patternfly-react/issues/4854)) ([c7d4df2](https://github.com/patternfly/patternfly-react/commit/c7d4df24009290816e5394865ab6312710f9481b))


### Features

* **LabelGroup:** add label group main div for categories ([#4923](https://github.com/patternfly/patternfly-react/issues/4923)) ([9fb7046](https://github.com/patternfly/patternfly-react/commit/9fb7046fafc6b99c3442b77f488432bf1dc2e5e1))





## [4.58.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.58.1...@patternfly/react-core@4.58.2) (2020-10-01)


### Bug Fixes

* **page:** replace hasNoPadding property in the documentation example ([#4848](https://github.com/patternfly/patternfly-react/issues/4848)) ([0a5465e](https://github.com/patternfly/patternfly-react/commit/0a5465e2d8d93cfd4651d7f4225cccda114af110)), closes [#4856](https://github.com/patternfly/patternfly-react/issues/4856)





## [4.58.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.58.0...@patternfly/react-core@4.58.1) (2020-10-01)

**Note:** Version bump only for package @patternfly/react-core





# [4.58.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.57.4...@patternfly/react-core@4.58.0) (2020-09-30)


### Features

* **Progress:** added truncation ([#4842](https://github.com/patternfly/patternfly-react/issues/4842)) ([3b5f1ba](https://github.com/patternfly/patternfly-react/commit/3b5f1baba4a452abb45f48fb0968be703999dfd4))
* **Select:** Added support for Divider in Select ([#4772](https://github.com/patternfly/patternfly-react/issues/4772)) ([4071f6f](https://github.com/patternfly/patternfly-react/commit/4071f6fd70d55356f16eebfac9bac3c24af1ed8d))





## [4.57.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.57.3...@patternfly/react-core@4.57.4) (2020-09-30)

**Note:** Version bump only for package @patternfly/react-core





## [4.57.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.57.2...@patternfly/react-core@4.57.3) (2020-09-28)

**Note:** Version bump only for package @patternfly/react-core





## [4.57.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.57.1...@patternfly/react-core@4.57.2) (2020-09-28)

**Note:** Version bump only for package @patternfly/react-core





## [4.57.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.57.0...@patternfly/react-core@4.57.1) (2020-09-28)

**Note:** Version bump only for package @patternfly/react-core





# [4.57.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.56.0...@patternfly/react-core@4.57.0) (2020-09-25)


### Features

* **react-core-tabs:** add support for light scheme variant in Tabs && TabContent ([#4832](https://github.com/patternfly/patternfly-react/issues/4832)) ([8bf0619](https://github.com/patternfly/patternfly-react/commit/8bf0619bfd08bf4e7daa3c601ee178d1c1349e76)), closes [#4658](https://github.com/patternfly/patternfly-react/issues/4658)





# [4.56.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.55.1...@patternfly/react-core@4.56.0) (2020-09-25)


### Features

* **react-core-button:** add isLoading and spinnerAriaValueText properties ([#4837](https://github.com/patternfly/patternfly-react/issues/4837)) ([bc81323](https://github.com/patternfly/patternfly-react/commit/bc81323af97230879e1ee2d9b9db0f0bfea6dabd)), closes [#4816](https://github.com/patternfly/patternfly-react/issues/4816)





## [4.55.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.55.0...@patternfly/react-core@4.55.1) (2020-09-24)

**Note:** Version bump only for package @patternfly/react-core





# [4.55.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.54.0...@patternfly/react-core@4.55.0) (2020-09-24)


### Bug Fixes

* **demo-app:** replace CRA with webpack and ts-loader ([#4877](https://github.com/patternfly/patternfly-react/issues/4877)) ([1b64309](https://github.com/patternfly/patternfly-react/commit/1b6430943e14acf84fa54115b1a009930cf2372e))


### Features

* **select:** pass chip group props on typeaheadmulti variant ([#4855](https://github.com/patternfly/patternfly-react/issues/4855)) ([5d008a0](https://github.com/patternfly/patternfly-react/commit/5d008a025304e22182fd4072cf9a7ddd979c50cf))





# [4.54.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.53.2...@patternfly/react-core@4.54.0) (2020-09-23)


### Features

* **progress:** add warning variant ([#4834](https://github.com/patternfly/patternfly-react/issues/4834)) ([ff0b4fc](https://github.com/patternfly/patternfly-react/commit/ff0b4fc51f9b991aa2d389ee20d0eb3a7507314a)), closes [#4818](https://github.com/patternfly/patternfly-react/issues/4818)





## [4.53.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.53.1...@patternfly/react-core@4.53.2) (2020-09-23)


### Bug Fixes

* **react-docs:** change overview to get-started ([#4862](https://github.com/patternfly/patternfly-react/issues/4862)) ([b6b544f](https://github.com/patternfly/patternfly-react/commit/b6b544fa11e4645d46e927dcbb749e0a0ecfe78d))





## [4.53.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.53.0...@patternfly/react-core@4.53.1) (2020-09-23)

**Note:** Version bump only for package @patternfly/react-core





# [4.53.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.52.0...@patternfly/react-core@4.53.0) (2020-09-22)


### Features

* **workspace:** use new doc theme ([#4840](https://github.com/patternfly/patternfly-react/issues/4840)) ([7bf451d](https://github.com/patternfly/patternfly-react/commit/7bf451d468538cc0b301fb68f0c1a8108600c24f))





# [4.52.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.51.1...@patternfly/react-core@4.52.0) (2020-09-21)


### Bug Fixes

* **primary-detail-demo:** fixed component padding ([#4808](https://github.com/patternfly/patternfly-react/issues/4808)) ([534d241](https://github.com/patternfly/patternfly-react/commit/534d241b8bd1b00d0d3a50431160d70d819bfe08))


### Features

* **react-core-button:** support warning variant ([#4829](https://github.com/patternfly/patternfly-react/issues/4829)) ([6c5df2a](https://github.com/patternfly/patternfly-react/commit/6c5df2adfc78f128448ee7b7450c4bc9c054131f)), closes [#4717](https://github.com/patternfly/patternfly-react/issues/4717)





## [4.51.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.51.0...@patternfly/react-core@4.51.1) (2020-09-21)


### Bug Fixes

* **tabs:** conditionally render aria-controls when un/mountOnEnter ([#4796](https://github.com/patternfly/patternfly-react/issues/4796)) ([41d3d0e](https://github.com/patternfly/patternfly-react/commit/41d3d0e1d41c45ba2a7d18f4ab9c3bdca494a3e4))





# [4.51.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.50.2...@patternfly/react-core@4.51.0) (2020-09-21)


### Features

* **notificationDrawer:** add default variation to notification items ([#4792](https://github.com/patternfly/patternfly-react/issues/4792)) ([7f32482](https://github.com/patternfly/patternfly-react/commit/7f32482604191bcc1a22214f20d7da3ec03eb5bd))





## [4.50.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.50.1...@patternfly/react-core@4.50.2) (2020-09-18)


### Bug Fixes

* **DropdownToggleCheckbox:** indeterminate warning ([#4844](https://github.com/patternfly/patternfly-react/issues/4844)) ([64f5f5d](https://github.com/patternfly/patternfly-react/commit/64f5f5da19574aa9909ef7e8bc5429f7874095c8))





## [4.50.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.50.0...@patternfly/react-core@4.50.1) (2020-09-17)

**Note:** Version bump only for package @patternfly/react-core





# [4.50.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.49.1...@patternfly/react-core@4.50.0) (2020-09-16)


### Features

* **Select:** add support for favourites ([#4642](https://github.com/patternfly/patternfly-react/issues/4642)) ([acd748b](https://github.com/patternfly/patternfly-react/commit/acd748b06a34a54f65a63325f179c7751181cf9a))





## [4.49.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.49.0...@patternfly/react-core@4.49.1) (2020-09-15)


### Bug Fixes

* **Tabs:** Handle activeKey props update with mountOnEnter on Tabs ([#4806](https://github.com/patternfly/patternfly-react/issues/4806)) ([4d92313](https://github.com/patternfly/patternfly-react/commit/4d923139b78f9a692532131638fae276f6287485)), closes [#4805](https://github.com/patternfly/patternfly-react/issues/4805)





# [4.49.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.48.1...@patternfly/react-core@4.49.0) (2020-09-14)


### Features

* **Drawer:** add bottom panel variation ([#4771](https://github.com/patternfly/patternfly-react/issues/4771)) ([93f8fe4](https://github.com/patternfly/patternfly-react/commit/93f8fe4ec55323212fd1e2dc07986a9f10815bf3))
* **Skeleton:** add skeleton component, examples, tests ([#4755](https://github.com/patternfly/patternfly-react/issues/4755)) ([1f9a46e](https://github.com/patternfly/patternfly-react/commit/1f9a46ed8f9b3fa2bcef7fc580e7101f7aaef09c))
* **Toolbar:** add insets property ([#4757](https://github.com/patternfly/patternfly-react/issues/4757)) ([2d388af](https://github.com/patternfly/patternfly-react/commit/2d388afd22a243195dea56b502398a62a7138617))





## [4.48.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.48.0...@patternfly/react-core@4.48.1) (2020-09-11)


### Bug Fixes

* **page:** hide PageSideBar onClick on mobile when isManagedSidebar ([#4781](https://github.com/patternfly/patternfly-react/issues/4781)) ([00faa96](https://github.com/patternfly/patternfly-react/commit/00faa966158354663e2062bafb1e936865f1185f))





# [4.48.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.47.6...@patternfly/react-core@4.48.0) (2020-09-11)


### Features

* **Card:** add ability to customize card title and support heading element ([#4761](https://github.com/patternfly/patternfly-react/issues/4761)) ([215c566](https://github.com/patternfly/patternfly-react/commit/215c566057172a73772a514b3413dbdee0542263))





## [4.47.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.47.5...@patternfly/react-core@4.47.6) (2020-09-11)

**Note:** Version bump only for package @patternfly/react-core





## [4.47.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.47.4...@patternfly/react-core@4.47.5) (2020-09-10)

**Note:** Version bump only for package @patternfly/react-core





## [4.47.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.47.3...@patternfly/react-core@4.47.4) (2020-09-08)

**Note:** Version bump only for package @patternfly/react-core





## [4.47.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.47.2...@patternfly/react-core@4.47.3) (2020-09-04)

**Note:** Version bump only for package @patternfly/react-core





## [4.47.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.47.1...@patternfly/react-core@4.47.2) (2020-09-02)

**Note:** Version bump only for package @patternfly/react-core





## [4.47.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.47.0...@patternfly/react-core@4.47.1) (2020-08-28)

**Note:** Version bump only for package @patternfly/react-core





# [4.47.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.46.0...@patternfly/react-core@4.47.0) (2020-08-25)


### Bug Fixes

* **Page:** add missing tertiary nav demo, integration, and cypress test ([#4707](https://github.com/patternfly/patternfly-react/issues/4707)) ([1abca6d](https://github.com/patternfly/patternfly-react/commit/1abca6d09bd27459c8b3fc84c0f29040f3d33575))


### Features

* **Tile:** add tile component ([#4610](https://github.com/patternfly/patternfly-react/issues/4610)) ([a49c28f](https://github.com/patternfly/patternfly-react/commit/a49c28fbeefe2cabdf1be1e4f3e3633a3e01c0d2))
* **ToggleGroup:** add new toggle group component ([#4702](https://github.com/patternfly/patternfly-react/issues/4702)) ([4c00ae5](https://github.com/patternfly/patternfly-react/commit/4c00ae54da9df1a2560c8033464b91f97eac2ca7))
* **TreeView:** add treeview, demos, tests ([#4701](https://github.com/patternfly/patternfly-react/issues/4701)) ([1840aac](https://github.com/patternfly/patternfly-react/commit/1840aac8e5fe3b29e349e8cf615d8b914274a16b))





# [4.46.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.45.1...@patternfly/react-core@4.46.0) (2020-08-25)


### Features

* **modal:** add medium variant ([#4678](https://github.com/patternfly/patternfly-react/issues/4678)) ([203dd08](https://github.com/patternfly/patternfly-react/commit/203dd0802c630fa3979cf349e5308f8fe906c429))





## [4.45.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.45.0...@patternfly/react-core@4.45.1) (2020-08-25)


### Bug Fixes

* **search-input:** use title case id ([#4725](https://github.com/patternfly/patternfly-react/issues/4725)) ([2ccb235](https://github.com/patternfly/patternfly-react/commit/2ccb23515057dea80daf279bcecad005309d4903))





# [4.45.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.44.1...@patternfly/react-core@4.45.0) (2020-08-24)


### Features

* **alert,notificationdrawer:** add support to truncate title ([#4399](https://github.com/patternfly/patternfly-react/issues/4399)) ([1506bb8](https://github.com/patternfly/patternfly-react/commit/1506bb821921bf17f6191f0ce2a0fc7be975bdd2))





## [4.44.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.44.0...@patternfly/react-core@4.44.1) (2020-08-24)


### Bug Fixes

* **docs:** use ids and h3s ([#4720](https://github.com/patternfly/patternfly-react/issues/4720)) ([a3f684f](https://github.com/patternfly/patternfly-react/commit/a3f684fa23cfce3d8e79b86206773292790cec5c))





# [4.44.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.43.0...@patternfly/react-core@4.44.0) (2020-08-24)


### Features

* **Label:** add no overflow prop ([#4680](https://github.com/patternfly/patternfly-react/issues/4680)) ([e9dbde9](https://github.com/patternfly/patternfly-react/commit/e9dbde9a9325d37a7cc084527d01c56f667fab12))





# [4.43.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.42.0...@patternfly/react-core@4.43.0) (2020-08-24)


### Features

* **Page:** add width limit ([#4686](https://github.com/patternfly/patternfly-react/issues/4686)) ([16659fc](https://github.com/patternfly/patternfly-react/commit/16659fc9bd5c087d8f818d4a26c080cca5fcbe43))





# [4.42.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.41.1...@patternfly/react-core@4.42.0) (2020-08-24)


### Features

* **TextInput:** add helper util for left trim ([#4691](https://github.com/patternfly/patternfly-react/issues/4691)) ([44dba19](https://github.com/patternfly/patternfly-react/commit/44dba19f3ba357942484d69721bbdfe4ff4e81d8))





## [4.41.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.41.0...@patternfly/react-core@4.41.1) (2020-08-24)


### Bug Fixes

* **demo:** rename master detail demo to primary-detail ([#4703](https://github.com/patternfly/patternfly-react/issues/4703)) ([8a49a66](https://github.com/patternfly/patternfly-react/commit/8a49a66f89c2449f5ee4ccc337887e7dfd296e33)), closes [#4611](https://github.com/patternfly/patternfly-react/issues/4611)





# [4.41.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.40.6...@patternfly/react-core@4.41.0) (2020-08-21)


### Features

* **NotificationDrawer:** add formatHeaderText prop to support customize notification drawer header text ([#4684](https://github.com/patternfly/patternfly-react/issues/4684)) ([c11b4d0](https://github.com/patternfly/patternfly-react/commit/c11b4d0a9fd8e1d22cd60ccd89b54942a7026330))





## [4.40.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.40.5...@patternfly/react-core@4.40.6) (2020-08-21)

**Note:** Version bump only for package @patternfly/react-core





## [4.40.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.40.4...@patternfly/react-core@4.40.5) (2020-08-20)


### Bug Fixes

* **tabs:** add classNames to tab ([#4578](https://github.com/patternfly/patternfly-react/issues/4578)) ([53a3977](https://github.com/patternfly/patternfly-react/commit/53a397707c059234800dbe6ac57a684f632839b2))





## [4.40.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.40.3...@patternfly/react-core@4.40.4) (2020-08-17)

**Note:** Version bump only for package @patternfly/react-core





## [4.40.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.40.2...@patternfly/react-core@4.40.3) (2020-08-12)

**Note:** Version bump only for package @patternfly/react-core





## [4.40.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.40.1...@patternfly/react-core@4.40.2) (2020-08-10)

**Note:** Version bump only for package @patternfly/react-core





## [4.40.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.40.0...@patternfly/react-core@4.40.1) (2020-08-06)

**Note:** Version bump only for package @patternfly/react-core





# [4.40.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.39.0...@patternfly/react-core@4.40.0) (2020-08-05)


### Features

* **Select:** fix space/enter closing typeahead variants incorrectly ([#4663](https://github.com/patternfly/patternfly-react/issues/4663)) ([3635f26](https://github.com/patternfly/patternfly-react/commit/3635f26520af063a926c836c028d8dc896813415))





# [4.39.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.38.1...@patternfly/react-core@4.39.0) (2020-08-04)


### Features

* **NotificationDrawer:** Add notification drawer demo ([#4640](https://github.com/patternfly/patternfly-react/issues/4640)) ([3b9231d](https://github.com/patternfly/patternfly-react/commit/3b9231dab2fd92eb40e38d3a38ffb83562e1dbc2))





## [4.38.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.38.0...@patternfly/react-core@4.38.1) (2020-08-04)

**Note:** Version bump only for package @patternfly/react-core





# [4.38.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.37.0...@patternfly/react-core@4.38.0) (2020-08-03)


### Features

* **SearchInput:** add new SearchInput component ([#4588](https://github.com/patternfly/patternfly-react/issues/4588)) ([bca4005](https://github.com/patternfly/patternfly-react/commit/bca40058168bcdf79898ea638f95c0601a8d0e17))





# [4.37.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.36.0...@patternfly/react-core@4.37.0) (2020-08-03)


### Features

* **DescriptionList:** add new DescriptionList component ([#4586](https://github.com/patternfly/patternfly-react/issues/4586)) ([776aba7](https://github.com/patternfly/patternfly-react/commit/776aba7eef7b43585a841daf1e32d2e60693e34f))





# [4.36.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.35.1...@patternfly/react-core@4.36.0) (2020-08-03)


### Bug Fixes

* **Toolbar*:** change spelling of visiblity prop ([#4560](https://github.com/patternfly/patternfly-react/issues/4560)) ([cc17bf2](https://github.com/patternfly/patternfly-react/commit/cc17bf264a951017969615ebbba8cf6a05c8a5c9)), closes [#4555](https://github.com/patternfly/patternfly-react/issues/4555) [#4556](https://github.com/patternfly/patternfly-react/issues/4556)


### Features

* **NotificationBadge:** add needs attention state and count ([#4516](https://github.com/patternfly/patternfly-react/issues/4516)) ([63c7cbf](https://github.com/patternfly/patternfly-react/commit/63c7cbf0beed5497ca7addf7fc6663229f37ab81))





## [4.35.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.35.0...@patternfly/react-core@4.35.1) (2020-07-31)


### Bug Fixes

* **PageHeaderToolsItem:** fix breakpoint typo ([#4634](https://github.com/patternfly/patternfly-react/issues/4634)) ([779890c](https://github.com/patternfly/patternfly-react/commit/779890c9fc3535386c1322269c000ea4b11b0f5b))





# [4.35.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.34.2...@patternfly/react-core@4.35.0) (2020-07-29)


### Bug Fixes

* **expandable-section:** make children optional ([#4621](https://github.com/patternfly/patternfly-react/issues/4621)) ([5c52c59](https://github.com/patternfly/patternfly-react/commit/5c52c5970c4b9f233296977e86aaeddac9d0b1fb))
* **Toolbar:** deleteChip expects categoryKey as string ([#4553](https://github.com/patternfly/patternfly-react/issues/4553)) ([f49358c](https://github.com/patternfly/patternfly-react/commit/f49358c52c4193724747b55534bdc092b2ccf87f))


### Features

* **Select:** allow typeahead groups, fix few bugs around groups ([#4622](https://github.com/patternfly/patternfly-react/issues/4622)) ([dbacb9b](https://github.com/patternfly/patternfly-react/commit/dbacb9b37bf20dff7d7651650774fed4965c46f6))





## [4.34.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.34.1...@patternfly/react-core@4.34.2) (2020-07-29)


### Bug Fixes

* **wizard:** use new example title format ([#4628](https://github.com/patternfly/patternfly-react/issues/4628)) ([09dd6c5](https://github.com/patternfly/patternfly-react/commit/09dd6c551ba9ce5773608288b02309e3a0858780))





## [4.34.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.34.0...@patternfly/react-core@4.34.1) (2020-07-29)


### Bug Fixes

* **react-docs:** add missing imports ([#4627](https://github.com/patternfly/patternfly-react/issues/4627)) ([5b6250b](https://github.com/patternfly/patternfly-react/commit/5b6250b3ccfe26e0066b6ea1904dda43e172b487))





# [4.34.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.33.2...@patternfly/react-core@4.34.0) (2020-07-29)


### Features

* **wiz:** make wiz nav items more easily discoverable ([#4425](https://github.com/patternfly/patternfly-react/issues/4425)) ([92384d4](https://github.com/patternfly/patternfly-react/commit/92384d40cb4d5e3171c6922d00e391ed290239ac))





## [4.33.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.33.1...@patternfly/react-core@4.33.2) (2020-07-29)


### Bug Fixes

* **ClipboardCopy:** maintain line breaks & spaces when copying text ([#4619](https://github.com/patternfly/patternfly-react/issues/4619)) ([67f160f](https://github.com/patternfly/patternfly-react/commit/67f160f90eba77b8cced0d8f30cfff4a3274dc86))





## [4.33.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.33.0...@patternfly/react-core@4.33.1) (2020-07-29)


### Bug Fixes

* **pageheader:** use the correct type for the page context ([#4576](https://github.com/patternfly/patternfly-react/issues/4576)) ([2e9d1ad](https://github.com/patternfly/patternfly-react/commit/2e9d1ad9e3e5b983dce456eaf5a84c76cd8ce542))





# [4.33.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.14...@patternfly/react-core@4.33.0) (2020-07-28)


### Bug Fixes

* **Modal:** ensure getElement does not return null ([#4544](https://github.com/patternfly/patternfly-react/issues/4544)) ([358b0e2](https://github.com/patternfly/patternfly-react/commit/358b0e2a7b20fd87737359bb3f34ad717d0a8efe))
* **overflowmenu-dropdown-item:** allow to pass dropdown item props ([#4536](https://github.com/patternfly/patternfly-react/issues/4536)) ([4deab01](https://github.com/patternfly/patternfly-react/commit/4deab0164812edb90a0a12c8eeb7dedf5a1b4bb4))


### Features

* **Button:** add cta/large modifier ([#4596](https://github.com/patternfly/patternfly-react/issues/4596)) ([bc97c3c](https://github.com/patternfly/patternfly-react/commit/bc97c3cc059fc36f4ab201b1a77ee600c9983ba9))
* **Hint:** add hint components ([#4595](https://github.com/patternfly/patternfly-react/issues/4595)) ([7adfa83](https://github.com/patternfly/patternfly-react/commit/7adfa83e970f5b3ef49a28358405650367ecc4c9))





## [4.32.14](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.13...@patternfly/react-core@4.32.14) (2020-07-28)


### Bug Fixes

* **ChipGroup:** Add type button to overflow chip button ([#4608](https://github.com/patternfly/patternfly-react/issues/4608)) ([d135e8b](https://github.com/patternfly/patternfly-react/commit/d135e8bb81dde8a84aa9872eecd5650e30f6347e))





## [4.32.13](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.12...@patternfly/react-core@4.32.13) (2020-07-27)

**Note:** Version bump only for package @patternfly/react-core





## [4.32.12](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.11...@patternfly/react-core@4.32.12) (2020-07-27)


### Bug Fixes

* **NotificationDrawer:** fix accessibility issues and add accessibility test cases ([#4466](https://github.com/patternfly/patternfly-react/issues/4466)) ([d4cb0bb](https://github.com/patternfly/patternfly-react/commit/d4cb0bbe4381967713429a58c0f15d6190f3ceff))





## [4.32.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.10...@patternfly/react-core@4.32.11) (2020-07-23)

**Note:** Version bump only for package @patternfly/react-core





## [4.32.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.9...@patternfly/react-core@4.32.10) (2020-07-23)


### Bug Fixes

* **NavExpandable:** converts nav expandable to button ([#4512](https://github.com/patternfly/patternfly-react/issues/4512)) ([ead0266](https://github.com/patternfly/patternfly-react/commit/ead0266fe165d84ed4538772e3c48baf98508044))





## [4.32.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.8...@patternfly/react-core@4.32.9) (2020-07-23)


### Bug Fixes

* **demos:** fix demo headers and imports ([#4607](https://github.com/patternfly/patternfly-react/issues/4607)) ([a144ddd](https://github.com/patternfly/patternfly-react/commit/a144ddd2570408d419ea3526b5a588a4b5228569))





## [4.32.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.7...@patternfly/react-core@4.32.8) (2020-07-22)

**Note:** Version bump only for package @patternfly/react-core





## [4.32.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.6...@patternfly/react-core@4.32.7) (2020-07-21)


### Bug Fixes

* **Select:** use width prop in select ([#4579](https://github.com/patternfly/patternfly-react/issues/4579)) ([d23b5da](https://github.com/patternfly/patternfly-react/commit/d23b5da129c3661351bd539dd29ac5ce4e013ea5)), closes [#4509](https://github.com/patternfly/patternfly-react/issues/4509)





## [4.32.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.5...@patternfly/react-core@4.32.6) (2020-07-21)

**Note:** Version bump only for package @patternfly/react-core





## [4.32.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.4...@patternfly/react-core@4.32.5) (2020-07-20)

**Note:** Version bump only for package @patternfly/react-core





## [4.32.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.3...@patternfly/react-core@4.32.4) (2020-07-20)

**Note:** Version bump only for package @patternfly/react-core





## [4.32.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.2...@patternfly/react-core@4.32.3) (2020-07-20)

**Note:** Version bump only for package @patternfly/react-core





## [4.32.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.1...@patternfly/react-core@4.32.2) (2020-07-17)

**Note:** Version bump only for package @patternfly/react-core





## [4.32.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.32.0...@patternfly/react-core@4.32.1) (2020-07-16)

**Note:** Version bump only for package @patternfly/react-core





# [4.32.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.31.4...@patternfly/react-core@4.32.0) (2020-07-16)


### Features

* **FormGroup, FormSelect, TextInput, TextArea:** Add warning state ([#4554](https://github.com/patternfly/patternfly-react/issues/4554)) ([4e7f69a](https://github.com/patternfly/patternfly-react/commit/4e7f69a35abd247db99bd946a2c9bc931c335564))





## [4.31.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.31.3...@patternfly/react-core@4.31.4) (2020-07-15)


### Bug Fixes

* **Toolbar*:** change spelling of visiblity prop ([#4555](https://github.com/patternfly/patternfly-react/issues/4555)) ([c23659e](https://github.com/patternfly/patternfly-react/commit/c23659e65d03bda01426b53463c5a0e07b6926ec)), closes [#4501](https://github.com/patternfly/patternfly-react/issues/4501)





## [4.31.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.31.2...@patternfly/react-core@4.31.3) (2020-07-14)

**Note:** Version bump only for package @patternfly/react-core





## [4.31.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.31.1...@patternfly/react-core@4.31.2) (2020-07-14)

**Note:** Version bump only for package @patternfly/react-core





## [4.31.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.31.0...@patternfly/react-core@4.31.1) (2020-07-13)

**Note:** Version bump only for package @patternfly/react-core





# [4.31.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.30.1...@patternfly/react-core@4.31.0) (2020-07-10)


### Bug Fixes

* **select:** option with description on active display only value ([#4503](https://github.com/patternfly/patternfly-react/issues/4503)) ([eba354e](https://github.com/patternfly/patternfly-react/commit/eba354ecd67140b9165c60111c0df645c162ebfc))


### Features

* **Toolbar&OverflowMenu:** update docs to use OverflowMenu components ([#4459](https://github.com/patternfly/patternfly-react/issues/4459)) ([90246dc](https://github.com/patternfly/patternfly-react/commit/90246dc39fc92464dc70621c940be906ff621047))





## [4.30.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.30.0...@patternfly/react-core@4.30.1) (2020-07-10)


### Bug Fixes

* **expandable-section:** pass expandable value to onToggle ([#4427](https://github.com/patternfly/patternfly-react/issues/4427)) ([e016965](https://github.com/patternfly/patternfly-react/commit/e0169655dac62fc19890f6abae66a8eb98a25559))





# [4.30.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.29.0...@patternfly/react-core@4.30.0) (2020-07-10)


### Bug Fixes

* **drawer:** rename onMount to onExpand and add animation timeout ([#4508](https://github.com/patternfly/patternfly-react/issues/4508)) ([a908179](https://github.com/patternfly/patternfly-react/commit/a90817915d65201b3cf582665a19750dd9370019))


### Features

* **DataList:** Add support for action containers in DataList ([#4488](https://github.com/patternfly/patternfly-react/issues/4488)) ([386bedd](https://github.com/patternfly/patternfly-react/commit/386bedde711635627aecbf050273306958a746a2))
* **Dropdown:** add description to DropdownItem ([#4468](https://github.com/patternfly/patternfly-react/issues/4468)) ([0508fe6](https://github.com/patternfly/patternfly-react/commit/0508fe69999dfc25093102923dfef46275d35709))





# [4.29.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.28.1...@patternfly/react-core@4.29.0) (2020-07-10)


### Features

* **Alert:** Add alert timeout functionality ([#4510](https://github.com/patternfly/patternfly-react/issues/4510)) ([3e43126](https://github.com/patternfly/patternfly-react/commit/3e43126c5d7ec9205b4b746c55198f83a447bd9b))
* **Select:** fix typeahead button toggle propagation ([#4472](https://github.com/patternfly/patternfly-react/issues/4472)) ([8a574cf](https://github.com/patternfly/patternfly-react/commit/8a574cf36687f513e3bd7e4b4d64ce5ab1b53d87))





## [4.28.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.28.0...@patternfly/react-core@4.28.1) (2020-07-09)


### Bug Fixes

* **examples:** make the interactions in the demo more life-like ([#4492](https://github.com/patternfly/patternfly-react/issues/4492)) ([9503acf](https://github.com/patternfly/patternfly-react/commit/9503acfdfadced214938a6411aaf60380808b383))





# [4.28.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.27.5...@patternfly/react-core@4.28.0) (2020-07-08)


### Features

* **dropdownitem:** add support for styleChildren and document ([#4476](https://github.com/patternfly/patternfly-react/issues/4476)) ([5d99c06](https://github.com/patternfly/patternfly-react/commit/5d99c0668afd12fc79695851a1959ed3ce375c81))





## [4.27.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.27.4...@patternfly/react-core@4.27.5) (2020-07-08)

**Note:** Version bump only for package @patternfly/react-core





## [4.27.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.27.3...@patternfly/react-core@4.27.4) (2020-07-08)


### Bug Fixes

* **DrawerPanelContent:** don't render children when hidden ([#4500](https://github.com/patternfly/patternfly-react/issues/4500)) ([10c7480](https://github.com/patternfly/patternfly-react/commit/10c7480364121c21fa8bdd2fb737758d716acf06))





## [4.27.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.27.2...@patternfly/react-core@4.27.3) (2020-07-08)

**Note:** Version bump only for package @patternfly/react-core





## [4.27.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.27.1...@patternfly/react-core@4.27.2) (2020-07-07)

**Note:** Version bump only for package @patternfly/react-core





## [4.27.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.27.0...@patternfly/react-core@4.27.1) (2020-07-07)

**Note:** Version bump only for package @patternfly/react-core





# [4.27.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.26.0...@patternfly/react-core@4.27.0) (2020-07-06)


### Features

* **Select:** add option description property ([#4460](https://github.com/patternfly/patternfly-react/issues/4460)) ([bda22a3](https://github.com/patternfly/patternfly-react/commit/bda22a37f886a69504fab66da7f4827465552dc6))





# [4.26.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.25.0...@patternfly/react-core@4.26.0) (2020-07-06)


### Features

* **Select:** add logic to handle SelectOptionObject in comparisons ([#4469](https://github.com/patternfly/patternfly-react/issues/4469)) ([6179b52](https://github.com/patternfly/patternfly-react/commit/6179b524d59f50d373bbbe294897361f69ced598))





# [4.25.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.24.0...@patternfly/react-core@4.25.0) (2020-07-02)


### Bug Fixes

* **Select:** handle missing select group label ([#4464](https://github.com/patternfly/patternfly-react/issues/4464)) ([f29b8d9](https://github.com/patternfly/patternfly-react/commit/f29b8d90e8222ed5fcb0ca8918fd5ccf5e4160bc))


### Features

* **button:** add support to small variation ([#4433](https://github.com/patternfly/patternfly-react/issues/4433)) ([af9e292](https://github.com/patternfly/patternfly-react/commit/af9e292cd7ebd2752dfe7e220c28cf230bddb6d5))





# [4.24.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.23.1...@patternfly/react-core@4.24.0) (2020-06-25)


### Bug Fixes

* **alert:** add display name to the close action button ([#4426](https://github.com/patternfly/patternfly-react/issues/4426)) ([b5f6e9d](https://github.com/patternfly/patternfly-react/commit/b5f6e9de4cbcc960c2232bc000591dff584b9553))
* **OptionsMenu:** fix accessibility bug in plain with text disabled part ([#4424](https://github.com/patternfly/patternfly-react/issues/4424)) ([310738f](https://github.com/patternfly/patternfly-react/commit/310738f2802a0e0bfb8a923e29c448e9590edb4e))


### Features

* **Table:** adds sticky header prop and demo ([#4417](https://github.com/patternfly/patternfly-react/issues/4417)) ([6a58f1f](https://github.com/patternfly/patternfly-react/commit/6a58f1f91a6c4cde53be562b6e740e6fe33a8b33))





## [4.23.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.23.0...@patternfly/react-core@4.23.1) (2020-06-24)

**Note:** Version bump only for package @patternfly/react-core





# [4.23.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.22.3...@patternfly/react-core@4.23.0) (2020-06-23)


### Features

* **Banner:** clean up commit ([#4439](https://github.com/patternfly/patternfly-react/issues/4439)) ([4362966](https://github.com/patternfly/patternfly-react/commit/4362966766d57a70c1c97a242a0db71b4e104f8f))





## [4.22.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.22.2...@patternfly/react-core@4.22.3) (2020-06-22)

**Note:** Version bump only for package @patternfly/react-core





## [4.22.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.22.1...@patternfly/react-core@4.22.2) (2020-06-22)

**Note:** Version bump only for package @patternfly/react-core





## [4.22.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.22.0...@patternfly/react-core@4.22.1) (2020-06-19)

**Note:** Version bump only for package @patternfly/react-core





# [4.22.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.21.0...@patternfly/react-core@4.22.0) (2020-06-19)


### Bug Fixes

* **OptionsMenu:** fix accessibility issue in plain with text ([#4352](https://github.com/patternfly/patternfly-react/issues/4352)) ([2bcf204](https://github.com/patternfly/patternfly-react/commit/2bcf204e8b6c9ce56dd0824e0d317baea313f08d))


### Features

* **Banner:** add banner component ([#4408](https://github.com/patternfly/patternfly-react/issues/4408)) ([d783fc7](https://github.com/patternfly/patternfly-react/commit/d783fc708a6ed8e725af858b913ff9fbcfb742c6))





# [4.21.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.20.0...@patternfly/react-core@4.21.0) (2020-06-19)


### Features

* **Table:** Add inline editable dropdown ([#4262](https://github.com/patternfly/patternfly-react/issues/4262)) ([9cd5360](https://github.com/patternfly/patternfly-react/commit/9cd53600a7f7bcc786772ebae0dc8b2c579e782a))





# [4.20.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.19.0...@patternfly/react-core@4.20.0) (2020-06-19)


### Features

* **button:** add isAriaDisabled ([#3801](https://github.com/patternfly/patternfly-react/issues/3801)) ([a6ef254](https://github.com/patternfly/patternfly-react/commit/a6ef2545833f3cf6b98ad0736719975cc0a9c6dd))





# [4.19.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.20...@patternfly/react-core@4.19.0) (2020-06-19)


### Features

* **Divider:** Add support for insets to the Divider ([#4410](https://github.com/patternfly/patternfly-react/issues/4410)) ([32916b8](https://github.com/patternfly/patternfly-react/commit/32916b89fcf631eb498ae0b64faffec756242127))





## [4.18.20](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.19...@patternfly/react-core@4.18.20) (2020-06-18)


### Bug Fixes

* **Form:** Added .pf-c-form__group-control wrapper to .pf-c-form__actions ([#4405](https://github.com/patternfly/patternfly-react/issues/4405)) ([deed0d0](https://github.com/patternfly/patternfly-react/commit/deed0d0435a71b38e646dee1b767f7e86dc7d888))





## [4.18.19](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.18...@patternfly/react-core@4.18.19) (2020-06-17)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.18](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.17...@patternfly/react-core@4.18.18) (2020-06-17)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.17](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.16...@patternfly/react-core@4.18.17) (2020-06-17)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.16](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.15...@patternfly/react-core@4.18.16) (2020-06-16)


### Bug Fixes

* **Spinner:** className prop not getting applied properly ([#4380](https://github.com/patternfly/patternfly-react/issues/4380)) ([27330d5](https://github.com/patternfly/patternfly-react/commit/27330d5f531cbc046b68e584269c8651bc2068ed))





## [4.18.15](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.14...@patternfly/react-core@4.18.15) (2020-06-16)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.14](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.13...@patternfly/react-core@4.18.14) (2020-06-15)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.13](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.12...@patternfly/react-core@4.18.13) (2020-06-11)


### Bug Fixes

* **breadcrumb:** temp fix for spacing ([#4368](https://github.com/patternfly/patternfly-react/issues/4368)) ([7010497](https://github.com/patternfly/patternfly-react/commit/7010497c74efbd2dbf91629751dbf5d833c385ad))





## [4.18.12](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.11...@patternfly/react-core@4.18.12) (2020-06-11)


### Bug Fixes

* **NavExpandable:** add style.modifiers.expandable ([#4362](https://github.com/patternfly/patternfly-react/issues/4362)) ([eb5bc98](https://github.com/patternfly/patternfly-react/commit/eb5bc98f38e250e824e959c9619ee33b0c6210b2))





## [4.18.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.10...@patternfly/react-core@4.18.11) (2020-06-09)


### Bug Fixes

* **Drawer:** opening drawer can send focus to the drawer ([#4328](https://github.com/patternfly/patternfly-react/issues/4328)) ([fec328a](https://github.com/patternfly/patternfly-react/commit/fec328ab03bb1456e5eb685b5fe91b712c82ef5d))





## [4.18.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.9...@patternfly/react-core@4.18.10) (2020-06-09)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.8...@patternfly/react-core@4.18.9) (2020-06-09)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.7...@patternfly/react-core@4.18.8) (2020-06-08)


### Bug Fixes

* **OverflowMenu:** fix accessibility issue on KebabToggle button ([#4353](https://github.com/patternfly/patternfly-react/issues/4353)) ([3df7370](https://github.com/patternfly/patternfly-react/commit/3df73703cb7b380da5542aed505dcca5c28abf59))





## [4.18.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.6...@patternfly/react-core@4.18.7) (2020-06-08)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.5...@patternfly/react-core@4.18.6) (2020-06-08)


### Bug Fixes

* **Select:** fix filter clear button accessibility issue ([#4331](https://github.com/patternfly/patternfly-react/issues/4331)) ([d398f3e](https://github.com/patternfly/patternfly-react/commit/d398f3ec1fd1ebcf0fd74cc2816f1a1402d0d5d5))
* **Select:** fix panel issue ([#4340](https://github.com/patternfly/patternfly-react/issues/4340)) ([0e9c43b](https://github.com/patternfly/patternfly-react/commit/0e9c43b9c98f3afa7f58594abe717a862c8189d2))





## [4.18.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.4...@patternfly/react-core@4.18.5) (2020-06-05)


### Bug Fixes

* **docs:** add upgrade guide ([#4298](https://github.com/patternfly/patternfly-react/issues/4298)) ([4ee8805](https://github.com/patternfly/patternfly-react/commit/4ee8805ab9b232ebbe280313d4ae3e53bd78fb70))





## [4.18.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.3...@patternfly/react-core@4.18.4) (2020-06-05)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.2...@patternfly/react-core@4.18.3) (2020-06-05)


### Bug Fixes

* **ToolbarToggleGroup:** revert show to breakpoint ([#4343](https://github.com/patternfly/patternfly-react/issues/4343)) ([8c50170](https://github.com/patternfly/patternfly-react/commit/8c501709770b5e28e85f7db0bb64c3607d260c55))





## [4.18.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.1...@patternfly/react-core@4.18.2) (2020-06-03)

**Note:** Version bump only for package @patternfly/react-core





## [4.18.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.18.0...@patternfly/react-core@4.18.1) (2020-06-01)


### Bug Fixes

* **breakpoints:** make API consistent and appear in docs ([#4310](https://github.com/patternfly/patternfly-react/issues/4310)) ([ac1afa6](https://github.com/patternfly/patternfly-react/commit/ac1afa60067346c658fcb160534d9ddaf7dafbc6))





# [4.18.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.17.3...@patternfly/react-core@4.18.0) (2020-05-28)


### Features

* **Form:** remove semicolons from docs ([#4296](https://github.com/patternfly/patternfly-react/issues/4296)) ([c666474](https://github.com/patternfly/patternfly-react/commit/c666474bad1741fbd30c3ceccaa3eafc5187bd72))





## [4.17.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.17.2...@patternfly/react-core@4.17.3) (2020-05-27)


### Bug Fixes

* **loginpage:** basic example logo ([#4294](https://github.com/patternfly/patternfly-react/issues/4294)) ([e140178](https://github.com/patternfly/patternfly-react/commit/e140178f2378710c91e7667e9158b0b0f5c974ec))





## [4.17.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.17.1...@patternfly/react-core@4.17.2) (2020-05-26)


### Bug Fixes

* **wiz:** add missing label for wiz-in-modal ([#4280](https://github.com/patternfly/patternfly-react/issues/4280)) ([71a45d1](https://github.com/patternfly/patternfly-react/commit/71a45d122b20afddb9f2c99105f3603cbfc96bac))





## [4.17.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.17.0...@patternfly/react-core@4.17.1) (2020-05-21)


### Bug Fixes

* **nav:** fix expanding on new span icon ([#4275](https://github.com/patternfly/patternfly-react/issues/4275)) ([8c9c008](https://github.com/patternfly/patternfly-react/commit/8c9c0087b9a11e294d1d53ea47f2e28533a2b467))
* **util:** 3xl and 4xl breakpoint modifiers ([#4276](https://github.com/patternfly/patternfly-react/issues/4276)) ([6bd33d5](https://github.com/patternfly/patternfly-react/commit/6bd33d5a51288291f40b9a97bed12371b0fe92cc))





# [4.17.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.16.1...@patternfly/react-core@4.17.0) (2020-05-21)


### Features

* **drawer:** use the breakpoint mods prop instead of width props ([#4270](https://github.com/patternfly/patternfly-react/issues/4270)) ([4cac8d0](https://github.com/patternfly/patternfly-react/commit/4cac8d01ea771a7e8b082ca33242fcf590b861f8))





## [4.16.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.16.0...@patternfly/react-core@4.16.1) (2020-05-21)

**Note:** Version bump only for package @patternfly/react-core





# [4.16.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@4.15.0...@patternfly/react-core@4.16.0) (2020-05-19)


### Features

* **Select:** fix console warnings ([#4265](https://github.com/patternfly/patternfly-react/issues/4265)) ([109a53f](https://github.com/patternfly/patternfly-react/commit/109a53f9ff8d874cc5c7f429af7be8090d962dfe))





# [4.15.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.158.1...@patternfly/react-core@4.15.0) (2020-05-15)


### Features

* **master:** merge v4 ([#4255](https://github.com/patternfly/patternfly-react/issues/4255)) ([567c0b8](https://github.com/patternfly/patternfly-react/commit/567c0b88b10d2cd629ce380745a24dacdf9dd3d1)), closes [#3868](https://github.com/patternfly/patternfly-react/issues/3868) [#3915](https://github.com/patternfly/patternfly-react/issues/3915) [#3921](https://github.com/patternfly/patternfly-react/issues/3921) [#3872](https://github.com/patternfly/patternfly-react/issues/3872) [#3821](https://github.com/patternfly/patternfly-react/issues/3821) [#3807](https://github.com/patternfly/patternfly-react/issues/3807) [#3879](https://github.com/patternfly/patternfly-react/issues/3879) [#3871](https://github.com/patternfly/patternfly-react/issues/3871) [#3881](https://github.com/patternfly/patternfly-react/issues/3881) [#3826](https://github.com/patternfly/patternfly-react/issues/3826) [#3490](https://github.com/patternfly/patternfly-react/issues/3490) [#3882](https://github.com/patternfly/patternfly-react/issues/3882) [#3843](https://github.com/patternfly/patternfly-react/issues/3843) [#3884](https://github.com/patternfly/patternfly-react/issues/3884) [#3609](https://github.com/patternfly/patternfly-react/issues/3609) [#3880](https://github.com/patternfly/patternfly-react/issues/3880) [#3865](https://github.com/patternfly/patternfly-react/issues/3865) [#3894](https://github.com/patternfly/patternfly-react/issues/3894) [#3897](https://github.com/patternfly/patternfly-react/issues/3897) [#3892](https://github.com/patternfly/patternfly-react/issues/3892) [#3891](https://github.com/patternfly/patternfly-react/issues/3891) [#3908](https://github.com/patternfly/patternfly-react/issues/3908) [#3910](https://github.com/patternfly/patternfly-react/issues/3910) [#3861](https://github.com/patternfly/patternfly-react/issues/3861) [#3877](https://github.com/patternfly/patternfly-react/issues/3877) [#3916](https://github.com/patternfly/patternfly-react/issues/3916) [#3886](https://github.com/patternfly/patternfly-react/issues/3886) [#3872](https://github.com/patternfly/patternfly-react/issues/3872) [#3821](https://github.com/patternfly/patternfly-react/issues/3821) [#3807](https://github.com/patternfly/patternfly-react/issues/3807) [#3879](https://github.com/patternfly/patternfly-react/issues/3879) [#3871](https://github.com/patternfly/patternfly-react/issues/3871) [#3881](https://github.com/patternfly/patternfly-react/issues/3881) [#3826](https://github.com/patternfly/patternfly-react/issues/3826) [#3490](https://github.com/patternfly/patternfly-react/issues/3490) [#3882](https://github.com/patternfly/patternfly-react/issues/3882) [#3927](https://github.com/patternfly/patternfly-react/issues/3927) [#3933](https://github.com/patternfly/patternfly-react/issues/3933) [#3221](https://github.com/patternfly/patternfly-react/issues/3221) [#3873](https://github.com/patternfly/patternfly-react/issues/3873) [#3928](https://github.com/patternfly/patternfly-react/issues/3928) [#3929](https://github.com/patternfly/patternfly-react/issues/3929) [#2582](https://github.com/patternfly/patternfly-react/issues/2582) [#3296](https://github.com/patternfly/patternfly-react/issues/3296) [#3924](https://github.com/patternfly/patternfly-react/issues/3924) [#1529](https://github.com/patternfly/patternfly-react/issues/1529) [#3903](https://github.com/patternfly/patternfly-react/issues/3903) [#3904](https://github.com/patternfly/patternfly-react/issues/3904) [#3974](https://github.com/patternfly/patternfly-react/issues/3974) [#3970](https://github.com/patternfly/patternfly-react/issues/3970) [#3920](https://github.com/patternfly/patternfly-react/issues/3920) [#3945](https://github.com/patternfly/patternfly-react/issues/3945) [#3978](https://github.com/patternfly/patternfly-react/issues/3978) [#3962](https://github.com/patternfly/patternfly-react/issues/3962) [#3975](https://github.com/patternfly/patternfly-react/issues/3975) [#3906](https://github.com/patternfly/patternfly-react/issues/3906) [#3870](https://github.com/patternfly/patternfly-react/issues/3870) [#3958](https://github.com/patternfly/patternfly-react/issues/3958) [#3922](https://github.com/patternfly/patternfly-react/issues/3922) [#3985](https://github.com/patternfly/patternfly-react/issues/3985) [#3991](https://github.com/patternfly/patternfly-react/issues/3991) [#3872](https://github.com/patternfly/patternfly-react/issues/3872) [#3821](https://github.com/patternfly/patternfly-react/issues/3821) [#3807](https://github.com/patternfly/patternfly-react/issues/3807) [#3879](https://github.com/patternfly/patternfly-react/issues/3879) [#3871](https://github.com/patternfly/patternfly-react/issues/3871) [#3881](https://github.com/patternfly/patternfly-react/issues/3881) [#3826](https://github.com/patternfly/patternfly-react/issues/3826) [#3490](https://github.com/patternfly/patternfly-react/issues/3490) [#3882](https://github.com/patternfly/patternfly-react/issues/3882) [#3843](https://github.com/patternfly/patternfly-react/issues/3843) [#3884](https://github.com/patternfly/patternfly-react/issues/3884) [#3609](https://github.com/patternfly/patternfly-react/issues/3609) [#3880](https://github.com/patternfly/patternfly-react/issues/3880) [#3865](https://github.com/patternfly/patternfly-react/issues/3865) [#3894](https://github.com/patternfly/patternfly-react/issues/3894) [#3897](https://github.com/patternfly/patternfly-react/issues/3897) [#3892](https://github.com/patternfly/patternfly-react/issues/3892) [#3891](https://github.com/patternfly/patternfly-react/issues/3891) [#3908](https://github.com/patternfly/patternfly-react/issues/3908) [#3910](https://github.com/patternfly/patternfly-react/issues/3910) [#3861](https://github.com/patternfly/patternfly-react/issues/3861) [#3877](https://github.com/patternfly/patternfly-react/issues/3877) [#3916](https://github.com/patternfly/patternfly-react/issues/3916) [#3844](https://github.com/patternfly/patternfly-react/issues/3844) [#3919](https://github.com/patternfly/patternfly-react/issues/3919) [#3923](https://github.com/patternfly/patternfly-react/issues/3923) [#3838](https://github.com/patternfly/patternfly-react/issues/3838) [#3895](https://github.com/patternfly/patternfly-react/issues/3895) [#3896](https://github.com/patternfly/patternfly-react/issues/3896) [#3771](https://github.com/patternfly/patternfly-react/issues/3771) [#3940](https://github.com/patternfly/patternfly-react/issues/3940) [#3941](https://github.com/patternfly/patternfly-react/issues/3941) [#3441](https://github.com/patternfly/patternfly-react/issues/3441) [#3950](https://github.com/patternfly/patternfly-react/issues/3950) [#3642](https://github.com/patternfly/patternfly-react/issues/3642) [#3964](https://github.com/patternfly/patternfly-react/issues/3964) [#3968](https://github.com/patternfly/patternfly-react/issues/3968) [#3967](https://github.com/patternfly/patternfly-react/issues/3967) [#3971](https://github.com/patternfly/patternfly-react/issues/3971) [#3942](https://github.com/patternfly/patternfly-react/issues/3942) [#3898](https://github.com/patternfly/patternfly-react/issues/3898) [#3898](https://github.com/patternfly/patternfly-react/issues/3898) [#3976](https://github.com/patternfly/patternfly-react/issues/3976) [#3889](https://github.com/patternfly/patternfly-react/issues/3889) [#3641](https://github.com/patternfly/patternfly-react/issues/3641) [#3982](https://github.com/patternfly/patternfly-react/issues/3982) [#3979](https://github.com/patternfly/patternfly-react/issues/3979) [#3989](https://github.com/patternfly/patternfly-react/issues/3989) [#4017](https://github.com/patternfly/patternfly-react/issues/4017) [#4022](https://github.com/patternfly/patternfly-react/issues/4022) [#4014](https://github.com/patternfly/patternfly-react/issues/4014) [#4048](https://github.com/patternfly/patternfly-react/issues/4048) [#4050](https://github.com/patternfly/patternfly-react/issues/4050) [#4051](https://github.com/patternfly/patternfly-react/issues/4051) [#4058](https://github.com/patternfly/patternfly-react/issues/4058) [#4030](https://github.com/patternfly/patternfly-react/issues/4030) [#4031](https://github.com/patternfly/patternfly-react/issues/4031) [#3996](https://github.com/patternfly/patternfly-react/issues/3996) [#4001](https://github.com/patternfly/patternfly-react/issues/4001) [#4004](https://github.com/patternfly/patternfly-react/issues/4004) [#4066](https://github.com/patternfly/patternfly-react/issues/4066) [#4021](https://github.com/patternfly/patternfly-react/issues/4021) [#4061](https://github.com/patternfly/patternfly-react/issues/4061) [#4026](https://github.com/patternfly/patternfly-react/issues/4026) [#4069](https://github.com/patternfly/patternfly-react/issues/4069) [#4073](https://github.com/patternfly/patternfly-react/issues/4073) [#4036](https://github.com/patternfly/patternfly-react/issues/4036) [#4019](https://github.com/patternfly/patternfly-react/issues/4019) [#4081](https://github.com/patternfly/patternfly-react/issues/4081) [#4033](https://github.com/patternfly/patternfly-react/issues/4033) [#4065](https://github.com/patternfly/patternfly-react/issues/4065) [#4078](https://github.com/patternfly/patternfly-react/issues/4078) [#4032](https://github.com/patternfly/patternfly-react/issues/4032) [#4029](https://github.com/patternfly/patternfly-react/issues/4029) [#4064](https://github.com/patternfly/patternfly-react/issues/4064) [#4063](https://github.com/patternfly/patternfly-react/issues/4063) [#2593](https://github.com/patternfly/patternfly-react/issues/2593) [#4076](https://github.com/patternfly/patternfly-react/issues/4076) [#4099](https://github.com/patternfly/patternfly-react/issues/4099) [#4038](https://github.com/patternfly/patternfly-react/issues/4038) [#4116](https://github.com/patternfly/patternfly-react/issues/4116) [#3960](https://github.com/patternfly/patternfly-react/issues/3960) [#4121](https://github.com/patternfly/patternfly-react/issues/4121) [#4123](https://github.com/patternfly/patternfly-react/issues/4123) [#4025](https://github.com/patternfly/patternfly-react/issues/4025) [#4126](https://github.com/patternfly/patternfly-react/issues/4126) [#4122](https://github.com/patternfly/patternfly-react/issues/4122) [#4086](https://github.com/patternfly/patternfly-react/issues/4086) [#4127](https://github.com/patternfly/patternfly-react/issues/4127) [#4129](https://github.com/patternfly/patternfly-react/issues/4129) [#4111](https://github.com/patternfly/patternfly-react/issues/4111) [#4136](https://github.com/patternfly/patternfly-react/issues/4136) [#4138](https://github.com/patternfly/patternfly-react/issues/4138) [#4141](https://github.com/patternfly/patternfly-react/issues/4141) [#4145](https://github.com/patternfly/patternfly-react/issues/4145) [#4034](https://github.com/patternfly/patternfly-react/issues/4034) [#4144](https://github.com/patternfly/patternfly-react/issues/4144) [#4152](https://github.com/patternfly/patternfly-react/issues/4152) [#4158](https://github.com/patternfly/patternfly-react/issues/4158) [#4157](https://github.com/patternfly/patternfly-react/issues/4157) [#4156](https://github.com/patternfly/patternfly-react/issues/4156) [#4147](https://github.com/patternfly/patternfly-react/issues/4147) [#4159](https://github.com/patternfly/patternfly-react/issues/4159) [#4170](https://github.com/patternfly/patternfly-react/issues/4170) [#4142](https://github.com/patternfly/patternfly-react/issues/4142) [#4175](https://github.com/patternfly/patternfly-react/issues/4175) [#4176](https://github.com/patternfly/patternfly-react/issues/4176) [#4187](https://github.com/patternfly/patternfly-react/issues/4187) [#4188](https://github.com/patternfly/patternfly-react/issues/4188) [#4140](https://github.com/patternfly/patternfly-react/issues/4140) [#4193](https://github.com/patternfly/patternfly-react/issues/4193) [#4154](https://github.com/patternfly/patternfly-react/issues/4154) [#4192](https://github.com/patternfly/patternfly-react/issues/4192) [#4190](https://github.com/patternfly/patternfly-react/issues/4190) [#4199](https://github.com/patternfly/patternfly-react/issues/4199) [#4133](https://github.com/patternfly/patternfly-react/issues/4133) [#4165](https://github.com/patternfly/patternfly-react/issues/4165) [#4208](https://github.com/patternfly/patternfly-react/issues/4208) [#4212](https://github.com/patternfly/patternfly-react/issues/4212) [#4130](https://github.com/patternfly/patternfly-react/issues/4130) [#4219](https://github.com/patternfly/patternfly-react/issues/4219) [#4166](https://github.com/patternfly/patternfly-react/issues/4166) [#4202](https://github.com/patternfly/patternfly-react/issues/4202) [#4216](https://github.com/patternfly/patternfly-react/issues/4216) [#4225](https://github.com/patternfly/patternfly-react/issues/4225) [#4221](https://github.com/patternfly/patternfly-react/issues/4221) [#4146](https://github.com/patternfly/patternfly-react/issues/4146) [#3951](https://github.com/patternfly/patternfly-react/issues/3951) [#3681](https://github.com/patternfly/patternfly-react/issues/3681) [#4243](https://github.com/patternfly/patternfly-react/issues/4243) [#4220](https://github.com/patternfly/patternfly-react/issues/4220) [#4153](https://github.com/patternfly/patternfly-react/issues/4153) [#4209](https://github.com/patternfly/patternfly-react/issues/4209) [#4249](https://github.com/patternfly/patternfly-react/issues/4249) [#4239](https://github.com/patternfly/patternfly-react/issues/4239) [#4247](https://github.com/patternfly/patternfly-react/issues/4247) [#4246](https://github.com/patternfly/patternfly-react/issues/4246) [#3684](https://github.com/patternfly/patternfly-react/issues/3684) [#4223](https://github.com/patternfly/patternfly-react/issues/4223) [#4195](https://github.com/patternfly/patternfly-react/issues/4195) [#4254](https://github.com/patternfly/patternfly-react/issues/4254)
* **packages:** bump core to 4.10.21 ([#4257](https://github.com/patternfly/patternfly-react/issues/4257)) ([2e2676c](https://github.com/patternfly/patternfly-react/commit/2e2676ce6bc34f5e20231ca066d26ea4c3ac95e4))





## [3.158.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.158.0...@patternfly/react-core@3.158.1) (2020-05-11)

**Note:** Version bump only for package @patternfly/react-core





# [3.158.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.157.0...@patternfly/react-core@3.158.0) (2020-05-08)


### Features

* **Select:** Add support for 0 and all badges ([#4198](https://github.com/patternfly/patternfly-react/issues/4198)) ([9f7f764](https://github.com/patternfly/patternfly-react/commit/9f7f764fecdd24f41744085af52e870bc60e3a96)), closes [#4186](https://github.com/patternfly/patternfly-react/issues/4186)





# [3.157.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.156.0...@patternfly/react-core@3.157.0) (2020-05-07)


### Bug Fixes

* **tabs:** properly handle null Tab and TabContent ([#4211](https://github.com/patternfly/patternfly-react/issues/4211)) ([2fd93b1](https://github.com/patternfly/patternfly-react/commit/2fd93b112eb3cc87a2e9816754926744479a6c50))


### Features

* **MasterDetailDemo:** Add Master Detail Demo ([#4115](https://github.com/patternfly/patternfly-react/issues/4115)) ([1ed3055](https://github.com/patternfly/patternfly-react/commit/1ed30551b7bf77ef52603be9b10b30260b40a04c))





# [3.156.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.155.0...@patternfly/react-core@3.156.0) (2020-05-06)


### Bug Fixes

* **tabs:** properly check children before setting hidden ([#4179](https://github.com/patternfly/patternfly-react/issues/4179)) ([dc85915](https://github.com/patternfly/patternfly-react/commit/dc8591577c21144bf74f4a36c71d288e8a7cdadc))


### Features

* **tabs:** allow hiding tab buttons ([#4196](https://github.com/patternfly/patternfly-react/issues/4196)) ([caf13bd](https://github.com/patternfly/patternfly-react/commit/caf13bde3b1ca9a3d325ca9e8bc48acc1136a4f9))





# [3.155.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.154.0...@patternfly/react-core@3.155.0) (2020-05-05)


### Bug Fixes

* **page:** make tabIndex optional ([#4181](https://github.com/patternfly/patternfly-react/issues/4181)) ([858be76](https://github.com/patternfly/patternfly-react/commit/858be769876640e42203ae82a633f96ff58f9568))


### Features

* **Select:** Added placeholder text for inline filter ([#4185](https://github.com/patternfly/patternfly-react/issues/4185)) ([42bb77e](https://github.com/patternfly/patternfly-react/commit/42bb77ec77d898050960ceac3cd7b0616c38562f)), closes [#4162](https://github.com/patternfly/patternfly-react/issues/4162)





# [3.154.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.15...@patternfly/react-core@3.154.0) (2020-05-01)


### Features

* **NotificationDrawer:** Add new Notification Drawer Component ([#4137](https://github.com/patternfly/patternfly-react/issues/4137)) ([afbf832](https://github.com/patternfly/patternfly-react/commit/afbf832ab6394faa40b38a17817e95f67a37d61c)), closes [#1939](https://github.com/patternfly/patternfly-react/issues/1939)





## [3.153.15](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.14...@patternfly/react-core@3.153.15) (2020-04-30)


### Bug Fixes

* **fillTemplate:** ie11 compatibility ([#4155](https://github.com/patternfly/patternfly-react/issues/4155)) ([1900655](https://github.com/patternfly/patternfly-react/commit/1900655a54680a9cdd13a90db02b6005e1851e05))





## [3.153.14](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.13...@patternfly/react-core@3.153.14) (2020-04-27)


### Bug Fixes

* **select:** add missing import to docs ([#4109](https://github.com/patternfly/patternfly-react/issues/4109)) ([c51d22a](https://github.com/patternfly/patternfly-react/commit/c51d22a18cabfbc775dbeaa15cbbf57b28966865))





## [3.153.13](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.12...@patternfly/react-core@3.153.13) (2020-04-20)


### Bug Fixes

* **DataToolbar:** max depth fix ([#4103](https://github.com/patternfly/patternfly-react/issues/4103)) ([e561e5a](https://github.com/patternfly/patternfly-react/commit/e561e5a4198799bc3729726296d9e657769dd6f6))





## [3.153.12](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.11...@patternfly/react-core@3.153.12) (2020-04-20)


### Bug Fixes

* **Datatoolbar:** Revert change that prevents the current state of the toolbar filters to display in ([#4097](https://github.com/patternfly/patternfly-react/issues/4097)) ([241d390](https://github.com/patternfly/patternfly-react/commit/241d390981853959ac2bdad9a961127eda32c40f)), closes [#4096](https://github.com/patternfly/patternfly-react/issues/4096)





## [3.153.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.10...@patternfly/react-core@3.153.11) (2020-04-17)

**Note:** Version bump only for package @patternfly/react-core





## [3.153.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.9...@patternfly/react-core@3.153.10) (2020-04-17)


### Bug Fixes

* **tooltip:** codesandbox examples ([#4088](https://github.com/patternfly/patternfly-react/issues/4088)) ([7c34ce3](https://github.com/patternfly/patternfly-react/commit/7c34ce3dd9dce9a8adbfb3876834e847209027a7))





## [3.153.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.8...@patternfly/react-core@3.153.9) (2020-04-16)


### Bug Fixes

* **DataToolbarFilter:** Add prop to enable removal of all chips in a filter category. ([#4060](https://github.com/patternfly/patternfly-react/issues/4060)) ([16340da](https://github.com/patternfly/patternfly-react/commit/16340dad7dc37d4a9446717adc7fc252469e3cd4)), closes [#4059](https://github.com/patternfly/patternfly-react/issues/4059)





## [3.153.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.7...@patternfly/react-core@3.153.8) (2020-04-14)


### Bug Fixes

* **DataToolbar:** fix filter context from updating unnecessarily ([#4056](https://github.com/patternfly/patternfly-react/issues/4056)) ([dededf3](https://github.com/patternfly/patternfly-react/commit/dededf3e0091a5fa52470ca8f7e1e381b868d34b))





## [3.153.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.6...@patternfly/react-core@3.153.7) (2020-04-13)


### Bug Fixes

* **DropdownToggleCheckbox:** fix ref to show indeterminate checkbox state properly ([#3990](https://github.com/patternfly/patternfly-react/issues/3990)) ([7c23a02](https://github.com/patternfly/patternfly-react/commit/7c23a02a36f9947808160f3a2fbba375e723163b))





## [3.153.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.5...@patternfly/react-core@3.153.6) (2020-04-09)


### Bug Fixes

* **react-core:** guttersize type regression ([#4041](https://github.com/patternfly/patternfly-react/issues/4041)) ([1e3d585](https://github.com/patternfly/patternfly-react/commit/1e3d5856070c4cc84f72b71e914216f20e7a7fe1))





## [3.153.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.4...@patternfly/react-core@3.153.5) (2020-04-08)

**Note:** Version bump only for package @patternfly/react-core





## [3.153.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.3...@patternfly/react-core@3.153.4) (2020-04-07)


### Bug Fixes

* **dropdown:** respect already passed props ([#4016](https://github.com/patternfly/patternfly-react/issues/4016)) ([fe3c082](https://github.com/patternfly/patternfly-react/commit/fe3c08233f50d636490e0c664ac3a4b175b84ba6))





## [3.153.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.2...@patternfly/react-core@3.153.3) (2020-04-01)

**Note:** Version bump only for package @patternfly/react-core





## [3.153.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.1...@patternfly/react-core@3.153.2) (2020-03-31)


### Bug Fixes

* **app-launcher:** less aggressive router linking ([#3995](https://github.com/patternfly/patternfly-react/issues/3995)) ([28d653e](https://github.com/patternfly/patternfly-react/commit/28d653e8b71ae55426a265bd692b390846ed5b83))





## [3.153.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.153.0...@patternfly/react-core@3.153.1) (2020-03-30)

**Note:** Version bump only for package @patternfly/react-core





# [3.153.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.152.0...@patternfly/react-core@3.153.0) (2020-03-27)


### Features

* **Drawer:** added width props, updated demo & integration test ([#3979](https://github.com/patternfly/patternfly-react/issues/3979)) ([b1c7da3](https://github.com/patternfly/patternfly-react/commit/b1c7da3eea53330837952d79f664f0de3b62ec3a))





# [3.152.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.151.0...@patternfly/react-core@3.152.0) (2020-03-27)


### Features

* **Dropdown:** Add new prop so Links are treated better ([#3889](https://github.com/patternfly/patternfly-react/issues/3889)) ([5fac34e](https://github.com/patternfly/patternfly-react/commit/5fac34e206b542bcaa0663631b0567765a07e69f)), closes [#3641](https://github.com/patternfly/patternfly-react/issues/3641)





# [3.151.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.150.0...@patternfly/react-core@3.151.0) (2020-03-27)


### Features

* **select:** Allow count badge to be hidden in checkbox select ([#3976](https://github.com/patternfly/patternfly-react/issues/3976)) ([98bef94](https://github.com/patternfly/patternfly-react/commit/98bef941745d57f94b1f9cafd866c06ea1f85a93))





# [3.150.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.149.3...@patternfly/react-core@3.150.0) (2020-03-26)


### Features

* **rollup:** create unified react-core dist ([#3971](https://github.com/patternfly/patternfly-react/issues/3971)) ([506ea20](https://github.com/patternfly/patternfly-react/commit/506ea2084e37c8dd2887391747db62056086c69b))





## [3.149.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.149.2...@patternfly/react-core@3.149.3) (2020-03-25)

**Note:** Version bump only for package @patternfly/react-core





## [3.149.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.149.1...@patternfly/react-core@3.149.2) (2020-03-24)

**Note:** Version bump only for package @patternfly/react-core





## [3.149.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.149.0...@patternfly/react-core@3.149.1) (2020-03-24)


### Bug Fixes

* **card:** add wrapper to image to resize it properly ([#3642](https://github.com/patternfly/patternfly-react/issues/3642)) ([a3ea2ba](https://github.com/patternfly/patternfly-react/commit/a3ea2bacc87fd68ba7d342d96a0ab6b40191e3d5))





# [3.149.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.148.3...@patternfly/react-core@3.149.0) (2020-03-23)


### Features

* **card view:** Adds Card View to demos ([#3441](https://github.com/patternfly/patternfly-react/issues/3441)) ([802e7e3](https://github.com/patternfly/patternfly-react/commit/802e7e3a4c73493e43fb97ca6b2dc1542e81a858))





## [3.148.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.148.2...@patternfly/react-core@3.148.3) (2020-03-20)

**Note:** Version bump only for package @patternfly/react-core





## [3.148.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.148.1...@patternfly/react-core@3.148.2) (2020-03-19)


### Bug Fixes

* **alert:** use context to set label ([#3771](https://github.com/patternfly/patternfly-react/issues/3771)) ([29eb11b](https://github.com/patternfly/patternfly-react/commit/29eb11b4443f7156731263db84d88ad5a1ff53eb))





## [3.148.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.148.0...@patternfly/react-core@3.148.1) (2020-03-18)

**Note:** Version bump only for package @patternfly/react-core





# [3.148.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.147.1...@patternfly/react-core@3.148.0) (2020-03-17)


### Features

* **Select:** add logic for disabled default options for typeahead ([#3895](https://github.com/patternfly/patternfly-react/issues/3895)) ([8f060a2](https://github.com/patternfly/patternfly-react/commit/8f060a2e80c7617b0578611b60ec29d503745e8d))





## [3.147.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.147.0...@patternfly/react-core@3.147.1) (2020-03-17)


### Bug Fixes

* **select:** fix group select options in single variant ([#3838](https://github.com/patternfly/patternfly-react/issues/3838)) ([f8f87b8](https://github.com/patternfly/patternfly-react/commit/f8f87b8000cb6cd7f9c230fba888512293300be9))





# [3.147.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.146.2...@patternfly/react-core@3.147.0) (2020-03-17)


### Bug Fixes

* **aboutmodal:** set a customize aria-label to the close button ([#3877](https://github.com/patternfly/patternfly-react/issues/3877)) ([f824828](https://github.com/patternfly/patternfly-react/commit/f824828fa5b6a0879e9aa419fe8f0ff7b94db348))
* **core,table:** forward ref types ([#3919](https://github.com/patternfly/patternfly-react/issues/3919)) ([2210ec2](https://github.com/patternfly/patternfly-react/commit/2210ec2c142a385f85de8b0bac9c61a61521186d))
* **dropdown:** clean console errors in Dropdown.test.tsx ([#3861](https://github.com/patternfly/patternfly-react/issues/3861)) ([7cbeb75](https://github.com/patternfly/patternfly-react/commit/7cbeb750adf5f57698a8f69c83b92d51b2ab5a45))
* **dropdown:** remove duplicate prop ([#3923](https://github.com/patternfly/patternfly-react/issues/3923)) ([55dc272](https://github.com/patternfly/patternfly-react/commit/55dc27201cc536f87fb3aef9af5d4d5440c54267))


### Features

* **EmptyState:** Added support for extra-large empty state ([#3844](https://github.com/patternfly/patternfly-react/issues/3844)) ([d4ea57f](https://github.com/patternfly/patternfly-react/commit/d4ea57f47eab89b8cdedc792ebe078b746176679))





## [3.146.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.146.0...@patternfly/react-core@3.146.2) (2020-03-13)


### Bug Fixes

* **nothing:** bumping to release 2020.03 release notes ([#3908](https://github.com/patternfly/patternfly-react/issues/3908)) ([468511a](https://github.com/patternfly/patternfly-react/commit/468511aae16c0c5ec3e4a3e0efbeeaffa1695c5b))





## [3.146.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.146.0...@patternfly/react-core@3.146.1) (2020-03-12)


### Bug Fixes

* **nothing:** bumping to release 2020.03 release notes ([#3908](https://github.com/patternfly/patternfly-react/issues/3908)) ([468511a](https://github.com/patternfly/patternfly-react/commit/468511aae16c0c5ec3e4a3e0efbeeaffa1695c5b))





# [3.146.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.145.3...@patternfly/react-core@3.146.0) (2020-03-10)


### Features

* **Modal:** move description to separate component ([#3897](https://github.com/patternfly/patternfly-react/issues/3897)) ([97eb9d8](https://github.com/patternfly/patternfly-react/commit/97eb9d8766febf5dd97424c4c7868f80441b8386))





## [3.145.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.145.2...@patternfly/react-core@3.145.3) (2020-03-09)

**Note:** Version bump only for package @patternfly/react-core





## [3.145.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.145.1...@patternfly/react-core@3.145.2) (2020-03-09)

**Note:** Version bump only for package @patternfly/react-core





## [3.145.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.145.0...@patternfly/react-core@3.145.1) (2020-03-09)

**Note:** Version bump only for package @patternfly/react-core





# [3.145.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.144.1...@patternfly/react-core@3.145.0) (2020-03-09)


### Features

* **Select:** add inline filtering to checkbox select ([#3843](https://github.com/patternfly/patternfly-react/issues/3843)) ([2263de8](https://github.com/patternfly/patternfly-react/commit/2263de8361b196f4421a3adcbb01b4b2dd410d4a))





## [3.144.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.144.0...@patternfly/react-core@3.144.1) (2020-03-06)

**Note:** Version bump only for package @patternfly/react-core





# [3.144.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.143.0...@patternfly/react-core@3.144.0) (2020-03-06)


### Features

* **ChipGroup:** Added a tooltip to the Chipgroup label ([#3826](https://github.com/patternfly/patternfly-react/issues/3826)) ([d25c80b](https://github.com/patternfly/patternfly-react/commit/d25c80b68795c44d46eaf261b335c5f088d71e96)), closes [#3490](https://github.com/patternfly/patternfly-react/issues/3490)





# [3.143.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.142.2...@patternfly/react-core@3.143.0) (2020-03-06)


### Bug Fixes

* **ouia:** don't omit ouiaContext ([#3872](https://github.com/patternfly/patternfly-react/issues/3872)) ([23cf7fc](https://github.com/patternfly/patternfly-react/commit/23cf7fca4764178e91dc4e054677a316d2e44f8e))
* **wizard:** use patternfly-styles to set the no padding modifier ([#3871](https://github.com/patternfly/patternfly-react/issues/3871)) ([0295597](https://github.com/patternfly/patternfly-react/commit/0295597a091def71d979ec4db7ade8e493d421f3))


### Features

* **DataList:** add compact data list ([#3807](https://github.com/patternfly/patternfly-react/issues/3807)) ([18d9b7b](https://github.com/patternfly/patternfly-react/commit/18d9b7b756e985304864e52b09f5f1d1789791f8))
* **Modal:** add description property ([#3821](https://github.com/patternfly/patternfly-react/issues/3821)) ([c7bfe03](https://github.com/patternfly/patternfly-react/commit/c7bfe03c54caf2ffcc215ab359c98cf0359c035e))





## [3.142.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.142.1...@patternfly/react-core@3.142.2) (2020-03-03)

**Note:** Version bump only for package @patternfly/react-core





## [3.142.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.142.0...@patternfly/react-core@3.142.1) (2020-03-02)

**Note:** Version bump only for package @patternfly/react-core





# [3.142.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.141.6...@patternfly/react-core@3.142.0) (2020-03-02)


### Features

* **Button:** add link icon position for link buttons ([#3798](https://github.com/patternfly/patternfly-react/issues/3798)) ([33739b5](https://github.com/patternfly/patternfly-react/commit/33739b5544b9b2ac564389cc8ffc626620df78d9))





## [3.141.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.141.5...@patternfly/react-core@3.141.6) (2020-02-28)

**Note:** Version bump only for package @patternfly/react-core





## [3.141.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.141.4...@patternfly/react-core@3.141.5) (2020-02-27)


### Bug Fixes

* **pagination:** update navigation input according to page number ([#3534](https://github.com/patternfly/patternfly-react/issues/3534)) ([0d50607](https://github.com/patternfly/patternfly-react/commit/0d506074e4084f8dadd3ffdfafb04dde7d13ed7c))





## [3.141.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.141.3...@patternfly/react-core@3.141.4) (2020-02-26)


### Bug Fixes

* **switch:** avoid switch id override by props ([#3706](https://github.com/patternfly/patternfly-react/issues/3706)) ([0952774](https://github.com/patternfly/patternfly-react/commit/0952774d3dbcf6a7d66d4463277fab181bfd6c28))





## [3.141.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.141.2...@patternfly/react-core@3.141.3) (2020-02-26)

**Note:** Version bump only for package @patternfly/react-core





## [3.141.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.141.1...@patternfly/react-core@3.141.2) (2020-02-25)


### Bug Fixes

* **dropdown:** Keyboard selection of toggle causes selection of parent ([#3816](https://github.com/patternfly/patternfly-react/issues/3816)) ([2563ce6](https://github.com/patternfly/patternfly-react/commit/2563ce695046b5f934693bc025122e29b00209cf))





## [3.141.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.141.0...@patternfly/react-core@3.141.1) (2020-02-25)


### Bug Fixes

* **layouts:** wrapped examples to fix codesandbox ([#3818](https://github.com/patternfly/patternfly-react/issues/3818)) ([81791eb](https://github.com/patternfly/patternfly-react/commit/81791eb0e25e49f9d1317ce12d6ce5a16d313a5f))





# [3.141.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.11...@patternfly/react-core@3.141.0) (2020-02-25)


### Bug Fixes

* **Tabs:** update tabs with nav examples + add Tab component to props docs ([#3527](https://github.com/patternfly/patternfly-react/issues/3527)) ([a97c226](https://github.com/patternfly/patternfly-react/commit/a97c22622b429a87cf8c7cb1bfd212526b403f58))


### Features

* **card:** add selectable and selected variation ([#3587](https://github.com/patternfly/patternfly-react/issues/3587)) ([166aa09](https://github.com/patternfly/patternfly-react/commit/166aa097ae08f5da216c9f59a1094e032da49054))





## [3.140.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.10...@patternfly/react-core@3.140.11) (2020-02-18)


### Bug Fixes

* **experimental:** Added experimental exports  ([#3775](https://github.com/patternfly/patternfly-react/issues/3775)) ([600bd12](https://github.com/patternfly/patternfly-react/commit/600bd1278ecaa16f85b8340088d10208cb5006f0))





## [3.140.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.9...@patternfly/react-core@3.140.10) (2020-02-18)

**Note:** Version bump only for package @patternfly/react-core





## [3.140.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.8...@patternfly/react-core@3.140.9) (2020-02-18)

**Note:** Version bump only for package @patternfly/react-core





## [3.140.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.7...@patternfly/react-core@3.140.8) (2020-02-18)

**Note:** Version bump only for package @patternfly/react-core





## [3.140.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.6...@patternfly/react-core@3.140.7) (2020-02-18)

**Note:** Version bump only for package @patternfly/react-core





## [3.140.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.5...@patternfly/react-core@3.140.6) (2020-02-17)


### Bug Fixes

* **version:** version updated in react-core for react-icons ([#3760](https://github.com/patternfly/patternfly-react/issues/3760)) ([59544ac](https://github.com/patternfly/patternfly-react/commit/59544ac2cf69b5a460d06b0c9f1af920a68c0dd6))





## [3.140.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.4...@patternfly/react-core@3.140.5) (2020-02-17)


### Bug Fixes

* **beta:** beta warning for datatoolbar, cleanup ([#3755](https://github.com/patternfly/patternfly-react/issues/3755)) ([ae708ac](https://github.com/patternfly/patternfly-react/commit/ae708ac2ee1cdf321519d63833c1998b6627d8c1))





## [3.140.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.3...@patternfly/react-core@3.140.4) (2020-02-17)

**Note:** Version bump only for package @patternfly/react-core





## [3.140.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.2...@patternfly/react-core@3.140.3) (2020-02-17)

**Note:** Version bump only for package @patternfly/react-core





## [3.140.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.1...@patternfly/react-core@3.140.2) (2020-02-14)

**Note:** Version bump only for package @patternfly/react-core





## [3.140.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.140.0...@patternfly/react-core@3.140.1) (2020-02-14)

**Note:** Version bump only for package @patternfly/react-core





# [3.140.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.139.0...@patternfly/react-core@3.140.0) (2020-02-14)


### Features

* **inline-edit:** add row level inline editing feature to Table ([#3581](https://github.com/patternfly/patternfly-react/issues/3581)) ([498d49f](https://github.com/patternfly/patternfly-react/commit/498d49fcc5cc9188197ddc7cd6468907fdd8224d))





# [3.139.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.138.0...@patternfly/react-core@3.139.0) (2020-02-14)


### Features

* **SimpleList:** add simple list ([#3645](https://github.com/patternfly/patternfly-react/issues/3645)) ([4bba16c](https://github.com/patternfly/patternfly-react/commit/4bba16c3fbe788a74523ddede45293eb48a60009))





# [3.138.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.137.0...@patternfly/react-core@3.138.0) (2020-02-13)


### Features

* **Popover:** add min-width override property ([#3601](https://github.com/patternfly/patternfly-react/issues/3601)) ([8c906b8](https://github.com/patternfly/patternfly-react/commit/8c906b8982b39aba1ecbb425961be859803057a3))





# [3.137.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.15...@patternfly/react-core@3.137.0) (2020-02-13)


### Features

* **DataToolbar:** update html structure to match core ([#3710](https://github.com/patternfly/patternfly-react/issues/3710)) ([6e61b1e](https://github.com/patternfly/patternfly-react/commit/6e61b1e43380d8fc86585504a3b13897cf68227d))





## [3.136.15](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.14...@patternfly/react-core@3.136.15) (2020-02-13)


### Bug Fixes

* **Select:** handle undefined default for checkbox select ([#3711](https://github.com/patternfly/patternfly-react/issues/3711)) ([12e7ac2](https://github.com/patternfly/patternfly-react/commit/12e7ac2c42ef576f4978cefc527f8a3890d5cde0))





## [3.136.14](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.13...@patternfly/react-core@3.136.14) (2020-02-12)


### Bug Fixes

* **docs:** updated node version in readme ([#3741](https://github.com/patternfly/patternfly-react/issues/3741)) ([c0fd4a6](https://github.com/patternfly/patternfly-react/commit/c0fd4a6b6cbe4ff9524ac83a09daec233477bc5b))





## [3.136.13](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.12...@patternfly/react-core@3.136.13) (2020-02-12)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.12](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.11...@patternfly/react-core@3.136.12) (2020-02-12)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.10...@patternfly/react-core@3.136.11) (2020-02-11)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.9...@patternfly/react-core@3.136.10) (2020-02-10)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.8...@patternfly/react-core@3.136.9) (2020-02-10)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.7...@patternfly/react-core@3.136.8) (2020-02-10)


### Bug Fixes

* **ContextSelector:** Updated signature for context selector to match what it returns. ([#3697](https://github.com/patternfly/patternfly-react/issues/3697)) ([bfd9958](https://github.com/patternfly/patternfly-react/commit/bfd99585db6720e6ea0d54e226342dc4ef033c92)), closes [#3694](https://github.com/patternfly/patternfly-react/issues/3694)





## [3.136.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.6...@patternfly/react-core@3.136.7) (2020-02-06)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.5...@patternfly/react-core@3.136.6) (2020-02-06)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.4...@patternfly/react-core@3.136.5) (2020-02-06)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.3...@patternfly/react-core@3.136.4) (2020-02-05)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.2...@patternfly/react-core@3.136.3) (2020-02-04)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.1...@patternfly/react-core@3.136.2) (2020-02-03)

**Note:** Version bump only for package @patternfly/react-core





## [3.136.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.136.0...@patternfly/react-core@3.136.1) (2020-02-03)


### Bug Fixes

* **Page & PageHeader:** adds optional "role" prop ([#3595](https://github.com/patternfly/patternfly-react/issues/3595)) ([ed36aaf](https://github.com/patternfly/patternfly-react/commit/ed36aafc09a0494931585241f4eb10fba56c5475))





# [3.136.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.135.1...@patternfly/react-core@3.136.0) (2020-01-31)


### Features

* **radio/check:** add support for optional description ([#3621](https://github.com/patternfly/patternfly-react/issues/3621)) ([f4370fe](https://github.com/patternfly/patternfly-react/commit/f4370fed639f386ee2e6037cbf3843eba0871ec1))





## [3.135.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.135.0...@patternfly/react-core@3.135.1) (2020-01-31)

**Note:** Version bump only for package @patternfly/react-core





# [3.135.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.134.4...@patternfly/react-core@3.135.0) (2020-01-31)


### Features

* **icons:** use absolute import paths ([#3517](https://github.com/patternfly/patternfly-react/issues/3517)) ([897d359](https://github.com/patternfly/patternfly-react/commit/897d359a48ac2ce6ddea68bbdcfe0ae2f05544bd))





## [3.134.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.134.3...@patternfly/react-core@3.134.4) (2020-01-30)


### Bug Fixes

* **a11y:** fix a11y errors and enable a11y in CI ([#3593](https://github.com/patternfly/patternfly-react/issues/3593)) ([d20cab7](https://github.com/patternfly/patternfly-react/commit/d20cab7c9f39f7d1cd195f0a3b50aff3b7c3a0d3))
* **wizard:** add type to wizard context ([#3572](https://github.com/patternfly/patternfly-react/issues/3572)) ([0063fd2](https://github.com/patternfly/patternfly-react/commit/0063fd29b00a07bb574c6248dc9239b34147d581))





## [3.134.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.134.2...@patternfly/react-core@3.134.3) (2020-01-30)

**Note:** Version bump only for package @patternfly/react-core





## [3.134.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.134.1...@patternfly/react-core@3.134.2) (2020-01-27)

**Note:** Version bump only for package @patternfly/react-core





## [3.134.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.134.0...@patternfly/react-core@3.134.1) (2020-01-27)


### Bug Fixes

* **dropdown:** do not pass id to dropdown list item if is not set ([#3555](https://github.com/patternfly/patternfly-react/issues/3555)) ([06df46a](https://github.com/patternfly/patternfly-react/commit/06df46a845da13a981239c9f7393258112161acf))





# [3.134.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.133.2...@patternfly/react-core@3.134.0) (2020-01-27)


### Features

* **AlertGroup:** Add alert group component ([#3531](https://github.com/patternfly/patternfly-react/issues/3531)) ([0a6806e](https://github.com/patternfly/patternfly-react/commit/0a6806e0f6be01a022e6ce2a9d578a6d8bd52554))





## [3.133.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.133.1...@patternfly/react-core@3.133.2) (2020-01-27)

**Note:** Version bump only for package @patternfly/react-core





## [3.133.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.133.0...@patternfly/react-core@3.133.1) (2020-01-27)

**Note:** Version bump only for package @patternfly/react-core





# [3.133.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.132.3...@patternfly/react-core@3.133.0) (2020-01-24)


### Features

* **pf4:** Use absolute import paths for react core in pf4 packages. ([#3525](https://github.com/patternfly/patternfly-react/issues/3525)) ([65d0b3d](https://github.com/patternfly/patternfly-react/commit/65d0b3d1e04610895f122c1313d1442360356f13)), closes [#3155](https://github.com/patternfly/patternfly-react/issues/3155)





## [3.132.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.132.2...@patternfly/react-core@3.132.3) (2020-01-23)

**Note:** Version bump only for package @patternfly/react-core





## [3.132.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.132.1...@patternfly/react-core@3.132.2) (2020-01-23)

**Note:** Version bump only for package @patternfly/react-core





## [3.132.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.132.0...@patternfly/react-core@3.132.1) (2020-01-22)

**Note:** Version bump only for package @patternfly/react-core





# [3.132.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.131.5...@patternfly/react-core@3.132.0) (2020-01-22)


### Features

* **alert:** Accessibility updates to alert for toast alerts ([#3519](https://github.com/patternfly/patternfly-react/issues/3519)) ([dc57757](https://github.com/patternfly/patternfly-react/commit/dc57757a3aea6f6bd4ad0fd421e6dad8eaf40646))





## [3.131.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.131.4...@patternfly/react-core@3.131.5) (2020-01-22)


### Bug Fixes

* **select:** set a unique id to the select toggle typeahead input ([#3529](https://github.com/patternfly/patternfly-react/issues/3529)) ([40dd8f1](https://github.com/patternfly/patternfly-react/commit/40dd8f116996a5273ecb90784063c2db53bc82ba))





## [3.131.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.131.3...@patternfly/react-core@3.131.4) (2020-01-21)

**Note:** Version bump only for package @patternfly/react-core





## [3.131.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.131.2...@patternfly/react-core@3.131.3) (2020-01-21)

**Note:** Version bump only for package @patternfly/react-core





## [3.131.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.131.1...@patternfly/react-core@3.131.2) (2020-01-21)

**Note:** Version bump only for package @patternfly/react-core





## [3.131.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.131.0...@patternfly/react-core@3.131.1) (2020-01-20)


### Bug Fixes

* **Select:** clear button appears with any typeahead input ([#3502](https://github.com/patternfly/patternfly-react/issues/3502)) ([f506291](https://github.com/patternfly/patternfly-react/commit/f506291228de8ca79eaedfdb700b3b9f87270377))





# [3.131.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.10...@patternfly/react-core@3.131.0) (2020-01-17)


### Features

* **Select:** allow custom option data comparison ([#3491](https://github.com/patternfly/patternfly-react/issues/3491)) ([79204a5](https://github.com/patternfly/patternfly-react/commit/79204a5f42e531895f667d8f2fcbfce4bdf129f5))





## [3.130.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.9...@patternfly/react-core@3.130.10) (2020-01-15)


### Bug Fixes

* **PageHeader:** removing redundant role="banner" attribute ([#3499](https://github.com/patternfly/patternfly-react/issues/3499)) ([d9452de](https://github.com/patternfly/patternfly-react/commit/d9452de235963e33178057a24305e2cf365d5097))





## [3.130.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.8...@patternfly/react-core@3.130.9) (2020-01-15)

**Note:** Version bump only for package @patternfly/react-core





## [3.130.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.7...@patternfly/react-core@3.130.8) (2020-01-15)

**Note:** Version bump only for package @patternfly/react-core





## [3.130.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.6...@patternfly/react-core@3.130.7) (2020-01-14)

**Note:** Version bump only for package @patternfly/react-core





## [3.130.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.5...@patternfly/react-core@3.130.6) (2020-01-13)


### Bug Fixes

* **select:** Add the type prop to the select toggle button ([#3495](https://github.com/patternfly/patternfly-react/issues/3495)) ([e61c0bd](https://github.com/patternfly/patternfly-react/commit/e61c0bd6894d0fad70e89829fb114766b6e88108))





## [3.130.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.4...@patternfly/react-core@3.130.5) (2020-01-13)


### Bug Fixes

* **DataToolbar:** add and remove some modifiers to match core ([#3422](https://github.com/patternfly/patternfly-react/issues/3422)) ([034c041](https://github.com/patternfly/patternfly-react/commit/034c041c8237c906778edfc3287c5e2193480a53))





## [3.130.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.3...@patternfly/react-core@3.130.4) (2020-01-10)


### Bug Fixes

* **pagination:** disable navigation input if page is equal to zero ([#3472](https://github.com/patternfly/patternfly-react/issues/3472)) ([09e1bf3](https://github.com/patternfly/patternfly-react/commit/09e1bf321f488291c2733d3c3c2141592d944c61))





## [3.130.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.2...@patternfly/react-core@3.130.3) (2020-01-09)

**Note:** Version bump only for package @patternfly/react-core





## [3.130.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.1...@patternfly/react-core@3.130.2) (2020-01-09)

**Note:** Version bump only for package @patternfly/react-core





## [3.130.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.130.0...@patternfly/react-core@3.130.1) (2020-01-09)


### Bug Fixes

* **react-core transform plugin:** Use direct paths to react-icons in prod build ([#3448](https://github.com/patternfly/patternfly-react/issues/3448)) ([49814a7](https://github.com/patternfly/patternfly-react/commit/49814a72fa829de6fa6f34963a21c554fad7b06e))





# [3.130.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.129.6...@patternfly/react-core@3.130.0) (2020-01-08)


### Features

* **ChipGroup:** add closable chip-group ([#3455](https://github.com/patternfly/patternfly-react/issues/3455)) ([a11dea1](https://github.com/patternfly/patternfly-react/commit/a11dea19ad9b78b6ed52420021c3f726c918a977))





## [3.129.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.129.5...@patternfly/react-core@3.129.6) (2020-01-08)

**Note:** Version bump only for package @patternfly/react-core





## [3.129.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.129.4...@patternfly/react-core@3.129.5) (2020-01-08)

**Note:** Version bump only for package @patternfly/react-core





## [3.129.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.129.3...@patternfly/react-core@3.129.4) (2020-01-07)


### Bug Fixes

* **clipboardcopy:** set type of copy and toggle buttons to 'button' ([#3444](https://github.com/patternfly/patternfly-react/issues/3444)) ([e15d44a](https://github.com/patternfly/patternfly-react/commit/e15d44a825937dabea6a5945bb6b1ffb64a87742))
* **DataList:** properly assign selectable and selected classes ([#3447](https://github.com/patternfly/patternfly-react/issues/3447)) ([1784176](https://github.com/patternfly/patternfly-react/commit/1784176e59ba8f4de54e6d9c4e2ba86026ddcfed))





## [3.129.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.129.2...@patternfly/react-core@3.129.3) (2019-12-19)


### Bug Fixes

* **DataList:** remove hook ([#3434](https://github.com/patternfly/patternfly-react/issues/3434)) ([2a33ab2](https://github.com/patternfly/patternfly-react/commit/2a33ab2f5d9a9c5b194e7a8336330348fd76664a))





## [3.129.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.129.1...@patternfly/react-core@3.129.2) (2019-12-19)


### Bug Fixes

* **DataList:** Revert React.Component back to React.FunctionComponent ([#3431](https://github.com/patternfly/patternfly-react/issues/3431)) ([90f6b30](https://github.com/patternfly/patternfly-react/commit/90f6b30c627613149a999d71d2bd189a809ae579))





## [3.129.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.129.0...@patternfly/react-core@3.129.1) (2019-12-17)

**Note:** Version bump only for package @patternfly/react-core





# [3.129.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.128.2...@patternfly/react-core@3.129.0) (2019-12-17)


### Features

* **DataList:** add selectable variant ([#3404](https://github.com/patternfly/patternfly-react/issues/3404)) ([eeacf0c](https://github.com/patternfly/patternfly-react/commit/eeacf0c5e4a9a44abcf1c13fd98b58d7d4b9e50d))





## [3.128.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.128.1...@patternfly/react-core@3.128.2) (2019-12-16)


### Bug Fixes

* **docs:** documented CJS tree shaking solution for icons and react-core ([#3410](https://github.com/patternfly/patternfly-react/issues/3410)) ([7e7eb01](https://github.com/patternfly/patternfly-react/commit/7e7eb0103a79c8cb9e6824f1c27723e7357f751a))





## [3.128.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.128.0...@patternfly/react-core@3.128.1) (2019-12-16)

**Note:** Version bump only for package @patternfly/react-core





# [3.128.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.127.3...@patternfly/react-core@3.128.0) (2019-12-16)


### Features

* **list:** add the ordered variant ([#3363](https://github.com/patternfly/patternfly-react/issues/3363)) ([373f923](https://github.com/patternfly/patternfly-react/commit/373f923af83801ce6e8126a799b734e5cb112d81))





## [3.127.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.127.2...@patternfly/react-core@3.127.3) (2019-12-13)


### Bug Fixes

* **Options menu:** added support for groups and titles ([#3360](https://github.com/patternfly/patternfly-react/issues/3360)) ([e608e60](https://github.com/patternfly/patternfly-react/commit/e608e601a7841ab83a8abb3a04521ef2d8397362))





## [3.127.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.127.1...@patternfly/react-core@3.127.2) (2019-12-12)

**Note:** Version bump only for package @patternfly/react-core





## [3.127.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.127.0...@patternfly/react-core@3.127.1) (2019-12-12)


### Bug Fixes

* **Dropdown:** Update component to use input rather than PF Checkbox ([#3391](https://github.com/patternfly/patternfly-react/issues/3391)) ([89561d5](https://github.com/patternfly/patternfly-react/commit/89561d5bb94f7f07f56acfabe09192dc5565f0d2)), closes [#3325](https://github.com/patternfly/patternfly-react/issues/3325)





# [3.127.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.126.5...@patternfly/react-core@3.127.0) (2019-12-11)


### Features

* **Pagination:** added optional offset prop ([#3383](https://github.com/patternfly/patternfly-react/issues/3383)) ([1dd38a1](https://github.com/patternfly/patternfly-react/commit/1dd38a15b19f4f60d5f09e88d553801765947705))





## [3.126.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.126.4...@patternfly/react-core@3.126.5) (2019-12-06)


### Bug Fixes

* **Pagination:** fixed prev arrows active with 0 rows ([#3384](https://github.com/patternfly/patternfly-react/issues/3384)) ([901cb13](https://github.com/patternfly/patternfly-react/commit/901cb1379b8685c1957fb3575a0de3209846fb48))





## [3.126.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.126.3...@patternfly/react-core@3.126.4) (2019-12-05)

**Note:** Version bump only for package @patternfly/react-core





## [3.126.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.126.2...@patternfly/react-core@3.126.3) (2019-12-05)

**Note:** Version bump only for package @patternfly/react-core





## [3.126.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.126.1...@patternfly/react-core@3.126.2) (2019-12-05)

**Note:** Version bump only for package @patternfly/react-core





## [3.126.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.126.0...@patternfly/react-core@3.126.1) (2019-12-05)

**Note:** Version bump only for package @patternfly/react-core





# [3.126.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.125.1...@patternfly/react-core@3.126.0) (2019-12-05)


### Features

* **Pagination:** automate pagination and overflow logic ([#3182](https://github.com/patternfly/patternfly-react/issues/3182)) ([af19ff8](https://github.com/patternfly/patternfly-react/commit/af19ff80026c4f69b83e5818345f0bf5da8b58bd)), closes [#3136](https://github.com/patternfly/patternfly-react/issues/3136) [#3136](https://github.com/patternfly/patternfly-react/issues/3136)





## [3.125.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.125.0...@patternfly/react-core@3.125.1) (2019-12-04)

**Note:** Version bump only for package @patternfly/react-core





# [3.125.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.124.3...@patternfly/react-core@3.125.0) (2019-12-02)


### Features

* **textinput:** support passing a ref ([#3168](https://github.com/patternfly/patternfly-react/issues/3168)) ([1e1ca74](https://github.com/patternfly/patternfly-react/commit/1e1ca741db3bcf31614365fa75ea1947abbccf8e))





## [3.124.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.124.2...@patternfly/react-core@3.124.3) (2019-12-02)


### Bug Fixes

* **nav & pagelayout:** removes basic nav example, switches to default variant,  updates PF masthead logo ([#3262](https://github.com/patternfly/patternfly-react/issues/3262)) ([fe707a3](https://github.com/patternfly/patternfly-react/commit/fe707a3c23a1b072e13664786c4b95ef91a5e361))





## [3.124.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.124.1...@patternfly/react-core@3.124.2) (2019-11-27)

**Note:** Version bump only for package @patternfly/react-core





## [3.124.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.124.0...@patternfly/react-core@3.124.1) (2019-11-21)

**Note:** Version bump only for package @patternfly/react-core





# [3.124.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.123.1...@patternfly/react-core@3.124.0) (2019-11-21)


### Features

* **Select:** Add the ability to have custom content in the Select Menu ([#3333](https://github.com/patternfly/patternfly-react/issues/3333)) ([7f3b550](https://github.com/patternfly/patternfly-react/commit/7f3b550a604f99fce993f93ca6a3ef5cfd27c312)), closes [#3193](https://github.com/patternfly/patternfly-react/issues/3193)





## [3.123.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.123.0...@patternfly/react-core@3.123.1) (2019-11-21)


### Bug Fixes

* **DataToolbar:** move and wrap chips in expandable content ([#3319](https://github.com/patternfly/patternfly-react/issues/3319)) ([99f1efe](https://github.com/patternfly/patternfly-react/commit/99f1efe4c179754a1e1aa46585c9776c3073ee34))





# [3.123.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.122.4...@patternfly/react-core@3.123.0) (2019-11-21)


### Features

* **Dropdown:** add split button action variant ([#3307](https://github.com/patternfly/patternfly-react/issues/3307)) ([625ea59](https://github.com/patternfly/patternfly-react/commit/625ea59df1c23ec7f70fb0c8de717a6b404db277))





## [3.122.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.122.3...@patternfly/react-core@3.122.4) (2019-11-21)


### Bug Fixes

* **button:** support setting tab index unless not button and disabled ([#3240](https://github.com/patternfly/patternfly-react/issues/3240)) ([759c8f1](https://github.com/patternfly/patternfly-react/commit/759c8f1bb486cc9b2533160e7f91846f2728f817))





## [3.122.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.122.2...@patternfly/react-core@3.122.3) (2019-11-21)


### Bug Fixes

* **PaginationTableDemo:** add Spinner and empty state to demo ([#3294](https://github.com/patternfly/patternfly-react/issues/3294)) ([c4cb9f4](https://github.com/patternfly/patternfly-react/commit/c4cb9f496be52224608985912d7a2673969f5531))





## [3.122.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.122.1...@patternfly/react-core@3.122.2) (2019-11-20)


### Bug Fixes

* **flex:** typo in align and justify modifiers ([#3328](https://github.com/patternfly/patternfly-react/issues/3328)) ([89f8bae](https://github.com/patternfly/patternfly-react/commit/89f8bae708cb6df7aed501d0c830ab18b351453e))





## [3.122.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.122.0...@patternfly/react-core@3.122.1) (2019-11-20)


### Bug Fixes

* **Select:** Display pre-selected input ([#3305](https://github.com/patternfly/patternfly-react/issues/3305)) ([f04fe92](https://github.com/patternfly/patternfly-react/commit/f04fe9240c710c0cf1fd7c76d1a0542cd6b3845d))





# [3.122.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.121.0...@patternfly/react-core@3.122.0) (2019-11-20)


### Features

* **Accordion:** Add a prop to allow th box shadow to be removed ([#3309](https://github.com/patternfly/patternfly-react/issues/3309)) ([02145a2](https://github.com/patternfly/patternfly-react/commit/02145a2b224846e35c8c23df5958b57a5e47f101)), closes [#3195](https://github.com/patternfly/patternfly-react/issues/3195)





# [3.121.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.17...@patternfly/react-core@3.121.0) (2019-11-19)


### Features

* **form:** Add validated variant to form inputs ([#3220](https://github.com/patternfly/patternfly-react/issues/3220)) ([52b17e9](https://github.com/patternfly/patternfly-react/commit/52b17e9e8a31311ce1860051928755e5a394d827))





## [3.120.17](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.16...@patternfly/react-core@3.120.17) (2019-11-19)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.16](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.15...@patternfly/react-core@3.120.16) (2019-11-19)


### Bug Fixes

* **flex:** in breakpointMods set breakpoint as optional and add enums ([#3258](https://github.com/patternfly/patternfly-react/issues/3258)) ([285ea43](https://github.com/patternfly/patternfly-react/commit/285ea43dccdfbdf6ca404c643be0500f27683ac8))





## [3.120.15](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.14...@patternfly/react-core@3.120.15) (2019-11-19)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.14](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.13...@patternfly/react-core@3.120.14) (2019-11-18)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.13](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.12...@patternfly/react-core@3.120.13) (2019-11-18)


### Bug Fixes

* **wizard,aboutmodal:** remove appendTo from props passed to div ([#3239](https://github.com/patternfly/patternfly-react/issues/3239)) ([0b62699](https://github.com/patternfly/patternfly-react/commit/0b62699976c598262581596fb716c1b3bb61bfa3))





## [3.120.12](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.11...@patternfly/react-core@3.120.12) (2019-11-15)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.10...@patternfly/react-core@3.120.11) (2019-11-15)


### Bug Fixes

* **Pagination:** fixed previous page navigation issues with 1 row perpage ([#3297](https://github.com/patternfly/patternfly-react/issues/3297)) ([300d828](https://github.com/patternfly/patternfly-react/commit/300d8285e7057f71c1cf4df73a5832abcea9e3ac))





## [3.120.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.9...@patternfly/react-core@3.120.10) (2019-11-14)


### Bug Fixes

* **Select:** remove form typeahead and checkbox selects ([#3298](https://github.com/patternfly/patternfly-react/issues/3298)) ([913daeb](https://github.com/patternfly/patternfly-react/commit/913daeb7ee936421d78ecbd0ab8857f5f8a6956e))





## [3.120.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.8...@patternfly/react-core@3.120.9) (2019-11-12)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.7...@patternfly/react-core@3.120.8) (2019-11-08)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.6...@patternfly/react-core@3.120.7) (2019-11-06)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.5...@patternfly/react-core@3.120.6) (2019-11-05)


### Bug Fixes

* **optionmenu:** remove the i element around selected item svg ([#3238](https://github.com/patternfly/patternfly-react/issues/3238)) ([5991033](https://github.com/patternfly/patternfly-react/commit/5991033126ff429172fcaa345806bd5a59671ef3))





## [3.120.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.4...@patternfly/react-core@3.120.5) (2019-11-01)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.3...@patternfly/react-core@3.120.4) (2019-10-31)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.2...@patternfly/react-core@3.120.3) (2019-10-30)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.1...@patternfly/react-core@3.120.2) (2019-10-25)

**Note:** Version bump only for package @patternfly/react-core





## [3.120.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.120.0...@patternfly/react-core@3.120.1) (2019-10-25)

**Note:** Version bump only for package @patternfly/react-core





# [3.120.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.119.0...@patternfly/react-core@3.120.0) (2019-10-24)


### Features

* **react-catalog-view-extension:** Added catalog view extension and three components ([#3145](https://github.com/patternfly/patternfly-react/issues/3145)) ([20a981b](https://github.com/patternfly/patternfly-react/commit/20a981b6aff0bbf3ff04d5b016f67bf76545f3cd)), closes [#3159](https://github.com/patternfly/patternfly-react/issues/3159)





# [3.119.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.118.1...@patternfly/react-core@3.119.0) (2019-10-24)


### Features

* **TextArea:** Add a prop to allow limiting the resize orientation o… ([#3180](https://github.com/patternfly/patternfly-react/issues/3180)) ([d61ae9d](https://github.com/patternfly/patternfly-react/commit/d61ae9d)), closes [#2839](https://github.com/patternfly/patternfly-react/issues/2839)





## [3.118.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.118.0...@patternfly/react-core@3.118.1) (2019-10-24)

**Note:** Version bump only for package @patternfly/react-core





# [3.118.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.117.5...@patternfly/react-core@3.118.0) (2019-10-23)


### Bug Fixes

* **DataToolbar:** implement changes to match PF-Core ([#3144](https://github.com/patternfly/patternfly-react/issues/3144)) ([e77c613](https://github.com/patternfly/patternfly-react/commit/e77c613))


### Features

* **BulkSelect demo:** add bulk select demo with table and toolbar ([#3082](https://github.com/patternfly/patternfly-react/issues/3082)) ([1f0defa](https://github.com/patternfly/patternfly-react/commit/1f0defa))
* **Divider:** add divider component ([#3125](https://github.com/patternfly/patternfly-react/issues/3125)) ([92971d3](https://github.com/patternfly/patternfly-react/commit/92971d3))





## [3.117.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.117.4...@patternfly/react-core@3.117.5) (2019-10-22)


### Bug Fixes

* **Select:** add plain modifier to toggle button ([#3140](https://github.com/patternfly/patternfly-react/issues/3140)) ([6dda90a](https://github.com/patternfly/patternfly-react/commit/6dda90a)), closes [#3128](https://github.com/patternfly/patternfly-react/issues/3128)
* **Select:** display typeahead filtered options ([#3158](https://github.com/patternfly/patternfly-react/issues/3158)) ([ca4dff7](https://github.com/patternfly/patternfly-react/commit/ca4dff7))





## [3.117.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.117.3...@patternfly/react-core@3.117.4) (2019-10-22)

**Note:** Version bump only for package @patternfly/react-core





## [3.117.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.117.2...@patternfly/react-core@3.117.3) (2019-10-21)

**Note:** Version bump only for package @patternfly/react-core





## [3.117.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.117.1...@patternfly/react-core@3.117.2) (2019-10-21)


### Bug Fixes

* **copytoclipboard:** wrap pre inside the expand element ([#3169](https://github.com/patternfly/patternfly-react/issues/3169)) ([b89f1d3](https://github.com/patternfly/patternfly-react/commit/b89f1d3))





## [3.117.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.117.0...@patternfly/react-core@3.117.1) (2019-10-21)

**Note:** Version bump only for package @patternfly/react-core





# [3.117.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.116.3...@patternfly/react-core@3.117.0) (2019-10-18)


### Features

* **docs:** use gatsby-theme-patternfly-org ([#3146](https://github.com/patternfly/patternfly-react/issues/3146)) ([93c843b](https://github.com/patternfly/patternfly-react/commit/93c843b))





## [3.116.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.116.2...@patternfly/react-core@3.116.3) (2019-10-18)


### Bug Fixes

* **OUIA:** Use consumer context if specified ([#3149](https://github.com/patternfly/patternfly-react/issues/3149)) ([07de08d](https://github.com/patternfly/patternfly-react/commit/07de08d))





## [3.116.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.116.1...@patternfly/react-core@3.116.2) (2019-10-17)

**Note:** Version bump only for package @patternfly/react-core





## [3.116.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.116.0...@patternfly/react-core@3.116.1) (2019-10-15)


### Bug Fixes

* **switch:** revert defaultChecked to checked ([#3037](https://github.com/patternfly/patternfly-react/issues/3037)) ([329146c](https://github.com/patternfly/patternfly-react/commit/329146c))





# [3.116.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.115.3...@patternfly/react-core@3.116.0) (2019-10-15)


### Bug Fixes

* **Radio:** Fix console error ([#3138](https://github.com/patternfly/patternfly-react/issues/3138)) ([3e432b8](https://github.com/patternfly/patternfly-react/commit/3e432b8)), closes [#3111](https://github.com/patternfly/patternfly-react/issues/3111)


### Features

* **aboutmodal,wizard:** append component to any element in DOM ([#3102](https://github.com/patternfly/patternfly-react/issues/3102)) ([ec9d5dd](https://github.com/patternfly/patternfly-react/commit/ec9d5dd))





## [3.115.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.115.2...@patternfly/react-core@3.115.3) (2019-10-14)

**Note:** Version bump only for package @patternfly/react-core





## [3.115.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.115.1...@patternfly/react-core@3.115.2) (2019-10-14)

**Note:** Version bump only for package @patternfly/react-core





## [3.115.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.115.0...@patternfly/react-core@3.115.1) (2019-10-14)

**Note:** Version bump only for package @patternfly/react-core





# [3.115.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.114.4...@patternfly/react-core@3.115.0) (2019-10-11)


### Bug Fixes

* **Dropdown/Application Launcher/Options Menu:** Fix unit tests and options menu ([#3107](https://github.com/patternfly/patternfly-react/issues/3107)) ([e54f158](https://github.com/patternfly/patternfly-react/commit/e54f158)), closes [#3029](https://github.com/patternfly/patternfly-react/issues/3029)


### Features

* **tooltip:** allow tooltip text to be left-aligned ([#3053](https://github.com/patternfly/patternfly-react/issues/3053)) ([d369c07](https://github.com/patternfly/patternfly-react/commit/d369c07))





## [3.114.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.114.3...@patternfly/react-core@3.114.4) (2019-10-11)


### Bug Fixes

* **Select:** use props children if custom on filter used ([#3123](https://github.com/patternfly/patternfly-react/issues/3123)) ([b20a624](https://github.com/patternfly/patternfly-react/commit/b20a624)), closes [#3117](https://github.com/patternfly/patternfly-react/issues/3117)





## [3.114.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.114.2...@patternfly/react-core@3.114.3) (2019-10-11)


### Bug Fixes

* **Select:** Modifying selection outside now works ([#3096](https://github.com/patternfly/patternfly-react/issues/3096)) ([bbe99f3](https://github.com/patternfly/patternfly-react/commit/bbe99f3))





## [3.114.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.114.1...@patternfly/react-core@3.114.2) (2019-10-11)

**Note:** Version bump only for package @patternfly/react-core





## [3.114.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.114.0...@patternfly/react-core@3.114.1) (2019-10-11)

**Note:** Version bump only for package @patternfly/react-core





# [3.114.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.113.4...@patternfly/react-core@3.114.0) (2019-10-10)


### Features

* **Expandable:** Allow for dynamic toggle text in uncontrolled version ([#3068](https://github.com/patternfly/patternfly-react/issues/3068)) ([3c6e4b6](https://github.com/patternfly/patternfly-react/commit/3c6e4b6)), closes [#2914](https://github.com/patternfly/patternfly-react/issues/2914)





## [3.113.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.113.3...@patternfly/react-core@3.113.4) (2019-10-09)

**Note:** Version bump only for package @patternfly/react-core





## [3.113.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.113.2...@patternfly/react-core@3.113.3) (2019-10-08)


### Bug Fixes

* **loginform:** pass 'remember me' state to isChecked ([#3056](https://github.com/patternfly/patternfly-react/issues/3056)) ([3d3a0ce](https://github.com/patternfly/patternfly-react/commit/3d3a0ce))





## [3.113.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.113.1...@patternfly/react-core@3.113.2) (2019-10-08)


### Bug Fixes

* **button:** component type should accept react-router Link ([#3077](https://github.com/patternfly/patternfly-react/issues/3077)) ([85c8e29](https://github.com/patternfly/patternfly-react/commit/85c8e29))





## [3.113.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.113.0...@patternfly/react-core@3.113.1) (2019-10-07)

**Note:** Version bump only for package @patternfly/react-core





# [3.113.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.10...@patternfly/react-core@3.113.0) (2019-10-07)


### Features

* **Chip:** Added OUIA compatibility to Chip component  ([#2995](https://github.com/patternfly/patternfly-react/issues/2995)) ([bd358b6](https://github.com/patternfly/patternfly-react/commit/bd358b6))





## [3.112.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.9...@patternfly/react-core@3.112.10) (2019-10-04)


### Bug Fixes

* **Select:** Allow custom components as select option ([#3064](https://github.com/patternfly/patternfly-react/issues/3064)) ([21a7d96](https://github.com/patternfly/patternfly-react/commit/21a7d96)), closes [#3060](https://github.com/patternfly/patternfly-react/issues/3060)





## [3.112.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.8...@patternfly/react-core@3.112.9) (2019-10-03)


### Bug Fixes

* **Radio:** pass checked either from isChecked or checked ([#3066](https://github.com/patternfly/patternfly-react/issues/3066)) ([51c59fb](https://github.com/patternfly/patternfly-react/commit/51c59fb))





## [3.112.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.7...@patternfly/react-core@3.112.8) (2019-10-03)

**Note:** Version bump only for package @patternfly/react-core





## [3.112.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.6...@patternfly/react-core@3.112.7) (2019-10-03)


### Bug Fixes

* **radio:** align radio examples to pf4-core ([#2684](https://github.com/patternfly/patternfly-react/issues/2684)) ([de22a80](https://github.com/patternfly/patternfly-react/commit/de22a80))





## [3.112.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.5...@patternfly/react-core@3.112.6) (2019-10-03)

**Note:** Version bump only for package @patternfly/react-core





## [3.112.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.4...@patternfly/react-core@3.112.5) (2019-10-02)

**Note:** Version bump only for package @patternfly/react-core





## [3.112.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.3...@patternfly/react-core@3.112.4) (2019-10-02)

**Note:** Version bump only for package @patternfly/react-core





## [3.112.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.2...@patternfly/react-core@3.112.3) (2019-09-30)

**Note:** Version bump only for package @patternfly/react-core





## [3.112.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.1...@patternfly/react-core@3.112.2) (2019-09-30)


### Bug Fixes

* **Tabs:** Fix the regression in the Tab class with the title prop ([#3031](https://github.com/patternfly/patternfly-react/issues/3031)) ([53102c8](https://github.com/patternfly/patternfly-react/commit/53102c8)), closes [#3006](https://github.com/patternfly/patternfly-react/issues/3006)





## [3.112.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.112.0...@patternfly/react-core@3.112.1) (2019-09-27)

**Note:** Version bump only for package @patternfly/react-core





# [3.112.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.111.2...@patternfly/react-core@3.112.0) (2019-09-27)


### Features

* **DataToolbar:** add Chip groups to DataToolbar ([#2969](https://github.com/patternfly/patternfly-react/issues/2969)) ([c060bdb](https://github.com/patternfly/patternfly-react/commit/c060bdb))





## [3.111.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.111.1...@patternfly/react-core@3.111.2) (2019-09-26)

**Note:** Version bump only for package @patternfly/react-core





## [3.111.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.111.0...@patternfly/react-core@3.111.1) (2019-09-26)

**Note:** Version bump only for package @patternfly/react-core





# [3.111.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.110.2...@patternfly/react-core@3.111.0) (2019-09-26)


### Features

* **Alert:** Added OUIA compatibility to Alert component ([#2958](https://github.com/patternfly/patternfly-react/issues/2958)) ([dfb609c](https://github.com/patternfly/patternfly-react/commit/dfb609c))





## [3.110.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.110.1...@patternfly/react-core@3.110.2) (2019-09-26)


### Bug Fixes

* **DataToolbar:** add aria-haspopup to the toggle group ([#3012](https://github.com/patternfly/patternfly-react/issues/3012)) ([75e9a2f](https://github.com/patternfly/patternfly-react/commit/75e9a2f)), closes [#2900](https://github.com/patternfly/patternfly-react/issues/2900)





## [3.110.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.110.0...@patternfly/react-core@3.110.1) (2019-09-26)


### Bug Fixes

* **copytoclipboard:** wrap content in pre tag ([#2981](https://github.com/patternfly/patternfly-react/issues/2981)) ([27aa1e4](https://github.com/patternfly/patternfly-react/commit/27aa1e4))
* **Pagination:** Styling discrepancy with HTML version ([#2904](https://github.com/patternfly/patternfly-react/issues/2904)) ([7e6e586](https://github.com/patternfly/patternfly-react/commit/7e6e586))





# [3.110.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.109.0...@patternfly/react-core@3.110.0) (2019-09-25)


### Features

* **emptyState:** support primary and icon as div elements ([#2957](https://github.com/patternfly/patternfly-react/issues/2957)) ([9bb3962](https://github.com/patternfly/patternfly-react/commit/9bb3962))





# [3.109.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.108.0...@patternfly/react-core@3.109.0) (2019-09-25)


### Features

* **Pagination:** add compact variation flag ([#2998](https://github.com/patternfly/patternfly-react/issues/2998)) ([fcc5e90](https://github.com/patternfly/patternfly-react/commit/fcc5e90))





# [3.108.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.107.0...@patternfly/react-core@3.108.0) (2019-09-25)


### Features

* **Flex:** Added support for flex layout, tests, etc. ([#2985](https://github.com/patternfly/patternfly-react/issues/2985)) ([bc5af59](https://github.com/patternfly/patternfly-react/commit/bc5af59)), closes [#2860](https://github.com/patternfly/patternfly-react/issues/2860)





# [3.107.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.106.0...@patternfly/react-core@3.107.0) (2019-09-25)


### Features

* **Select:** add max height property, update tests ([#2946](https://github.com/patternfly/patternfly-react/issues/2946)) ([af0ea5f](https://github.com/patternfly/patternfly-react/commit/af0ea5f))





# [3.106.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.105.4...@patternfly/react-core@3.106.0) (2019-09-25)


### Features

* **Button:** add control variant to button ([#2983](https://github.com/patternfly/patternfly-react/issues/2983)) ([2c7dd72](https://github.com/patternfly/patternfly-react/commit/2c7dd72))





## [3.105.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.105.3...@patternfly/react-core@3.105.4) (2019-09-25)


### Bug Fixes

* **Select:** Add props for hard coded strings ([#2993](https://github.com/patternfly/patternfly-react/issues/2993)) ([1377c7e](https://github.com/patternfly/patternfly-react/commit/1377c7e)), closes [#2901](https://github.com/patternfly/patternfly-react/issues/2901)





## [3.105.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.105.2...@patternfly/react-core@3.105.3) (2019-09-25)


### Bug Fixes

* **dropdown:** disabled button only applies disabled attribute ([#2989](https://github.com/patternfly/patternfly-react/issues/2989)) ([951816f](https://github.com/patternfly/patternfly-react/commit/951816f))





## [3.105.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.105.1...@patternfly/react-core@3.105.2) (2019-09-25)

**Note:** Version bump only for package @patternfly/react-core





## [3.105.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.105.0...@patternfly/react-core@3.105.1) (2019-09-24)

**Note:** Version bump only for package @patternfly/react-core





# [3.105.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.12...@patternfly/react-core@3.105.0) (2019-09-23)


### Bug Fixes

* **Dropdown split button:** Add 3rd state to split button ([#2842](https://github.com/patternfly/patternfly-react/issues/2842)) ([6cb6424](https://github.com/patternfly/patternfly-react/commit/6cb6424))


### Features

* **Tab:** Added two new props: mountOnEnter and unmountOnExit ([#2902](https://github.com/patternfly/patternfly-react/issues/2902)) ([dcc0ccb](https://github.com/patternfly/patternfly-react/commit/dcc0ccb)), closes [#2609](https://github.com/patternfly/patternfly-react/issues/2609)





## [3.104.12](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.11...@patternfly/react-core@3.104.12) (2019-09-20)

**Note:** Version bump only for package @patternfly/react-core





## [3.104.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.10...@patternfly/react-core@3.104.11) (2019-09-20)

**Note:** Version bump only for package @patternfly/react-core





## [3.104.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.9...@patternfly/react-core@3.104.10) (2019-09-19)

**Note:** Version bump only for package @patternfly/react-core





## [3.104.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.8...@patternfly/react-core@3.104.9) (2019-09-19)

**Note:** Version bump only for package @patternfly/react-core





## [3.104.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.7...@patternfly/react-core@3.104.8) (2019-09-19)


### Bug Fixes

* **button:** set the disable modifier when component is not button ([#2683](https://github.com/patternfly/patternfly-react/issues/2683)) ([39b359d](https://github.com/patternfly/patternfly-react/commit/39b359d))





## [3.104.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.6...@patternfly/react-core@3.104.7) (2019-09-19)


### Bug Fixes

* **copyclipboard:** add prop for expanded by default ([#2923](https://github.com/patternfly/patternfly-react/issues/2923)) ([8cd5d13](https://github.com/patternfly/patternfly-react/commit/8cd5d13))





## [3.104.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.5...@patternfly/react-core@3.104.6) (2019-09-18)


### Bug Fixes

* **Select:** display selections data properly ([#2848](https://github.com/patternfly/patternfly-react/issues/2848)) ([5dc05eb](https://github.com/patternfly/patternfly-react/commit/5dc05eb))
* **switch:** backward compatibility in case labelOff is not set ([#2816](https://github.com/patternfly/patternfly-react/issues/2816)) ([f2d0969](https://github.com/patternfly/patternfly-react/commit/f2d0969))
* **Wizard:** adds default function to onClose prop ([#2863](https://github.com/patternfly/patternfly-react/issues/2863)) ([4773f18](https://github.com/patternfly/patternfly-react/commit/4773f18))





## [3.104.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.4...@patternfly/react-core@3.104.5) (2019-09-17)

**Note:** Version bump only for package @patternfly/react-core





## [3.104.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.3...@patternfly/react-core@3.104.4) (2019-09-17)


### Bug Fixes

* **chipgroup:** allow chipgroup toolbar item to handle single chip ([#2882](https://github.com/patternfly/patternfly-react/issues/2882)) ([3d9881f](https://github.com/patternfly/patternfly-react/commit/3d9881f))





## [3.104.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.2...@patternfly/react-core@3.104.3) (2019-09-17)

**Note:** Version bump only for package @patternfly/react-core





## [3.104.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.1...@patternfly/react-core@3.104.2) (2019-09-16)


### Bug Fixes

* **chipGroup:** Allow variable number of chips to be displayed ([#2878](https://github.com/patternfly/patternfly-react/issues/2878)) ([6bbff0c](https://github.com/patternfly/patternfly-react/commit/6bbff0c))





## [3.104.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.104.0...@patternfly/react-core@3.104.1) (2019-09-13)

**Note:** Version bump only for package @patternfly/react-core





# [3.104.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.103.4...@patternfly/react-core@3.104.0) (2019-09-10)


### Features

* **DataToolbar:** Add Data Toolbar component to experimental ([#2861](https://github.com/patternfly/patternfly-react/issues/2861)) ([6ec0ce4](https://github.com/patternfly/patternfly-react/commit/6ec0ce4))





## [3.103.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.103.3...@patternfly/react-core@3.103.4) (2019-09-10)


### Bug Fixes

* **FormGroup:** Also add className if not inline ([#2864](https://github.com/patternfly/patternfly-react/issues/2864)) ([5368124](https://github.com/patternfly/patternfly-react/commit/5368124))





## [3.103.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.103.2...@patternfly/react-core@3.103.3) (2019-09-10)

**Note:** Version bump only for package @patternfly/react-core





## [3.103.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.103.1...@patternfly/react-core@3.103.2) (2019-09-09)


### Bug Fixes

* **dropdown:** extract DropdownWithContext ([#2872](https://github.com/patternfly/patternfly-react/issues/2872)) ([5acd5cd](https://github.com/patternfly/patternfly-react/commit/5acd5cd))





## [3.103.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.103.0...@patternfly/react-core@3.103.1) (2019-09-09)

**Note:** Version bump only for package @patternfly/react-core





# [3.103.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.102.1...@patternfly/react-core@3.103.0) (2019-09-09)


### Features

* **Split button:** Allow texts in split button ([#2840](https://github.com/patternfly/patternfly-react/issues/2840)) ([7b379bf](https://github.com/patternfly/patternfly-react/commit/7b379bf))





## [3.102.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.102.0...@patternfly/react-core@3.102.1) (2019-09-09)

**Note:** Version bump only for package @patternfly/react-core





# [3.102.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.101.0...@patternfly/react-core@3.102.0) (2019-09-06)


### Features

* **Page, Nav:** add dark theme modifier flag ([#2856](https://github.com/patternfly/patternfly-react/issues/2856)) ([9c5f336](https://github.com/patternfly/patternfly-react/commit/9c5f336))





# [3.101.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.100.0...@patternfly/react-core@3.101.0) (2019-09-06)


### Features

* **accordion:** add content and toggle container props ([#2713](https://github.com/patternfly/patternfly-react/issues/2713)) ([2c50a68](https://github.com/patternfly/patternfly-react/commit/2c50a68))
* **Select:** add creatable and new features ([#2820](https://github.com/patternfly/patternfly-react/issues/2820)) ([f16e0f3](https://github.com/patternfly/patternfly-react/commit/f16e0f3))
* **tab:** support JSX elements in Tab title ([#2681](https://github.com/patternfly/patternfly-react/issues/2681)) ([e6d04fd](https://github.com/patternfly/patternfly-react/commit/e6d04fd))





# [3.100.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.99.4...@patternfly/react-core@3.100.0) (2019-09-06)


### Features

* **Spinner:** Add Spinner to experimental ([#2858](https://github.com/patternfly/patternfly-react/issues/2858)) ([77afa63](https://github.com/patternfly/patternfly-react/commit/77afa63)), closes [#2753](https://github.com/patternfly/patternfly-react/issues/2753)





## [3.99.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.99.3...@patternfly/react-core@3.99.4) (2019-09-06)


### Bug Fixes

* **ClipboardCopy:** Update if children change ([#2849](https://github.com/patternfly/patternfly-react/issues/2849)) ([b5252f6](https://github.com/patternfly/patternfly-react/commit/b5252f6))
* **switch:** use defaultChecked instead of checked ([#2749](https://github.com/patternfly/patternfly-react/issues/2749)) ([42f7720](https://github.com/patternfly/patternfly-react/commit/42f7720))





## [3.99.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.99.2...@patternfly/react-core@3.99.3) (2019-09-06)

**Note:** Version bump only for package @patternfly/react-core





## [3.99.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.99.1...@patternfly/react-core@3.99.2) (2019-09-06)

**Note:** Version bump only for package @patternfly/react-core





## [3.99.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.99.0...@patternfly/react-core@3.99.1) (2019-09-06)

**Note:** Version bump only for package @patternfly/react-core





# [3.99.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.98.0...@patternfly/react-core@3.99.0) (2019-09-06)


### Features

* **Modal:** add modifier to left align Modal footer ([#2835](https://github.com/patternfly/patternfly-react/issues/2835)) ([e6c7694](https://github.com/patternfly/patternfly-react/commit/e6c7694)), closes [#2744](https://github.com/patternfly/patternfly-react/issues/2744)





# [3.98.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.97.0...@patternfly/react-core@3.98.0) (2019-09-05)


### Features

* **Dropdown:** Added support for dropdown with primary button toggle ([#2857](https://github.com/patternfly/patternfly-react/issues/2857)) ([48b0d3a](https://github.com/patternfly/patternfly-react/commit/48b0d3a)), closes [#2750](https://github.com/patternfly/patternfly-react/issues/2750)





# [3.97.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.96.0...@patternfly/react-core@3.97.0) (2019-09-05)


### Features

* **Wizard:** add support for in page rendering ([#2830](https://github.com/patternfly/patternfly-react/issues/2830)) ([bf96474](https://github.com/patternfly/patternfly-react/commit/bf96474))





# [3.96.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.95.6...@patternfly/react-core@3.96.0) (2019-09-05)


### Features

* **experimental:** add alert states for docs ([#2809](https://github.com/patternfly/patternfly-react/issues/2809)) ([7ec8f1a](https://github.com/patternfly/patternfly-react/commit/7ec8f1a))





## [3.95.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.95.5...@patternfly/react-core@3.95.6) (2019-09-04)

**Note:** Version bump only for package @patternfly/react-core





## [3.95.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.95.4...@patternfly/react-core@3.95.5) (2019-09-04)

**Note:** Version bump only for package @patternfly/react-core





## [3.95.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.95.3...@patternfly/react-core@3.95.4) (2019-09-03)

**Note:** Version bump only for package @patternfly/react-core





## [3.95.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.95.2...@patternfly/react-core@3.95.3) (2019-09-03)

**Note:** Version bump only for package @patternfly/react-core





## [3.95.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.95.1...@patternfly/react-core@3.95.2) (2019-08-30)

**Note:** Version bump only for package @patternfly/react-core





## [3.95.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.95.0...@patternfly/react-core@3.95.1) (2019-08-30)


### Bug Fixes

* **ActionGroup:** Remove unneeded Action import ([#2785](https://github.com/patternfly/patternfly-react/issues/2785)) ([2b20276](https://github.com/patternfly/patternfly-react/commit/2b20276)), closes [#2745](https://github.com/patternfly/patternfly-react/issues/2745)





# [3.95.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.94.3...@patternfly/react-core@3.95.0) (2019-08-30)


### Features

* **PF4 - Drawer:** Update drawer to expose all parts ([#2733](https://github.com/patternfly/patternfly-react/issues/2733)) ([fad9cc6](https://github.com/patternfly/patternfly-react/commit/fad9cc6))





## [3.94.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.94.2...@patternfly/react-core@3.94.3) (2019-08-30)


### Bug Fixes

* **Modal:** FocusTrap works with showClose being false ([#2774](https://github.com/patternfly/patternfly-react/issues/2774)) ([aa23ca8](https://github.com/patternfly/patternfly-react/commit/aa23ca8))





## [3.94.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.94.1...@patternfly/react-core@3.94.2) (2019-08-29)

**Note:** Version bump only for package @patternfly/react-core





## [3.94.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.94.0...@patternfly/react-core@3.94.1) (2019-08-28)


### Bug Fixes

* **clipboardcopy:** change type to window.settimeout ([#2740](https://github.com/patternfly/patternfly-react/issues/2740)) ([a0ed960](https://github.com/patternfly/patternfly-react/commit/a0ed960))





# [3.94.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.93.1...@patternfly/react-core@3.94.0) (2019-08-27)


### Features

* **select:** add support for toggle icon ([#2748](https://github.com/patternfly/patternfly-react/issues/2748)) ([f5c3a94](https://github.com/patternfly/patternfly-react/commit/f5c3a94))





## [3.93.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.93.0...@patternfly/react-core@3.93.1) (2019-08-27)

**Note:** Version bump only for package @patternfly/react-core





# [3.93.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.92.3...@patternfly/react-core@3.93.0) (2019-08-26)


### Features

* **PF4 Option:** Rewrite options menu to use dropdown component ([#2299](https://github.com/patternfly/patternfly-react/issues/2299)) ([e18b407](https://github.com/patternfly/patternfly-react/commit/e18b407))





## [3.92.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.92.2...@patternfly/react-core@3.92.3) (2019-08-26)


### Bug Fixes

* **button:** add reset to ButtonType enum ([#2781](https://github.com/patternfly/patternfly-react/issues/2781)) ([0d1716d](https://github.com/patternfly/patternfly-react/commit/0d1716d))





## [3.92.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.92.1...@patternfly/react-core@3.92.2) (2019-08-26)

**Note:** Version bump only for package @patternfly/react-core





## [3.92.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.92.0...@patternfly/react-core@3.92.1) (2019-08-26)


### Bug Fixes

* **tooltip:** allow manul trigger, access to tippy.js props ([#2769](https://github.com/patternfly/patternfly-react/issues/2769)) ([de6b211](https://github.com/patternfly/patternfly-react/commit/de6b211))





# [3.92.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.91.0...@patternfly/react-core@3.92.0) (2019-08-26)


### Features

* **Button:** Added OUIA compatibility to Button component ([#2710](https://github.com/patternfly/patternfly-react/issues/2710)) ([d96116c](https://github.com/patternfly/patternfly-react/commit/d96116c)), closes [#2425](https://github.com/patternfly/patternfly-react/issues/2425)





# [3.91.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.90.2...@patternfly/react-core@3.91.0) (2019-08-23)


### Bug Fixes

* **emptyState:** set the correct size modifier using the  variant prop ([#2692](https://github.com/patternfly/patternfly-react/issues/2692)) ([26e653b](https://github.com/patternfly/patternfly-react/commit/26e653b))


### Features

* **Tabs:** Added OUIA compatibility to Tabs component ([#2704](https://github.com/patternfly/patternfly-react/issues/2704)) ([e759244](https://github.com/patternfly/patternfly-react/commit/e759244)), closes [#2303](https://github.com/patternfly/patternfly-react/issues/2303)





## [3.90.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.90.1...@patternfly/react-core@3.90.2) (2019-08-23)

**Note:** Version bump only for package @patternfly/react-core





## [3.90.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.90.0...@patternfly/react-core@3.90.1) (2019-08-21)


### Bug Fixes

* **loginForm:** adds autoFocus to username input ([#2659](https://github.com/patternfly/patternfly-react/issues/2659)) ([9a1f1c7](https://github.com/patternfly/patternfly-react/commit/9a1f1c7))





# [3.90.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.89.3...@patternfly/react-core@3.90.0) (2019-08-21)


### Features

* **Expandable:** Support uncontrolled expandable ([#2649](https://github.com/patternfly/patternfly-react/issues/2649)) ([2755e36](https://github.com/patternfly/patternfly-react/commit/2755e36))





## [3.89.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.89.2...@patternfly/react-core@3.89.3) (2019-08-21)

**Note:** Version bump only for package @patternfly/react-core





## [3.89.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.89.1...@patternfly/react-core@3.89.2) (2019-08-20)

**Note:** Version bump only for package @patternfly/react-core





## [3.89.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.89.0...@patternfly/react-core@3.89.1) (2019-08-20)


### Bug Fixes

* **formselect:** adds isRequired prop ([#2645](https://github.com/patternfly/patternfly-react/issues/2645)) ([c74baa4](https://github.com/patternfly/patternfly-react/commit/c74baa4))





# [3.89.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.88.3...@patternfly/react-core@3.89.0) (2019-08-19)


### Features

* **charts:** add bullet chart ([#2708](https://github.com/patternfly/patternfly-react/issues/2708)) ([c871fff](https://github.com/patternfly/patternfly-react/commit/c871fff))





## [3.88.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.88.2...@patternfly/react-core@3.88.3) (2019-08-19)

**Note:** Version bump only for package @patternfly/react-core





## [3.88.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.88.1...@patternfly/react-core@3.88.2) (2019-08-19)

**Note:** Version bump only for package @patternfly/react-core





## [3.88.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.88.0...@patternfly/react-core@3.88.1) (2019-08-19)

**Note:** Version bump only for package @patternfly/react-core





# [3.88.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.87.4...@patternfly/react-core@3.88.0) (2019-08-19)


### Features

* **Select:** adds direction prop to Select ([#2611](https://github.com/patternfly/patternfly-react/issues/2611)) ([f192742](https://github.com/patternfly/patternfly-react/commit/f192742))





## [3.87.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.87.3...@patternfly/react-core@3.87.4) (2019-08-19)

**Note:** Version bump only for package @patternfly/react-core





## [3.87.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.87.2...@patternfly/react-core@3.87.3) (2019-08-16)

**Note:** Version bump only for package @patternfly/react-core





## [3.87.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.87.1...@patternfly/react-core@3.87.2) (2019-08-16)

**Note:** Version bump only for package @patternfly/react-core





## [3.87.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.87.0...@patternfly/react-core@3.87.1) (2019-08-15)

**Note:** Version bump only for package @patternfly/react-core





# [3.87.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.86.4...@patternfly/react-core@3.87.0) (2019-08-15)


### Features

* **Dropdown:** adds missing class, changes icon type in toggle ([#2702](https://github.com/patternfly/patternfly-react/issues/2702)) ([0f50fda](https://github.com/patternfly/patternfly-react/commit/0f50fda))





## [3.86.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.86.3...@patternfly/react-core@3.86.4) (2019-08-14)


### Bug Fixes

* **Dropdown:** Spread props to Dropdown toggle to fix regression ([#2690](https://github.com/patternfly/patternfly-react/issues/2690)) ([549b0bd](https://github.com/patternfly/patternfly-react/commit/549b0bd)), closes [#2689](https://github.com/patternfly/patternfly-react/issues/2689)





## [3.86.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.86.2...@patternfly/react-core@3.86.3) (2019-08-13)

**Note:** Version bump only for package @patternfly/react-core





## [3.86.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.86.1...@patternfly/react-core@3.86.2) (2019-08-13)


### Bug Fixes

* **inline-styles:** remove inject and Stylesheet.parse inline references ([#2653](https://github.com/patternfly/patternfly-react/issues/2653)) ([ee2ca95](https://github.com/patternfly/patternfly-react/commit/ee2ca95))





## [3.86.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.86.0...@patternfly/react-core@3.86.1) (2019-08-12)

**Note:** Version bump only for package @patternfly/react-core





# [3.86.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.85.1...@patternfly/react-core@3.86.0) (2019-08-09)


### Features

* **Select:** add disabled flag for component ([#2678](https://github.com/patternfly/patternfly-react/issues/2678)) ([a72124f](https://github.com/patternfly/patternfly-react/commit/a72124f))





## [3.85.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.85.0...@patternfly/react-core@3.85.1) (2019-08-09)

**Note:** Version bump only for package @patternfly/react-core





# [3.85.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.84.1...@patternfly/react-core@3.85.0) (2019-08-09)


### Features

* **drawer:** Added the drawer component to experimental ([#2633](https://github.com/patternfly/patternfly-react/issues/2633)) ([ff6d905](https://github.com/patternfly/patternfly-react/commit/ff6d905)), closes [#1938](https://github.com/patternfly/patternfly-react/issues/1938)





## [3.84.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.84.0...@patternfly/react-core@3.84.1) (2019-08-09)


### Bug Fixes

* **docs:** Fix a11y issues in Documentation ([#2634](https://github.com/patternfly/patternfly-react/issues/2634)) ([b0d29a3](https://github.com/patternfly/patternfly-react/commit/b0d29a3))





# [3.84.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.83.0...@patternfly/react-core@3.84.0) (2019-08-08)


### Bug Fixes

* **Checkbox:** Updated ids so none repeat ([#2663](https://github.com/patternfly/patternfly-react/issues/2663)) ([6319986](https://github.com/patternfly/patternfly-react/commit/6319986)), closes [#2619](https://github.com/patternfly/patternfly-react/issues/2619)


### Features

* **Pagination:** add disabled flag for whole component ([#2586](https://github.com/patternfly/patternfly-react/issues/2586)) ([7683f68](https://github.com/patternfly/patternfly-react/commit/7683f68))





# [3.83.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.82.4...@patternfly/react-core@3.83.0) (2019-08-08)


### Bug Fixes

* **select:** disable focus trap on checkbox select with no children ([#2647](https://github.com/patternfly/patternfly-react/issues/2647)) ([f5f6ab6](https://github.com/patternfly/patternfly-react/commit/f5f6ab6))


### Features

* **Select:** Adds the ability to pass in a user defined object ([#2612](https://github.com/patternfly/patternfly-react/issues/2612)) ([9037033](https://github.com/patternfly/patternfly-react/commit/9037033)), closes [#2045](https://github.com/patternfly/patternfly-react/issues/2045)





## [3.82.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.82.3...@patternfly/react-core@3.82.4) (2019-08-07)


### Bug Fixes

* **Dropdown:** pass event object through onSelect ([#2657](https://github.com/patternfly/patternfly-react/issues/2657)) ([078fe56](https://github.com/patternfly/patternfly-react/commit/078fe56))





## [3.82.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.82.2...@patternfly/react-core@3.82.3) (2019-08-06)

**Note:** Version bump only for package @patternfly/react-core





## [3.82.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.82.1...@patternfly/react-core@3.82.2) (2019-08-06)


### Bug Fixes

* **Pagination:** Fix pagination to update page count ([#2639](https://github.com/patternfly/patternfly-react/issues/2639)) ([ff9c745](https://github.com/patternfly/patternfly-react/commit/ff9c745))





## [3.82.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.82.0...@patternfly/react-core@3.82.1) (2019-08-05)

**Note:** Version bump only for package @patternfly/react-core





# [3.82.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.81.0...@patternfly/react-core@3.82.0) (2019-08-05)


### Features

* **Page:** Allow the nav to default to closed for managed sidebar ([#2608](https://github.com/patternfly/patternfly-react/issues/2608)) ([6489375](https://github.com/patternfly/patternfly-react/commit/6489375)), closes [#1658](https://github.com/patternfly/patternfly-react/issues/1658)





# [3.81.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.80.4...@patternfly/react-core@3.81.0) (2019-08-02)


### Features

* **switch:** add aria-labelledby to input ([#2468](https://github.com/patternfly/patternfly-react/issues/2468)) ([0f7cd6e](https://github.com/patternfly/patternfly-react/commit/0f7cd6e))





## [3.80.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.80.3...@patternfly/react-core@3.80.4) (2019-08-02)


### Bug Fixes

* **Select:** Prevent select from submitting forms ([#2621](https://github.com/patternfly/patternfly-react/issues/2621)) ([37f0a99](https://github.com/patternfly/patternfly-react/commit/37f0a99)), closes [#2029](https://github.com/patternfly/patternfly-react/issues/2029)





## [3.80.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.80.2...@patternfly/react-core@3.80.3) (2019-08-01)


### Bug Fixes

* **button:** add 'reset' to types ([#2622](https://github.com/patternfly/patternfly-react/issues/2622)) ([8ee40c0](https://github.com/patternfly/patternfly-react/commit/8ee40c0))
* **select:** add isPlain variation/prop to Select.tsx, snapshot tests, and integration ([#2588](https://github.com/patternfly/patternfly-react/issues/2588)) ([0809b28](https://github.com/patternfly/patternfly-react/commit/0809b28))





## [3.80.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.80.1...@patternfly/react-core@3.80.2) (2019-07-30)

**Note:** Version bump only for package @patternfly/react-core





## [3.80.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.80.0...@patternfly/react-core@3.80.1) (2019-07-30)

**Note:** Version bump only for package @patternfly/react-core





# [3.80.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.79.0...@patternfly/react-core@3.80.0) (2019-07-30)


### Features

* **accordion:** add definition list use case ([#2422](https://github.com/patternfly/patternfly-react/issues/2422)) ([7211713](https://github.com/patternfly/patternfly-react/commit/7211713))





# [3.79.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.78.0...@patternfly/react-core@3.79.0) (2019-07-30)


### Features

* **Modal:** Allow custom header and footer ([#2120](https://github.com/patternfly/patternfly-react/issues/2120)) ([9d2f157](https://github.com/patternfly/patternfly-react/commit/9d2f157))





# [3.78.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.77.2...@patternfly/react-core@3.78.0) (2019-07-29)


### Bug Fixes

* **Dropdown:** adds aria-label for icon only example ([#2517](https://github.com/patternfly/patternfly-react/issues/2517)) ([dd2dc02](https://github.com/patternfly/patternfly-react/commit/dd2dc02))


### Features

* **Select:** add select custom filter callback ([#2434](https://github.com/patternfly/patternfly-react/issues/2434)) ([878a107](https://github.com/patternfly/patternfly-react/commit/878a107))





## [3.77.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.77.1...@patternfly/react-core@3.77.2) (2019-07-26)


### Bug Fixes

* **page:** skip to content should point to primary content container ([#2519](https://github.com/patternfly/patternfly-react/issues/2519)) ([1f709bd](https://github.com/patternfly/patternfly-react/commit/1f709bd))
* **PF4: Pagination:** When 0 or negative number is passed to Pagintion show 0 pages ([#2558](https://github.com/patternfly/patternfly-react/issues/2558)) ([7dee544](https://github.com/patternfly/patternfly-react/commit/7dee544)), closes [#2557](https://github.com/patternfly/patternfly-react/issues/2557)





## [3.77.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.77.0...@patternfly/react-core@3.77.1) (2019-07-25)


### Bug Fixes

* **form:** replace radio with check ([#2567](https://github.com/patternfly/patternfly-react/issues/2567)) ([f5516de](https://github.com/patternfly/patternfly-react/commit/f5516de))





# [3.77.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.76.0...@patternfly/react-core@3.77.0) (2019-07-25)


### Features

* **Dropdown:** Convert dropdown to typescript ([#2502](https://github.com/patternfly/patternfly-react/issues/2502)) ([14474fe](https://github.com/patternfly/patternfly-react/commit/14474fe))





# [3.76.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.75.3...@patternfly/react-core@3.76.0) (2019-07-25)


### Features

* **Tooltip:** Added support for aria prop from Tippy library ([#2539](https://github.com/patternfly/patternfly-react/issues/2539)) ([54dce53](https://github.com/patternfly/patternfly-react/commit/54dce53)), closes [#1458](https://github.com/patternfly/patternfly-react/issues/1458)





## [3.75.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.75.2...@patternfly/react-core@3.75.3) (2019-07-24)

**Note:** Version bump only for package @patternfly/react-core





## [3.75.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.75.1...@patternfly/react-core@3.75.2) (2019-07-24)

**Note:** Version bump only for package @patternfly/react-core





## [3.75.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.75.0...@patternfly/react-core@3.75.1) (2019-07-22)

**Note:** Version bump only for package @patternfly/react-core





# [3.75.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.74.0...@patternfly/react-core@3.75.0) (2019-07-22)


### Features

* **experimental:** add POC for experimental button and badge ([#2363](https://github.com/patternfly/patternfly-react/issues/2363)) ([3d4d322](https://github.com/patternfly/patternfly-react/commit/3d4d322))





# [3.74.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.73.2...@patternfly/react-core@3.74.0) (2019-07-22)


### Features

* **Select:** update typeahead filtered list when children change ([#2518](https://github.com/patternfly/patternfly-react/issues/2518)) ([85562fe](https://github.com/patternfly/patternfly-react/commit/85562fe))





## [3.73.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.73.1...@patternfly/react-core@3.73.2) (2019-07-22)

**Note:** Version bump only for package @patternfly/react-core





## [3.73.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.73.0...@patternfly/react-core@3.73.1) (2019-07-18)

**Note:** Version bump only for package @patternfly/react-core





# [3.73.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.72.3...@patternfly/react-core@3.73.0) (2019-07-17)


### Features

* **Tabs:** Implement overflow styles for secondary tabs ([#2512](https://github.com/patternfly/patternfly-react/issues/2512)) ([d840c4d](https://github.com/patternfly/patternfly-react/commit/d840c4d))





## [3.72.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.72.2...@patternfly/react-core@3.72.3) (2019-07-17)

**Note:** Version bump only for package @patternfly/react-core





## [3.72.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.72.1...@patternfly/react-core@3.72.2) (2019-07-16)

**Note:** Version bump only for package @patternfly/react-core





## [3.72.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.72.0...@patternfly/react-core@3.72.1) (2019-07-15)


### Bug Fixes

* **options menu:** update examples to trigger select on the whole item ([#2513](https://github.com/patternfly/patternfly-react/issues/2513)) ([a533a7c](https://github.com/patternfly/patternfly-react/commit/a533a7c))





# [3.72.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.71.0...@patternfly/react-core@3.72.0) (2019-07-12)


### Features

* **EmptyState:** update EmptyStateBody to use <div> instead of <p> ([#2499](https://github.com/patternfly/patternfly-react/issues/2499)) ([233fe25](https://github.com/patternfly/patternfly-react/commit/233fe25)), closes [#2494](https://github.com/patternfly/patternfly-react/issues/2494)





# [3.71.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.70.1...@patternfly/react-core@3.71.0) (2019-07-12)


### Features

* **Select:** add optional display via children to option ([#2419](https://github.com/patternfly/patternfly-react/issues/2419)) ([03be1a7](https://github.com/patternfly/patternfly-react/commit/03be1a7))





## [3.70.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.70.0...@patternfly/react-core@3.70.1) (2019-07-11)


### Bug Fixes

* **login page:** removes ariaLabel from checkbox ([#2455](https://github.com/patternfly/patternfly-react/issues/2455)) ([3cf57e3](https://github.com/patternfly/patternfly-react/commit/3cf57e3))





# [3.70.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.69.0...@patternfly/react-core@3.70.0) (2019-07-11)


### Features

* **Pagination:** Let users enter numbers into the input field ([#2417](https://github.com/patternfly/patternfly-react/issues/2417)) ([38ed9d8](https://github.com/patternfly/patternfly-react/commit/38ed9d8)), closes [#2344](https://github.com/patternfly/patternfly-react/issues/2344)





# [3.69.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.68.0...@patternfly/react-core@3.69.0) (2019-07-10)


### Features

* **Tabs:** Allow eventKey to accept a string ([#2493](https://github.com/patternfly/patternfly-react/issues/2493)) ([1bde27c](https://github.com/patternfly/patternfly-react/commit/1bde27c)), closes [#1446](https://github.com/patternfly/patternfly-react/issues/1446)





# [3.68.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.67.4...@patternfly/react-core@3.68.0) (2019-07-10)


### Bug Fixes

* **aboutModal+modal:** now trap focus in browser ([#2428](https://github.com/patternfly/patternfly-react/issues/2428)) ([e9d7534](https://github.com/patternfly/patternfly-react/commit/e9d7534))


### Features

* **Grid:** Convert grid to typescript ([#2443](https://github.com/patternfly/patternfly-react/issues/2443)) ([d4f8231](https://github.com/patternfly/patternfly-react/commit/d4f8231))





## [3.67.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.67.3...@patternfly/react-core@3.67.4) (2019-07-10)


### Bug Fixes

* **ApplicationLauncher:** Allow custom icon for application launcher toggle ([#2492](https://github.com/patternfly/patternfly-react/issues/2492)) ([9cdc85d](https://github.com/patternfly/patternfly-react/commit/9cdc85d))





## [3.67.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.67.2...@patternfly/react-core@3.67.3) (2019-07-09)


### Bug Fixes

* **unit tests:** tests now pass in util.test.js ([#2489](https://github.com/patternfly/patternfly-react/issues/2489)) ([86981f6](https://github.com/patternfly/patternfly-react/commit/86981f6))





## [3.67.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.67.1...@patternfly/react-core@3.67.2) (2019-07-09)

**Note:** Version bump only for package @patternfly/react-core





## [3.67.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.67.0...@patternfly/react-core@3.67.1) (2019-07-08)


### Bug Fixes

* **Dropdown:** Provide option to not autofocus on first item ([#2473](https://github.com/patternfly/patternfly-react/issues/2473)) ([f094b2d](https://github.com/patternfly/patternfly-react/commit/f094b2d))





# [3.67.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.66.1...@patternfly/react-core@3.67.0) (2019-07-08)


### Features

* **Toolbar:** Convert toolbar to typescript ([#2475](https://github.com/patternfly/patternfly-react/issues/2475)) ([b508e5d](https://github.com/patternfly/patternfly-react/commit/b508e5d))





## [3.66.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.66.0...@patternfly/react-core@3.66.1) (2019-07-08)


### Bug Fixes

* **build:** make pf3/pf4 build on windows ([#2471](https://github.com/patternfly/patternfly-react/issues/2471)) ([5bbc4a2](https://github.com/patternfly/patternfly-react/commit/5bbc4a2))





# [3.66.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.65.0...@patternfly/react-core@3.66.0) (2019-07-08)


### Features

* **Split:** Convert split to typescript ([#2466](https://github.com/patternfly/patternfly-react/issues/2466)) ([a544f31](https://github.com/patternfly/patternfly-react/commit/a544f31))





# [3.65.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.64.0...@patternfly/react-core@3.65.0) (2019-07-08)


### Features

* **datalist:** add hidden and visible breakpoints ([#2251](https://github.com/patternfly/patternfly-react/issues/2251)) ([fdbde6d](https://github.com/patternfly/patternfly-react/commit/fdbde6d))





# [3.64.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.63.0...@patternfly/react-core@3.64.0) (2019-07-08)


### Features

* **Level:** Convert level to typescript ([#2450](https://github.com/patternfly/patternfly-react/issues/2450)) ([5c891a0](https://github.com/patternfly/patternfly-react/commit/5c891a0))





# [3.63.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.62.1...@patternfly/react-core@3.63.0) (2019-07-08)


### Features

* **react-core:** add ouia compatibility to Switch ([#2304](https://github.com/patternfly/patternfly-react/issues/2304)) ([2cc4d48](https://github.com/patternfly/patternfly-react/commit/2cc4d48))





## [3.62.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.62.0...@patternfly/react-core@3.62.1) (2019-07-06)

**Note:** Version bump only for package @patternfly/react-core





# [3.62.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.61.1...@patternfly/react-core@3.62.0) (2019-07-05)


### Features

* **Gallery:** Convert gallery to typescript ([#2432](https://github.com/patternfly/patternfly-react/issues/2432)) ([f351fd0](https://github.com/patternfly/patternfly-react/commit/f351fd0))





## [3.61.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.61.0...@patternfly/react-core@3.61.1) (2019-07-05)

**Note:** Version bump only for package @patternfly/react-core





# [3.61.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.60.0...@patternfly/react-core@3.61.0) (2019-07-05)


### Features

* **Bullseye:** Convert bullseye to typescript ([#2427](https://github.com/patternfly/patternfly-react/issues/2427)) ([2515be5](https://github.com/patternfly/patternfly-react/commit/2515be5))





# [3.60.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.59.5...@patternfly/react-core@3.60.0) (2019-07-05)


### Features

* **Stack:** Convert stack to typescript ([#2412](https://github.com/patternfly/patternfly-react/issues/2412)) ([a1c34b6](https://github.com/patternfly/patternfly-react/commit/a1c34b6))





## [3.59.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.59.4...@patternfly/react-core@3.59.5) (2019-07-05)


### Bug Fixes

* **select:** removed ariaLabel from grouped checkbox select ([#2456](https://github.com/patternfly/patternfly-react/issues/2456)) ([415a462](https://github.com/patternfly/patternfly-react/commit/415a462))





## [3.59.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.59.3...@patternfly/react-core@3.59.4) (2019-07-03)

**Note:** Version bump only for package @patternfly/react-core





## [3.59.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.59.2...@patternfly/react-core@3.59.3) (2019-07-03)

**Note:** Version bump only for package @patternfly/react-core





## [3.59.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.59.1...@patternfly/react-core@3.59.2) (2019-07-02)

**Note:** Version bump only for package @patternfly/react-core





## [3.59.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.59.0...@patternfly/react-core@3.59.1) (2019-07-02)


### Bug Fixes

* **Modal:** get modal container from state to set/unset aria-hidden ([#2406](https://github.com/patternfly/patternfly-react/issues/2406)) ([dd49c7e](https://github.com/patternfly/patternfly-react/commit/dd49c7e))





# [3.59.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.58.1...@patternfly/react-core@3.59.0) (2019-07-02)


### Features

* **Pagination:** Pagination Component Typescript Conversion ([#2256](https://github.com/patternfly/patternfly-react/issues/2256)) ([8a29a20](https://github.com/patternfly/patternfly-react/commit/8a29a20))





## [3.58.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.58.0...@patternfly/react-core@3.58.1) (2019-07-01)


### Bug Fixes

* **clipboardcopy:** add read only expanded example  ([#2379](https://github.com/patternfly/patternfly-react/issues/2379)) ([2d3c9c2](https://github.com/patternfly/patternfly-react/commit/2d3c9c2))





# [4.0.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.58.0...@patternfly/react-core@4.0.0) (2019-07-01)


### Bug Fixes

* **tooltip:** revert tippy2 upgrade ([#2326](https://github.com/patternfly/patternfly-react/issues/2326)) ([#2414](https://github.com/patternfly/patternfly-react/issues/2414)) ([3e919e3](https://github.com/patternfly/patternfly-react/commit/3e919e3))


### Features

* **OptionsMenu:** Add disabled modifier to the toggle ([#2401](https://github.com/patternfly/patternfly-react/issues/2401)) ([c6693c1](https://github.com/patternfly/patternfly-react/commit/c6693c1)), closes [#2396](https://github.com/patternfly/patternfly-react/issues/2396)
* **Select:** convert to Typescript ([#2201](https://github.com/patternfly/patternfly-react/issues/2201)) ([fd9fca1](https://github.com/patternfly/patternfly-react/commit/fd9fca1))


* **Select:** Checkbox select variant collapsed into Select. CheckboxSelectGroup now is a generic
Select Group to be used in any variant.

* fix(Select): fix optional flag on optional params

* fix(Select): add tslint ignore to focus trap require (cannot use ES6)

* fix(Select): fix function component declaration

* feat(Select): add pr feedback, fix docs build

* fix(Select): update test snapshots from rebase

* feat(Select): add backwards compatibility with previous select (removing breaking changes)

old method should still work as well as the new method

* feat(Select): add pr feedback

update tests, minor fixes

* feat(Select): add props extensions

* feat(Select): update props of group





# (2019-07-01)


### Bug Fixes

* **tooltip:** revert tippy2 upgrade ([#2326](https://github.com/patternfly/patternfly-react/issues/2326)) ([#2414](https://github.com/patternfly/patternfly-react/issues/2414)) ([3e919e3](https://github.com/patternfly/patternfly-react/commit/3e919e3))





# (2019-07-01)

**Note:** Version bump only for package @patternfly/react-core





# (2019-07-01)


### Features

* **OptionsMenu:** Add disabled modifier to the toggle ([#2401](https://github.com/patternfly/patternfly-react/issues/2401)) ([c6693c1](https://github.com/patternfly/patternfly-react/commit/c6693c1)), closes [#2396](https://github.com/patternfly/patternfly-react/issues/2396)





# (2019-07-01)


### Features

* **Select:** convert to Typescript ([#2201](https://github.com/patternfly/patternfly-react/issues/2201)) ([fd9fca1](https://github.com/patternfly/patternfly-react/commit/fd9fca1))


### BREAKING CHANGES

* **Select:** Checkbox select variant collapsed into Select. CheckboxSelectGroup now is a generic
Select Group to be used in any variant.

* fix(Select): fix optional flag on optional params

* fix(Select): add tslint ignore to focus trap require (cannot use ES6)

* fix(Select): fix function component declaration

* feat(Select): add pr feedback, fix docs build

* fix(Select): update test snapshots from rebase

* feat(Select): add backwards compatibility with previous select (removing breaking changes)

old method should still work as well as the new method

* feat(Select): add pr feedback

update tests, minor fixes

* feat(Select): add props extensions

* feat(Select): update props of group





# [3.58.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.57.2...@patternfly/react-core@3.58.0) (2019-07-01)


### Bug Fixes

* **tabs:** tab container refs ([#2402](https://github.com/patternfly/patternfly-react/issues/2402)) ([3c0a8a1](https://github.com/patternfly/patternfly-react/commit/3c0a8a1))


### Features

* **card:** Add compact card variation ([#2399](https://github.com/patternfly/patternfly-react/issues/2399)) ([e27ad9e](https://github.com/patternfly/patternfly-react/commit/e27ad9e))





## [3.57.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.57.1...@patternfly/react-core@3.57.2) (2019-07-01)


### Bug Fixes

* **grid:** always remove props from {...props} ([#2404](https://github.com/patternfly/patternfly-react/issues/2404)) ([f549b95](https://github.com/patternfly/patternfly-react/commit/f549b95))





## [3.57.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.57.0...@patternfly/react-core@3.57.1) (2019-06-28)

**Note:** Version bump only for package @patternfly/react-core





# [3.57.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.56.1...@patternfly/react-core@3.57.0) (2019-06-27)


### Bug Fixes

* **aboutmodal:** change strapline element to paragraph ([#2376](https://github.com/patternfly/patternfly-react/issues/2376)) ([8a06aa2](https://github.com/patternfly/patternfly-react/commit/8a06aa2))


### Features

* **Notification Badge:** Adds the notification badge component ([#2342](https://github.com/patternfly/patternfly-react/issues/2342)) ([a0e7965](https://github.com/patternfly/patternfly-react/commit/a0e7965)), closes [#2021](https://github.com/patternfly/patternfly-react/issues/2021)





## [3.56.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.56.0...@patternfly/react-core@3.56.1) (2019-06-27)


### Bug Fixes

* **Radio:** fix warning from undefined starting params ([#2292](https://github.com/patternfly/patternfly-react/issues/2292)) ([fe708e1](https://github.com/patternfly/patternfly-react/commit/fe708e1))





# [3.56.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.55.0...@patternfly/react-core@3.56.0) (2019-06-27)


### Features

* **Page:** add page section main nav type variant ([#2268](https://github.com/patternfly/patternfly-react/issues/2268)) ([0c0d4a0](https://github.com/patternfly/patternfly-react/commit/0c0d4a0))





# [3.55.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.54.1...@patternfly/react-core@3.55.0) (2019-06-27)


### Features

* **chipGroup:** add heading level prop to toolbar chip group label ([#2278](https://github.com/patternfly/patternfly-react/issues/2278)) ([d87ce91](https://github.com/patternfly/patternfly-react/commit/d87ce91))
* **InputGroup:** Convert input group to typescript ([#2220](https://github.com/patternfly/patternfly-react/issues/2220)) ([0313519](https://github.com/patternfly/patternfly-react/commit/0313519))





## [3.54.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.54.0...@patternfly/react-core@3.54.1) (2019-06-27)


### Bug Fixes

* **dropdown:** Automatically focus first dropdown item when DropdownMenu mounts ([#2355](https://github.com/patternfly/patternfly-react/issues/2355)) ([276f5fb](https://github.com/patternfly/patternfly-react/commit/276f5fb)), closes [#2083](https://github.com/patternfly/patternfly-react/issues/2083)
* **Grid:** Update grid layout to support new 2xl breakpoint ([#2305](https://github.com/patternfly/patternfly-react/issues/2305)) ([2025c1c](https://github.com/patternfly/patternfly-react/commit/2025c1c))





# [3.54.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.53.4...@patternfly/react-core@3.54.0) (2019-06-27)


### Bug Fixes

* **Data list:** Add DataListRow to imports ([#2353](https://github.com/patternfly/patternfly-react/issues/2353)) ([d20d481](https://github.com/patternfly/patternfly-react/commit/d20d481)), closes [#2338](https://github.com/patternfly/patternfly-react/issues/2338)


### Features

* **ClipboardCopy:** Convert clipboard copy to typescript ([#2131](https://github.com/patternfly/patternfly-react/issues/2131)) ([44168dd](https://github.com/patternfly/patternfly-react/commit/44168dd))
* **PF Checkbox:** Add 3rd state to checkbox controlled by consumer ([#2252](https://github.com/patternfly/patternfly-react/issues/2252)) ([cf06254](https://github.com/patternfly/patternfly-react/commit/cf06254))





## [3.53.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.53.3...@patternfly/react-core@3.53.4) (2019-06-27)

**Note:** Version bump only for package @patternfly/react-core





## [3.53.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.53.2...@patternfly/react-core@3.53.3) (2019-06-25)


### Bug Fixes

* **form:** update text in form component ([#2352](https://github.com/patternfly/patternfly-react/issues/2352)) ([929ed2d](https://github.com/patternfly/patternfly-react/commit/929ed2d))





## [3.53.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.53.1...@patternfly/react-core@3.53.2) (2019-06-25)


### Bug Fixes

* **expandable:** Add button type to the Expandable Component ([#2340](https://github.com/patternfly/patternfly-react/issues/2340)) ([670b8a1](https://github.com/patternfly/patternfly-react/commit/670b8a1))
* **Tabs:** Make variant prop optional ([#2348](https://github.com/patternfly/patternfly-react/issues/2348)) ([b17fa06](https://github.com/patternfly/patternfly-react/commit/b17fa06)), closes [#2345](https://github.com/patternfly/patternfly-react/issues/2345)





## [3.53.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.53.0...@patternfly/react-core@3.53.1) (2019-06-25)

**Note:** Version bump only for package @patternfly/react-core





# [3.53.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.52.1...@patternfly/react-core@3.53.0) (2019-06-24)


### Features

* **form:** wrap form label text in new element ([#2332](https://github.com/patternfly/patternfly-react/issues/2332)) ([b1301a3](https://github.com/patternfly/patternfly-react/commit/b1301a3))





## [3.52.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.52.0...@patternfly/react-core@3.52.1) (2019-06-24)

**Note:** Version bump only for package @patternfly/react-core





# [3.52.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.51.2...@patternfly/react-core@3.52.0) (2019-06-24)


### Features

* **tippy:** upgrade tippy deps and apply api changes ([#2326](https://github.com/patternfly/patternfly-react/issues/2326)) ([b2dc2e2](https://github.com/patternfly/patternfly-react/commit/b2dc2e2))





## [3.51.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.51.1...@patternfly/react-core@3.51.2) (2019-06-24)

**Note:** Version bump only for package @patternfly/react-core





## [3.51.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.51.0...@patternfly/react-core@3.51.1) (2019-06-24)

**Note:** Version bump only for package @patternfly/react-core





# [3.51.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.50.5...@patternfly/react-core@3.51.0) (2019-06-24)


### Features

* **Tabs:** Convert tabs to typescript ([#2253](https://github.com/patternfly/patternfly-react/issues/2253)) ([e4e5b16](https://github.com/patternfly/patternfly-react/commit/e4e5b16))





## [3.50.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.50.4...@patternfly/react-core@3.50.5) (2019-06-21)

**Note:** Version bump only for package @patternfly/react-core





## [3.50.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.50.3...@patternfly/react-core@3.50.4) (2019-06-20)

**Note:** Version bump only for package @patternfly/react-core





## [3.50.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.50.2...@patternfly/react-core@3.50.3) (2019-06-20)


### Bug Fixes

* **Alert:** fix close button action ([#2308](https://github.com/patternfly/patternfly-react/issues/2308)) ([175352c](https://github.com/patternfly/patternfly-react/commit/175352c)), closes [patternfly/patternfly-org#1213](https://github.com/patternfly/patternfly-org/issues/1213)





## [3.50.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.50.1...@patternfly/react-core@3.50.2) (2019-06-20)

**Note:** Version bump only for package @patternfly/react-core





## [3.50.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.50.0...@patternfly/react-core@3.50.1) (2019-06-19)

**Note:** Version bump only for package @patternfly/react-core





# [3.50.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.49.1...@patternfly/react-core@3.50.0) (2019-06-19)


### Features

* **FormSelect:** Convert form select to typescript ([#2204](https://github.com/patternfly/patternfly-react/issues/2204)) ([373e012](https://github.com/patternfly/patternfly-react/commit/373e012))





## [3.49.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.49.0...@patternfly/react-core@3.49.1) (2019-06-19)


### Bug Fixes

* **Alert:** remove the <p> from the Alert description ([#2293](https://github.com/patternfly/patternfly-react/issues/2293)) ([ccaf11e](https://github.com/patternfly/patternfly-react/commit/ccaf11e)), closes [#2283](https://github.com/patternfly/patternfly-react/issues/2283)





# [3.49.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.48.5...@patternfly/react-core@3.49.0) (2019-06-19)


### Features

* **Button:** add icon property and wrapper css ([#2205](https://github.com/patternfly/patternfly-react/issues/2205)) ([14d1d70](https://github.com/patternfly/patternfly-react/commit/14d1d70))





## [3.48.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.48.4...@patternfly/react-core@3.48.5) (2019-06-18)

**Note:** Version bump only for package @patternfly/react-core





## [3.48.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.48.3...@patternfly/react-core@3.48.4) (2019-06-18)

**Note:** Version bump only for package @patternfly/react-core





## [3.48.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.48.2...@patternfly/react-core@3.48.3) (2019-06-18)


### Bug Fixes

* **popover:** reset pointer-events to capture default target bounds ([#2284](https://github.com/patternfly/patternfly-react/issues/2284)) ([910c667](https://github.com/patternfly/patternfly-react/commit/910c667))





## [3.48.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.48.1...@patternfly/react-core@3.48.2) (2019-06-18)

**Note:** Version bump only for package @patternfly/react-core





## [3.48.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.48.0...@patternfly/react-core@3.48.1) (2019-06-18)


### Bug Fixes

* **Accordion:** final changes ([#2290](https://github.com/patternfly/patternfly-react/issues/2290)) ([6fce654](https://github.com/patternfly/patternfly-react/commit/6fce654))





# [3.48.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.46.1...@patternfly/react-core@3.48.0) (2019-06-18)


### Features

* **ContextSelector:** Convert context selector to typescript ([#2147](https://github.com/patternfly/patternfly-react/issues/2147)) ([9a4f484](https://github.com/patternfly/patternfly-react/commit/9a4f484))





# [3.47.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.46.1...@patternfly/react-core@3.47.0) (2019-06-18)


### Features

* **ContextSelector:** Convert context selector to typescript ([#2147](https://github.com/patternfly/patternfly-react/issues/2147)) ([9a4f484](https://github.com/patternfly/patternfly-react/commit/9a4f484))





## [3.46.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.46.0...@patternfly/react-core@3.46.1) (2019-06-14)

**Note:** Version bump only for package @patternfly/react-core





# [3.46.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.45.0...@patternfly/react-core@3.46.0) (2019-06-14)


### Bug Fixes

* **Alert:** set the variant prop to info by default ([#2218](https://github.com/patternfly/patternfly-react/issues/2218)) ([bd8afad](https://github.com/patternfly/patternfly-react/commit/bd8afad))
* **react-icons:** add noVerticalAlign prop to d.ts file ([#2238](https://github.com/patternfly/patternfly-react/issues/2238)) ([c50143c](https://github.com/patternfly/patternfly-react/commit/c50143c)), closes [#2237](https://github.com/patternfly/patternfly-react/issues/2237)


### Features

* **Accordion:** Accordion Component TypeScript Conversion ([#2121](https://github.com/patternfly/patternfly-react/issues/2121)) ([e2e981d](https://github.com/patternfly/patternfly-react/commit/e2e981d))





# [3.45.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.44.0...@patternfly/react-core@3.45.0) (2019-06-14)


### Features

* **PF4: Application launcher:** Use dropdown components in App launcher ([#2101](https://github.com/patternfly/patternfly-react/issues/2101)) ([44a2ea1](https://github.com/patternfly/patternfly-react/commit/44a2ea1))





# [3.44.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.43.0...@patternfly/react-core@3.44.0) (2019-06-14)


### Features

* **PF4 Dropdown:** Wrap dropdown with context ([#2227](https://github.com/patternfly/patternfly-react/issues/2227)) ([5bb8051](https://github.com/patternfly/patternfly-react/commit/5bb8051))





# [3.43.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.42.1...@patternfly/react-core@3.43.0) (2019-06-13)


### Features

* **build:** add source maps ([#2142](https://github.com/patternfly/patternfly-react/issues/2142)) ([5076c48](https://github.com/patternfly/patternfly-react/commit/5076c48))





## [3.42.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.42.0...@patternfly/react-core@3.42.1) (2019-06-13)


### Bug Fixes

* **pagination:** dropdown closes on click outside of menu area ([#2235](https://github.com/patternfly/patternfly-react/issues/2235)) ([a2942c2](https://github.com/patternfly/patternfly-react/commit/a2942c2))





# [3.42.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.41.0...@patternfly/react-core@3.42.0) (2019-06-12)


### Features

* **Alert:** Add the inline alert modifier ([#2126](https://github.com/patternfly/patternfly-react/issues/2126)) ([230e83a](https://github.com/patternfly/patternfly-react/commit/230e83a)), closes [#1934](https://github.com/patternfly/patternfly-react/issues/1934)





# [3.41.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.40.0...@patternfly/react-core@3.41.0) (2019-06-12)


### Features

* **react-core:** allow dynamic rendering of anchor components ([#2117](https://github.com/patternfly/patternfly-react/issues/2117)) ([c1c3be9](https://github.com/patternfly/patternfly-react/commit/c1c3be9))





# [3.40.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.39.0...@patternfly/react-core@3.40.0) (2019-06-11)


### Features

* **ApplicationLauncher:** Convert application launcher to typescript ([#2166](https://github.com/patternfly/patternfly-react/issues/2166)) ([9b90f94](https://github.com/patternfly/patternfly-react/commit/9b90f94))
* **Card:** Add support for images and actions ([#2122](https://github.com/patternfly/patternfly-react/issues/2122)) ([7832518](https://github.com/patternfly/patternfly-react/commit/7832518))





# [3.39.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.38.1...@patternfly/react-core@3.39.0) (2019-06-11)


### Features

* **Topology:** Add @patternfly/react-topology package ([#2170](https://github.com/patternfly/patternfly-react/issues/2170)) ([58eb9cc](https://github.com/patternfly/patternfly-react/commit/58eb9cc))





## [3.38.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.38.0...@patternfly/react-core@3.38.1) (2019-06-11)

**Note:** Version bump only for package @patternfly/react-core





# [3.38.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.37.1...@patternfly/react-core@3.38.0) (2019-06-10)


### Features

* **backdrop:** Convert backdrop to typescript ([#2105](https://github.com/patternfly/patternfly-react/issues/2105)) ([fd3d771](https://github.com/patternfly/patternfly-react/commit/fd3d771))





## [3.37.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.37.0...@patternfly/react-core@3.37.1) (2019-06-10)

**Note:** Version bump only for package @patternfly/react-core





# [3.37.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.36.1...@patternfly/react-core@3.37.0) (2019-06-07)


### Features

* **PF4: Pagination:** When empty array sent to pagination no per page should be visible ([#2175](https://github.com/patternfly/patternfly-react/issues/2175)) ([cb97dfd](https://github.com/patternfly/patternfly-react/commit/cb97dfd))





## [3.36.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.36.0...@patternfly/react-core@3.36.1) (2019-06-06)

**Note:** Version bump only for package @patternfly/react-core





# [3.36.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.35.0...@patternfly/react-core@3.36.0) (2019-06-05)


### Bug Fixes

* **NavItem:** Maintain className passed to custom NavItems ([#2134](https://github.com/patternfly/patternfly-react/issues/2134)) ([8f38b97](https://github.com/patternfly/patternfly-react/commit/8f38b97))


### Features

* **react-styles:** move react styles ([#2085](https://github.com/patternfly/patternfly-react/issues/2085)) ([81d1ed2](https://github.com/patternfly/patternfly-react/commit/81d1ed2))





# [3.35.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.34.2...@patternfly/react-core@3.35.0) (2019-06-05)


### Features

* **background image:** Convert background image to typescript ([#2070](https://github.com/patternfly/patternfly-react/issues/2070)) ([d4ae6db](https://github.com/patternfly/patternfly-react/commit/d4ae6db))
* **Select:** add typeahead keyboard navigation ([#2013](https://github.com/patternfly/patternfly-react/issues/2013)) ([60b4d91](https://github.com/patternfly/patternfly-react/commit/60b4d91))
* **TextInput:** Convert text input to TypeScript ([#1914](https://github.com/patternfly/patternfly-react/issues/1914)) ([1707236](https://github.com/patternfly/patternfly-react/commit/1707236)), closes [#1908](https://github.com/patternfly/patternfly-react/issues/1908)





## [3.34.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.34.1...@patternfly/react-core@3.34.2) (2019-06-05)


### Bug Fixes

* **aboutmodal:** support isOpen initially set true in about modal ([#2153](https://github.com/patternfly/patternfly-react/issues/2153)) ([d8209ad](https://github.com/patternfly/patternfly-react/commit/d8209ad))





## [3.34.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.34.0...@patternfly/react-core@3.34.1) (2019-06-05)

**Note:** Version bump only for package @patternfly/react-core





# 3.34.0 (2019-06-03)


### Features

* **component:** Add Time Picker component ([#1875](https://github.com/patternfly/patternfly-react/issues/1875)) ([00996e9](https://github.com/patternfly/patternfly-react/commit/00996e9))





## [3.33.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.33.0...@patternfly/react-core@3.33.1) (2019-05-30)


### Bug Fixes

* **checkbox:** set checked if onChanged is not the default ([#2037](https://github.com/patternfly/patternfly-react/issues/2037)) ([2237fa5](https://github.com/patternfly/patternfly-react/commit/2237fa5))





# [3.33.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.10...@patternfly/react-core@3.33.0) (2019-05-30)


### Features

* **OptionsMenu:** Options Menu Component Typescript Conversion ([#2002](https://github.com/patternfly/patternfly-react/issues/2002)) ([402718b](https://github.com/patternfly/patternfly-react/commit/402718b))





## [3.32.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.9...@patternfly/react-core@3.32.10) (2019-05-30)


### Bug Fixes

* **popover:** make PopoverPosition an enum ([#2113](https://github.com/patternfly/patternfly-react/issues/2113)) ([4afe336](https://github.com/patternfly/patternfly-react/commit/4afe336))





## [3.32.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.8...@patternfly/react-core@3.32.9) (2019-05-29)

**Note:** Version bump only for package @patternfly/react-core





## [3.32.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.7...@patternfly/react-core@3.32.8) (2019-05-29)


### Bug Fixes

* **Select:** update SelectProps interface, clean up demos ([#2107](https://github.com/patternfly/patternfly-react/issues/2107)) ([b56ea35](https://github.com/patternfly/patternfly-react/commit/b56ea35))





## [3.32.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.6...@patternfly/react-core@3.32.7) (2019-05-29)


### Bug Fixes

* **popover:** maxWidth typescript error with maxWidth ([#2110](https://github.com/patternfly/patternfly-react/issues/2110)) ([e41ae79](https://github.com/patternfly/patternfly-react/commit/e41ae79))





## [3.32.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.5...@patternfly/react-core@3.32.6) (2019-05-29)


### Bug Fixes

* **docs:** use frontmatter for what props to show in docs ([#2072](https://github.com/patternfly/patternfly-react/issues/2072)) ([20e6b12](https://github.com/patternfly/patternfly-react/commit/20e6b12))





## [3.32.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.4...@patternfly/react-core@3.32.5) (2019-05-28)

**Note:** Version bump only for package @patternfly/react-core





## [3.32.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.3...@patternfly/react-core@3.32.4) (2019-05-28)


### Bug Fixes

* **Pagination PF4:** set default items start and end to null ([#2089](https://github.com/patternfly/patternfly-react/issues/2089)) ([44c489c](https://github.com/patternfly/patternfly-react/commit/44c489c))





## [3.32.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.2...@patternfly/react-core@3.32.3) (2019-05-24)

**Note:** Version bump only for package @patternfly/react-core





## [3.32.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.1...@patternfly/react-core@3.32.2) (2019-05-24)

**Note:** Version bump only for package @patternfly/react-core





## [3.32.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.32.0...@patternfly/react-core@3.32.1) (2019-05-24)

**Note:** Version bump only for package @patternfly/react-core





# [3.32.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.31.0...@patternfly/react-core@3.32.0) (2019-05-24)


### Features

* **page:** add fill and no-fill modifiers to page sections ([#1973](https://github.com/patternfly/patternfly-react/issues/1973)) ([eef6513](https://github.com/patternfly/patternfly-react/commit/eef6513))





# [3.31.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.30.1...@patternfly/react-core@3.31.0) (2019-05-23)


### Features

* **Nav:** Convert Nav component to typescript, add Demos ([#2005](https://github.com/patternfly/patternfly-react/issues/2005)) ([f8961fa](https://github.com/patternfly/patternfly-react/commit/f8961fa))





## [3.30.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.30.0...@patternfly/react-core@3.30.1) (2019-05-22)


### Bug Fixes

* **modal:** do not render title when hideTitle is true ([#2057](https://github.com/patternfly/patternfly-react/issues/2057)) ([e152246](https://github.com/patternfly/patternfly-react/commit/e152246))





# [3.30.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.29.1...@patternfly/react-core@3.30.0) (2019-05-21)


### Features

* **Badge:** Convert badge to typescript ([#2048](https://github.com/patternfly/patternfly-react/issues/2048)) ([836f484](https://github.com/patternfly/patternfly-react/commit/836f484))
* **ChipGroup:** Converted ChipGroup component to typescript ([#1951](https://github.com/patternfly/patternfly-react/issues/1951)) ([f13ce5b](https://github.com/patternfly/patternfly-react/commit/f13ce5b))





## [3.29.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.29.0...@patternfly/react-core@3.29.1) (2019-05-21)


### Bug Fixes

* **Select:** changed prop TypeScript definitions ([#2047](https://github.com/patternfly/patternfly-react/issues/2047)) ([c9eb042](https://github.com/patternfly/patternfly-react/commit/c9eb042))





# [3.29.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.28.1...@patternfly/react-core@3.29.0) (2019-05-21)


### Features

* **ts:** convert aboutmodal to TS ([#1968](https://github.com/patternfly/patternfly-react/issues/1968)) ([7dd9526](https://github.com/patternfly/patternfly-react/commit/7dd9526))





## [3.28.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.28.0...@patternfly/react-core@3.28.1) (2019-05-21)


### Bug Fixes

* **Select:** account for direct JSX children ([#2042](https://github.com/patternfly/patternfly-react/issues/2042)) ([67dd3b5](https://github.com/patternfly/patternfly-react/commit/67dd3b5))





# [3.28.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.27.0...@patternfly/react-core@3.28.0) (2019-05-20)


### Features

* **form:** Converted form component to typescript ([#1933](https://github.com/patternfly/patternfly-react/issues/1933)) ([110684d](https://github.com/patternfly/patternfly-react/commit/110684d))





# [3.27.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.26.0...@patternfly/react-core@3.27.0) (2019-05-20)


### Bug Fixes

* **wizard:** wizards props extends div element props ([#1993](https://github.com/patternfly/patternfly-react/issues/1993)) ([1e9698e](https://github.com/patternfly/patternfly-react/commit/1e9698e))


### Features

* **Breadcrumb:** Convert Breadcrumb jsx file to tsx ([#1723](https://github.com/patternfly/patternfly-react/issues/1723)) ([9151262](https://github.com/patternfly/patternfly-react/commit/9151262))





# [3.26.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.25.0...@patternfly/react-core@3.26.0) (2019-05-20)


### Features

* **button:** Converted button component to typescript ([#1903](https://github.com/patternfly/patternfly-react/issues/1903)) ([2b9d252](https://github.com/patternfly/patternfly-react/commit/2b9d252))





# [3.25.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.24.0...@patternfly/react-core@3.25.0) (2019-05-20)


### Features

* **card:** Converted card component to typescript ([#1885](https://github.com/patternfly/patternfly-react/issues/1885)) ([e3e4170](https://github.com/patternfly/patternfly-react/commit/e3e4170))
* **List:** Convert list to TypeScript ([#1946](https://github.com/patternfly/patternfly-react/issues/1946)) ([ecb2702](https://github.com/patternfly/patternfly-react/commit/ecb2702))





# [3.24.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.23.1...@patternfly/react-core@3.24.0) (2019-05-17)


### Features

* **EmptyState:** Convert empty state to TypeScript ([#1917](https://github.com/patternfly/patternfly-react/issues/1917)) ([1fb9934](https://github.com/patternfly/patternfly-react/commit/1fb9934))





## [3.23.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.23.0...@patternfly/react-core@3.23.1) (2019-05-17)


### Bug Fixes

* **Dropdown:** handle on enter focusing when options are disabled ([#2025](https://github.com/patternfly/patternfly-react/issues/2025)) ([8903702](https://github.com/patternfly/patternfly-react/commit/8903702))





# [3.23.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.22.1...@patternfly/react-core@3.23.0) (2019-05-17)


### Features

* **Radio:** Convert radio to TypeScript ([#1945](https://github.com/patternfly/patternfly-react/issues/1945)) ([11a77d4](https://github.com/patternfly/patternfly-react/commit/11a77d4))





## [3.22.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.22.0...@patternfly/react-core@3.22.1) (2019-05-17)

**Note:** Version bump only for package @patternfly/react-core





# [3.22.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.21.0...@patternfly/react-core@3.22.0) (2019-05-17)


### Features

* **LoginPage:** Convert LoginPage to typescript, add integration tests, and demo ([#1967](https://github.com/patternfly/patternfly-react/issues/1967)) ([4657da1](https://github.com/patternfly/patternfly-react/commit/4657da1))





# [3.21.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.20.0...@patternfly/react-core@3.21.0) (2019-05-17)


### Bug Fixes

* **build:** update snapshots and fix linter errors ([#2031](https://github.com/patternfly/patternfly-react/issues/2031)) ([236d1d5](https://github.com/patternfly/patternfly-react/commit/236d1d5))
* **Checkbox:** Set checked value correctly ([#1929](https://github.com/patternfly/patternfly-react/issues/1929)) ([43d5283](https://github.com/patternfly/patternfly-react/commit/43d5283))


### Features

* **alert:** convert alert to TS ([#1978](https://github.com/patternfly/patternfly-react/issues/1978)) ([72a86f3](https://github.com/patternfly/patternfly-react/commit/72a86f3)), closes [#2023](https://github.com/patternfly/patternfly-react/issues/2023)
* **brand:** Converted brand component to typescript ([#1918](https://github.com/patternfly/patternfly-react/issues/1918)) ([2c52451](https://github.com/patternfly/patternfly-react/commit/2c52451))





# [3.20.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.19.0...@patternfly/react-core@3.20.0) (2019-05-16)


### Features

* **Text:** Convert Text to TypeScript ([#1907](https://github.com/patternfly/patternfly-react/issues/1907)) ([ad8e1f5](https://github.com/patternfly/patternfly-react/commit/ad8e1f5)), closes [#1897](https://github.com/patternfly/patternfly-react/issues/1897)





# [3.19.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.18.2...@patternfly/react-core@3.19.0) (2019-05-13)


### Bug Fixes

* **build:** use native fs-extra commands instead of folderHash ([#1957](https://github.com/patternfly/patternfly-react/issues/1957)) ([b074b8e](https://github.com/patternfly/patternfly-react/commit/b074b8e))


### Features

* **table:** add umd to react-table ([#1966](https://github.com/patternfly/patternfly-react/issues/1966)) ([a48836b](https://github.com/patternfly/patternfly-react/commit/a48836b))





## [3.18.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.18.1...@patternfly/react-core@3.18.2) (2019-05-13)

**Note:** Version bump only for package @patternfly/react-core





## [3.18.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.18.0...@patternfly/react-core@3.18.1) (2019-05-09)


### Bug Fixes

* **ts-doc:** fix regressions ([#1960](https://github.com/patternfly/patternfly-react/issues/1960)) ([227091b](https://github.com/patternfly/patternfly-react/commit/227091b))





# [3.18.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.17.0...@patternfly/react-core@3.18.0) (2019-05-09)


### Features

* **Dropdown:** add dropdown groups option ([#1725](https://github.com/patternfly/patternfly-react/issues/1725)) ([488f198](https://github.com/patternfly/patternfly-react/commit/488f198))





# [3.17.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.19...@patternfly/react-core@3.17.0) (2019-05-09)


### Features

* **Label:** Convert Label to TypeScript ([#1896](https://github.com/patternfly/patternfly-react/issues/1896)) ([a950fd5](https://github.com/patternfly/patternfly-react/commit/a950fd5)), closes [#1893](https://github.com/patternfly/patternfly-react/issues/1893)





## [3.16.19](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.18...@patternfly/react-core@3.16.19) (2019-05-09)


### Bug Fixes

* **docs:** fix ts docgen ([#1944](https://github.com/patternfly/patternfly-react/issues/1944)) ([f68bbc5](https://github.com/patternfly/patternfly-react/commit/f68bbc5))





## [3.16.18](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.17...@patternfly/react-core@3.16.18) (2019-05-08)


### Bug Fixes

* **AboutModal:** provide a way to set the background using props ([#1940](https://github.com/patternfly/patternfly-react/issues/1940)) ([4ad711d](https://github.com/patternfly/patternfly-react/commit/4ad711d))





## [3.16.17](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.16...@patternfly/react-core@3.16.17) (2019-05-08)

**Note:** Version bump only for package @patternfly/react-core





## [3.16.16](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.15...@patternfly/react-core@3.16.16) (2019-05-07)

**Note:** Version bump only for package @patternfly/react-core





## [3.16.15](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.14...@patternfly/react-core@3.16.15) (2019-05-07)


### Bug Fixes

* **Dropdown:** Send event when clicking on dropdown toggle ([#1667](https://github.com/patternfly/patternfly-react/issues/1667)) ([fec1d41](https://github.com/patternfly/patternfly-react/commit/fec1d41))





## [3.16.14](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.13...@patternfly/react-core@3.16.14) (2019-05-06)


### Bug Fixes

* **BackgroundImage:** fixed background image spacing issue  ([#1923](https://github.com/patternfly/patternfly-react/issues/1923)) ([ce38bae](https://github.com/patternfly/patternfly-react/commit/ce38bae))





## [3.16.13](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.12...@patternfly/react-core@3.16.13) (2019-05-06)


### Bug Fixes

* **popover:** Enable highlighting and selecting text in popover. ([#1757](https://github.com/patternfly/patternfly-react/issues/1757)) ([70be06f](https://github.com/patternfly/patternfly-react/commit/70be06f))





## [3.16.12](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.11...@patternfly/react-core@3.16.12) (2019-05-06)

**Note:** Version bump only for package @patternfly/react-core





## [3.16.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.10...@patternfly/react-core@3.16.11) (2019-05-03)


### Bug Fixes

* **dropitems:** updates to drop down item and skip to content api ([#1924](https://github.com/patternfly/patternfly-react/issues/1924)) ([a21f5fb](https://github.com/patternfly/patternfly-react/commit/a21f5fb))





## [3.16.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.9...@patternfly/react-core@3.16.10) (2019-05-01)


### Bug Fixes

* **styles:** update layout styles for layouts ([#1906](https://github.com/patternfly/patternfly-react/issues/1906)) ([22e74ac](https://github.com/patternfly/patternfly-react/commit/22e74ac))





## [3.16.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.8...@patternfly/react-core@3.16.9) (2019-05-01)

**Note:** Version bump only for package @patternfly/react-core





## [3.16.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.7...@patternfly/react-core@3.16.8) (2019-05-01)

**Note:** Version bump only for package @patternfly/react-core





## [3.16.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.6...@patternfly/react-core@3.16.7) (2019-05-01)


### Bug Fixes

* **ClickboardCopy:** update imports and clean up ([#1876](https://github.com/patternfly/patternfly-react/issues/1876)) ([7a85bfb](https://github.com/patternfly/patternfly-react/commit/7a85bfb))





## [3.16.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.5...@patternfly/react-core@3.16.6) (2019-04-30)


### Bug Fixes

* **ApplicationLauncher:** fix rename ariaHasPopup attribute to aria-haspopup ([#1880](https://github.com/patternfly/patternfly-react/issues/1880)) ([444b024](https://github.com/patternfly/patternfly-react/commit/444b024)), closes [#1846](https://github.com/patternfly/patternfly-react/issues/1846)





## [3.16.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.4...@patternfly/react-core@3.16.5) (2019-04-30)

**Note:** Version bump only for package @patternfly/react-core





## [3.16.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.3...@patternfly/react-core@3.16.4) (2019-04-30)

**Note:** Version bump only for package @patternfly/react-core





## [3.16.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.2...@patternfly/react-core@3.16.3) (2019-04-29)


### Bug Fixes

* **Accordion:** Wrong import in definition file ([#1870](https://github.com/patternfly/patternfly-react/issues/1870)) ([780d7c7](https://github.com/patternfly/patternfly-react/commit/780d7c7)), closes [#1869](https://github.com/patternfly/patternfly-react/issues/1869)





## [3.16.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.1...@patternfly/react-core@3.16.2) (2019-04-29)


### Bug Fixes

* **build:** make downstream patternfly-org work upstream ([#1835](https://github.com/patternfly/patternfly-react/issues/1835)) ([bccbebd](https://github.com/patternfly/patternfly-react/commit/bccbebd))
* **version:** bump patternfly version to 2.6.5 ([#1874](https://github.com/patternfly/patternfly-react/issues/1874)) ([e3c8d7c](https://github.com/patternfly/patternfly-react/commit/e3c8d7c))





## [3.16.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.16.0...@patternfly/react-core@3.16.1) (2019-04-29)

**Note:** Version bump only for package @patternfly/react-core





# [3.16.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.15.2...@patternfly/react-core@3.16.0) (2019-04-26)


### Features

* **About modal:** Added support for more user control over content ([#1859](https://github.com/patternfly/patternfly-react/issues/1859)) ([fb2adcd](https://github.com/patternfly/patternfly-react/commit/fb2adcd)), closes [#1853](https://github.com/patternfly/patternfly-react/issues/1853)





## [3.15.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.15.1...@patternfly/react-core@3.15.2) (2019-04-26)

**Note:** Version bump only for package @patternfly/react-core





## [3.15.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.15.0...@patternfly/react-core@3.15.1) (2019-04-26)


### Bug Fixes

* **dropdown:** rename toggle export ([#1861](https://github.com/patternfly/patternfly-react/issues/1861)) ([e7088ce](https://github.com/patternfly/patternfly-react/commit/e7088ce))





# [3.15.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.14.0...@patternfly/react-core@3.15.0) (2019-04-26)


### Features

* **accordion:** Introduce accordion ([#1852](https://github.com/patternfly/patternfly-react/issues/1852)) ([4ae95e9](https://github.com/patternfly/patternfly-react/commit/4ae95e9))





# [3.14.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.13.5...@patternfly/react-core@3.14.0) (2019-04-26)


### Features

* **Select:** add typeahead variants (single and multi) ([#1839](https://github.com/patternfly/patternfly-react/issues/1839)) ([8da35a9](https://github.com/patternfly/patternfly-react/commit/8da35a9))





## [3.13.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.13.4...@patternfly/react-core@3.13.5) (2019-04-26)

**Note:** Version bump only for package @patternfly/react-core





## [3.13.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.13.3...@patternfly/react-core@3.13.4) (2019-04-25)


### Bug Fixes

* **Alert:** Change title type from string to node ([#1856](https://github.com/patternfly/patternfly-react/issues/1856)) ([12c7a55](https://github.com/patternfly/patternfly-react/commit/12c7a55)), closes [#1854](https://github.com/patternfly/patternfly-react/issues/1854)





## [3.13.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.13.2...@patternfly/react-core@3.13.3) (2019-04-25)

**Note:** Version bump only for package @patternfly/react-core





## [3.13.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.13.1...@patternfly/react-core@3.13.2) (2019-04-25)

**Note:** Version bump only for package @patternfly/react-core





## [3.13.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.13.0...@patternfly/react-core@3.13.1) (2019-04-25)


### Bug Fixes

* **clipboard:** change expanded content in clipboard copy to ref ([#1848](https://github.com/patternfly/patternfly-react/issues/1848)) ([a613bf4](https://github.com/patternfly/patternfly-react/commit/a613bf4))





# [3.13.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.12.1...@patternfly/react-core@3.13.0) (2019-04-25)


### Features

* **DropdownToggle:** Add splitButtonItems prop, DropdownToggleCheckbox and split-button dropdown examples ([#1843](https://github.com/patternfly/patternfly-react/issues/1843)) ([86b3087](https://github.com/patternfly/patternfly-react/commit/86b3087)), closes [#1287](https://github.com/patternfly/patternfly-react/issues/1287)





## [3.12.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.12.0...@patternfly/react-core@3.12.1) (2019-04-25)

**Note:** Version bump only for package @patternfly/react-core





# [3.12.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.11.0...@patternfly/react-core@3.12.0) (2019-04-24)


### Features

* **clipboard:** remove textarea from clipboard copy ([#1840](https://github.com/patternfly/patternfly-react/issues/1840)) ([8bb26a2](https://github.com/patternfly/patternfly-react/commit/8bb26a2))
* **Skip To Content:** Added Skip To Content Component and Page breadcrumb styling ([#1686](https://github.com/patternfly/patternfly-react/issues/1686)) ([f6db50d](https://github.com/patternfly/patternfly-react/commit/f6db50d)), closes [#1733](https://github.com/patternfly/patternfly-react/issues/1733)





# [3.11.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.10.0...@patternfly/react-core@3.11.0) (2019-04-24)


### Features

* **BackgroundImage:** update background image component ([#1811](https://github.com/patternfly/patternfly-react/issues/1811)) ([baab0cf](https://github.com/patternfly/patternfly-react/commit/baab0cf))





# [3.10.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.9.0...@patternfly/react-core@3.10.0) (2019-04-24)


### Features

* **Tab:** Render Tab as <a> instead of <button> if it contains an href prop ([#1828](https://github.com/patternfly/patternfly-react/issues/1828)) ([716bf41](https://github.com/patternfly/patternfly-react/commit/716bf41)), closes [#1805](https://github.com/patternfly/patternfly-react/issues/1805)





# [3.9.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.8.1...@patternfly/react-core@3.9.0) (2019-04-24)


### Features

* **Wizard:** support for full width and full height ([#1786](https://github.com/patternfly/patternfly-react/issues/1786)) ([2ad0f55](https://github.com/patternfly/patternfly-react/commit/2ad0f55))





## [3.8.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.8.0...@patternfly/react-core@3.8.1) (2019-04-23)

**Note:** Version bump only for package @patternfly/react-core





# [3.8.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.7.3...@patternfly/react-core@3.8.0) (2019-04-23)


### Features

* **accordion:** Add accordion to pf ([#1511](https://github.com/patternfly/patternfly-react/issues/1511)) ([c02e683](https://github.com/patternfly/patternfly-react/commit/c02e683))





## [3.7.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.7.2...@patternfly/react-core@3.7.3) (2019-04-23)


### Bug Fixes

* **grid:** add missing props in d.ts ([#1749](https://github.com/patternfly/patternfly-react/issues/1749)) ([35815c2](https://github.com/patternfly/patternfly-react/commit/35815c2))





## [3.7.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.7.1...@patternfly/react-core@3.7.2) (2019-04-23)

**Note:** Version bump only for package @patternfly/react-core





## [3.7.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.7.0...@patternfly/react-core@3.7.1) (2019-04-23)

**Note:** Version bump only for package @patternfly/react-core





# [3.7.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.6.0...@patternfly/react-core@3.7.0) (2019-04-22)


### Features

* **padding:** add pagesection no padding props ([#1818](https://github.com/patternfly/patternfly-react/issues/1818)) ([a472953](https://github.com/patternfly/patternfly-react/commit/a472953))





# [3.6.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.5.0...@patternfly/react-core@3.6.0) (2019-04-22)


### Features

* **aboutmodal:** make productName optional ([#1797](https://github.com/patternfly/patternfly-react/issues/1797)) ([7384d26](https://github.com/patternfly/patternfly-react/commit/7384d26)), closes [#1714](https://github.com/patternfly/patternfly-react/issues/1714)





# [3.5.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.4.1...@patternfly/react-core@3.5.0) (2019-04-22)


### Bug Fixes

* **clipboardcopy:** fix docs ([#1821](https://github.com/patternfly/patternfly-react/issues/1821)) ([2caf8a5](https://github.com/patternfly/patternfly-react/commit/2caf8a5))


### Features

* **card:** adds card is-hoverable modifier prop ([#1812](https://github.com/patternfly/patternfly-react/issues/1812)) ([a398042](https://github.com/patternfly/patternfly-react/commit/a398042))
* **clipboardcopy:** add clipboardcopy to PF4 ([#1538](https://github.com/patternfly/patternfly-react/issues/1538)) ([6a5305e](https://github.com/patternfly/patternfly-react/commit/6a5305e))





## [3.4.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.4.0...@patternfly/react-core@3.4.1) (2019-04-18)


### Bug Fixes

* **login:** added login subtitle ([#1696](https://github.com/patternfly/patternfly-react/issues/1696)) ([4864eb6](https://github.com/patternfly/patternfly-react/commit/4864eb6))





# [3.4.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.3.0...@patternfly/react-core@3.4.0) (2019-04-18)


### Features

* **Chip:** add read-only chip, add single chip examples ([#1639](https://github.com/patternfly/patternfly-react/issues/1639)) ([a127563](https://github.com/patternfly/patternfly-react/commit/a127563))





# [3.3.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.2.8...@patternfly/react-core@3.3.0) (2019-04-18)


### Features

* **Expandable:** Add PF4 Expandable Component ([#1685](https://github.com/patternfly/patternfly-react/issues/1685)) ([26aad7e](https://github.com/patternfly/patternfly-react/commit/26aad7e)), closes [#1403](https://github.com/patternfly/patternfly-react/issues/1403)





## [3.2.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.2.7...@patternfly/react-core@3.2.8) (2019-04-18)

**Note:** Version bump only for package @patternfly/react-core





## [3.2.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.2.6...@patternfly/react-core@3.2.7) (2019-04-17)


### Bug Fixes

* **Modal:** Remove extra Bullseye from Modal ([#1799](https://github.com/patternfly/patternfly-react/issues/1799)) ([00bda05](https://github.com/patternfly/patternfly-react/commit/00bda05)), closes [#1722](https://github.com/patternfly/patternfly-react/issues/1722)





## [3.2.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.2.5...@patternfly/react-core@3.2.6) (2019-04-17)


### Bug Fixes

* **version:** force bump ([#1807](https://github.com/patternfly/patternfly-react/issues/1807)) ([9cccda3](https://github.com/patternfly/patternfly-react/commit/9cccda3))





## [3.2.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.2.4...@patternfly/react-core@3.2.5) (2019-04-17)


### Bug Fixes

* **readme:** version bump for last commit ([#1804](https://github.com/patternfly/patternfly-react/issues/1804)) ([b54c848](https://github.com/patternfly/patternfly-react/commit/b54c848))





## [3.2.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.2.3...@patternfly/react-core@3.2.4) (2019-04-17)


### Bug Fixes

* **react-core:** Fixes console error with perPageSuffix (Issue [#1784](https://github.com/patternfly/patternfly-react/issues/1784)) ([#1793](https://github.com/patternfly/patternfly-react/issues/1793)) ([bd67b22](https://github.com/patternfly/patternfly-react/commit/bd67b22))





## [3.2.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.2.2...@patternfly/react-core@3.2.3) (2019-04-17)


### Bug Fixes

* **Card:** change Header to be a div and not h1 ([#1789](https://github.com/patternfly/patternfly-react/issues/1789)) ([d69a34e](https://github.com/patternfly/patternfly-react/commit/d69a34e)), closes [#1783](https://github.com/patternfly/patternfly-react/issues/1783)
* **Tabs:** Move TabContent outside of Tabs div ([#1788](https://github.com/patternfly/patternfly-react/issues/1788)) ([15d948c](https://github.com/patternfly/patternfly-react/commit/15d948c)), closes [#1775](https://github.com/patternfly/patternfly-react/issues/1775) [#1779](https://github.com/patternfly/patternfly-react/issues/1779)





## [3.2.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.2.1...@patternfly/react-core@3.2.2) (2019-04-16)

**Note:** Version bump only for package @patternfly/react-core





## [3.2.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.2.0...@patternfly/react-core@3.2.1) (2019-04-16)

**Note:** Version bump only for package @patternfly/react-core





# [3.2.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.1.3...@patternfly/react-core@3.2.0) (2019-04-16)


### Bug Fixes

* **Nav:** fix onSelect and onToggle arg list types from positional params to obj ([#1665](https://github.com/patternfly/patternfly-react/issues/1665)) ([bba2e4f](https://github.com/patternfly/patternfly-react/commit/bba2e4f)), closes [#1391](https://github.com/patternfly/patternfly-react/issues/1391)


### Features

* **mdx:** use mdx for docs ([#1753](https://github.com/patternfly/patternfly-react/issues/1753)) ([a03ecd0](https://github.com/patternfly/patternfly-react/commit/a03ecd0))





## [3.1.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.1.2...@patternfly/react-core@3.1.3) (2019-04-15)

**Note:** Version bump only for package @patternfly/react-core





## 3.1.2 (2019-04-15)


### Bug Fixes

* Update React with changes from core ([#1703](https://github.com/patternfly/patternfly-react/issues/1703)) ([a219cae](https://github.com/patternfly/patternfly-react/commit/a219cae)), closes [#1680](https://github.com/patternfly/patternfly-react/issues/1680) [#1684](https://github.com/patternfly/patternfly-react/issues/1684) [#1684](https://github.com/patternfly/patternfly-react/issues/1684)
* **emptyState:** add small/large modifiers ([#1729](https://github.com/patternfly/patternfly-react/issues/1729)) ([4f97ba1](https://github.com/patternfly/patternfly-react/commit/4f97ba1))
* **select:** remove the custom override on width ([#1652](https://github.com/patternfly/patternfly-react/issues/1652)) ([e0f0309](https://github.com/patternfly/patternfly-react/commit/e0f0309))





## [3.0.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@3.0.0...@patternfly/react-core@3.0.1) (2019-04-15)

### BREAKING CHANGES

* Update React with changes from core ([#1703](https://github.com/patternfly/patternfly-react/issues/1703)) ([a219cae](https://github.com/patternfly/patternfly-react/commit/a219cae)), closes [#1680](https://github.com/patternfly/patternfly-react/issues/1680) [#1684](https://github.com/patternfly/patternfly-react/issues/1684) [#1684](https://github.com/patternfly/patternfly-react/issues/1684)
* **pagination:** remove size attr from type="number" input ([#1694](https://github.com/patternfly/patternfly-react/issues/1694)) ([7229b95](https://github.com/patternfly/patternfly-react/commit/7229b95))
* **css:** change css import methodology ([#1592](https://github.com/patternfly/patternfly-react/issues/1592)) ([80cd41a](https://github.com/patternfly/patternfly-react/commit/80cd41a))

### Bug Fixes

* **ChipGroup:** remove unused prop from d.ts file ([#1728](https://github.com/patternfly/patternfly-react/issues/1728)) ([74c430f](https://github.com/patternfly/patternfly-react/commit/74c430f)), closes [#1559](https://github.com/patternfly/patternfly-react/issues/1559)
* **emptyState:** add small/large modifiers ([#1729](https://github.com/patternfly/patternfly-react/issues/1729)) ([4f97ba1](https://github.com/patternfly/patternfly-react/commit/4f97ba1))


### Features

* **docs:** fix regression to hot reload core changes ([#1727](https://github.com/patternfly/patternfly-react/issues/1727)) ([67190ab](https://github.com/patternfly/patternfly-react/commit/67190ab))
* **gatsby:** Refactor Gatsby ([#1656](https://github.com/patternfly/patternfly-react/issues/1656)) ([bc32a25](https://github.com/patternfly/patternfly-react/commit/bc32a25))





## [2.11.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.11.0...@patternfly/react-core@2.11.1) (2019-04-02)


### Bug Fixes

* **Tabs:** Use TabsVariant.nav and fix a minor HTML issue ([#1690](https://github.com/patternfly/patternfly-react/issues/1690)) ([ae581fe](https://github.com/patternfly/patternfly-react/commit/ae581fe)), closes [#1689](https://github.com/patternfly/patternfly-react/issues/1689)





# [2.11.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.9...@patternfly/react-core@2.11.0) (2019-04-02)


### Features

* **Select:** add checkbox select variant ([#1487](https://github.com/patternfly/patternfly-react/issues/1487)) ([3b64c00](https://github.com/patternfly/patternfly-react/commit/3b64c00))





## [2.10.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.8...@patternfly/react-core@2.10.9) (2019-04-02)


### Features

* **Tabs:** Allow tabbing of content outside Tabs ([#1413](https://github.com/patternfly/patternfly-react/issues/1413)) ([b3c406f](https://github.com/patternfly/patternfly-react/commit/b3c406f)), closes [#1364](https://github.com/patternfly/patternfly-react/issues/1364) [#1364](https://github.com/patternfly/patternfly-react/issues/1364) [#1364](https://github.com/patternfly/patternfly-react/issues/1364) [#1364](https://github.com/patternfly/patternfly-react/issues/1364) [#1597](https://github.com/patternfly/patternfly-react/issues/1597) [#1268](https://github.com/patternfly/patternfly-react/issues/1268) [#1268](https://github.com/patternfly/patternfly-react/issues/1268) [#1597](https://github.com/patternfly/patternfly-react/issues/1597)


### BREAKING CHANGES

* **Tabs:** Use of React.forwardRef





## [2.10.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.7...@patternfly/react-core@2.10.8) (2019-04-02)


### Bug Fixes

* **pagination:** add "per page" suffix in options ([#1642](https://github.com/patternfly/patternfly-react/issues/1642)) ([a0ff240](https://github.com/patternfly/patternfly-react/commit/a0ff240))





## [2.10.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.6...@patternfly/react-core@2.10.7) (2019-04-01)


### Bug Fixes

* **misc:** small bug fixes ([#1660](https://github.com/patternfly/patternfly-react/issues/1660)) ([14e4cd3](https://github.com/patternfly/patternfly-react/commit/14e4cd3))





## [2.10.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.5...@patternfly/react-core@2.10.6) (2019-03-29)

**Note:** Version bump only for package @patternfly/react-core





## [2.10.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.4...@patternfly/react-core@2.10.5) (2019-03-29)


### Bug Fixes

* **tooltip:** trigger tooltip by mouse click or other events ([#1648](https://github.com/patternfly/patternfly-react/issues/1648)) ([acc1e3b](https://github.com/patternfly/patternfly-react/commit/acc1e3b))





## [2.10.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.3...@patternfly/react-core@2.10.4) (2019-03-28)


### Bug Fixes

* **util.ts:** Improve cross-browser compatibility of `isElementInView` and `sideElementIsOutOfView` ([#1625](https://github.com/patternfly/patternfly-react/issues/1625)) ([96d033c](https://github.com/patternfly/patternfly-react/commit/96d033c)), closes [#1451](https://github.com/patternfly/patternfly-react/issues/1451)





## [2.10.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.2...@patternfly/react-core@2.10.3) (2019-03-27)

**Note:** Version bump only for package @patternfly/react-core





## [2.10.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.1...@patternfly/react-core@2.10.2) (2019-03-27)

**Note:** Version bump only for package @patternfly/react-core





## [2.10.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.10.0...@patternfly/react-core@2.10.1) (2019-03-27)


### Bug Fixes

* **DataList:** set width and isExpanded to optional in d.ts ([#1627](https://github.com/patternfly/patternfly-react/issues/1627)) ([0aa174d](https://github.com/patternfly/patternfly-react/commit/0aa174d))





# [2.10.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.9.3...@patternfly/react-core@2.10.0) (2019-03-25)


### Bug Fixes

* **dropdown-toggle:** toggle props, allow null iconComponent ([#1638](https://github.com/patternfly/patternfly-react/issues/1638)) ([2ef2de6](https://github.com/patternfly/patternfly-react/commit/2ef2de6))


### Features

* **Table:** support inline editing in PF4 ([#1227](https://github.com/patternfly/patternfly-react/issues/1227)) ([b6eb553](https://github.com/patternfly/patternfly-react/commit/b6eb553))





## [2.9.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.9.2...@patternfly/react-core@2.9.3) (2019-03-25)

**Note:** Version bump only for package @patternfly/react-core





## [2.9.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.9.1...@patternfly/react-core@2.9.2) (2019-03-21)


### Bug Fixes

* **ts-fixes:** ts definition changes ([#1619](https://github.com/patternfly/patternfly-react/issues/1619)) ([11cc103](https://github.com/patternfly/patternfly-react/commit/11cc103))





## [2.9.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.9.0...@patternfly/react-core@2.9.1) (2019-03-21)

**Note:** Version bump only for package @patternfly/react-core





# [2.9.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.8.4...@patternfly/react-core@2.9.0) (2019-03-20)


### Features

* **ContextSelector:** Add PF4 ContextSelector Component ([#1526](https://github.com/patternfly/patternfly-react/issues/1526)) ([df745ea](https://github.com/patternfly/patternfly-react/commit/df745ea)), closes [#1294](https://github.com/patternfly/patternfly-react/issues/1294) [#1525](https://github.com/patternfly/patternfly-react/issues/1525)





## [2.8.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.8.3...@patternfly/react-core@2.8.4) (2019-03-20)


### Bug Fixes

* **DataList:** remove shadow-box ([#1613](https://github.com/patternfly/patternfly-react/issues/1613)) ([85e670f](https://github.com/patternfly/patternfly-react/commit/85e670f))





## [2.8.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.8.2...@patternfly/react-core@2.8.3) (2019-03-20)

**Note:** Version bump only for package @patternfly/react-core





## [2.8.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.8.1...@patternfly/react-core@2.8.2) (2019-03-19)

**Note:** Version bump only for package @patternfly/react-core





## [2.8.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.8.0...@patternfly/react-core@2.8.1) (2019-03-18)

**Note:** Version bump only for package @patternfly/react-core





# [2.8.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.7.0...@patternfly/react-core@2.8.0) (2019-03-18)


### Features

* **Switch:** Add icon and fix labels ([#1591](https://github.com/patternfly/patternfly-react/issues/1591)) ([3a86a66](https://github.com/patternfly/patternfly-react/commit/3a86a66)), closes [#1296](https://github.com/patternfly/patternfly-react/issues/1296)
* **umd:** add umd for styles, tokens, and icons ([#1599](https://github.com/patternfly/patternfly-react/issues/1599)) ([4ca1a5c](https://github.com/patternfly/patternfly-react/commit/4ca1a5c))





# [2.7.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.6.3...@patternfly/react-core@2.7.0) (2019-03-18)


### Features

* **core:** clean tsconfigs, add defaultProps to TS-docs ([#1570](https://github.com/patternfly/patternfly-react/issues/1570)) ([9df0f15](https://github.com/patternfly/patternfly-react/commit/9df0f15))





## [2.6.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.6.2...@patternfly/react-core@2.6.3) (2019-03-18)


### Bug Fixes

* **NavItem:** fix type definition ([#1585](https://github.com/patternfly/patternfly-react/issues/1585)) ([6e3a700](https://github.com/patternfly/patternfly-react/commit/6e3a700))





## [2.6.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.6.1...@patternfly/react-core@2.6.2) (2019-03-18)


### Bug Fixes

* **Dropdown:** fix d.ts file to make props optional ([#1593](https://github.com/patternfly/patternfly-react/issues/1593)) ([a2c6645](https://github.com/patternfly/patternfly-react/commit/a2c6645)), closes [#1584](https://github.com/patternfly/patternfly-react/issues/1584)





## [2.6.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.6.0...@patternfly/react-core@2.6.1) (2019-03-15)

**Note:** Version bump only for package @patternfly/react-core





# [2.6.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.5.8...@patternfly/react-core@2.6.0) (2019-03-15)


### Features

* **PF4:** Wizard ([#1539](https://github.com/patternfly/patternfly-react/issues/1539)) ([c668a33](https://github.com/patternfly/patternfly-react/commit/c668a33))





## [2.5.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.5.7...@patternfly/react-core@2.5.8) (2019-03-15)

**Note:** Version bump only for package @patternfly/react-core





## [2.5.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.5.6...@patternfly/react-core@2.5.7) (2019-03-14)


### Bug Fixes

* **DataList:** Add dropdown and button actions to DataList ([#1079](https://github.com/patternfly/patternfly-react/issues/1079)) ([7636381](https://github.com/patternfly/patternfly-react/commit/7636381))





## [2.5.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.5.5...@patternfly/react-core@2.5.6) (2019-03-14)


### Bug Fixes

* **Nav:** add onClick to the definition file ([#1576](https://github.com/patternfly/patternfly-react/issues/1576)) ([b7f0094](https://github.com/patternfly/patternfly-react/commit/b7f0094))





## [2.5.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.5.4...@patternfly/react-core@2.5.5) (2019-03-14)


### Bug Fixes

* **Chip, NavItem:** Fixed Typescript definition file errors ([#1560](https://github.com/patternfly/patternfly-react/issues/1560)) ([9ef332c](https://github.com/patternfly/patternfly-react/commit/9ef332c)), closes [#1559](https://github.com/patternfly/patternfly-react/issues/1559) [#1506](https://github.com/patternfly/patternfly-react/issues/1506)





## [2.5.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.5.3...@patternfly/react-core@2.5.4) (2019-03-13)


### Bug Fixes

* **Modal:** remove backdropOpen class from body when Modal is removed ([#1563](https://github.com/patternfly/patternfly-react/issues/1563)) ([23533af](https://github.com/patternfly/patternfly-react/commit/23533af)), closes [#1531](https://github.com/patternfly/patternfly-react/issues/1531)





## [2.5.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.5.2...@patternfly/react-core@2.5.3) (2019-03-13)

**Note:** Version bump only for package @patternfly/react-core





## [2.5.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.5.1...@patternfly/react-core@2.5.2) (2019-03-12)


### Bug Fixes

* PF4 Fix HelperText definition in LoginForm ([#1551](https://github.com/patternfly/patternfly-react/issues/1551)) ([b3bc152](https://github.com/patternfly/patternfly-react/commit/b3bc152))





## [2.5.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.5.0...@patternfly/react-core@2.5.1) (2019-03-11)


### Bug Fixes

* **Modal:** accessibility enhancements and other small fixes ([#1453](https://github.com/patternfly/patternfly-react/issues/1453)) ([da9a224](https://github.com/patternfly/patternfly-react/commit/da9a224))
* **tabs:** remove d.ts file from tabContent ([#1543](https://github.com/patternfly/patternfly-react/issues/1543)) ([d908f7a](https://github.com/patternfly/patternfly-react/commit/d908f7a))





# [2.5.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.4.1...@patternfly/react-core@2.5.0) (2019-03-11)


### Bug Fixes

* **tabs:** Move TabContent to its own component ([#1423](https://github.com/patternfly/patternfly-react/issues/1423)) ([a0dcdc3](https://github.com/patternfly/patternfly-react/commit/a0dcdc3))


### Features

* **Dropdown:** add support for disabled dropdown menus ([#1510](https://github.com/patternfly/patternfly-react/issues/1510)) ([ef12ef0](https://github.com/patternfly/patternfly-react/commit/ef12ef0))





## [2.4.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.4.0...@patternfly/react-core@2.4.1) (2019-03-11)


### Bug Fixes

* **tsconfig:** avatar tsx change ([#1535](https://github.com/patternfly/patternfly-react/issues/1535)) ([8107f5c](https://github.com/patternfly/patternfly-react/commit/8107f5c))





# [2.4.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.3.7...@patternfly/react-core@2.4.0) (2019-03-08)


### Bug Fixes

* **core:** fix pagination tests ([#1530](https://github.com/patternfly/patternfly-react/issues/1530)) ([1116f32](https://github.com/patternfly/patternfly-react/commit/1116f32))


### Features

* **Pagination:** Introduce new PF4 pagination component ([#1297](https://github.com/patternfly/patternfly-react/issues/1297)) ([4778a28](https://github.com/patternfly/patternfly-react/commit/4778a28))





## [2.3.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.3.6...@patternfly/react-core@2.3.7) (2019-03-08)


### Bug Fixes

* **typeUtils:** export typeUtils and move them to helpers ([#1521](https://github.com/patternfly/patternfly-react/issues/1521)) ([886082d](https://github.com/patternfly/patternfly-react/commit/886082d))





## [2.3.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.3.5...@patternfly/react-core@2.3.6) (2019-03-06)

**Note:** Version bump only for package @patternfly/react-core





## [2.3.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.3.4...@patternfly/react-core@2.3.5) (2019-03-06)


### Bug Fixes

* **datalistitem:** add validity check before cloning children ([#1512](https://github.com/patternfly/patternfly-react/issues/1512)) ([05cc2a2](https://github.com/patternfly/patternfly-react/commit/05cc2a2))





## [2.3.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.3.3...@patternfly/react-core@2.3.4) (2019-03-05)


### Bug Fixes

* **iconOnly:** Add conditional for icon only styles ([#1505](https://github.com/patternfly/patternfly-react/issues/1505)) ([abdbcb1](https://github.com/patternfly/patternfly-react/commit/abdbcb1))
* **nav:** fix React warning with onExpand prop ([#1504](https://github.com/patternfly/patternfly-react/issues/1504)) ([a879274](https://github.com/patternfly/patternfly-react/commit/a879274))





## [2.3.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.3.2...@patternfly/react-core@2.3.3) (2019-03-05)


### Bug Fixes

* **navExpand:** remove defaultExpand in favor of just using isExpanded ([#1490](https://github.com/patternfly/patternfly-react/issues/1490)) ([9aafabd](https://github.com/patternfly/patternfly-react/commit/9aafabd))





## [2.3.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.3.1...@patternfly/react-core@2.3.2) (2019-03-05)

**Note:** Version bump only for package @patternfly/react-core





## [2.3.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.3.0...@patternfly/react-core@2.3.1) (2019-03-04)


### Bug Fixes

* **inputgroup:** fix typescript and examples ([#1489](https://github.com/patternfly/patternfly-react/issues/1489)) ([59c29a5](https://github.com/patternfly/patternfly-react/commit/59c29a5))





# [2.3.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.11...@patternfly/react-core@2.3.0) (2019-03-04)


### Bug Fixes

* **nav:** Fix bug where previous was expanding on select ([#1479](https://github.com/patternfly/patternfly-react/issues/1479)) ([f0863a0](https://github.com/patternfly/patternfly-react/commit/f0863a0))


### Features

* **InputGroup:** Add InputGroup to PF4 ([#1108](https://github.com/patternfly/patternfly-react/issues/1108)) ([807ca69](https://github.com/patternfly/patternfly-react/commit/807ca69))





## [2.2.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.10...@patternfly/react-core@2.2.11) (2019-02-28)


### Bug Fixes

* **Select:** fix typescript def for SelectProps and SelectOptionProps ([#1470](https://github.com/patternfly/patternfly-react/issues/1470)) ([56e6340](https://github.com/patternfly/patternfly-react/commit/56e6340))





## [2.2.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.9...@patternfly/react-core@2.2.10) (2019-02-28)


### Bug Fixes

* **DataList:** Add aria-label and aria-labelledby improvements ([#1347](https://github.com/patternfly/patternfly-react/issues/1347)) ([4aa38fe](https://github.com/patternfly/patternfly-react/commit/4aa38fe)), closes [#1163](https://github.com/patternfly/patternfly-react/issues/1163) [#1163](https://github.com/patternfly/patternfly-react/issues/1163) [#1163](https://github.com/patternfly/patternfly-react/issues/1163)





## [2.2.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.8...@patternfly/react-core@2.2.9) (2019-02-25)

**Note:** Version bump only for package @patternfly/react-core





## [2.2.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.7...@patternfly/react-core@2.2.8) (2019-02-25)


### Bug Fixes

* **modalbox:** add the small modifier to modalbox ([#1372](https://github.com/patternfly/patternfly-react/issues/1372)) ([ca131f3](https://github.com/patternfly/patternfly-react/commit/ca131f3))





## [2.2.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.5...@patternfly/react-core@2.2.7) (2019-02-21)

**Note:** Version bump only for package @patternfly/react-core





## [2.2.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.4...@patternfly/react-core@2.2.5) (2019-02-20)

**Note:** Version bump only for package @patternfly/react-core





## [2.2.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.3...@patternfly/react-core@2.2.4) (2019-02-20)

**Note:** Version bump only for package @patternfly/react-core





## [2.2.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.2...@patternfly/react-core@2.2.3) (2019-02-20)


### Bug Fixes

* **lint:** fix linting glob and auto-fixable linter errors  ([#1256](https://github.com/patternfly/patternfly-react/issues/1256)) ([#1409](https://github.com/patternfly/patternfly-react/issues/1409)) ([0b637fe](https://github.com/patternfly/patternfly-react/commit/0b637fe))





## [2.2.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.1...@patternfly/react-core@2.2.2) (2019-02-19)

**Note:** Version bump only for package @patternfly/react-core





## [2.2.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.2.0...@patternfly/react-core@2.2.1) (2019-02-19)


### Bug Fixes

* **login:** Add union types for backgroundImgSrc ([#1373](https://github.com/patternfly/patternfly-react/issues/1373)) ([79b4f20](https://github.com/patternfly/patternfly-react/commit/79b4f20))





# [2.2.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.1.8...@patternfly/react-core@2.2.0) (2019-02-18)


### Bug Fixes

* additional boolean check in Grid layout ([#1404](https://github.com/patternfly/patternfly-react/issues/1404)) ([eecc4cf](https://github.com/patternfly/patternfly-react/commit/eecc4cf))


### Features

* **Progress:** add single line progress handling and example ([#1335](https://github.com/patternfly/patternfly-react/issues/1335)) ([592ffdb](https://github.com/patternfly/patternfly-react/commit/592ffdb))





## [2.1.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.1.7...@patternfly/react-core@2.1.8) (2019-02-15)

**Note:** Version bump only for package @patternfly/react-core





## [2.1.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.1.6...@patternfly/react-core@2.1.7) (2019-02-14)

**Note:** Version bump only for package @patternfly/react-core





## [2.1.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.1.5...@patternfly/react-core@2.1.6) (2019-02-13)

**Note:** Version bump only for package @patternfly/react-core





## [2.1.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.1.4...@patternfly/react-core@2.1.5) (2019-02-13)


### Bug Fixes

* **core:** FormSelect onChange value type was missing ([#1380](https://github.com/patternfly/patternfly-react/issues/1380)) ([d275105](https://github.com/patternfly/patternfly-react/commit/d275105))





## [2.1.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.1.3...@patternfly/react-core@2.1.4) (2019-02-12)

**Note:** Version bump only for package @patternfly/react-core





## [2.1.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.1.2...@patternfly/react-core@2.1.3) (2019-02-12)

**Note:** Version bump only for package @patternfly/react-core





## [2.1.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.1.1...@patternfly/react-core@2.1.2) (2019-02-11)


### Bug Fixes

* **LoginPage:** Remove Language Selector from LoginPage ([#1279](https://github.com/patternfly/patternfly-react/issues/1279)) ([c6e90ba](https://github.com/patternfly/patternfly-react/commit/c6e90ba)), closes [#1243](https://github.com/patternfly/patternfly-react/issues/1243)





## [2.1.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.1.0...@patternfly/react-core@2.1.1) (2019-02-11)


### Bug Fixes

* **Login:** update component to match pf4 design changes ([#1319](https://github.com/patternfly/patternfly-react/issues/1319)) ([c85ee8c](https://github.com/patternfly/patternfly-react/commit/c85ee8c))





# [2.1.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.0.1...@patternfly/react-core@2.1.0) (2019-02-11)


### Features

* **chipGroup:** Add Chip Group component to pf4 ([#1245](https://github.com/patternfly/patternfly-react/issues/1245)) ([d3f2cc9](https://github.com/patternfly/patternfly-react/commit/d3f2cc9))





## [2.0.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@2.0.0...@patternfly/react-core@2.0.1) (2019-02-08)


### Bug Fixes

* **readme:** modify readme content for react-core release ([#1358](https://github.com/patternfly/patternfly-react/issues/1358)) ([e0a0dab](https://github.com/patternfly/patternfly-react/commit/e0a0dab))





# [2.0.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.51.6...@patternfly/react-core@2.0.0) (2019-02-08)


### Bug Fixes

* **Alert:** Fix index.d.ts file ([#1320](https://github.com/patternfly/patternfly-react/issues/1320)) ([b69d45d](https://github.com/patternfly/patternfly-react/commit/b69d45d)), closes [#1318](https://github.com/patternfly/patternfly-react/issues/1318)
* **Alert:** Make Alert consistent with core ([#1298](https://github.com/patternfly/patternfly-react/issues/1298)) ([cba507e](https://github.com/patternfly/patternfly-react/commit/cba507e)), closes [#1286](https://github.com/patternfly/patternfly-react/issues/1286)
* **Alert:** Make Alert title required ([#1326](https://github.com/patternfly/patternfly-react/issues/1326)) ([942ca78](https://github.com/patternfly/patternfly-react/commit/942ca78))
* **nav:** Allow nav to expand by prop change ([#1345](https://github.com/patternfly/patternfly-react/issues/1345)) ([07097bc](https://github.com/patternfly/patternfly-react/commit/07097bc))
* **Nav:** do not render the examples page ([#1316](https://github.com/patternfly/patternfly-react/issues/1316)) ([18dbd65](https://github.com/patternfly/patternfly-react/commit/18dbd65))
* **PF4:** tooltip/popover - include tippy css ([#1244](https://github.com/patternfly/patternfly-react/issues/1244)) ([469477a](https://github.com/patternfly/patternfly-react/commit/469477a))
* Add consistent aria labels for <nav> elements ([#1252](https://github.com/patternfly/patternfly-react/issues/1252)) ([fd87668](https://github.com/patternfly/patternfly-react/commit/fd87668)), closes [#1182](https://github.com/patternfly/patternfly-react/issues/1182)
* **Radio:** Use pf-c-radio class in Radio ([#1328](https://github.com/patternfly/patternfly-react/issues/1328)) ([869d4bd](https://github.com/patternfly/patternfly-react/commit/869d4bd))
* **tests:** update alert tests ([#1353](https://github.com/patternfly/patternfly-react/issues/1353)) ([9071f40](https://github.com/patternfly/patternfly-react/commit/9071f40))
* **types:** popover, tooltip, and helper types fixes ([#1341](https://github.com/patternfly/patternfly-react/issues/1341)) ([40c9b26](https://github.com/patternfly/patternfly-react/commit/40c9b26))
* **utils:** export common utility functions and constants in react-core ([#1232](https://github.com/patternfly/patternfly-react/issues/1232)) ([dc657b9](https://github.com/patternfly/patternfly-react/commit/dc657b9))


### Code Refactoring

* **AboutModal:** Upgrade core to 1.0.175 and Refactor AboutModal ([#1307](https://github.com/patternfly/patternfly-react/issues/1307)) ([1f85756](https://github.com/patternfly/patternfly-react/commit/1f85756)), closes [#1267](https://github.com/patternfly/patternfly-react/issues/1267)


### Features

* **Tooltip:** Add optional delay prop to Tooltip ([#1205](https://github.com/patternfly/patternfly-react/issues/1205)) ([0c5e910](https://github.com/patternfly/patternfly-react/commit/0c5e910)), closes [#1161](https://github.com/patternfly/patternfly-react/issues/1161)


### BREAKING CHANGES

* **AboutModal:** removed heroImg and heroImageSrc and heroImageAlt props





## [1.51.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.51.5...@patternfly/react-core@1.51.6) (2019-02-01)

**Note:** Version bump only for package @patternfly/react-core





## [1.51.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.51.4...@patternfly/react-core@1.51.5) (2019-02-01)

**Note:** Version bump only for package @patternfly/react-core





## [1.51.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.51.3...@patternfly/react-core@1.51.4) (2019-01-30)


### Bug Fixes

* **AboutModal:** Use paragraph in heading ([#1280](https://github.com/patternfly/patternfly-react/issues/1280)) ([15b4b98](https://github.com/patternfly/patternfly-react/commit/15b4b98))





## [1.51.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.51.2...@patternfly/react-core@1.51.3) (2019-01-29)


### Bug Fixes

* **Checkbox:** Adjustments to examples ([#1270](https://github.com/patternfly/patternfly-react/issues/1270)) ([ceb632b](https://github.com/patternfly/patternfly-react/commit/ceb632b)), closes [#1006](https://github.com/patternfly/patternfly-react/issues/1006)
* **Radio:** Modify examples and aria-label/label ([#1269](https://github.com/patternfly/patternfly-react/issues/1269)) ([168dcaf](https://github.com/patternfly/patternfly-react/commit/168dcaf)), closes [#1007](https://github.com/patternfly/patternfly-react/issues/1007)





## [1.51.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.51.1...@patternfly/react-core@1.51.2) (2019-01-29)

**Note:** Version bump only for package @patternfly/react-core





## [1.51.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.51.0...@patternfly/react-core@1.51.1) (2019-01-29)

**Note:** Version bump only for package @patternfly/react-core





# [1.51.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.50.1...@patternfly/react-core@1.51.0) (2019-01-29)


### Bug Fixes

* **Chip:** Replace check for length of chip text with refs/overflow values ([#1262](https://github.com/patternfly/patternfly-react/issues/1262)) ([57fb44f](https://github.com/patternfly/patternfly-react/commit/57fb44f)), closes [#1197](https://github.com/patternfly/patternfly-react/issues/1197)


### Features

* **FormSelect:** rename Select components to FormSelect ([#1231](https://github.com/patternfly/patternfly-react/issues/1231)) ([df32933](https://github.com/patternfly/patternfly-react/commit/df32933))





## [1.50.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.50.0...@patternfly/react-core@1.50.1) (2019-01-29)


### Bug Fixes

* **Page:** improve a11y in sidebar and header ([#1145](https://github.com/patternfly/patternfly-react/issues/1145)) ([274d7f7](https://github.com/patternfly/patternfly-react/commit/274d7f7))





# [1.50.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.49.6...@patternfly/react-core@1.50.0) (2019-01-28)


### Features

* **Form:** add novalidate flag to form ([#1253](https://github.com/patternfly/patternfly-react/issues/1253)) ([5e54437](https://github.com/patternfly/patternfly-react/commit/5e54437))





## [1.49.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.49.5...@patternfly/react-core@1.49.6) (2019-01-25)


### Bug Fixes

* **ts:** nav ts props ([#1242](https://github.com/patternfly/patternfly-react/issues/1242)) ([67207d8](https://github.com/patternfly/patternfly-react/commit/67207d8))





## [1.49.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.49.4...@patternfly/react-core@1.49.5) (2019-01-24)

**Note:** Version bump only for package @patternfly/react-core





## [1.49.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.49.3...@patternfly/react-core@1.49.4) (2019-01-21)


### Bug Fixes

* **Dropdown:** Do not focus Dropdown if menu is not opened ([#1222](https://github.com/patternfly/patternfly-react/issues/1222)) ([45367bc](https://github.com/patternfly/patternfly-react/commit/45367bc))





## [1.49.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.49.2...@patternfly/react-core@1.49.3) (2019-01-18)


### Bug Fixes

* **DropdownMenu:** Fixes dropdown menu when using items as children. ([#1219](https://github.com/patternfly/patternfly-react/issues/1219)) ([279a595](https://github.com/patternfly/patternfly-react/commit/279a595))





## [1.49.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.49.1...@patternfly/react-core@1.49.2) (2019-01-18)

**Note:** Version bump only for package @patternfly/react-core





## [1.49.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.49.0...@patternfly/react-core@1.49.1) (2019-01-17)


### Bug Fixes

* **Dropdown:** add onclick fix to custom items ([#1211](https://github.com/patternfly/patternfly-react/issues/1211)) ([bbdf4cc](https://github.com/patternfly/patternfly-react/commit/bbdf4cc))
* **Form:** Update From Based in Audit ([#1185](https://github.com/patternfly/patternfly-react/issues/1185)) ([a42ab72](https://github.com/patternfly/patternfly-react/commit/a42ab72)), closes [#1026](https://github.com/patternfly/patternfly-react/issues/1026)





# [1.49.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.48.0...@patternfly/react-core@1.49.0) (2019-01-17)


### Features

* **Alert:** Add optional Close button to Alert via onClose prop ([#1200](https://github.com/patternfly/patternfly-react/issues/1200)) ([9d59dcb](https://github.com/patternfly/patternfly-react/commit/9d59dcb)), closes [#1036](https://github.com/patternfly/patternfly-react/issues/1036)





# [1.48.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.47.0...@patternfly/react-core@1.48.0) (2019-01-16)


### Bug Fixes

* **Dropdown:** Pass down ref for dropdown item ([#1193](https://github.com/patternfly/patternfly-react/issues/1193)) ([29e536f](https://github.com/patternfly/patternfly-react/commit/29e536f))
* **Dropdown:** pass onClick to any dropdown item if present ([#1203](https://github.com/patternfly/patternfly-react/issues/1203)) ([f4a92ee](https://github.com/patternfly/patternfly-react/commit/f4a92ee))


### Features

* **Dropdown:** handle keyboard navigation and styling for Link children ([#1201](https://github.com/patternfly/patternfly-react/issues/1201)) ([0996cfd](https://github.com/patternfly/patternfly-react/commit/0996cfd))





<a name="1.47.0"></a>
# [1.47.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.46.0...@patternfly/react-core@1.47.0) (2019-01-15)


### Features

* **Chip:** Add the Chip component to PF4 ([#1180](https://github.com/patternfly/patternfly-react/issues/1180)) ([752adae](https://github.com/patternfly/patternfly-react/commit/752adae))




<a name="1.46.0"></a>
# [1.46.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.45.4...@patternfly/react-core@1.46.0) (2019-01-15)


### Features

* **umd modules:** adds babel-transform-es2015-modules-umd for umd module support ([#1150](https://github.com/patternfly/patternfly-react/issues/1150)) ([7b4fde8](https://github.com/patternfly/patternfly-react/commit/7b4fde8))




<a name="1.45.4"></a>
## [1.45.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.45.3...@patternfly/react-core@1.45.4) (2019-01-14)


### Bug Fixes

* **Button:** make aria-label optional prop ([#1186](https://github.com/patternfly/patternfly-react/issues/1186)) ([0f7fef5](https://github.com/patternfly/patternfly-react/commit/0f7fef5)), closes [#1184](https://github.com/patternfly/patternfly-react/issues/1184)




<a name="1.45.3"></a>
## [1.45.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.45.2...@patternfly/react-core@1.45.3) (2019-01-14)


### Bug Fixes

* PF4: Add missing attribute isPlain to Dropdown ([#1173](https://github.com/patternfly/patternfly-react/issues/1173)) ([72210f5](https://github.com/patternfly/patternfly-react/commit/72210f5))




<a name="1.45.2"></a>
## [1.45.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.45.0...@patternfly/react-core@1.45.2) (2019-01-11)


### Bug Fixes

* **dropdown:** add span wrapper for dropdown toggle text ([#1169](https://github.com/patternfly/patternfly-react/issues/1169)) ([9381f04](https://github.com/patternfly/patternfly-react/commit/9381f04))
* **ModalContent:** Hide footer when no actions ([#1167](https://github.com/patternfly/patternfly-react/issues/1167)) ([a58a262](https://github.com/patternfly/patternfly-react/commit/a58a262)), closes [#1107](https://github.com/patternfly/patternfly-react/issues/1107)




<a name="1.45.1"></a>
## [1.45.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.45.0...@patternfly/react-core@1.45.1) (2019-01-11)


### Bug Fixes

* **dropdown:** add span wrapper for dropdown toggle text ([#1169](https://github.com/patternfly/patternfly-react/issues/1169)) ([9381f04](https://github.com/patternfly/patternfly-react/commit/9381f04))
* **ModalContent:** Hide footer when no actions ([#1167](https://github.com/patternfly/patternfly-react/issues/1167)) ([a58a262](https://github.com/patternfly/patternfly-react/commit/a58a262)), closes [#1107](https://github.com/patternfly/patternfly-react/issues/1107)




<a name="1.45.0"></a>
# [1.45.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.11...@patternfly/react-core@1.45.0) (2019-01-11)


### Features

* **Nav:** add separator flag ([#1165](https://github.com/patternfly/patternfly-react/issues/1165)) ([a2ee4e3](https://github.com/patternfly/patternfly-react/commit/a2ee4e3))




<a name="1.44.11"></a>
## [1.44.11](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.10...@patternfly/react-core@1.44.11) (2019-01-11)


### Bug Fixes

* **DropdownToggle:** Listen for touch events on the document to close a Toggle on mobile ([#1152](https://github.com/patternfly/patternfly-react/issues/1152)) ([a7f3c89](https://github.com/patternfly/patternfly-react/commit/a7f3c89)), closes [#1131](https://github.com/patternfly/patternfly-react/issues/1131)




<a name="1.44.10"></a>
## [1.44.10](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.9...@patternfly/react-core@1.44.10) (2019-01-10)


### Bug Fixes

* **docs:** fix workspace previews ([#1159](https://github.com/patternfly/patternfly-react/issues/1159)) ([9598b75](https://github.com/patternfly/patternfly-react/commit/9598b75))




<a name="1.44.9"></a>
## [1.44.9](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.8...@patternfly/react-core@1.44.9) (2019-01-10)


### Bug Fixes

* **Dropdown typings:** fix the DropdownItem typings  ([#1155](https://github.com/patternfly/patternfly-react/issues/1155)) ([9613232](https://github.com/patternfly/patternfly-react/commit/9613232))




<a name="1.44.8"></a>
## [1.44.8](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.7...@patternfly/react-core@1.44.8) (2019-01-10)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.44.7"></a>
## [1.44.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.6...@patternfly/react-core@1.44.7) (2019-01-09)


### Bug Fixes

* **Dropdown:** set default button type to button ([#1148](https://github.com/patternfly/patternfly-react/issues/1148)) ([b4bded3](https://github.com/patternfly/patternfly-react/commit/b4bded3))




<a name="1.44.6"></a>
## [1.44.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.5...@patternfly/react-core@1.44.6) (2019-01-08)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.44.5"></a>
## [1.44.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.4...@patternfly/react-core@1.44.5) (2019-01-08)


### Bug Fixes

* **EmptyState:** Use IconProps to define EmptyStateIconProps ([#1137](https://github.com/patternfly/patternfly-react/issues/1137)) ([ccf4240](https://github.com/patternfly/patternfly-react/commit/ccf4240))




<a name="1.44.4"></a>
## [1.44.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.3...@patternfly/react-core@1.44.4) (2019-01-08)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.44.3"></a>
## [1.44.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.2...@patternfly/react-core@1.44.3) (2019-01-07)


### Bug Fixes

* **Avatar:** Correctly export Avatar component typings ([#1135](https://github.com/patternfly/patternfly-react/issues/1135)) ([3a05852](https://github.com/patternfly/patternfly-react/commit/3a05852))




<a name="1.44.2"></a>
## [1.44.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.1...@patternfly/react-core@1.44.2) (2019-01-04)


### Bug Fixes

* **dropdown:** add focus trap option that allows  close on click ([#1126](https://github.com/patternfly/patternfly-react/issues/1126)) ([2878615](https://github.com/patternfly/patternfly-react/commit/2878615))




<a name="1.44.1"></a>
## [1.44.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.44.0...@patternfly/react-core@1.44.1) (2019-01-04)


### Bug Fixes

* **Radio.d.ts:** Made aria-label required ([#1116](https://github.com/patternfly/patternfly-react/issues/1116)) ([0c01314](https://github.com/patternfly/patternfly-react/commit/0c01314))




<a name="1.44.0"></a>
# [1.44.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.43.7...@patternfly/react-core@1.44.0) (2019-01-04)


### Bug Fixes

* **TextInput/Area:** update type definitions ([#1120](https://github.com/patternfly/patternfly-react/issues/1120)) ([0306a08](https://github.com/patternfly/patternfly-react/commit/0306a08))


### Features

* **tooltip:** add tooltip to PF4 ([#1103](https://github.com/patternfly/patternfly-react/issues/1103)) ([c9aa254](https://github.com/patternfly/patternfly-react/commit/c9aa254))




<a name="1.43.7"></a>
## [1.43.7](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.43.6...@patternfly/react-core@1.43.7) (2019-01-03)


### Bug Fixes

* **BackgroundImage:** remove old tokens ([#1124](https://github.com/patternfly/patternfly-react/issues/1124)) ([f091e28](https://github.com/patternfly/patternfly-react/commit/f091e28))




<a name="1.43.6"></a>
## [1.43.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.43.5...@patternfly/react-core@1.43.6) (2019-01-02)


### Bug Fixes

* **Form:** fix type definitions ([#1112](https://github.com/patternfly/patternfly-react/issues/1112)) ([47c4de0](https://github.com/patternfly/patternfly-react/commit/47c4de0))




<a name="1.43.5"></a>
## [1.43.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.43.4...@patternfly/react-core@1.43.5) (2018-12-20)


### Bug Fixes

* **ts:** fix for popover ts ([#1106](https://github.com/patternfly/patternfly-react/issues/1106)) ([7ea696f](https://github.com/patternfly/patternfly-react/commit/7ea696f))




<a name="1.43.4"></a>
## [1.43.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.43.3...@patternfly/react-core@1.43.4) (2018-12-20)


### Bug Fixes

* **EmptyState:** a typo at the import path in EmptyStateIcon.d.ts ([#1099](https://github.com/patternfly/patternfly-react/issues/1099)) ([187171d](https://github.com/patternfly/patternfly-react/commit/187171d))




<a name="1.43.3"></a>
## [1.43.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.43.2...@patternfly/react-core@1.43.3) (2018-12-20)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.43.2"></a>
## [1.43.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.43.1...@patternfly/react-core@1.43.2) (2018-12-19)


### Bug Fixes

* **DropdownItem:** wrap DropdownItem in div when child is a Link node ([#991](https://github.com/patternfly/patternfly-react/issues/991)) ([584fd28](https://github.com/patternfly/patternfly-react/commit/584fd28))




<a name="1.43.1"></a>
## [1.43.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.43.0...@patternfly/react-core@1.43.1) (2018-12-19)


### Bug Fixes

* **modal:** rename reactRoot to srHide and add to ts file ([#1098](https://github.com/patternfly/patternfly-react/issues/1098)) ([1d0a941](https://github.com/patternfly/patternfly-react/commit/1d0a941))




<a name="1.43.0"></a>
# [1.43.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.42.0...@patternfly/react-core@1.43.0) (2018-12-19)


### Features

* **core:** Popover positioning ([#1032](https://github.com/patternfly/patternfly-react/issues/1032)) ([13430ef](https://github.com/patternfly/patternfly-react/commit/13430ef))




<a name="1.42.0"></a>
# [1.42.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.40.4...@patternfly/react-core@1.42.0) (2018-12-19)


### Bug Fixes

* **LoginForm:** LoginForm.d.ts fix typo passwordValue ([#1063](https://github.com/patternfly/patternfly-react/issues/1063)) ([0bbe428](https://github.com/patternfly/patternfly-react/commit/0bbe428)), closes [#1062](https://github.com/patternfly/patternfly-react/issues/1062)


### Features

* **Alert:** add sr variant customization ([#1056](https://github.com/patternfly/patternfly-react/issues/1056)) ([0b8d241](https://github.com/patternfly/patternfly-react/commit/0b8d241))




<a name="1.41.0"></a>
# [1.41.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.40.4...@patternfly/react-core@1.41.0) (2018-12-19)


### Bug Fixes

* **LoginForm:** LoginForm.d.ts fix typo passwordValue ([#1063](https://github.com/patternfly/patternfly-react/issues/1063)) ([0bbe428](https://github.com/patternfly/patternfly-react/commit/0bbe428)), closes [#1062](https://github.com/patternfly/patternfly-react/issues/1062)


### Features

* **Alert:** add sr variant customization ([#1056](https://github.com/patternfly/patternfly-react/issues/1056)) ([0b8d241](https://github.com/patternfly/patternfly-react/commit/0b8d241))




<a name="1.40.4"></a>
## [1.40.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.40.3...@patternfly/react-core@1.40.4) (2018-12-19)


### Bug Fixes

* PF4 About Modal: make trademark, logoImageSrc and logoImageAlt p… ([#1082](https://github.com/patternfly/patternfly-react/issues/1082)) ([dbc8b06](https://github.com/patternfly/patternfly-react/commit/dbc8b06))




<a name="1.40.3"></a>
## [1.40.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.40.2...@patternfly/react-core@1.40.3) (2018-12-19)


### Bug Fixes

* **page:** move page from layouts to components ([#1089](https://github.com/patternfly/patternfly-react/issues/1089)) ([4c3e6af](https://github.com/patternfly/patternfly-react/commit/4c3e6af))
* update alt text in LoginPage ([#1084](https://github.com/patternfly/patternfly-react/issues/1084)) ([2665351](https://github.com/patternfly/patternfly-react/commit/2665351))




<a name="1.40.2"></a>
## [1.40.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.40.1...@patternfly/react-core@1.40.2) (2018-12-19)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.40.0"></a>
# [1.40.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.39.1...@patternfly/react-core@1.40.0) (2018-12-11)


### Features

* **EmptyState:** Add Empty State to PF-4 ([#995](https://github.com/patternfly/patternfly-react/issues/995)) ([04bbb1d](https://github.com/patternfly/patternfly-react/commit/04bbb1d))




<a name="1.39.1"></a>
## [1.39.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.39.0...@patternfly/react-core@1.39.1) (2018-12-10)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.39.0"></a>
# [1.39.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.38.6...@patternfly/react-core@1.39.0) (2018-12-07)


### Features

* **DataList:** Add simple data list ([#927](https://github.com/patternfly/patternfly-react/issues/927)) ([cd25279](https://github.com/patternfly/patternfly-react/commit/cd25279))




<a name="1.38.6"></a>
## [1.38.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.38.5...@patternfly/react-core@1.38.6) (2018-12-07)


### Bug Fixes

* **Button:** remove margin around Buttons in docs ([#1015](https://github.com/patternfly/patternfly-react/issues/1015)) ([4ba4af6](https://github.com/patternfly/patternfly-react/commit/4ba4af6))
* **title:** allow multiple heading levels for Title ([#1005](https://github.com/patternfly/patternfly-react/issues/1005)) ([0eae3d1](https://github.com/patternfly/patternfly-react/commit/0eae3d1))




<a name="1.38.5"></a>
## [1.38.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.38.4...@patternfly/react-core@1.38.5) (2018-12-05)


### Bug Fixes

* **Badge:** remove margin between badges to match core ([#1001](https://github.com/patternfly/patternfly-react/issues/1001)) ([62ece9b](https://github.com/patternfly/patternfly-react/commit/62ece9b))




<a name="1.38.4"></a>
## [1.38.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.38.3...@patternfly/react-core@1.38.4) (2018-11-30)


### Bug Fixes

* **LoginPage:** typos ([#988](https://github.com/patternfly/patternfly-react/issues/988)) ([fb61a15](https://github.com/patternfly/patternfly-react/commit/fb61a15))




<a name="1.38.3"></a>
## [1.38.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.38.2...@patternfly/react-core@1.38.3) (2018-11-30)


### Bug Fixes

* **a11y:** tweak html for better accessibility ([#917](https://github.com/patternfly/patternfly-react/issues/917)) ([c1af473](https://github.com/patternfly/patternfly-react/commit/c1af473))




<a name="1.38.2"></a>
## [1.38.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.38.1...@patternfly/react-core@1.38.2) (2018-11-30)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.38.1"></a>
## [1.38.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.38.0...@patternfly/react-core@1.38.1) (2018-11-28)


### Bug Fixes

* **Dropdown:** Apply `pf-m-plain` modifier to dropdown toggle element instead of wrapper ([#954](https://github.com/patternfly/patternfly-react/issues/954)) ([4e3afdb](https://github.com/patternfly/patternfly-react/commit/4e3afdb))




<a name="1.38.0"></a>
# [1.38.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.37.3...@patternfly/react-core@1.38.0) (2018-11-28)


### Features

* **Progress:** use max parameter to scale value of progress bar ([#950](https://github.com/patternfly/patternfly-react/issues/950)) ([52a6b6d](https://github.com/patternfly/patternfly-react/commit/52a6b6d))




<a name="1.37.3"></a>
## [1.37.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.37.2...@patternfly/react-core@1.37.3) (2018-11-28)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.37.2"></a>
## [1.37.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.37.0...@patternfly/react-core@1.37.2) (2018-11-27)


### Bug Fixes

* **pagelayoutdemo:** Fix several issues in the PF4 pagelayoutdemo ([#969](https://github.com/patternfly/patternfly-react/issues/969)) ([6bcef8b](https://github.com/patternfly/patternfly-react/commit/6bcef8b))
* **Radio:** Updated Radio aria-label prop so that it is optional ([#930](https://github.com/patternfly/patternfly-react/issues/930)) ([a3e74fa](https://github.com/patternfly/patternfly-react/commit/a3e74fa)), closes [#803](https://github.com/patternfly/patternfly-react/issues/803)




<a name="1.37.1"></a>
## [1.37.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.37.0...@patternfly/react-core@1.37.1) (2018-11-27)


### Bug Fixes

* **pagelayoutdemo:** Fix several issues in the PF4 pagelayoutdemo ([#969](https://github.com/patternfly/patternfly-react/issues/969)) ([6bcef8b](https://github.com/patternfly/patternfly-react/commit/6bcef8b))




<a name="1.37.0"></a>
# [1.37.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.36.0...@patternfly/react-core@1.37.0) (2018-11-27)


### Features

* **breadcrumb:** adds breadcrumb, breadcrumbItem components ([#872](https://github.com/patternfly/patternfly-react/issues/872)) ([bcd2954](https://github.com/patternfly/patternfly-react/commit/bcd2954)), closes [#856](https://github.com/patternfly/patternfly-react/issues/856)
* **Popover:** Add PF4 Popover ([#754](https://github.com/patternfly/patternfly-react/issues/754)) ([17cf0c0](https://github.com/patternfly/patternfly-react/commit/17cf0c0))




<a name="1.36.0"></a>
# [1.36.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.35.2...@patternfly/react-core@1.36.0) (2018-11-20)


### Features

* **PF4 Page:** Allow passing of custom ref for condensed header ([#941](https://github.com/patternfly/patternfly-react/issues/941)) ([889ec1a](https://github.com/patternfly/patternfly-react/commit/889ec1a))




<a name="1.35.2"></a>
## [1.35.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.35.1...@patternfly/react-core@1.35.2) (2018-11-20)


### Bug Fixes

* **dropdown:** address typescript issue with toggle prop ([#935](https://github.com/patternfly/patternfly-react/issues/935)) ([8341297](https://github.com/patternfly/patternfly-react/commit/8341297))




<a name="1.35.1"></a>
## [1.35.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.35.0...@patternfly/react-core@1.35.1) (2018-11-16)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.35.0"></a>
# [1.35.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.34.1...@patternfly/react-core@1.35.0) (2018-11-15)


### Features

* **component:** introduce the pf4 switch component ([#761](https://github.com/patternfly/patternfly-react/issues/761)) ([ef13fd2](https://github.com/patternfly/patternfly-react/commit/ef13fd2))




<a name="1.34.1"></a>
## [1.34.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.34.0...@patternfly/react-core@1.34.1) (2018-11-14)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.34.0"></a>
# [1.34.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.32.2...@patternfly/react-core@1.34.0) (2018-11-13)


### Bug Fixes

* **PF4 AboutModal and Modal:** added a class to the body when the Mod… ([#895](https://github.com/patternfly/patternfly-react/issues/895)) ([5b12b97](https://github.com/patternfly/patternfly-react/commit/5b12b97)), closes [#724](https://github.com/patternfly/patternfly-react/issues/724)


### Features

* **LoginForm:** Added the PF4 LoginForm Component    ([#874](https://github.com/patternfly/patternfly-react/issues/874)) ([befeb77](https://github.com/patternfly/patternfly-react/commit/befeb77)), closes [#825](https://github.com/patternfly/patternfly-react/issues/825) [#825](https://github.com/patternfly/patternfly-react/issues/825)




<a name="1.33.0"></a>
# [1.33.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.32.2...@patternfly/react-core@1.33.0) (2018-11-13)


### Bug Fixes

* **PF4 AboutModal and Modal:** added a class to the body when the Mod… ([#895](https://github.com/patternfly/patternfly-react/issues/895)) ([5b12b97](https://github.com/patternfly/patternfly-react/commit/5b12b97)), closes [#724](https://github.com/patternfly/patternfly-react/issues/724)


### Features

* **LoginForm:** Added the PF4 LoginForm Component    ([#874](https://github.com/patternfly/patternfly-react/issues/874)) ([befeb77](https://github.com/patternfly/patternfly-react/commit/befeb77)), closes [#825](https://github.com/patternfly/patternfly-react/issues/825) [#825](https://github.com/patternfly/patternfly-react/issues/825)




<a name="1.32.2"></a>
## [1.32.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.32.1...@patternfly/react-core@1.32.2) (2018-11-08)


### Bug Fixes

* **layout:** fix layout tsd ([#901](https://github.com/patternfly/patternfly-react/issues/901)) ([13547c5](https://github.com/patternfly/patternfly-react/commit/13547c5))




<a name="1.32.1"></a>
## [1.32.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.32.0...@patternfly/react-core@1.32.1) (2018-11-08)


### Bug Fixes

* **dropdown props:** fix typescript typings ([#900](https://github.com/patternfly/patternfly-react/issues/900)) ([e1ae1bd](https://github.com/patternfly/patternfly-react/commit/e1ae1bd))




<a name="1.32.0"></a>
# [1.32.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.31.2...@patternfly/react-core@1.32.0) (2018-11-08)


### Features

* **DropdownToggle - noCaret option:** Adds the noCaret option ([#893](https://github.com/patternfly/patternfly-react/issues/893)) ([21e6e64](https://github.com/patternfly/patternfly-react/commit/21e6e64))




<a name="1.31.2"></a>
## [1.31.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.31.1...@patternfly/react-core@1.31.2) (2018-11-07)


### Bug Fixes

* **dropdown:** Address typescript errors ([#898](https://github.com/patternfly/patternfly-react/issues/898)) ([48a3256](https://github.com/patternfly/patternfly-react/commit/48a3256))




<a name="1.31.1"></a>
## [1.31.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.31.0...@patternfly/react-core@1.31.1) (2018-11-07)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.31.0"></a>
# [1.31.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.30.3...@patternfly/react-core@1.31.0) (2018-11-06)


### Features

* **LoginPage:** introduce the login page component ([#863](https://github.com/patternfly/patternfly-react/issues/863)) ([c1435d9](https://github.com/patternfly/patternfly-react/commit/c1435d9))




<a name="1.30.3"></a>
## [1.30.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.30.2...@patternfly/react-core@1.30.3) (2018-11-06)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.30.2"></a>
## [1.30.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.30.1...@patternfly/react-core@1.30.2) (2018-11-05)


### Bug Fixes

* **overlay:** add anchor tag to filter overlay ([#883](https://github.com/patternfly/patternfly-react/issues/883)) ([80e54df](https://github.com/patternfly/patternfly-react/commit/80e54df))




<a name="1.30.1"></a>
## [1.30.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.30.0...@patternfly/react-core@1.30.1) (2018-11-05)


### Bug Fixes

* **typescript:** Export LoginBox and make PageSection props optional ([#880](https://github.com/patternfly/patternfly-react/issues/880)) ([082bb8d](https://github.com/patternfly/patternfly-react/commit/082bb8d))




<a name="1.30.0"></a>
# [1.30.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.29.1...@patternfly/react-core@1.30.0) (2018-11-02)


### Features

* **condensed horizontal nav:** updates condensed nav to match Core horizontal & vertical nav ([#876](https://github.com/patternfly/patternfly-react/issues/876)) ([760cc7b](https://github.com/patternfly/patternfly-react/commit/760cc7b))




<a name="1.29.1"></a>
## [1.29.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.29.0...@patternfly/react-core@1.29.1) (2018-11-01)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.29.0"></a>
# [1.29.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.28.4...@patternfly/react-core@1.29.0) (2018-10-30)


### Features

* **Label:** add Label to PF4 ([#859](https://github.com/patternfly/patternfly-react/issues/859)) ([e1c16d2](https://github.com/patternfly/patternfly-react/commit/e1c16d2))




<a name="1.28.4"></a>
## [1.28.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.28.3...@patternfly/react-core@1.28.4) (2018-10-30)


### Bug Fixes

* **Progress:** import progress style object ([#858](https://github.com/patternfly/patternfly-react/issues/858)) ([7a90c3b](https://github.com/patternfly/patternfly-react/commit/7a90c3b))




<a name="1.28.3"></a>
## [1.28.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.28.2...@patternfly/react-core@1.28.3) (2018-10-30)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.28.2"></a>
## [1.28.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.28.1...@patternfly/react-core@1.28.2) (2018-10-30)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.28.1"></a>
## [1.28.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.28.0...@patternfly/react-core@1.28.1) (2018-10-29)


### Bug Fixes

* **patternfly-4/react-core:** Make the id prop for Dropdown optional in d.ts file ([#841](https://github.com/patternfly/patternfly-react/issues/841)) ([3bac80e](https://github.com/patternfly/patternfly-react/commit/3bac80e)), closes [#840](https://github.com/patternfly/patternfly-react/issues/840)




<a name="1.28.0"></a>
# [1.28.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.27.6...@patternfly/react-core@1.28.0) (2018-10-26)


### Features

* **page layout:** adds the condensed header feature to the page header ([#843](https://github.com/patternfly/patternfly-react/issues/843)) ([0a3591a](https://github.com/patternfly/patternfly-react/commit/0a3591a))




<a name="1.27.6"></a>
## [1.27.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.27.5...@patternfly/react-core@1.27.6) (2018-10-26)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.27.5"></a>
## [1.27.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.27.4...@patternfly/react-core@1.27.5) (2018-10-26)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.27.4"></a>
## [1.27.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.27.3...@patternfly/react-core@1.27.4) (2018-10-26)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.27.3"></a>
## [1.27.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.27.2...@patternfly/react-core@1.27.3) (2018-10-26)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.27.2"></a>
## [1.27.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.27.1...@patternfly/react-core@1.27.2) (2018-10-26)


### Bug Fixes

* **Select/TextInput:** fix components typescript interfaces ([#833](https://github.com/patternfly/patternfly-react/issues/833)) ([4011d86](https://github.com/patternfly/patternfly-react/commit/4011d86))




<a name="1.27.1"></a>
## [1.27.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.27.0...@patternfly/react-core@1.27.1) (2018-10-25)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.27.0"></a>
# [1.27.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.26.1...@patternfly/react-core@1.27.0) (2018-10-24)


### Features

* **Labeled progress:** allow consumers to pass additional label for progressbar ([#822](https://github.com/patternfly/patternfly-react/issues/822)) ([b8ce0c9](https://github.com/patternfly/patternfly-react/commit/b8ce0c9))




<a name="1.26.1"></a>
## [1.26.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.26.0...@patternfly/react-core@1.26.1) (2018-10-24)


### Bug Fixes

* **formComponent:** removes Children props checking ([#823](https://github.com/patternfly/patternfly-react/issues/823)) ([4ef696b](https://github.com/patternfly/patternfly-react/commit/4ef696b))




<a name="1.26.0"></a>
# [1.26.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.25.6...@patternfly/react-core@1.26.0) (2018-10-24)


### Features

* **PF4-Dropdown:** Enhance keyboard interaction for a11y ([#815](https://github.com/patternfly/patternfly-react/issues/815)) ([cc89db6](https://github.com/patternfly/patternfly-react/commit/cc89db6)), closes [#557](https://github.com/patternfly/patternfly-react/issues/557)




<a name="1.25.6"></a>
## [1.25.6](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.25.5...@patternfly/react-core@1.25.6) (2018-10-18)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.25.5"></a>
## [1.25.5](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.25.3...@patternfly/react-core@1.25.5) (2018-10-18)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.25.4"></a>
## [1.25.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.25.3...@patternfly/react-core@1.25.4) (2018-10-18)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.25.3"></a>
## [1.25.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.25.2...@patternfly/react-core@1.25.3) (2018-10-18)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.25.2"></a>
## [1.25.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.25.1...@patternfly/react-core@1.25.2) (2018-10-18)


### Bug Fixes

* **ts-definitions:** fix type definitions for radio ([#806](https://github.com/patternfly/patternfly-react/issues/806)) ([66ce547](https://github.com/patternfly/patternfly-react/commit/66ce547))




<a name="1.25.1"></a>
## [1.25.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.25.0...@patternfly/react-core@1.25.1) (2018-10-18)


### Bug Fixes

* **Form:** Do not add any class if action modifier is missing ([#792](https://github.com/patternfly/patternfly-react/issues/792)) ([dee29d4](https://github.com/patternfly/patternfly-react/commit/dee29d4))
* **typescript definitions:** fix ts defs for checkbox, BackgroundImage, and Form ([#800](https://github.com/patternfly/patternfly-react/issues/800)) ([d39f596](https://github.com/patternfly/patternfly-react/commit/d39f596))




<a name="1.25.0"></a>
# [1.25.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.24.3...@patternfly/react-core@1.25.0) (2018-10-17)


### Features

* **radioComponent:** updated according to PF-next demo ([#756](https://github.com/patternfly/patternfly-react/issues/756)) ([a62ee27](https://github.com/patternfly/patternfly-react/commit/a62ee27))




<a name="1.24.3"></a>
## [1.24.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.24.2...@patternfly/react-core@1.24.3) (2018-10-17)


### Bug Fixes

* **react-core:** add missing component to index type definitions ([#798](https://github.com/patternfly/patternfly-react/issues/798)) ([46a2c69](https://github.com/patternfly/patternfly-react/commit/46a2c69))




<a name="1.24.2"></a>
## [1.24.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.24.1...@patternfly/react-core@1.24.2) (2018-10-17)


### Bug Fixes

* **Form components style modifiers:** Style modifiers ([#797](https://github.com/patternfly/patternfly-react/issues/797)) ([b5bc87e](https://github.com/patternfly/patternfly-react/commit/b5bc87e))




<a name="1.24.1"></a>
## [1.24.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.24.0...@patternfly/react-core@1.24.1) (2018-10-16)


### Bug Fixes

* **Progress:** Correct small progress size ([#790](https://github.com/patternfly/patternfly-react/issues/790)) ([c30c89f](https://github.com/patternfly/patternfly-react/commit/c30c89f))




<a name="1.24.0"></a>
# [1.24.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.23.1...@patternfly/react-core@1.24.0) (2018-10-16)


### Features

* **formComponent:** add Form, FormGroup, ActionGroup PF4 components ([#667](https://github.com/patternfly/patternfly-react/issues/667)) ([c38779c](https://github.com/patternfly/patternfly-react/commit/c38779c)), closes [#390](https://github.com/patternfly/patternfly-react/issues/390)




<a name="1.23.1"></a>
## [1.23.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.23.0...@patternfly/react-core@1.23.1) (2018-10-16)


### Bug Fixes

* **Progress:** missing ProgressSize added to exported types ([#785](https://github.com/patternfly/patternfly-react/issues/785)) ([37f43fc](https://github.com/patternfly/patternfly-react/commit/37f43fc)), closes [#782](https://github.com/patternfly/patternfly-react/issues/782)




<a name="1.23.0"></a>
# [1.23.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.22.0...@patternfly/react-core@1.23.0) (2018-10-13)


### Features

* **checkboxComponent:** updated checkbox PF4 component according to demo ([#717](https://github.com/patternfly/patternfly-react/issues/717)) ([de120e3](https://github.com/patternfly/patternfly-react/commit/de120e3))




<a name="1.22.0"></a>
# [1.22.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.21.4...@patternfly/react-core@1.22.0) (2018-10-12)


### Features

* **page layout demos:** Add PF4 page layout demos ([#749](https://github.com/patternfly/patternfly-react/issues/749)) ([025d862](https://github.com/patternfly/patternfly-react/commit/025d862))




<a name="1.21.4"></a>
## [1.21.4](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.21.3...@patternfly/react-core@1.21.4) (2018-10-12)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.21.3"></a>
## [1.21.3](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.21.2...@patternfly/react-core@1.21.3) (2018-10-11)


### Bug Fixes

* **BackgroundImage:** removed children from props ([#748](https://github.com/patternfly/patternfly-react/issues/748)) ([bd32a9b](https://github.com/patternfly/patternfly-react/commit/bd32a9b))




<a name="1.21.2"></a>
## [1.21.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.21.1...@patternfly/react-core@1.21.2) (2018-10-11)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.21.1"></a>
## [1.21.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.21.0...@patternfly/react-core@1.21.1) (2018-10-11)


### Bug Fixes

* **background image:** fix variable map for background image so when tokens are missing do not assig ([#744](https://github.com/patternfly/patternfly-react/issues/744)) ([44edab1](https://github.com/patternfly/patternfly-react/commit/44edab1))




<a name="1.21.0"></a>
# [1.21.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.20.0...@patternfly/react-core@1.21.0) (2018-10-11)


### Features

* **text component:** adds the text component to PF4 ([#733](https://github.com/patternfly/patternfly-react/issues/733)) ([a02495e](https://github.com/patternfly/patternfly-react/commit/a02495e))




<a name="1.20.0"></a>
# [1.20.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.19.2...@patternfly/react-core@1.20.0) (2018-10-11)


### Features

* **LoginBox:** introduce the pf4 loginbox component ([#737](https://github.com/patternfly/patternfly-react/issues/737)) ([2508215](https://github.com/patternfly/patternfly-react/commit/2508215))




<a name="1.19.2"></a>
## [1.19.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.19.1...@patternfly/react-core@1.19.2) (2018-10-11)


### Bug Fixes

* **doc:** list full steps required to start pf4 dev environment ([#732](https://github.com/patternfly/patternfly-react/issues/732)) ([02d6082](https://github.com/patternfly/patternfly-react/commit/02d6082))




<a name="1.19.1"></a>
## [1.19.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.19.0...@patternfly/react-core@1.19.1) (2018-10-09)


### Bug Fixes

* **Alert:** [TS] action type is string while it should've been node ([#727](https://github.com/patternfly/patternfly-react/issues/727)) ([f325d03](https://github.com/patternfly/patternfly-react/commit/f325d03))




<a name="1.19.0"></a>
# [1.19.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.18.2...@patternfly/react-core@1.19.0) (2018-10-09)


### Features

* **Page layout:** Adds the page layout to PF4 ([#714](https://github.com/patternfly/patternfly-react/issues/714)) ([c8a3324](https://github.com/patternfly/patternfly-react/commit/c8a3324)), closes [#548](https://github.com/patternfly/patternfly-react/issues/548)




<a name="1.18.2"></a>
## [1.18.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.18.1...@patternfly/react-core@1.18.2) (2018-10-09)


### Bug Fixes

* **backgroundImage:** example to override css image paths ([3890d59](https://github.com/patternfly/patternfly-react/commit/3890d59))




<a name="1.18.1"></a>
## [1.18.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.18.0...@patternfly/react-core@1.18.1) (2018-10-08)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.18.0"></a>
# [1.18.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.17.2...@patternfly/react-core@1.18.0) (2018-10-08)


### Bug Fixes

* **@patternfly/react-core:** Update the snapshot for progress bar component ([#722](https://github.com/patternfly/patternfly-react/issues/722)) ([b555243](https://github.com/patternfly/patternfly-react/commit/b555243))
* **Alert:** Use the correct css class name for screen readers ([#713](https://github.com/patternfly/patternfly-react/issues/713)) ([9c313d2](https://github.com/patternfly/patternfly-react/commit/9c313d2)), closes [#601](https://github.com/patternfly/patternfly-react/issues/601)


### Features

* **patternfly-react/patternfly-4/react-core/:** added PF4 AboutModal Component ([#671](https://github.com/patternfly/patternfly-react/issues/671)) ([1b01037](https://github.com/patternfly/patternfly-react/commit/1b01037)), closes [#482](https://github.com/patternfly/patternfly-react/issues/482)
* **pf4-progress:** introduce new component progress with it's variants ([#648](https://github.com/patternfly/patternfly-react/issues/648)) ([e9d9492](https://github.com/patternfly/patternfly-react/commit/e9d9492)), closes [#588](https://github.com/patternfly/patternfly-react/issues/588)




<a name="1.17.2"></a>
## [1.17.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.17.1...@patternfly/react-core@1.17.2) (2018-10-05)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.17.1"></a>
## [1.17.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.17.0...@patternfly/react-core@1.17.1) (2018-10-05)




**Note:** Version bump only for package @patternfly/react-core

<a name="1.17.0"></a>
# [1.17.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.16.2...@patternfly/react-core@1.17.0) (2018-10-05)


### Features

* **pf-icons:** add all PF icons and update font awesome pckg ([#654](https://github.com/patternfly/patternfly-react/issues/654)) ([bdc00c4](https://github.com/patternfly/patternfly-react/commit/bdc00c4)), closes [#730](https://github.com/patternfly/patternfly-react/issues/730)




<a name="1.16.2"></a>
## [1.16.2](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.16.1...@patternfly/react-core@1.16.2) (2018-10-03)


### Bug Fixes

* **patternfly-4/react-core:** add missing comments to component props ([#695](https://github.com/patternfly/patternfly-react/issues/695)) ([ce282c8](https://github.com/patternfly/patternfly-react/commit/ce282c8)), closes [#538](https://github.com/patternfly/patternfly-react/issues/538)




<a name="1.16.1"></a>
## [1.16.1](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.16.0...@patternfly/react-core@1.16.1) (2018-10-03)


### Bug Fixes

* **pf-4:** checkboxProps to be consistent with Checkbox.propTypes ([#696](https://github.com/patternfly/patternfly-react/issues/696)) ([c690b3e](https://github.com/patternfly/patternfly-react/commit/c690b3e))




<a name="1.16.0"></a>
# [1.16.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.15.0...@patternfly/react-core@1.16.0) (2018-10-03)


### Features

* **pf-next update:** Update location of styles for patternfly next ([#697](https://github.com/patternfly/patternfly-react/issues/697)) ([f1ebc54](https://github.com/patternfly/patternfly-react/commit/f1ebc54))




<a name="1.15.0"></a>
# [1.15.0](https://github.com/patternfly/patternfly-react/compare/@patternfly/react-core@1.14.0...@patternfly/react-core@1.15.0) (2018-10-02)


### Features

* **backgroundImage:** introduce background image component ([#683](https://github.com/patternfly/patternfly-react/issues/683)) ([ec5ec1f](https://github.com/patternfly/patternfly-react/commit/ec5ec1f))
* **pf4-nav:** add nav component ([#626](https://github.com/patternfly/patternfly-react/issues/626)) ([677587c](https://github.com/patternfly/patternfly-react/commit/677587c)), closes [#547](https://github.com/patternfly/patternfly-react/issues/547)
