; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt %s -S -simplifycfg -simplifycfg-require-and-preserve-domtree=1 | FileCheck %s
; Check for when one branch implies the value of a successors conditional and
; it's not simply the same conditional repeated.

define void @test(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add nsw i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp slt i32 [[IPLUS1]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    br i1 [[VAR29]], label [[IN_BOUNDS:%.*]], label [[OUT_OF_BOUNDS:%.*]]
; CHECK:       in_bounds:
; CHECK-NEXT:    ret void
; CHECK:       out_of_bounds:
; CHECK-NEXT:    call void @foo(i64 0)
; CHECK-NEXT:    unreachable
;
  %iplus1 = add nsw i32 %i, 1
  %var29 = icmp slt i32 %iplus1, %length.i
  br i1 %var29, label %next, label %out_of_bounds

next:
  %var30 = icmp slt i32 %i, %length.i
  br i1 %var30, label %in_bounds, label %out_of_bounds2

in_bounds:
  ret void

out_of_bounds:
  call void @foo(i64 0)
  unreachable

out_of_bounds2:
  call void @foo(i64 1)
  unreachable
}

; If the add is not nsw, it's not safe to use the fact about i+1 to imply the
; i condition since it could have overflowed.
define void @test_neg(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_neg(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp slt i32 [[IPLUS1]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    br i1 [[VAR29]], label [[NEXT:%.*]], label [[OUT_OF_BOUNDS:%.*]]
; CHECK:       next:
; CHECK-NEXT:    [[VAR30:%.*]] = icmp slt i32 [[I]], [[LENGTH_I]]
; CHECK-NEXT:    br i1 [[VAR30]], label [[IN_BOUNDS:%.*]], label [[OUT_OF_BOUNDS2:%.*]]
; CHECK:       in_bounds:
; CHECK-NEXT:    ret void
; CHECK:       out_of_bounds:
; CHECK-NEXT:    call void @foo(i64 0)
; CHECK-NEXT:    unreachable
; CHECK:       out_of_bounds2:
; CHECK-NEXT:    call void @foo(i64 1)
; CHECK-NEXT:    unreachable
;
  %iplus1 = add i32 %i, 1
  %var29 = icmp slt i32 %iplus1, %length.i
  br i1 %var29, label %next, label %out_of_bounds

next:
  %var30 = icmp slt i32 %i, %length.i
  br i1 %var30, label %in_bounds, label %out_of_bounds2

in_bounds:
  ret void

out_of_bounds:
  call void @foo(i64 0)
  unreachable

out_of_bounds2:
  call void @foo(i64 1)
  unreachable
}


define void @test2(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[IPLUS100:%.*]] = add nsw i32 [[I:%.*]], 100
; CHECK-NEXT:    [[VAR29:%.*]] = icmp slt i32 [[IPLUS100]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    br i1 [[VAR29]], label [[IN_BOUNDS:%.*]], label [[OUT_OF_BOUNDS:%.*]]
; CHECK:       in_bounds:
; CHECK-NEXT:    ret void
; CHECK:       out_of_bounds:
; CHECK-NEXT:    call void @foo(i64 0)
; CHECK-NEXT:    unreachable
;
  %iplus100 = add nsw i32 %i, 100
  %var29 = icmp slt i32 %iplus100, %length.i
  br i1 %var29, label %next, label %out_of_bounds

next:
  %var30 = icmp slt i32 %i, %length.i
  br i1 %var30, label %in_bounds, label %out_of_bounds2

in_bounds:
  ret void

out_of_bounds:
  call void @foo(i64 0)
  unreachable

out_of_bounds2:
  call void @foo(i64 1)
  unreachable
}

declare void @foo(i64)

